 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file FHS_lower_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _FHS_LOWER_REGMASKS_H_
#define _FHS_LOWER_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Fractional Horizontal Scale (FHS_lower)
/** \brief (rev 0 . 2 . 2 . 0)<p>
    Register descriptions for the Fractional Horizontal Scale (FHS) block.<p>
    FHS programming is simple, writing only a handful of registers.
    Minimally writing only the input and output image width registers followed by a write to the control register is required, namely: inImageWidth, outImageWidth and control, respectively.
    FHS will apply the correct scale factor to get the desired output.
    The write only control register is read via the read only status register.<br><br>
    Optional for decimation, the High and Low Threshold registers are used to determine if each pixel is significantly light or dark using all three color values. If a pixel is due to be decimated, both it and its neighbor pixel thresholds are checked and if any of the four are met a maximum per color merge function outputs that information into the neighboring pixel to retain as much color as possible. On reset Threshold registers are by shut off with default High values of 0xFF and default Low values of 0x00.
    When using the Threshold registers, the control register's Threshold-Max-not-Min should be programmed to match the color space CMY or RGB, 1'b1 or 1'b0, respectively.
    Also for decimation, if a threshold is not met, the control register's Merge Method dictates whether the decimation pixel color information is used, and if so how, i.e., average, minimum, or maximum.<p>
    FHS will handle three known error conditions:<br>
    1. Bad initialization of the inImageWidth with a value less than two.<br>
    2. Incorrect inImageWidth with respect to the actual data width, smaller value.<br>
    3. Incorrect inImageWidth with respect to the actual data width, larger value.<br>
    Error case 1 is evaluated on the write of the control register, and results in a forced bypass of the scale function.<br>
    Error cases 2 and 3 are determined algorithmically when expected end-of-line/image comes at the wrong time, and result in the FHS either consuming data or generating data to match the outImageWidth.
    For development, control register bit stallOnError may be set which will stall the pipe for error cases 2 and 3 stopping all data flow.
    Interrupts for the error conditions may be enabled in the int_en register, and acknowledged via int_ack register.
    Interrupt pending bits in register int_pend are set for errors regardless of whether or not interrupts are enabled.
    NOTE: The reset value is only valid on system reset or power-up, a soft reset from a higher level block will not affect the registers, as per design guidelines.*/
//
//====================================================================

//====================================================================
//Register: Input Image Pixel Width Register (inImageWidth)
/** \brief Contains the count of the input image pixels in the horizontal direction.*/
//====================================================================

#define  FHS_LOWER_INIMAGEWIDTH_RESERVED1_MASK 0xffff0000
#define  FHS_LOWER_INIMAGEWIDTH_RESERVED1_SHIFT 16
#define  FHS_LOWER_INIMAGEWIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INIMAGEWIDTH_RESERVED1_MASK) >> FHS_LOWER_INIMAGEWIDTH_RESERVED1_SHIFT)
#define  FHS_LOWER_INIMAGEWIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INIMAGEWIDTH_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_INIMAGEWIDTH_RESERVED1_SHIFT))

#define  FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_MASK 0xffff
#define  FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_SHIFT 0
#define  FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_MASK) >> FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_SHIFT)
#define  FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_MASK) | (((uint32_t)val) << FHS_LOWER_INIMAGEWIDTH_INPUTCOUNT_SHIFT))

//====================================================================
//Register: Output Image Pixel Width Register (outImageWidth)
/** \brief Contains the count of the output image pixels in the horizontal direction.*/
//====================================================================

#define  FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_MASK 0xffff0000
#define  FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_SHIFT 16
#define  FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_MASK) >> FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_SHIFT)
#define  FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_OUTIMAGEWIDTH_RESERVED1_SHIFT))

#define  FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_MASK 0xffff
#define  FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_SHIFT 0
#define  FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_MASK) >> FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_SHIFT)
#define  FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_MASK) | (((uint32_t)val) << FHS_LOWER_OUTIMAGEWIDTH_OUTPUTCOUNT_SHIFT))

//====================================================================
//Register: Control Register (control)
/** \brief Control register of the Fractional Horizontal Scale (FHS) block is write only.
      This register MUST be written after writing the values in the inImageWidth or outImageWidth registers even if the values don't change.*/
//====================================================================

#define  FHS_LOWER_CONTROL_BYPASS_MASK 0x80000000
#define  FHS_LOWER_CONTROL_BYPASS_SHIFT 31
#define  FHS_LOWER_CONTROL_BYPASS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_BYPASS_MASK) >> FHS_LOWER_CONTROL_BYPASS_SHIFT)
#define  FHS_LOWER_CONTROL_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_BYPASS_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_BYPASS_SHIFT))

#define  FHS_LOWER_CONTROL_RESERVED1_MASK 0x7e000000
#define  FHS_LOWER_CONTROL_RESERVED1_SHIFT 25
#define  FHS_LOWER_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_RESERVED1_MASK) >> FHS_LOWER_CONTROL_RESERVED1_SHIFT)
#define  FHS_LOWER_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_RESERVED1_SHIFT))

#define  FHS_LOWER_CONTROL_STALLONERROR_MASK 0x1000000
#define  FHS_LOWER_CONTROL_STALLONERROR_SHIFT 24
#define  FHS_LOWER_CONTROL_STALLONERROR_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_STALLONERROR_MASK) >> FHS_LOWER_CONTROL_STALLONERROR_SHIFT)
#define  FHS_LOWER_CONTROL_STALLONERROR_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_STALLONERROR_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_STALLONERROR_SHIFT))

#define  FHS_LOWER_CONTROL_CENTERSCALING_MASK 0x800000
#define  FHS_LOWER_CONTROL_CENTERSCALING_SHIFT 23
#define  FHS_LOWER_CONTROL_CENTERSCALING_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_CENTERSCALING_MASK) >> FHS_LOWER_CONTROL_CENTERSCALING_SHIFT)
#define  FHS_LOWER_CONTROL_CENTERSCALING_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_CENTERSCALING_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_CENTERSCALING_SHIFT))

#define  FHS_LOWER_CONTROL_RESERVED2_MASK 0x7fff00
#define  FHS_LOWER_CONTROL_RESERVED2_SHIFT 8
#define  FHS_LOWER_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_RESERVED2_MASK) >> FHS_LOWER_CONTROL_RESERVED2_SHIFT)
#define  FHS_LOWER_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_RESERVED2_SHIFT))

#define  FHS_LOWER_CONTROL_MERGEMETHOD_MASK 0xc0
#define  FHS_LOWER_CONTROL_MERGEMETHOD_SHIFT 6
#define  FHS_LOWER_CONTROL_MERGEMETHOD_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_MERGEMETHOD_MASK) >> FHS_LOWER_CONTROL_MERGEMETHOD_SHIFT)
#define  FHS_LOWER_CONTROL_MERGEMETHOD_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_MERGEMETHOD_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_MERGEMETHOD_SHIFT))

#define  FHS_LOWER_CONTROL_RESERVED3_MASK 0x20
#define  FHS_LOWER_CONTROL_RESERVED3_SHIFT 5
#define  FHS_LOWER_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_RESERVED3_MASK) >> FHS_LOWER_CONTROL_RESERVED3_SHIFT)
#define  FHS_LOWER_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_RESERVED3_SHIFT))

#define  FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_MASK 0x10
#define  FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_SHIFT 4
#define  FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_MASK) >> FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_SHIFT)
#define  FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_THRESHMERGEMAXNMIN_SHIFT))

#define  FHS_LOWER_CONTROL_RESERVED4_MASK 0xf
#define  FHS_LOWER_CONTROL_RESERVED4_SHIFT 0
#define  FHS_LOWER_CONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & FHS_LOWER_CONTROL_RESERVED4_MASK) >> FHS_LOWER_CONTROL_RESERVED4_SHIFT)
#define  FHS_LOWER_CONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_CONTROL_RESERVED4_MASK) | (((uint32_t)val) << FHS_LOWER_CONTROL_RESERVED4_SHIFT))

//====================================================================
//Register: Status Register (status)
/** \brief Read only status of the Fractional Horizontal Scale (FHS) block.*/
//====================================================================

#define  FHS_LOWER_STATUS_BYPASS_MASK 0x80000000
#define  FHS_LOWER_STATUS_BYPASS_SHIFT 31
#define  FHS_LOWER_STATUS_BYPASS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_BYPASS_MASK) >> FHS_LOWER_STATUS_BYPASS_SHIFT)
#define  FHS_LOWER_STATUS_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_BYPASS_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_BYPASS_SHIFT))

#define  FHS_LOWER_STATUS_RESERVED1_MASK 0x7e000000
#define  FHS_LOWER_STATUS_RESERVED1_SHIFT 25
#define  FHS_LOWER_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_RESERVED1_MASK) >> FHS_LOWER_STATUS_RESERVED1_SHIFT)
#define  FHS_LOWER_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_RESERVED1_SHIFT))

#define  FHS_LOWER_STATUS_STALLONERROR_MASK 0x1000000
#define  FHS_LOWER_STATUS_STALLONERROR_SHIFT 24
#define  FHS_LOWER_STATUS_STALLONERROR_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_STALLONERROR_MASK) >> FHS_LOWER_STATUS_STALLONERROR_SHIFT)
#define  FHS_LOWER_STATUS_STALLONERROR_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_STALLONERROR_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_STALLONERROR_SHIFT))

#define  FHS_LOWER_STATUS_RESERVED2_MASK 0xf80000
#define  FHS_LOWER_STATUS_RESERVED2_SHIFT 19
#define  FHS_LOWER_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_RESERVED2_MASK) >> FHS_LOWER_STATUS_RESERVED2_SHIFT)
#define  FHS_LOWER_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_RESERVED2_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_RESERVED2_SHIFT))

#define  FHS_LOWER_STATUS_DATATYPE_MASK 0x70000
#define  FHS_LOWER_STATUS_DATATYPE_SHIFT 16
#define  FHS_LOWER_STATUS_DATATYPE_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_DATATYPE_MASK) >> FHS_LOWER_STATUS_DATATYPE_SHIFT)
#define  FHS_LOWER_STATUS_DATATYPE_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_DATATYPE_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_DATATYPE_SHIFT))

#define  FHS_LOWER_STATUS_RESERVED3_MASK 0xf800
#define  FHS_LOWER_STATUS_RESERVED3_SHIFT 11
#define  FHS_LOWER_STATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_RESERVED3_MASK) >> FHS_LOWER_STATUS_RESERVED3_SHIFT)
#define  FHS_LOWER_STATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_RESERVED3_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_RESERVED3_SHIFT))

#define  FHS_LOWER_STATUS_MODE_MASK 0x700
#define  FHS_LOWER_STATUS_MODE_SHIFT 8
#define  FHS_LOWER_STATUS_MODE_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_MODE_MASK) >> FHS_LOWER_STATUS_MODE_SHIFT)
#define  FHS_LOWER_STATUS_MODE_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_MODE_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_MODE_SHIFT))

#define  FHS_LOWER_STATUS_MERGEMETHOD_MASK 0xc0
#define  FHS_LOWER_STATUS_MERGEMETHOD_SHIFT 6
#define  FHS_LOWER_STATUS_MERGEMETHOD_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_MERGEMETHOD_MASK) >> FHS_LOWER_STATUS_MERGEMETHOD_SHIFT)
#define  FHS_LOWER_STATUS_MERGEMETHOD_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_MERGEMETHOD_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_MERGEMETHOD_SHIFT))

#define  FHS_LOWER_STATUS_RESERVED4_MASK 0x20
#define  FHS_LOWER_STATUS_RESERVED4_SHIFT 5
#define  FHS_LOWER_STATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_RESERVED4_MASK) >> FHS_LOWER_STATUS_RESERVED4_SHIFT)
#define  FHS_LOWER_STATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_RESERVED4_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_RESERVED4_SHIFT))

#define  FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_MASK 0x10
#define  FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_SHIFT 4
#define  FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_MASK) >> FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_SHIFT)
#define  FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_THRESHMERGEMAXNMIN_SHIFT))

#define  FHS_LOWER_STATUS_RESERVED5_MASK 0xf
#define  FHS_LOWER_STATUS_RESERVED5_SHIFT 0
#define  FHS_LOWER_STATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & FHS_LOWER_STATUS_RESERVED5_MASK) >> FHS_LOWER_STATUS_RESERVED5_SHIFT)
#define  FHS_LOWER_STATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_STATUS_RESERVED5_MASK) | (((uint32_t)val) << FHS_LOWER_STATUS_RESERVED5_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
/** \brief Indicates interrupt cause.*/
//====================================================================

#define  FHS_LOWER_INT_PEND_RESERVED1_MASK 0xfffffff8
#define  FHS_LOWER_INT_PEND_RESERVED1_SHIFT 3
#define  FHS_LOWER_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_PEND_RESERVED1_MASK) >> FHS_LOWER_INT_PEND_RESERVED1_SHIFT)
#define  FHS_LOWER_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_INT_PEND_RESERVED1_SHIFT))

#define  FHS_LOWER_INT_PEND_FORCEDBP_ILT2_MASK 0x4
#define  FHS_LOWER_INT_PEND_FORCEDBP_ILT2_SHIFT 2
#define  FHS_LOWER_INT_PEND_FORCEDBP_ILT2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_PEND_FORCEDBP_ILT2_MASK) >> FHS_LOWER_INT_PEND_FORCEDBP_ILT2_SHIFT)
#define  FHS_LOWER_INT_PEND_FORCEDBP_ILT2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_PEND_FORCEDBP_ILT2_MASK) | (((uint32_t)val) << FHS_LOWER_INT_PEND_FORCEDBP_ILT2_SHIFT))

#define  FHS_LOWER_INT_PEND_SURPLUS_MASK 0x2
#define  FHS_LOWER_INT_PEND_SURPLUS_SHIFT 1
#define  FHS_LOWER_INT_PEND_SURPLUS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_PEND_SURPLUS_MASK) >> FHS_LOWER_INT_PEND_SURPLUS_SHIFT)
#define  FHS_LOWER_INT_PEND_SURPLUS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_PEND_SURPLUS_MASK) | (((uint32_t)val) << FHS_LOWER_INT_PEND_SURPLUS_SHIFT))

#define  FHS_LOWER_INT_PEND_DEFICIT_MASK 0x1
#define  FHS_LOWER_INT_PEND_DEFICIT_SHIFT 0
#define  FHS_LOWER_INT_PEND_DEFICIT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_PEND_DEFICIT_MASK) >> FHS_LOWER_INT_PEND_DEFICIT_SHIFT)
#define  FHS_LOWER_INT_PEND_DEFICIT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_PEND_DEFICIT_MASK) | (((uint32_t)val) << FHS_LOWER_INT_PEND_DEFICIT_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
/** \brief Interrupt Acknowledge clears pending causes.*/
//====================================================================

#define  FHS_LOWER_INT_ACK_RESERVED1_MASK 0xfffffff8
#define  FHS_LOWER_INT_ACK_RESERVED1_SHIFT 3
#define  FHS_LOWER_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_ACK_RESERVED1_MASK) >> FHS_LOWER_INT_ACK_RESERVED1_SHIFT)
#define  FHS_LOWER_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_INT_ACK_RESERVED1_SHIFT))

#define  FHS_LOWER_INT_ACK_FORCEDBP_ILT2_MASK 0x4
#define  FHS_LOWER_INT_ACK_FORCEDBP_ILT2_SHIFT 2
#define  FHS_LOWER_INT_ACK_FORCEDBP_ILT2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_ACK_FORCEDBP_ILT2_MASK) >> FHS_LOWER_INT_ACK_FORCEDBP_ILT2_SHIFT)
#define  FHS_LOWER_INT_ACK_FORCEDBP_ILT2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_ACK_FORCEDBP_ILT2_MASK) | (((uint32_t)val) << FHS_LOWER_INT_ACK_FORCEDBP_ILT2_SHIFT))

#define  FHS_LOWER_INT_ACK_SURPLUS_MASK 0x2
#define  FHS_LOWER_INT_ACK_SURPLUS_SHIFT 1
#define  FHS_LOWER_INT_ACK_SURPLUS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_ACK_SURPLUS_MASK) >> FHS_LOWER_INT_ACK_SURPLUS_SHIFT)
#define  FHS_LOWER_INT_ACK_SURPLUS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_ACK_SURPLUS_MASK) | (((uint32_t)val) << FHS_LOWER_INT_ACK_SURPLUS_SHIFT))

#define  FHS_LOWER_INT_ACK_DEFICIT_MASK 0x1
#define  FHS_LOWER_INT_ACK_DEFICIT_SHIFT 0
#define  FHS_LOWER_INT_ACK_DEFICIT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_ACK_DEFICIT_MASK) >> FHS_LOWER_INT_ACK_DEFICIT_SHIFT)
#define  FHS_LOWER_INT_ACK_DEFICIT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_ACK_DEFICIT_MASK) | (((uint32_t)val) << FHS_LOWER_INT_ACK_DEFICIT_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
/** \brief Force Interrupt causes.*/
//====================================================================

#define  FHS_LOWER_INT_FO_RESERVED1_MASK 0xfffffff8
#define  FHS_LOWER_INT_FO_RESERVED1_SHIFT 3
#define  FHS_LOWER_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_FO_RESERVED1_MASK) >> FHS_LOWER_INT_FO_RESERVED1_SHIFT)
#define  FHS_LOWER_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_INT_FO_RESERVED1_SHIFT))

#define  FHS_LOWER_INT_FO_FORCEDBP_ILT2_MASK 0x4
#define  FHS_LOWER_INT_FO_FORCEDBP_ILT2_SHIFT 2
#define  FHS_LOWER_INT_FO_FORCEDBP_ILT2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_FO_FORCEDBP_ILT2_MASK) >> FHS_LOWER_INT_FO_FORCEDBP_ILT2_SHIFT)
#define  FHS_LOWER_INT_FO_FORCEDBP_ILT2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_FO_FORCEDBP_ILT2_MASK) | (((uint32_t)val) << FHS_LOWER_INT_FO_FORCEDBP_ILT2_SHIFT))

#define  FHS_LOWER_INT_FO_SURPLUS_MASK 0x2
#define  FHS_LOWER_INT_FO_SURPLUS_SHIFT 1
#define  FHS_LOWER_INT_FO_SURPLUS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_FO_SURPLUS_MASK) >> FHS_LOWER_INT_FO_SURPLUS_SHIFT)
#define  FHS_LOWER_INT_FO_SURPLUS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_FO_SURPLUS_MASK) | (((uint32_t)val) << FHS_LOWER_INT_FO_SURPLUS_SHIFT))

#define  FHS_LOWER_INT_FO_DEFICIT_MASK 0x1
#define  FHS_LOWER_INT_FO_DEFICIT_SHIFT 0
#define  FHS_LOWER_INT_FO_DEFICIT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_FO_DEFICIT_MASK) >> FHS_LOWER_INT_FO_DEFICIT_SHIFT)
#define  FHS_LOWER_INT_FO_DEFICIT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_FO_DEFICIT_MASK) | (((uint32_t)val) << FHS_LOWER_INT_FO_DEFICIT_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
/** \brief Enable Interrupt causes.*/
//====================================================================

#define  FHS_LOWER_INT_EN_RESERVED1_MASK 0xfffffff8
#define  FHS_LOWER_INT_EN_RESERVED1_SHIFT 3
#define  FHS_LOWER_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_EN_RESERVED1_MASK) >> FHS_LOWER_INT_EN_RESERVED1_SHIFT)
#define  FHS_LOWER_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_INT_EN_RESERVED1_SHIFT))

#define  FHS_LOWER_INT_EN_FORCEDBP_ILT2_MASK 0x4
#define  FHS_LOWER_INT_EN_FORCEDBP_ILT2_SHIFT 2
#define  FHS_LOWER_INT_EN_FORCEDBP_ILT2_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_EN_FORCEDBP_ILT2_MASK) >> FHS_LOWER_INT_EN_FORCEDBP_ILT2_SHIFT)
#define  FHS_LOWER_INT_EN_FORCEDBP_ILT2_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_EN_FORCEDBP_ILT2_MASK) | (((uint32_t)val) << FHS_LOWER_INT_EN_FORCEDBP_ILT2_SHIFT))

#define  FHS_LOWER_INT_EN_SURPLUS_MASK 0x2
#define  FHS_LOWER_INT_EN_SURPLUS_SHIFT 1
#define  FHS_LOWER_INT_EN_SURPLUS_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_EN_SURPLUS_MASK) >> FHS_LOWER_INT_EN_SURPLUS_SHIFT)
#define  FHS_LOWER_INT_EN_SURPLUS_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_EN_SURPLUS_MASK) | (((uint32_t)val) << FHS_LOWER_INT_EN_SURPLUS_SHIFT))

#define  FHS_LOWER_INT_EN_DEFICIT_MASK 0x1
#define  FHS_LOWER_INT_EN_DEFICIT_SHIFT 0
#define  FHS_LOWER_INT_EN_DEFICIT_MASK_SHIFT(reg) (((reg) & FHS_LOWER_INT_EN_DEFICIT_MASK) >> FHS_LOWER_INT_EN_DEFICIT_SHIFT)
#define  FHS_LOWER_INT_EN_DEFICIT_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_INT_EN_DEFICIT_MASK) | (((uint32_t)val) << FHS_LOWER_INT_EN_DEFICIT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  FHS_LOWER_REV0_MAJ_MASK 0xffff0000
#define  FHS_LOWER_REV0_MAJ_SHIFT 16
#define  FHS_LOWER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & FHS_LOWER_REV0_MAJ_MASK) >> FHS_LOWER_REV0_MAJ_SHIFT)
#define  FHS_LOWER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_REV0_MAJ_MASK) | (((uint32_t)val) << FHS_LOWER_REV0_MAJ_SHIFT))

#define  FHS_LOWER_REV0_MID_MASK 0xffff
#define  FHS_LOWER_REV0_MID_SHIFT 0
#define  FHS_LOWER_REV0_MID_MASK_SHIFT(reg) (((reg) & FHS_LOWER_REV0_MID_MASK) >> FHS_LOWER_REV0_MID_SHIFT)
#define  FHS_LOWER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_REV0_MID_MASK) | (((uint32_t)val) << FHS_LOWER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  FHS_LOWER_REV1_RESERVED1_MASK 0xffff0000
#define  FHS_LOWER_REV1_RESERVED1_SHIFT 16
#define  FHS_LOWER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_REV1_RESERVED1_MASK) >> FHS_LOWER_REV1_RESERVED1_SHIFT)
#define  FHS_LOWER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_REV1_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_REV1_RESERVED1_SHIFT))

#define  FHS_LOWER_REV1_CFG_MASK 0xffff
#define  FHS_LOWER_REV1_CFG_SHIFT 0
#define  FHS_LOWER_REV1_CFG_MASK_SHIFT(reg) (((reg) & FHS_LOWER_REV1_CFG_MASK) >> FHS_LOWER_REV1_CFG_SHIFT)
#define  FHS_LOWER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_REV1_CFG_MASK) | (((uint32_t)val) << FHS_LOWER_REV1_CFG_SHIFT))

//====================================================================
//Register: Threshold Enable Register (threshEnable)
/** \brief Each bit corresponds to the given data channel. If enabled, the threshold registers will be used to determine the merge method used;
      if not enabled, the channel's values will not factor into thresholding calculations.*/
//====================================================================

#define  FHS_LOWER_THRESHENABLE_RESERVED1_MASK 0xffffffc0
#define  FHS_LOWER_THRESHENABLE_RESERVED1_SHIFT 6
#define  FHS_LOWER_THRESHENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHENABLE_RESERVED1_MASK) >> FHS_LOWER_THRESHENABLE_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHENABLE_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHENABLE_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHENABLE_THRESHENABLE_MASK 0x3f
#define  FHS_LOWER_THRESHENABLE_THRESHENABLE_SHIFT 0
#define  FHS_LOWER_THRESHENABLE_THRESHENABLE_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHENABLE_THRESHENABLE_MASK) >> FHS_LOWER_THRESHENABLE_THRESHENABLE_SHIFT)
#define  FHS_LOWER_THRESHENABLE_THRESHENABLE_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHENABLE_THRESHENABLE_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHENABLE_THRESHENABLE_SHIFT))

//====================================================================
//Register: Merge Enable Register (mergeEnable)
/** \brief Each bit corresponds to a given data channel. If enabled, the selected merge method will be used during decimation when appropriate;
      if not enabled, decimation only will occur on the given color channel.*/
//====================================================================

#define  FHS_LOWER_MERGEENABLE_RESERVED1_MASK 0xffffffc0
#define  FHS_LOWER_MERGEENABLE_RESERVED1_SHIFT 6
#define  FHS_LOWER_MERGEENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_MERGEENABLE_RESERVED1_MASK) >> FHS_LOWER_MERGEENABLE_RESERVED1_SHIFT)
#define  FHS_LOWER_MERGEENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_MERGEENABLE_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_MERGEENABLE_RESERVED1_SHIFT))

#define  FHS_LOWER_MERGEENABLE_MERGEENABLE_MASK 0x3f
#define  FHS_LOWER_MERGEENABLE_MERGEENABLE_SHIFT 0
#define  FHS_LOWER_MERGEENABLE_MERGEENABLE_MASK_SHIFT(reg) (((reg) & FHS_LOWER_MERGEENABLE_MERGEENABLE_MASK) >> FHS_LOWER_MERGEENABLE_MERGEENABLE_SHIFT)
#define  FHS_LOWER_MERGEENABLE_MERGEENABLE_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_MERGEENABLE_MERGEENABLE_MASK) | (((uint32_t)val) << FHS_LOWER_MERGEENABLE_MERGEENABLE_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 1 of 6) (threshLow0)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 1 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW0_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW0_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW0_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW0_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW0_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW0_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW0_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW0_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW0_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW0_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW0_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW0_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW0_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW0_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW0_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 2 of 6) (threshLow1)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 2 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW1_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW1_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW1_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW1_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW1_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW1_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW1_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW1_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW1_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW1_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW1_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW1_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW1_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW1_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW1_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 3 of 6) (threshLow2)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 3 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW2_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW2_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW2_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW2_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW2_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW2_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW2_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW2_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW2_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW2_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW2_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW2_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW2_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW2_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW2_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 4 of 6) (threshLow3)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 4 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW3_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW3_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW3_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW3_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW3_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW3_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW3_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW3_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW3_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW3_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW3_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW3_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW3_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW3_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW3_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 5 of 6) (threshLow4)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 5 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW4_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW4_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW4_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW4_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW4_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW4_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW4_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW4_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW4_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW4_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW4_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW4_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW4_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW4_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW4_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge Low Threshold Registers (Instance 6 of 6) (threshLow5)
/** \brief Set each color(s) low threshold. All (enabled) color values of a pixel must meet the low threshold assigned to it to enable threshold method merging. (Instance 6 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHLOW5_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHLOW5_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHLOW5_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW5_RESERVED1_MASK) >> FHS_LOWER_THRESHLOW5_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHLOW5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW5_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW5_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHLOW5_THRESHLOW_MASK 0x3ff
#define  FHS_LOWER_THRESHLOW5_THRESHLOW_SHIFT 0
#define  FHS_LOWER_THRESHLOW5_THRESHLOW_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHLOW5_THRESHLOW_MASK) >> FHS_LOWER_THRESHLOW5_THRESHLOW_SHIFT)
#define  FHS_LOWER_THRESHLOW5_THRESHLOW_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHLOW5_THRESHLOW_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHLOW5_THRESHLOW_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 1 of 6) (threshHigh0)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 1 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH0_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH0_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH0_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH0_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH0_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH0_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH0_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH0_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH0_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH0_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH0_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH0_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH0_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH0_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH0_THRESHHIGH_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 2 of 6) (threshHigh1)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 2 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH1_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH1_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH1_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH1_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH1_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH1_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH1_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH1_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH1_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH1_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH1_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH1_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH1_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH1_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH1_THRESHHIGH_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 3 of 6) (threshHigh2)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 3 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH2_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH2_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH2_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH2_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH2_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH2_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH2_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH2_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH2_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH2_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH2_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH2_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH2_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH2_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH2_THRESHHIGH_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 4 of 6) (threshHigh3)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 4 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH3_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH3_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH3_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH3_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH3_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH3_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH3_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH3_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH3_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH3_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH3_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH3_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH3_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH3_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH3_THRESHHIGH_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 5 of 6) (threshHigh4)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 5 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH4_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH4_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH4_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH4_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH4_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH4_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH4_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH4_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH4_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH4_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH4_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH4_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH4_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH4_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH4_THRESHHIGH_SHIFT))

//====================================================================
//Register: Merge High Threshold Register (Instance 6 of 6) (threshHigh5)
/** \brief Set each color(s) high threshold. All color values of a pixel must meet the high threshold assigned to it to enable threshold method merging. (Instance 6 of 6)*/
//====================================================================

#define  FHS_LOWER_THRESHHIGH5_RESERVED1_MASK 0xfffffc00
#define  FHS_LOWER_THRESHHIGH5_RESERVED1_SHIFT 10
#define  FHS_LOWER_THRESHHIGH5_RESERVED1_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH5_RESERVED1_MASK) >> FHS_LOWER_THRESHHIGH5_RESERVED1_SHIFT)
#define  FHS_LOWER_THRESHHIGH5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH5_RESERVED1_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH5_RESERVED1_SHIFT))

#define  FHS_LOWER_THRESHHIGH5_THRESHHIGH_MASK 0x3ff
#define  FHS_LOWER_THRESHHIGH5_THRESHHIGH_SHIFT 0
#define  FHS_LOWER_THRESHHIGH5_THRESHHIGH_MASK_SHIFT(reg) (((reg) & FHS_LOWER_THRESHHIGH5_THRESHHIGH_MASK) >> FHS_LOWER_THRESHHIGH5_THRESHHIGH_SHIFT)
#define  FHS_LOWER_THRESHHIGH5_THRESHHIGH_REPLACE_VAL(reg,val) (((reg) & ~FHS_LOWER_THRESHHIGH5_THRESHHIGH_MASK) | (((uint32_t)val) << FHS_LOWER_THRESHHIGH5_THRESHHIGH_SHIFT))

#endif // FHS_LOWER
