 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DTH_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DTH_REGMASKS_H_
#define _DTH_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DTH (DTH)
/** \brief (rev 0 . 2 . 0 . 0)
    Top-level register file for the DMA Threshold Halftoning block*/
//
//====================================================================

//====================================================================
//Register: DTH Control Register (CTRL)
/** \brief This register configures the major features of the DTH module*/
//====================================================================

#define  DTH_CTRL_RESERVED1_MASK 0xffffff80
#define  DTH_CTRL_RESERVED1_SHIFT 7
#define  DTH_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_CTRL_RESERVED1_MASK) >> DTH_CTRL_RESERVED1_SHIFT)
#define  DTH_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DTH_CTRL_RESERVED1_SHIFT))

#define  DTH_CTRL_MODE_MASK 0x70
#define  DTH_CTRL_MODE_SHIFT 4
#define  DTH_CTRL_MODE_MASK_SHIFT(reg) (((reg) & DTH_CTRL_MODE_MASK) >> DTH_CTRL_MODE_SHIFT)
#define  DTH_CTRL_MODE_REPLACE_VAL(reg,val) (((reg) & ~DTH_CTRL_MODE_MASK) | (((uint32_t)val) << DTH_CTRL_MODE_SHIFT))

#define  DTH_CTRL_RESERVED2_MASK 0xe
#define  DTH_CTRL_RESERVED2_SHIFT 1
#define  DTH_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DTH_CTRL_RESERVED2_MASK) >> DTH_CTRL_RESERVED2_SHIFT)
#define  DTH_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DTH_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DTH_CTRL_RESERVED2_SHIFT))

#define  DTH_CTRL_BYPASSALL_MASK 0x1
#define  DTH_CTRL_BYPASSALL_SHIFT 0
#define  DTH_CTRL_BYPASSALL_MASK_SHIFT(reg) (((reg) & DTH_CTRL_BYPASSALL_MASK) >> DTH_CTRL_BYPASSALL_SHIFT)
#define  DTH_CTRL_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~DTH_CTRL_BYPASSALL_MASK) | (((uint32_t)val) << DTH_CTRL_BYPASSALL_SHIFT))

//====================================================================
//Register: DTH Array Width Register (THRESH_ARRAY_WIDTH)
/** \brief This register describes the width of the threshold comparison array*/
//====================================================================

#define  DTH_THRESH_ARRAY_WIDTH_RESERVED1_MASK 0xfffff000
#define  DTH_THRESH_ARRAY_WIDTH_RESERVED1_SHIFT 12
#define  DTH_THRESH_ARRAY_WIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_THRESH_ARRAY_WIDTH_RESERVED1_MASK) >> DTH_THRESH_ARRAY_WIDTH_RESERVED1_SHIFT)
#define  DTH_THRESH_ARRAY_WIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_THRESH_ARRAY_WIDTH_RESERVED1_MASK) | (((uint32_t)val) << DTH_THRESH_ARRAY_WIDTH_RESERVED1_SHIFT))

#define  DTH_THRESH_ARRAY_WIDTH_WIDTH_MASK 0xfff
#define  DTH_THRESH_ARRAY_WIDTH_WIDTH_SHIFT 0
#define  DTH_THRESH_ARRAY_WIDTH_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_THRESH_ARRAY_WIDTH_WIDTH_MASK) >> DTH_THRESH_ARRAY_WIDTH_WIDTH_SHIFT)
#define  DTH_THRESH_ARRAY_WIDTH_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_THRESH_ARRAY_WIDTH_WIDTH_MASK) | (((uint32_t)val) << DTH_THRESH_ARRAY_WIDTH_WIDTH_SHIFT))

//====================================================================
//Register: DTH Line Count Register (LINE_CNT)
/** \brief Shows the number of lines that have been processed*/
//====================================================================

#define  DTH_LINE_CNT_RESERVED1_MASK 0xffff0000
#define  DTH_LINE_CNT_RESERVED1_SHIFT 16
#define  DTH_LINE_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_LINE_CNT_RESERVED1_MASK) >> DTH_LINE_CNT_RESERVED1_SHIFT)
#define  DTH_LINE_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_LINE_CNT_RESERVED1_MASK) | (((uint32_t)val) << DTH_LINE_CNT_RESERVED1_SHIFT))

#define  DTH_LINE_CNT_LINECNT_MASK 0xffff
#define  DTH_LINE_CNT_LINECNT_SHIFT 0
#define  DTH_LINE_CNT_LINECNT_MASK_SHIFT(reg) (((reg) & DTH_LINE_CNT_LINECNT_MASK) >> DTH_LINE_CNT_LINECNT_SHIFT)
#define  DTH_LINE_CNT_LINECNT_REPLACE_VAL(reg,val) (((reg) & ~DTH_LINE_CNT_LINECNT_MASK) | (((uint32_t)val) << DTH_LINE_CNT_LINECNT_SHIFT))

//====================================================================
//Register: Threshold SRAM Access Control Register (THACR)
//====================================================================

#define  DTH_THACR_RESERVED1_MASK 0xfffffff8
#define  DTH_THACR_RESERVED1_SHIFT 3
#define  DTH_THACR_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_THACR_RESERVED1_MASK) >> DTH_THACR_RESERVED1_SHIFT)
#define  DTH_THACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_THACR_RESERVED1_MASK) | (((uint32_t)val) << DTH_THACR_RESERVED1_SHIFT))

#define  DTH_THACR_RAM_SELECT_MASK 0x4
#define  DTH_THACR_RAM_SELECT_SHIFT 2
#define  DTH_THACR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & DTH_THACR_RAM_SELECT_MASK) >> DTH_THACR_RAM_SELECT_SHIFT)
#define  DTH_THACR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~DTH_THACR_RAM_SELECT_MASK) | (((uint32_t)val) << DTH_THACR_RAM_SELECT_SHIFT))

#define  DTH_THACR_INC_ADDR_MODE_MASK 0x2
#define  DTH_THACR_INC_ADDR_MODE_SHIFT 1
#define  DTH_THACR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & DTH_THACR_INC_ADDR_MODE_MASK) >> DTH_THACR_INC_ADDR_MODE_SHIFT)
#define  DTH_THACR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~DTH_THACR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << DTH_THACR_INC_ADDR_MODE_SHIFT))

#define  DTH_THACR_TH_CPU_MASK 0x1
#define  DTH_THACR_TH_CPU_SHIFT 0
#define  DTH_THACR_TH_CPU_MASK_SHIFT(reg) (((reg) & DTH_THACR_TH_CPU_MASK) >> DTH_THACR_TH_CPU_SHIFT)
#define  DTH_THACR_TH_CPU_REPLACE_VAL(reg,val) (((reg) & ~DTH_THACR_TH_CPU_MASK) | (((uint32_t)val) << DTH_THACR_TH_CPU_SHIFT))

//====================================================================
//Register: Threshold RAM Address Register (THAR)
//====================================================================

#define  DTH_THAR_ADDRESS_MASK 0xffffffff
#define  DTH_THAR_ADDRESS_SHIFT 0
#define  DTH_THAR_ADDRESS_MASK_SHIFT(reg) (((reg) & DTH_THAR_ADDRESS_MASK) >> DTH_THAR_ADDRESS_SHIFT)
#define  DTH_THAR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DTH_THAR_ADDRESS_MASK) | (((uint32_t)val) << DTH_THAR_ADDRESS_SHIFT))

//====================================================================
//Register: Threshold RAM Address Status Register (THASR)
//====================================================================

#define  DTH_THASR_ADDRESS_MASK 0xffffffff
#define  DTH_THASR_ADDRESS_SHIFT 0
#define  DTH_THASR_ADDRESS_MASK_SHIFT(reg) (((reg) & DTH_THASR_ADDRESS_MASK) >> DTH_THASR_ADDRESS_SHIFT)
#define  DTH_THASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DTH_THASR_ADDRESS_MASK) | (((uint32_t)val) << DTH_THASR_ADDRESS_SHIFT))

//====================================================================
//Register: Threshold RAM Data Write Register (THDWR)
/** \brief This register writes the Threshold SRAM entry.*/
//====================================================================

#define  DTH_THDWR_DATA_MASK 0xffffffff
#define  DTH_THDWR_DATA_SHIFT 0
#define  DTH_THDWR_DATA_MASK_SHIFT(reg) (((reg) & DTH_THDWR_DATA_MASK) >> DTH_THDWR_DATA_SHIFT)
#define  DTH_THDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~DTH_THDWR_DATA_MASK) | (((uint32_t)val) << DTH_THDWR_DATA_SHIFT))

//====================================================================
//Register: Threshold RAM Data Read Register (THDRR)
/** \brief This register reads the Threshold SRAM entry*/
//====================================================================

#define  DTH_THDRR_DATA_MASK 0xffffffff
#define  DTH_THDRR_DATA_SHIFT 0
#define  DTH_THDRR_DATA_MASK_SHIFT(reg) (((reg) & DTH_THDRR_DATA_MASK) >> DTH_THDRR_DATA_SHIFT)
#define  DTH_THDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~DTH_THDRR_DATA_MASK) | (((uint32_t)val) << DTH_THDRR_DATA_SHIFT))

//====================================================================
//Register: Deinterleave SRAM Access Control Register (DIACR)
/** \brief NOTE: This register is only valid if the module has the deinterleaving logic enabled as
              indicated by a '1' in the DI_ENABLED field in the DTH Parameter register (DTH_PARAM).*/
//====================================================================

#define  DTH_DIACR_RESERVED1_MASK 0xfffffff8
#define  DTH_DIACR_RESERVED1_SHIFT 3
#define  DTH_DIACR_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_DIACR_RESERVED1_MASK) >> DTH_DIACR_RESERVED1_SHIFT)
#define  DTH_DIACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIACR_RESERVED1_MASK) | (((uint32_t)val) << DTH_DIACR_RESERVED1_SHIFT))

#define  DTH_DIACR_RAM_SELECT_MASK 0x4
#define  DTH_DIACR_RAM_SELECT_SHIFT 2
#define  DTH_DIACR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & DTH_DIACR_RAM_SELECT_MASK) >> DTH_DIACR_RAM_SELECT_SHIFT)
#define  DTH_DIACR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIACR_RAM_SELECT_MASK) | (((uint32_t)val) << DTH_DIACR_RAM_SELECT_SHIFT))

#define  DTH_DIACR_INC_ADDR_MODE_MASK 0x2
#define  DTH_DIACR_INC_ADDR_MODE_SHIFT 1
#define  DTH_DIACR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & DTH_DIACR_INC_ADDR_MODE_MASK) >> DTH_DIACR_INC_ADDR_MODE_SHIFT)
#define  DTH_DIACR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIACR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << DTH_DIACR_INC_ADDR_MODE_SHIFT))

#define  DTH_DIACR_DI_CPU_MASK 0x1
#define  DTH_DIACR_DI_CPU_SHIFT 0
#define  DTH_DIACR_DI_CPU_MASK_SHIFT(reg) (((reg) & DTH_DIACR_DI_CPU_MASK) >> DTH_DIACR_DI_CPU_SHIFT)
#define  DTH_DIACR_DI_CPU_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIACR_DI_CPU_MASK) | (((uint32_t)val) << DTH_DIACR_DI_CPU_SHIFT))

//====================================================================
//Register: Deinterleave RAM Address Register (DIAR)
/** \brief NOTE: This register is only valid if the module has the deinterleaving logic enabled as
              indicated by a '1' in the DI_ENABLED field in the DTH Parameter register (DTH_PARAM).*/
//====================================================================

#define  DTH_DIAR_ADDRESS_MASK 0xffffffff
#define  DTH_DIAR_ADDRESS_SHIFT 0
#define  DTH_DIAR_ADDRESS_MASK_SHIFT(reg) (((reg) & DTH_DIAR_ADDRESS_MASK) >> DTH_DIAR_ADDRESS_SHIFT)
#define  DTH_DIAR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIAR_ADDRESS_MASK) | (((uint32_t)val) << DTH_DIAR_ADDRESS_SHIFT))

//====================================================================
//Register: Deinterleave RAM Address Status Register (DIASR)
/** \brief NOTE: This register is only valid if the module has the deinterleaving logic enabled as
              indicated by a '1' in the DI_ENABLED field in the DTH Parameter register (DTH_PARAM).*/
//====================================================================

#define  DTH_DIASR_ADDRESS_MASK 0xffffffff
#define  DTH_DIASR_ADDRESS_SHIFT 0
#define  DTH_DIASR_ADDRESS_MASK_SHIFT(reg) (((reg) & DTH_DIASR_ADDRESS_MASK) >> DTH_DIASR_ADDRESS_SHIFT)
#define  DTH_DIASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIASR_ADDRESS_MASK) | (((uint32_t)val) << DTH_DIASR_ADDRESS_SHIFT))

//====================================================================
//Register: Deinterleave RAM Data Write Register (DIDWR)
/** \brief NOTE: This register is only valid if the module has the deinterleaving logic enabled as
              indicated by a '1' in the DI_ENABLED field in the DTH Parameter register (DTH_PARAM).*/
//====================================================================

#define  DTH_DIDWR_DATA_MASK 0xffffffff
#define  DTH_DIDWR_DATA_SHIFT 0
#define  DTH_DIDWR_DATA_MASK_SHIFT(reg) (((reg) & DTH_DIDWR_DATA_MASK) >> DTH_DIDWR_DATA_SHIFT)
#define  DTH_DIDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIDWR_DATA_MASK) | (((uint32_t)val) << DTH_DIDWR_DATA_SHIFT))

//====================================================================
//Register: Deinterleave RAM Data Read Register (DIDRR)
/** \brief NOTE: This register is only valid if the module has the deinterleaving logic enabled as
              indicated by a '1' in the DI_ENABLED field in the DTH Parameter register (DTH_PARAM).*/
//====================================================================

#define  DTH_DIDRR_DATA_MASK 0xffffffff
#define  DTH_DIDRR_DATA_SHIFT 0
#define  DTH_DIDRR_DATA_MASK_SHIFT(reg) (((reg) & DTH_DIDRR_DATA_MASK) >> DTH_DIDRR_DATA_SHIFT)
#define  DTH_DIDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~DTH_DIDRR_DATA_MASK) | (((uint32_t)val) << DTH_DIDRR_DATA_SHIFT))

//====================================================================
//Register: DTH Parameter Register 0 (DTH_PARAM0)
/** \brief Contains parameter settings for this instantiation of DTH*/
//====================================================================

#define  DTH_DTH_PARAM0_RESERVED1_MASK 0xf8000000
#define  DTH_DTH_PARAM0_RESERVED1_SHIFT 27
#define  DTH_DTH_PARAM0_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_RESERVED1_MASK) >> DTH_DTH_PARAM0_RESERVED1_SHIFT)
#define  DTH_DTH_PARAM0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_RESERVED1_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_RESERVED1_SHIFT))

#define  DTH_DTH_PARAM0_TH_SRAM_WIDTH_MASK 0x7e00000
#define  DTH_DTH_PARAM0_TH_SRAM_WIDTH_SHIFT 21
#define  DTH_DTH_PARAM0_TH_SRAM_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_TH_SRAM_WIDTH_MASK) >> DTH_DTH_PARAM0_TH_SRAM_WIDTH_SHIFT)
#define  DTH_DTH_PARAM0_TH_SRAM_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_TH_SRAM_WIDTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_TH_SRAM_WIDTH_SHIFT))

#define  DTH_DTH_PARAM0_TH_SRAM_DEPTH_MASK 0x1ffc00
#define  DTH_DTH_PARAM0_TH_SRAM_DEPTH_SHIFT 10
#define  DTH_DTH_PARAM0_TH_SRAM_DEPTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_TH_SRAM_DEPTH_MASK) >> DTH_DTH_PARAM0_TH_SRAM_DEPTH_SHIFT)
#define  DTH_DTH_PARAM0_TH_SRAM_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_TH_SRAM_DEPTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_TH_SRAM_DEPTH_SHIFT))

#define  DTH_DTH_PARAM0_DT_WIDTH_MASK 0x300
#define  DTH_DTH_PARAM0_DT_WIDTH_SHIFT 8
#define  DTH_DTH_PARAM0_DT_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_DT_WIDTH_MASK) >> DTH_DTH_PARAM0_DT_WIDTH_SHIFT)
#define  DTH_DTH_PARAM0_DT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_DT_WIDTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_DT_WIDTH_SHIFT))

#define  DTH_DTH_PARAM0_OUT_CH_WIDTH_MASK 0xf0
#define  DTH_DTH_PARAM0_OUT_CH_WIDTH_SHIFT 4
#define  DTH_DTH_PARAM0_OUT_CH_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_OUT_CH_WIDTH_MASK) >> DTH_DTH_PARAM0_OUT_CH_WIDTH_SHIFT)
#define  DTH_DTH_PARAM0_OUT_CH_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_OUT_CH_WIDTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_OUT_CH_WIDTH_SHIFT))

#define  DTH_DTH_PARAM0_IN_CH_WIDTH_MASK 0xf
#define  DTH_DTH_PARAM0_IN_CH_WIDTH_SHIFT 0
#define  DTH_DTH_PARAM0_IN_CH_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM0_IN_CH_WIDTH_MASK) >> DTH_DTH_PARAM0_IN_CH_WIDTH_SHIFT)
#define  DTH_DTH_PARAM0_IN_CH_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM0_IN_CH_WIDTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM0_IN_CH_WIDTH_SHIFT))

//====================================================================
//Register: DTH Parameter Register 1 (DTH_PARAM1)
/** \brief Contains parameter settings for this instantiation of DTH*/
//====================================================================

#define  DTH_DTH_PARAM1_RESERVED1_MASK 0xfffc0000
#define  DTH_DTH_PARAM1_RESERVED1_SHIFT 18
#define  DTH_DTH_PARAM1_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM1_RESERVED1_MASK) >> DTH_DTH_PARAM1_RESERVED1_SHIFT)
#define  DTH_DTH_PARAM1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM1_RESERVED1_MASK) | (((uint32_t)val) << DTH_DTH_PARAM1_RESERVED1_SHIFT))

#define  DTH_DTH_PARAM1_DI_SRAM_WIDTH_MASK 0x3f000
#define  DTH_DTH_PARAM1_DI_SRAM_WIDTH_SHIFT 12
#define  DTH_DTH_PARAM1_DI_SRAM_WIDTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM1_DI_SRAM_WIDTH_MASK) >> DTH_DTH_PARAM1_DI_SRAM_WIDTH_SHIFT)
#define  DTH_DTH_PARAM1_DI_SRAM_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM1_DI_SRAM_WIDTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM1_DI_SRAM_WIDTH_SHIFT))

#define  DTH_DTH_PARAM1_DI_SRAM_DEPTH_MASK 0xffe
#define  DTH_DTH_PARAM1_DI_SRAM_DEPTH_SHIFT 1
#define  DTH_DTH_PARAM1_DI_SRAM_DEPTH_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM1_DI_SRAM_DEPTH_MASK) >> DTH_DTH_PARAM1_DI_SRAM_DEPTH_SHIFT)
#define  DTH_DTH_PARAM1_DI_SRAM_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM1_DI_SRAM_DEPTH_MASK) | (((uint32_t)val) << DTH_DTH_PARAM1_DI_SRAM_DEPTH_SHIFT))

#define  DTH_DTH_PARAM1_DI_ENABLED_MASK 0x1
#define  DTH_DTH_PARAM1_DI_ENABLED_SHIFT 0
#define  DTH_DTH_PARAM1_DI_ENABLED_MASK_SHIFT(reg) (((reg) & DTH_DTH_PARAM1_DI_ENABLED_MASK) >> DTH_DTH_PARAM1_DI_ENABLED_SHIFT)
#define  DTH_DTH_PARAM1_DI_ENABLED_REPLACE_VAL(reg,val) (((reg) & ~DTH_DTH_PARAM1_DI_ENABLED_MASK) | (((uint32_t)val) << DTH_DTH_PARAM1_DI_ENABLED_SHIFT))

//====================================================================
//Register: DTH Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DTH_REV0_MAJ_MASK 0xffff0000
#define  DTH_REV0_MAJ_SHIFT 16
#define  DTH_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DTH_REV0_MAJ_MASK) >> DTH_REV0_MAJ_SHIFT)
#define  DTH_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DTH_REV0_MAJ_MASK) | (((uint32_t)val) << DTH_REV0_MAJ_SHIFT))

#define  DTH_REV0_MID_MASK 0xffff
#define  DTH_REV0_MID_SHIFT 0
#define  DTH_REV0_MID_MASK_SHIFT(reg) (((reg) & DTH_REV0_MID_MASK) >> DTH_REV0_MID_SHIFT)
#define  DTH_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DTH_REV0_MID_MASK) | (((uint32_t)val) << DTH_REV0_MID_SHIFT))

//====================================================================
//Register: DTH Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DTH_REV1_RESERVED1_MASK 0xffff0000
#define  DTH_REV1_RESERVED1_SHIFT 16
#define  DTH_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DTH_REV1_RESERVED1_MASK) >> DTH_REV1_RESERVED1_SHIFT)
#define  DTH_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DTH_REV1_RESERVED1_MASK) | (((uint32_t)val) << DTH_REV1_RESERVED1_SHIFT))

#define  DTH_REV1_CFG_MASK 0xffff
#define  DTH_REV1_CFG_SHIFT 0
#define  DTH_REV1_CFG_MASK_SHIFT(reg) (((reg) & DTH_REV1_CFG_MASK) >> DTH_REV1_CFG_SHIFT)
#define  DTH_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DTH_REV1_CFG_MASK) | (((uint32_t)val) << DTH_REV1_CFG_SHIFT))

#endif // DTH
