 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DSMF_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DSMF_REGSTRUCTS_H_
#define _DSMF_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DSMF (DSMF)
/** \brief Register Descriptions for the Descreen / MultiFilter block
(rev 0 . 1 . 0 . 0)*/
//
//====================================================================

typedef struct DSMF_REGS_s
{
  volatile uint32_t DSMF_Ctl;  ///< 0x0 [R/W]: DSMF Control Register
  volatile uint32_t DSMF_Seg_HV_Proj;  ///< 0x4 [R/W]: DSMF Segmentation Threshold - Horizontal and Vertical Projection Register
  volatile uint32_t DSMF_Seg_Diag_Proj;  ///< 0x8 [R/W]: DSMF Segmentation Threshold - Diagonal Projection Register
  volatile uint32_t DSMF_Seg_Isolated;  ///< 0xc [R/W]: DSMF Segmentation Threshold - Isolated Detection Register
  volatile uint32_t DSMF_Seg_3x3_Text;  ///< 0x10 [R/W]: DSMF Segmentation Threshold - 3x3 Text Detection Register
  volatile uint32_t DSMF_Seg_3x3_Mixed;  ///< 0x14 [R/W]: DSMF Segmentation Threshold - 3x3 Mixed Detection Register
  volatile uint32_t DSMF_Seg_5x5_Text;  ///< 0x18 [R/W]: DSMF Segmentation Threshold - 5x5 Text Detection Register
  volatile uint32_t DSMF_Seg_5x5_Mixed;  ///< 0x1c [R/W]: DSMF Segmentation Threshold - 5x5 Mixed Detection Register
  volatile uint32_t DSMF_Seg_Line;  ///< 0x20 [R/W]: DSMF Segmentation Threshold - Line Detection Register
  volatile uint32_t DSMF_Seg_Line_Diag;  ///< 0x24 [R/W]: DSMF Segmentation Threshold - Line Diagonal Detection Register
  volatile uint32_t DSMF_SCR1;  ///< 0x28 [R/W]: DSMF Sculptor Configuration 1 Register
  volatile uint32_t DSMF_SCR2;  ///< 0x2c [R/W]: DSMF Sculptor Configuration 2 Register
  volatile uint32_t DSMF_TEL1R;  ///< 0x30 [R/W]: DSMF Text Enhance Limit 1 Register
  volatile uint32_t DSMF_TEL2R;  ///< 0x34 [R/W]: DSMF Text Enhance Limit 2 Register
  volatile uint32_t DSMF_TEL3R;  ///< 0x38 [R/W]: DSMF Text Enhance Limit 3 Register
  volatile uint32_t DSMF_EC_COMPARE;  ///< 0x3c [R/W]: DSMF Edge Count Compare
  volatile uint32_t DSMF_EC_WR;  ///< 0x40 [W]: DSMF Edge Count Write
  volatile uint32_t DSMF_EC_OBS;  ///< 0x44 [R]: DSMF Edge Count Observation
  volatile uint32_t DSMF_ECI;  ///< 0x48 [R/W]: DSMF Edge Count Indices
  volatile uint32_t DSMF_YVC00_01;  ///< 0x4c [R/W]: DSMF Y Variable Coefficient00_01, Filter 0
  volatile uint32_t DSMF_YVC02_03;  ///< 0x50 [R/W]: DSMF Y Variable Coefficient02_03, Filter 0
  volatile uint32_t DSMF_YVC04_10;  ///< 0x54 [R/W]: DSMF Y Variable Coefficient04_10, Filter 0
  volatile uint32_t DSMF_YVC11_12;  ///< 0x58 [R/W]: DSMF Y Variable Coefficient11_12, Filter 0
  volatile uint32_t DSMF_YVC13_14;  ///< 0x5c [R/W]: DSMF Y Variable Coefficient13_14, Filter 0
  volatile uint32_t DSMF_YVC20_21;  ///< 0x60 [R/W]: DSMF Y Variable Coefficient20_21, Filter 0
  volatile uint32_t DSMF_YVC22_23;  ///< 0x64 [R/W]: DSMF Y Variable Coefficient22_23, Filter 0
  volatile uint32_t DSMF_YVC24;  ///< 0x68 [R/W]: DSMF Y Variable Coefficient24, Filter 0
  volatile uint32_t DSMF_YVC30_31;  ///< 0x6c [R/W]: DSMF Y Variable Coefficient30_31, Filter 0
  volatile uint32_t DSMF_YVC32_33;  ///< 0x70 [R/W]: DSMF Y Variable Coefficient32_33, Filter 0
  volatile uint32_t DSMF_YVC34_40;  ///< 0x74 [R/W]: DSMF Y Variable Coefficient34_40, Filter 0
  volatile uint32_t DSMF_YVC41_42;  ///< 0x78 [R/W]: DSMF Y Variable Coefficient41_42, Filter 0
  volatile uint32_t DSMF_YVC43_44;  ///< 0x7c [R/W]: DSMF Y Variable Coefficient43_44, Filter 0
  volatile uint32_t DSMF_CVC00_01;  ///< 0x80 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 0
  volatile uint32_t DSMF_CVC02_03;  ///< 0x84 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 0
  volatile uint32_t DSMF_CVC04_10;  ///< 0x88 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 0
  volatile uint32_t DSMF_CVC11_12;  ///< 0x8c [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 0
  volatile uint32_t DSMF_CVC13_14;  ///< 0x90 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 0
  volatile uint32_t DSMF_CVC20_21;  ///< 0x94 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 0
  volatile uint32_t DSMF_CVC22_23;  ///< 0x98 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 0
  volatile uint32_t DSMF_CVC24;  ///< 0x9c [R/W]: DSMF Chroma Variable Coefficient24, Filter 0
  volatile uint32_t DSMF_CVC30_31;  ///< 0xa0 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 0
  volatile uint32_t DSMF_CVC32_33;  ///< 0xa4 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 0
  volatile uint32_t DSMF_CVC34_40;  ///< 0xa8 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 0
  volatile uint32_t DSMF_CVC41_42;  ///< 0xac [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 0
  volatile uint32_t DSMF_CVC43_44;  ///< 0xb0 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 0
  volatile uint32_t DSMF_FILT_MULT;  ///< 0xb4 [R/W]: DSMF Filter Sum Multiplier, Filter 0
  volatile uint32_t DSMF_FILT_SHIFT;  ///< 0xb8 [R/W]: DSMF Filter Sum Shift Factor, Filter 0
  volatile uint32_t DSMF_YVC00_01_F1;  ///< 0xbc [R/W]: DSMF Y Variable Coefficient00_01, Filter 1
  volatile uint32_t DSMF_YVC02_03_F1;  ///< 0xc0 [R/W]: DSMF Y Variable Coefficient02_03, Filter 1
  volatile uint32_t DSMF_YVC04_10_F1;  ///< 0xc4 [R/W]: DSMF Y Variable Coefficient04_10, Filter 1
  volatile uint32_t DSMF_YVC11_12_F1;  ///< 0xc8 [R/W]: DSMF Y Variable Coefficient11_12, Filter 1
  volatile uint32_t DSMF_YVC13_14_F1;  ///< 0xcc [R/W]: DSMF Y Variable Coefficient13_14, Filter 1
  volatile uint32_t DSMF_YVC20_21_F1;  ///< 0xd0 [R/W]: DSMF Y Variable Coefficient20_21, Filter 1
  volatile uint32_t DSMF_YVC22_23_F1;  ///< 0xd4 [R/W]: DSMF Y Variable Coefficient22_23, Filter 1
  volatile uint32_t DSMF_YVC24_F1;  ///< 0xd8 [R/W]: DSMF Y Variable Coefficient24, Filter 1
  volatile uint32_t DSMF_YVC30_31_F1;  ///< 0xdc [R/W]: DSMF Y Variable Coefficient30_31, Filter 1
  volatile uint32_t DSMF_YVC32_33_F1;  ///< 0xe0 [R/W]: DSMF Y Variable Coefficient32_33, Filter 1
  volatile uint32_t DSMF_YVC34_40_F1;  ///< 0xe4 [R/W]: DSMF Y Variable Coefficient34_40, Filter 1
  volatile uint32_t DSMF_YVC41_42_F1;  ///< 0xe8 [R/W]: DSMF Y Variable Coefficient41_42, Filter 1
  volatile uint32_t DSMF_YVC43_44_F1;  ///< 0xec [R/W]: DSMF Y Variable Coefficient43_44, Filter 1
  volatile uint32_t DSMF_CVC00_01_F1;  ///< 0xf0 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 1
  volatile uint32_t DSMF_CVC02_03_F1;  ///< 0xf4 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 1
  volatile uint32_t DSMF_CVC04_10_F1;  ///< 0xf8 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 1
  volatile uint32_t DSMF_CVC11_12_F1;  ///< 0xfc [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 1
  volatile uint32_t DSMF_CVC13_14_F1;  ///< 0x100 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 1
  volatile uint32_t DSMF_CVC20_21_F1;  ///< 0x104 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 1
  volatile uint32_t DSMF_CVC22_23_F1;  ///< 0x108 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 1
  volatile uint32_t DSMF_CVC24_F1;  ///< 0x10c [R/W]: DSMF Chroma Variable Coefficient24, Filter 1
  volatile uint32_t DSMF_CVC30_31_F1;  ///< 0x110 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 1
  volatile uint32_t DSMF_CVC32_33_F1;  ///< 0x114 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 1
  volatile uint32_t DSMF_CVC34_40_F1;  ///< 0x118 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 1
  volatile uint32_t DSMF_CVC41_42_F1;  ///< 0x11c [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 1
  volatile uint32_t DSMF_CVC43_44_F1;  ///< 0x120 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 1
  volatile uint32_t DSMF_FILT_MULT_F1;  ///< 0x124 [R/W]: DSMF Filter Sum Multiplier, Filter 1
  volatile uint32_t DSMF_FILT_SHIFT_F1;  ///< 0x128 [R/W]: DSMF Filter Sum Shift Factor, Filter 1
  volatile uint32_t DSMF_YVC00_01_F2;  ///< 0x12c [R/W]: DSMF Y Variable Coefficient00_01, Filter 2
  volatile uint32_t DSMF_YVC02_03_F2;  ///< 0x130 [R/W]: DSMF Y Variable Coefficient02_03, Filter 2
  volatile uint32_t DSMF_YVC04_10_F2;  ///< 0x134 [R/W]: DSMF Y Variable Coefficient04_10, Filter 2
  volatile uint32_t DSMF_YVC11_12_F2;  ///< 0x138 [R/W]: DSMF Y Variable Coefficient11_12, Filter 2
  volatile uint32_t DSMF_YVC13_14_F2;  ///< 0x13c [R/W]: DSMF Y Variable Coefficient13_14, Filter 2
  volatile uint32_t DSMF_YVC20_21_F2;  ///< 0x140 [R/W]: DSMF Y Variable Coefficient20_21, Filter 2
  volatile uint32_t DSMF_YVC22_23_F2;  ///< 0x144 [R/W]: DSMF Y Variable Coefficient22_23, Filter 2
  volatile uint32_t DSMF_YVC24_F2;  ///< 0x148 [R/W]: DSMF Y Variable Coefficient24, Filter 2
  volatile uint32_t DSMF_YVC30_31_F2;  ///< 0x14c [R/W]: DSMF Y Variable Coefficient30_31, Filter 2
  volatile uint32_t DSMF_YVC32_33_F2;  ///< 0x150 [R/W]: DSMF Y Variable Coefficient32_33, Filter 2
  volatile uint32_t DSMF_YVC34_40_F2;  ///< 0x154 [R/W]: DSMF Y Variable Coefficient34_40, Filter 2
  volatile uint32_t DSMF_YVC41_42_F2;  ///< 0x158 [R/W]: DSMF Y Variable Coefficient41_42, Filter 2
  volatile uint32_t DSMF_YVC43_44_F2;  ///< 0x15c [R/W]: DSMF Y Variable Coefficient43_44, Filter 2
  volatile uint32_t DSMF_CVC00_01_F2;  ///< 0x160 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 2
  volatile uint32_t DSMF_CVC02_03_F2;  ///< 0x164 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 2
  volatile uint32_t DSMF_CVC04_10_F2;  ///< 0x168 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 2
  volatile uint32_t DSMF_CVC11_12_F2;  ///< 0x16c [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 2
  volatile uint32_t DSMF_CVC13_14_F2;  ///< 0x170 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 2
  volatile uint32_t DSMF_CVC20_21_F2;  ///< 0x174 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 2
  volatile uint32_t DSMF_CVC22_23_F2;  ///< 0x178 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 2
  volatile uint32_t DSMF_CVC24_F2;  ///< 0x17c [R/W]: DSMF Chroma Variable Coefficient24, Filter 2
  volatile uint32_t DSMF_CVC30_31_F2;  ///< 0x180 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 2
  volatile uint32_t DSMF_CVC32_33_F2;  ///< 0x184 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 2
  volatile uint32_t DSMF_CVC34_40_F2;  ///< 0x188 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 2
  volatile uint32_t DSMF_CVC41_42_F2;  ///< 0x18c [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 2
  volatile uint32_t DSMF_CVC43_44_F2;  ///< 0x190 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 2
  volatile uint32_t DSMF_FILT_MULT_F2;  ///< 0x194 [R/W]: DSMF Filter Sum Multiplier, Filter 2
  volatile uint32_t DSMF_FILT_SHIFT_F2;  ///< 0x198 [R/W]: DSMF Filter Sum Shift Factor, Filter 2
  volatile uint32_t DSMF_YVC00_01_F3;  ///< 0x19c [R/W]: DSMF Y Variable Coefficient00_01, Filter 3
  volatile uint32_t DSMF_YVC02_03_F3;  ///< 0x1a0 [R/W]: DSMF Y Variable Coefficient02_03, Filter 3
  volatile uint32_t DSMF_YVC04_10_F3;  ///< 0x1a4 [R/W]: DSMF Y Variable Coefficient04_10, Filter 3
  volatile uint32_t DSMF_YVC11_12_F3;  ///< 0x1a8 [R/W]: DSMF Y Variable Coefficient11_12, Filter 3
  volatile uint32_t DSMF_YVC13_14_F3;  ///< 0x1ac [R/W]: DSMF Y Variable Coefficient13_14, Filter 3
  volatile uint32_t DSMF_YVC20_21_F3;  ///< 0x1b0 [R/W]: DSMF Y Variable Coefficient20_21, Filter 3
  volatile uint32_t DSMF_YVC22_23_F3;  ///< 0x1b4 [R/W]: DSMF Y Variable Coefficient22_23, Filter 3
  volatile uint32_t DSMF_YVC24_F3;  ///< 0x1b8 [R/W]: DSMF Y Variable Coefficient24, Filter 3
  volatile uint32_t DSMF_YVC30_31_F3;  ///< 0x1bc [R/W]: DSMF Y Variable Coefficient30_31, Filter 3
  volatile uint32_t DSMF_YVC32_33_F3;  ///< 0x1c0 [R/W]: DSMF Y Variable Coefficient32_33, Filter 3
  volatile uint32_t DSMF_YVC34_40_F3;  ///< 0x1c4 [R/W]: DSMF Y Variable Coefficient34_40, Filter 3
  volatile uint32_t DSMF_YVC41_42_F3;  ///< 0x1c8 [R/W]: DSMF Y Variable Coefficient41_42, Filter 3
  volatile uint32_t DSMF_YVC43_44_F3;  ///< 0x1cc [R/W]: DSMF Y Variable Coefficient43_44, Filter 3
  volatile uint32_t DSMF_CVC00_01_F3;  ///< 0x1d0 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 3
  volatile uint32_t DSMF_CVC02_03_F3;  ///< 0x1d4 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 3
  volatile uint32_t DSMF_CVC04_10_F3;  ///< 0x1d8 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 3
  volatile uint32_t DSMF_CVC11_12_F3;  ///< 0x1dc [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 3
  volatile uint32_t DSMF_CVC13_14_F3;  ///< 0x1e0 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 3
  volatile uint32_t DSMF_CVC20_21_F3;  ///< 0x1e4 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 3
  volatile uint32_t DSMF_CVC22_23_F3;  ///< 0x1e8 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 3
  volatile uint32_t DSMF_CVC24_F3;  ///< 0x1ec [R/W]: DSMF Chroma Variable Coefficient24, Filter 3
  volatile uint32_t DSMF_CVC30_31_F3;  ///< 0x1f0 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 3
  volatile uint32_t DSMF_CVC32_33_F3;  ///< 0x1f4 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 3
  volatile uint32_t DSMF_CVC34_40_F3;  ///< 0x1f8 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 3
  volatile uint32_t DSMF_CVC41_42_F3;  ///< 0x1fc [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 3
  volatile uint32_t DSMF_CVC43_44_F3;  ///< 0x200 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 3
  volatile uint32_t DSMF_FILT_MULT_F3;  ///< 0x204 [R/W]: DSMF Filter Sum Multiplier, Filter 3
  volatile uint32_t DSMF_FILT_SHIFT_F3;  ///< 0x208 [R/W]: DSMF Filter Sum Shift Factor, Filter 3
  volatile uint32_t DSMF_AVG_MASK;  ///< 0x20c [R/W]: DSMF Average Mask Mode
  volatile uint32_t DSMF_FILT_CTL_LUT[16];  ///< 0x210 [R/W]: DSMF Filter Control LUT
  volatile uint32_t reserved0[108];
  volatile uint32_t DSMF_SEG_PROJ_LUT[256];  ///< 0x400 [R/W]: DSMF Segmentation / Projection LUT
  volatile uint32_t reserved1[256];
  volatile uint32_t DSMF_AI_LUT0[64];  ///< 0xc00 [R/W]: DSMF Activity Index LUT 0
  volatile uint32_t reserved2[192];
  volatile uint32_t DSMF_AI_LUT1[64];  ///< 0x1000 [R/W]: DSMF Activity Index LUT 1
  volatile uint32_t REV0;  ///< 0x1100 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1104 [R]: IP Tagging Revision 1
} DSMF_REGS_t;

#endif // DSMF
