 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DSMF_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DSMF_REGMASKS_H_
#define _DSMF_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DSMF (DSMF)
/** \brief Register Descriptions for the Descreen / MultiFilter block
(rev 0 . 1 . 0 . 0)*/
//
//====================================================================

//====================================================================
//Register: DSMF Control Register (DSMF_Ctl)
/** \brief General configuration register for DSMF module*/
//====================================================================

#define  DSMF_DSMF_CTL_RESERVED1_MASK 0xfc000000
#define  DSMF_DSMF_CTL_RESERVED1_SHIFT 26
#define  DSMF_DSMF_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED1_MASK) >> DSMF_DSMF_CTL_RESERVED1_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED1_SHIFT))

#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK 0x2000000
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT 25
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK) >> DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT)
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT))

#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK 0x1000000
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT 24
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK) >> DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT)
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK 0x800000
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT 23
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK) >> DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_FILT_MASK 0x400000
#define  DSMF_DSMF_CTL_BYPASS_FILT_SHIFT 22
#define  DSMF_DSMF_CTL_BYPASS_FILT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_FILT_MASK) >> DSMF_DSMF_CTL_BYPASS_FILT_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_FILT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_FILT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_FILT_SHIFT))

#define  DSMF_DSMF_CTL_WIN_SHRINK_MASK 0x300000
#define  DSMF_DSMF_CTL_WIN_SHRINK_SHIFT 20
#define  DSMF_DSMF_CTL_WIN_SHRINK_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_WIN_SHRINK_MASK) >> DSMF_DSMF_CTL_WIN_SHRINK_SHIFT)
#define  DSMF_DSMF_CTL_WIN_SHRINK_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_WIN_SHRINK_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_WIN_SHRINK_SHIFT))

#define  DSMF_DSMF_CTL_FILT_IDX_SEL_MASK 0xf0000
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT 16
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_FILT_IDX_SEL_MASK) >> DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT)
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_FILT_IDX_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT))

#define  DSMF_DSMF_CTL_OT_OUT_SEL_MASK 0xf000
#define  DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT 12
#define  DSMF_DSMF_CTL_OT_OUT_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_OT_OUT_SEL_MASK) >> DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT)
#define  DSMF_DSMF_CTL_OT_OUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_OT_OUT_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT))

#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK 0x800
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT 11
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK) >> DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT)
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT))

#define  DSMF_DSMF_CTL_RESERVED2_MASK 0x600
#define  DSMF_DSMF_CTL_RESERVED2_SHIFT 9
#define  DSMF_DSMF_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED2_MASK) >> DSMF_DSMF_CTL_RESERVED2_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED2_SHIFT))

#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK 0x100
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT 8
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK) >> DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT)
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT))

#define  DSMF_DSMF_CTL_TEST_MIXED_MASK 0x80
#define  DSMF_DSMF_CTL_TEST_MIXED_SHIFT 7
#define  DSMF_DSMF_CTL_TEST_MIXED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_MIXED_MASK) >> DSMF_DSMF_CTL_TEST_MIXED_SHIFT)
#define  DSMF_DSMF_CTL_TEST_MIXED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_MIXED_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_MIXED_SHIFT))

#define  DSMF_DSMF_CTL_TEST_HALFTONE_MASK 0x40
#define  DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT 6
#define  DSMF_DSMF_CTL_TEST_HALFTONE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_HALFTONE_MASK) >> DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT)
#define  DSMF_DSMF_CTL_TEST_HALFTONE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_HALFTONE_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT))

#define  DSMF_DSMF_CTL_TEST_TEXT_MASK 0x20
#define  DSMF_DSMF_CTL_TEST_TEXT_SHIFT 5
#define  DSMF_DSMF_CTL_TEST_TEXT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_TEXT_MASK) >> DSMF_DSMF_CTL_TEST_TEXT_SHIFT)
#define  DSMF_DSMF_CTL_TEST_TEXT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_TEXT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_TEXT_SHIFT))

#define  DSMF_DSMF_CTL_TEST_ISOLATED_MASK 0x10
#define  DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT 4
#define  DSMF_DSMF_CTL_TEST_ISOLATED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_ISOLATED_MASK) >> DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT)
#define  DSMF_DSMF_CTL_TEST_ISOLATED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_ISOLATED_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT))

#define  DSMF_DSMF_CTL_RESERVED3_MASK 0xe
#define  DSMF_DSMF_CTL_RESERVED3_SHIFT 1
#define  DSMF_DSMF_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED3_MASK) >> DSMF_DSMF_CTL_RESERVED3_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED3_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_ALL_MASK 0x1
#define  DSMF_DSMF_CTL_BYPASS_ALL_SHIFT 0
#define  DSMF_DSMF_CTL_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_ALL_MASK) >> DSMF_DSMF_CTL_BYPASS_ALL_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_ALL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_ALL_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Horizontal and Vertical Projection Register (DSMF_Seg_HV_Proj)
/** \brief Horizontal and Vertical Projection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK 0xc0000000
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT 30
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK) >> DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK 0x3fff0000
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT 16
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK) >> DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK 0xc000
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT 14
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK) >> DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK 0x3fff
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT 0
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK) >> DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Diagonal Projection Register (DSMF_Seg_Diag_Proj)
/** \brief Diagonal Projection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK 0xffffe000
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT 13
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK) >> DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK 0x1fff
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT 0
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK) >> DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT)
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Isolated Detection Register (DSMF_Seg_Isolated)
/** \brief Isolated Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK) >> DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 3x3 Text Detection Register (DSMF_Seg_3x3_Text)
/** \brief 3x3 Text Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 3x3 Mixed Detection Register (DSMF_Seg_3x3_Mixed)
/** \brief 3x3 Mixed Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 5x5 Text Detection Register (DSMF_Seg_5x5_Text)
/** \brief 5x5 Text Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 5x5 Mixed Detection Register (DSMF_Seg_5x5_Mixed)
/** \brief 5x5 Mixed Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Line Detection Register (DSMF_Seg_Line)
/** \brief Line Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_LINE_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT 16
#define  DSMF_DSMF_SEG_LINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_RESERVED1_MASK) >> DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK) >> DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT)
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT))

#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK 0xff
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT 0
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK) >> DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Line Diagonal Detection Register (DSMF_Seg_Line_Diag)
/** \brief Line Diagonal Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK 0xff0000
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT 16
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK 0xff00
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT 8
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT))

//====================================================================
//Register: DSMF Sculptor Configuration 1 Register (DSMF_SCR1)
//====================================================================

#define  DSMF_DSMF_SCR1_OFFSET_MASK 0xff800000
#define  DSMF_DSMF_SCR1_OFFSET_SHIFT 23
#define  DSMF_DSMF_SCR1_OFFSET_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_OFFSET_MASK) >> DSMF_DSMF_SCR1_OFFSET_SHIFT)
#define  DSMF_DSMF_SCR1_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_OFFSET_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_OFFSET_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED1_MASK 0x400000
#define  DSMF_DSMF_SCR1_RESERVED1_SHIFT 22
#define  DSMF_DSMF_SCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED1_MASK) >> DSMF_DSMF_SCR1_RESERVED1_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED1_SHIFT))

#define  DSMF_DSMF_SCR1_LUT_SCALE_MASK 0x300000
#define  DSMF_DSMF_SCR1_LUT_SCALE_SHIFT 20
#define  DSMF_DSMF_SCR1_LUT_SCALE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_LUT_SCALE_MASK) >> DSMF_DSMF_SCR1_LUT_SCALE_SHIFT)
#define  DSMF_DSMF_SCR1_LUT_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_LUT_SCALE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_LUT_SCALE_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED2_MASK 0xc0000
#define  DSMF_DSMF_SCR1_RESERVED2_SHIFT 18
#define  DSMF_DSMF_SCR1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED2_MASK) >> DSMF_DSMF_SCR1_RESERVED2_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED2_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_2_MASK 0x30000
#define  DSMF_DSMF_SCR1_SCALE_2_SHIFT 16
#define  DSMF_DSMF_SCR1_SCALE_2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_2_MASK) >> DSMF_DSMF_SCR1_SCALE_2_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_2_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED3_MASK 0xc000
#define  DSMF_DSMF_SCR1_RESERVED3_SHIFT 14
#define  DSMF_DSMF_SCR1_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED3_MASK) >> DSMF_DSMF_SCR1_RESERVED3_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED3_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_1_5_MASK 0x3000
#define  DSMF_DSMF_SCR1_SCALE_1_5_SHIFT 12
#define  DSMF_DSMF_SCR1_SCALE_1_5_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_1_5_MASK) >> DSMF_DSMF_SCR1_SCALE_1_5_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_1_5_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_1_5_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_1_5_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED4_MASK 0xc00
#define  DSMF_DSMF_SCR1_RESERVED4_SHIFT 10
#define  DSMF_DSMF_SCR1_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED4_MASK) >> DSMF_DSMF_SCR1_RESERVED4_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED4_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_MASK 0x300
#define  DSMF_DSMF_SCR1_SCALE_SHIFT 8
#define  DSMF_DSMF_SCR1_SCALE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_MASK) >> DSMF_DSMF_SCR1_SCALE_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED5_MASK 0xff
#define  DSMF_DSMF_SCR1_RESERVED5_SHIFT 0
#define  DSMF_DSMF_SCR1_RESERVED5_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED5_MASK) >> DSMF_DSMF_SCR1_RESERVED5_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED5_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED5_SHIFT))

//====================================================================
//Register: DSMF Sculptor Configuration 2 Register (DSMF_SCR2)
//====================================================================

#define  DSMF_DSMF_SCR2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_SCR2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_SCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED1_MASK) >> DSMF_DSMF_SCR2_RESERVED1_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED1_SHIFT))

#define  DSMF_DSMF_SCR2_EN_EROSION_MASK 0x10000000
#define  DSMF_DSMF_SCR2_EN_EROSION_SHIFT 28
#define  DSMF_DSMF_SCR2_EN_EROSION_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_EN_EROSION_MASK) >> DSMF_DSMF_SCR2_EN_EROSION_SHIFT)
#define  DSMF_DSMF_SCR2_EN_EROSION_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_EN_EROSION_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_EN_EROSION_SHIFT))

#define  DSMF_DSMF_SCR2_RESERVED2_MASK 0xe000000
#define  DSMF_DSMF_SCR2_RESERVED2_SHIFT 25
#define  DSMF_DSMF_SCR2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED2_MASK) >> DSMF_DSMF_SCR2_RESERVED2_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED2_SHIFT))

#define  DSMF_DSMF_SCR2_EN_DILATION_MASK 0x1000000
#define  DSMF_DSMF_SCR2_EN_DILATION_SHIFT 24
#define  DSMF_DSMF_SCR2_EN_DILATION_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_EN_DILATION_MASK) >> DSMF_DSMF_SCR2_EN_DILATION_SHIFT)
#define  DSMF_DSMF_SCR2_EN_DILATION_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_EN_DILATION_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_EN_DILATION_SHIFT))

#define  DSMF_DSMF_SCR2_RESERVED3_MASK 0xfffffe
#define  DSMF_DSMF_SCR2_RESERVED3_SHIFT 1
#define  DSMF_DSMF_SCR2_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED3_MASK) >> DSMF_DSMF_SCR2_RESERVED3_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED3_SHIFT))

#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK 0x1
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT 0
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK) >> DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT)
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 1 Register (DSMF_TEL1R)
//====================================================================

#define  DSMF_DSMF_TEL1R_RESERVED1_MASK 0x80000000
#define  DSMF_DSMF_TEL1R_RESERVED1_SHIFT 31
#define  DSMF_DSMF_TEL1R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED1_MASK) >> DSMF_DSMF_TEL1R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL1R_CENTERCMAX_MASK 0x7f000000
#define  DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT 24
#define  DSMF_DSMF_TEL1R_CENTERCMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_CENTERCMAX_MASK) >> DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT)
#define  DSMF_DSMF_TEL1R_CENTERCMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_CENTERCMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED2_MASK 0xc00000
#define  DSMF_DSMF_TEL1R_RESERVED2_SHIFT 22
#define  DSMF_DSMF_TEL1R_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED2_MASK) >> DSMF_DSMF_TEL1R_RESERVED2_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED2_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTBWMIN_MASK 0x3f0000
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT 16
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTBWMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTBWMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED3_MASK 0xe000
#define  DSMF_DSMF_TEL1R_RESERVED3_SHIFT 13
#define  DSMF_DSMF_TEL1R_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED3_MASK) >> DSMF_DSMF_TEL1R_RESERVED3_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED3_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTWMIN_MASK 0x1f00
#define  DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT 8
#define  DSMF_DSMF_TEL1R_COUNTWMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTWMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTWMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTWMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED4_MASK 0xe0
#define  DSMF_DSMF_TEL1R_RESERVED4_SHIFT 5
#define  DSMF_DSMF_TEL1R_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED4_MASK) >> DSMF_DSMF_TEL1R_RESERVED4_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED4_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTBMIN_MASK 0x1f
#define  DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT 0
#define  DSMF_DSMF_TEL1R_COUNTBMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTBMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTBMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTBMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 2 Register (DSMF_TEL2R)
//====================================================================

#define  DSMF_DSMF_TEL2R_RESERVED1_MASK 0xffffff80
#define  DSMF_DSMF_TEL2R_RESERVED1_SHIFT 7
#define  DSMF_DSMF_TEL2R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL2R_RESERVED1_MASK) >> DSMF_DSMF_TEL2R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL2R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL2R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL2R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL2R_CMAX_MASK 0x7f
#define  DSMF_DSMF_TEL2R_CMAX_SHIFT 0
#define  DSMF_DSMF_TEL2R_CMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL2R_CMAX_MASK) >> DSMF_DSMF_TEL2R_CMAX_SHIFT)
#define  DSMF_DSMF_TEL2R_CMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL2R_CMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL2R_CMAX_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 3 Register (DSMF_TEL3R)
//====================================================================

#define  DSMF_DSMF_TEL3R_RESERVED1_MASK 0x80000000
#define  DSMF_DSMF_TEL3R_RESERVED1_SHIFT 31
#define  DSMF_DSMF_TEL3R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED1_MASK) >> DSMF_DSMF_TEL3R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK 0x7f000000
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT 24
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK) >> DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED2_MASK 0x800000
#define  DSMF_DSMF_TEL3R_RESERVED2_SHIFT 23
#define  DSMF_DSMF_TEL3R_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED2_MASK) >> DSMF_DSMF_TEL3R_RESERVED2_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED2_SHIFT))

#define  DSMF_DSMF_TEL3R_WHITEYMIN_MASK 0x7f0000
#define  DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT 16
#define  DSMF_DSMF_TEL3R_WHITEYMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_WHITEYMIN_MASK) >> DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT)
#define  DSMF_DSMF_TEL3R_WHITEYMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_WHITEYMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED3_MASK 0x8000
#define  DSMF_DSMF_TEL3R_RESERVED3_SHIFT 15
#define  DSMF_DSMF_TEL3R_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED3_MASK) >> DSMF_DSMF_TEL3R_RESERVED3_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED3_SHIFT))

#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK 0x7f00
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT 8
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK) >> DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED4_MASK 0x80
#define  DSMF_DSMF_TEL3R_RESERVED4_SHIFT 7
#define  DSMF_DSMF_TEL3R_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED4_MASK) >> DSMF_DSMF_TEL3R_RESERVED4_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED4_SHIFT))

#define  DSMF_DSMF_TEL3R_BLACKYMAX_MASK 0x7f
#define  DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT 0
#define  DSMF_DSMF_TEL3R_BLACKYMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_BLACKYMAX_MASK) >> DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_BLACKYMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_BLACKYMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT))

//====================================================================
//Register: DSMF Edge Count Compare (DSMF_EC_COMPARE)
//====================================================================

#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK 0xff000000
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT 24
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK) >> DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT)
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT))

#define  DSMF_DSMF_EC_COMPARE_RESERVED1_MASK 0xffffff
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT 0
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_COMPARE_RESERVED1_MASK) >> DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_COMPARE_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT))

//====================================================================
//Register: DSMF Edge Count Write (DSMF_EC_WR)
//====================================================================

#define  DSMF_DSMF_EC_WR_RESERVED1_MASK 0xfe000000
#define  DSMF_DSMF_EC_WR_RESERVED1_SHIFT 25
#define  DSMF_DSMF_EC_WR_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_RESERVED1_MASK) >> DSMF_DSMF_EC_WR_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_RESERVED1_SHIFT))

#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK 0x1000000
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT 24
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK) >> DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT)
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT))

#define  DSMF_DSMF_EC_WR_EDGE_COUNT_MASK 0xffffff
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT 0
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_EDGE_COUNT_MASK) >> DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT)
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_EDGE_COUNT_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT))

//====================================================================
//Register: DSMF Edge Count Observation (DSMF_EC_OBS)
//====================================================================

#define  DSMF_DSMF_EC_OBS_RESERVED1_MASK 0xfe000000
#define  DSMF_DSMF_EC_OBS_RESERVED1_SHIFT 25
#define  DSMF_DSMF_EC_OBS_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_RESERVED1_MASK) >> DSMF_DSMF_EC_OBS_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_OBS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_RESERVED1_SHIFT))

#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK 0x1000000
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT 24
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK) >> DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT)
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT))

#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK 0xffffff
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT 0
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK) >> DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT)
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT))

//====================================================================
//Register: DSMF Edge Count Indices (DSMF_ECI)
//====================================================================

#define  DSMF_DSMF_ECI_RESERVED1_MASK 0xffe00000
#define  DSMF_DSMF_ECI_RESERVED1_SHIFT 21
#define  DSMF_DSMF_ECI_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED1_MASK) >> DSMF_DSMF_ECI_RESERVED1_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED1_SHIFT))

#define  DSMF_DSMF_ECI_EC_RST_IDX_MASK 0x1f0000
#define  DSMF_DSMF_ECI_EC_RST_IDX_SHIFT 16
#define  DSMF_DSMF_ECI_EC_RST_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_RST_IDX_MASK) >> DSMF_DSMF_ECI_EC_RST_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_RST_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_RST_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_RST_IDX_SHIFT))

#define  DSMF_DSMF_ECI_RESERVED2_MASK 0xe000
#define  DSMF_DSMF_ECI_RESERVED2_SHIFT 13
#define  DSMF_DSMF_ECI_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED2_MASK) >> DSMF_DSMF_ECI_RESERVED2_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED2_SHIFT))

#define  DSMF_DSMF_ECI_EC_END_IDX_MASK 0x1f00
#define  DSMF_DSMF_ECI_EC_END_IDX_SHIFT 8
#define  DSMF_DSMF_ECI_EC_END_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_END_IDX_MASK) >> DSMF_DSMF_ECI_EC_END_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_END_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_END_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_END_IDX_SHIFT))

#define  DSMF_DSMF_ECI_RESERVED3_MASK 0xe0
#define  DSMF_DSMF_ECI_RESERVED3_SHIFT 5
#define  DSMF_DSMF_ECI_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED3_MASK) >> DSMF_DSMF_ECI_RESERVED3_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED3_SHIFT))

#define  DSMF_DSMF_ECI_EC_ST_IDX_MASK 0x1f
#define  DSMF_DSMF_ECI_EC_ST_IDX_SHIFT 0
#define  DSMF_DSMF_ECI_EC_ST_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_ST_IDX_MASK) >> DSMF_DSMF_ECI_EC_ST_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_ST_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_ST_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_ST_IDX_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 0 (DSMF_YVC00_01)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 0.
The following table is for reference to understand the names of the
coefficients with their position in a 9x9 pixel window.
<table>
<tr><td>Coef00</td><td>Coef01</td></td><td>Coef02</td><td>Coef03</td><td>Coef04</td><td>Coef03</td><td>Coef02</td><td>Coef01</td><td>Coef00</td></td></td></tr>
<tr><td>Coef10</td><td>Coef11</td></td><td>Coef12</td><td>Coef13</td><td>Coef14</td><td>Coef13</td><td>Coef12</td><td>Coef11</td><td>Coef10</td></td></td></tr>
<tr><td>Coef20</td><td>Coef21</td></td><td>Coef22</td><td>Coef23</td><td>Coef24</td><td>Coef23</td><td>Coef22</td><td>Coef21</td><td>Coef20</td></td></td></tr>
<tr><td>Coef30</td><td>Coef31</td></td><td>Coef32</td><td>Coef33</td><td>Coef34</td><td>Coef33</td><td>Coef32</td><td>Coef31</td><td>Coef30</td></td></td></tr>
<tr><td>Coef40</td><td>Coef41</td></td><td>Coef42</td><td>Coef43</td><td>Coef44</td><td>Coef43</td><td>Coef42</td><td>Coef41</td><td>Coef40</td></td></td></tr>
<tr><td>Coef30</td><td>Coef31</td></td><td>Coef32</td><td>Coef33</td><td>Coef34</td><td>Coef33</td><td>Coef32</td><td>Coef31</td><td>Coef30</td></td></td></tr>
<tr><td>Coef20</td><td>Coef21</td></td><td>Coef22</td><td>Coef23</td><td>Coef24</td><td>Coef23</td><td>Coef22</td><td>Coef21</td><td>Coef20</td></td></td></tr>
<tr><td>Coef10</td><td>Coef11</td></td><td>Coef12</td><td>Coef13</td><td>Coef14</td><td>Coef13</td><td>Coef11</td><td>Coef11</td><td>Coef10</td></td></td></tr>
<tr><td>Coef00</td><td>Coef01</td></td><td>Coef02</td><td>Coef03</td><td>Coef04</td><td>Coef03</td><td>Coef02</td><td>Coef01</td><td>Coef00</td></td></td></tr>
</table>*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_B_MASK) >> DSMF_DSMF_YVC00_01_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_A_MASK) >> DSMF_DSMF_YVC00_01_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 0 (DSMF_YVC02_03)
//====================================================================

#define  DSMF_DSMF_YVC02_03_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_B_MASK) >> DSMF_DSMF_YVC02_03_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_A_MASK) >> DSMF_DSMF_YVC02_03_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 0 (DSMF_YVC04_10)
//====================================================================

#define  DSMF_DSMF_YVC04_10_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_B_MASK) >> DSMF_DSMF_YVC04_10_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_A_MASK) >> DSMF_DSMF_YVC04_10_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 0 (DSMF_YVC11_12)
//====================================================================

#define  DSMF_DSMF_YVC11_12_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_B_MASK) >> DSMF_DSMF_YVC11_12_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_A_MASK) >> DSMF_DSMF_YVC11_12_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 0 (DSMF_YVC13_14)
//====================================================================

#define  DSMF_DSMF_YVC13_14_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_B_MASK) >> DSMF_DSMF_YVC13_14_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_A_MASK) >> DSMF_DSMF_YVC13_14_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 0 (DSMF_YVC20_21)
//====================================================================

#define  DSMF_DSMF_YVC20_21_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_B_MASK) >> DSMF_DSMF_YVC20_21_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_A_MASK) >> DSMF_DSMF_YVC20_21_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 0 (DSMF_YVC22_23)
//====================================================================

#define  DSMF_DSMF_YVC22_23_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_B_MASK) >> DSMF_DSMF_YVC22_23_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_A_MASK) >> DSMF_DSMF_YVC22_23_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 0 (DSMF_YVC24)
//====================================================================

#define  DSMF_DSMF_YVC24_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_RESERVED1_MASK) >> DSMF_DSMF_YVC24_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_A_SHIFT 0
#define  DSMF_DSMF_YVC24_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_A_MASK) >> DSMF_DSMF_YVC24_A_SHIFT)
#define  DSMF_DSMF_YVC24_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 0 (DSMF_YVC30_31)
//====================================================================

#define  DSMF_DSMF_YVC30_31_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_B_MASK) >> DSMF_DSMF_YVC30_31_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_A_MASK) >> DSMF_DSMF_YVC30_31_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 0 (DSMF_YVC32_33)
//====================================================================

#define  DSMF_DSMF_YVC32_33_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_B_MASK) >> DSMF_DSMF_YVC32_33_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_A_MASK) >> DSMF_DSMF_YVC32_33_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 0 (DSMF_YVC34_40)
//====================================================================

#define  DSMF_DSMF_YVC34_40_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_B_MASK) >> DSMF_DSMF_YVC34_40_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_A_MASK) >> DSMF_DSMF_YVC34_40_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 0 (DSMF_YVC41_42)
//====================================================================

#define  DSMF_DSMF_YVC41_42_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_B_MASK) >> DSMF_DSMF_YVC41_42_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_A_MASK) >> DSMF_DSMF_YVC41_42_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 0 (DSMF_YVC43_44)
//====================================================================

#define  DSMF_DSMF_YVC43_44_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_B_MASK) >> DSMF_DSMF_YVC43_44_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_A_MASK) >> DSMF_DSMF_YVC43_44_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 0 (DSMF_CVC00_01)
//====================================================================

#define  DSMF_DSMF_CVC00_01_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_B_MASK) >> DSMF_DSMF_CVC00_01_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_A_MASK) >> DSMF_DSMF_CVC00_01_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 0 (DSMF_CVC02_03)
//====================================================================

#define  DSMF_DSMF_CVC02_03_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_B_MASK) >> DSMF_DSMF_CVC02_03_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_A_MASK) >> DSMF_DSMF_CVC02_03_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 0 (DSMF_CVC04_10)
//====================================================================

#define  DSMF_DSMF_CVC04_10_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_B_MASK) >> DSMF_DSMF_CVC04_10_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_A_MASK) >> DSMF_DSMF_CVC04_10_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 0 (DSMF_CVC11_12)
//====================================================================

#define  DSMF_DSMF_CVC11_12_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_B_MASK) >> DSMF_DSMF_CVC11_12_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_A_MASK) >> DSMF_DSMF_CVC11_12_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 0 (DSMF_CVC13_14)
//====================================================================

#define  DSMF_DSMF_CVC13_14_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_B_MASK) >> DSMF_DSMF_CVC13_14_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_A_MASK) >> DSMF_DSMF_CVC13_14_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 0 (DSMF_CVC20_21)
//====================================================================

#define  DSMF_DSMF_CVC20_21_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_B_MASK) >> DSMF_DSMF_CVC20_21_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_A_MASK) >> DSMF_DSMF_CVC20_21_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 0 (DSMF_CVC22_23)
//====================================================================

#define  DSMF_DSMF_CVC22_23_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_B_MASK) >> DSMF_DSMF_CVC22_23_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_A_MASK) >> DSMF_DSMF_CVC22_23_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 0 (DSMF_CVC24)
//====================================================================

#define  DSMF_DSMF_CVC24_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_RESERVED1_MASK) >> DSMF_DSMF_CVC24_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_A_SHIFT 0
#define  DSMF_DSMF_CVC24_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_A_MASK) >> DSMF_DSMF_CVC24_A_SHIFT)
#define  DSMF_DSMF_CVC24_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 0 (DSMF_CVC30_31)
//====================================================================

#define  DSMF_DSMF_CVC30_31_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_B_MASK) >> DSMF_DSMF_CVC30_31_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_A_MASK) >> DSMF_DSMF_CVC30_31_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 0 (DSMF_CVC32_33)
//====================================================================

#define  DSMF_DSMF_CVC32_33_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_B_MASK) >> DSMF_DSMF_CVC32_33_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_A_MASK) >> DSMF_DSMF_CVC32_33_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 0 (DSMF_CVC34_40)
//====================================================================

#define  DSMF_DSMF_CVC34_40_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_B_MASK) >> DSMF_DSMF_CVC34_40_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_A_MASK) >> DSMF_DSMF_CVC34_40_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 0 (DSMF_CVC41_42)
//====================================================================

#define  DSMF_DSMF_CVC41_42_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_B_MASK) >> DSMF_DSMF_CVC41_42_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_A_MASK) >> DSMF_DSMF_CVC41_42_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 0 (DSMF_CVC43_44)
//====================================================================

#define  DSMF_DSMF_CVC43_44_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_B_MASK) >> DSMF_DSMF_CVC43_44_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_A_MASK) >> DSMF_DSMF_CVC43_44_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 0 (DSMF_FILT_MULT)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 0 (DSMF_FILT_SHIFT)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 1 (DSMF_YVC00_01_F1)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 1.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_B_MASK) >> DSMF_DSMF_YVC00_01_F1_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_A_MASK) >> DSMF_DSMF_YVC00_01_F1_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 1 (DSMF_YVC02_03_F1)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_B_MASK) >> DSMF_DSMF_YVC02_03_F1_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_A_MASK) >> DSMF_DSMF_YVC02_03_F1_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 1 (DSMF_YVC04_10_F1)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_B_MASK) >> DSMF_DSMF_YVC04_10_F1_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_A_MASK) >> DSMF_DSMF_YVC04_10_F1_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 1 (DSMF_YVC11_12_F1)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_B_MASK) >> DSMF_DSMF_YVC11_12_F1_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_A_MASK) >> DSMF_DSMF_YVC11_12_F1_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 1 (DSMF_YVC13_14_F1)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_B_MASK) >> DSMF_DSMF_YVC13_14_F1_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_A_MASK) >> DSMF_DSMF_YVC13_14_F1_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 1 (DSMF_YVC20_21_F1)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_B_MASK) >> DSMF_DSMF_YVC20_21_F1_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_A_MASK) >> DSMF_DSMF_YVC20_21_F1_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 1 (DSMF_YVC22_23_F1)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_B_MASK) >> DSMF_DSMF_YVC22_23_F1_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_A_MASK) >> DSMF_DSMF_YVC22_23_F1_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 1 (DSMF_YVC24_F1)
//====================================================================

#define  DSMF_DSMF_YVC24_F1_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F1_A_MASK) >> DSMF_DSMF_YVC24_F1_A_SHIFT)
#define  DSMF_DSMF_YVC24_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 1 (DSMF_YVC30_31_F1)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_B_MASK) >> DSMF_DSMF_YVC30_31_F1_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_A_MASK) >> DSMF_DSMF_YVC30_31_F1_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 1 (DSMF_YVC32_33_F1)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_B_MASK) >> DSMF_DSMF_YVC32_33_F1_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_A_MASK) >> DSMF_DSMF_YVC32_33_F1_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 1 (DSMF_YVC34_40_F1)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_B_MASK) >> DSMF_DSMF_YVC34_40_F1_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_A_MASK) >> DSMF_DSMF_YVC34_40_F1_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 1 (DSMF_YVC41_42_F1)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_B_MASK) >> DSMF_DSMF_YVC41_42_F1_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_A_MASK) >> DSMF_DSMF_YVC41_42_F1_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 1 (DSMF_YVC43_44_F1)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_B_MASK) >> DSMF_DSMF_YVC43_44_F1_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_A_MASK) >> DSMF_DSMF_YVC43_44_F1_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 1 (DSMF_CVC00_01_F1)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_B_MASK) >> DSMF_DSMF_CVC00_01_F1_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_A_MASK) >> DSMF_DSMF_CVC00_01_F1_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 1 (DSMF_CVC02_03_F1)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_B_MASK) >> DSMF_DSMF_CVC02_03_F1_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_A_MASK) >> DSMF_DSMF_CVC02_03_F1_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 1 (DSMF_CVC04_10_F1)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_B_MASK) >> DSMF_DSMF_CVC04_10_F1_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_A_MASK) >> DSMF_DSMF_CVC04_10_F1_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 1 (DSMF_CVC11_12_F1)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_B_MASK) >> DSMF_DSMF_CVC11_12_F1_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_A_MASK) >> DSMF_DSMF_CVC11_12_F1_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 1 (DSMF_CVC13_14_F1)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_B_MASK) >> DSMF_DSMF_CVC13_14_F1_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_A_MASK) >> DSMF_DSMF_CVC13_14_F1_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 1 (DSMF_CVC20_21_F1)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_B_MASK) >> DSMF_DSMF_CVC20_21_F1_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_A_MASK) >> DSMF_DSMF_CVC20_21_F1_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 1 (DSMF_CVC22_23_F1)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_B_MASK) >> DSMF_DSMF_CVC22_23_F1_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_A_MASK) >> DSMF_DSMF_CVC22_23_F1_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 1 (DSMF_CVC24_F1)
//====================================================================

#define  DSMF_DSMF_CVC24_F1_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F1_A_MASK) >> DSMF_DSMF_CVC24_F1_A_SHIFT)
#define  DSMF_DSMF_CVC24_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 1 (DSMF_CVC30_31_F1)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_B_MASK) >> DSMF_DSMF_CVC30_31_F1_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_A_MASK) >> DSMF_DSMF_CVC30_31_F1_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 1 (DSMF_CVC32_33_F1)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_B_MASK) >> DSMF_DSMF_CVC32_33_F1_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_A_MASK) >> DSMF_DSMF_CVC32_33_F1_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 1 (DSMF_CVC34_40_F1)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_B_MASK) >> DSMF_DSMF_CVC34_40_F1_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_A_MASK) >> DSMF_DSMF_CVC34_40_F1_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 1 (DSMF_CVC41_42_F1)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_B_MASK) >> DSMF_DSMF_CVC41_42_F1_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_A_MASK) >> DSMF_DSMF_CVC41_42_F1_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 1 (DSMF_CVC43_44_F1)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_B_MASK) >> DSMF_DSMF_CVC43_44_F1_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_A_MASK) >> DSMF_DSMF_CVC43_44_F1_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 1 (DSMF_FILT_MULT_F1)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 1 (DSMF_FILT_SHIFT_F1)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 2 (DSMF_YVC00_01_F2)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 2.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_B_MASK) >> DSMF_DSMF_YVC00_01_F2_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_A_MASK) >> DSMF_DSMF_YVC00_01_F2_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 2 (DSMF_YVC02_03_F2)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_B_MASK) >> DSMF_DSMF_YVC02_03_F2_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_A_MASK) >> DSMF_DSMF_YVC02_03_F2_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 2 (DSMF_YVC04_10_F2)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_B_MASK) >> DSMF_DSMF_YVC04_10_F2_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_A_MASK) >> DSMF_DSMF_YVC04_10_F2_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 2 (DSMF_YVC11_12_F2)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_B_MASK) >> DSMF_DSMF_YVC11_12_F2_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_A_MASK) >> DSMF_DSMF_YVC11_12_F2_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 2 (DSMF_YVC13_14_F2)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_B_MASK) >> DSMF_DSMF_YVC13_14_F2_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_A_MASK) >> DSMF_DSMF_YVC13_14_F2_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 2 (DSMF_YVC20_21_F2)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_B_MASK) >> DSMF_DSMF_YVC20_21_F2_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_A_MASK) >> DSMF_DSMF_YVC20_21_F2_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 2 (DSMF_YVC22_23_F2)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_B_MASK) >> DSMF_DSMF_YVC22_23_F2_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_A_MASK) >> DSMF_DSMF_YVC22_23_F2_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 2 (DSMF_YVC24_F2)
//====================================================================

#define  DSMF_DSMF_YVC24_F2_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F2_A_MASK) >> DSMF_DSMF_YVC24_F2_A_SHIFT)
#define  DSMF_DSMF_YVC24_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 2 (DSMF_YVC30_31_F2)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_B_MASK) >> DSMF_DSMF_YVC30_31_F2_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_A_MASK) >> DSMF_DSMF_YVC30_31_F2_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 2 (DSMF_YVC32_33_F2)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_B_MASK) >> DSMF_DSMF_YVC32_33_F2_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_A_MASK) >> DSMF_DSMF_YVC32_33_F2_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 2 (DSMF_YVC34_40_F2)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_B_MASK) >> DSMF_DSMF_YVC34_40_F2_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_A_MASK) >> DSMF_DSMF_YVC34_40_F2_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 2 (DSMF_YVC41_42_F2)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_B_MASK) >> DSMF_DSMF_YVC41_42_F2_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_A_MASK) >> DSMF_DSMF_YVC41_42_F2_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 2 (DSMF_YVC43_44_F2)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_B_MASK) >> DSMF_DSMF_YVC43_44_F2_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_A_MASK) >> DSMF_DSMF_YVC43_44_F2_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 2 (DSMF_CVC00_01_F2)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_B_MASK) >> DSMF_DSMF_CVC00_01_F2_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_A_MASK) >> DSMF_DSMF_CVC00_01_F2_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 2 (DSMF_CVC02_03_F2)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_B_MASK) >> DSMF_DSMF_CVC02_03_F2_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_A_MASK) >> DSMF_DSMF_CVC02_03_F2_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 2 (DSMF_CVC04_10_F2)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_B_MASK) >> DSMF_DSMF_CVC04_10_F2_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_A_MASK) >> DSMF_DSMF_CVC04_10_F2_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 2 (DSMF_CVC11_12_F2)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_B_MASK) >> DSMF_DSMF_CVC11_12_F2_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_A_MASK) >> DSMF_DSMF_CVC11_12_F2_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 2 (DSMF_CVC13_14_F2)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_B_MASK) >> DSMF_DSMF_CVC13_14_F2_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_A_MASK) >> DSMF_DSMF_CVC13_14_F2_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 2 (DSMF_CVC20_21_F2)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_B_MASK) >> DSMF_DSMF_CVC20_21_F2_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_A_MASK) >> DSMF_DSMF_CVC20_21_F2_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 2 (DSMF_CVC22_23_F2)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_B_MASK) >> DSMF_DSMF_CVC22_23_F2_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_A_MASK) >> DSMF_DSMF_CVC22_23_F2_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 2 (DSMF_CVC24_F2)
//====================================================================

#define  DSMF_DSMF_CVC24_F2_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F2_A_MASK) >> DSMF_DSMF_CVC24_F2_A_SHIFT)
#define  DSMF_DSMF_CVC24_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 2 (DSMF_CVC30_31_F2)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_B_MASK) >> DSMF_DSMF_CVC30_31_F2_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_A_MASK) >> DSMF_DSMF_CVC30_31_F2_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 2 (DSMF_CVC32_33_F2)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_B_MASK) >> DSMF_DSMF_CVC32_33_F2_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_A_MASK) >> DSMF_DSMF_CVC32_33_F2_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 2 (DSMF_CVC34_40_F2)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_B_MASK) >> DSMF_DSMF_CVC34_40_F2_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_A_MASK) >> DSMF_DSMF_CVC34_40_F2_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 2 (DSMF_CVC41_42_F2)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_B_MASK) >> DSMF_DSMF_CVC41_42_F2_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_A_MASK) >> DSMF_DSMF_CVC41_42_F2_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 2 (DSMF_CVC43_44_F2)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_B_MASK) >> DSMF_DSMF_CVC43_44_F2_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_A_MASK) >> DSMF_DSMF_CVC43_44_F2_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 2 (DSMF_FILT_MULT_F2)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 2 (DSMF_FILT_SHIFT_F2)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 3 (DSMF_YVC00_01_F3)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 3.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_B_MASK) >> DSMF_DSMF_YVC00_01_F3_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_A_MASK) >> DSMF_DSMF_YVC00_01_F3_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 3 (DSMF_YVC02_03_F3)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_B_MASK) >> DSMF_DSMF_YVC02_03_F3_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_A_MASK) >> DSMF_DSMF_YVC02_03_F3_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 3 (DSMF_YVC04_10_F3)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_B_MASK) >> DSMF_DSMF_YVC04_10_F3_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_A_MASK) >> DSMF_DSMF_YVC04_10_F3_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 3 (DSMF_YVC11_12_F3)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_B_MASK) >> DSMF_DSMF_YVC11_12_F3_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_A_MASK) >> DSMF_DSMF_YVC11_12_F3_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 3 (DSMF_YVC13_14_F3)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_B_MASK) >> DSMF_DSMF_YVC13_14_F3_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_A_MASK) >> DSMF_DSMF_YVC13_14_F3_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 3 (DSMF_YVC20_21_F3)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_B_MASK) >> DSMF_DSMF_YVC20_21_F3_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_A_MASK) >> DSMF_DSMF_YVC20_21_F3_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 3 (DSMF_YVC22_23_F3)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_B_MASK) >> DSMF_DSMF_YVC22_23_F3_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_A_MASK) >> DSMF_DSMF_YVC22_23_F3_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 3 (DSMF_YVC24_F3)
//====================================================================

#define  DSMF_DSMF_YVC24_F3_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F3_A_MASK) >> DSMF_DSMF_YVC24_F3_A_SHIFT)
#define  DSMF_DSMF_YVC24_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 3 (DSMF_YVC30_31_F3)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_B_MASK) >> DSMF_DSMF_YVC30_31_F3_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_A_MASK) >> DSMF_DSMF_YVC30_31_F3_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 3 (DSMF_YVC32_33_F3)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_B_MASK) >> DSMF_DSMF_YVC32_33_F3_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_A_MASK) >> DSMF_DSMF_YVC32_33_F3_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 3 (DSMF_YVC34_40_F3)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_B_MASK) >> DSMF_DSMF_YVC34_40_F3_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_A_MASK) >> DSMF_DSMF_YVC34_40_F3_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 3 (DSMF_YVC41_42_F3)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_B_MASK) >> DSMF_DSMF_YVC41_42_F3_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_A_MASK) >> DSMF_DSMF_YVC41_42_F3_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 3 (DSMF_YVC43_44_F3)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_B_MASK) >> DSMF_DSMF_YVC43_44_F3_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_A_MASK) >> DSMF_DSMF_YVC43_44_F3_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 3 (DSMF_CVC00_01_F3)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_B_MASK) >> DSMF_DSMF_CVC00_01_F3_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_A_MASK) >> DSMF_DSMF_CVC00_01_F3_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 3 (DSMF_CVC02_03_F3)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_B_MASK) >> DSMF_DSMF_CVC02_03_F3_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_A_MASK) >> DSMF_DSMF_CVC02_03_F3_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 3 (DSMF_CVC04_10_F3)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_B_MASK) >> DSMF_DSMF_CVC04_10_F3_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_A_MASK) >> DSMF_DSMF_CVC04_10_F3_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 3 (DSMF_CVC11_12_F3)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_B_MASK) >> DSMF_DSMF_CVC11_12_F3_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_A_MASK) >> DSMF_DSMF_CVC11_12_F3_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 3 (DSMF_CVC13_14_F3)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_B_MASK) >> DSMF_DSMF_CVC13_14_F3_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_A_MASK) >> DSMF_DSMF_CVC13_14_F3_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 3 (DSMF_CVC20_21_F3)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_B_MASK) >> DSMF_DSMF_CVC20_21_F3_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_A_MASK) >> DSMF_DSMF_CVC20_21_F3_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 3 (DSMF_CVC22_23_F3)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_B_MASK) >> DSMF_DSMF_CVC22_23_F3_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_A_MASK) >> DSMF_DSMF_CVC22_23_F3_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 3 (DSMF_CVC24_F3)
//====================================================================

#define  DSMF_DSMF_CVC24_F3_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F3_A_MASK) >> DSMF_DSMF_CVC24_F3_A_SHIFT)
#define  DSMF_DSMF_CVC24_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 3 (DSMF_CVC30_31_F3)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_B_MASK) >> DSMF_DSMF_CVC30_31_F3_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_A_MASK) >> DSMF_DSMF_CVC30_31_F3_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 3 (DSMF_CVC32_33_F3)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_B_MASK) >> DSMF_DSMF_CVC32_33_F3_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_A_MASK) >> DSMF_DSMF_CVC32_33_F3_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 3 (DSMF_CVC34_40_F3)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_B_MASK) >> DSMF_DSMF_CVC34_40_F3_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_A_MASK) >> DSMF_DSMF_CVC34_40_F3_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 3 (DSMF_CVC41_42_F3)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_B_MASK) >> DSMF_DSMF_CVC41_42_F3_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_A_MASK) >> DSMF_DSMF_CVC41_42_F3_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 3 (DSMF_CVC43_44_F3)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_B_MASK) >> DSMF_DSMF_CVC43_44_F3_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_A_MASK) >> DSMF_DSMF_CVC43_44_F3_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 3 (DSMF_FILT_MULT_F3)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 3 (DSMF_FILT_SHIFT_F3)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Average Mask Mode (DSMF_AVG_MASK)
//====================================================================

#define  DSMF_DSMF_AVG_MASK_RESERVED1_MASK 0xfffff000
#define  DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT 12
#define  DSMF_DSMF_AVG_MASK_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_RESERVED1_MASK) >> DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT)
#define  DSMF_DSMF_AVG_MASK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK 0xff0
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT 4
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT))

#define  DSMF_DSMF_AVG_MASK_RESERVED2_MASK 0x8
#define  DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT 3
#define  DSMF_DSMF_AVG_MASK_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_RESERVED2_MASK) >> DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT)
#define  DSMF_DSMF_AVG_MASK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK 0x6
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT 1
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK 0x1
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT 0
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT))

//====================================================================
//Register: DSMF Filter Control LUT (DSMF_FILT_CTL_LUT)
/** \brief Filter Control LUT ;<BR>
       (Note: cpu_access_lut bit must be set to write this LUT) ;<BR>*/
//====================================================================

#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK 0xffffffc0
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT 6
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK) >> DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK 0x3f
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT 0
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK) >> DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT)
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT))

//====================================================================
//Register: DSMF Segmentation / Projection LUT (DSMF_SEG_PROJ_LUT)
//====================================================================

#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK 0xffffff00
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT 8
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK) >> DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_PROJ_LUT_D_MASK 0xff
#define  DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT 0
#define  DSMF_DSMF_SEG_PROJ_LUT_D_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_PROJ_LUT_D_MASK) >> DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT)
#define  DSMF_DSMF_SEG_PROJ_LUT_D_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_PROJ_LUT_D_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT))

//====================================================================
//Register: DSMF Activity Index LUT 0 (DSMF_AI_LUT0)
//====================================================================

#define  DSMF_DSMF_AI_LUT0_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT 16
#define  DSMF_DSMF_AI_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_RESERVED1_MASK) >> DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT)
#define  DSMF_DSMF_AI_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT))

#define  DSMF_DSMF_AI_LUT0_Y_MASK 0xff00
#define  DSMF_DSMF_AI_LUT0_Y_SHIFT 8
#define  DSMF_DSMF_AI_LUT0_Y_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_Y_MASK) >> DSMF_DSMF_AI_LUT0_Y_SHIFT)
#define  DSMF_DSMF_AI_LUT0_Y_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_Y_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_Y_SHIFT))

#define  DSMF_DSMF_AI_LUT0_C_MASK 0xff
#define  DSMF_DSMF_AI_LUT0_C_SHIFT 0
#define  DSMF_DSMF_AI_LUT0_C_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_C_MASK) >> DSMF_DSMF_AI_LUT0_C_SHIFT)
#define  DSMF_DSMF_AI_LUT0_C_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_C_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_C_SHIFT))

//====================================================================
//Register: DSMF Activity Index LUT 1 (DSMF_AI_LUT1)
//====================================================================

#define  DSMF_DSMF_AI_LUT1_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT 16
#define  DSMF_DSMF_AI_LUT1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_RESERVED1_MASK) >> DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT)
#define  DSMF_DSMF_AI_LUT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT))

#define  DSMF_DSMF_AI_LUT1_Y_MASK 0xff00
#define  DSMF_DSMF_AI_LUT1_Y_SHIFT 8
#define  DSMF_DSMF_AI_LUT1_Y_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_Y_MASK) >> DSMF_DSMF_AI_LUT1_Y_SHIFT)
#define  DSMF_DSMF_AI_LUT1_Y_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_Y_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_Y_SHIFT))

#define  DSMF_DSMF_AI_LUT1_C_MASK 0xff
#define  DSMF_DSMF_AI_LUT1_C_SHIFT 0
#define  DSMF_DSMF_AI_LUT1_C_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_C_MASK) >> DSMF_DSMF_AI_LUT1_C_SHIFT)
#define  DSMF_DSMF_AI_LUT1_C_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_C_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_C_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DSMF_REV0_MAJ_MASK 0xffff0000
#define  DSMF_REV0_MAJ_SHIFT 16
#define  DSMF_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DSMF_REV0_MAJ_MASK) >> DSMF_REV0_MAJ_SHIFT)
#define  DSMF_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV0_MAJ_MASK) | (((uint32_t)val) << DSMF_REV0_MAJ_SHIFT))

#define  DSMF_REV0_MID_MASK 0xffff
#define  DSMF_REV0_MID_SHIFT 0
#define  DSMF_REV0_MID_MASK_SHIFT(reg) (((reg) & DSMF_REV0_MID_MASK) >> DSMF_REV0_MID_SHIFT)
#define  DSMF_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV0_MID_MASK) | (((uint32_t)val) << DSMF_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DSMF_REV1_RESERVED1_MASK 0xffff0000
#define  DSMF_REV1_RESERVED1_SHIFT 16
#define  DSMF_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_REV1_RESERVED1_MASK) >> DSMF_REV1_RESERVED1_SHIFT)
#define  DSMF_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_REV1_RESERVED1_SHIFT))

#define  DSMF_REV1_CFG_MASK 0xffff
#define  DSMF_REV1_CFG_SHIFT 0
#define  DSMF_REV1_CFG_MASK_SHIFT(reg) (((reg) & DSMF_REV1_CFG_MASK) >> DSMF_REV1_CFG_SHIFT)
#define  DSMF_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV1_CFG_MASK) | (((uint32_t)val) << DSMF_REV1_CFG_SHIFT))

#endif // DSMF
