 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_REGMASKS_H_
#define _DISTORT_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT Correction (DISTORT)
/** \brief Register file for the DISTORT block
(rev 0 . 4 . 1 . 0)*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DISTORT_REV0_MAJ_MASK 0xffff0000
#define  DISTORT_REV0_MAJ_SHIFT 16
#define  DISTORT_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DISTORT_REV0_MAJ_MASK) >> DISTORT_REV0_MAJ_SHIFT)
#define  DISTORT_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV0_MAJ_MASK) | (((uint32_t)val) << DISTORT_REV0_MAJ_SHIFT))

#define  DISTORT_REV0_MID_MASK 0xffff
#define  DISTORT_REV0_MID_SHIFT 0
#define  DISTORT_REV0_MID_MASK_SHIFT(reg) (((reg) & DISTORT_REV0_MID_MASK) >> DISTORT_REV0_MID_SHIFT)
#define  DISTORT_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV0_MID_MASK) | (((uint32_t)val) << DISTORT_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DISTORT_REV1_RESERVED1_MASK 0xffff0000
#define  DISTORT_REV1_RESERVED1_SHIFT 16
#define  DISTORT_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_REV1_RESERVED1_MASK) >> DISTORT_REV1_RESERVED1_SHIFT)
#define  DISTORT_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_REV1_RESERVED1_SHIFT))

#define  DISTORT_REV1_CFG_MASK 0xffff
#define  DISTORT_REV1_CFG_SHIFT 0
#define  DISTORT_REV1_CFG_MASK_SHIFT(reg) (((reg) & DISTORT_REV1_CFG_MASK) >> DISTORT_REV1_CFG_SHIFT)
#define  DISTORT_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV1_CFG_MASK) | (((uint32_t)val) << DISTORT_REV1_CFG_SHIFT))

//====================================================================
//Register: Distort Configuration Register (Cfg)
/** \brief This register configures the major features of the Distort module*/
//====================================================================

#define  DISTORT_CFG_RESERVED1_MASK 0xfc000000
#define  DISTORT_CFG_RESERVED1_SHIFT 26
#define  DISTORT_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED1_MASK) >> DISTORT_CFG_RESERVED1_SHIFT)
#define  DISTORT_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED1_SHIFT))

#define  DISTORT_CFG_HORZSHIFT_MASK 0x3000000
#define  DISTORT_CFG_HORZSHIFT_SHIFT 24
#define  DISTORT_CFG_HORZSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_HORZSHIFT_MASK) >> DISTORT_CFG_HORZSHIFT_SHIFT)
#define  DISTORT_CFG_HORZSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_HORZSHIFT_MASK) | (((uint32_t)val) << DISTORT_CFG_HORZSHIFT_SHIFT))

#define  DISTORT_CFG_RESERVED2_MASK 0xfc0000
#define  DISTORT_CFG_RESERVED2_SHIFT 18
#define  DISTORT_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED2_MASK) >> DISTORT_CFG_RESERVED2_SHIFT)
#define  DISTORT_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED2_SHIFT))

#define  DISTORT_CFG_VERTSHIFT_MASK 0x30000
#define  DISTORT_CFG_VERTSHIFT_SHIFT 16
#define  DISTORT_CFG_VERTSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_VERTSHIFT_MASK) >> DISTORT_CFG_VERTSHIFT_SHIFT)
#define  DISTORT_CFG_VERTSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_VERTSHIFT_MASK) | (((uint32_t)val) << DISTORT_CFG_VERTSHIFT_SHIFT))

#define  DISTORT_CFG_RESERVED3_MASK 0xff80
#define  DISTORT_CFG_RESERVED3_SHIFT 7
#define  DISTORT_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED3_MASK) >> DISTORT_CFG_RESERVED3_SHIFT)
#define  DISTORT_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED3_SHIFT))

#define  DISTORT_CFG_ENCOLOR3_MASK 0x40
#define  DISTORT_CFG_ENCOLOR3_SHIFT 6
#define  DISTORT_CFG_ENCOLOR3_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR3_MASK) >> DISTORT_CFG_ENCOLOR3_SHIFT)
#define  DISTORT_CFG_ENCOLOR3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR3_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR3_SHIFT))

#define  DISTORT_CFG_ENCOLOR2_MASK 0x20
#define  DISTORT_CFG_ENCOLOR2_SHIFT 5
#define  DISTORT_CFG_ENCOLOR2_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR2_MASK) >> DISTORT_CFG_ENCOLOR2_SHIFT)
#define  DISTORT_CFG_ENCOLOR2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR2_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR2_SHIFT))

#define  DISTORT_CFG_ENCOLOR1_MASK 0x10
#define  DISTORT_CFG_ENCOLOR1_SHIFT 4
#define  DISTORT_CFG_ENCOLOR1_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR1_MASK) >> DISTORT_CFG_ENCOLOR1_SHIFT)
#define  DISTORT_CFG_ENCOLOR1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR1_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR1_SHIFT))

#define  DISTORT_CFG_CH3_MAPMODE_MASK 0x8
#define  DISTORT_CFG_CH3_MAPMODE_SHIFT 3
#define  DISTORT_CFG_CH3_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH3_MAPMODE_MASK) >> DISTORT_CFG_CH3_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH3_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH3_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH3_MAPMODE_SHIFT))

#define  DISTORT_CFG_CH2_MAPMODE_MASK 0x4
#define  DISTORT_CFG_CH2_MAPMODE_SHIFT 2
#define  DISTORT_CFG_CH2_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH2_MAPMODE_MASK) >> DISTORT_CFG_CH2_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH2_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH2_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH2_MAPMODE_SHIFT))

#define  DISTORT_CFG_CH1_MAPMODE_MASK 0x2
#define  DISTORT_CFG_CH1_MAPMODE_SHIFT 1
#define  DISTORT_CFG_CH1_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH1_MAPMODE_MASK) >> DISTORT_CFG_CH1_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH1_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH1_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH1_MAPMODE_SHIFT))

#define  DISTORT_CFG_BYPASS_MASK 0x1
#define  DISTORT_CFG_BYPASS_SHIFT 0
#define  DISTORT_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_BYPASS_MASK) >> DISTORT_CFG_BYPASS_SHIFT)
#define  DISTORT_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_BYPASS_MASK) | (((uint32_t)val) << DISTORT_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Strip Register (Strip)
/** \brief This register starts generation of fixed steps for one strip.*/
//====================================================================

#define  DISTORT_STRIP_RESERVED1_MASK 0xfffffffc
#define  DISTORT_STRIP_RESERVED1_SHIFT 2
#define  DISTORT_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_RESERVED1_MASK) >> DISTORT_STRIP_RESERVED1_SHIFT)
#define  DISTORT_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_STRIP_RESERVED1_SHIFT))

#define  DISTORT_STRIP_RESETLINES_MASK 0x2
#define  DISTORT_STRIP_RESETLINES_SHIFT 1
#define  DISTORT_STRIP_RESETLINES_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_RESETLINES_MASK) >> DISTORT_STRIP_RESETLINES_SHIFT)
#define  DISTORT_STRIP_RESETLINES_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_RESETLINES_MASK) | (((uint32_t)val) << DISTORT_STRIP_RESETLINES_SHIFT))

#define  DISTORT_STRIP_START_MASK 0x1
#define  DISTORT_STRIP_START_SHIFT 0
#define  DISTORT_STRIP_START_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_START_MASK) >> DISTORT_STRIP_START_SHIFT)
#define  DISTORT_STRIP_START_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_START_MASK) | (((uint32_t)val) << DISTORT_STRIP_START_SHIFT))

//====================================================================
//Register: Output Strip Size (OutputStripDimension)
/** \brief This register sets the output strip size in pixels.*/
//====================================================================

#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK 0xc0000000
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT 30
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK 0x3f000000
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT 24
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK 0xc00000
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT 22
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK 0x3f0000
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT 16
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK 0xffff
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT 0
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Enable Register (IntEnable)
//====================================================================

#define  DISTORT_INTENABLE_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTENABLE_RESERVED1_SHIFT 3
#define  DISTORT_INTENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_RESERVED1_MASK) >> DISTORT_INTENABLE_RESERVED1_SHIFT)
#define  DISTORT_INTENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_RESERVED1_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTENABLE_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP3_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTENABLE_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP2_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTENABLE_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP1_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Pending Register (IntPending)
//====================================================================

#define  DISTORT_INTPENDING_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTPENDING_RESERVED1_SHIFT 3
#define  DISTORT_INTPENDING_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_RESERVED1_MASK) >> DISTORT_INTPENDING_RESERVED1_SHIFT)
#define  DISTORT_INTPENDING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_RESERVED1_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTPENDING_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP3_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTPENDING_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP2_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTPENDING_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP1_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Clear Register (IntClear)
//====================================================================

#define  DISTORT_INTCLEAR_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTCLEAR_RESERVED1_SHIFT 3
#define  DISTORT_INTCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_RESERVED1_MASK) >> DISTORT_INTCLEAR_RESERVED1_SHIFT)
#define  DISTORT_INTCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_RESERVED1_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP3_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP2_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP1_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Force Register (IntForce)
//====================================================================

#define  DISTORT_INTFORCE_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTFORCE_RESERVED1_SHIFT 3
#define  DISTORT_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_RESERVED1_MASK) >> DISTORT_INTFORCE_RESERVED1_SHIFT)
#define  DISTORT_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_RESERVED1_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTFORCE_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP3_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTFORCE_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP2_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTFORCE_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP1_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: Input Image Size (Ch1_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Input Image Size (Ch2_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Input Image Size (Ch3_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch1_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch2_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch3_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch1_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch2_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch3_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 1 in non-MapMode (Ch1_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 2 in non-MapMode (Ch2_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 3 in non-MapMode (Ch3_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 1 in non-MapMode (Ch1_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 2 in non-MapMode (Ch2_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 3 in non-MapMode (Ch3_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 1 in non-MapMode (Ch1_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 2 in non-MapMode (Ch2_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 3 in non-MapMode (Ch3_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 1 in non-MapMode (Ch1_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 2 in non-MapMode (Ch2_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 3 in non-MapMode (Ch3_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Blank value for channel 1 (Ch1_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 1.*/
//====================================================================

#define  DISTORT_CH1_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Blank value for channel 2 (Ch2_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 2.*/
//====================================================================

#define  DISTORT_CH2_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Blank value for channel 3 (Ch3_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 3.*/
//====================================================================

#define  DISTORT_CH3_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Highest line for channel 1 (Ch1_HighestLine)
//====================================================================

#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register: Highest line for channel 2 (Ch2_HighestLine)
//====================================================================

#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register: Highest line for channel 3 (Ch3_HighestLine)
//====================================================================

#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register:  (OperationStatus)
//====================================================================

#define  DISTORT_OPERATIONSTATUS_RESERVED1_MASK 0xfffffff8
#define  DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT 3
#define  DISTORT_OPERATIONSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_RESERVED1_MASK) >> DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT)
#define  DISTORT_OPERATIONSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK 0x4
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT 2
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK 0x2
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT 1
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK 0x1
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT 0
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT))

//====================================================================
//Register: Current Position (CurrentPosition)
//====================================================================

#define  DISTORT_CURRENTPOSITION_COLUMN_MASK 0xffff0000
#define  DISTORT_CURRENTPOSITION_COLUMN_SHIFT 16
#define  DISTORT_CURRENTPOSITION_COLUMN_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_COLUMN_MASK) >> DISTORT_CURRENTPOSITION_COLUMN_SHIFT)
#define  DISTORT_CURRENTPOSITION_COLUMN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_COLUMN_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_COLUMN_SHIFT))

#define  DISTORT_CURRENTPOSITION_RESERVED1_MASK 0xffc0
#define  DISTORT_CURRENTPOSITION_RESERVED1_SHIFT 6
#define  DISTORT_CURRENTPOSITION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_RESERVED1_MASK) >> DISTORT_CURRENTPOSITION_RESERVED1_SHIFT)
#define  DISTORT_CURRENTPOSITION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_RESERVED1_SHIFT))

#define  DISTORT_CURRENTPOSITION_ROW_MASK 0x3f
#define  DISTORT_CURRENTPOSITION_ROW_SHIFT 0
#define  DISTORT_CURRENTPOSITION_ROW_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_ROW_MASK) >> DISTORT_CURRENTPOSITION_ROW_SHIFT)
#define  DISTORT_CURRENTPOSITION_ROW_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_ROW_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_ROW_SHIFT))

//====================================================================
//Register: Position Select (PosSelect)
/** \brief This register selects the channel and process output in CurrentPosition.*/
//====================================================================

#define  DISTORT_POSSELECT_RESERVED1_MASK 0xffffffc0
#define  DISTORT_POSSELECT_RESERVED1_SHIFT 6
#define  DISTORT_POSSELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_RESERVED1_MASK) >> DISTORT_POSSELECT_RESERVED1_SHIFT)
#define  DISTORT_POSSELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_RESERVED1_SHIFT))

#define  DISTORT_POSSELECT_CHANNEL_MASK 0x30
#define  DISTORT_POSSELECT_CHANNEL_SHIFT 4
#define  DISTORT_POSSELECT_CHANNEL_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_CHANNEL_MASK) >> DISTORT_POSSELECT_CHANNEL_SHIFT)
#define  DISTORT_POSSELECT_CHANNEL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_CHANNEL_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_CHANNEL_SHIFT))

#define  DISTORT_POSSELECT_RESERVED2_MASK 0xe
#define  DISTORT_POSSELECT_RESERVED2_SHIFT 1
#define  DISTORT_POSSELECT_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_RESERVED2_MASK) >> DISTORT_POSSELECT_RESERVED2_SHIFT)
#define  DISTORT_POSSELECT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_RESERVED2_SHIFT))

#define  DISTORT_POSSELECT_PROCESS_MASK 0x1
#define  DISTORT_POSSELECT_PROCESS_SHIFT 0
#define  DISTORT_POSSELECT_PROCESS_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_PROCESS_MASK) >> DISTORT_POSSELECT_PROCESS_SHIFT)
#define  DISTORT_POSSELECT_PROCESS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_PROCESS_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_PROCESS_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 1 of 16) (HCL0)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_HCL0_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL0_RESERVED1_SHIFT 28
#define  DISTORT_HCL0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_RESERVED1_MASK) >> DISTORT_HCL0_RESERVED1_SHIFT)
#define  DISTORT_HCL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL0_RESERVED1_SHIFT))

#define  DISTORT_HCL0_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL0_HCOEF1_SHIFT 16
#define  DISTORT_HCL0_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_HCOEF1_MASK) >> DISTORT_HCL0_HCOEF1_SHIFT)
#define  DISTORT_HCL0_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL0_HCOEF1_SHIFT))

#define  DISTORT_HCL0_RESERVED2_MASK 0xf000
#define  DISTORT_HCL0_RESERVED2_SHIFT 12
#define  DISTORT_HCL0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_RESERVED2_MASK) >> DISTORT_HCL0_RESERVED2_SHIFT)
#define  DISTORT_HCL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL0_RESERVED2_SHIFT))

#define  DISTORT_HCL0_HCOEF0_MASK 0xfff
#define  DISTORT_HCL0_HCOEF0_SHIFT 0
#define  DISTORT_HCL0_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_HCOEF0_MASK) >> DISTORT_HCL0_HCOEF0_SHIFT)
#define  DISTORT_HCL0_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL0_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 2 of 16) (HCL1)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_HCL1_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL1_RESERVED1_SHIFT 28
#define  DISTORT_HCL1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_RESERVED1_MASK) >> DISTORT_HCL1_RESERVED1_SHIFT)
#define  DISTORT_HCL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL1_RESERVED1_SHIFT))

#define  DISTORT_HCL1_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL1_HCOEF1_SHIFT 16
#define  DISTORT_HCL1_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_HCOEF1_MASK) >> DISTORT_HCL1_HCOEF1_SHIFT)
#define  DISTORT_HCL1_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL1_HCOEF1_SHIFT))

#define  DISTORT_HCL1_RESERVED2_MASK 0xf000
#define  DISTORT_HCL1_RESERVED2_SHIFT 12
#define  DISTORT_HCL1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_RESERVED2_MASK) >> DISTORT_HCL1_RESERVED2_SHIFT)
#define  DISTORT_HCL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL1_RESERVED2_SHIFT))

#define  DISTORT_HCL1_HCOEF0_MASK 0xfff
#define  DISTORT_HCL1_HCOEF0_SHIFT 0
#define  DISTORT_HCL1_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_HCOEF0_MASK) >> DISTORT_HCL1_HCOEF0_SHIFT)
#define  DISTORT_HCL1_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL1_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 3 of 16) (HCL2)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_HCL2_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL2_RESERVED1_SHIFT 28
#define  DISTORT_HCL2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_RESERVED1_MASK) >> DISTORT_HCL2_RESERVED1_SHIFT)
#define  DISTORT_HCL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL2_RESERVED1_SHIFT))

#define  DISTORT_HCL2_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL2_HCOEF1_SHIFT 16
#define  DISTORT_HCL2_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_HCOEF1_MASK) >> DISTORT_HCL2_HCOEF1_SHIFT)
#define  DISTORT_HCL2_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL2_HCOEF1_SHIFT))

#define  DISTORT_HCL2_RESERVED2_MASK 0xf000
#define  DISTORT_HCL2_RESERVED2_SHIFT 12
#define  DISTORT_HCL2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_RESERVED2_MASK) >> DISTORT_HCL2_RESERVED2_SHIFT)
#define  DISTORT_HCL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL2_RESERVED2_SHIFT))

#define  DISTORT_HCL2_HCOEF0_MASK 0xfff
#define  DISTORT_HCL2_HCOEF0_SHIFT 0
#define  DISTORT_HCL2_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_HCOEF0_MASK) >> DISTORT_HCL2_HCOEF0_SHIFT)
#define  DISTORT_HCL2_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL2_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 4 of 16) (HCL3)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_HCL3_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL3_RESERVED1_SHIFT 28
#define  DISTORT_HCL3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_RESERVED1_MASK) >> DISTORT_HCL3_RESERVED1_SHIFT)
#define  DISTORT_HCL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL3_RESERVED1_SHIFT))

#define  DISTORT_HCL3_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL3_HCOEF1_SHIFT 16
#define  DISTORT_HCL3_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_HCOEF1_MASK) >> DISTORT_HCL3_HCOEF1_SHIFT)
#define  DISTORT_HCL3_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL3_HCOEF1_SHIFT))

#define  DISTORT_HCL3_RESERVED2_MASK 0xf000
#define  DISTORT_HCL3_RESERVED2_SHIFT 12
#define  DISTORT_HCL3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_RESERVED2_MASK) >> DISTORT_HCL3_RESERVED2_SHIFT)
#define  DISTORT_HCL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL3_RESERVED2_SHIFT))

#define  DISTORT_HCL3_HCOEF0_MASK 0xfff
#define  DISTORT_HCL3_HCOEF0_SHIFT 0
#define  DISTORT_HCL3_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_HCOEF0_MASK) >> DISTORT_HCL3_HCOEF0_SHIFT)
#define  DISTORT_HCL3_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL3_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 5 of 16) (HCL4)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_HCL4_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL4_RESERVED1_SHIFT 28
#define  DISTORT_HCL4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_RESERVED1_MASK) >> DISTORT_HCL4_RESERVED1_SHIFT)
#define  DISTORT_HCL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL4_RESERVED1_SHIFT))

#define  DISTORT_HCL4_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL4_HCOEF1_SHIFT 16
#define  DISTORT_HCL4_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_HCOEF1_MASK) >> DISTORT_HCL4_HCOEF1_SHIFT)
#define  DISTORT_HCL4_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL4_HCOEF1_SHIFT))

#define  DISTORT_HCL4_RESERVED2_MASK 0xf000
#define  DISTORT_HCL4_RESERVED2_SHIFT 12
#define  DISTORT_HCL4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_RESERVED2_MASK) >> DISTORT_HCL4_RESERVED2_SHIFT)
#define  DISTORT_HCL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL4_RESERVED2_SHIFT))

#define  DISTORT_HCL4_HCOEF0_MASK 0xfff
#define  DISTORT_HCL4_HCOEF0_SHIFT 0
#define  DISTORT_HCL4_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_HCOEF0_MASK) >> DISTORT_HCL4_HCOEF0_SHIFT)
#define  DISTORT_HCL4_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL4_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 6 of 16) (HCL5)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_HCL5_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL5_RESERVED1_SHIFT 28
#define  DISTORT_HCL5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_RESERVED1_MASK) >> DISTORT_HCL5_RESERVED1_SHIFT)
#define  DISTORT_HCL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL5_RESERVED1_SHIFT))

#define  DISTORT_HCL5_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL5_HCOEF1_SHIFT 16
#define  DISTORT_HCL5_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_HCOEF1_MASK) >> DISTORT_HCL5_HCOEF1_SHIFT)
#define  DISTORT_HCL5_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL5_HCOEF1_SHIFT))

#define  DISTORT_HCL5_RESERVED2_MASK 0xf000
#define  DISTORT_HCL5_RESERVED2_SHIFT 12
#define  DISTORT_HCL5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_RESERVED2_MASK) >> DISTORT_HCL5_RESERVED2_SHIFT)
#define  DISTORT_HCL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL5_RESERVED2_SHIFT))

#define  DISTORT_HCL5_HCOEF0_MASK 0xfff
#define  DISTORT_HCL5_HCOEF0_SHIFT 0
#define  DISTORT_HCL5_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_HCOEF0_MASK) >> DISTORT_HCL5_HCOEF0_SHIFT)
#define  DISTORT_HCL5_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL5_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 7 of 16) (HCL6)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_HCL6_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL6_RESERVED1_SHIFT 28
#define  DISTORT_HCL6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_RESERVED1_MASK) >> DISTORT_HCL6_RESERVED1_SHIFT)
#define  DISTORT_HCL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL6_RESERVED1_SHIFT))

#define  DISTORT_HCL6_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL6_HCOEF1_SHIFT 16
#define  DISTORT_HCL6_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_HCOEF1_MASK) >> DISTORT_HCL6_HCOEF1_SHIFT)
#define  DISTORT_HCL6_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL6_HCOEF1_SHIFT))

#define  DISTORT_HCL6_RESERVED2_MASK 0xf000
#define  DISTORT_HCL6_RESERVED2_SHIFT 12
#define  DISTORT_HCL6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_RESERVED2_MASK) >> DISTORT_HCL6_RESERVED2_SHIFT)
#define  DISTORT_HCL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL6_RESERVED2_SHIFT))

#define  DISTORT_HCL6_HCOEF0_MASK 0xfff
#define  DISTORT_HCL6_HCOEF0_SHIFT 0
#define  DISTORT_HCL6_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_HCOEF0_MASK) >> DISTORT_HCL6_HCOEF0_SHIFT)
#define  DISTORT_HCL6_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL6_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 8 of 16) (HCL7)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_HCL7_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL7_RESERVED1_SHIFT 28
#define  DISTORT_HCL7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_RESERVED1_MASK) >> DISTORT_HCL7_RESERVED1_SHIFT)
#define  DISTORT_HCL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL7_RESERVED1_SHIFT))

#define  DISTORT_HCL7_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL7_HCOEF1_SHIFT 16
#define  DISTORT_HCL7_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_HCOEF1_MASK) >> DISTORT_HCL7_HCOEF1_SHIFT)
#define  DISTORT_HCL7_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL7_HCOEF1_SHIFT))

#define  DISTORT_HCL7_RESERVED2_MASK 0xf000
#define  DISTORT_HCL7_RESERVED2_SHIFT 12
#define  DISTORT_HCL7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_RESERVED2_MASK) >> DISTORT_HCL7_RESERVED2_SHIFT)
#define  DISTORT_HCL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL7_RESERVED2_SHIFT))

#define  DISTORT_HCL7_HCOEF0_MASK 0xfff
#define  DISTORT_HCL7_HCOEF0_SHIFT 0
#define  DISTORT_HCL7_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_HCOEF0_MASK) >> DISTORT_HCL7_HCOEF0_SHIFT)
#define  DISTORT_HCL7_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL7_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 9 of 16) (HCL8)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_HCL8_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL8_RESERVED1_SHIFT 28
#define  DISTORT_HCL8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_RESERVED1_MASK) >> DISTORT_HCL8_RESERVED1_SHIFT)
#define  DISTORT_HCL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL8_RESERVED1_SHIFT))

#define  DISTORT_HCL8_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL8_HCOEF1_SHIFT 16
#define  DISTORT_HCL8_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_HCOEF1_MASK) >> DISTORT_HCL8_HCOEF1_SHIFT)
#define  DISTORT_HCL8_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL8_HCOEF1_SHIFT))

#define  DISTORT_HCL8_RESERVED2_MASK 0xf000
#define  DISTORT_HCL8_RESERVED2_SHIFT 12
#define  DISTORT_HCL8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_RESERVED2_MASK) >> DISTORT_HCL8_RESERVED2_SHIFT)
#define  DISTORT_HCL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL8_RESERVED2_SHIFT))

#define  DISTORT_HCL8_HCOEF0_MASK 0xfff
#define  DISTORT_HCL8_HCOEF0_SHIFT 0
#define  DISTORT_HCL8_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_HCOEF0_MASK) >> DISTORT_HCL8_HCOEF0_SHIFT)
#define  DISTORT_HCL8_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL8_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 10 of 16) (HCL9)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_HCL9_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL9_RESERVED1_SHIFT 28
#define  DISTORT_HCL9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_RESERVED1_MASK) >> DISTORT_HCL9_RESERVED1_SHIFT)
#define  DISTORT_HCL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL9_RESERVED1_SHIFT))

#define  DISTORT_HCL9_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL9_HCOEF1_SHIFT 16
#define  DISTORT_HCL9_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_HCOEF1_MASK) >> DISTORT_HCL9_HCOEF1_SHIFT)
#define  DISTORT_HCL9_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL9_HCOEF1_SHIFT))

#define  DISTORT_HCL9_RESERVED2_MASK 0xf000
#define  DISTORT_HCL9_RESERVED2_SHIFT 12
#define  DISTORT_HCL9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_RESERVED2_MASK) >> DISTORT_HCL9_RESERVED2_SHIFT)
#define  DISTORT_HCL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL9_RESERVED2_SHIFT))

#define  DISTORT_HCL9_HCOEF0_MASK 0xfff
#define  DISTORT_HCL9_HCOEF0_SHIFT 0
#define  DISTORT_HCL9_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_HCOEF0_MASK) >> DISTORT_HCL9_HCOEF0_SHIFT)
#define  DISTORT_HCL9_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL9_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 11 of 16) (HCL10)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_HCL10_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL10_RESERVED1_SHIFT 28
#define  DISTORT_HCL10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_RESERVED1_MASK) >> DISTORT_HCL10_RESERVED1_SHIFT)
#define  DISTORT_HCL10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL10_RESERVED1_SHIFT))

#define  DISTORT_HCL10_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL10_HCOEF1_SHIFT 16
#define  DISTORT_HCL10_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_HCOEF1_MASK) >> DISTORT_HCL10_HCOEF1_SHIFT)
#define  DISTORT_HCL10_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL10_HCOEF1_SHIFT))

#define  DISTORT_HCL10_RESERVED2_MASK 0xf000
#define  DISTORT_HCL10_RESERVED2_SHIFT 12
#define  DISTORT_HCL10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_RESERVED2_MASK) >> DISTORT_HCL10_RESERVED2_SHIFT)
#define  DISTORT_HCL10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL10_RESERVED2_SHIFT))

#define  DISTORT_HCL10_HCOEF0_MASK 0xfff
#define  DISTORT_HCL10_HCOEF0_SHIFT 0
#define  DISTORT_HCL10_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_HCOEF0_MASK) >> DISTORT_HCL10_HCOEF0_SHIFT)
#define  DISTORT_HCL10_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL10_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 12 of 16) (HCL11)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_HCL11_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL11_RESERVED1_SHIFT 28
#define  DISTORT_HCL11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_RESERVED1_MASK) >> DISTORT_HCL11_RESERVED1_SHIFT)
#define  DISTORT_HCL11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL11_RESERVED1_SHIFT))

#define  DISTORT_HCL11_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL11_HCOEF1_SHIFT 16
#define  DISTORT_HCL11_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_HCOEF1_MASK) >> DISTORT_HCL11_HCOEF1_SHIFT)
#define  DISTORT_HCL11_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL11_HCOEF1_SHIFT))

#define  DISTORT_HCL11_RESERVED2_MASK 0xf000
#define  DISTORT_HCL11_RESERVED2_SHIFT 12
#define  DISTORT_HCL11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_RESERVED2_MASK) >> DISTORT_HCL11_RESERVED2_SHIFT)
#define  DISTORT_HCL11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL11_RESERVED2_SHIFT))

#define  DISTORT_HCL11_HCOEF0_MASK 0xfff
#define  DISTORT_HCL11_HCOEF0_SHIFT 0
#define  DISTORT_HCL11_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_HCOEF0_MASK) >> DISTORT_HCL11_HCOEF0_SHIFT)
#define  DISTORT_HCL11_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL11_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 13 of 16) (HCL12)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_HCL12_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL12_RESERVED1_SHIFT 28
#define  DISTORT_HCL12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_RESERVED1_MASK) >> DISTORT_HCL12_RESERVED1_SHIFT)
#define  DISTORT_HCL12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL12_RESERVED1_SHIFT))

#define  DISTORT_HCL12_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL12_HCOEF1_SHIFT 16
#define  DISTORT_HCL12_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_HCOEF1_MASK) >> DISTORT_HCL12_HCOEF1_SHIFT)
#define  DISTORT_HCL12_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL12_HCOEF1_SHIFT))

#define  DISTORT_HCL12_RESERVED2_MASK 0xf000
#define  DISTORT_HCL12_RESERVED2_SHIFT 12
#define  DISTORT_HCL12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_RESERVED2_MASK) >> DISTORT_HCL12_RESERVED2_SHIFT)
#define  DISTORT_HCL12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL12_RESERVED2_SHIFT))

#define  DISTORT_HCL12_HCOEF0_MASK 0xfff
#define  DISTORT_HCL12_HCOEF0_SHIFT 0
#define  DISTORT_HCL12_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_HCOEF0_MASK) >> DISTORT_HCL12_HCOEF0_SHIFT)
#define  DISTORT_HCL12_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL12_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 14 of 16) (HCL13)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_HCL13_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL13_RESERVED1_SHIFT 28
#define  DISTORT_HCL13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_RESERVED1_MASK) >> DISTORT_HCL13_RESERVED1_SHIFT)
#define  DISTORT_HCL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL13_RESERVED1_SHIFT))

#define  DISTORT_HCL13_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL13_HCOEF1_SHIFT 16
#define  DISTORT_HCL13_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_HCOEF1_MASK) >> DISTORT_HCL13_HCOEF1_SHIFT)
#define  DISTORT_HCL13_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL13_HCOEF1_SHIFT))

#define  DISTORT_HCL13_RESERVED2_MASK 0xf000
#define  DISTORT_HCL13_RESERVED2_SHIFT 12
#define  DISTORT_HCL13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_RESERVED2_MASK) >> DISTORT_HCL13_RESERVED2_SHIFT)
#define  DISTORT_HCL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL13_RESERVED2_SHIFT))

#define  DISTORT_HCL13_HCOEF0_MASK 0xfff
#define  DISTORT_HCL13_HCOEF0_SHIFT 0
#define  DISTORT_HCL13_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_HCOEF0_MASK) >> DISTORT_HCL13_HCOEF0_SHIFT)
#define  DISTORT_HCL13_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL13_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 15 of 16) (HCL14)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_HCL14_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL14_RESERVED1_SHIFT 28
#define  DISTORT_HCL14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_RESERVED1_MASK) >> DISTORT_HCL14_RESERVED1_SHIFT)
#define  DISTORT_HCL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL14_RESERVED1_SHIFT))

#define  DISTORT_HCL14_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL14_HCOEF1_SHIFT 16
#define  DISTORT_HCL14_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_HCOEF1_MASK) >> DISTORT_HCL14_HCOEF1_SHIFT)
#define  DISTORT_HCL14_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL14_HCOEF1_SHIFT))

#define  DISTORT_HCL14_RESERVED2_MASK 0xf000
#define  DISTORT_HCL14_RESERVED2_SHIFT 12
#define  DISTORT_HCL14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_RESERVED2_MASK) >> DISTORT_HCL14_RESERVED2_SHIFT)
#define  DISTORT_HCL14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL14_RESERVED2_SHIFT))

#define  DISTORT_HCL14_HCOEF0_MASK 0xfff
#define  DISTORT_HCL14_HCOEF0_SHIFT 0
#define  DISTORT_HCL14_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_HCOEF0_MASK) >> DISTORT_HCL14_HCOEF0_SHIFT)
#define  DISTORT_HCL14_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL14_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 16 of 16) (HCL15)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_HCL15_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL15_RESERVED1_SHIFT 28
#define  DISTORT_HCL15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_RESERVED1_MASK) >> DISTORT_HCL15_RESERVED1_SHIFT)
#define  DISTORT_HCL15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL15_RESERVED1_SHIFT))

#define  DISTORT_HCL15_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL15_HCOEF1_SHIFT 16
#define  DISTORT_HCL15_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_HCOEF1_MASK) >> DISTORT_HCL15_HCOEF1_SHIFT)
#define  DISTORT_HCL15_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL15_HCOEF1_SHIFT))

#define  DISTORT_HCL15_RESERVED2_MASK 0xf000
#define  DISTORT_HCL15_RESERVED2_SHIFT 12
#define  DISTORT_HCL15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_RESERVED2_MASK) >> DISTORT_HCL15_RESERVED2_SHIFT)
#define  DISTORT_HCL15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL15_RESERVED2_SHIFT))

#define  DISTORT_HCL15_HCOEF0_MASK 0xfff
#define  DISTORT_HCL15_HCOEF0_SHIFT 0
#define  DISTORT_HCL15_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_HCOEF0_MASK) >> DISTORT_HCL15_HCOEF0_SHIFT)
#define  DISTORT_HCL15_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL15_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 1 of 16) (HCH0)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_HCH0_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH0_RESERVED1_SHIFT 28
#define  DISTORT_HCH0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_RESERVED1_MASK) >> DISTORT_HCH0_RESERVED1_SHIFT)
#define  DISTORT_HCH0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH0_RESERVED1_SHIFT))

#define  DISTORT_HCH0_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH0_HCOEF3_SHIFT 16
#define  DISTORT_HCH0_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_HCOEF3_MASK) >> DISTORT_HCH0_HCOEF3_SHIFT)
#define  DISTORT_HCH0_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH0_HCOEF3_SHIFT))

#define  DISTORT_HCH0_RESERVED2_MASK 0xf000
#define  DISTORT_HCH0_RESERVED2_SHIFT 12
#define  DISTORT_HCH0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_RESERVED2_MASK) >> DISTORT_HCH0_RESERVED2_SHIFT)
#define  DISTORT_HCH0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH0_RESERVED2_SHIFT))

#define  DISTORT_HCH0_HCOEF2_MASK 0xfff
#define  DISTORT_HCH0_HCOEF2_SHIFT 0
#define  DISTORT_HCH0_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_HCOEF2_MASK) >> DISTORT_HCH0_HCOEF2_SHIFT)
#define  DISTORT_HCH0_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH0_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 2 of 16) (HCH1)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_HCH1_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH1_RESERVED1_SHIFT 28
#define  DISTORT_HCH1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_RESERVED1_MASK) >> DISTORT_HCH1_RESERVED1_SHIFT)
#define  DISTORT_HCH1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH1_RESERVED1_SHIFT))

#define  DISTORT_HCH1_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH1_HCOEF3_SHIFT 16
#define  DISTORT_HCH1_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_HCOEF3_MASK) >> DISTORT_HCH1_HCOEF3_SHIFT)
#define  DISTORT_HCH1_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH1_HCOEF3_SHIFT))

#define  DISTORT_HCH1_RESERVED2_MASK 0xf000
#define  DISTORT_HCH1_RESERVED2_SHIFT 12
#define  DISTORT_HCH1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_RESERVED2_MASK) >> DISTORT_HCH1_RESERVED2_SHIFT)
#define  DISTORT_HCH1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH1_RESERVED2_SHIFT))

#define  DISTORT_HCH1_HCOEF2_MASK 0xfff
#define  DISTORT_HCH1_HCOEF2_SHIFT 0
#define  DISTORT_HCH1_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_HCOEF2_MASK) >> DISTORT_HCH1_HCOEF2_SHIFT)
#define  DISTORT_HCH1_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH1_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 3 of 16) (HCH2)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_HCH2_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH2_RESERVED1_SHIFT 28
#define  DISTORT_HCH2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_RESERVED1_MASK) >> DISTORT_HCH2_RESERVED1_SHIFT)
#define  DISTORT_HCH2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH2_RESERVED1_SHIFT))

#define  DISTORT_HCH2_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH2_HCOEF3_SHIFT 16
#define  DISTORT_HCH2_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_HCOEF3_MASK) >> DISTORT_HCH2_HCOEF3_SHIFT)
#define  DISTORT_HCH2_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH2_HCOEF3_SHIFT))

#define  DISTORT_HCH2_RESERVED2_MASK 0xf000
#define  DISTORT_HCH2_RESERVED2_SHIFT 12
#define  DISTORT_HCH2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_RESERVED2_MASK) >> DISTORT_HCH2_RESERVED2_SHIFT)
#define  DISTORT_HCH2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH2_RESERVED2_SHIFT))

#define  DISTORT_HCH2_HCOEF2_MASK 0xfff
#define  DISTORT_HCH2_HCOEF2_SHIFT 0
#define  DISTORT_HCH2_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_HCOEF2_MASK) >> DISTORT_HCH2_HCOEF2_SHIFT)
#define  DISTORT_HCH2_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH2_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 4 of 16) (HCH3)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_HCH3_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH3_RESERVED1_SHIFT 28
#define  DISTORT_HCH3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_RESERVED1_MASK) >> DISTORT_HCH3_RESERVED1_SHIFT)
#define  DISTORT_HCH3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH3_RESERVED1_SHIFT))

#define  DISTORT_HCH3_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH3_HCOEF3_SHIFT 16
#define  DISTORT_HCH3_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_HCOEF3_MASK) >> DISTORT_HCH3_HCOEF3_SHIFT)
#define  DISTORT_HCH3_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH3_HCOEF3_SHIFT))

#define  DISTORT_HCH3_RESERVED2_MASK 0xf000
#define  DISTORT_HCH3_RESERVED2_SHIFT 12
#define  DISTORT_HCH3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_RESERVED2_MASK) >> DISTORT_HCH3_RESERVED2_SHIFT)
#define  DISTORT_HCH3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH3_RESERVED2_SHIFT))

#define  DISTORT_HCH3_HCOEF2_MASK 0xfff
#define  DISTORT_HCH3_HCOEF2_SHIFT 0
#define  DISTORT_HCH3_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_HCOEF2_MASK) >> DISTORT_HCH3_HCOEF2_SHIFT)
#define  DISTORT_HCH3_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH3_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 5 of 16) (HCH4)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_HCH4_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH4_RESERVED1_SHIFT 28
#define  DISTORT_HCH4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_RESERVED1_MASK) >> DISTORT_HCH4_RESERVED1_SHIFT)
#define  DISTORT_HCH4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH4_RESERVED1_SHIFT))

#define  DISTORT_HCH4_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH4_HCOEF3_SHIFT 16
#define  DISTORT_HCH4_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_HCOEF3_MASK) >> DISTORT_HCH4_HCOEF3_SHIFT)
#define  DISTORT_HCH4_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH4_HCOEF3_SHIFT))

#define  DISTORT_HCH4_RESERVED2_MASK 0xf000
#define  DISTORT_HCH4_RESERVED2_SHIFT 12
#define  DISTORT_HCH4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_RESERVED2_MASK) >> DISTORT_HCH4_RESERVED2_SHIFT)
#define  DISTORT_HCH4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH4_RESERVED2_SHIFT))

#define  DISTORT_HCH4_HCOEF2_MASK 0xfff
#define  DISTORT_HCH4_HCOEF2_SHIFT 0
#define  DISTORT_HCH4_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_HCOEF2_MASK) >> DISTORT_HCH4_HCOEF2_SHIFT)
#define  DISTORT_HCH4_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH4_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 6 of 16) (HCH5)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_HCH5_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH5_RESERVED1_SHIFT 28
#define  DISTORT_HCH5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_RESERVED1_MASK) >> DISTORT_HCH5_RESERVED1_SHIFT)
#define  DISTORT_HCH5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH5_RESERVED1_SHIFT))

#define  DISTORT_HCH5_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH5_HCOEF3_SHIFT 16
#define  DISTORT_HCH5_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_HCOEF3_MASK) >> DISTORT_HCH5_HCOEF3_SHIFT)
#define  DISTORT_HCH5_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH5_HCOEF3_SHIFT))

#define  DISTORT_HCH5_RESERVED2_MASK 0xf000
#define  DISTORT_HCH5_RESERVED2_SHIFT 12
#define  DISTORT_HCH5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_RESERVED2_MASK) >> DISTORT_HCH5_RESERVED2_SHIFT)
#define  DISTORT_HCH5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH5_RESERVED2_SHIFT))

#define  DISTORT_HCH5_HCOEF2_MASK 0xfff
#define  DISTORT_HCH5_HCOEF2_SHIFT 0
#define  DISTORT_HCH5_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_HCOEF2_MASK) >> DISTORT_HCH5_HCOEF2_SHIFT)
#define  DISTORT_HCH5_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH5_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 7 of 16) (HCH6)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_HCH6_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH6_RESERVED1_SHIFT 28
#define  DISTORT_HCH6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_RESERVED1_MASK) >> DISTORT_HCH6_RESERVED1_SHIFT)
#define  DISTORT_HCH6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH6_RESERVED1_SHIFT))

#define  DISTORT_HCH6_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH6_HCOEF3_SHIFT 16
#define  DISTORT_HCH6_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_HCOEF3_MASK) >> DISTORT_HCH6_HCOEF3_SHIFT)
#define  DISTORT_HCH6_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH6_HCOEF3_SHIFT))

#define  DISTORT_HCH6_RESERVED2_MASK 0xf000
#define  DISTORT_HCH6_RESERVED2_SHIFT 12
#define  DISTORT_HCH6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_RESERVED2_MASK) >> DISTORT_HCH6_RESERVED2_SHIFT)
#define  DISTORT_HCH6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH6_RESERVED2_SHIFT))

#define  DISTORT_HCH6_HCOEF2_MASK 0xfff
#define  DISTORT_HCH6_HCOEF2_SHIFT 0
#define  DISTORT_HCH6_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_HCOEF2_MASK) >> DISTORT_HCH6_HCOEF2_SHIFT)
#define  DISTORT_HCH6_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH6_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 8 of 16) (HCH7)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_HCH7_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH7_RESERVED1_SHIFT 28
#define  DISTORT_HCH7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_RESERVED1_MASK) >> DISTORT_HCH7_RESERVED1_SHIFT)
#define  DISTORT_HCH7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH7_RESERVED1_SHIFT))

#define  DISTORT_HCH7_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH7_HCOEF3_SHIFT 16
#define  DISTORT_HCH7_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_HCOEF3_MASK) >> DISTORT_HCH7_HCOEF3_SHIFT)
#define  DISTORT_HCH7_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH7_HCOEF3_SHIFT))

#define  DISTORT_HCH7_RESERVED2_MASK 0xf000
#define  DISTORT_HCH7_RESERVED2_SHIFT 12
#define  DISTORT_HCH7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_RESERVED2_MASK) >> DISTORT_HCH7_RESERVED2_SHIFT)
#define  DISTORT_HCH7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH7_RESERVED2_SHIFT))

#define  DISTORT_HCH7_HCOEF2_MASK 0xfff
#define  DISTORT_HCH7_HCOEF2_SHIFT 0
#define  DISTORT_HCH7_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_HCOEF2_MASK) >> DISTORT_HCH7_HCOEF2_SHIFT)
#define  DISTORT_HCH7_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH7_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 9 of 16) (HCH8)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_HCH8_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH8_RESERVED1_SHIFT 28
#define  DISTORT_HCH8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_RESERVED1_MASK) >> DISTORT_HCH8_RESERVED1_SHIFT)
#define  DISTORT_HCH8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH8_RESERVED1_SHIFT))

#define  DISTORT_HCH8_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH8_HCOEF3_SHIFT 16
#define  DISTORT_HCH8_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_HCOEF3_MASK) >> DISTORT_HCH8_HCOEF3_SHIFT)
#define  DISTORT_HCH8_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH8_HCOEF3_SHIFT))

#define  DISTORT_HCH8_RESERVED2_MASK 0xf000
#define  DISTORT_HCH8_RESERVED2_SHIFT 12
#define  DISTORT_HCH8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_RESERVED2_MASK) >> DISTORT_HCH8_RESERVED2_SHIFT)
#define  DISTORT_HCH8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH8_RESERVED2_SHIFT))

#define  DISTORT_HCH8_HCOEF2_MASK 0xfff
#define  DISTORT_HCH8_HCOEF2_SHIFT 0
#define  DISTORT_HCH8_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_HCOEF2_MASK) >> DISTORT_HCH8_HCOEF2_SHIFT)
#define  DISTORT_HCH8_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH8_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 10 of 16) (HCH9)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_HCH9_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH9_RESERVED1_SHIFT 28
#define  DISTORT_HCH9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_RESERVED1_MASK) >> DISTORT_HCH9_RESERVED1_SHIFT)
#define  DISTORT_HCH9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH9_RESERVED1_SHIFT))

#define  DISTORT_HCH9_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH9_HCOEF3_SHIFT 16
#define  DISTORT_HCH9_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_HCOEF3_MASK) >> DISTORT_HCH9_HCOEF3_SHIFT)
#define  DISTORT_HCH9_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH9_HCOEF3_SHIFT))

#define  DISTORT_HCH9_RESERVED2_MASK 0xf000
#define  DISTORT_HCH9_RESERVED2_SHIFT 12
#define  DISTORT_HCH9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_RESERVED2_MASK) >> DISTORT_HCH9_RESERVED2_SHIFT)
#define  DISTORT_HCH9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH9_RESERVED2_SHIFT))

#define  DISTORT_HCH9_HCOEF2_MASK 0xfff
#define  DISTORT_HCH9_HCOEF2_SHIFT 0
#define  DISTORT_HCH9_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_HCOEF2_MASK) >> DISTORT_HCH9_HCOEF2_SHIFT)
#define  DISTORT_HCH9_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH9_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 11 of 16) (HCH10)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_HCH10_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH10_RESERVED1_SHIFT 28
#define  DISTORT_HCH10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_RESERVED1_MASK) >> DISTORT_HCH10_RESERVED1_SHIFT)
#define  DISTORT_HCH10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH10_RESERVED1_SHIFT))

#define  DISTORT_HCH10_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH10_HCOEF3_SHIFT 16
#define  DISTORT_HCH10_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_HCOEF3_MASK) >> DISTORT_HCH10_HCOEF3_SHIFT)
#define  DISTORT_HCH10_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH10_HCOEF3_SHIFT))

#define  DISTORT_HCH10_RESERVED2_MASK 0xf000
#define  DISTORT_HCH10_RESERVED2_SHIFT 12
#define  DISTORT_HCH10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_RESERVED2_MASK) >> DISTORT_HCH10_RESERVED2_SHIFT)
#define  DISTORT_HCH10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH10_RESERVED2_SHIFT))

#define  DISTORT_HCH10_HCOEF2_MASK 0xfff
#define  DISTORT_HCH10_HCOEF2_SHIFT 0
#define  DISTORT_HCH10_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_HCOEF2_MASK) >> DISTORT_HCH10_HCOEF2_SHIFT)
#define  DISTORT_HCH10_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH10_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 12 of 16) (HCH11)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_HCH11_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH11_RESERVED1_SHIFT 28
#define  DISTORT_HCH11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_RESERVED1_MASK) >> DISTORT_HCH11_RESERVED1_SHIFT)
#define  DISTORT_HCH11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH11_RESERVED1_SHIFT))

#define  DISTORT_HCH11_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH11_HCOEF3_SHIFT 16
#define  DISTORT_HCH11_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_HCOEF3_MASK) >> DISTORT_HCH11_HCOEF3_SHIFT)
#define  DISTORT_HCH11_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH11_HCOEF3_SHIFT))

#define  DISTORT_HCH11_RESERVED2_MASK 0xf000
#define  DISTORT_HCH11_RESERVED2_SHIFT 12
#define  DISTORT_HCH11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_RESERVED2_MASK) >> DISTORT_HCH11_RESERVED2_SHIFT)
#define  DISTORT_HCH11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH11_RESERVED2_SHIFT))

#define  DISTORT_HCH11_HCOEF2_MASK 0xfff
#define  DISTORT_HCH11_HCOEF2_SHIFT 0
#define  DISTORT_HCH11_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_HCOEF2_MASK) >> DISTORT_HCH11_HCOEF2_SHIFT)
#define  DISTORT_HCH11_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH11_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 13 of 16) (HCH12)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_HCH12_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH12_RESERVED1_SHIFT 28
#define  DISTORT_HCH12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_RESERVED1_MASK) >> DISTORT_HCH12_RESERVED1_SHIFT)
#define  DISTORT_HCH12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH12_RESERVED1_SHIFT))

#define  DISTORT_HCH12_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH12_HCOEF3_SHIFT 16
#define  DISTORT_HCH12_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_HCOEF3_MASK) >> DISTORT_HCH12_HCOEF3_SHIFT)
#define  DISTORT_HCH12_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH12_HCOEF3_SHIFT))

#define  DISTORT_HCH12_RESERVED2_MASK 0xf000
#define  DISTORT_HCH12_RESERVED2_SHIFT 12
#define  DISTORT_HCH12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_RESERVED2_MASK) >> DISTORT_HCH12_RESERVED2_SHIFT)
#define  DISTORT_HCH12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH12_RESERVED2_SHIFT))

#define  DISTORT_HCH12_HCOEF2_MASK 0xfff
#define  DISTORT_HCH12_HCOEF2_SHIFT 0
#define  DISTORT_HCH12_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_HCOEF2_MASK) >> DISTORT_HCH12_HCOEF2_SHIFT)
#define  DISTORT_HCH12_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH12_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 14 of 16) (HCH13)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_HCH13_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH13_RESERVED1_SHIFT 28
#define  DISTORT_HCH13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_RESERVED1_MASK) >> DISTORT_HCH13_RESERVED1_SHIFT)
#define  DISTORT_HCH13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH13_RESERVED1_SHIFT))

#define  DISTORT_HCH13_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH13_HCOEF3_SHIFT 16
#define  DISTORT_HCH13_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_HCOEF3_MASK) >> DISTORT_HCH13_HCOEF3_SHIFT)
#define  DISTORT_HCH13_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH13_HCOEF3_SHIFT))

#define  DISTORT_HCH13_RESERVED2_MASK 0xf000
#define  DISTORT_HCH13_RESERVED2_SHIFT 12
#define  DISTORT_HCH13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_RESERVED2_MASK) >> DISTORT_HCH13_RESERVED2_SHIFT)
#define  DISTORT_HCH13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH13_RESERVED2_SHIFT))

#define  DISTORT_HCH13_HCOEF2_MASK 0xfff
#define  DISTORT_HCH13_HCOEF2_SHIFT 0
#define  DISTORT_HCH13_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_HCOEF2_MASK) >> DISTORT_HCH13_HCOEF2_SHIFT)
#define  DISTORT_HCH13_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH13_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 15 of 16) (HCH14)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_HCH14_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH14_RESERVED1_SHIFT 28
#define  DISTORT_HCH14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_RESERVED1_MASK) >> DISTORT_HCH14_RESERVED1_SHIFT)
#define  DISTORT_HCH14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH14_RESERVED1_SHIFT))

#define  DISTORT_HCH14_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH14_HCOEF3_SHIFT 16
#define  DISTORT_HCH14_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_HCOEF3_MASK) >> DISTORT_HCH14_HCOEF3_SHIFT)
#define  DISTORT_HCH14_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH14_HCOEF3_SHIFT))

#define  DISTORT_HCH14_RESERVED2_MASK 0xf000
#define  DISTORT_HCH14_RESERVED2_SHIFT 12
#define  DISTORT_HCH14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_RESERVED2_MASK) >> DISTORT_HCH14_RESERVED2_SHIFT)
#define  DISTORT_HCH14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH14_RESERVED2_SHIFT))

#define  DISTORT_HCH14_HCOEF2_MASK 0xfff
#define  DISTORT_HCH14_HCOEF2_SHIFT 0
#define  DISTORT_HCH14_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_HCOEF2_MASK) >> DISTORT_HCH14_HCOEF2_SHIFT)
#define  DISTORT_HCH14_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH14_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 16 of 16) (HCH15)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_HCH15_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH15_RESERVED1_SHIFT 28
#define  DISTORT_HCH15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_RESERVED1_MASK) >> DISTORT_HCH15_RESERVED1_SHIFT)
#define  DISTORT_HCH15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH15_RESERVED1_SHIFT))

#define  DISTORT_HCH15_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH15_HCOEF3_SHIFT 16
#define  DISTORT_HCH15_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_HCOEF3_MASK) >> DISTORT_HCH15_HCOEF3_SHIFT)
#define  DISTORT_HCH15_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH15_HCOEF3_SHIFT))

#define  DISTORT_HCH15_RESERVED2_MASK 0xf000
#define  DISTORT_HCH15_RESERVED2_SHIFT 12
#define  DISTORT_HCH15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_RESERVED2_MASK) >> DISTORT_HCH15_RESERVED2_SHIFT)
#define  DISTORT_HCH15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH15_RESERVED2_SHIFT))

#define  DISTORT_HCH15_HCOEF2_MASK 0xfff
#define  DISTORT_HCH15_HCOEF2_SHIFT 0
#define  DISTORT_HCH15_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_HCOEF2_MASK) >> DISTORT_HCH15_HCOEF2_SHIFT)
#define  DISTORT_HCH15_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH15_HCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 1 of 16) (VCL0)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_VCL0_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL0_RESERVED1_SHIFT 28
#define  DISTORT_VCL0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_RESERVED1_MASK) >> DISTORT_VCL0_RESERVED1_SHIFT)
#define  DISTORT_VCL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL0_RESERVED1_SHIFT))

#define  DISTORT_VCL0_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL0_VCOEF1_SHIFT 16
#define  DISTORT_VCL0_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_VCOEF1_MASK) >> DISTORT_VCL0_VCOEF1_SHIFT)
#define  DISTORT_VCL0_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL0_VCOEF1_SHIFT))

#define  DISTORT_VCL0_RESERVED2_MASK 0xf000
#define  DISTORT_VCL0_RESERVED2_SHIFT 12
#define  DISTORT_VCL0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_RESERVED2_MASK) >> DISTORT_VCL0_RESERVED2_SHIFT)
#define  DISTORT_VCL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL0_RESERVED2_SHIFT))

#define  DISTORT_VCL0_VCOEF0_MASK 0xfff
#define  DISTORT_VCL0_VCOEF0_SHIFT 0
#define  DISTORT_VCL0_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_VCOEF0_MASK) >> DISTORT_VCL0_VCOEF0_SHIFT)
#define  DISTORT_VCL0_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL0_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 2 of 16) (VCL1)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_VCL1_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL1_RESERVED1_SHIFT 28
#define  DISTORT_VCL1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_RESERVED1_MASK) >> DISTORT_VCL1_RESERVED1_SHIFT)
#define  DISTORT_VCL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL1_RESERVED1_SHIFT))

#define  DISTORT_VCL1_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL1_VCOEF1_SHIFT 16
#define  DISTORT_VCL1_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_VCOEF1_MASK) >> DISTORT_VCL1_VCOEF1_SHIFT)
#define  DISTORT_VCL1_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL1_VCOEF1_SHIFT))

#define  DISTORT_VCL1_RESERVED2_MASK 0xf000
#define  DISTORT_VCL1_RESERVED2_SHIFT 12
#define  DISTORT_VCL1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_RESERVED2_MASK) >> DISTORT_VCL1_RESERVED2_SHIFT)
#define  DISTORT_VCL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL1_RESERVED2_SHIFT))

#define  DISTORT_VCL1_VCOEF0_MASK 0xfff
#define  DISTORT_VCL1_VCOEF0_SHIFT 0
#define  DISTORT_VCL1_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_VCOEF0_MASK) >> DISTORT_VCL1_VCOEF0_SHIFT)
#define  DISTORT_VCL1_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL1_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 3 of 16) (VCL2)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_VCL2_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL2_RESERVED1_SHIFT 28
#define  DISTORT_VCL2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_RESERVED1_MASK) >> DISTORT_VCL2_RESERVED1_SHIFT)
#define  DISTORT_VCL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL2_RESERVED1_SHIFT))

#define  DISTORT_VCL2_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL2_VCOEF1_SHIFT 16
#define  DISTORT_VCL2_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_VCOEF1_MASK) >> DISTORT_VCL2_VCOEF1_SHIFT)
#define  DISTORT_VCL2_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL2_VCOEF1_SHIFT))

#define  DISTORT_VCL2_RESERVED2_MASK 0xf000
#define  DISTORT_VCL2_RESERVED2_SHIFT 12
#define  DISTORT_VCL2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_RESERVED2_MASK) >> DISTORT_VCL2_RESERVED2_SHIFT)
#define  DISTORT_VCL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL2_RESERVED2_SHIFT))

#define  DISTORT_VCL2_VCOEF0_MASK 0xfff
#define  DISTORT_VCL2_VCOEF0_SHIFT 0
#define  DISTORT_VCL2_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_VCOEF0_MASK) >> DISTORT_VCL2_VCOEF0_SHIFT)
#define  DISTORT_VCL2_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL2_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 4 of 16) (VCL3)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_VCL3_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL3_RESERVED1_SHIFT 28
#define  DISTORT_VCL3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_RESERVED1_MASK) >> DISTORT_VCL3_RESERVED1_SHIFT)
#define  DISTORT_VCL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL3_RESERVED1_SHIFT))

#define  DISTORT_VCL3_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL3_VCOEF1_SHIFT 16
#define  DISTORT_VCL3_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_VCOEF1_MASK) >> DISTORT_VCL3_VCOEF1_SHIFT)
#define  DISTORT_VCL3_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL3_VCOEF1_SHIFT))

#define  DISTORT_VCL3_RESERVED2_MASK 0xf000
#define  DISTORT_VCL3_RESERVED2_SHIFT 12
#define  DISTORT_VCL3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_RESERVED2_MASK) >> DISTORT_VCL3_RESERVED2_SHIFT)
#define  DISTORT_VCL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL3_RESERVED2_SHIFT))

#define  DISTORT_VCL3_VCOEF0_MASK 0xfff
#define  DISTORT_VCL3_VCOEF0_SHIFT 0
#define  DISTORT_VCL3_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_VCOEF0_MASK) >> DISTORT_VCL3_VCOEF0_SHIFT)
#define  DISTORT_VCL3_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL3_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 5 of 16) (VCL4)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_VCL4_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL4_RESERVED1_SHIFT 28
#define  DISTORT_VCL4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_RESERVED1_MASK) >> DISTORT_VCL4_RESERVED1_SHIFT)
#define  DISTORT_VCL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL4_RESERVED1_SHIFT))

#define  DISTORT_VCL4_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL4_VCOEF1_SHIFT 16
#define  DISTORT_VCL4_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_VCOEF1_MASK) >> DISTORT_VCL4_VCOEF1_SHIFT)
#define  DISTORT_VCL4_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL4_VCOEF1_SHIFT))

#define  DISTORT_VCL4_RESERVED2_MASK 0xf000
#define  DISTORT_VCL4_RESERVED2_SHIFT 12
#define  DISTORT_VCL4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_RESERVED2_MASK) >> DISTORT_VCL4_RESERVED2_SHIFT)
#define  DISTORT_VCL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL4_RESERVED2_SHIFT))

#define  DISTORT_VCL4_VCOEF0_MASK 0xfff
#define  DISTORT_VCL4_VCOEF0_SHIFT 0
#define  DISTORT_VCL4_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_VCOEF0_MASK) >> DISTORT_VCL4_VCOEF0_SHIFT)
#define  DISTORT_VCL4_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL4_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 6 of 16) (VCL5)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_VCL5_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL5_RESERVED1_SHIFT 28
#define  DISTORT_VCL5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_RESERVED1_MASK) >> DISTORT_VCL5_RESERVED1_SHIFT)
#define  DISTORT_VCL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL5_RESERVED1_SHIFT))

#define  DISTORT_VCL5_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL5_VCOEF1_SHIFT 16
#define  DISTORT_VCL5_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_VCOEF1_MASK) >> DISTORT_VCL5_VCOEF1_SHIFT)
#define  DISTORT_VCL5_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL5_VCOEF1_SHIFT))

#define  DISTORT_VCL5_RESERVED2_MASK 0xf000
#define  DISTORT_VCL5_RESERVED2_SHIFT 12
#define  DISTORT_VCL5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_RESERVED2_MASK) >> DISTORT_VCL5_RESERVED2_SHIFT)
#define  DISTORT_VCL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL5_RESERVED2_SHIFT))

#define  DISTORT_VCL5_VCOEF0_MASK 0xfff
#define  DISTORT_VCL5_VCOEF0_SHIFT 0
#define  DISTORT_VCL5_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_VCOEF0_MASK) >> DISTORT_VCL5_VCOEF0_SHIFT)
#define  DISTORT_VCL5_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL5_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 7 of 16) (VCL6)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_VCL6_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL6_RESERVED1_SHIFT 28
#define  DISTORT_VCL6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_RESERVED1_MASK) >> DISTORT_VCL6_RESERVED1_SHIFT)
#define  DISTORT_VCL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL6_RESERVED1_SHIFT))

#define  DISTORT_VCL6_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL6_VCOEF1_SHIFT 16
#define  DISTORT_VCL6_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_VCOEF1_MASK) >> DISTORT_VCL6_VCOEF1_SHIFT)
#define  DISTORT_VCL6_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL6_VCOEF1_SHIFT))

#define  DISTORT_VCL6_RESERVED2_MASK 0xf000
#define  DISTORT_VCL6_RESERVED2_SHIFT 12
#define  DISTORT_VCL6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_RESERVED2_MASK) >> DISTORT_VCL6_RESERVED2_SHIFT)
#define  DISTORT_VCL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL6_RESERVED2_SHIFT))

#define  DISTORT_VCL6_VCOEF0_MASK 0xfff
#define  DISTORT_VCL6_VCOEF0_SHIFT 0
#define  DISTORT_VCL6_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_VCOEF0_MASK) >> DISTORT_VCL6_VCOEF0_SHIFT)
#define  DISTORT_VCL6_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL6_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 8 of 16) (VCL7)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_VCL7_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL7_RESERVED1_SHIFT 28
#define  DISTORT_VCL7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_RESERVED1_MASK) >> DISTORT_VCL7_RESERVED1_SHIFT)
#define  DISTORT_VCL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL7_RESERVED1_SHIFT))

#define  DISTORT_VCL7_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL7_VCOEF1_SHIFT 16
#define  DISTORT_VCL7_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_VCOEF1_MASK) >> DISTORT_VCL7_VCOEF1_SHIFT)
#define  DISTORT_VCL7_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL7_VCOEF1_SHIFT))

#define  DISTORT_VCL7_RESERVED2_MASK 0xf000
#define  DISTORT_VCL7_RESERVED2_SHIFT 12
#define  DISTORT_VCL7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_RESERVED2_MASK) >> DISTORT_VCL7_RESERVED2_SHIFT)
#define  DISTORT_VCL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL7_RESERVED2_SHIFT))

#define  DISTORT_VCL7_VCOEF0_MASK 0xfff
#define  DISTORT_VCL7_VCOEF0_SHIFT 0
#define  DISTORT_VCL7_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_VCOEF0_MASK) >> DISTORT_VCL7_VCOEF0_SHIFT)
#define  DISTORT_VCL7_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL7_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 9 of 16) (VCL8)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_VCL8_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL8_RESERVED1_SHIFT 28
#define  DISTORT_VCL8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_RESERVED1_MASK) >> DISTORT_VCL8_RESERVED1_SHIFT)
#define  DISTORT_VCL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL8_RESERVED1_SHIFT))

#define  DISTORT_VCL8_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL8_VCOEF1_SHIFT 16
#define  DISTORT_VCL8_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_VCOEF1_MASK) >> DISTORT_VCL8_VCOEF1_SHIFT)
#define  DISTORT_VCL8_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL8_VCOEF1_SHIFT))

#define  DISTORT_VCL8_RESERVED2_MASK 0xf000
#define  DISTORT_VCL8_RESERVED2_SHIFT 12
#define  DISTORT_VCL8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_RESERVED2_MASK) >> DISTORT_VCL8_RESERVED2_SHIFT)
#define  DISTORT_VCL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL8_RESERVED2_SHIFT))

#define  DISTORT_VCL8_VCOEF0_MASK 0xfff
#define  DISTORT_VCL8_VCOEF0_SHIFT 0
#define  DISTORT_VCL8_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_VCOEF0_MASK) >> DISTORT_VCL8_VCOEF0_SHIFT)
#define  DISTORT_VCL8_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL8_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 10 of 16) (VCL9)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_VCL9_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL9_RESERVED1_SHIFT 28
#define  DISTORT_VCL9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_RESERVED1_MASK) >> DISTORT_VCL9_RESERVED1_SHIFT)
#define  DISTORT_VCL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL9_RESERVED1_SHIFT))

#define  DISTORT_VCL9_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL9_VCOEF1_SHIFT 16
#define  DISTORT_VCL9_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_VCOEF1_MASK) >> DISTORT_VCL9_VCOEF1_SHIFT)
#define  DISTORT_VCL9_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL9_VCOEF1_SHIFT))

#define  DISTORT_VCL9_RESERVED2_MASK 0xf000
#define  DISTORT_VCL9_RESERVED2_SHIFT 12
#define  DISTORT_VCL9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_RESERVED2_MASK) >> DISTORT_VCL9_RESERVED2_SHIFT)
#define  DISTORT_VCL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL9_RESERVED2_SHIFT))

#define  DISTORT_VCL9_VCOEF0_MASK 0xfff
#define  DISTORT_VCL9_VCOEF0_SHIFT 0
#define  DISTORT_VCL9_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_VCOEF0_MASK) >> DISTORT_VCL9_VCOEF0_SHIFT)
#define  DISTORT_VCL9_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL9_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 11 of 16) (VCL10)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_VCL10_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL10_RESERVED1_SHIFT 28
#define  DISTORT_VCL10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_RESERVED1_MASK) >> DISTORT_VCL10_RESERVED1_SHIFT)
#define  DISTORT_VCL10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL10_RESERVED1_SHIFT))

#define  DISTORT_VCL10_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL10_VCOEF1_SHIFT 16
#define  DISTORT_VCL10_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_VCOEF1_MASK) >> DISTORT_VCL10_VCOEF1_SHIFT)
#define  DISTORT_VCL10_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL10_VCOEF1_SHIFT))

#define  DISTORT_VCL10_RESERVED2_MASK 0xf000
#define  DISTORT_VCL10_RESERVED2_SHIFT 12
#define  DISTORT_VCL10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_RESERVED2_MASK) >> DISTORT_VCL10_RESERVED2_SHIFT)
#define  DISTORT_VCL10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL10_RESERVED2_SHIFT))

#define  DISTORT_VCL10_VCOEF0_MASK 0xfff
#define  DISTORT_VCL10_VCOEF0_SHIFT 0
#define  DISTORT_VCL10_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_VCOEF0_MASK) >> DISTORT_VCL10_VCOEF0_SHIFT)
#define  DISTORT_VCL10_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL10_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 12 of 16) (VCL11)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_VCL11_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL11_RESERVED1_SHIFT 28
#define  DISTORT_VCL11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_RESERVED1_MASK) >> DISTORT_VCL11_RESERVED1_SHIFT)
#define  DISTORT_VCL11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL11_RESERVED1_SHIFT))

#define  DISTORT_VCL11_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL11_VCOEF1_SHIFT 16
#define  DISTORT_VCL11_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_VCOEF1_MASK) >> DISTORT_VCL11_VCOEF1_SHIFT)
#define  DISTORT_VCL11_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL11_VCOEF1_SHIFT))

#define  DISTORT_VCL11_RESERVED2_MASK 0xf000
#define  DISTORT_VCL11_RESERVED2_SHIFT 12
#define  DISTORT_VCL11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_RESERVED2_MASK) >> DISTORT_VCL11_RESERVED2_SHIFT)
#define  DISTORT_VCL11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL11_RESERVED2_SHIFT))

#define  DISTORT_VCL11_VCOEF0_MASK 0xfff
#define  DISTORT_VCL11_VCOEF0_SHIFT 0
#define  DISTORT_VCL11_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_VCOEF0_MASK) >> DISTORT_VCL11_VCOEF0_SHIFT)
#define  DISTORT_VCL11_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL11_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 13 of 16) (VCL12)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_VCL12_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL12_RESERVED1_SHIFT 28
#define  DISTORT_VCL12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_RESERVED1_MASK) >> DISTORT_VCL12_RESERVED1_SHIFT)
#define  DISTORT_VCL12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL12_RESERVED1_SHIFT))

#define  DISTORT_VCL12_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL12_VCOEF1_SHIFT 16
#define  DISTORT_VCL12_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_VCOEF1_MASK) >> DISTORT_VCL12_VCOEF1_SHIFT)
#define  DISTORT_VCL12_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL12_VCOEF1_SHIFT))

#define  DISTORT_VCL12_RESERVED2_MASK 0xf000
#define  DISTORT_VCL12_RESERVED2_SHIFT 12
#define  DISTORT_VCL12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_RESERVED2_MASK) >> DISTORT_VCL12_RESERVED2_SHIFT)
#define  DISTORT_VCL12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL12_RESERVED2_SHIFT))

#define  DISTORT_VCL12_VCOEF0_MASK 0xfff
#define  DISTORT_VCL12_VCOEF0_SHIFT 0
#define  DISTORT_VCL12_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_VCOEF0_MASK) >> DISTORT_VCL12_VCOEF0_SHIFT)
#define  DISTORT_VCL12_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL12_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 14 of 16) (VCL13)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_VCL13_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL13_RESERVED1_SHIFT 28
#define  DISTORT_VCL13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_RESERVED1_MASK) >> DISTORT_VCL13_RESERVED1_SHIFT)
#define  DISTORT_VCL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL13_RESERVED1_SHIFT))

#define  DISTORT_VCL13_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL13_VCOEF1_SHIFT 16
#define  DISTORT_VCL13_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_VCOEF1_MASK) >> DISTORT_VCL13_VCOEF1_SHIFT)
#define  DISTORT_VCL13_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL13_VCOEF1_SHIFT))

#define  DISTORT_VCL13_RESERVED2_MASK 0xf000
#define  DISTORT_VCL13_RESERVED2_SHIFT 12
#define  DISTORT_VCL13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_RESERVED2_MASK) >> DISTORT_VCL13_RESERVED2_SHIFT)
#define  DISTORT_VCL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL13_RESERVED2_SHIFT))

#define  DISTORT_VCL13_VCOEF0_MASK 0xfff
#define  DISTORT_VCL13_VCOEF0_SHIFT 0
#define  DISTORT_VCL13_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_VCOEF0_MASK) >> DISTORT_VCL13_VCOEF0_SHIFT)
#define  DISTORT_VCL13_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL13_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 15 of 16) (VCL14)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_VCL14_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL14_RESERVED1_SHIFT 28
#define  DISTORT_VCL14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_RESERVED1_MASK) >> DISTORT_VCL14_RESERVED1_SHIFT)
#define  DISTORT_VCL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL14_RESERVED1_SHIFT))

#define  DISTORT_VCL14_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL14_VCOEF1_SHIFT 16
#define  DISTORT_VCL14_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_VCOEF1_MASK) >> DISTORT_VCL14_VCOEF1_SHIFT)
#define  DISTORT_VCL14_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL14_VCOEF1_SHIFT))

#define  DISTORT_VCL14_RESERVED2_MASK 0xf000
#define  DISTORT_VCL14_RESERVED2_SHIFT 12
#define  DISTORT_VCL14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_RESERVED2_MASK) >> DISTORT_VCL14_RESERVED2_SHIFT)
#define  DISTORT_VCL14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL14_RESERVED2_SHIFT))

#define  DISTORT_VCL14_VCOEF0_MASK 0xfff
#define  DISTORT_VCL14_VCOEF0_SHIFT 0
#define  DISTORT_VCL14_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_VCOEF0_MASK) >> DISTORT_VCL14_VCOEF0_SHIFT)
#define  DISTORT_VCL14_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL14_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 16 of 16) (VCL15)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_VCL15_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL15_RESERVED1_SHIFT 28
#define  DISTORT_VCL15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_RESERVED1_MASK) >> DISTORT_VCL15_RESERVED1_SHIFT)
#define  DISTORT_VCL15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL15_RESERVED1_SHIFT))

#define  DISTORT_VCL15_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL15_VCOEF1_SHIFT 16
#define  DISTORT_VCL15_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_VCOEF1_MASK) >> DISTORT_VCL15_VCOEF1_SHIFT)
#define  DISTORT_VCL15_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL15_VCOEF1_SHIFT))

#define  DISTORT_VCL15_RESERVED2_MASK 0xf000
#define  DISTORT_VCL15_RESERVED2_SHIFT 12
#define  DISTORT_VCL15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_RESERVED2_MASK) >> DISTORT_VCL15_RESERVED2_SHIFT)
#define  DISTORT_VCL15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL15_RESERVED2_SHIFT))

#define  DISTORT_VCL15_VCOEF0_MASK 0xfff
#define  DISTORT_VCL15_VCOEF0_SHIFT 0
#define  DISTORT_VCL15_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_VCOEF0_MASK) >> DISTORT_VCL15_VCOEF0_SHIFT)
#define  DISTORT_VCL15_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL15_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 1 of 16) (VCH0)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_VCH0_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH0_RESERVED1_SHIFT 28
#define  DISTORT_VCH0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_RESERVED1_MASK) >> DISTORT_VCH0_RESERVED1_SHIFT)
#define  DISTORT_VCH0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH0_RESERVED1_SHIFT))

#define  DISTORT_VCH0_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH0_VCOEF3_SHIFT 16
#define  DISTORT_VCH0_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_VCOEF3_MASK) >> DISTORT_VCH0_VCOEF3_SHIFT)
#define  DISTORT_VCH0_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH0_VCOEF3_SHIFT))

#define  DISTORT_VCH0_RESERVED2_MASK 0xf000
#define  DISTORT_VCH0_RESERVED2_SHIFT 12
#define  DISTORT_VCH0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_RESERVED2_MASK) >> DISTORT_VCH0_RESERVED2_SHIFT)
#define  DISTORT_VCH0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH0_RESERVED2_SHIFT))

#define  DISTORT_VCH0_VCOEF2_MASK 0xfff
#define  DISTORT_VCH0_VCOEF2_SHIFT 0
#define  DISTORT_VCH0_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_VCOEF2_MASK) >> DISTORT_VCH0_VCOEF2_SHIFT)
#define  DISTORT_VCH0_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH0_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 2 of 16) (VCH1)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_VCH1_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH1_RESERVED1_SHIFT 28
#define  DISTORT_VCH1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_RESERVED1_MASK) >> DISTORT_VCH1_RESERVED1_SHIFT)
#define  DISTORT_VCH1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH1_RESERVED1_SHIFT))

#define  DISTORT_VCH1_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH1_VCOEF3_SHIFT 16
#define  DISTORT_VCH1_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_VCOEF3_MASK) >> DISTORT_VCH1_VCOEF3_SHIFT)
#define  DISTORT_VCH1_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH1_VCOEF3_SHIFT))

#define  DISTORT_VCH1_RESERVED2_MASK 0xf000
#define  DISTORT_VCH1_RESERVED2_SHIFT 12
#define  DISTORT_VCH1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_RESERVED2_MASK) >> DISTORT_VCH1_RESERVED2_SHIFT)
#define  DISTORT_VCH1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH1_RESERVED2_SHIFT))

#define  DISTORT_VCH1_VCOEF2_MASK 0xfff
#define  DISTORT_VCH1_VCOEF2_SHIFT 0
#define  DISTORT_VCH1_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_VCOEF2_MASK) >> DISTORT_VCH1_VCOEF2_SHIFT)
#define  DISTORT_VCH1_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH1_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 3 of 16) (VCH2)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_VCH2_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH2_RESERVED1_SHIFT 28
#define  DISTORT_VCH2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_RESERVED1_MASK) >> DISTORT_VCH2_RESERVED1_SHIFT)
#define  DISTORT_VCH2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH2_RESERVED1_SHIFT))

#define  DISTORT_VCH2_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH2_VCOEF3_SHIFT 16
#define  DISTORT_VCH2_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_VCOEF3_MASK) >> DISTORT_VCH2_VCOEF3_SHIFT)
#define  DISTORT_VCH2_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH2_VCOEF3_SHIFT))

#define  DISTORT_VCH2_RESERVED2_MASK 0xf000
#define  DISTORT_VCH2_RESERVED2_SHIFT 12
#define  DISTORT_VCH2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_RESERVED2_MASK) >> DISTORT_VCH2_RESERVED2_SHIFT)
#define  DISTORT_VCH2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH2_RESERVED2_SHIFT))

#define  DISTORT_VCH2_VCOEF2_MASK 0xfff
#define  DISTORT_VCH2_VCOEF2_SHIFT 0
#define  DISTORT_VCH2_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_VCOEF2_MASK) >> DISTORT_VCH2_VCOEF2_SHIFT)
#define  DISTORT_VCH2_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH2_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 4 of 16) (VCH3)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_VCH3_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH3_RESERVED1_SHIFT 28
#define  DISTORT_VCH3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_RESERVED1_MASK) >> DISTORT_VCH3_RESERVED1_SHIFT)
#define  DISTORT_VCH3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH3_RESERVED1_SHIFT))

#define  DISTORT_VCH3_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH3_VCOEF3_SHIFT 16
#define  DISTORT_VCH3_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_VCOEF3_MASK) >> DISTORT_VCH3_VCOEF3_SHIFT)
#define  DISTORT_VCH3_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH3_VCOEF3_SHIFT))

#define  DISTORT_VCH3_RESERVED2_MASK 0xf000
#define  DISTORT_VCH3_RESERVED2_SHIFT 12
#define  DISTORT_VCH3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_RESERVED2_MASK) >> DISTORT_VCH3_RESERVED2_SHIFT)
#define  DISTORT_VCH3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH3_RESERVED2_SHIFT))

#define  DISTORT_VCH3_VCOEF2_MASK 0xfff
#define  DISTORT_VCH3_VCOEF2_SHIFT 0
#define  DISTORT_VCH3_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_VCOEF2_MASK) >> DISTORT_VCH3_VCOEF2_SHIFT)
#define  DISTORT_VCH3_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH3_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 5 of 16) (VCH4)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_VCH4_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH4_RESERVED1_SHIFT 28
#define  DISTORT_VCH4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_RESERVED1_MASK) >> DISTORT_VCH4_RESERVED1_SHIFT)
#define  DISTORT_VCH4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH4_RESERVED1_SHIFT))

#define  DISTORT_VCH4_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH4_VCOEF3_SHIFT 16
#define  DISTORT_VCH4_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_VCOEF3_MASK) >> DISTORT_VCH4_VCOEF3_SHIFT)
#define  DISTORT_VCH4_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH4_VCOEF3_SHIFT))

#define  DISTORT_VCH4_RESERVED2_MASK 0xf000
#define  DISTORT_VCH4_RESERVED2_SHIFT 12
#define  DISTORT_VCH4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_RESERVED2_MASK) >> DISTORT_VCH4_RESERVED2_SHIFT)
#define  DISTORT_VCH4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH4_RESERVED2_SHIFT))

#define  DISTORT_VCH4_VCOEF2_MASK 0xfff
#define  DISTORT_VCH4_VCOEF2_SHIFT 0
#define  DISTORT_VCH4_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_VCOEF2_MASK) >> DISTORT_VCH4_VCOEF2_SHIFT)
#define  DISTORT_VCH4_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH4_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 6 of 16) (VCH5)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_VCH5_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH5_RESERVED1_SHIFT 28
#define  DISTORT_VCH5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_RESERVED1_MASK) >> DISTORT_VCH5_RESERVED1_SHIFT)
#define  DISTORT_VCH5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH5_RESERVED1_SHIFT))

#define  DISTORT_VCH5_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH5_VCOEF3_SHIFT 16
#define  DISTORT_VCH5_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_VCOEF3_MASK) >> DISTORT_VCH5_VCOEF3_SHIFT)
#define  DISTORT_VCH5_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH5_VCOEF3_SHIFT))

#define  DISTORT_VCH5_RESERVED2_MASK 0xf000
#define  DISTORT_VCH5_RESERVED2_SHIFT 12
#define  DISTORT_VCH5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_RESERVED2_MASK) >> DISTORT_VCH5_RESERVED2_SHIFT)
#define  DISTORT_VCH5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH5_RESERVED2_SHIFT))

#define  DISTORT_VCH5_VCOEF2_MASK 0xfff
#define  DISTORT_VCH5_VCOEF2_SHIFT 0
#define  DISTORT_VCH5_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_VCOEF2_MASK) >> DISTORT_VCH5_VCOEF2_SHIFT)
#define  DISTORT_VCH5_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH5_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 7 of 16) (VCH6)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_VCH6_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH6_RESERVED1_SHIFT 28
#define  DISTORT_VCH6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_RESERVED1_MASK) >> DISTORT_VCH6_RESERVED1_SHIFT)
#define  DISTORT_VCH6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH6_RESERVED1_SHIFT))

#define  DISTORT_VCH6_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH6_VCOEF3_SHIFT 16
#define  DISTORT_VCH6_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_VCOEF3_MASK) >> DISTORT_VCH6_VCOEF3_SHIFT)
#define  DISTORT_VCH6_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH6_VCOEF3_SHIFT))

#define  DISTORT_VCH6_RESERVED2_MASK 0xf000
#define  DISTORT_VCH6_RESERVED2_SHIFT 12
#define  DISTORT_VCH6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_RESERVED2_MASK) >> DISTORT_VCH6_RESERVED2_SHIFT)
#define  DISTORT_VCH6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH6_RESERVED2_SHIFT))

#define  DISTORT_VCH6_VCOEF2_MASK 0xfff
#define  DISTORT_VCH6_VCOEF2_SHIFT 0
#define  DISTORT_VCH6_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_VCOEF2_MASK) >> DISTORT_VCH6_VCOEF2_SHIFT)
#define  DISTORT_VCH6_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH6_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 8 of 16) (VCH7)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_VCH7_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH7_RESERVED1_SHIFT 28
#define  DISTORT_VCH7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_RESERVED1_MASK) >> DISTORT_VCH7_RESERVED1_SHIFT)
#define  DISTORT_VCH7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH7_RESERVED1_SHIFT))

#define  DISTORT_VCH7_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH7_VCOEF3_SHIFT 16
#define  DISTORT_VCH7_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_VCOEF3_MASK) >> DISTORT_VCH7_VCOEF3_SHIFT)
#define  DISTORT_VCH7_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH7_VCOEF3_SHIFT))

#define  DISTORT_VCH7_RESERVED2_MASK 0xf000
#define  DISTORT_VCH7_RESERVED2_SHIFT 12
#define  DISTORT_VCH7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_RESERVED2_MASK) >> DISTORT_VCH7_RESERVED2_SHIFT)
#define  DISTORT_VCH7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH7_RESERVED2_SHIFT))

#define  DISTORT_VCH7_VCOEF2_MASK 0xfff
#define  DISTORT_VCH7_VCOEF2_SHIFT 0
#define  DISTORT_VCH7_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_VCOEF2_MASK) >> DISTORT_VCH7_VCOEF2_SHIFT)
#define  DISTORT_VCH7_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH7_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 9 of 16) (VCH8)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_VCH8_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH8_RESERVED1_SHIFT 28
#define  DISTORT_VCH8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_RESERVED1_MASK) >> DISTORT_VCH8_RESERVED1_SHIFT)
#define  DISTORT_VCH8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH8_RESERVED1_SHIFT))

#define  DISTORT_VCH8_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH8_VCOEF3_SHIFT 16
#define  DISTORT_VCH8_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_VCOEF3_MASK) >> DISTORT_VCH8_VCOEF3_SHIFT)
#define  DISTORT_VCH8_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH8_VCOEF3_SHIFT))

#define  DISTORT_VCH8_RESERVED2_MASK 0xf000
#define  DISTORT_VCH8_RESERVED2_SHIFT 12
#define  DISTORT_VCH8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_RESERVED2_MASK) >> DISTORT_VCH8_RESERVED2_SHIFT)
#define  DISTORT_VCH8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH8_RESERVED2_SHIFT))

#define  DISTORT_VCH8_VCOEF2_MASK 0xfff
#define  DISTORT_VCH8_VCOEF2_SHIFT 0
#define  DISTORT_VCH8_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_VCOEF2_MASK) >> DISTORT_VCH8_VCOEF2_SHIFT)
#define  DISTORT_VCH8_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH8_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 10 of 16) (VCH9)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_VCH9_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH9_RESERVED1_SHIFT 28
#define  DISTORT_VCH9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_RESERVED1_MASK) >> DISTORT_VCH9_RESERVED1_SHIFT)
#define  DISTORT_VCH9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH9_RESERVED1_SHIFT))

#define  DISTORT_VCH9_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH9_VCOEF3_SHIFT 16
#define  DISTORT_VCH9_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_VCOEF3_MASK) >> DISTORT_VCH9_VCOEF3_SHIFT)
#define  DISTORT_VCH9_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH9_VCOEF3_SHIFT))

#define  DISTORT_VCH9_RESERVED2_MASK 0xf000
#define  DISTORT_VCH9_RESERVED2_SHIFT 12
#define  DISTORT_VCH9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_RESERVED2_MASK) >> DISTORT_VCH9_RESERVED2_SHIFT)
#define  DISTORT_VCH9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH9_RESERVED2_SHIFT))

#define  DISTORT_VCH9_VCOEF2_MASK 0xfff
#define  DISTORT_VCH9_VCOEF2_SHIFT 0
#define  DISTORT_VCH9_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_VCOEF2_MASK) >> DISTORT_VCH9_VCOEF2_SHIFT)
#define  DISTORT_VCH9_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH9_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 11 of 16) (VCH10)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_VCH10_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH10_RESERVED1_SHIFT 28
#define  DISTORT_VCH10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_RESERVED1_MASK) >> DISTORT_VCH10_RESERVED1_SHIFT)
#define  DISTORT_VCH10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH10_RESERVED1_SHIFT))

#define  DISTORT_VCH10_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH10_VCOEF3_SHIFT 16
#define  DISTORT_VCH10_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_VCOEF3_MASK) >> DISTORT_VCH10_VCOEF3_SHIFT)
#define  DISTORT_VCH10_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH10_VCOEF3_SHIFT))

#define  DISTORT_VCH10_RESERVED2_MASK 0xf000
#define  DISTORT_VCH10_RESERVED2_SHIFT 12
#define  DISTORT_VCH10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_RESERVED2_MASK) >> DISTORT_VCH10_RESERVED2_SHIFT)
#define  DISTORT_VCH10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH10_RESERVED2_SHIFT))

#define  DISTORT_VCH10_VCOEF2_MASK 0xfff
#define  DISTORT_VCH10_VCOEF2_SHIFT 0
#define  DISTORT_VCH10_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_VCOEF2_MASK) >> DISTORT_VCH10_VCOEF2_SHIFT)
#define  DISTORT_VCH10_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH10_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 12 of 16) (VCH11)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_VCH11_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH11_RESERVED1_SHIFT 28
#define  DISTORT_VCH11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_RESERVED1_MASK) >> DISTORT_VCH11_RESERVED1_SHIFT)
#define  DISTORT_VCH11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH11_RESERVED1_SHIFT))

#define  DISTORT_VCH11_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH11_VCOEF3_SHIFT 16
#define  DISTORT_VCH11_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_VCOEF3_MASK) >> DISTORT_VCH11_VCOEF3_SHIFT)
#define  DISTORT_VCH11_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH11_VCOEF3_SHIFT))

#define  DISTORT_VCH11_RESERVED2_MASK 0xf000
#define  DISTORT_VCH11_RESERVED2_SHIFT 12
#define  DISTORT_VCH11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_RESERVED2_MASK) >> DISTORT_VCH11_RESERVED2_SHIFT)
#define  DISTORT_VCH11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH11_RESERVED2_SHIFT))

#define  DISTORT_VCH11_VCOEF2_MASK 0xfff
#define  DISTORT_VCH11_VCOEF2_SHIFT 0
#define  DISTORT_VCH11_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_VCOEF2_MASK) >> DISTORT_VCH11_VCOEF2_SHIFT)
#define  DISTORT_VCH11_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH11_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 13 of 16) (VCH12)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_VCH12_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH12_RESERVED1_SHIFT 28
#define  DISTORT_VCH12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_RESERVED1_MASK) >> DISTORT_VCH12_RESERVED1_SHIFT)
#define  DISTORT_VCH12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH12_RESERVED1_SHIFT))

#define  DISTORT_VCH12_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH12_VCOEF3_SHIFT 16
#define  DISTORT_VCH12_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_VCOEF3_MASK) >> DISTORT_VCH12_VCOEF3_SHIFT)
#define  DISTORT_VCH12_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH12_VCOEF3_SHIFT))

#define  DISTORT_VCH12_RESERVED2_MASK 0xf000
#define  DISTORT_VCH12_RESERVED2_SHIFT 12
#define  DISTORT_VCH12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_RESERVED2_MASK) >> DISTORT_VCH12_RESERVED2_SHIFT)
#define  DISTORT_VCH12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH12_RESERVED2_SHIFT))

#define  DISTORT_VCH12_VCOEF2_MASK 0xfff
#define  DISTORT_VCH12_VCOEF2_SHIFT 0
#define  DISTORT_VCH12_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_VCOEF2_MASK) >> DISTORT_VCH12_VCOEF2_SHIFT)
#define  DISTORT_VCH12_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH12_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 14 of 16) (VCH13)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_VCH13_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH13_RESERVED1_SHIFT 28
#define  DISTORT_VCH13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_RESERVED1_MASK) >> DISTORT_VCH13_RESERVED1_SHIFT)
#define  DISTORT_VCH13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH13_RESERVED1_SHIFT))

#define  DISTORT_VCH13_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH13_VCOEF3_SHIFT 16
#define  DISTORT_VCH13_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_VCOEF3_MASK) >> DISTORT_VCH13_VCOEF3_SHIFT)
#define  DISTORT_VCH13_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH13_VCOEF3_SHIFT))

#define  DISTORT_VCH13_RESERVED2_MASK 0xf000
#define  DISTORT_VCH13_RESERVED2_SHIFT 12
#define  DISTORT_VCH13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_RESERVED2_MASK) >> DISTORT_VCH13_RESERVED2_SHIFT)
#define  DISTORT_VCH13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH13_RESERVED2_SHIFT))

#define  DISTORT_VCH13_VCOEF2_MASK 0xfff
#define  DISTORT_VCH13_VCOEF2_SHIFT 0
#define  DISTORT_VCH13_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_VCOEF2_MASK) >> DISTORT_VCH13_VCOEF2_SHIFT)
#define  DISTORT_VCH13_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH13_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 15 of 16) (VCH14)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_VCH14_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH14_RESERVED1_SHIFT 28
#define  DISTORT_VCH14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_RESERVED1_MASK) >> DISTORT_VCH14_RESERVED1_SHIFT)
#define  DISTORT_VCH14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH14_RESERVED1_SHIFT))

#define  DISTORT_VCH14_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH14_VCOEF3_SHIFT 16
#define  DISTORT_VCH14_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_VCOEF3_MASK) >> DISTORT_VCH14_VCOEF3_SHIFT)
#define  DISTORT_VCH14_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH14_VCOEF3_SHIFT))

#define  DISTORT_VCH14_RESERVED2_MASK 0xf000
#define  DISTORT_VCH14_RESERVED2_SHIFT 12
#define  DISTORT_VCH14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_RESERVED2_MASK) >> DISTORT_VCH14_RESERVED2_SHIFT)
#define  DISTORT_VCH14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH14_RESERVED2_SHIFT))

#define  DISTORT_VCH14_VCOEF2_MASK 0xfff
#define  DISTORT_VCH14_VCOEF2_SHIFT 0
#define  DISTORT_VCH14_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_VCOEF2_MASK) >> DISTORT_VCH14_VCOEF2_SHIFT)
#define  DISTORT_VCH14_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH14_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 16 of 16) (VCH15)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_VCH15_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH15_RESERVED1_SHIFT 28
#define  DISTORT_VCH15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_RESERVED1_MASK) >> DISTORT_VCH15_RESERVED1_SHIFT)
#define  DISTORT_VCH15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH15_RESERVED1_SHIFT))

#define  DISTORT_VCH15_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH15_VCOEF3_SHIFT 16
#define  DISTORT_VCH15_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_VCOEF3_MASK) >> DISTORT_VCH15_VCOEF3_SHIFT)
#define  DISTORT_VCH15_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH15_VCOEF3_SHIFT))

#define  DISTORT_VCH15_RESERVED2_MASK 0xf000
#define  DISTORT_VCH15_RESERVED2_SHIFT 12
#define  DISTORT_VCH15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_RESERVED2_MASK) >> DISTORT_VCH15_RESERVED2_SHIFT)
#define  DISTORT_VCH15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH15_RESERVED2_SHIFT))

#define  DISTORT_VCH15_VCOEF2_MASK 0xfff
#define  DISTORT_VCH15_VCOEF2_SHIFT 0
#define  DISTORT_VCH15_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_VCOEF2_MASK) >> DISTORT_VCH15_VCOEF2_SHIFT)
#define  DISTORT_VCH15_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH15_VCOEF2_SHIFT))

#endif // DISTORT
