 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_TOP_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_TOP_REGSTRUCTS_H_
#define _DISTORT_TOP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT_TOP Testbench (DISTORT_TOP)
/** \brief Register Descriptions for the DISTORT_TOP Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE LUT1D_BDE, ANTIFCOR, DISTORT_DMA (ANTIFCOR_TOP)
/** \brief Register Descriptions for the ANTIFCOR Top Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Distort (DISTORT)
/** \brief Register file for the DISTORT block
(rev 0 . 4 . 0 . 0)*/
//
//====================================================================

typedef struct DISTORT_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Distort Configuration Register
  volatile uint32_t Strip;  ///< 0x4 [W]: Strip Register
  volatile uint32_t OutputStripDimension;  ///< 0x8 [R/W]: Output Strip Size
  volatile uint32_t IntEnable;  ///< 0xc [R/W]: DISTORT Interrupt Enable Register
  volatile uint32_t IntPending;  ///< 0x10 [R]: DISTORT Interrupt Pending Register
  volatile uint32_t IntClear;  ///< 0x14 [W]: DISTORT Interrupt Clear Register
  volatile uint32_t IntForce;  ///< 0x18 [W]: DISTORT Interrupt Force Register
  volatile uint32_t reserved0;
  volatile uint32_t Ch1_ImageDimension;  ///< 0x20 [R/W]: Input Image Size
  volatile uint32_t Ch2_ImageDimension;  ///< 0x24 [R/W]: Input Image Size
  volatile uint32_t Ch3_ImageDimension;  ///< 0x28 [R/W]: Input Image Size
  volatile uint32_t reserved1;
  volatile uint32_t Ch1_DataStartPos_X;  ///< 0x30 [R/W]: Horizontal Data Start Position
  volatile uint32_t Ch2_DataStartPos_X;  ///< 0x34 [R/W]: Horizontal Data Start Position
  volatile uint32_t Ch3_DataStartPos_X;  ///< 0x38 [R/W]: Horizontal Data Start Position
  volatile uint32_t reserved2;
  volatile uint32_t Ch1_DataStartPos_Y;  ///< 0x40 [R/W]: Vertical Data Start Position
  volatile uint32_t Ch2_DataStartPos_Y;  ///< 0x44 [R/W]: Vertical Data Start Position
  volatile uint32_t Ch3_DataStartPos_Y;  ///< 0x48 [R/W]: Vertical Data Start Position
  volatile uint32_t reserved3;
  volatile uint32_t Ch1_FixedRowStepX;  ///< 0x50 [R/W]: Fixed Row Step X for channel 1 in non-MapMode
  volatile uint32_t Ch2_FixedRowStepX;  ///< 0x54 [R/W]: Fixed Row Step X for channel 2 in non-MapMode
  volatile uint32_t Ch3_FixedRowStepX;  ///< 0x58 [R/W]: Fixed Row Step X for channel 3 in non-MapMode
  volatile uint32_t reserved4;
  volatile uint32_t Ch1_FixedRowStepY;  ///< 0x60 [R/W]: Fixed Row Step Y for channel 1 in non-MapMode
  volatile uint32_t Ch2_FixedRowStepY;  ///< 0x64 [R/W]: Fixed Row Step Y for channel 2 in non-MapMode
  volatile uint32_t Ch3_FixedRowStepY;  ///< 0x68 [R/W]: Fixed Row Step Y for channel 3 in non-MapMode
  volatile uint32_t reserved5;
  volatile uint32_t Ch1_FixedColStepX;  ///< 0x70 [R/W]: Fixed Col Step X for channel 1 in non-MapMode
  volatile uint32_t Ch2_FixedColStepX;  ///< 0x74 [R/W]: Fixed Col Step X for channel 2 in non-MapMode
  volatile uint32_t Ch3_FixedColStepX;  ///< 0x78 [R/W]: Fixed Col Step X for channel 3 in non-MapMode
  volatile uint32_t reserved6;
  volatile uint32_t Ch1_FixedColStepY;  ///< 0x80 [R/W]: Fixed Col Step Y for channel 1 in non-MapMode
  volatile uint32_t Ch2_FixedColStepY;  ///< 0x84 [R/W]: Fixed Col Step Y for channel 2 in non-MapMode
  volatile uint32_t Ch3_FixedColStepY;  ///< 0x88 [R/W]: Fixed Col Step Y for channel 3 in non-MapMode
  volatile uint32_t reserved7;
  volatile uint32_t Ch1_BlankValue;  ///< 0x90 [R/W]: Blank value for channel 1
  volatile uint32_t Ch2_BlankValue;  ///< 0x94 [R/W]: Blank value for channel 2
  volatile uint32_t Ch3_BlankValue;  ///< 0x98 [R/W]: Blank value for channel 3
  volatile uint32_t reserved8;
  volatile uint32_t Ch1_HighestLine;  ///< 0xa0 [R]: Highest line for channel 1
  volatile uint32_t Ch2_HighestLine;  ///< 0xa4 [R]: Highest line for channel 2
  volatile uint32_t Ch3_HighestLine;  ///< 0xa8 [R]: Highest line for channel 3
  volatile uint32_t reserved9;
  volatile uint32_t OperationStatus;  ///< 0xb0 [R]: 
  volatile uint32_t CurrentPosition;  ///< 0xb4 [R]: Current Position
  volatile uint32_t PosSelect;  ///< 0xb8 [R/W]: Position Select
  volatile uint32_t reserved10[81];
  volatile uint32_t REV0;  ///< 0x200 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x204 [R]: IP Tagging Revision 1
  volatile uint32_t reserved11[62];
  volatile uint32_t HCL0;  ///< 0x300 [R/W]: Horizontal Coefficient 0 / 1 (Instance 1 of 16)
  volatile uint32_t HCH0;  ///< 0x304 [R/W]: Horizontal Coefficient 2 / 3 (Instance 1 of 16)
  volatile uint32_t HCL1;  ///< 0x308 [R/W]: Horizontal Coefficient 0 / 1 (Instance 2 of 16)
  volatile uint32_t HCH1;  ///< 0x30c [R/W]: Horizontal Coefficient 2 / 3 (Instance 2 of 16)
  volatile uint32_t HCL2;  ///< 0x310 [R/W]: Horizontal Coefficient 0 / 1 (Instance 3 of 16)
  volatile uint32_t HCH2;  ///< 0x314 [R/W]: Horizontal Coefficient 2 / 3 (Instance 3 of 16)
  volatile uint32_t HCL3;  ///< 0x318 [R/W]: Horizontal Coefficient 0 / 1 (Instance 4 of 16)
  volatile uint32_t HCH3;  ///< 0x31c [R/W]: Horizontal Coefficient 2 / 3 (Instance 4 of 16)
  volatile uint32_t HCL4;  ///< 0x320 [R/W]: Horizontal Coefficient 0 / 1 (Instance 5 of 16)
  volatile uint32_t HCH4;  ///< 0x324 [R/W]: Horizontal Coefficient 2 / 3 (Instance 5 of 16)
  volatile uint32_t HCL5;  ///< 0x328 [R/W]: Horizontal Coefficient 0 / 1 (Instance 6 of 16)
  volatile uint32_t HCH5;  ///< 0x32c [R/W]: Horizontal Coefficient 2 / 3 (Instance 6 of 16)
  volatile uint32_t HCL6;  ///< 0x330 [R/W]: Horizontal Coefficient 0 / 1 (Instance 7 of 16)
  volatile uint32_t HCH6;  ///< 0x334 [R/W]: Horizontal Coefficient 2 / 3 (Instance 7 of 16)
  volatile uint32_t HCL7;  ///< 0x338 [R/W]: Horizontal Coefficient 0 / 1 (Instance 8 of 16)
  volatile uint32_t HCH7;  ///< 0x33c [R/W]: Horizontal Coefficient 2 / 3 (Instance 8 of 16)
  volatile uint32_t HCL8;  ///< 0x340 [R/W]: Horizontal Coefficient 0 / 1 (Instance 9 of 16)
  volatile uint32_t HCH8;  ///< 0x344 [R/W]: Horizontal Coefficient 2 / 3 (Instance 9 of 16)
  volatile uint32_t HCL9;  ///< 0x348 [R/W]: Horizontal Coefficient 0 / 1 (Instance 10 of 16)
  volatile uint32_t HCH9;  ///< 0x34c [R/W]: Horizontal Coefficient 2 / 3 (Instance 10 of 16)
  volatile uint32_t HCL10;  ///< 0x350 [R/W]: Horizontal Coefficient 0 / 1 (Instance 11 of 16)
  volatile uint32_t HCH10;  ///< 0x354 [R/W]: Horizontal Coefficient 2 / 3 (Instance 11 of 16)
  volatile uint32_t HCL11;  ///< 0x358 [R/W]: Horizontal Coefficient 0 / 1 (Instance 12 of 16)
  volatile uint32_t HCH11;  ///< 0x35c [R/W]: Horizontal Coefficient 2 / 3 (Instance 12 of 16)
  volatile uint32_t HCL12;  ///< 0x360 [R/W]: Horizontal Coefficient 0 / 1 (Instance 13 of 16)
  volatile uint32_t HCH12;  ///< 0x364 [R/W]: Horizontal Coefficient 2 / 3 (Instance 13 of 16)
  volatile uint32_t HCL13;  ///< 0x368 [R/W]: Horizontal Coefficient 0 / 1 (Instance 14 of 16)
  volatile uint32_t HCH13;  ///< 0x36c [R/W]: Horizontal Coefficient 2 / 3 (Instance 14 of 16)
  volatile uint32_t HCL14;  ///< 0x370 [R/W]: Horizontal Coefficient 0 / 1 (Instance 15 of 16)
  volatile uint32_t HCH14;  ///< 0x374 [R/W]: Horizontal Coefficient 2 / 3 (Instance 15 of 16)
  volatile uint32_t HCL15;  ///< 0x378 [R/W]: Horizontal Coefficient 0 / 1 (Instance 16 of 16)
  volatile uint32_t HCH15;  ///< 0x37c [R/W]: Horizontal Coefficient 2 / 3 (Instance 16 of 16)
  volatile uint32_t VCL0;  ///< 0x380 [R/W]: Vertical Coefficient 0 / 1 (Instance 1 of 16)
  volatile uint32_t VCH0;  ///< 0x384 [R/W]: Vertical Coefficient 2 / 3 (Instance 1 of 16)
  volatile uint32_t VCL1;  ///< 0x388 [R/W]: Vertical Coefficient 0 / 1 (Instance 2 of 16)
  volatile uint32_t VCH1;  ///< 0x38c [R/W]: Vertical Coefficient 2 / 3 (Instance 2 of 16)
  volatile uint32_t VCL2;  ///< 0x390 [R/W]: Vertical Coefficient 0 / 1 (Instance 3 of 16)
  volatile uint32_t VCH2;  ///< 0x394 [R/W]: Vertical Coefficient 2 / 3 (Instance 3 of 16)
  volatile uint32_t VCL3;  ///< 0x398 [R/W]: Vertical Coefficient 0 / 1 (Instance 4 of 16)
  volatile uint32_t VCH3;  ///< 0x39c [R/W]: Vertical Coefficient 2 / 3 (Instance 4 of 16)
  volatile uint32_t VCL4;  ///< 0x3a0 [R/W]: Vertical Coefficient 0 / 1 (Instance 5 of 16)
  volatile uint32_t VCH4;  ///< 0x3a4 [R/W]: Vertical Coefficient 2 / 3 (Instance 5 of 16)
  volatile uint32_t VCL5;  ///< 0x3a8 [R/W]: Vertical Coefficient 0 / 1 (Instance 6 of 16)
  volatile uint32_t VCH5;  ///< 0x3ac [R/W]: Vertical Coefficient 2 / 3 (Instance 6 of 16)
  volatile uint32_t VCL6;  ///< 0x3b0 [R/W]: Vertical Coefficient 0 / 1 (Instance 7 of 16)
  volatile uint32_t VCH6;  ///< 0x3b4 [R/W]: Vertical Coefficient 2 / 3 (Instance 7 of 16)
  volatile uint32_t VCL7;  ///< 0x3b8 [R/W]: Vertical Coefficient 0 / 1 (Instance 8 of 16)
  volatile uint32_t VCH7;  ///< 0x3bc [R/W]: Vertical Coefficient 2 / 3 (Instance 8 of 16)
  volatile uint32_t VCL8;  ///< 0x3c0 [R/W]: Vertical Coefficient 0 / 1 (Instance 9 of 16)
  volatile uint32_t VCH8;  ///< 0x3c4 [R/W]: Vertical Coefficient 2 / 3 (Instance 9 of 16)
  volatile uint32_t VCL9;  ///< 0x3c8 [R/W]: Vertical Coefficient 0 / 1 (Instance 10 of 16)
  volatile uint32_t VCH9;  ///< 0x3cc [R/W]: Vertical Coefficient 2 / 3 (Instance 10 of 16)
  volatile uint32_t VCL10;  ///< 0x3d0 [R/W]: Vertical Coefficient 0 / 1 (Instance 11 of 16)
  volatile uint32_t VCH10;  ///< 0x3d4 [R/W]: Vertical Coefficient 2 / 3 (Instance 11 of 16)
  volatile uint32_t VCL11;  ///< 0x3d8 [R/W]: Vertical Coefficient 0 / 1 (Instance 12 of 16)
  volatile uint32_t VCH11;  ///< 0x3dc [R/W]: Vertical Coefficient 2 / 3 (Instance 12 of 16)
  volatile uint32_t VCL12;  ///< 0x3e0 [R/W]: Vertical Coefficient 0 / 1 (Instance 13 of 16)
  volatile uint32_t VCH12;  ///< 0x3e4 [R/W]: Vertical Coefficient 2 / 3 (Instance 13 of 16)
  volatile uint32_t VCL13;  ///< 0x3e8 [R/W]: Vertical Coefficient 0 / 1 (Instance 14 of 16)
  volatile uint32_t VCH13;  ///< 0x3ec [R/W]: Vertical Coefficient 2 / 3 (Instance 14 of 16)
  volatile uint32_t VCL14;  ///< 0x3f0 [R/W]: Vertical Coefficient 0 / 1 (Instance 15 of 16)
  volatile uint32_t VCH14;  ///< 0x3f4 [R/W]: Vertical Coefficient 2 / 3 (Instance 15 of 16)
  volatile uint32_t VCL15;  ///< 0x3f8 [R/W]: Vertical Coefficient 0 / 1 (Instance 16 of 16)
  volatile uint32_t VCH15;  ///< 0x3fc [R/W]: Vertical Coefficient 2 / 3 (Instance 16 of 16)
} DISTORT_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT_MAP (DISTORT_MAP)
/** \brief Register descriptions for the DISTORT_MAP block.*/
//
//====================================================================

typedef struct DISTORT_MAP_REGS_s
{
  volatile uint32_t CR_BLOCK;  ///< 0x0 [R/W]: DISTORT_MAP Block Configuration Register
  volatile uint32_t CR_IMAGE;  ///< 0x4 [R/W]: DISTORT_MAP Image Configuration Register
  volatile uint32_t CR_STRIP;  ///< 0x8 [W]: DISTORT_MAP Strip Configuration Register
  volatile uint32_t SR_STRIP;  ///< 0xc [R]: DISTORT_MAP Strip Status Register
  volatile uint32_t SR_OUTPUT;  ///< 0x10 [R]: DISTORT_MAP Output Status Register
  volatile uint32_t CR_CH0SE0;  ///< 0x14 [W]: DISTORT_MAP Channel 0 Start Element 0 Configuration Register
  volatile uint32_t CR_CH0SE1;  ///< 0x18 [W]: DISTORT_MAP Channel 0 Start Element 1 Configuration Register
  volatile uint32_t CR_CH1SE0;  ///< 0x1c [W]: DISTORT_MAP Channel 1 Start Element 0 Configuration Register
  volatile uint32_t CR_CH1SE1;  ///< 0x20 [W]: DISTORT_MAP Channel 1 Start Element 1 Configuration Register
  volatile uint32_t CR_CH2SE0;  ///< 0x24 [W]: DISTORT_MAP Channel 2 Start Element 0 Configuration Register
  volatile uint32_t CR_CH2SE1;  ///< 0x28 [W]: DISTORT_MAP Channel 2 Start Element 1 Configuration Register
  volatile uint32_t SR_CH0SE0;  ///< 0x2c [R]: DISTORT_MAP Channel 0 Start Element 0 Status Register
  volatile uint32_t SR_CH0SE1;  ///< 0x30 [R]: DISTORT_MAP Channel 0 Start Element 1 Status Register
  volatile uint32_t SR_CH1SE0;  ///< 0x34 [R]: DISTORT_MAP Channel 1 Start Element 0 Status Register
  volatile uint32_t SR_CH1SE1;  ///< 0x38 [R]: DISTORT_MAP Channel 1 Start Element 1 Status Register
  volatile uint32_t SR_CH2SE0;  ///< 0x3c [R]: DISTORT_MAP Channel 2 Start Element 0 Status Register
  volatile uint32_t SR_CH2SE1;  ///< 0x40 [R]: DISTORT_MAP Channel 2 Start Element 1 Status Register
  volatile uint32_t INTR_EN;  ///< 0x44 [R/W]: DISTORT_MAP Interrupt Enable Register
  volatile uint32_t INTR_STAT;  ///< 0x48 [R]: DISTORT_MAP Interrupt Status Register
  volatile uint32_t INTR_ACK;  ///< 0x4c [W]: DISTORT_MAP Interrupt Acknowledge Register
  volatile uint32_t INTR_FORCE;  ///< 0x50 [W]: DISTORT_MAP Interrupt Force Register
  volatile uint32_t DR_CH0PRE;  ///< 0x54 [R]: DISTORT_MAP Channel 0 Prefetch Debug Register
  volatile uint32_t DR_CH0DEL;  ///< 0x58 [R]: DISTORT_MAP Channel 0 Delayed Debug Register
  volatile uint32_t DR_CH1PRE;  ///< 0x5c [R]: DISTORT_MAP Channel 1 Prefetch Debug Register
  volatile uint32_t DR_CH1DEL;  ///< 0x60 [R]: DISTORT_MAP Channel 1 Delayed Debug Register
  volatile uint32_t DR_CH2PRE;  ///< 0x64 [R]: DISTORT_MAP Channel 2 Prefetch Debug Register
  volatile uint32_t DR_CH2DEL;  ///< 0x68 [R]: DISTORT_MAP Channel 2 Delayed Debug Register
  volatile uint32_t REV0;  ///< 0x6c [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x70 [R]: IP Tagging Revision 1
} DISTORT_MAP_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 1 of 3) (ANTIFCOR_TOP_LUT1D_BDE0)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct ANTIFCOR_TOP_LUT1D_BDE0_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} ANTIFCOR_TOP_LUT1D_BDE0_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 2 of 3) (ANTIFCOR_TOP_LUT1D_BDE1)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct ANTIFCOR_TOP_LUT1D_BDE1_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} ANTIFCOR_TOP_LUT1D_BDE1_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 3 of 3) (ANTIFCOR_TOP_LUT1D_BDE2)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct ANTIFCOR_TOP_LUT1D_BDE2_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} ANTIFCOR_TOP_LUT1D_BDE2_REGS_t;

//====================================================================
//
//Register File: PIE Antiflare Correction (ANTIFCOR_TOP_ANTIFCOR)
/** \brief Register descriptions for the ANTIFCOR block.*/
//
//====================================================================

typedef struct ANTIFCOR_TOP_ANTIFCOR_REGS_s
{
  volatile uint32_t ANTIFCOR_CFG;  ///< 0x0 [R/W]: ANTIFCOR Configuration Register
  volatile uint32_t ANTIFCOR_CLIP;  ///< 0x4 [R/W]: ANTIFCOR Gray and Black Clip Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} ANTIFCOR_TOP_ANTIFCOR_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 1 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA0)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 2 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA1)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_DATA1_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_DATA1_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 3 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA2)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_DATA2_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_DATA2_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 1 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR0)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_CORR0_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_CORR0_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 2 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR1)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_CORR1_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_CORR1_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 3 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR2)
//
//====================================================================

typedef struct ANTIFCOR_TOP_DDMA_AC_CORR2_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} ANTIFCOR_TOP_DDMA_AC_CORR2_REGS_t;

#endif // DISTORT_TOP
