 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_TOP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_TOP_REGMASKS_H_
#define _DISTORT_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT_TOP Testbench (DISTORT_TOP)
/** \brief Register Descriptions for the DISTORT_TOP Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE LUT1D_BDE, ANTIFCOR, DISTORT_DMA (ANTIFCOR_TOP)
/** \brief Register Descriptions for the ANTIFCOR Top Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Distort (DISTORT)
/** \brief Register file for the DISTORT block
(rev 0 . 4 . 0 . 0)*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DISTORT_REV0_MAJ_MASK 0xffff0000
#define  DISTORT_REV0_MAJ_SHIFT 16
#define  DISTORT_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DISTORT_REV0_MAJ_MASK) >> DISTORT_REV0_MAJ_SHIFT)
#define  DISTORT_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV0_MAJ_MASK) | (((uint32_t)val) << DISTORT_REV0_MAJ_SHIFT))

#define  DISTORT_REV0_MID_MASK 0xffff
#define  DISTORT_REV0_MID_SHIFT 0
#define  DISTORT_REV0_MID_MASK_SHIFT(reg) (((reg) & DISTORT_REV0_MID_MASK) >> DISTORT_REV0_MID_SHIFT)
#define  DISTORT_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV0_MID_MASK) | (((uint32_t)val) << DISTORT_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DISTORT_REV1_RESERVED1_MASK 0xffff0000
#define  DISTORT_REV1_RESERVED1_SHIFT 16
#define  DISTORT_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_REV1_RESERVED1_MASK) >> DISTORT_REV1_RESERVED1_SHIFT)
#define  DISTORT_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_REV1_RESERVED1_SHIFT))

#define  DISTORT_REV1_CFG_MASK 0xffff
#define  DISTORT_REV1_CFG_SHIFT 0
#define  DISTORT_REV1_CFG_MASK_SHIFT(reg) (((reg) & DISTORT_REV1_CFG_MASK) >> DISTORT_REV1_CFG_SHIFT)
#define  DISTORT_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_REV1_CFG_MASK) | (((uint32_t)val) << DISTORT_REV1_CFG_SHIFT))

//====================================================================
//Register: Distort Configuration Register (Cfg)
/** \brief This register configures the major features of the Distort module*/
//====================================================================

#define  DISTORT_CFG_RESERVED1_MASK 0xfc000000
#define  DISTORT_CFG_RESERVED1_SHIFT 26
#define  DISTORT_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED1_MASK) >> DISTORT_CFG_RESERVED1_SHIFT)
#define  DISTORT_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED1_SHIFT))

#define  DISTORT_CFG_HORZSHIFT_MASK 0x3000000
#define  DISTORT_CFG_HORZSHIFT_SHIFT 24
#define  DISTORT_CFG_HORZSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_HORZSHIFT_MASK) >> DISTORT_CFG_HORZSHIFT_SHIFT)
#define  DISTORT_CFG_HORZSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_HORZSHIFT_MASK) | (((uint32_t)val) << DISTORT_CFG_HORZSHIFT_SHIFT))

#define  DISTORT_CFG_RESERVED2_MASK 0xfc0000
#define  DISTORT_CFG_RESERVED2_SHIFT 18
#define  DISTORT_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED2_MASK) >> DISTORT_CFG_RESERVED2_SHIFT)
#define  DISTORT_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED2_SHIFT))

#define  DISTORT_CFG_VERTSHIFT_MASK 0x30000
#define  DISTORT_CFG_VERTSHIFT_SHIFT 16
#define  DISTORT_CFG_VERTSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_VERTSHIFT_MASK) >> DISTORT_CFG_VERTSHIFT_SHIFT)
#define  DISTORT_CFG_VERTSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_VERTSHIFT_MASK) | (((uint32_t)val) << DISTORT_CFG_VERTSHIFT_SHIFT))

#define  DISTORT_CFG_RESERVED3_MASK 0xff80
#define  DISTORT_CFG_RESERVED3_SHIFT 7
#define  DISTORT_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_RESERVED3_MASK) >> DISTORT_CFG_RESERVED3_SHIFT)
#define  DISTORT_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_CFG_RESERVED3_SHIFT))

#define  DISTORT_CFG_ENCOLOR3_MASK 0x40
#define  DISTORT_CFG_ENCOLOR3_SHIFT 6
#define  DISTORT_CFG_ENCOLOR3_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR3_MASK) >> DISTORT_CFG_ENCOLOR3_SHIFT)
#define  DISTORT_CFG_ENCOLOR3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR3_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR3_SHIFT))

#define  DISTORT_CFG_ENCOLOR2_MASK 0x20
#define  DISTORT_CFG_ENCOLOR2_SHIFT 5
#define  DISTORT_CFG_ENCOLOR2_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR2_MASK) >> DISTORT_CFG_ENCOLOR2_SHIFT)
#define  DISTORT_CFG_ENCOLOR2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR2_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR2_SHIFT))

#define  DISTORT_CFG_ENCOLOR1_MASK 0x10
#define  DISTORT_CFG_ENCOLOR1_SHIFT 4
#define  DISTORT_CFG_ENCOLOR1_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_ENCOLOR1_MASK) >> DISTORT_CFG_ENCOLOR1_SHIFT)
#define  DISTORT_CFG_ENCOLOR1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_ENCOLOR1_MASK) | (((uint32_t)val) << DISTORT_CFG_ENCOLOR1_SHIFT))

#define  DISTORT_CFG_CH3_MAPMODE_MASK 0x8
#define  DISTORT_CFG_CH3_MAPMODE_SHIFT 3
#define  DISTORT_CFG_CH3_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH3_MAPMODE_MASK) >> DISTORT_CFG_CH3_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH3_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH3_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH3_MAPMODE_SHIFT))

#define  DISTORT_CFG_CH2_MAPMODE_MASK 0x4
#define  DISTORT_CFG_CH2_MAPMODE_SHIFT 2
#define  DISTORT_CFG_CH2_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH2_MAPMODE_MASK) >> DISTORT_CFG_CH2_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH2_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH2_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH2_MAPMODE_SHIFT))

#define  DISTORT_CFG_CH1_MAPMODE_MASK 0x2
#define  DISTORT_CFG_CH1_MAPMODE_SHIFT 1
#define  DISTORT_CFG_CH1_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_CH1_MAPMODE_MASK) >> DISTORT_CFG_CH1_MAPMODE_SHIFT)
#define  DISTORT_CFG_CH1_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_CH1_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_CFG_CH1_MAPMODE_SHIFT))

#define  DISTORT_CFG_BYPASS_MASK 0x1
#define  DISTORT_CFG_BYPASS_SHIFT 0
#define  DISTORT_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & DISTORT_CFG_BYPASS_MASK) >> DISTORT_CFG_BYPASS_SHIFT)
#define  DISTORT_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CFG_BYPASS_MASK) | (((uint32_t)val) << DISTORT_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Strip Register (Strip)
/** \brief This register starts generation of fixed steps for one strip.*/
//====================================================================

#define  DISTORT_STRIP_RESERVED1_MASK 0xfffffffc
#define  DISTORT_STRIP_RESERVED1_SHIFT 2
#define  DISTORT_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_RESERVED1_MASK) >> DISTORT_STRIP_RESERVED1_SHIFT)
#define  DISTORT_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_STRIP_RESERVED1_SHIFT))

#define  DISTORT_STRIP_RESETLINES_MASK 0x2
#define  DISTORT_STRIP_RESETLINES_SHIFT 1
#define  DISTORT_STRIP_RESETLINES_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_RESETLINES_MASK) >> DISTORT_STRIP_RESETLINES_SHIFT)
#define  DISTORT_STRIP_RESETLINES_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_RESETLINES_MASK) | (((uint32_t)val) << DISTORT_STRIP_RESETLINES_SHIFT))

#define  DISTORT_STRIP_START_MASK 0x1
#define  DISTORT_STRIP_START_SHIFT 0
#define  DISTORT_STRIP_START_MASK_SHIFT(reg) (((reg) & DISTORT_STRIP_START_MASK) >> DISTORT_STRIP_START_SHIFT)
#define  DISTORT_STRIP_START_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_STRIP_START_MASK) | (((uint32_t)val) << DISTORT_STRIP_START_SHIFT))

//====================================================================
//Register: Output Strip Size (OutputStripDimension)
/** \brief This register sets the output strip size in pixels.*/
//====================================================================

#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK 0xc0000000
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT 30
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK 0x3f000000
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT 24
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPOFFSET_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK 0xc00000
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT 22
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK 0x3f0000
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT 16
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPHEIGHT_SHIFT))

#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK 0xffff
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT 0
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK) >> DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT)
#define  DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_MASK) | (((uint32_t)val) << DISTORT_OUTPUTSTRIPDIMENSION_STRIPWIDTH_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Enable Register (IntEnable)
//====================================================================

#define  DISTORT_INTENABLE_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTENABLE_RESERVED1_SHIFT 3
#define  DISTORT_INTENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_RESERVED1_MASK) >> DISTORT_INTENABLE_RESERVED1_SHIFT)
#define  DISTORT_INTENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_RESERVED1_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTENABLE_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP3_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTENABLE_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP2_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTENABLE_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTENABLE_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTENABLE_ENDOFSTRIP1_MASK) >> DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTENABLE_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTENABLE_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTENABLE_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Pending Register (IntPending)
//====================================================================

#define  DISTORT_INTPENDING_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTPENDING_RESERVED1_SHIFT 3
#define  DISTORT_INTPENDING_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_RESERVED1_MASK) >> DISTORT_INTPENDING_RESERVED1_SHIFT)
#define  DISTORT_INTPENDING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_RESERVED1_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTPENDING_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP3_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTPENDING_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP2_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTPENDING_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTPENDING_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTPENDING_ENDOFSTRIP1_MASK) >> DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTPENDING_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTPENDING_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTPENDING_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Clear Register (IntClear)
//====================================================================

#define  DISTORT_INTCLEAR_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTCLEAR_RESERVED1_SHIFT 3
#define  DISTORT_INTCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_RESERVED1_MASK) >> DISTORT_INTCLEAR_RESERVED1_SHIFT)
#define  DISTORT_INTCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_RESERVED1_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP3_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP2_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTCLEAR_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTCLEAR_ENDOFSTRIP1_MASK) >> DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTCLEAR_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTCLEAR_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTCLEAR_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: DISTORT Interrupt Force Register (IntForce)
//====================================================================

#define  DISTORT_INTFORCE_RESERVED1_MASK 0xfffffff8
#define  DISTORT_INTFORCE_RESERVED1_SHIFT 3
#define  DISTORT_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_RESERVED1_MASK) >> DISTORT_INTFORCE_RESERVED1_SHIFT)
#define  DISTORT_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_RESERVED1_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP3_MASK 0x4
#define  DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT 2
#define  DISTORT_INTFORCE_ENDOFSTRIP3_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP3_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP3_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP3_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP2_MASK 0x2
#define  DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT 1
#define  DISTORT_INTFORCE_ENDOFSTRIP2_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP2_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP2_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP2_SHIFT))

#define  DISTORT_INTFORCE_ENDOFSTRIP1_MASK 0x1
#define  DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT 0
#define  DISTORT_INTFORCE_ENDOFSTRIP1_MASK_SHIFT(reg) (((reg) & DISTORT_INTFORCE_ENDOFSTRIP1_MASK) >> DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT)
#define  DISTORT_INTFORCE_ENDOFSTRIP1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_INTFORCE_ENDOFSTRIP1_MASK) | (((uint32_t)val) << DISTORT_INTFORCE_ENDOFSTRIP1_SHIFT))

//====================================================================
//Register: Input Image Size (Ch1_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH1_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Input Image Size (Ch2_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH2_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Input Image Size (Ch3_ImageDimension)
/** \brief This register sets the input image sizes in pixels*/
//====================================================================

#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_CH3_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch1_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch2_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Horizontal Data Start Position (Ch3_DataStartPos_X)
/** \brief Horizontal Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch1_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch2_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Vertical Data Start Position (Ch3_DataStartPos_Y)
/** \brief Vertical Data Start Position: contains 2 parts, 16-bit whole number and 16-bit fractional number*/
//====================================================================

#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 1 in non-MapMode (Ch1_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 2 in non-MapMode (Ch2_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 3 in non-MapMode (Ch3_FixedRowStepX)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPX_ROWSTEPX_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 1 in non-MapMode (Ch1_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 2 in non-MapMode (Ch2_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Row Step Y for channel 3 in non-MapMode (Ch3_FixedRowStepY)
/** \brief In non-MapMode, this row step is used instead of reading steps from the map block. This register contains the row step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK) >> DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK 0xfffff
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT 0
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK) >> DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT)
#define  DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDROWSTEPY_ROWSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 1 in non-MapMode (Ch1_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 2 in non-MapMode (Ch2_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step X for channel 3 in non-MapMode (Ch3_FixedColStepX)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the X dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK) >> DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPX_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK 0xfffff
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT 0
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK) >> DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPX_COLSTEPX_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 1 in non-MapMode (Ch1_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH1_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 2 in non-MapMode (Ch2_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH2_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Fixed Col Step Y for channel 3 in non-MapMode (Ch3_FixedColStepY)
/** \brief In non-MapMode, this column step is used instead of reading steps from the map block. This register contains the column step in the Y dimension.*/
//====================================================================

#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK 0xfff00000
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT 20
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK) >> DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPY_RESERVED1_SHIFT))

#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK 0xfffff
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT 0
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK) >> DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT)
#define  DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_MASK) | (((uint32_t)val) << DISTORT_CH3_FIXEDCOLSTEPY_COLSTEPY_SHIFT))

//====================================================================
//Register: Blank value for channel 1 (Ch1_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 1.*/
//====================================================================

#define  DISTORT_CH1_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH1_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH1_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH1_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Blank value for channel 2 (Ch2_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 2.*/
//====================================================================

#define  DISTORT_CH2_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH2_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH2_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH2_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Blank value for channel 3 (Ch3_BlankValue)
/** \brief The blank value is used when the source pixel position falls outside of the input image. This register contains the value for channel 3.*/
//====================================================================

#define  DISTORT_CH3_BLANKVALUE_RESERVED1_MASK 0xffffc000
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT 14
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_BLANKVALUE_RESERVED1_MASK) >> DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT)
#define  DISTORT_CH3_BLANKVALUE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_BLANKVALUE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_BLANKVALUE_RESERVED1_SHIFT))

#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK 0x3fff
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT 0
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK) >> DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT)
#define  DISTORT_CH3_BLANKVALUE_BLANKVALUE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_BLANKVALUE_BLANKVALUE_MASK) | (((uint32_t)val) << DISTORT_CH3_BLANKVALUE_BLANKVALUE_SHIFT))

//====================================================================
//Register: Highest line for channel 1 (Ch1_HighestLine)
//====================================================================

#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH1_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH1_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH1_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register: Highest line for channel 2 (Ch2_HighestLine)
//====================================================================

#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH2_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH2_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH2_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register: Highest line for channel 3 (Ch3_HighestLine)
//====================================================================

#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK 0xffff8000
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT 15
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK) >> DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT)
#define  DISTORT_CH3_HIGHESTLINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_HIGHESTLINE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CH3_HIGHESTLINE_RESERVED1_SHIFT))

#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK 0x7fff
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT 0
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK_SHIFT(reg) (((reg) & DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK) >> DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT)
#define  DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_MASK) | (((uint32_t)val) << DISTORT_CH3_HIGHESTLINE_HIGHESTLINE_SHIFT))

//====================================================================
//Register:  (OperationStatus)
//====================================================================

#define  DISTORT_OPERATIONSTATUS_RESERVED1_MASK 0xfffffff8
#define  DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT 3
#define  DISTORT_OPERATIONSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_RESERVED1_MASK) >> DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT)
#define  DISTORT_OPERATIONSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_RESERVED1_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK 0x4
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT 2
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH3_OPSTATUS_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK 0x2
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT 1
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH2_OPSTATUS_SHIFT))

#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK 0x1
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT 0
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK_SHIFT(reg) (((reg) & DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK) >> DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT)
#define  DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_MASK) | (((uint32_t)val) << DISTORT_OPERATIONSTATUS_CH1_OPSTATUS_SHIFT))

//====================================================================
//Register: Current Position (CurrentPosition)
//====================================================================

#define  DISTORT_CURRENTPOSITION_COLUMN_MASK 0xffff0000
#define  DISTORT_CURRENTPOSITION_COLUMN_SHIFT 16
#define  DISTORT_CURRENTPOSITION_COLUMN_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_COLUMN_MASK) >> DISTORT_CURRENTPOSITION_COLUMN_SHIFT)
#define  DISTORT_CURRENTPOSITION_COLUMN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_COLUMN_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_COLUMN_SHIFT))

#define  DISTORT_CURRENTPOSITION_RESERVED1_MASK 0xffc0
#define  DISTORT_CURRENTPOSITION_RESERVED1_SHIFT 6
#define  DISTORT_CURRENTPOSITION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_RESERVED1_MASK) >> DISTORT_CURRENTPOSITION_RESERVED1_SHIFT)
#define  DISTORT_CURRENTPOSITION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_RESERVED1_SHIFT))

#define  DISTORT_CURRENTPOSITION_ROW_MASK 0x3f
#define  DISTORT_CURRENTPOSITION_ROW_SHIFT 0
#define  DISTORT_CURRENTPOSITION_ROW_MASK_SHIFT(reg) (((reg) & DISTORT_CURRENTPOSITION_ROW_MASK) >> DISTORT_CURRENTPOSITION_ROW_SHIFT)
#define  DISTORT_CURRENTPOSITION_ROW_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_CURRENTPOSITION_ROW_MASK) | (((uint32_t)val) << DISTORT_CURRENTPOSITION_ROW_SHIFT))

//====================================================================
//Register: Position Select (PosSelect)
/** \brief This register selects the channel and process output in CurrentPosition.*/
//====================================================================

#define  DISTORT_POSSELECT_RESERVED1_MASK 0xffffffc0
#define  DISTORT_POSSELECT_RESERVED1_SHIFT 6
#define  DISTORT_POSSELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_RESERVED1_MASK) >> DISTORT_POSSELECT_RESERVED1_SHIFT)
#define  DISTORT_POSSELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_RESERVED1_SHIFT))

#define  DISTORT_POSSELECT_CHANNEL_MASK 0x30
#define  DISTORT_POSSELECT_CHANNEL_SHIFT 4
#define  DISTORT_POSSELECT_CHANNEL_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_CHANNEL_MASK) >> DISTORT_POSSELECT_CHANNEL_SHIFT)
#define  DISTORT_POSSELECT_CHANNEL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_CHANNEL_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_CHANNEL_SHIFT))

#define  DISTORT_POSSELECT_RESERVED2_MASK 0xe
#define  DISTORT_POSSELECT_RESERVED2_SHIFT 1
#define  DISTORT_POSSELECT_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_RESERVED2_MASK) >> DISTORT_POSSELECT_RESERVED2_SHIFT)
#define  DISTORT_POSSELECT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_RESERVED2_SHIFT))

#define  DISTORT_POSSELECT_PROCESS_MASK 0x1
#define  DISTORT_POSSELECT_PROCESS_SHIFT 0
#define  DISTORT_POSSELECT_PROCESS_MASK_SHIFT(reg) (((reg) & DISTORT_POSSELECT_PROCESS_MASK) >> DISTORT_POSSELECT_PROCESS_SHIFT)
#define  DISTORT_POSSELECT_PROCESS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_POSSELECT_PROCESS_MASK) | (((uint32_t)val) << DISTORT_POSSELECT_PROCESS_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 1 of 16) (HCL0)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_HCL0_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL0_RESERVED1_SHIFT 28
#define  DISTORT_HCL0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_RESERVED1_MASK) >> DISTORT_HCL0_RESERVED1_SHIFT)
#define  DISTORT_HCL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL0_RESERVED1_SHIFT))

#define  DISTORT_HCL0_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL0_HCOEF1_SHIFT 16
#define  DISTORT_HCL0_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_HCOEF1_MASK) >> DISTORT_HCL0_HCOEF1_SHIFT)
#define  DISTORT_HCL0_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL0_HCOEF1_SHIFT))

#define  DISTORT_HCL0_RESERVED2_MASK 0xf000
#define  DISTORT_HCL0_RESERVED2_SHIFT 12
#define  DISTORT_HCL0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_RESERVED2_MASK) >> DISTORT_HCL0_RESERVED2_SHIFT)
#define  DISTORT_HCL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL0_RESERVED2_SHIFT))

#define  DISTORT_HCL0_HCOEF0_MASK 0xfff
#define  DISTORT_HCL0_HCOEF0_SHIFT 0
#define  DISTORT_HCL0_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL0_HCOEF0_MASK) >> DISTORT_HCL0_HCOEF0_SHIFT)
#define  DISTORT_HCL0_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL0_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL0_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 2 of 16) (HCL1)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_HCL1_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL1_RESERVED1_SHIFT 28
#define  DISTORT_HCL1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_RESERVED1_MASK) >> DISTORT_HCL1_RESERVED1_SHIFT)
#define  DISTORT_HCL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL1_RESERVED1_SHIFT))

#define  DISTORT_HCL1_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL1_HCOEF1_SHIFT 16
#define  DISTORT_HCL1_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_HCOEF1_MASK) >> DISTORT_HCL1_HCOEF1_SHIFT)
#define  DISTORT_HCL1_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL1_HCOEF1_SHIFT))

#define  DISTORT_HCL1_RESERVED2_MASK 0xf000
#define  DISTORT_HCL1_RESERVED2_SHIFT 12
#define  DISTORT_HCL1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_RESERVED2_MASK) >> DISTORT_HCL1_RESERVED2_SHIFT)
#define  DISTORT_HCL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL1_RESERVED2_SHIFT))

#define  DISTORT_HCL1_HCOEF0_MASK 0xfff
#define  DISTORT_HCL1_HCOEF0_SHIFT 0
#define  DISTORT_HCL1_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL1_HCOEF0_MASK) >> DISTORT_HCL1_HCOEF0_SHIFT)
#define  DISTORT_HCL1_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL1_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL1_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 3 of 16) (HCL2)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_HCL2_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL2_RESERVED1_SHIFT 28
#define  DISTORT_HCL2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_RESERVED1_MASK) >> DISTORT_HCL2_RESERVED1_SHIFT)
#define  DISTORT_HCL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL2_RESERVED1_SHIFT))

#define  DISTORT_HCL2_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL2_HCOEF1_SHIFT 16
#define  DISTORT_HCL2_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_HCOEF1_MASK) >> DISTORT_HCL2_HCOEF1_SHIFT)
#define  DISTORT_HCL2_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL2_HCOEF1_SHIFT))

#define  DISTORT_HCL2_RESERVED2_MASK 0xf000
#define  DISTORT_HCL2_RESERVED2_SHIFT 12
#define  DISTORT_HCL2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_RESERVED2_MASK) >> DISTORT_HCL2_RESERVED2_SHIFT)
#define  DISTORT_HCL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL2_RESERVED2_SHIFT))

#define  DISTORT_HCL2_HCOEF0_MASK 0xfff
#define  DISTORT_HCL2_HCOEF0_SHIFT 0
#define  DISTORT_HCL2_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL2_HCOEF0_MASK) >> DISTORT_HCL2_HCOEF0_SHIFT)
#define  DISTORT_HCL2_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL2_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL2_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 4 of 16) (HCL3)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_HCL3_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL3_RESERVED1_SHIFT 28
#define  DISTORT_HCL3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_RESERVED1_MASK) >> DISTORT_HCL3_RESERVED1_SHIFT)
#define  DISTORT_HCL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL3_RESERVED1_SHIFT))

#define  DISTORT_HCL3_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL3_HCOEF1_SHIFT 16
#define  DISTORT_HCL3_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_HCOEF1_MASK) >> DISTORT_HCL3_HCOEF1_SHIFT)
#define  DISTORT_HCL3_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL3_HCOEF1_SHIFT))

#define  DISTORT_HCL3_RESERVED2_MASK 0xf000
#define  DISTORT_HCL3_RESERVED2_SHIFT 12
#define  DISTORT_HCL3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_RESERVED2_MASK) >> DISTORT_HCL3_RESERVED2_SHIFT)
#define  DISTORT_HCL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL3_RESERVED2_SHIFT))

#define  DISTORT_HCL3_HCOEF0_MASK 0xfff
#define  DISTORT_HCL3_HCOEF0_SHIFT 0
#define  DISTORT_HCL3_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL3_HCOEF0_MASK) >> DISTORT_HCL3_HCOEF0_SHIFT)
#define  DISTORT_HCL3_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL3_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL3_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 5 of 16) (HCL4)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_HCL4_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL4_RESERVED1_SHIFT 28
#define  DISTORT_HCL4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_RESERVED1_MASK) >> DISTORT_HCL4_RESERVED1_SHIFT)
#define  DISTORT_HCL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL4_RESERVED1_SHIFT))

#define  DISTORT_HCL4_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL4_HCOEF1_SHIFT 16
#define  DISTORT_HCL4_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_HCOEF1_MASK) >> DISTORT_HCL4_HCOEF1_SHIFT)
#define  DISTORT_HCL4_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL4_HCOEF1_SHIFT))

#define  DISTORT_HCL4_RESERVED2_MASK 0xf000
#define  DISTORT_HCL4_RESERVED2_SHIFT 12
#define  DISTORT_HCL4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_RESERVED2_MASK) >> DISTORT_HCL4_RESERVED2_SHIFT)
#define  DISTORT_HCL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL4_RESERVED2_SHIFT))

#define  DISTORT_HCL4_HCOEF0_MASK 0xfff
#define  DISTORT_HCL4_HCOEF0_SHIFT 0
#define  DISTORT_HCL4_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL4_HCOEF0_MASK) >> DISTORT_HCL4_HCOEF0_SHIFT)
#define  DISTORT_HCL4_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL4_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL4_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 6 of 16) (HCL5)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_HCL5_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL5_RESERVED1_SHIFT 28
#define  DISTORT_HCL5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_RESERVED1_MASK) >> DISTORT_HCL5_RESERVED1_SHIFT)
#define  DISTORT_HCL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL5_RESERVED1_SHIFT))

#define  DISTORT_HCL5_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL5_HCOEF1_SHIFT 16
#define  DISTORT_HCL5_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_HCOEF1_MASK) >> DISTORT_HCL5_HCOEF1_SHIFT)
#define  DISTORT_HCL5_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL5_HCOEF1_SHIFT))

#define  DISTORT_HCL5_RESERVED2_MASK 0xf000
#define  DISTORT_HCL5_RESERVED2_SHIFT 12
#define  DISTORT_HCL5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_RESERVED2_MASK) >> DISTORT_HCL5_RESERVED2_SHIFT)
#define  DISTORT_HCL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL5_RESERVED2_SHIFT))

#define  DISTORT_HCL5_HCOEF0_MASK 0xfff
#define  DISTORT_HCL5_HCOEF0_SHIFT 0
#define  DISTORT_HCL5_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL5_HCOEF0_MASK) >> DISTORT_HCL5_HCOEF0_SHIFT)
#define  DISTORT_HCL5_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL5_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL5_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 7 of 16) (HCL6)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_HCL6_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL6_RESERVED1_SHIFT 28
#define  DISTORT_HCL6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_RESERVED1_MASK) >> DISTORT_HCL6_RESERVED1_SHIFT)
#define  DISTORT_HCL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL6_RESERVED1_SHIFT))

#define  DISTORT_HCL6_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL6_HCOEF1_SHIFT 16
#define  DISTORT_HCL6_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_HCOEF1_MASK) >> DISTORT_HCL6_HCOEF1_SHIFT)
#define  DISTORT_HCL6_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL6_HCOEF1_SHIFT))

#define  DISTORT_HCL6_RESERVED2_MASK 0xf000
#define  DISTORT_HCL6_RESERVED2_SHIFT 12
#define  DISTORT_HCL6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_RESERVED2_MASK) >> DISTORT_HCL6_RESERVED2_SHIFT)
#define  DISTORT_HCL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL6_RESERVED2_SHIFT))

#define  DISTORT_HCL6_HCOEF0_MASK 0xfff
#define  DISTORT_HCL6_HCOEF0_SHIFT 0
#define  DISTORT_HCL6_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL6_HCOEF0_MASK) >> DISTORT_HCL6_HCOEF0_SHIFT)
#define  DISTORT_HCL6_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL6_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL6_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 8 of 16) (HCL7)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_HCL7_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL7_RESERVED1_SHIFT 28
#define  DISTORT_HCL7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_RESERVED1_MASK) >> DISTORT_HCL7_RESERVED1_SHIFT)
#define  DISTORT_HCL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL7_RESERVED1_SHIFT))

#define  DISTORT_HCL7_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL7_HCOEF1_SHIFT 16
#define  DISTORT_HCL7_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_HCOEF1_MASK) >> DISTORT_HCL7_HCOEF1_SHIFT)
#define  DISTORT_HCL7_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL7_HCOEF1_SHIFT))

#define  DISTORT_HCL7_RESERVED2_MASK 0xf000
#define  DISTORT_HCL7_RESERVED2_SHIFT 12
#define  DISTORT_HCL7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_RESERVED2_MASK) >> DISTORT_HCL7_RESERVED2_SHIFT)
#define  DISTORT_HCL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL7_RESERVED2_SHIFT))

#define  DISTORT_HCL7_HCOEF0_MASK 0xfff
#define  DISTORT_HCL7_HCOEF0_SHIFT 0
#define  DISTORT_HCL7_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL7_HCOEF0_MASK) >> DISTORT_HCL7_HCOEF0_SHIFT)
#define  DISTORT_HCL7_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL7_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL7_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 9 of 16) (HCL8)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_HCL8_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL8_RESERVED1_SHIFT 28
#define  DISTORT_HCL8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_RESERVED1_MASK) >> DISTORT_HCL8_RESERVED1_SHIFT)
#define  DISTORT_HCL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL8_RESERVED1_SHIFT))

#define  DISTORT_HCL8_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL8_HCOEF1_SHIFT 16
#define  DISTORT_HCL8_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_HCOEF1_MASK) >> DISTORT_HCL8_HCOEF1_SHIFT)
#define  DISTORT_HCL8_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL8_HCOEF1_SHIFT))

#define  DISTORT_HCL8_RESERVED2_MASK 0xf000
#define  DISTORT_HCL8_RESERVED2_SHIFT 12
#define  DISTORT_HCL8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_RESERVED2_MASK) >> DISTORT_HCL8_RESERVED2_SHIFT)
#define  DISTORT_HCL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL8_RESERVED2_SHIFT))

#define  DISTORT_HCL8_HCOEF0_MASK 0xfff
#define  DISTORT_HCL8_HCOEF0_SHIFT 0
#define  DISTORT_HCL8_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL8_HCOEF0_MASK) >> DISTORT_HCL8_HCOEF0_SHIFT)
#define  DISTORT_HCL8_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL8_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL8_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 10 of 16) (HCL9)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_HCL9_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL9_RESERVED1_SHIFT 28
#define  DISTORT_HCL9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_RESERVED1_MASK) >> DISTORT_HCL9_RESERVED1_SHIFT)
#define  DISTORT_HCL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL9_RESERVED1_SHIFT))

#define  DISTORT_HCL9_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL9_HCOEF1_SHIFT 16
#define  DISTORT_HCL9_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_HCOEF1_MASK) >> DISTORT_HCL9_HCOEF1_SHIFT)
#define  DISTORT_HCL9_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL9_HCOEF1_SHIFT))

#define  DISTORT_HCL9_RESERVED2_MASK 0xf000
#define  DISTORT_HCL9_RESERVED2_SHIFT 12
#define  DISTORT_HCL9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_RESERVED2_MASK) >> DISTORT_HCL9_RESERVED2_SHIFT)
#define  DISTORT_HCL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL9_RESERVED2_SHIFT))

#define  DISTORT_HCL9_HCOEF0_MASK 0xfff
#define  DISTORT_HCL9_HCOEF0_SHIFT 0
#define  DISTORT_HCL9_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL9_HCOEF0_MASK) >> DISTORT_HCL9_HCOEF0_SHIFT)
#define  DISTORT_HCL9_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL9_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL9_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 11 of 16) (HCL10)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_HCL10_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL10_RESERVED1_SHIFT 28
#define  DISTORT_HCL10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_RESERVED1_MASK) >> DISTORT_HCL10_RESERVED1_SHIFT)
#define  DISTORT_HCL10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL10_RESERVED1_SHIFT))

#define  DISTORT_HCL10_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL10_HCOEF1_SHIFT 16
#define  DISTORT_HCL10_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_HCOEF1_MASK) >> DISTORT_HCL10_HCOEF1_SHIFT)
#define  DISTORT_HCL10_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL10_HCOEF1_SHIFT))

#define  DISTORT_HCL10_RESERVED2_MASK 0xf000
#define  DISTORT_HCL10_RESERVED2_SHIFT 12
#define  DISTORT_HCL10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_RESERVED2_MASK) >> DISTORT_HCL10_RESERVED2_SHIFT)
#define  DISTORT_HCL10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL10_RESERVED2_SHIFT))

#define  DISTORT_HCL10_HCOEF0_MASK 0xfff
#define  DISTORT_HCL10_HCOEF0_SHIFT 0
#define  DISTORT_HCL10_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL10_HCOEF0_MASK) >> DISTORT_HCL10_HCOEF0_SHIFT)
#define  DISTORT_HCL10_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL10_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL10_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 12 of 16) (HCL11)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_HCL11_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL11_RESERVED1_SHIFT 28
#define  DISTORT_HCL11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_RESERVED1_MASK) >> DISTORT_HCL11_RESERVED1_SHIFT)
#define  DISTORT_HCL11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL11_RESERVED1_SHIFT))

#define  DISTORT_HCL11_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL11_HCOEF1_SHIFT 16
#define  DISTORT_HCL11_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_HCOEF1_MASK) >> DISTORT_HCL11_HCOEF1_SHIFT)
#define  DISTORT_HCL11_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL11_HCOEF1_SHIFT))

#define  DISTORT_HCL11_RESERVED2_MASK 0xf000
#define  DISTORT_HCL11_RESERVED2_SHIFT 12
#define  DISTORT_HCL11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_RESERVED2_MASK) >> DISTORT_HCL11_RESERVED2_SHIFT)
#define  DISTORT_HCL11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL11_RESERVED2_SHIFT))

#define  DISTORT_HCL11_HCOEF0_MASK 0xfff
#define  DISTORT_HCL11_HCOEF0_SHIFT 0
#define  DISTORT_HCL11_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL11_HCOEF0_MASK) >> DISTORT_HCL11_HCOEF0_SHIFT)
#define  DISTORT_HCL11_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL11_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL11_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 13 of 16) (HCL12)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_HCL12_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL12_RESERVED1_SHIFT 28
#define  DISTORT_HCL12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_RESERVED1_MASK) >> DISTORT_HCL12_RESERVED1_SHIFT)
#define  DISTORT_HCL12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL12_RESERVED1_SHIFT))

#define  DISTORT_HCL12_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL12_HCOEF1_SHIFT 16
#define  DISTORT_HCL12_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_HCOEF1_MASK) >> DISTORT_HCL12_HCOEF1_SHIFT)
#define  DISTORT_HCL12_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL12_HCOEF1_SHIFT))

#define  DISTORT_HCL12_RESERVED2_MASK 0xf000
#define  DISTORT_HCL12_RESERVED2_SHIFT 12
#define  DISTORT_HCL12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_RESERVED2_MASK) >> DISTORT_HCL12_RESERVED2_SHIFT)
#define  DISTORT_HCL12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL12_RESERVED2_SHIFT))

#define  DISTORT_HCL12_HCOEF0_MASK 0xfff
#define  DISTORT_HCL12_HCOEF0_SHIFT 0
#define  DISTORT_HCL12_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL12_HCOEF0_MASK) >> DISTORT_HCL12_HCOEF0_SHIFT)
#define  DISTORT_HCL12_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL12_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL12_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 14 of 16) (HCL13)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_HCL13_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL13_RESERVED1_SHIFT 28
#define  DISTORT_HCL13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_RESERVED1_MASK) >> DISTORT_HCL13_RESERVED1_SHIFT)
#define  DISTORT_HCL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL13_RESERVED1_SHIFT))

#define  DISTORT_HCL13_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL13_HCOEF1_SHIFT 16
#define  DISTORT_HCL13_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_HCOEF1_MASK) >> DISTORT_HCL13_HCOEF1_SHIFT)
#define  DISTORT_HCL13_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL13_HCOEF1_SHIFT))

#define  DISTORT_HCL13_RESERVED2_MASK 0xf000
#define  DISTORT_HCL13_RESERVED2_SHIFT 12
#define  DISTORT_HCL13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_RESERVED2_MASK) >> DISTORT_HCL13_RESERVED2_SHIFT)
#define  DISTORT_HCL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL13_RESERVED2_SHIFT))

#define  DISTORT_HCL13_HCOEF0_MASK 0xfff
#define  DISTORT_HCL13_HCOEF0_SHIFT 0
#define  DISTORT_HCL13_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL13_HCOEF0_MASK) >> DISTORT_HCL13_HCOEF0_SHIFT)
#define  DISTORT_HCL13_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL13_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL13_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 15 of 16) (HCL14)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_HCL14_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL14_RESERVED1_SHIFT 28
#define  DISTORT_HCL14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_RESERVED1_MASK) >> DISTORT_HCL14_RESERVED1_SHIFT)
#define  DISTORT_HCL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL14_RESERVED1_SHIFT))

#define  DISTORT_HCL14_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL14_HCOEF1_SHIFT 16
#define  DISTORT_HCL14_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_HCOEF1_MASK) >> DISTORT_HCL14_HCOEF1_SHIFT)
#define  DISTORT_HCL14_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL14_HCOEF1_SHIFT))

#define  DISTORT_HCL14_RESERVED2_MASK 0xf000
#define  DISTORT_HCL14_RESERVED2_SHIFT 12
#define  DISTORT_HCL14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_RESERVED2_MASK) >> DISTORT_HCL14_RESERVED2_SHIFT)
#define  DISTORT_HCL14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL14_RESERVED2_SHIFT))

#define  DISTORT_HCL14_HCOEF0_MASK 0xfff
#define  DISTORT_HCL14_HCOEF0_SHIFT 0
#define  DISTORT_HCL14_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL14_HCOEF0_MASK) >> DISTORT_HCL14_HCOEF0_SHIFT)
#define  DISTORT_HCL14_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL14_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL14_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 0 / 1 (Instance 16 of 16) (HCL15)
/** \brief This register contains horizontal coefficients 0 and 1 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_HCL15_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCL15_RESERVED1_SHIFT 28
#define  DISTORT_HCL15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_RESERVED1_MASK) >> DISTORT_HCL15_RESERVED1_SHIFT)
#define  DISTORT_HCL15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCL15_RESERVED1_SHIFT))

#define  DISTORT_HCL15_HCOEF1_MASK 0xfff0000
#define  DISTORT_HCL15_HCOEF1_SHIFT 16
#define  DISTORT_HCL15_HCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_HCOEF1_MASK) >> DISTORT_HCL15_HCOEF1_SHIFT)
#define  DISTORT_HCL15_HCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_HCOEF1_MASK) | (((uint32_t)val) << DISTORT_HCL15_HCOEF1_SHIFT))

#define  DISTORT_HCL15_RESERVED2_MASK 0xf000
#define  DISTORT_HCL15_RESERVED2_SHIFT 12
#define  DISTORT_HCL15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_RESERVED2_MASK) >> DISTORT_HCL15_RESERVED2_SHIFT)
#define  DISTORT_HCL15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCL15_RESERVED2_SHIFT))

#define  DISTORT_HCL15_HCOEF0_MASK 0xfff
#define  DISTORT_HCL15_HCOEF0_SHIFT 0
#define  DISTORT_HCL15_HCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_HCL15_HCOEF0_MASK) >> DISTORT_HCL15_HCOEF0_SHIFT)
#define  DISTORT_HCL15_HCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCL15_HCOEF0_MASK) | (((uint32_t)val) << DISTORT_HCL15_HCOEF0_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 1 of 16) (HCH0)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_HCH0_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH0_RESERVED1_SHIFT 28
#define  DISTORT_HCH0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_RESERVED1_MASK) >> DISTORT_HCH0_RESERVED1_SHIFT)
#define  DISTORT_HCH0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH0_RESERVED1_SHIFT))

#define  DISTORT_HCH0_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH0_HCOEF3_SHIFT 16
#define  DISTORT_HCH0_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_HCOEF3_MASK) >> DISTORT_HCH0_HCOEF3_SHIFT)
#define  DISTORT_HCH0_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH0_HCOEF3_SHIFT))

#define  DISTORT_HCH0_RESERVED2_MASK 0xf000
#define  DISTORT_HCH0_RESERVED2_SHIFT 12
#define  DISTORT_HCH0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_RESERVED2_MASK) >> DISTORT_HCH0_RESERVED2_SHIFT)
#define  DISTORT_HCH0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH0_RESERVED2_SHIFT))

#define  DISTORT_HCH0_HCOEF2_MASK 0xfff
#define  DISTORT_HCH0_HCOEF2_SHIFT 0
#define  DISTORT_HCH0_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH0_HCOEF2_MASK) >> DISTORT_HCH0_HCOEF2_SHIFT)
#define  DISTORT_HCH0_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH0_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH0_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 2 of 16) (HCH1)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_HCH1_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH1_RESERVED1_SHIFT 28
#define  DISTORT_HCH1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_RESERVED1_MASK) >> DISTORT_HCH1_RESERVED1_SHIFT)
#define  DISTORT_HCH1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH1_RESERVED1_SHIFT))

#define  DISTORT_HCH1_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH1_HCOEF3_SHIFT 16
#define  DISTORT_HCH1_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_HCOEF3_MASK) >> DISTORT_HCH1_HCOEF3_SHIFT)
#define  DISTORT_HCH1_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH1_HCOEF3_SHIFT))

#define  DISTORT_HCH1_RESERVED2_MASK 0xf000
#define  DISTORT_HCH1_RESERVED2_SHIFT 12
#define  DISTORT_HCH1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_RESERVED2_MASK) >> DISTORT_HCH1_RESERVED2_SHIFT)
#define  DISTORT_HCH1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH1_RESERVED2_SHIFT))

#define  DISTORT_HCH1_HCOEF2_MASK 0xfff
#define  DISTORT_HCH1_HCOEF2_SHIFT 0
#define  DISTORT_HCH1_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH1_HCOEF2_MASK) >> DISTORT_HCH1_HCOEF2_SHIFT)
#define  DISTORT_HCH1_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH1_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH1_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 3 of 16) (HCH2)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_HCH2_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH2_RESERVED1_SHIFT 28
#define  DISTORT_HCH2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_RESERVED1_MASK) >> DISTORT_HCH2_RESERVED1_SHIFT)
#define  DISTORT_HCH2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH2_RESERVED1_SHIFT))

#define  DISTORT_HCH2_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH2_HCOEF3_SHIFT 16
#define  DISTORT_HCH2_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_HCOEF3_MASK) >> DISTORT_HCH2_HCOEF3_SHIFT)
#define  DISTORT_HCH2_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH2_HCOEF3_SHIFT))

#define  DISTORT_HCH2_RESERVED2_MASK 0xf000
#define  DISTORT_HCH2_RESERVED2_SHIFT 12
#define  DISTORT_HCH2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_RESERVED2_MASK) >> DISTORT_HCH2_RESERVED2_SHIFT)
#define  DISTORT_HCH2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH2_RESERVED2_SHIFT))

#define  DISTORT_HCH2_HCOEF2_MASK 0xfff
#define  DISTORT_HCH2_HCOEF2_SHIFT 0
#define  DISTORT_HCH2_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH2_HCOEF2_MASK) >> DISTORT_HCH2_HCOEF2_SHIFT)
#define  DISTORT_HCH2_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH2_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH2_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 4 of 16) (HCH3)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_HCH3_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH3_RESERVED1_SHIFT 28
#define  DISTORT_HCH3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_RESERVED1_MASK) >> DISTORT_HCH3_RESERVED1_SHIFT)
#define  DISTORT_HCH3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH3_RESERVED1_SHIFT))

#define  DISTORT_HCH3_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH3_HCOEF3_SHIFT 16
#define  DISTORT_HCH3_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_HCOEF3_MASK) >> DISTORT_HCH3_HCOEF3_SHIFT)
#define  DISTORT_HCH3_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH3_HCOEF3_SHIFT))

#define  DISTORT_HCH3_RESERVED2_MASK 0xf000
#define  DISTORT_HCH3_RESERVED2_SHIFT 12
#define  DISTORT_HCH3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_RESERVED2_MASK) >> DISTORT_HCH3_RESERVED2_SHIFT)
#define  DISTORT_HCH3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH3_RESERVED2_SHIFT))

#define  DISTORT_HCH3_HCOEF2_MASK 0xfff
#define  DISTORT_HCH3_HCOEF2_SHIFT 0
#define  DISTORT_HCH3_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH3_HCOEF2_MASK) >> DISTORT_HCH3_HCOEF2_SHIFT)
#define  DISTORT_HCH3_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH3_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH3_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 5 of 16) (HCH4)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_HCH4_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH4_RESERVED1_SHIFT 28
#define  DISTORT_HCH4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_RESERVED1_MASK) >> DISTORT_HCH4_RESERVED1_SHIFT)
#define  DISTORT_HCH4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH4_RESERVED1_SHIFT))

#define  DISTORT_HCH4_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH4_HCOEF3_SHIFT 16
#define  DISTORT_HCH4_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_HCOEF3_MASK) >> DISTORT_HCH4_HCOEF3_SHIFT)
#define  DISTORT_HCH4_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH4_HCOEF3_SHIFT))

#define  DISTORT_HCH4_RESERVED2_MASK 0xf000
#define  DISTORT_HCH4_RESERVED2_SHIFT 12
#define  DISTORT_HCH4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_RESERVED2_MASK) >> DISTORT_HCH4_RESERVED2_SHIFT)
#define  DISTORT_HCH4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH4_RESERVED2_SHIFT))

#define  DISTORT_HCH4_HCOEF2_MASK 0xfff
#define  DISTORT_HCH4_HCOEF2_SHIFT 0
#define  DISTORT_HCH4_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH4_HCOEF2_MASK) >> DISTORT_HCH4_HCOEF2_SHIFT)
#define  DISTORT_HCH4_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH4_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH4_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 6 of 16) (HCH5)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_HCH5_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH5_RESERVED1_SHIFT 28
#define  DISTORT_HCH5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_RESERVED1_MASK) >> DISTORT_HCH5_RESERVED1_SHIFT)
#define  DISTORT_HCH5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH5_RESERVED1_SHIFT))

#define  DISTORT_HCH5_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH5_HCOEF3_SHIFT 16
#define  DISTORT_HCH5_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_HCOEF3_MASK) >> DISTORT_HCH5_HCOEF3_SHIFT)
#define  DISTORT_HCH5_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH5_HCOEF3_SHIFT))

#define  DISTORT_HCH5_RESERVED2_MASK 0xf000
#define  DISTORT_HCH5_RESERVED2_SHIFT 12
#define  DISTORT_HCH5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_RESERVED2_MASK) >> DISTORT_HCH5_RESERVED2_SHIFT)
#define  DISTORT_HCH5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH5_RESERVED2_SHIFT))

#define  DISTORT_HCH5_HCOEF2_MASK 0xfff
#define  DISTORT_HCH5_HCOEF2_SHIFT 0
#define  DISTORT_HCH5_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH5_HCOEF2_MASK) >> DISTORT_HCH5_HCOEF2_SHIFT)
#define  DISTORT_HCH5_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH5_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH5_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 7 of 16) (HCH6)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_HCH6_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH6_RESERVED1_SHIFT 28
#define  DISTORT_HCH6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_RESERVED1_MASK) >> DISTORT_HCH6_RESERVED1_SHIFT)
#define  DISTORT_HCH6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH6_RESERVED1_SHIFT))

#define  DISTORT_HCH6_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH6_HCOEF3_SHIFT 16
#define  DISTORT_HCH6_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_HCOEF3_MASK) >> DISTORT_HCH6_HCOEF3_SHIFT)
#define  DISTORT_HCH6_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH6_HCOEF3_SHIFT))

#define  DISTORT_HCH6_RESERVED2_MASK 0xf000
#define  DISTORT_HCH6_RESERVED2_SHIFT 12
#define  DISTORT_HCH6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_RESERVED2_MASK) >> DISTORT_HCH6_RESERVED2_SHIFT)
#define  DISTORT_HCH6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH6_RESERVED2_SHIFT))

#define  DISTORT_HCH6_HCOEF2_MASK 0xfff
#define  DISTORT_HCH6_HCOEF2_SHIFT 0
#define  DISTORT_HCH6_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH6_HCOEF2_MASK) >> DISTORT_HCH6_HCOEF2_SHIFT)
#define  DISTORT_HCH6_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH6_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH6_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 8 of 16) (HCH7)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_HCH7_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH7_RESERVED1_SHIFT 28
#define  DISTORT_HCH7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_RESERVED1_MASK) >> DISTORT_HCH7_RESERVED1_SHIFT)
#define  DISTORT_HCH7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH7_RESERVED1_SHIFT))

#define  DISTORT_HCH7_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH7_HCOEF3_SHIFT 16
#define  DISTORT_HCH7_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_HCOEF3_MASK) >> DISTORT_HCH7_HCOEF3_SHIFT)
#define  DISTORT_HCH7_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH7_HCOEF3_SHIFT))

#define  DISTORT_HCH7_RESERVED2_MASK 0xf000
#define  DISTORT_HCH7_RESERVED2_SHIFT 12
#define  DISTORT_HCH7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_RESERVED2_MASK) >> DISTORT_HCH7_RESERVED2_SHIFT)
#define  DISTORT_HCH7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH7_RESERVED2_SHIFT))

#define  DISTORT_HCH7_HCOEF2_MASK 0xfff
#define  DISTORT_HCH7_HCOEF2_SHIFT 0
#define  DISTORT_HCH7_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH7_HCOEF2_MASK) >> DISTORT_HCH7_HCOEF2_SHIFT)
#define  DISTORT_HCH7_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH7_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH7_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 9 of 16) (HCH8)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_HCH8_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH8_RESERVED1_SHIFT 28
#define  DISTORT_HCH8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_RESERVED1_MASK) >> DISTORT_HCH8_RESERVED1_SHIFT)
#define  DISTORT_HCH8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH8_RESERVED1_SHIFT))

#define  DISTORT_HCH8_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH8_HCOEF3_SHIFT 16
#define  DISTORT_HCH8_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_HCOEF3_MASK) >> DISTORT_HCH8_HCOEF3_SHIFT)
#define  DISTORT_HCH8_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH8_HCOEF3_SHIFT))

#define  DISTORT_HCH8_RESERVED2_MASK 0xf000
#define  DISTORT_HCH8_RESERVED2_SHIFT 12
#define  DISTORT_HCH8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_RESERVED2_MASK) >> DISTORT_HCH8_RESERVED2_SHIFT)
#define  DISTORT_HCH8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH8_RESERVED2_SHIFT))

#define  DISTORT_HCH8_HCOEF2_MASK 0xfff
#define  DISTORT_HCH8_HCOEF2_SHIFT 0
#define  DISTORT_HCH8_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH8_HCOEF2_MASK) >> DISTORT_HCH8_HCOEF2_SHIFT)
#define  DISTORT_HCH8_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH8_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH8_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 10 of 16) (HCH9)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_HCH9_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH9_RESERVED1_SHIFT 28
#define  DISTORT_HCH9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_RESERVED1_MASK) >> DISTORT_HCH9_RESERVED1_SHIFT)
#define  DISTORT_HCH9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH9_RESERVED1_SHIFT))

#define  DISTORT_HCH9_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH9_HCOEF3_SHIFT 16
#define  DISTORT_HCH9_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_HCOEF3_MASK) >> DISTORT_HCH9_HCOEF3_SHIFT)
#define  DISTORT_HCH9_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH9_HCOEF3_SHIFT))

#define  DISTORT_HCH9_RESERVED2_MASK 0xf000
#define  DISTORT_HCH9_RESERVED2_SHIFT 12
#define  DISTORT_HCH9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_RESERVED2_MASK) >> DISTORT_HCH9_RESERVED2_SHIFT)
#define  DISTORT_HCH9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH9_RESERVED2_SHIFT))

#define  DISTORT_HCH9_HCOEF2_MASK 0xfff
#define  DISTORT_HCH9_HCOEF2_SHIFT 0
#define  DISTORT_HCH9_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH9_HCOEF2_MASK) >> DISTORT_HCH9_HCOEF2_SHIFT)
#define  DISTORT_HCH9_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH9_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH9_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 11 of 16) (HCH10)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_HCH10_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH10_RESERVED1_SHIFT 28
#define  DISTORT_HCH10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_RESERVED1_MASK) >> DISTORT_HCH10_RESERVED1_SHIFT)
#define  DISTORT_HCH10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH10_RESERVED1_SHIFT))

#define  DISTORT_HCH10_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH10_HCOEF3_SHIFT 16
#define  DISTORT_HCH10_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_HCOEF3_MASK) >> DISTORT_HCH10_HCOEF3_SHIFT)
#define  DISTORT_HCH10_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH10_HCOEF3_SHIFT))

#define  DISTORT_HCH10_RESERVED2_MASK 0xf000
#define  DISTORT_HCH10_RESERVED2_SHIFT 12
#define  DISTORT_HCH10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_RESERVED2_MASK) >> DISTORT_HCH10_RESERVED2_SHIFT)
#define  DISTORT_HCH10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH10_RESERVED2_SHIFT))

#define  DISTORT_HCH10_HCOEF2_MASK 0xfff
#define  DISTORT_HCH10_HCOEF2_SHIFT 0
#define  DISTORT_HCH10_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH10_HCOEF2_MASK) >> DISTORT_HCH10_HCOEF2_SHIFT)
#define  DISTORT_HCH10_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH10_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH10_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 12 of 16) (HCH11)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_HCH11_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH11_RESERVED1_SHIFT 28
#define  DISTORT_HCH11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_RESERVED1_MASK) >> DISTORT_HCH11_RESERVED1_SHIFT)
#define  DISTORT_HCH11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH11_RESERVED1_SHIFT))

#define  DISTORT_HCH11_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH11_HCOEF3_SHIFT 16
#define  DISTORT_HCH11_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_HCOEF3_MASK) >> DISTORT_HCH11_HCOEF3_SHIFT)
#define  DISTORT_HCH11_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH11_HCOEF3_SHIFT))

#define  DISTORT_HCH11_RESERVED2_MASK 0xf000
#define  DISTORT_HCH11_RESERVED2_SHIFT 12
#define  DISTORT_HCH11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_RESERVED2_MASK) >> DISTORT_HCH11_RESERVED2_SHIFT)
#define  DISTORT_HCH11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH11_RESERVED2_SHIFT))

#define  DISTORT_HCH11_HCOEF2_MASK 0xfff
#define  DISTORT_HCH11_HCOEF2_SHIFT 0
#define  DISTORT_HCH11_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH11_HCOEF2_MASK) >> DISTORT_HCH11_HCOEF2_SHIFT)
#define  DISTORT_HCH11_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH11_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH11_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 13 of 16) (HCH12)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_HCH12_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH12_RESERVED1_SHIFT 28
#define  DISTORT_HCH12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_RESERVED1_MASK) >> DISTORT_HCH12_RESERVED1_SHIFT)
#define  DISTORT_HCH12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH12_RESERVED1_SHIFT))

#define  DISTORT_HCH12_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH12_HCOEF3_SHIFT 16
#define  DISTORT_HCH12_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_HCOEF3_MASK) >> DISTORT_HCH12_HCOEF3_SHIFT)
#define  DISTORT_HCH12_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH12_HCOEF3_SHIFT))

#define  DISTORT_HCH12_RESERVED2_MASK 0xf000
#define  DISTORT_HCH12_RESERVED2_SHIFT 12
#define  DISTORT_HCH12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_RESERVED2_MASK) >> DISTORT_HCH12_RESERVED2_SHIFT)
#define  DISTORT_HCH12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH12_RESERVED2_SHIFT))

#define  DISTORT_HCH12_HCOEF2_MASK 0xfff
#define  DISTORT_HCH12_HCOEF2_SHIFT 0
#define  DISTORT_HCH12_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH12_HCOEF2_MASK) >> DISTORT_HCH12_HCOEF2_SHIFT)
#define  DISTORT_HCH12_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH12_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH12_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 14 of 16) (HCH13)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_HCH13_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH13_RESERVED1_SHIFT 28
#define  DISTORT_HCH13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_RESERVED1_MASK) >> DISTORT_HCH13_RESERVED1_SHIFT)
#define  DISTORT_HCH13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH13_RESERVED1_SHIFT))

#define  DISTORT_HCH13_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH13_HCOEF3_SHIFT 16
#define  DISTORT_HCH13_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_HCOEF3_MASK) >> DISTORT_HCH13_HCOEF3_SHIFT)
#define  DISTORT_HCH13_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH13_HCOEF3_SHIFT))

#define  DISTORT_HCH13_RESERVED2_MASK 0xf000
#define  DISTORT_HCH13_RESERVED2_SHIFT 12
#define  DISTORT_HCH13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_RESERVED2_MASK) >> DISTORT_HCH13_RESERVED2_SHIFT)
#define  DISTORT_HCH13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH13_RESERVED2_SHIFT))

#define  DISTORT_HCH13_HCOEF2_MASK 0xfff
#define  DISTORT_HCH13_HCOEF2_SHIFT 0
#define  DISTORT_HCH13_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH13_HCOEF2_MASK) >> DISTORT_HCH13_HCOEF2_SHIFT)
#define  DISTORT_HCH13_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH13_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH13_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 15 of 16) (HCH14)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_HCH14_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH14_RESERVED1_SHIFT 28
#define  DISTORT_HCH14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_RESERVED1_MASK) >> DISTORT_HCH14_RESERVED1_SHIFT)
#define  DISTORT_HCH14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH14_RESERVED1_SHIFT))

#define  DISTORT_HCH14_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH14_HCOEF3_SHIFT 16
#define  DISTORT_HCH14_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_HCOEF3_MASK) >> DISTORT_HCH14_HCOEF3_SHIFT)
#define  DISTORT_HCH14_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH14_HCOEF3_SHIFT))

#define  DISTORT_HCH14_RESERVED2_MASK 0xf000
#define  DISTORT_HCH14_RESERVED2_SHIFT 12
#define  DISTORT_HCH14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_RESERVED2_MASK) >> DISTORT_HCH14_RESERVED2_SHIFT)
#define  DISTORT_HCH14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH14_RESERVED2_SHIFT))

#define  DISTORT_HCH14_HCOEF2_MASK 0xfff
#define  DISTORT_HCH14_HCOEF2_SHIFT 0
#define  DISTORT_HCH14_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH14_HCOEF2_MASK) >> DISTORT_HCH14_HCOEF2_SHIFT)
#define  DISTORT_HCH14_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH14_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH14_HCOEF2_SHIFT))

//====================================================================
//Register: Horizontal Coefficient 2 / 3 (Instance 16 of 16) (HCH15)
/** \brief This register contains horizontal coefficients 2 and 3 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_HCH15_RESERVED1_MASK 0xf0000000
#define  DISTORT_HCH15_RESERVED1_SHIFT 28
#define  DISTORT_HCH15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_RESERVED1_MASK) >> DISTORT_HCH15_RESERVED1_SHIFT)
#define  DISTORT_HCH15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_HCH15_RESERVED1_SHIFT))

#define  DISTORT_HCH15_HCOEF3_MASK 0xfff0000
#define  DISTORT_HCH15_HCOEF3_SHIFT 16
#define  DISTORT_HCH15_HCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_HCOEF3_MASK) >> DISTORT_HCH15_HCOEF3_SHIFT)
#define  DISTORT_HCH15_HCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_HCOEF3_MASK) | (((uint32_t)val) << DISTORT_HCH15_HCOEF3_SHIFT))

#define  DISTORT_HCH15_RESERVED2_MASK 0xf000
#define  DISTORT_HCH15_RESERVED2_SHIFT 12
#define  DISTORT_HCH15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_RESERVED2_MASK) >> DISTORT_HCH15_RESERVED2_SHIFT)
#define  DISTORT_HCH15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_HCH15_RESERVED2_SHIFT))

#define  DISTORT_HCH15_HCOEF2_MASK 0xfff
#define  DISTORT_HCH15_HCOEF2_SHIFT 0
#define  DISTORT_HCH15_HCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_HCH15_HCOEF2_MASK) >> DISTORT_HCH15_HCOEF2_SHIFT)
#define  DISTORT_HCH15_HCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_HCH15_HCOEF2_MASK) | (((uint32_t)val) << DISTORT_HCH15_HCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 1 of 16) (VCL0)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_VCL0_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL0_RESERVED1_SHIFT 28
#define  DISTORT_VCL0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_RESERVED1_MASK) >> DISTORT_VCL0_RESERVED1_SHIFT)
#define  DISTORT_VCL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL0_RESERVED1_SHIFT))

#define  DISTORT_VCL0_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL0_VCOEF1_SHIFT 16
#define  DISTORT_VCL0_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_VCOEF1_MASK) >> DISTORT_VCL0_VCOEF1_SHIFT)
#define  DISTORT_VCL0_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL0_VCOEF1_SHIFT))

#define  DISTORT_VCL0_RESERVED2_MASK 0xf000
#define  DISTORT_VCL0_RESERVED2_SHIFT 12
#define  DISTORT_VCL0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_RESERVED2_MASK) >> DISTORT_VCL0_RESERVED2_SHIFT)
#define  DISTORT_VCL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL0_RESERVED2_SHIFT))

#define  DISTORT_VCL0_VCOEF0_MASK 0xfff
#define  DISTORT_VCL0_VCOEF0_SHIFT 0
#define  DISTORT_VCL0_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL0_VCOEF0_MASK) >> DISTORT_VCL0_VCOEF0_SHIFT)
#define  DISTORT_VCL0_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL0_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL0_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 2 of 16) (VCL1)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_VCL1_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL1_RESERVED1_SHIFT 28
#define  DISTORT_VCL1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_RESERVED1_MASK) >> DISTORT_VCL1_RESERVED1_SHIFT)
#define  DISTORT_VCL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL1_RESERVED1_SHIFT))

#define  DISTORT_VCL1_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL1_VCOEF1_SHIFT 16
#define  DISTORT_VCL1_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_VCOEF1_MASK) >> DISTORT_VCL1_VCOEF1_SHIFT)
#define  DISTORT_VCL1_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL1_VCOEF1_SHIFT))

#define  DISTORT_VCL1_RESERVED2_MASK 0xf000
#define  DISTORT_VCL1_RESERVED2_SHIFT 12
#define  DISTORT_VCL1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_RESERVED2_MASK) >> DISTORT_VCL1_RESERVED2_SHIFT)
#define  DISTORT_VCL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL1_RESERVED2_SHIFT))

#define  DISTORT_VCL1_VCOEF0_MASK 0xfff
#define  DISTORT_VCL1_VCOEF0_SHIFT 0
#define  DISTORT_VCL1_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL1_VCOEF0_MASK) >> DISTORT_VCL1_VCOEF0_SHIFT)
#define  DISTORT_VCL1_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL1_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL1_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 3 of 16) (VCL2)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_VCL2_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL2_RESERVED1_SHIFT 28
#define  DISTORT_VCL2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_RESERVED1_MASK) >> DISTORT_VCL2_RESERVED1_SHIFT)
#define  DISTORT_VCL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL2_RESERVED1_SHIFT))

#define  DISTORT_VCL2_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL2_VCOEF1_SHIFT 16
#define  DISTORT_VCL2_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_VCOEF1_MASK) >> DISTORT_VCL2_VCOEF1_SHIFT)
#define  DISTORT_VCL2_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL2_VCOEF1_SHIFT))

#define  DISTORT_VCL2_RESERVED2_MASK 0xf000
#define  DISTORT_VCL2_RESERVED2_SHIFT 12
#define  DISTORT_VCL2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_RESERVED2_MASK) >> DISTORT_VCL2_RESERVED2_SHIFT)
#define  DISTORT_VCL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL2_RESERVED2_SHIFT))

#define  DISTORT_VCL2_VCOEF0_MASK 0xfff
#define  DISTORT_VCL2_VCOEF0_SHIFT 0
#define  DISTORT_VCL2_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL2_VCOEF0_MASK) >> DISTORT_VCL2_VCOEF0_SHIFT)
#define  DISTORT_VCL2_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL2_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL2_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 4 of 16) (VCL3)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_VCL3_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL3_RESERVED1_SHIFT 28
#define  DISTORT_VCL3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_RESERVED1_MASK) >> DISTORT_VCL3_RESERVED1_SHIFT)
#define  DISTORT_VCL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL3_RESERVED1_SHIFT))

#define  DISTORT_VCL3_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL3_VCOEF1_SHIFT 16
#define  DISTORT_VCL3_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_VCOEF1_MASK) >> DISTORT_VCL3_VCOEF1_SHIFT)
#define  DISTORT_VCL3_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL3_VCOEF1_SHIFT))

#define  DISTORT_VCL3_RESERVED2_MASK 0xf000
#define  DISTORT_VCL3_RESERVED2_SHIFT 12
#define  DISTORT_VCL3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_RESERVED2_MASK) >> DISTORT_VCL3_RESERVED2_SHIFT)
#define  DISTORT_VCL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL3_RESERVED2_SHIFT))

#define  DISTORT_VCL3_VCOEF0_MASK 0xfff
#define  DISTORT_VCL3_VCOEF0_SHIFT 0
#define  DISTORT_VCL3_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL3_VCOEF0_MASK) >> DISTORT_VCL3_VCOEF0_SHIFT)
#define  DISTORT_VCL3_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL3_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL3_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 5 of 16) (VCL4)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_VCL4_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL4_RESERVED1_SHIFT 28
#define  DISTORT_VCL4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_RESERVED1_MASK) >> DISTORT_VCL4_RESERVED1_SHIFT)
#define  DISTORT_VCL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL4_RESERVED1_SHIFT))

#define  DISTORT_VCL4_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL4_VCOEF1_SHIFT 16
#define  DISTORT_VCL4_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_VCOEF1_MASK) >> DISTORT_VCL4_VCOEF1_SHIFT)
#define  DISTORT_VCL4_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL4_VCOEF1_SHIFT))

#define  DISTORT_VCL4_RESERVED2_MASK 0xf000
#define  DISTORT_VCL4_RESERVED2_SHIFT 12
#define  DISTORT_VCL4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_RESERVED2_MASK) >> DISTORT_VCL4_RESERVED2_SHIFT)
#define  DISTORT_VCL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL4_RESERVED2_SHIFT))

#define  DISTORT_VCL4_VCOEF0_MASK 0xfff
#define  DISTORT_VCL4_VCOEF0_SHIFT 0
#define  DISTORT_VCL4_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL4_VCOEF0_MASK) >> DISTORT_VCL4_VCOEF0_SHIFT)
#define  DISTORT_VCL4_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL4_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL4_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 6 of 16) (VCL5)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_VCL5_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL5_RESERVED1_SHIFT 28
#define  DISTORT_VCL5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_RESERVED1_MASK) >> DISTORT_VCL5_RESERVED1_SHIFT)
#define  DISTORT_VCL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL5_RESERVED1_SHIFT))

#define  DISTORT_VCL5_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL5_VCOEF1_SHIFT 16
#define  DISTORT_VCL5_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_VCOEF1_MASK) >> DISTORT_VCL5_VCOEF1_SHIFT)
#define  DISTORT_VCL5_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL5_VCOEF1_SHIFT))

#define  DISTORT_VCL5_RESERVED2_MASK 0xf000
#define  DISTORT_VCL5_RESERVED2_SHIFT 12
#define  DISTORT_VCL5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_RESERVED2_MASK) >> DISTORT_VCL5_RESERVED2_SHIFT)
#define  DISTORT_VCL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL5_RESERVED2_SHIFT))

#define  DISTORT_VCL5_VCOEF0_MASK 0xfff
#define  DISTORT_VCL5_VCOEF0_SHIFT 0
#define  DISTORT_VCL5_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL5_VCOEF0_MASK) >> DISTORT_VCL5_VCOEF0_SHIFT)
#define  DISTORT_VCL5_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL5_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL5_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 7 of 16) (VCL6)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_VCL6_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL6_RESERVED1_SHIFT 28
#define  DISTORT_VCL6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_RESERVED1_MASK) >> DISTORT_VCL6_RESERVED1_SHIFT)
#define  DISTORT_VCL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL6_RESERVED1_SHIFT))

#define  DISTORT_VCL6_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL6_VCOEF1_SHIFT 16
#define  DISTORT_VCL6_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_VCOEF1_MASK) >> DISTORT_VCL6_VCOEF1_SHIFT)
#define  DISTORT_VCL6_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL6_VCOEF1_SHIFT))

#define  DISTORT_VCL6_RESERVED2_MASK 0xf000
#define  DISTORT_VCL6_RESERVED2_SHIFT 12
#define  DISTORT_VCL6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_RESERVED2_MASK) >> DISTORT_VCL6_RESERVED2_SHIFT)
#define  DISTORT_VCL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL6_RESERVED2_SHIFT))

#define  DISTORT_VCL6_VCOEF0_MASK 0xfff
#define  DISTORT_VCL6_VCOEF0_SHIFT 0
#define  DISTORT_VCL6_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL6_VCOEF0_MASK) >> DISTORT_VCL6_VCOEF0_SHIFT)
#define  DISTORT_VCL6_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL6_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL6_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 8 of 16) (VCL7)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_VCL7_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL7_RESERVED1_SHIFT 28
#define  DISTORT_VCL7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_RESERVED1_MASK) >> DISTORT_VCL7_RESERVED1_SHIFT)
#define  DISTORT_VCL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL7_RESERVED1_SHIFT))

#define  DISTORT_VCL7_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL7_VCOEF1_SHIFT 16
#define  DISTORT_VCL7_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_VCOEF1_MASK) >> DISTORT_VCL7_VCOEF1_SHIFT)
#define  DISTORT_VCL7_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL7_VCOEF1_SHIFT))

#define  DISTORT_VCL7_RESERVED2_MASK 0xf000
#define  DISTORT_VCL7_RESERVED2_SHIFT 12
#define  DISTORT_VCL7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_RESERVED2_MASK) >> DISTORT_VCL7_RESERVED2_SHIFT)
#define  DISTORT_VCL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL7_RESERVED2_SHIFT))

#define  DISTORT_VCL7_VCOEF0_MASK 0xfff
#define  DISTORT_VCL7_VCOEF0_SHIFT 0
#define  DISTORT_VCL7_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL7_VCOEF0_MASK) >> DISTORT_VCL7_VCOEF0_SHIFT)
#define  DISTORT_VCL7_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL7_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL7_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 9 of 16) (VCL8)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_VCL8_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL8_RESERVED1_SHIFT 28
#define  DISTORT_VCL8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_RESERVED1_MASK) >> DISTORT_VCL8_RESERVED1_SHIFT)
#define  DISTORT_VCL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL8_RESERVED1_SHIFT))

#define  DISTORT_VCL8_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL8_VCOEF1_SHIFT 16
#define  DISTORT_VCL8_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_VCOEF1_MASK) >> DISTORT_VCL8_VCOEF1_SHIFT)
#define  DISTORT_VCL8_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL8_VCOEF1_SHIFT))

#define  DISTORT_VCL8_RESERVED2_MASK 0xf000
#define  DISTORT_VCL8_RESERVED2_SHIFT 12
#define  DISTORT_VCL8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_RESERVED2_MASK) >> DISTORT_VCL8_RESERVED2_SHIFT)
#define  DISTORT_VCL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL8_RESERVED2_SHIFT))

#define  DISTORT_VCL8_VCOEF0_MASK 0xfff
#define  DISTORT_VCL8_VCOEF0_SHIFT 0
#define  DISTORT_VCL8_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL8_VCOEF0_MASK) >> DISTORT_VCL8_VCOEF0_SHIFT)
#define  DISTORT_VCL8_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL8_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL8_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 10 of 16) (VCL9)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_VCL9_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL9_RESERVED1_SHIFT 28
#define  DISTORT_VCL9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_RESERVED1_MASK) >> DISTORT_VCL9_RESERVED1_SHIFT)
#define  DISTORT_VCL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL9_RESERVED1_SHIFT))

#define  DISTORT_VCL9_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL9_VCOEF1_SHIFT 16
#define  DISTORT_VCL9_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_VCOEF1_MASK) >> DISTORT_VCL9_VCOEF1_SHIFT)
#define  DISTORT_VCL9_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL9_VCOEF1_SHIFT))

#define  DISTORT_VCL9_RESERVED2_MASK 0xf000
#define  DISTORT_VCL9_RESERVED2_SHIFT 12
#define  DISTORT_VCL9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_RESERVED2_MASK) >> DISTORT_VCL9_RESERVED2_SHIFT)
#define  DISTORT_VCL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL9_RESERVED2_SHIFT))

#define  DISTORT_VCL9_VCOEF0_MASK 0xfff
#define  DISTORT_VCL9_VCOEF0_SHIFT 0
#define  DISTORT_VCL9_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL9_VCOEF0_MASK) >> DISTORT_VCL9_VCOEF0_SHIFT)
#define  DISTORT_VCL9_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL9_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL9_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 11 of 16) (VCL10)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_VCL10_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL10_RESERVED1_SHIFT 28
#define  DISTORT_VCL10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_RESERVED1_MASK) >> DISTORT_VCL10_RESERVED1_SHIFT)
#define  DISTORT_VCL10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL10_RESERVED1_SHIFT))

#define  DISTORT_VCL10_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL10_VCOEF1_SHIFT 16
#define  DISTORT_VCL10_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_VCOEF1_MASK) >> DISTORT_VCL10_VCOEF1_SHIFT)
#define  DISTORT_VCL10_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL10_VCOEF1_SHIFT))

#define  DISTORT_VCL10_RESERVED2_MASK 0xf000
#define  DISTORT_VCL10_RESERVED2_SHIFT 12
#define  DISTORT_VCL10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_RESERVED2_MASK) >> DISTORT_VCL10_RESERVED2_SHIFT)
#define  DISTORT_VCL10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL10_RESERVED2_SHIFT))

#define  DISTORT_VCL10_VCOEF0_MASK 0xfff
#define  DISTORT_VCL10_VCOEF0_SHIFT 0
#define  DISTORT_VCL10_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL10_VCOEF0_MASK) >> DISTORT_VCL10_VCOEF0_SHIFT)
#define  DISTORT_VCL10_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL10_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL10_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 12 of 16) (VCL11)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_VCL11_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL11_RESERVED1_SHIFT 28
#define  DISTORT_VCL11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_RESERVED1_MASK) >> DISTORT_VCL11_RESERVED1_SHIFT)
#define  DISTORT_VCL11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL11_RESERVED1_SHIFT))

#define  DISTORT_VCL11_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL11_VCOEF1_SHIFT 16
#define  DISTORT_VCL11_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_VCOEF1_MASK) >> DISTORT_VCL11_VCOEF1_SHIFT)
#define  DISTORT_VCL11_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL11_VCOEF1_SHIFT))

#define  DISTORT_VCL11_RESERVED2_MASK 0xf000
#define  DISTORT_VCL11_RESERVED2_SHIFT 12
#define  DISTORT_VCL11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_RESERVED2_MASK) >> DISTORT_VCL11_RESERVED2_SHIFT)
#define  DISTORT_VCL11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL11_RESERVED2_SHIFT))

#define  DISTORT_VCL11_VCOEF0_MASK 0xfff
#define  DISTORT_VCL11_VCOEF0_SHIFT 0
#define  DISTORT_VCL11_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL11_VCOEF0_MASK) >> DISTORT_VCL11_VCOEF0_SHIFT)
#define  DISTORT_VCL11_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL11_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL11_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 13 of 16) (VCL12)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_VCL12_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL12_RESERVED1_SHIFT 28
#define  DISTORT_VCL12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_RESERVED1_MASK) >> DISTORT_VCL12_RESERVED1_SHIFT)
#define  DISTORT_VCL12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL12_RESERVED1_SHIFT))

#define  DISTORT_VCL12_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL12_VCOEF1_SHIFT 16
#define  DISTORT_VCL12_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_VCOEF1_MASK) >> DISTORT_VCL12_VCOEF1_SHIFT)
#define  DISTORT_VCL12_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL12_VCOEF1_SHIFT))

#define  DISTORT_VCL12_RESERVED2_MASK 0xf000
#define  DISTORT_VCL12_RESERVED2_SHIFT 12
#define  DISTORT_VCL12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_RESERVED2_MASK) >> DISTORT_VCL12_RESERVED2_SHIFT)
#define  DISTORT_VCL12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL12_RESERVED2_SHIFT))

#define  DISTORT_VCL12_VCOEF0_MASK 0xfff
#define  DISTORT_VCL12_VCOEF0_SHIFT 0
#define  DISTORT_VCL12_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL12_VCOEF0_MASK) >> DISTORT_VCL12_VCOEF0_SHIFT)
#define  DISTORT_VCL12_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL12_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL12_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 14 of 16) (VCL13)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_VCL13_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL13_RESERVED1_SHIFT 28
#define  DISTORT_VCL13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_RESERVED1_MASK) >> DISTORT_VCL13_RESERVED1_SHIFT)
#define  DISTORT_VCL13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL13_RESERVED1_SHIFT))

#define  DISTORT_VCL13_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL13_VCOEF1_SHIFT 16
#define  DISTORT_VCL13_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_VCOEF1_MASK) >> DISTORT_VCL13_VCOEF1_SHIFT)
#define  DISTORT_VCL13_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL13_VCOEF1_SHIFT))

#define  DISTORT_VCL13_RESERVED2_MASK 0xf000
#define  DISTORT_VCL13_RESERVED2_SHIFT 12
#define  DISTORT_VCL13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_RESERVED2_MASK) >> DISTORT_VCL13_RESERVED2_SHIFT)
#define  DISTORT_VCL13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL13_RESERVED2_SHIFT))

#define  DISTORT_VCL13_VCOEF0_MASK 0xfff
#define  DISTORT_VCL13_VCOEF0_SHIFT 0
#define  DISTORT_VCL13_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL13_VCOEF0_MASK) >> DISTORT_VCL13_VCOEF0_SHIFT)
#define  DISTORT_VCL13_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL13_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL13_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 15 of 16) (VCL14)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_VCL14_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL14_RESERVED1_SHIFT 28
#define  DISTORT_VCL14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_RESERVED1_MASK) >> DISTORT_VCL14_RESERVED1_SHIFT)
#define  DISTORT_VCL14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL14_RESERVED1_SHIFT))

#define  DISTORT_VCL14_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL14_VCOEF1_SHIFT 16
#define  DISTORT_VCL14_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_VCOEF1_MASK) >> DISTORT_VCL14_VCOEF1_SHIFT)
#define  DISTORT_VCL14_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL14_VCOEF1_SHIFT))

#define  DISTORT_VCL14_RESERVED2_MASK 0xf000
#define  DISTORT_VCL14_RESERVED2_SHIFT 12
#define  DISTORT_VCL14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_RESERVED2_MASK) >> DISTORT_VCL14_RESERVED2_SHIFT)
#define  DISTORT_VCL14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL14_RESERVED2_SHIFT))

#define  DISTORT_VCL14_VCOEF0_MASK 0xfff
#define  DISTORT_VCL14_VCOEF0_SHIFT 0
#define  DISTORT_VCL14_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL14_VCOEF0_MASK) >> DISTORT_VCL14_VCOEF0_SHIFT)
#define  DISTORT_VCL14_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL14_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL14_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 0 / 1 (Instance 16 of 16) (VCL15)
/** \brief This register contains vertical coefficients 0 and 1 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_VCL15_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCL15_RESERVED1_SHIFT 28
#define  DISTORT_VCL15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_RESERVED1_MASK) >> DISTORT_VCL15_RESERVED1_SHIFT)
#define  DISTORT_VCL15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCL15_RESERVED1_SHIFT))

#define  DISTORT_VCL15_VCOEF1_MASK 0xfff0000
#define  DISTORT_VCL15_VCOEF1_SHIFT 16
#define  DISTORT_VCL15_VCOEF1_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_VCOEF1_MASK) >> DISTORT_VCL15_VCOEF1_SHIFT)
#define  DISTORT_VCL15_VCOEF1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_VCOEF1_MASK) | (((uint32_t)val) << DISTORT_VCL15_VCOEF1_SHIFT))

#define  DISTORT_VCL15_RESERVED2_MASK 0xf000
#define  DISTORT_VCL15_RESERVED2_SHIFT 12
#define  DISTORT_VCL15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_RESERVED2_MASK) >> DISTORT_VCL15_RESERVED2_SHIFT)
#define  DISTORT_VCL15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCL15_RESERVED2_SHIFT))

#define  DISTORT_VCL15_VCOEF0_MASK 0xfff
#define  DISTORT_VCL15_VCOEF0_SHIFT 0
#define  DISTORT_VCL15_VCOEF0_MASK_SHIFT(reg) (((reg) & DISTORT_VCL15_VCOEF0_MASK) >> DISTORT_VCL15_VCOEF0_SHIFT)
#define  DISTORT_VCL15_VCOEF0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCL15_VCOEF0_MASK) | (((uint32_t)val) << DISTORT_VCL15_VCOEF0_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 1 of 16) (VCH0)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 1 of 16)*/
//====================================================================

#define  DISTORT_VCH0_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH0_RESERVED1_SHIFT 28
#define  DISTORT_VCH0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_RESERVED1_MASK) >> DISTORT_VCH0_RESERVED1_SHIFT)
#define  DISTORT_VCH0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH0_RESERVED1_SHIFT))

#define  DISTORT_VCH0_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH0_VCOEF3_SHIFT 16
#define  DISTORT_VCH0_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_VCOEF3_MASK) >> DISTORT_VCH0_VCOEF3_SHIFT)
#define  DISTORT_VCH0_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH0_VCOEF3_SHIFT))

#define  DISTORT_VCH0_RESERVED2_MASK 0xf000
#define  DISTORT_VCH0_RESERVED2_SHIFT 12
#define  DISTORT_VCH0_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_RESERVED2_MASK) >> DISTORT_VCH0_RESERVED2_SHIFT)
#define  DISTORT_VCH0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH0_RESERVED2_SHIFT))

#define  DISTORT_VCH0_VCOEF2_MASK 0xfff
#define  DISTORT_VCH0_VCOEF2_SHIFT 0
#define  DISTORT_VCH0_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH0_VCOEF2_MASK) >> DISTORT_VCH0_VCOEF2_SHIFT)
#define  DISTORT_VCH0_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH0_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH0_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 2 of 16) (VCH1)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 2 of 16)*/
//====================================================================

#define  DISTORT_VCH1_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH1_RESERVED1_SHIFT 28
#define  DISTORT_VCH1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_RESERVED1_MASK) >> DISTORT_VCH1_RESERVED1_SHIFT)
#define  DISTORT_VCH1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH1_RESERVED1_SHIFT))

#define  DISTORT_VCH1_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH1_VCOEF3_SHIFT 16
#define  DISTORT_VCH1_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_VCOEF3_MASK) >> DISTORT_VCH1_VCOEF3_SHIFT)
#define  DISTORT_VCH1_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH1_VCOEF3_SHIFT))

#define  DISTORT_VCH1_RESERVED2_MASK 0xf000
#define  DISTORT_VCH1_RESERVED2_SHIFT 12
#define  DISTORT_VCH1_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_RESERVED2_MASK) >> DISTORT_VCH1_RESERVED2_SHIFT)
#define  DISTORT_VCH1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH1_RESERVED2_SHIFT))

#define  DISTORT_VCH1_VCOEF2_MASK 0xfff
#define  DISTORT_VCH1_VCOEF2_SHIFT 0
#define  DISTORT_VCH1_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH1_VCOEF2_MASK) >> DISTORT_VCH1_VCOEF2_SHIFT)
#define  DISTORT_VCH1_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH1_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH1_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 3 of 16) (VCH2)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 3 of 16)*/
//====================================================================

#define  DISTORT_VCH2_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH2_RESERVED1_SHIFT 28
#define  DISTORT_VCH2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_RESERVED1_MASK) >> DISTORT_VCH2_RESERVED1_SHIFT)
#define  DISTORT_VCH2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH2_RESERVED1_SHIFT))

#define  DISTORT_VCH2_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH2_VCOEF3_SHIFT 16
#define  DISTORT_VCH2_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_VCOEF3_MASK) >> DISTORT_VCH2_VCOEF3_SHIFT)
#define  DISTORT_VCH2_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH2_VCOEF3_SHIFT))

#define  DISTORT_VCH2_RESERVED2_MASK 0xf000
#define  DISTORT_VCH2_RESERVED2_SHIFT 12
#define  DISTORT_VCH2_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_RESERVED2_MASK) >> DISTORT_VCH2_RESERVED2_SHIFT)
#define  DISTORT_VCH2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH2_RESERVED2_SHIFT))

#define  DISTORT_VCH2_VCOEF2_MASK 0xfff
#define  DISTORT_VCH2_VCOEF2_SHIFT 0
#define  DISTORT_VCH2_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH2_VCOEF2_MASK) >> DISTORT_VCH2_VCOEF2_SHIFT)
#define  DISTORT_VCH2_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH2_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH2_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 4 of 16) (VCH3)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 4 of 16)*/
//====================================================================

#define  DISTORT_VCH3_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH3_RESERVED1_SHIFT 28
#define  DISTORT_VCH3_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_RESERVED1_MASK) >> DISTORT_VCH3_RESERVED1_SHIFT)
#define  DISTORT_VCH3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH3_RESERVED1_SHIFT))

#define  DISTORT_VCH3_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH3_VCOEF3_SHIFT 16
#define  DISTORT_VCH3_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_VCOEF3_MASK) >> DISTORT_VCH3_VCOEF3_SHIFT)
#define  DISTORT_VCH3_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH3_VCOEF3_SHIFT))

#define  DISTORT_VCH3_RESERVED2_MASK 0xf000
#define  DISTORT_VCH3_RESERVED2_SHIFT 12
#define  DISTORT_VCH3_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_RESERVED2_MASK) >> DISTORT_VCH3_RESERVED2_SHIFT)
#define  DISTORT_VCH3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH3_RESERVED2_SHIFT))

#define  DISTORT_VCH3_VCOEF2_MASK 0xfff
#define  DISTORT_VCH3_VCOEF2_SHIFT 0
#define  DISTORT_VCH3_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH3_VCOEF2_MASK) >> DISTORT_VCH3_VCOEF2_SHIFT)
#define  DISTORT_VCH3_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH3_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH3_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 5 of 16) (VCH4)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 5 of 16)*/
//====================================================================

#define  DISTORT_VCH4_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH4_RESERVED1_SHIFT 28
#define  DISTORT_VCH4_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_RESERVED1_MASK) >> DISTORT_VCH4_RESERVED1_SHIFT)
#define  DISTORT_VCH4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH4_RESERVED1_SHIFT))

#define  DISTORT_VCH4_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH4_VCOEF3_SHIFT 16
#define  DISTORT_VCH4_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_VCOEF3_MASK) >> DISTORT_VCH4_VCOEF3_SHIFT)
#define  DISTORT_VCH4_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH4_VCOEF3_SHIFT))

#define  DISTORT_VCH4_RESERVED2_MASK 0xf000
#define  DISTORT_VCH4_RESERVED2_SHIFT 12
#define  DISTORT_VCH4_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_RESERVED2_MASK) >> DISTORT_VCH4_RESERVED2_SHIFT)
#define  DISTORT_VCH4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH4_RESERVED2_SHIFT))

#define  DISTORT_VCH4_VCOEF2_MASK 0xfff
#define  DISTORT_VCH4_VCOEF2_SHIFT 0
#define  DISTORT_VCH4_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH4_VCOEF2_MASK) >> DISTORT_VCH4_VCOEF2_SHIFT)
#define  DISTORT_VCH4_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH4_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH4_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 6 of 16) (VCH5)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 6 of 16)*/
//====================================================================

#define  DISTORT_VCH5_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH5_RESERVED1_SHIFT 28
#define  DISTORT_VCH5_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_RESERVED1_MASK) >> DISTORT_VCH5_RESERVED1_SHIFT)
#define  DISTORT_VCH5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH5_RESERVED1_SHIFT))

#define  DISTORT_VCH5_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH5_VCOEF3_SHIFT 16
#define  DISTORT_VCH5_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_VCOEF3_MASK) >> DISTORT_VCH5_VCOEF3_SHIFT)
#define  DISTORT_VCH5_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH5_VCOEF3_SHIFT))

#define  DISTORT_VCH5_RESERVED2_MASK 0xf000
#define  DISTORT_VCH5_RESERVED2_SHIFT 12
#define  DISTORT_VCH5_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_RESERVED2_MASK) >> DISTORT_VCH5_RESERVED2_SHIFT)
#define  DISTORT_VCH5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH5_RESERVED2_SHIFT))

#define  DISTORT_VCH5_VCOEF2_MASK 0xfff
#define  DISTORT_VCH5_VCOEF2_SHIFT 0
#define  DISTORT_VCH5_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH5_VCOEF2_MASK) >> DISTORT_VCH5_VCOEF2_SHIFT)
#define  DISTORT_VCH5_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH5_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH5_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 7 of 16) (VCH6)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 7 of 16)*/
//====================================================================

#define  DISTORT_VCH6_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH6_RESERVED1_SHIFT 28
#define  DISTORT_VCH6_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_RESERVED1_MASK) >> DISTORT_VCH6_RESERVED1_SHIFT)
#define  DISTORT_VCH6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH6_RESERVED1_SHIFT))

#define  DISTORT_VCH6_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH6_VCOEF3_SHIFT 16
#define  DISTORT_VCH6_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_VCOEF3_MASK) >> DISTORT_VCH6_VCOEF3_SHIFT)
#define  DISTORT_VCH6_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH6_VCOEF3_SHIFT))

#define  DISTORT_VCH6_RESERVED2_MASK 0xf000
#define  DISTORT_VCH6_RESERVED2_SHIFT 12
#define  DISTORT_VCH6_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_RESERVED2_MASK) >> DISTORT_VCH6_RESERVED2_SHIFT)
#define  DISTORT_VCH6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH6_RESERVED2_SHIFT))

#define  DISTORT_VCH6_VCOEF2_MASK 0xfff
#define  DISTORT_VCH6_VCOEF2_SHIFT 0
#define  DISTORT_VCH6_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH6_VCOEF2_MASK) >> DISTORT_VCH6_VCOEF2_SHIFT)
#define  DISTORT_VCH6_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH6_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH6_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 8 of 16) (VCH7)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 8 of 16)*/
//====================================================================

#define  DISTORT_VCH7_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH7_RESERVED1_SHIFT 28
#define  DISTORT_VCH7_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_RESERVED1_MASK) >> DISTORT_VCH7_RESERVED1_SHIFT)
#define  DISTORT_VCH7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH7_RESERVED1_SHIFT))

#define  DISTORT_VCH7_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH7_VCOEF3_SHIFT 16
#define  DISTORT_VCH7_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_VCOEF3_MASK) >> DISTORT_VCH7_VCOEF3_SHIFT)
#define  DISTORT_VCH7_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH7_VCOEF3_SHIFT))

#define  DISTORT_VCH7_RESERVED2_MASK 0xf000
#define  DISTORT_VCH7_RESERVED2_SHIFT 12
#define  DISTORT_VCH7_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_RESERVED2_MASK) >> DISTORT_VCH7_RESERVED2_SHIFT)
#define  DISTORT_VCH7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH7_RESERVED2_SHIFT))

#define  DISTORT_VCH7_VCOEF2_MASK 0xfff
#define  DISTORT_VCH7_VCOEF2_SHIFT 0
#define  DISTORT_VCH7_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH7_VCOEF2_MASK) >> DISTORT_VCH7_VCOEF2_SHIFT)
#define  DISTORT_VCH7_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH7_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH7_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 9 of 16) (VCH8)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 9 of 16)*/
//====================================================================

#define  DISTORT_VCH8_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH8_RESERVED1_SHIFT 28
#define  DISTORT_VCH8_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_RESERVED1_MASK) >> DISTORT_VCH8_RESERVED1_SHIFT)
#define  DISTORT_VCH8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH8_RESERVED1_SHIFT))

#define  DISTORT_VCH8_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH8_VCOEF3_SHIFT 16
#define  DISTORT_VCH8_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_VCOEF3_MASK) >> DISTORT_VCH8_VCOEF3_SHIFT)
#define  DISTORT_VCH8_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH8_VCOEF3_SHIFT))

#define  DISTORT_VCH8_RESERVED2_MASK 0xf000
#define  DISTORT_VCH8_RESERVED2_SHIFT 12
#define  DISTORT_VCH8_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_RESERVED2_MASK) >> DISTORT_VCH8_RESERVED2_SHIFT)
#define  DISTORT_VCH8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH8_RESERVED2_SHIFT))

#define  DISTORT_VCH8_VCOEF2_MASK 0xfff
#define  DISTORT_VCH8_VCOEF2_SHIFT 0
#define  DISTORT_VCH8_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH8_VCOEF2_MASK) >> DISTORT_VCH8_VCOEF2_SHIFT)
#define  DISTORT_VCH8_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH8_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH8_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 10 of 16) (VCH9)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 10 of 16)*/
//====================================================================

#define  DISTORT_VCH9_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH9_RESERVED1_SHIFT 28
#define  DISTORT_VCH9_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_RESERVED1_MASK) >> DISTORT_VCH9_RESERVED1_SHIFT)
#define  DISTORT_VCH9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH9_RESERVED1_SHIFT))

#define  DISTORT_VCH9_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH9_VCOEF3_SHIFT 16
#define  DISTORT_VCH9_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_VCOEF3_MASK) >> DISTORT_VCH9_VCOEF3_SHIFT)
#define  DISTORT_VCH9_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH9_VCOEF3_SHIFT))

#define  DISTORT_VCH9_RESERVED2_MASK 0xf000
#define  DISTORT_VCH9_RESERVED2_SHIFT 12
#define  DISTORT_VCH9_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_RESERVED2_MASK) >> DISTORT_VCH9_RESERVED2_SHIFT)
#define  DISTORT_VCH9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH9_RESERVED2_SHIFT))

#define  DISTORT_VCH9_VCOEF2_MASK 0xfff
#define  DISTORT_VCH9_VCOEF2_SHIFT 0
#define  DISTORT_VCH9_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH9_VCOEF2_MASK) >> DISTORT_VCH9_VCOEF2_SHIFT)
#define  DISTORT_VCH9_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH9_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH9_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 11 of 16) (VCH10)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 11 of 16)*/
//====================================================================

#define  DISTORT_VCH10_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH10_RESERVED1_SHIFT 28
#define  DISTORT_VCH10_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_RESERVED1_MASK) >> DISTORT_VCH10_RESERVED1_SHIFT)
#define  DISTORT_VCH10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH10_RESERVED1_SHIFT))

#define  DISTORT_VCH10_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH10_VCOEF3_SHIFT 16
#define  DISTORT_VCH10_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_VCOEF3_MASK) >> DISTORT_VCH10_VCOEF3_SHIFT)
#define  DISTORT_VCH10_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH10_VCOEF3_SHIFT))

#define  DISTORT_VCH10_RESERVED2_MASK 0xf000
#define  DISTORT_VCH10_RESERVED2_SHIFT 12
#define  DISTORT_VCH10_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_RESERVED2_MASK) >> DISTORT_VCH10_RESERVED2_SHIFT)
#define  DISTORT_VCH10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH10_RESERVED2_SHIFT))

#define  DISTORT_VCH10_VCOEF2_MASK 0xfff
#define  DISTORT_VCH10_VCOEF2_SHIFT 0
#define  DISTORT_VCH10_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH10_VCOEF2_MASK) >> DISTORT_VCH10_VCOEF2_SHIFT)
#define  DISTORT_VCH10_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH10_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH10_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 12 of 16) (VCH11)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 12 of 16)*/
//====================================================================

#define  DISTORT_VCH11_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH11_RESERVED1_SHIFT 28
#define  DISTORT_VCH11_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_RESERVED1_MASK) >> DISTORT_VCH11_RESERVED1_SHIFT)
#define  DISTORT_VCH11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH11_RESERVED1_SHIFT))

#define  DISTORT_VCH11_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH11_VCOEF3_SHIFT 16
#define  DISTORT_VCH11_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_VCOEF3_MASK) >> DISTORT_VCH11_VCOEF3_SHIFT)
#define  DISTORT_VCH11_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH11_VCOEF3_SHIFT))

#define  DISTORT_VCH11_RESERVED2_MASK 0xf000
#define  DISTORT_VCH11_RESERVED2_SHIFT 12
#define  DISTORT_VCH11_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_RESERVED2_MASK) >> DISTORT_VCH11_RESERVED2_SHIFT)
#define  DISTORT_VCH11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH11_RESERVED2_SHIFT))

#define  DISTORT_VCH11_VCOEF2_MASK 0xfff
#define  DISTORT_VCH11_VCOEF2_SHIFT 0
#define  DISTORT_VCH11_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH11_VCOEF2_MASK) >> DISTORT_VCH11_VCOEF2_SHIFT)
#define  DISTORT_VCH11_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH11_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH11_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 13 of 16) (VCH12)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 13 of 16)*/
//====================================================================

#define  DISTORT_VCH12_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH12_RESERVED1_SHIFT 28
#define  DISTORT_VCH12_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_RESERVED1_MASK) >> DISTORT_VCH12_RESERVED1_SHIFT)
#define  DISTORT_VCH12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH12_RESERVED1_SHIFT))

#define  DISTORT_VCH12_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH12_VCOEF3_SHIFT 16
#define  DISTORT_VCH12_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_VCOEF3_MASK) >> DISTORT_VCH12_VCOEF3_SHIFT)
#define  DISTORT_VCH12_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH12_VCOEF3_SHIFT))

#define  DISTORT_VCH12_RESERVED2_MASK 0xf000
#define  DISTORT_VCH12_RESERVED2_SHIFT 12
#define  DISTORT_VCH12_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_RESERVED2_MASK) >> DISTORT_VCH12_RESERVED2_SHIFT)
#define  DISTORT_VCH12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH12_RESERVED2_SHIFT))

#define  DISTORT_VCH12_VCOEF2_MASK 0xfff
#define  DISTORT_VCH12_VCOEF2_SHIFT 0
#define  DISTORT_VCH12_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH12_VCOEF2_MASK) >> DISTORT_VCH12_VCOEF2_SHIFT)
#define  DISTORT_VCH12_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH12_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH12_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 14 of 16) (VCH13)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 14 of 16)*/
//====================================================================

#define  DISTORT_VCH13_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH13_RESERVED1_SHIFT 28
#define  DISTORT_VCH13_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_RESERVED1_MASK) >> DISTORT_VCH13_RESERVED1_SHIFT)
#define  DISTORT_VCH13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH13_RESERVED1_SHIFT))

#define  DISTORT_VCH13_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH13_VCOEF3_SHIFT 16
#define  DISTORT_VCH13_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_VCOEF3_MASK) >> DISTORT_VCH13_VCOEF3_SHIFT)
#define  DISTORT_VCH13_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH13_VCOEF3_SHIFT))

#define  DISTORT_VCH13_RESERVED2_MASK 0xf000
#define  DISTORT_VCH13_RESERVED2_SHIFT 12
#define  DISTORT_VCH13_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_RESERVED2_MASK) >> DISTORT_VCH13_RESERVED2_SHIFT)
#define  DISTORT_VCH13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH13_RESERVED2_SHIFT))

#define  DISTORT_VCH13_VCOEF2_MASK 0xfff
#define  DISTORT_VCH13_VCOEF2_SHIFT 0
#define  DISTORT_VCH13_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH13_VCOEF2_MASK) >> DISTORT_VCH13_VCOEF2_SHIFT)
#define  DISTORT_VCH13_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH13_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH13_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 15 of 16) (VCH14)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 15 of 16)*/
//====================================================================

#define  DISTORT_VCH14_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH14_RESERVED1_SHIFT 28
#define  DISTORT_VCH14_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_RESERVED1_MASK) >> DISTORT_VCH14_RESERVED1_SHIFT)
#define  DISTORT_VCH14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH14_RESERVED1_SHIFT))

#define  DISTORT_VCH14_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH14_VCOEF3_SHIFT 16
#define  DISTORT_VCH14_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_VCOEF3_MASK) >> DISTORT_VCH14_VCOEF3_SHIFT)
#define  DISTORT_VCH14_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH14_VCOEF3_SHIFT))

#define  DISTORT_VCH14_RESERVED2_MASK 0xf000
#define  DISTORT_VCH14_RESERVED2_SHIFT 12
#define  DISTORT_VCH14_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_RESERVED2_MASK) >> DISTORT_VCH14_RESERVED2_SHIFT)
#define  DISTORT_VCH14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH14_RESERVED2_SHIFT))

#define  DISTORT_VCH14_VCOEF2_MASK 0xfff
#define  DISTORT_VCH14_VCOEF2_SHIFT 0
#define  DISTORT_VCH14_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH14_VCOEF2_MASK) >> DISTORT_VCH14_VCOEF2_SHIFT)
#define  DISTORT_VCH14_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH14_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH14_VCOEF2_SHIFT))

//====================================================================
//Register: Vertical Coefficient 2 / 3 (Instance 16 of 16) (VCH15)
/** \brief This register contains vertical coefficients 2 and 3 for the output filter. (Instance 16 of 16)*/
//====================================================================

#define  DISTORT_VCH15_RESERVED1_MASK 0xf0000000
#define  DISTORT_VCH15_RESERVED1_SHIFT 28
#define  DISTORT_VCH15_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_RESERVED1_MASK) >> DISTORT_VCH15_RESERVED1_SHIFT)
#define  DISTORT_VCH15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_VCH15_RESERVED1_SHIFT))

#define  DISTORT_VCH15_VCOEF3_MASK 0xfff0000
#define  DISTORT_VCH15_VCOEF3_SHIFT 16
#define  DISTORT_VCH15_VCOEF3_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_VCOEF3_MASK) >> DISTORT_VCH15_VCOEF3_SHIFT)
#define  DISTORT_VCH15_VCOEF3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_VCOEF3_MASK) | (((uint32_t)val) << DISTORT_VCH15_VCOEF3_SHIFT))

#define  DISTORT_VCH15_RESERVED2_MASK 0xf000
#define  DISTORT_VCH15_RESERVED2_SHIFT 12
#define  DISTORT_VCH15_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_RESERVED2_MASK) >> DISTORT_VCH15_RESERVED2_SHIFT)
#define  DISTORT_VCH15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_VCH15_RESERVED2_SHIFT))

#define  DISTORT_VCH15_VCOEF2_MASK 0xfff
#define  DISTORT_VCH15_VCOEF2_SHIFT 0
#define  DISTORT_VCH15_VCOEF2_MASK_SHIFT(reg) (((reg) & DISTORT_VCH15_VCOEF2_MASK) >> DISTORT_VCH15_VCOEF2_SHIFT)
#define  DISTORT_VCH15_VCOEF2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_VCH15_VCOEF2_MASK) | (((uint32_t)val) << DISTORT_VCH15_VCOEF2_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT_MAP (DISTORT_MAP)
/** \brief Register descriptions for the DISTORT_MAP block.*/
//
//====================================================================

//====================================================================
//Register: DISTORT_MAP Block Configuration Register (CR_BLOCK)
/** \brief This register configures the general operation of the DISTORT_MAP block.*/
//====================================================================

#define  DISTORT_MAP_CR_BLOCK_RESERVED1_MASK 0xc0000000
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT 30
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED1_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_OVERLAP_MASK 0x3f000000
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT 24
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_OVERLAP_MASK) >> DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_OVERLAP_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED2_MASK 0xf80000
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT 19
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED2_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK 0x70000
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT 16
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK) >> DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED3_MASK 0xfc00
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT 10
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED3_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_MODE_MASK 0x300
#define  DISTORT_MAP_CR_BLOCK_MODE_SHIFT 8
#define  DISTORT_MAP_CR_BLOCK_MODE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_MODE_MASK) >> DISTORT_MAP_CR_BLOCK_MODE_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_MODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_MODE_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_MODE_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED4_MASK 0xfe
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT 1
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED4_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK 0x1
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT 0
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK) >> DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Image Configuration Register (CR_IMAGE)
/** \brief This register contains information about the output map to be produced.*/
//====================================================================

#define  DISTORT_MAP_CR_IMAGE_WIDTH_MASK 0xffff0000
#define  DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT 16
#define  DISTORT_MAP_CR_IMAGE_WIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_IMAGE_WIDTH_MASK) >> DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT)
#define  DISTORT_MAP_CR_IMAGE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_IMAGE_WIDTH_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT))

#define  DISTORT_MAP_CR_IMAGE_HEIGHT_MASK 0xffff
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT 0
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_IMAGE_HEIGHT_MASK) >> DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT)
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_IMAGE_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Strip Configuration Register (CR_STRIP)
/** \brief This register sets the configuration of the output strip. This register is write-only.*/
//====================================================================

#define  DISTORT_MAP_CR_STRIP_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_CR_STRIP_START_LINE_SHIFT 16
#define  DISTORT_MAP_CR_STRIP_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_START_LINE_MASK) >> DISTORT_MAP_CR_STRIP_START_LINE_SHIFT)
#define  DISTORT_MAP_CR_STRIP_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_START_LINE_SHIFT))

#define  DISTORT_MAP_CR_STRIP_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT 6
#define  DISTORT_MAP_CR_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_RESERVED1_MASK) >> DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK) >> DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Strip Status Register (SR_STRIP)
/** \brief This register contains the configuration of the output strip. This register is read-only.*/
//====================================================================

#define  DISTORT_MAP_SR_STRIP_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_SR_STRIP_START_LINE_SHIFT 16
#define  DISTORT_MAP_SR_STRIP_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_START_LINE_MASK) >> DISTORT_MAP_SR_STRIP_START_LINE_SHIFT)
#define  DISTORT_MAP_SR_STRIP_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_START_LINE_SHIFT))

#define  DISTORT_MAP_SR_STRIP_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT 6
#define  DISTORT_MAP_SR_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_RESERVED1_MASK) >> DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK) >> DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Output Status Register (SR_OUTPUT)
/** \brief This register contains the status of the output control state machines.*/
//====================================================================

#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK 0xfe000000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT 25
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK 0x1000000
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT 24
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK 0xe00000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT 21
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK 0x100000
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT 20
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK 0xe0000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT 17
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK 0x10000
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT 16
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK 0xfe00
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT 9
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK 0x100
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT 8
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK 0xe0
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT 5
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK 0x10
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT 4
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK 0xe
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT 1
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK 0x1
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT 0
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 0 Configuration Register (CR_CH0SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH0SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH0SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH0SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE0_VAL_MASK) >> DISTORT_MAP_CR_CH0SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH0SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 1 Configuration Register (CR_CH0SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH0SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH0SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH0SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE1_VAL_MASK) >> DISTORT_MAP_CR_CH0SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH0SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 0 Configuration Register (CR_CH1SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH1SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH1SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH1SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE0_VAL_MASK) >> DISTORT_MAP_CR_CH1SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH1SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 1 Configuration Register (CR_CH1SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH1SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH1SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH1SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE1_VAL_MASK) >> DISTORT_MAP_CR_CH1SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH1SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 0 Configuration Register (CR_CH2SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH2SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH2SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH2SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE0_VAL_MASK) >> DISTORT_MAP_CR_CH2SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH2SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 1 Configuration Register (CR_CH2SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH2SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH2SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH2SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE1_VAL_MASK) >> DISTORT_MAP_CR_CH2SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH2SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 0 Status Register (SR_CH0SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH0SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH0SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH0SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE0_VAL_MASK) >> DISTORT_MAP_SR_CH0SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH0SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 1 Status Register (SR_CH0SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH0SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH0SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH0SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE1_VAL_MASK) >> DISTORT_MAP_SR_CH0SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH0SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 0 Status Register (SR_CH1SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH1SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH1SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH1SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE0_VAL_MASK) >> DISTORT_MAP_SR_CH1SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH1SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 1 Status Register (SR_CH1SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH1SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH1SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH1SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE1_VAL_MASK) >> DISTORT_MAP_SR_CH1SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH1SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 0 Status Register (SR_CH2SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH2SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH2SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH2SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE0_VAL_MASK) >> DISTORT_MAP_SR_CH2SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH2SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 1 Status Register (SR_CH2SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH2SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH2SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH2SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE1_VAL_MASK) >> DISTORT_MAP_SR_CH2SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH2SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Enable Register (INTR_EN)
/** \brief Enable Overflow Detection Interrupts with this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_EN_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_EN_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_EN_RESERVED1_MASK) >> DISTORT_MAP_INTR_EN_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_EN_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_EN_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_EN_INT_ENABLE_MASK 0x1
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT 0
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_EN_INT_ENABLE_MASK) >> DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT)
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_EN_INT_ENABLE_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Status Register (INTR_STAT)
/** \brief Interrupt Status of the block. Each channel has its own interrupt status field in this register. <br/> The meaning of the bits are as follows: <br/> [0]: Prefetch Channel Overflow, first column, first element (X0[0]). <br/> [1]: Prefetch Channel Overflow, first column, second element (X0[1]). <br/> [2]: Prefetch Channel Overflow, second column, first element (X1[0]). <br/> [3]: Prefetch Channel Overflow, second column, second element (X1[1]). <br/> [4]: Delayed Channel Overflow, first column, first element (X0[0]). <br/> [5]: Delayed Channel Overflow, first column, second element (X0[1]). <br/> [6]: Delayed Channel Overflow, second column, first element (X1[0]). <br/> [7]: Delayed Channel Overflow, second column, second element (X1[1]).*/
//====================================================================

#define  DISTORT_MAP_INTR_STAT_RESERVED1_MASK 0xff000000
#define  DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT 24
#define  DISTORT_MAP_INTR_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_RESERVED1_MASK) >> DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK 0xff0000
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT 16
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK 0xff00
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT 8
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK 0xff
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT 0
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Acknowledge Register (INTR_ACK)
/** \brief Acknowledge Interrupts by writing a 1 to this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_ACK_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_ACK_RESERVED1_MASK) >> DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_ACK_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_ACK_INT_ACK_MASK 0x1
#define  DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT 0
#define  DISTORT_MAP_INTR_ACK_INT_ACK_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_ACK_INT_ACK_MASK) >> DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT)
#define  DISTORT_MAP_INTR_ACK_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_ACK_INT_ACK_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Force Register (INTR_FORCE)
/** \brief Force an interrupt by writing a 1 to this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_FORCE_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_FORCE_RESERVED1_MASK) >> DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_FORCE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK 0x1
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT 0
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK) >> DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT)
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Prefetch Debug Register (DR_CH0PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 0.*/
//====================================================================

#define  DISTORT_MAP_DR_CH0PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Delayed Debug Register (DR_CH0DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 0.*/
//====================================================================

#define  DISTORT_MAP_DR_CH0DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Prefetch Debug Register (DR_CH1PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 1.*/
//====================================================================

#define  DISTORT_MAP_DR_CH1PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Delayed Debug Register (DR_CH1DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 1.*/
//====================================================================

#define  DISTORT_MAP_DR_CH1DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Prefetch Debug Register (DR_CH2PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 2.*/
//====================================================================

#define  DISTORT_MAP_DR_CH2PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Delayed Debug Register (DR_CH2DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 2.*/
//====================================================================

#define  DISTORT_MAP_DR_CH2DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DISTORT_MAP_REV0_MAJ_MASK 0xffff0000
#define  DISTORT_MAP_REV0_MAJ_SHIFT 16
#define  DISTORT_MAP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV0_MAJ_MASK) >> DISTORT_MAP_REV0_MAJ_SHIFT)
#define  DISTORT_MAP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV0_MAJ_MASK) | (((uint32_t)val) << DISTORT_MAP_REV0_MAJ_SHIFT))

#define  DISTORT_MAP_REV0_MID_MASK 0xffff
#define  DISTORT_MAP_REV0_MID_SHIFT 0
#define  DISTORT_MAP_REV0_MID_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV0_MID_MASK) >> DISTORT_MAP_REV0_MID_SHIFT)
#define  DISTORT_MAP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV0_MID_MASK) | (((uint32_t)val) << DISTORT_MAP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DISTORT_MAP_REV1_RESERVED1_MASK 0xffff0000
#define  DISTORT_MAP_REV1_RESERVED1_SHIFT 16
#define  DISTORT_MAP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV1_RESERVED1_MASK) >> DISTORT_MAP_REV1_RESERVED1_SHIFT)
#define  DISTORT_MAP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_REV1_RESERVED1_SHIFT))

#define  DISTORT_MAP_REV1_CFG_MASK 0xffff
#define  DISTORT_MAP_REV1_CFG_SHIFT 0
#define  DISTORT_MAP_REV1_CFG_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV1_CFG_MASK) >> DISTORT_MAP_REV1_CFG_SHIFT)
#define  DISTORT_MAP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV1_CFG_MASK) | (((uint32_t)val) << DISTORT_MAP_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 1 of 3) (ANTIFCOR_TOP_LUT1D_BDE0)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_REV1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_REV1_CFG_SHIFT))

//====================================================================
//Register: LUT1D Configuration Register (LUT_CR)
/** \brief The Control Register allows for setting the block mode and CPU access to the SRAMs*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_MASK 0xfffc0000
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_SHIFT 18
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_MASK 0x20000
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_SHIFT 17
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_WRITE_ALL_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_MASK 0x10000
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_CPU_ACCESS_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_MASK 0xfffe
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_SHIFT 1
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT_CR_BYPASS_ENABLE_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 (LUT0)
/** \brief The LUT0 registers are memory mapped to the first LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_MASK 0xffffc000
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_SHIFT 14
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_MASK 0x3fff
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE0_LUT0_LUT_VAL_SHIFT))

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 2 of 3) (ANTIFCOR_TOP_LUT1D_BDE1)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_REV0_MAJ_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_REV1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_REV1_CFG_SHIFT))

//====================================================================
//Register: LUT1D Configuration Register (LUT_CR)
/** \brief The Control Register allows for setting the block mode and CPU access to the SRAMs*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_MASK 0xfffc0000
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_SHIFT 18
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_MASK 0x20000
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_SHIFT 17
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_WRITE_ALL_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_MASK 0x10000
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_CPU_ACCESS_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_MASK 0xfffe
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_SHIFT 1
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT_CR_BYPASS_ENABLE_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 (LUT0)
/** \brief The LUT0 registers are memory mapped to the first LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_MASK 0xffffc000
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_SHIFT 14
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_MASK 0x3fff
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE1_LUT0_LUT_VAL_SHIFT))

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 3 of 3) (ANTIFCOR_TOP_LUT1D_BDE2)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_REV0_MAJ_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_REV1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_MASK 0xffff
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_REV1_CFG_SHIFT))

//====================================================================
//Register: LUT1D Configuration Register (LUT_CR)
/** \brief The Control Register allows for setting the block mode and CPU access to the SRAMs*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_MASK 0xfffc0000
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_SHIFT 18
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_MASK 0x20000
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_SHIFT 17
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_WRITE_ALL_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_MASK 0x10000
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_SHIFT 16
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_CPU_ACCESS_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_MASK 0xfffe
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_SHIFT 1
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT_CR_BYPASS_ENABLE_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 (LUT0)
/** \brief The LUT0 registers are memory mapped to the first LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_MASK 0xffffc000
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_SHIFT 14
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_MASK 0x3fff
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_SHIFT 0
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_MASK) >> ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_SHIFT)
#define  ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_LUT1D_BDE2_LUT0_LUT_VAL_SHIFT))

//====================================================================
//
//Register File: PIE Antiflare Correction (ANTIFCOR_TOP_ANTIFCOR)
/** \brief Register descriptions for the ANTIFCOR block.*/
//
//====================================================================

//====================================================================
//Register: ANTIFCOR Configuration Register (ANTIFCOR_CFG)
//====================================================================

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK 0xf8000000
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT 27
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK 0x7000000
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT 24
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK 0xf80000
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT 19
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK 0x70000
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT 16
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK 0xfffe
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT 1
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK 0x1
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT 0
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT))

//====================================================================
//Register: ANTIFCOR Gray and Black Clip Register (ANTIFCOR_CLIP)
//====================================================================

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK 0xffff0000
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT 16
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK 0xffff
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT 0
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK) >> ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_MASK 0xffff0000
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_SHIFT 16
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_MASK) >> ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MID_MASK 0xffff
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MID_SHIFT 0
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_REV0_MID_MASK) >> ANTIFCOR_TOP_ANTIFCOR_REV0_MID_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_REV0_MID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_MASK) >> ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_REV1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_MASK 0xffff
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_SHIFT 0
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_MASK) >> ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_SHIFT)
#define  ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_ANTIFCOR_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 1 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA0)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA0_UTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 2 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA1)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA1_UTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 3 of 3) (ANTIFCOR_TOP_DDMA_AC_DATA2)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_DATA2_UTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 1 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR0)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR0_UTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 2 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR1)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR1_UTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 3 of 3) (ANTIFCOR_TOP_DDMA_AC_CORR2)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_MASK 0xfff00000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_SHIFT 20
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_MASK 0xf0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DATAAXCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_MASK 0xf000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_SHIFT 12
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCARCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_MASK 0xf00
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_DESCAWCACHE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_MASK 0x80
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_SHIFT 7
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_MASK 0x60
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OUTPUTSELECT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNWRITEDISABLE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_OWNPOLARITY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_MASK 0x6
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_BEATS_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_MASK 0xffffffc0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_SHIFT 6
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_MASK 0x20
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CMDBUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFFULL_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_DATABUFEMPTY_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_CLEAR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_MASK 0xff000000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_SHIFT 24
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_MASK 0xffff00
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_FIFODEPTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_MASK 0xe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_RESERVED2_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_SERPSUPPORT_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_DESCLENGTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_BUSWIDTH_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_MASK 0xffffffe0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_SHIFT 5
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_MASK 0x10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_SHIFT 4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_RRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_MASK 0x8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_SHIFT 3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_BRESP_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_CLEARCOMPLETE_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_MASK 0x2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_SHIFT 1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_MASK 0x1
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_MASK 0xfffffffc
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_SHIFT 2
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_DESC_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_MASK 0x3
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_MASK 0xffffffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_MASK 0xfffffc00
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_SHIFT 10
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_MASK 0x200
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_SHIFT 9
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTDIR_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_MASK 0x100
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_SHIFT 8
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLAST_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_MASK 0xff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_SHIFT 16
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_RESERVED1_SHIFT))

#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_MASK 0xffff
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_SHIFT 0
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_MASK) >> ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_SHIFT)
#define  ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_MASK) | (((uint32_t)val) << ANTIFCOR_TOP_DDMA_AC_CORR2_UTR2_TAGMID_SHIFT))

#endif // DISTORT_TOP
