 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_MAP_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_MAP_REGSTRUCTS_H_
#define _DISTORT_MAP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT_MAP (DISTORT_MAP)
/** \brief Register descriptions for the DISTORT_MAP block.*/
//
//====================================================================

typedef struct DISTORT_MAP_REGS_s
{
  volatile uint32_t CR_BLOCK;  ///< 0x0 [R/W]: DISTORT_MAP Block Configuration Register
  volatile uint32_t CR_IMAGE;  ///< 0x4 [R/W]: DISTORT_MAP Image Configuration Register
  volatile uint32_t CR_STRIP;  ///< 0x8 [W]: DISTORT_MAP Strip Configuration Register
  volatile uint32_t SR_STRIP;  ///< 0xc [R]: DISTORT_MAP Strip Status Register
  volatile uint32_t SR_OUTPUT;  ///< 0x10 [R]: DISTORT_MAP Output Status Register
  volatile uint32_t CR_CH0SE0;  ///< 0x14 [W]: DISTORT_MAP Channel 0 Start Element 0 Configuration Register
  volatile uint32_t CR_CH0SE1;  ///< 0x18 [W]: DISTORT_MAP Channel 0 Start Element 1 Configuration Register
  volatile uint32_t CR_CH1SE0;  ///< 0x1c [W]: DISTORT_MAP Channel 1 Start Element 0 Configuration Register
  volatile uint32_t CR_CH1SE1;  ///< 0x20 [W]: DISTORT_MAP Channel 1 Start Element 1 Configuration Register
  volatile uint32_t CR_CH2SE0;  ///< 0x24 [W]: DISTORT_MAP Channel 2 Start Element 0 Configuration Register
  volatile uint32_t CR_CH2SE1;  ///< 0x28 [W]: DISTORT_MAP Channel 2 Start Element 1 Configuration Register
  volatile uint32_t SR_CH0SE0;  ///< 0x2c [R]: DISTORT_MAP Channel 0 Start Element 0 Status Register
  volatile uint32_t SR_CH0SE1;  ///< 0x30 [R]: DISTORT_MAP Channel 0 Start Element 1 Status Register
  volatile uint32_t SR_CH1SE0;  ///< 0x34 [R]: DISTORT_MAP Channel 1 Start Element 0 Status Register
  volatile uint32_t SR_CH1SE1;  ///< 0x38 [R]: DISTORT_MAP Channel 1 Start Element 1 Status Register
  volatile uint32_t SR_CH2SE0;  ///< 0x3c [R]: DISTORT_MAP Channel 2 Start Element 0 Status Register
  volatile uint32_t SR_CH2SE1;  ///< 0x40 [R]: DISTORT_MAP Channel 2 Start Element 1 Status Register
  volatile uint32_t INTR_EN;  ///< 0x44 [R/W]: DISTORT_MAP Interrupt Enable Register
  volatile uint32_t INTR_STAT;  ///< 0x48 [R]: DISTORT_MAP Interrupt Status Register
  volatile uint32_t INTR_ACK;  ///< 0x4c [W]: DISTORT_MAP Interrupt Acknowledge Register
  volatile uint32_t INTR_FORCE;  ///< 0x50 [W]: DISTORT_MAP Interrupt Force Register
  volatile uint32_t DR_CH0PRE;  ///< 0x54 [R]: DISTORT_MAP Channel 0 Prefetch Debug Register
  volatile uint32_t DR_CH0DEL;  ///< 0x58 [R]: DISTORT_MAP Channel 0 Delayed Debug Register
  volatile uint32_t DR_CH1PRE;  ///< 0x5c [R]: DISTORT_MAP Channel 1 Prefetch Debug Register
  volatile uint32_t DR_CH1DEL;  ///< 0x60 [R]: DISTORT_MAP Channel 1 Delayed Debug Register
  volatile uint32_t DR_CH2PRE;  ///< 0x64 [R]: DISTORT_MAP Channel 2 Prefetch Debug Register
  volatile uint32_t DR_CH2DEL;  ///< 0x68 [R]: DISTORT_MAP Channel 2 Delayed Debug Register
  volatile uint32_t REV0;  ///< 0x6c [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x70 [R]: IP Tagging Revision 1
} DISTORT_MAP_REGS_t;

#endif // DISTORT_MAP
