 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_MAP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_MAP_REGMASKS_H_
#define _DISTORT_MAP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT_MAP (DISTORT_MAP)
/** \brief Register descriptions for the DISTORT_MAP block.*/
//
//====================================================================

//====================================================================
//Register: DISTORT_MAP Block Configuration Register (CR_BLOCK)
/** \brief This register configures the general operation of the DISTORT_MAP block.*/
//====================================================================

#define  DISTORT_MAP_CR_BLOCK_RESERVED1_MASK 0xc0000000
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT 30
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED1_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_OVERLAP_MASK 0x3f000000
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT 24
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_OVERLAP_MASK) >> DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_OVERLAP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_OVERLAP_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_OVERLAP_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED2_MASK 0xf80000
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT 19
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED2_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED2_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK 0x70000
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT 16
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK) >> DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_SCALE_FACTOR_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED3_MASK 0xfc00
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT 10
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED3_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED3_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_MODE_MASK 0x300
#define  DISTORT_MAP_CR_BLOCK_MODE_SHIFT 8
#define  DISTORT_MAP_CR_BLOCK_MODE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_MODE_MASK) >> DISTORT_MAP_CR_BLOCK_MODE_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_MODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_MODE_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_MODE_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_RESERVED4_MASK 0xfe
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT 1
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_RESERVED4_MASK) >> DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_RESERVED4_SHIFT))

#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK 0x1
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT 0
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK) >> DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT)
#define  DISTORT_MAP_CR_BLOCK_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_BLOCK_BYPASS_ALL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_BLOCK_BYPASS_ALL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Image Configuration Register (CR_IMAGE)
/** \brief This register contains information about the output map to be produced.*/
//====================================================================

#define  DISTORT_MAP_CR_IMAGE_WIDTH_MASK 0xffff0000
#define  DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT 16
#define  DISTORT_MAP_CR_IMAGE_WIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_IMAGE_WIDTH_MASK) >> DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT)
#define  DISTORT_MAP_CR_IMAGE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_IMAGE_WIDTH_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_IMAGE_WIDTH_SHIFT))

#define  DISTORT_MAP_CR_IMAGE_HEIGHT_MASK 0xffff
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT 0
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_IMAGE_HEIGHT_MASK) >> DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT)
#define  DISTORT_MAP_CR_IMAGE_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_IMAGE_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_IMAGE_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Strip Configuration Register (CR_STRIP)
/** \brief This register sets the configuration of the output strip. This register is write-only.*/
//====================================================================

#define  DISTORT_MAP_CR_STRIP_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_CR_STRIP_START_LINE_SHIFT 16
#define  DISTORT_MAP_CR_STRIP_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_START_LINE_MASK) >> DISTORT_MAP_CR_STRIP_START_LINE_SHIFT)
#define  DISTORT_MAP_CR_STRIP_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_START_LINE_SHIFT))

#define  DISTORT_MAP_CR_STRIP_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT 6
#define  DISTORT_MAP_CR_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_RESERVED1_MASK) >> DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK) >> DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Strip Status Register (SR_STRIP)
/** \brief This register contains the configuration of the output strip. This register is read-only.*/
//====================================================================

#define  DISTORT_MAP_SR_STRIP_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_SR_STRIP_START_LINE_SHIFT 16
#define  DISTORT_MAP_SR_STRIP_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_START_LINE_MASK) >> DISTORT_MAP_SR_STRIP_START_LINE_SHIFT)
#define  DISTORT_MAP_SR_STRIP_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_START_LINE_SHIFT))

#define  DISTORT_MAP_SR_STRIP_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT 6
#define  DISTORT_MAP_SR_STRIP_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_RESERVED1_MASK) >> DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_STRIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK) >> DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_STRIP_OUTPUT_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Output Status Register (SR_OUTPUT)
/** \brief This register contains the status of the output control state machines.*/
//====================================================================

#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK 0xfe000000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT 25
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK 0x1000000
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT 24
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH2_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK 0xe00000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT 21
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED2_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK 0x100000
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT 20
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH1_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK 0xe0000
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT 17
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED3_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK 0x10000
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT 16
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH0_DEL_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK 0xfe00
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT 9
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED4_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK 0x100
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT 8
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH2_PRE_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK 0xe0
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT 5
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED5_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED5_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK 0x10
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT 4
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH1_PRE_IDLE_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK 0xe
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT 1
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK) >> DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_RESERVED6_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_RESERVED6_SHIFT))

#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK 0x1
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT 0
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK) >> DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT)
#define  DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_OUTPUT_CH0_PRE_IDLE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 0 Configuration Register (CR_CH0SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH0SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH0SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH0SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH0SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE0_VAL_MASK) >> DISTORT_MAP_CR_CH0SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH0SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 1 Configuration Register (CR_CH0SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH0SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH0SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH0SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH0SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH0SE1_VAL_MASK) >> DISTORT_MAP_CR_CH0SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH0SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH0SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH0SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 0 Configuration Register (CR_CH1SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH1SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH1SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH1SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH1SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE0_VAL_MASK) >> DISTORT_MAP_CR_CH1SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH1SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 1 Configuration Register (CR_CH1SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH1SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH1SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH1SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH1SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH1SE1_VAL_MASK) >> DISTORT_MAP_CR_CH1SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH1SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH1SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH1SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 0 Configuration Register (CR_CH2SE0)
/** \brief This register sets the Start Element 0 (X) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK) >> DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH2SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH2SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH2SE0_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH2SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE0_VAL_MASK) >> DISTORT_MAP_CR_CH2SE0_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH2SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 1 Configuration Register (CR_CH2SE1)
/** \brief This register sets the Start Element 1 (Y) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK) >> DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_CR_CH2SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_CR_CH2SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_CR_CH2SE1_VAL_SHIFT 0
#define  DISTORT_MAP_CR_CH2SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_CR_CH2SE1_VAL_MASK) >> DISTORT_MAP_CR_CH2SE1_VAL_SHIFT)
#define  DISTORT_MAP_CR_CH2SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_CR_CH2SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_CR_CH2SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 0 Status Register (SR_CH0SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH0SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH0SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH0SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH0SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE0_VAL_MASK) >> DISTORT_MAP_SR_CH0SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH0SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Start Element 1 Status Register (SR_CH0SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 0.*/
//====================================================================

#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH0SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH0SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH0SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH0SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH0SE1_VAL_MASK) >> DISTORT_MAP_SR_CH0SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH0SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH0SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH0SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 0 Status Register (SR_CH1SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH1SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH1SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH1SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH1SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE0_VAL_MASK) >> DISTORT_MAP_SR_CH1SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH1SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Start Element 1 Status Register (SR_CH1SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 1.*/
//====================================================================

#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH1SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH1SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH1SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH1SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH1SE1_VAL_MASK) >> DISTORT_MAP_SR_CH1SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH1SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH1SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH1SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 0 Status Register (SR_CH2SE0)
/** \brief This register contains the Start Element 0 (X) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK) >> DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH2SE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE0_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH2SE0_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH2SE0_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH2SE0_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE0_VAL_MASK) >> DISTORT_MAP_SR_CH2SE0_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH2SE0_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE0_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE0_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Start Element 1 Status Register (SR_CH2SE1)
/** \brief This register contains the Start Element 1 (Y) value for Channel 2.*/
//====================================================================

#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK 0xfff00000
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT 20
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK) >> DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT)
#define  DISTORT_MAP_SR_CH2SE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE1_RESERVED1_SHIFT))

#define  DISTORT_MAP_SR_CH2SE1_VAL_MASK 0xfffff
#define  DISTORT_MAP_SR_CH2SE1_VAL_SHIFT 0
#define  DISTORT_MAP_SR_CH2SE1_VAL_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_SR_CH2SE1_VAL_MASK) >> DISTORT_MAP_SR_CH2SE1_VAL_SHIFT)
#define  DISTORT_MAP_SR_CH2SE1_VAL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_SR_CH2SE1_VAL_MASK) | (((uint32_t)val) << DISTORT_MAP_SR_CH2SE1_VAL_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Enable Register (INTR_EN)
/** \brief Enable Overflow Detection Interrupts with this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_EN_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_EN_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_EN_RESERVED1_MASK) >> DISTORT_MAP_INTR_EN_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_EN_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_EN_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_EN_INT_ENABLE_MASK 0x1
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT 0
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_EN_INT_ENABLE_MASK) >> DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT)
#define  DISTORT_MAP_INTR_EN_INT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_EN_INT_ENABLE_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_EN_INT_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Status Register (INTR_STAT)
/** \brief Interrupt Status of the block. Each channel has its own interrupt status field in this register. <br/> The meaning of the bits are as follows: <br/> [0]: Prefetch Channel Overflow, first column, first element (X0[0]). <br/> [1]: Prefetch Channel Overflow, first column, second element (X0[1]). <br/> [2]: Prefetch Channel Overflow, second column, first element (X1[0]). <br/> [3]: Prefetch Channel Overflow, second column, second element (X1[1]). <br/> [4]: Delayed Channel Overflow, first column, first element (X0[0]). <br/> [5]: Delayed Channel Overflow, first column, second element (X0[1]). <br/> [6]: Delayed Channel Overflow, second column, first element (X1[0]). <br/> [7]: Delayed Channel Overflow, second column, second element (X1[1]).*/
//====================================================================

#define  DISTORT_MAP_INTR_STAT_RESERVED1_MASK 0xff000000
#define  DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT 24
#define  DISTORT_MAP_INTR_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_RESERVED1_MASK) >> DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK 0xff0000
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT 16
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_2_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_2_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK 0xff00
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT 8
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_1_SHIFT))

#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK 0xff
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT 0
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK) >> DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT)
#define  DISTORT_MAP_INTR_STAT_INT_STATUS_0_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_STAT_INT_STATUS_0_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_STAT_INT_STATUS_0_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Acknowledge Register (INTR_ACK)
/** \brief Acknowledge Interrupts by writing a 1 to this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_ACK_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_ACK_RESERVED1_MASK) >> DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_ACK_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_ACK_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_ACK_INT_ACK_MASK 0x1
#define  DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT 0
#define  DISTORT_MAP_INTR_ACK_INT_ACK_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_ACK_INT_ACK_MASK) >> DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT)
#define  DISTORT_MAP_INTR_ACK_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_ACK_INT_ACK_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_ACK_INT_ACK_SHIFT))

//====================================================================
//Register: DISTORT_MAP Interrupt Force Register (INTR_FORCE)
/** \brief Force an interrupt by writing a 1 to this register.*/
//====================================================================

#define  DISTORT_MAP_INTR_FORCE_RESERVED1_MASK 0xfffffffe
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT 1
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_FORCE_RESERVED1_MASK) >> DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT)
#define  DISTORT_MAP_INTR_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_FORCE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_FORCE_RESERVED1_SHIFT))

#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK 0x1
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT 0
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK) >> DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT)
#define  DISTORT_MAP_INTR_FORCE_INT_FORCE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_INTR_FORCE_INT_FORCE_MASK) | (((uint32_t)val) << DISTORT_MAP_INTR_FORCE_INT_FORCE_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Prefetch Debug Register (DR_CH0PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 0.*/
//====================================================================

#define  DISTORT_MAP_DR_CH0PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 0 Delayed Debug Register (DR_CH0DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 0.*/
//====================================================================

#define  DISTORT_MAP_DR_CH0DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH0DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Prefetch Debug Register (DR_CH1PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 1.*/
//====================================================================

#define  DISTORT_MAP_DR_CH1PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 1 Delayed Debug Register (DR_CH1DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 1.*/
//====================================================================

#define  DISTORT_MAP_DR_CH1DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH1DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Prefetch Debug Register (DR_CH2PRE)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Prefetch Channel 2.*/
//====================================================================

#define  DISTORT_MAP_DR_CH2PRE_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_START_LINE_MASK) >> DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK) >> DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2PRE_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: DISTORT_MAP Channel 2 Delayed Debug Register (DR_CH2DEL)
/** \brief This register allows reading of the current Start Line and Output POGO Height of the Delayed Channel 2.*/
//====================================================================

#define  DISTORT_MAP_DR_CH2DEL_START_LINE_MASK 0xffff0000
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT 16
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_START_LINE_MASK) >> DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_START_LINE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_START_LINE_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_START_LINE_SHIFT))

#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK 0xffc0
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT 6
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK) >> DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_RESERVED1_SHIFT))

#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK 0x3f
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT 0
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK) >> DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT)
#define  DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_MASK) | (((uint32_t)val) << DISTORT_MAP_DR_CH2DEL_POGO_HEIGHT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DISTORT_MAP_REV0_MAJ_MASK 0xffff0000
#define  DISTORT_MAP_REV0_MAJ_SHIFT 16
#define  DISTORT_MAP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV0_MAJ_MASK) >> DISTORT_MAP_REV0_MAJ_SHIFT)
#define  DISTORT_MAP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV0_MAJ_MASK) | (((uint32_t)val) << DISTORT_MAP_REV0_MAJ_SHIFT))

#define  DISTORT_MAP_REV0_MID_MASK 0xffff
#define  DISTORT_MAP_REV0_MID_SHIFT 0
#define  DISTORT_MAP_REV0_MID_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV0_MID_MASK) >> DISTORT_MAP_REV0_MID_SHIFT)
#define  DISTORT_MAP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV0_MID_MASK) | (((uint32_t)val) << DISTORT_MAP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DISTORT_MAP_REV1_RESERVED1_MASK 0xffff0000
#define  DISTORT_MAP_REV1_RESERVED1_SHIFT 16
#define  DISTORT_MAP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV1_RESERVED1_MASK) >> DISTORT_MAP_REV1_RESERVED1_SHIFT)
#define  DISTORT_MAP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_MAP_REV1_RESERVED1_SHIFT))

#define  DISTORT_MAP_REV1_CFG_MASK 0xffff
#define  DISTORT_MAP_REV1_CFG_SHIFT 0
#define  DISTORT_MAP_REV1_CFG_MASK_SHIFT(reg) (((reg) & DISTORT_MAP_REV1_CFG_MASK) >> DISTORT_MAP_REV1_CFG_SHIFT)
#define  DISTORT_MAP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_MAP_REV1_CFG_MASK) | (((uint32_t)val) << DISTORT_MAP_REV1_CFG_SHIFT))

#endif // DISTORT_MAP
