 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DISTORT_DMA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DISTORT_DMA_REGMASKS_H_
#define _DISTORT_DMA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DISTORT_DMA Registers (DISTORT_DMA)
//
//====================================================================

//====================================================================
//Register: DISTORT_DMA Configuration Register (UCR)
//====================================================================

#define  DISTORT_DMA_UCR_RESERVED1_MASK 0xfff00000
#define  DISTORT_DMA_UCR_RESERVED1_SHIFT 20
#define  DISTORT_DMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_RESERVED1_MASK) >> DISTORT_DMA_UCR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  DISTORT_DMA_UCR_DATAAXCACHE_SHIFT 16
#define  DISTORT_DMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_DATAAXCACHE_MASK) >> DISTORT_DMA_UCR_DATAAXCACHE_SHIFT)
#define  DISTORT_DMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_DATAAXCACHE_SHIFT))

#define  DISTORT_DMA_UCR_DESCARCACHE_MASK 0xf000
#define  DISTORT_DMA_UCR_DESCARCACHE_SHIFT 12
#define  DISTORT_DMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_DESCARCACHE_MASK) >> DISTORT_DMA_UCR_DESCARCACHE_SHIFT)
#define  DISTORT_DMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_DESCARCACHE_SHIFT))

#define  DISTORT_DMA_UCR_DESCAWCACHE_MASK 0xf00
#define  DISTORT_DMA_UCR_DESCAWCACHE_SHIFT 8
#define  DISTORT_DMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_DESCAWCACHE_MASK) >> DISTORT_DMA_UCR_DESCAWCACHE_SHIFT)
#define  DISTORT_DMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_DESCAWCACHE_SHIFT))

#define  DISTORT_DMA_UCR_RESERVED2_MASK 0x80
#define  DISTORT_DMA_UCR_RESERVED2_SHIFT 7
#define  DISTORT_DMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_RESERVED2_MASK) >> DISTORT_DMA_UCR_RESERVED2_SHIFT)
#define  DISTORT_DMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_RESERVED2_SHIFT))

#define  DISTORT_DMA_UCR_OUTPUTSELECT_MASK 0x60
#define  DISTORT_DMA_UCR_OUTPUTSELECT_SHIFT 5
#define  DISTORT_DMA_UCR_OUTPUTSELECT_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_OUTPUTSELECT_MASK) >> DISTORT_DMA_UCR_OUTPUTSELECT_SHIFT)
#define  DISTORT_DMA_UCR_OUTPUTSELECT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_OUTPUTSELECT_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_OUTPUTSELECT_SHIFT))

#define  DISTORT_DMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  DISTORT_DMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  DISTORT_DMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_OWNWRITEDISABLE_MASK) >> DISTORT_DMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  DISTORT_DMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  DISTORT_DMA_UCR_OWNPOLARITY_MASK 0x8
#define  DISTORT_DMA_UCR_OWNPOLARITY_SHIFT 3
#define  DISTORT_DMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_OWNPOLARITY_MASK) >> DISTORT_DMA_UCR_OWNPOLARITY_SHIFT)
#define  DISTORT_DMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_OWNPOLARITY_SHIFT))

#define  DISTORT_DMA_UCR_BEATS_MASK 0x6
#define  DISTORT_DMA_UCR_BEATS_SHIFT 1
#define  DISTORT_DMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_BEATS_MASK) >> DISTORT_DMA_UCR_BEATS_SHIFT)
#define  DISTORT_DMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_BEATS_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_BEATS_SHIFT))

#define  DISTORT_DMA_UCR_ENABLE_MASK 0x1
#define  DISTORT_DMA_UCR_ENABLE_SHIFT 0
#define  DISTORT_DMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UCR_ENABLE_MASK) >> DISTORT_DMA_UCR_ENABLE_SHIFT)
#define  DISTORT_DMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UCR_ENABLE_MASK) | (((uint32_t)val) << DISTORT_DMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: DISTORT_DMA Status Register (USR)
//====================================================================

#define  DISTORT_DMA_USR_RESERVED1_MASK 0xffffffc0
#define  DISTORT_DMA_USR_RESERVED1_SHIFT 6
#define  DISTORT_DMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_RESERVED1_MASK) >> DISTORT_DMA_USR_RESERVED1_SHIFT)
#define  DISTORT_DMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_RESERVED1_SHIFT))

#define  DISTORT_DMA_USR_CMDBUFFULL_MASK 0x20
#define  DISTORT_DMA_USR_CMDBUFFULL_SHIFT 5
#define  DISTORT_DMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_CMDBUFFULL_MASK) >> DISTORT_DMA_USR_CMDBUFFULL_SHIFT)
#define  DISTORT_DMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_CMDBUFFULL_SHIFT))

#define  DISTORT_DMA_USR_CMDBUFEMPTY_MASK 0x10
#define  DISTORT_DMA_USR_CMDBUFEMPTY_SHIFT 4
#define  DISTORT_DMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_CMDBUFEMPTY_MASK) >> DISTORT_DMA_USR_CMDBUFEMPTY_SHIFT)
#define  DISTORT_DMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_CMDBUFEMPTY_SHIFT))

#define  DISTORT_DMA_USR_DATABUFFULL_MASK 0x8
#define  DISTORT_DMA_USR_DATABUFFULL_SHIFT 3
#define  DISTORT_DMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_DATABUFFULL_MASK) >> DISTORT_DMA_USR_DATABUFFULL_SHIFT)
#define  DISTORT_DMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_DATABUFFULL_SHIFT))

#define  DISTORT_DMA_USR_DATABUFEMPTY_MASK 0x4
#define  DISTORT_DMA_USR_DATABUFEMPTY_SHIFT 2
#define  DISTORT_DMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_DATABUFEMPTY_MASK) >> DISTORT_DMA_USR_DATABUFEMPTY_SHIFT)
#define  DISTORT_DMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_DATABUFEMPTY_SHIFT))

#define  DISTORT_DMA_USR_CLEAR_MASK 0x2
#define  DISTORT_DMA_USR_CLEAR_SHIFT 1
#define  DISTORT_DMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_CLEAR_MASK) >> DISTORT_DMA_USR_CLEAR_SHIFT)
#define  DISTORT_DMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_CLEAR_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_CLEAR_SHIFT))

#define  DISTORT_DMA_USR_BUSY_MASK 0x1
#define  DISTORT_DMA_USR_BUSY_SHIFT 0
#define  DISTORT_DMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_USR_BUSY_MASK) >> DISTORT_DMA_USR_BUSY_SHIFT)
#define  DISTORT_DMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_USR_BUSY_MASK) | (((uint32_t)val) << DISTORT_DMA_USR_BUSY_SHIFT))

//====================================================================
//Register: DISTORT_DMA Parameter Register (UPR)
//====================================================================

#define  DISTORT_DMA_UPR_RESERVED1_MASK 0xff000000
#define  DISTORT_DMA_UPR_RESERVED1_SHIFT 24
#define  DISTORT_DMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_RESERVED1_MASK) >> DISTORT_DMA_UPR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UPR_FIFODEPTH_MASK 0xffff00
#define  DISTORT_DMA_UPR_FIFODEPTH_SHIFT 8
#define  DISTORT_DMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_FIFODEPTH_MASK) >> DISTORT_DMA_UPR_FIFODEPTH_SHIFT)
#define  DISTORT_DMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_FIFODEPTH_SHIFT))

#define  DISTORT_DMA_UPR_RESERVED2_MASK 0xe0
#define  DISTORT_DMA_UPR_RESERVED2_SHIFT 5
#define  DISTORT_DMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_RESERVED2_MASK) >> DISTORT_DMA_UPR_RESERVED2_SHIFT)
#define  DISTORT_DMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_RESERVED2_SHIFT))

#define  DISTORT_DMA_UPR_SERPSUPPORT_MASK 0x10
#define  DISTORT_DMA_UPR_SERPSUPPORT_SHIFT 4
#define  DISTORT_DMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_SERPSUPPORT_MASK) >> DISTORT_DMA_UPR_SERPSUPPORT_SHIFT)
#define  DISTORT_DMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_SERPSUPPORT_SHIFT))

#define  DISTORT_DMA_UPR_DESCLENGTH_MASK 0x8
#define  DISTORT_DMA_UPR_DESCLENGTH_SHIFT 3
#define  DISTORT_DMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_DESCLENGTH_MASK) >> DISTORT_DMA_UPR_DESCLENGTH_SHIFT)
#define  DISTORT_DMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_DESCLENGTH_SHIFT))

#define  DISTORT_DMA_UPR_BUSWIDTH_MASK 0x4
#define  DISTORT_DMA_UPR_BUSWIDTH_SHIFT 2
#define  DISTORT_DMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_BUSWIDTH_MASK) >> DISTORT_DMA_UPR_BUSWIDTH_SHIFT)
#define  DISTORT_DMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_BUSWIDTH_SHIFT))

#define  DISTORT_DMA_UPR_MEMALIGN_MASK 0x3
#define  DISTORT_DMA_UPR_MEMALIGN_SHIFT 0
#define  DISTORT_DMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UPR_MEMALIGN_MASK) >> DISTORT_DMA_UPR_MEMALIGN_SHIFT)
#define  DISTORT_DMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << DISTORT_DMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Enable Register (UIER)
//====================================================================

#define  DISTORT_DMA_UIER_RESERVED1_MASK 0xffffffe0
#define  DISTORT_DMA_UIER_RESERVED1_SHIFT 5
#define  DISTORT_DMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_RESERVED1_MASK) >> DISTORT_DMA_UIER_RESERVED1_SHIFT)
#define  DISTORT_DMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_RESERVED1_SHIFT))

#define  DISTORT_DMA_UIER_RRESP_MASK 0x10
#define  DISTORT_DMA_UIER_RRESP_SHIFT 4
#define  DISTORT_DMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_RRESP_MASK) >> DISTORT_DMA_UIER_RRESP_SHIFT)
#define  DISTORT_DMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_RRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_RRESP_SHIFT))

#define  DISTORT_DMA_UIER_BRESP_MASK 0x8
#define  DISTORT_DMA_UIER_BRESP_SHIFT 3
#define  DISTORT_DMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_BRESP_MASK) >> DISTORT_DMA_UIER_BRESP_SHIFT)
#define  DISTORT_DMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_BRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_BRESP_SHIFT))

#define  DISTORT_DMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  DISTORT_DMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  DISTORT_DMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_CLEARCOMPLETE_MASK) >> DISTORT_DMA_UIER_CLEARCOMPLETE_SHIFT)
#define  DISTORT_DMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_CLEARCOMPLETE_SHIFT))

#define  DISTORT_DMA_UIER_DESC_MASK 0x2
#define  DISTORT_DMA_UIER_DESC_SHIFT 1
#define  DISTORT_DMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_DESC_MASK) >> DISTORT_DMA_UIER_DESC_SHIFT)
#define  DISTORT_DMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_DESC_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_DESC_SHIFT))

#define  DISTORT_DMA_UIER_OWN_MASK 0x1
#define  DISTORT_DMA_UIER_OWN_SHIFT 0
#define  DISTORT_DMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIER_OWN_MASK) >> DISTORT_DMA_UIER_OWN_SHIFT)
#define  DISTORT_DMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIER_OWN_MASK) | (((uint32_t)val) << DISTORT_DMA_UIER_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Pending Register (UIPR)
//====================================================================

#define  DISTORT_DMA_UIPR_RESERVED1_MASK 0xffffffe0
#define  DISTORT_DMA_UIPR_RESERVED1_SHIFT 5
#define  DISTORT_DMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_RESERVED1_MASK) >> DISTORT_DMA_UIPR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UIPR_RRESP_MASK 0x10
#define  DISTORT_DMA_UIPR_RRESP_SHIFT 4
#define  DISTORT_DMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_RRESP_MASK) >> DISTORT_DMA_UIPR_RRESP_SHIFT)
#define  DISTORT_DMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_RRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_RRESP_SHIFT))

#define  DISTORT_DMA_UIPR_BRESP_MASK 0x8
#define  DISTORT_DMA_UIPR_BRESP_SHIFT 3
#define  DISTORT_DMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_BRESP_MASK) >> DISTORT_DMA_UIPR_BRESP_SHIFT)
#define  DISTORT_DMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_BRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_BRESP_SHIFT))

#define  DISTORT_DMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  DISTORT_DMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  DISTORT_DMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_CLEARCOMPLETE_MASK) >> DISTORT_DMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  DISTORT_DMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  DISTORT_DMA_UIPR_DESC_MASK 0x2
#define  DISTORT_DMA_UIPR_DESC_SHIFT 1
#define  DISTORT_DMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_DESC_MASK) >> DISTORT_DMA_UIPR_DESC_SHIFT)
#define  DISTORT_DMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_DESC_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_DESC_SHIFT))

#define  DISTORT_DMA_UIPR_OWN_MASK 0x1
#define  DISTORT_DMA_UIPR_OWN_SHIFT 0
#define  DISTORT_DMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIPR_OWN_MASK) >> DISTORT_DMA_UIPR_OWN_SHIFT)
#define  DISTORT_DMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIPR_OWN_MASK) | (((uint32_t)val) << DISTORT_DMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Clear Register (UICR)
//====================================================================

#define  DISTORT_DMA_UICR_RESERVED1_MASK 0xffffffe0
#define  DISTORT_DMA_UICR_RESERVED1_SHIFT 5
#define  DISTORT_DMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_RESERVED1_MASK) >> DISTORT_DMA_UICR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UICR_RRESP_MASK 0x10
#define  DISTORT_DMA_UICR_RRESP_SHIFT 4
#define  DISTORT_DMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_RRESP_MASK) >> DISTORT_DMA_UICR_RRESP_SHIFT)
#define  DISTORT_DMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_RRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_RRESP_SHIFT))

#define  DISTORT_DMA_UICR_BRESP_MASK 0x8
#define  DISTORT_DMA_UICR_BRESP_SHIFT 3
#define  DISTORT_DMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_BRESP_MASK) >> DISTORT_DMA_UICR_BRESP_SHIFT)
#define  DISTORT_DMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_BRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_BRESP_SHIFT))

#define  DISTORT_DMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  DISTORT_DMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  DISTORT_DMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_CLEARCOMPLETE_MASK) >> DISTORT_DMA_UICR_CLEARCOMPLETE_SHIFT)
#define  DISTORT_DMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_CLEARCOMPLETE_SHIFT))

#define  DISTORT_DMA_UICR_DESC_MASK 0x2
#define  DISTORT_DMA_UICR_DESC_SHIFT 1
#define  DISTORT_DMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_DESC_MASK) >> DISTORT_DMA_UICR_DESC_SHIFT)
#define  DISTORT_DMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_DESC_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_DESC_SHIFT))

#define  DISTORT_DMA_UICR_OWN_MASK 0x1
#define  DISTORT_DMA_UICR_OWN_SHIFT 0
#define  DISTORT_DMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UICR_OWN_MASK) >> DISTORT_DMA_UICR_OWN_SHIFT)
#define  DISTORT_DMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UICR_OWN_MASK) | (((uint32_t)val) << DISTORT_DMA_UICR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Interrupt Force Register (UIFR)
//====================================================================

#define  DISTORT_DMA_UIFR_RESERVED1_MASK 0xffffffe0
#define  DISTORT_DMA_UIFR_RESERVED1_SHIFT 5
#define  DISTORT_DMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_RESERVED1_MASK) >> DISTORT_DMA_UIFR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UIFR_RRESP_MASK 0x10
#define  DISTORT_DMA_UIFR_RRESP_SHIFT 4
#define  DISTORT_DMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_RRESP_MASK) >> DISTORT_DMA_UIFR_RRESP_SHIFT)
#define  DISTORT_DMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_RRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_RRESP_SHIFT))

#define  DISTORT_DMA_UIFR_BRESP_MASK 0x8
#define  DISTORT_DMA_UIFR_BRESP_SHIFT 3
#define  DISTORT_DMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_BRESP_MASK) >> DISTORT_DMA_UIFR_BRESP_SHIFT)
#define  DISTORT_DMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_BRESP_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_BRESP_SHIFT))

#define  DISTORT_DMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  DISTORT_DMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  DISTORT_DMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_CLEARCOMPLETE_MASK) >> DISTORT_DMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  DISTORT_DMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  DISTORT_DMA_UIFR_DESC_MASK 0x2
#define  DISTORT_DMA_UIFR_DESC_SHIFT 1
#define  DISTORT_DMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_DESC_MASK) >> DISTORT_DMA_UIFR_DESC_SHIFT)
#define  DISTORT_DMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_DESC_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_DESC_SHIFT))

#define  DISTORT_DMA_UIFR_OWN_MASK 0x1
#define  DISTORT_DMA_UIFR_OWN_SHIFT 0
#define  DISTORT_DMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIFR_OWN_MASK) >> DISTORT_DMA_UIFR_OWN_SHIFT)
#define  DISTORT_DMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIFR_OWN_MASK) | (((uint32_t)val) << DISTORT_DMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: DISTORT_DMA Descriptor Register (UDR)
//====================================================================

#define  DISTORT_DMA_UDR_DESC_MASK 0xfffffffc
#define  DISTORT_DMA_UDR_DESC_SHIFT 2
#define  DISTORT_DMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UDR_DESC_MASK) >> DISTORT_DMA_UDR_DESC_SHIFT)
#define  DISTORT_DMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UDR_DESC_MASK) | (((uint32_t)val) << DISTORT_DMA_UDR_DESC_SHIFT))

#define  DISTORT_DMA_UDR_RESERVED1_MASK 0x3
#define  DISTORT_DMA_UDR_RESERVED1_SHIFT 0
#define  DISTORT_DMA_UDR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UDR_RESERVED1_MASK) >> DISTORT_DMA_UDR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UDR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UDR_RESERVED1_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Address Register (UBAR)
//====================================================================

#define  DISTORT_DMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  DISTORT_DMA_UBAR_BURSTADDR_SHIFT 0
#define  DISTORT_DMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UBAR_BURSTADDR_MASK) >> DISTORT_DMA_UBAR_BURSTADDR_SHIFT)
#define  DISTORT_DMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << DISTORT_DMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: DISTORT_DMA Burst Length Register (UBLR)
//====================================================================

#define  DISTORT_DMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  DISTORT_DMA_UBLR_RESERVED1_SHIFT 10
#define  DISTORT_DMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UBLR_RESERVED1_MASK) >> DISTORT_DMA_UBLR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UBLR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UBLR_BURSTDIR_MASK 0x200
#define  DISTORT_DMA_UBLR_BURSTDIR_SHIFT 9
#define  DISTORT_DMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UBLR_BURSTDIR_MASK) >> DISTORT_DMA_UBLR_BURSTDIR_SHIFT)
#define  DISTORT_DMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << DISTORT_DMA_UBLR_BURSTDIR_SHIFT))

#define  DISTORT_DMA_UBLR_BURSTLAST_MASK 0x100
#define  DISTORT_DMA_UBLR_BURSTLAST_SHIFT 8
#define  DISTORT_DMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UBLR_BURSTLAST_MASK) >> DISTORT_DMA_UBLR_BURSTLAST_SHIFT)
#define  DISTORT_DMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << DISTORT_DMA_UBLR_BURSTLAST_SHIFT))

#define  DISTORT_DMA_UBLR_BURSTLENGTH_MASK 0xff
#define  DISTORT_DMA_UBLR_BURSTLENGTH_SHIFT 0
#define  DISTORT_DMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UBLR_BURSTLENGTH_MASK) >> DISTORT_DMA_UBLR_BURSTLENGTH_SHIFT)
#define  DISTORT_DMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << DISTORT_DMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Image Width Register (UIWR)
//====================================================================

#define  DISTORT_DMA_UIWR_RESERVED1_MASK 0xffff0000
#define  DISTORT_DMA_UIWR_RESERVED1_SHIFT 16
#define  DISTORT_DMA_UIWR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIWR_RESERVED1_MASK) >> DISTORT_DMA_UIWR_RESERVED1_SHIFT)
#define  DISTORT_DMA_UIWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIWR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UIWR_RESERVED1_SHIFT))

#define  DISTORT_DMA_UIWR_WIDTH_MASK 0xffff
#define  DISTORT_DMA_UIWR_WIDTH_SHIFT 0
#define  DISTORT_DMA_UIWR_WIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UIWR_WIDTH_MASK) >> DISTORT_DMA_UIWR_WIDTH_SHIFT)
#define  DISTORT_DMA_UIWR_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UIWR_WIDTH_MASK) | (((uint32_t)val) << DISTORT_DMA_UIWR_WIDTH_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 0 (UTR0)
//====================================================================

#define  DISTORT_DMA_UTR0_RESERVED1_MASK 0xffff0000
#define  DISTORT_DMA_UTR0_RESERVED1_SHIFT 16
#define  DISTORT_DMA_UTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR0_RESERVED1_MASK) >> DISTORT_DMA_UTR0_RESERVED1_SHIFT)
#define  DISTORT_DMA_UTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR0_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR0_RESERVED1_SHIFT))

#define  DISTORT_DMA_UTR0_TAGCFG_MASK 0xffff
#define  DISTORT_DMA_UTR0_TAGCFG_SHIFT 0
#define  DISTORT_DMA_UTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR0_TAGCFG_MASK) >> DISTORT_DMA_UTR0_TAGCFG_SHIFT)
#define  DISTORT_DMA_UTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR0_TAGCFG_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR0_TAGCFG_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 1 (UTR1)
//====================================================================

#define  DISTORT_DMA_UTR1_RESERVED1_MASK 0xffff0000
#define  DISTORT_DMA_UTR1_RESERVED1_SHIFT 16
#define  DISTORT_DMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR1_RESERVED1_MASK) >> DISTORT_DMA_UTR1_RESERVED1_SHIFT)
#define  DISTORT_DMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR1_RESERVED1_SHIFT))

#define  DISTORT_DMA_UTR1_TAGMAJ_MASK 0xffff
#define  DISTORT_DMA_UTR1_TAGMAJ_SHIFT 0
#define  DISTORT_DMA_UTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR1_TAGMAJ_MASK) >> DISTORT_DMA_UTR1_TAGMAJ_SHIFT)
#define  DISTORT_DMA_UTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR1_TAGMAJ_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: DISTORT_DMA Tag Register 2 (UTR2)
//====================================================================

#define  DISTORT_DMA_UTR2_RESERVED1_MASK 0xffff0000
#define  DISTORT_DMA_UTR2_RESERVED1_SHIFT 16
#define  DISTORT_DMA_UTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR2_RESERVED1_MASK) >> DISTORT_DMA_UTR2_RESERVED1_SHIFT)
#define  DISTORT_DMA_UTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR2_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR2_RESERVED1_SHIFT))

#define  DISTORT_DMA_UTR2_TAGMID_MASK 0xffff
#define  DISTORT_DMA_UTR2_TAGMID_SHIFT 0
#define  DISTORT_DMA_UTR2_TAGMID_MASK_SHIFT(reg) (((reg) & DISTORT_DMA_UTR2_TAGMID_MASK) >> DISTORT_DMA_UTR2_TAGMID_SHIFT)
#define  DISTORT_DMA_UTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_DMA_UTR2_TAGMID_MASK) | (((uint32_t)val) << DISTORT_DMA_UTR2_TAGMID_SHIFT))

#endif // DISTORT_DMA
