 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DEPOGO_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DEPOGO_REGMASKS_H_
#define _DEPOGO_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Depogoizer Module (DEPOGO)
/** \brief (rev 0 . 6 . 3 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Depogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  DEPOGO_CFG_RESERVED1_MASK 0xfffff800
#define  DEPOGO_CFG_RESERVED1_SHIFT 11
#define  DEPOGO_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_RESERVED1_MASK) >> DEPOGO_CFG_RESERVED1_SHIFT)
#define  DEPOGO_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_RESERVED1_MASK) | (((uint32_t)val) << DEPOGO_CFG_RESERVED1_SHIFT))

#define  DEPOGO_CFG_MONOCHAN_MASK 0x700
#define  DEPOGO_CFG_MONOCHAN_SHIFT 8
#define  DEPOGO_CFG_MONOCHAN_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_MONOCHAN_MASK) >> DEPOGO_CFG_MONOCHAN_SHIFT)
#define  DEPOGO_CFG_MONOCHAN_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_MONOCHAN_MASK) | (((uint32_t)val) << DEPOGO_CFG_MONOCHAN_SHIFT))

#define  DEPOGO_CFG_PIXORDER_MASK 0x80
#define  DEPOGO_CFG_PIXORDER_SHIFT 7
#define  DEPOGO_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_PIXORDER_MASK) >> DEPOGO_CFG_PIXORDER_SHIFT)
#define  DEPOGO_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_PIXORDER_MASK) | (((uint32_t)val) << DEPOGO_CFG_PIXORDER_SHIFT))

#define  DEPOGO_CFG_BPP_MASK 0x70
#define  DEPOGO_CFG_BPP_SHIFT 4
#define  DEPOGO_CFG_BPP_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_BPP_MASK) >> DEPOGO_CFG_BPP_SHIFT)
#define  DEPOGO_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_BPP_MASK) | (((uint32_t)val) << DEPOGO_CFG_BPP_SHIFT))

#define  DEPOGO_CFG_COLORSWAP_MASK 0x8
#define  DEPOGO_CFG_COLORSWAP_SHIFT 3
#define  DEPOGO_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_COLORSWAP_MASK) >> DEPOGO_CFG_COLORSWAP_SHIFT)
#define  DEPOGO_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_COLORSWAP_MASK) | (((uint32_t)val) << DEPOGO_CFG_COLORSWAP_SHIFT))

#define  DEPOGO_CFG_FMT_MASK 0x7
#define  DEPOGO_CFG_FMT_SHIFT 0
#define  DEPOGO_CFG_FMT_MASK_SHIFT(reg) (((reg) & DEPOGO_CFG_FMT_MASK) >> DEPOGO_CFG_FMT_SHIFT)
#define  DEPOGO_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_CFG_FMT_MASK) | (((uint32_t)val) << DEPOGO_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DEPOGO_REV0_MAJ_MASK 0xffff0000
#define  DEPOGO_REV0_MAJ_SHIFT 16
#define  DEPOGO_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DEPOGO_REV0_MAJ_MASK) >> DEPOGO_REV0_MAJ_SHIFT)
#define  DEPOGO_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_REV0_MAJ_MASK) | (((uint32_t)val) << DEPOGO_REV0_MAJ_SHIFT))

#define  DEPOGO_REV0_MID_MASK 0xffff
#define  DEPOGO_REV0_MID_SHIFT 0
#define  DEPOGO_REV0_MID_MASK_SHIFT(reg) (((reg) & DEPOGO_REV0_MID_MASK) >> DEPOGO_REV0_MID_SHIFT)
#define  DEPOGO_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_REV0_MID_MASK) | (((uint32_t)val) << DEPOGO_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DEPOGO_REV1_RESERVED1_MASK 0xffff0000
#define  DEPOGO_REV1_RESERVED1_SHIFT 16
#define  DEPOGO_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DEPOGO_REV1_RESERVED1_MASK) >> DEPOGO_REV1_RESERVED1_SHIFT)
#define  DEPOGO_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_REV1_RESERVED1_MASK) | (((uint32_t)val) << DEPOGO_REV1_RESERVED1_SHIFT))

#define  DEPOGO_REV1_CFG_MASK 0xffff
#define  DEPOGO_REV1_CFG_SHIFT 0
#define  DEPOGO_REV1_CFG_MASK_SHIFT(reg) (((reg) & DEPOGO_REV1_CFG_MASK) >> DEPOGO_REV1_CFG_SHIFT)
#define  DEPOGO_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DEPOGO_REV1_CFG_MASK) | (((uint32_t)val) << DEPOGO_REV1_CFG_SHIFT))

#endif // DEPOGO
