 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DENOISE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DENOISE_REGMASKS_H_
#define _DENOISE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: DENOISE_LNAME (DENOISE)
/** \brief (rev 0 . 0 . 1 . 5)
    Top-level register file for the DENOISE block*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DENOISE_REV0_MAJ_MASK 0xffff0000
#define  DENOISE_REV0_MAJ_SHIFT 16
#define  DENOISE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DENOISE_REV0_MAJ_MASK) >> DENOISE_REV0_MAJ_SHIFT)
#define  DENOISE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV0_MAJ_MASK) | (((uint32_t)val) << DENOISE_REV0_MAJ_SHIFT))

#define  DENOISE_REV0_MID_MASK 0xffff
#define  DENOISE_REV0_MID_SHIFT 0
#define  DENOISE_REV0_MID_MASK_SHIFT(reg) (((reg) & DENOISE_REV0_MID_MASK) >> DENOISE_REV0_MID_SHIFT)
#define  DENOISE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV0_MID_MASK) | (((uint32_t)val) << DENOISE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DENOISE_REV1_RESERVED1_MASK 0xffff0000
#define  DENOISE_REV1_RESERVED1_SHIFT 16
#define  DENOISE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DENOISE_REV1_RESERVED1_MASK) >> DENOISE_REV1_RESERVED1_SHIFT)
#define  DENOISE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV1_RESERVED1_MASK) | (((uint32_t)val) << DENOISE_REV1_RESERVED1_SHIFT))

#define  DENOISE_REV1_CFG_MASK 0xffff
#define  DENOISE_REV1_CFG_SHIFT 0
#define  DENOISE_REV1_CFG_MASK_SHIFT(reg) (((reg) & DENOISE_REV1_CFG_MASK) >> DENOISE_REV1_CFG_SHIFT)
#define  DENOISE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV1_CFG_MASK) | (((uint32_t)val) << DENOISE_REV1_CFG_SHIFT))

//====================================================================
//Register: Configuration Register (CFG)
/** \brief Configuration Register for Denoise block.*/
//====================================================================

#define  DENOISE_CFG_CRTHRESH_MASK 0xff000000
#define  DENOISE_CFG_CRTHRESH_SHIFT 24
#define  DENOISE_CFG_CRTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_CRTHRESH_MASK) >> DENOISE_CFG_CRTHRESH_SHIFT)
#define  DENOISE_CFG_CRTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_CRTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_CRTHRESH_SHIFT))

#define  DENOISE_CFG_CBTHRESH_MASK 0xff0000
#define  DENOISE_CFG_CBTHRESH_SHIFT 16
#define  DENOISE_CFG_CBTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_CBTHRESH_MASK) >> DENOISE_CFG_CBTHRESH_SHIFT)
#define  DENOISE_CFG_CBTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_CBTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_CBTHRESH_SHIFT))

#define  DENOISE_CFG_YTHRESH_MASK 0xff00
#define  DENOISE_CFG_YTHRESH_SHIFT 8
#define  DENOISE_CFG_YTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_YTHRESH_MASK) >> DENOISE_CFG_YTHRESH_SHIFT)
#define  DENOISE_CFG_YTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_YTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_YTHRESH_SHIFT))

#define  DENOISE_CFG_RESERVED1_MASK 0x80
#define  DENOISE_CFG_RESERVED1_SHIFT 7
#define  DENOISE_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_RESERVED1_MASK) >> DENOISE_CFG_RESERVED1_SHIFT)
#define  DENOISE_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_RESERVED1_MASK) | (((uint32_t)val) << DENOISE_CFG_RESERVED1_SHIFT))

#define  DENOISE_CFG_KEEP_MASK 0x70
#define  DENOISE_CFG_KEEP_SHIFT 4
#define  DENOISE_CFG_KEEP_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_KEEP_MASK) >> DENOISE_CFG_KEEP_SHIFT)
#define  DENOISE_CFG_KEEP_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_KEEP_MASK) | (((uint32_t)val) << DENOISE_CFG_KEEP_SHIFT))

#define  DENOISE_CFG_RESERVED2_MASK 0xe
#define  DENOISE_CFG_RESERVED2_SHIFT 1
#define  DENOISE_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_RESERVED2_MASK) >> DENOISE_CFG_RESERVED2_SHIFT)
#define  DENOISE_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_RESERVED2_MASK) | (((uint32_t)val) << DENOISE_CFG_RESERVED2_SHIFT))

#define  DENOISE_CFG_BYPASS_MASK 0x1
#define  DENOISE_CFG_BYPASS_SHIFT 0
#define  DENOISE_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_BYPASS_MASK) >> DENOISE_CFG_BYPASS_SHIFT)
#define  DENOISE_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_BYPASS_MASK) | (((uint32_t)val) << DENOISE_CFG_BYPASS_SHIFT))

#endif // DENOISE
