 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DEC_CONFIG_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DEC_CONFIG_REGS_REGMASKS_H_
#define _DEC_CONFIG_REGS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: dec_config_regs (dec_config_regs)
//
//====================================================================

//====================================================================
//Register: Top Synchronization register (Instance 1 of 4) (top_sync0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_MASK) >> DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC0_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC0_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_TOP_SYNC0_E_SHIFT 20
#define  DEC_CONFIG_REGS_TOP_SYNC0_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC0_E_MASK) >> DEC_CONFIG_REGS_TOP_SYNC0_E_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC0_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC0_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC0_E_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_MASK) >> DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC0_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC0_C_MASK 0x70000
#define  DEC_CONFIG_REGS_TOP_SYNC0_C_SHIFT 16
#define  DEC_CONFIG_REGS_TOP_SYNC0_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC0_C_MASK) >> DEC_CONFIG_REGS_TOP_SYNC0_C_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC0_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC0_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC0_C_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC0_S_MASK 0xffff
#define  DEC_CONFIG_REGS_TOP_SYNC0_S_SHIFT 0
#define  DEC_CONFIG_REGS_TOP_SYNC0_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC0_S_MASK) >> DEC_CONFIG_REGS_TOP_SYNC0_S_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC0_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC0_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC0_S_SHIFT))

//====================================================================
//Register: Top Synchronization register (Instance 2 of 4) (top_sync1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_MASK) >> DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC1_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC1_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_TOP_SYNC1_E_SHIFT 20
#define  DEC_CONFIG_REGS_TOP_SYNC1_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC1_E_MASK) >> DEC_CONFIG_REGS_TOP_SYNC1_E_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC1_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC1_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC1_E_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_MASK) >> DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC1_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC1_C_MASK 0x70000
#define  DEC_CONFIG_REGS_TOP_SYNC1_C_SHIFT 16
#define  DEC_CONFIG_REGS_TOP_SYNC1_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC1_C_MASK) >> DEC_CONFIG_REGS_TOP_SYNC1_C_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC1_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC1_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC1_C_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC1_S_MASK 0xffff
#define  DEC_CONFIG_REGS_TOP_SYNC1_S_SHIFT 0
#define  DEC_CONFIG_REGS_TOP_SYNC1_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC1_S_MASK) >> DEC_CONFIG_REGS_TOP_SYNC1_S_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC1_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC1_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC1_S_SHIFT))

//====================================================================
//Register: Top Synchronization register (Instance 3 of 4) (top_sync2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_MASK) >> DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC2_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC2_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_TOP_SYNC2_E_SHIFT 20
#define  DEC_CONFIG_REGS_TOP_SYNC2_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC2_E_MASK) >> DEC_CONFIG_REGS_TOP_SYNC2_E_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC2_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC2_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC2_E_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_MASK) >> DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC2_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC2_C_MASK 0x70000
#define  DEC_CONFIG_REGS_TOP_SYNC2_C_SHIFT 16
#define  DEC_CONFIG_REGS_TOP_SYNC2_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC2_C_MASK) >> DEC_CONFIG_REGS_TOP_SYNC2_C_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC2_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC2_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC2_C_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC2_S_MASK 0xffff
#define  DEC_CONFIG_REGS_TOP_SYNC2_S_SHIFT 0
#define  DEC_CONFIG_REGS_TOP_SYNC2_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC2_S_MASK) >> DEC_CONFIG_REGS_TOP_SYNC2_S_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC2_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC2_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC2_S_SHIFT))

//====================================================================
//Register: Top Synchronization register (Instance 4 of 4) (top_sync3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_MASK) >> DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC3_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC3_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_TOP_SYNC3_E_SHIFT 20
#define  DEC_CONFIG_REGS_TOP_SYNC3_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC3_E_MASK) >> DEC_CONFIG_REGS_TOP_SYNC3_E_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC3_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC3_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC3_E_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_MASK) >> DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC3_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC3_C_MASK 0x70000
#define  DEC_CONFIG_REGS_TOP_SYNC3_C_SHIFT 16
#define  DEC_CONFIG_REGS_TOP_SYNC3_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC3_C_MASK) >> DEC_CONFIG_REGS_TOP_SYNC3_C_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC3_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC3_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC3_C_SHIFT))

#define  DEC_CONFIG_REGS_TOP_SYNC3_S_MASK 0xffff
#define  DEC_CONFIG_REGS_TOP_SYNC3_S_SHIFT 0
#define  DEC_CONFIG_REGS_TOP_SYNC3_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_TOP_SYNC3_S_MASK) >> DEC_CONFIG_REGS_TOP_SYNC3_S_SHIFT)
#define  DEC_CONFIG_REGS_TOP_SYNC3_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_TOP_SYNC3_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_TOP_SYNC3_S_SHIFT))

//====================================================================
//Register: Bottom Synchronization register (Instance 1 of 4) (bottom_sync0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_E_SHIFT 20
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC0_E_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC0_E_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC0_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC0_E_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC0_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_C_MASK 0x70000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_C_SHIFT 16
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC0_C_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC0_C_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC0_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC0_C_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_S_MASK 0xffff
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_S_SHIFT 0
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC0_S_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC0_S_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC0_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC0_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC0_S_SHIFT))

//====================================================================
//Register: Bottom Synchronization register (Instance 2 of 4) (bottom_sync1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_E_SHIFT 20
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC1_E_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC1_E_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC1_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC1_E_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC1_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_C_MASK 0x70000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_C_SHIFT 16
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC1_C_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC1_C_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC1_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC1_C_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_S_MASK 0xffff
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_S_SHIFT 0
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC1_S_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC1_S_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC1_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC1_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC1_S_SHIFT))

//====================================================================
//Register: Bottom Synchronization register (Instance 3 of 4) (bottom_sync2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_E_SHIFT 20
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC2_E_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC2_E_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC2_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC2_E_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC2_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_C_MASK 0x70000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_C_SHIFT 16
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC2_C_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC2_C_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC2_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC2_C_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_S_MASK 0xffff
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_S_SHIFT 0
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC2_S_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC2_S_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC2_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC2_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC2_S_SHIFT))

//====================================================================
//Register: Bottom Synchronization register (Instance 4 of 4) (bottom_sync3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_MASK 0xff000000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_SHIFT 24
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_E_MASK 0xf00000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_E_SHIFT 20
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_E_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC3_E_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC3_E_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_E_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC3_E_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC3_E_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_MASK 0x80000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_SHIFT 19
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC3_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_C_MASK 0x70000
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_C_SHIFT 16
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_C_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC3_C_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC3_C_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_C_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC3_C_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC3_C_SHIFT))

#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_S_MASK 0xffff
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_S_SHIFT 0
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_S_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_BOTTOM_SYNC3_S_MASK) >> DEC_CONFIG_REGS_BOTTOM_SYNC3_S_SHIFT)
#define  DEC_CONFIG_REGS_BOTTOM_SYNC3_S_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_BOTTOM_SYNC3_S_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_BOTTOM_SYNC3_S_SHIFT))

//====================================================================
//Register: Manual Top/Bottom Synchronization register (man_tb_sync)
//====================================================================

#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_MASK 0xfff00000
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_SHIFT 20
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_MASK) >> DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_MASK 0xf0000
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_SHIFT 16
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_MASK) >> DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_SHIFT)
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MAN_TB_SYNC_BOT_SHIFT))

#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_MASK 0xfff0
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_SHIFT 4
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_MASK) >> DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MAN_TB_SYNC_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_MASK 0xf
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_SHIFT 0
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_MASK) >> DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_SHIFT)
#define  DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MAN_TB_SYNC_TOP_SHIFT))

//====================================================================
//Register: Miscellaneous Output Enable register (oe_misc)
//====================================================================

#define  DEC_CONFIG_REGS_OE_MISC_RESERVED1_MASK 0xfff00000
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED1_SHIFT 20
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_OE_MISC_RESERVED1_MASK) >> DEC_CONFIG_REGS_OE_MISC_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_OE_MISC_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_OE_MISC_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_OE_MISC_DAC_OE_MASK 0xf0000
#define  DEC_CONFIG_REGS_OE_MISC_DAC_OE_SHIFT 16
#define  DEC_CONFIG_REGS_OE_MISC_DAC_OE_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_OE_MISC_DAC_OE_MASK) >> DEC_CONFIG_REGS_OE_MISC_DAC_OE_SHIFT)
#define  DEC_CONFIG_REGS_OE_MISC_DAC_OE_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_OE_MISC_DAC_OE_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_OE_MISC_DAC_OE_SHIFT))

#define  DEC_CONFIG_REGS_OE_MISC_RESERVED2_MASK 0xf000
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED2_SHIFT 12
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_OE_MISC_RESERVED2_MASK) >> DEC_CONFIG_REGS_OE_MISC_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_OE_MISC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_OE_MISC_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_OE_MISC_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_MASK 0xfff
#define  DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_SHIFT 0
#define  DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_MASK) >> DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_SHIFT)
#define  DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_OE_MISC_LD_CTRL_OE_SHIFT))

//====================================================================
//Register: Missing HSync Merge register (missing)
//====================================================================

#define  DEC_CONFIG_REGS_MISSING_RESERVED1_MASK 0xf0000000
#define  DEC_CONFIG_REGS_MISSING_RESERVED1_SHIFT 28
#define  DEC_CONFIG_REGS_MISSING_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_RESERVED1_MASK) >> DEC_CONFIG_REGS_MISSING_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_MERGE3_MASK 0xf000000
#define  DEC_CONFIG_REGS_MISSING_MERGE3_SHIFT 24
#define  DEC_CONFIG_REGS_MISSING_MERGE3_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_MERGE3_MASK) >> DEC_CONFIG_REGS_MISSING_MERGE3_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_MERGE3_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_MERGE3_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_MERGE3_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_RESERVED2_MASK 0xf00000
#define  DEC_CONFIG_REGS_MISSING_RESERVED2_SHIFT 20
#define  DEC_CONFIG_REGS_MISSING_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_RESERVED2_MASK) >> DEC_CONFIG_REGS_MISSING_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_MERGE2_MASK 0xf0000
#define  DEC_CONFIG_REGS_MISSING_MERGE2_SHIFT 16
#define  DEC_CONFIG_REGS_MISSING_MERGE2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_MERGE2_MASK) >> DEC_CONFIG_REGS_MISSING_MERGE2_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_MERGE2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_MERGE2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_MERGE2_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_RESERVED3_MASK 0xf000
#define  DEC_CONFIG_REGS_MISSING_RESERVED3_SHIFT 12
#define  DEC_CONFIG_REGS_MISSING_RESERVED3_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_RESERVED3_MASK) >> DEC_CONFIG_REGS_MISSING_RESERVED3_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_RESERVED3_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_RESERVED3_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_MERGE1_MASK 0xf00
#define  DEC_CONFIG_REGS_MISSING_MERGE1_SHIFT 8
#define  DEC_CONFIG_REGS_MISSING_MERGE1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_MERGE1_MASK) >> DEC_CONFIG_REGS_MISSING_MERGE1_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_MERGE1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_MERGE1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_MERGE1_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_RESERVED4_MASK 0xf0
#define  DEC_CONFIG_REGS_MISSING_RESERVED4_SHIFT 4
#define  DEC_CONFIG_REGS_MISSING_RESERVED4_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_RESERVED4_MASK) >> DEC_CONFIG_REGS_MISSING_RESERVED4_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_RESERVED4_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_RESERVED4_SHIFT))

#define  DEC_CONFIG_REGS_MISSING_MERGE0_MASK 0xf
#define  DEC_CONFIG_REGS_MISSING_MERGE0_SHIFT 0
#define  DEC_CONFIG_REGS_MISSING_MERGE0_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_MISSING_MERGE0_MASK) >> DEC_CONFIG_REGS_MISSING_MERGE0_SHIFT)
#define  DEC_CONFIG_REGS_MISSING_MERGE0_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_MISSING_MERGE0_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_MISSING_MERGE0_SHIFT))

//====================================================================
//Register: HSync_missed Stretch register (stretch)
//====================================================================

#define  DEC_CONFIG_REGS_STRETCH_RESERVED1_MASK 0xfffffe00
#define  DEC_CONFIG_REGS_STRETCH_RESERVED1_SHIFT 9
#define  DEC_CONFIG_REGS_STRETCH_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_STRETCH_RESERVED1_MASK) >> DEC_CONFIG_REGS_STRETCH_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_STRETCH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_STRETCH_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_STRETCH_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_STRETCH_POL_MASK 0x100
#define  DEC_CONFIG_REGS_STRETCH_POL_SHIFT 8
#define  DEC_CONFIG_REGS_STRETCH_POL_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_STRETCH_POL_MASK) >> DEC_CONFIG_REGS_STRETCH_POL_SHIFT)
#define  DEC_CONFIG_REGS_STRETCH_POL_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_STRETCH_POL_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_STRETCH_POL_SHIFT))

#define  DEC_CONFIG_REGS_STRETCH_RESERVED2_MASK 0xe0
#define  DEC_CONFIG_REGS_STRETCH_RESERVED2_SHIFT 5
#define  DEC_CONFIG_REGS_STRETCH_RESERVED2_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_STRETCH_RESERVED2_MASK) >> DEC_CONFIG_REGS_STRETCH_RESERVED2_SHIFT)
#define  DEC_CONFIG_REGS_STRETCH_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_STRETCH_RESERVED2_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_STRETCH_RESERVED2_SHIFT))

#define  DEC_CONFIG_REGS_STRETCH_COUNT_MASK 0x1f
#define  DEC_CONFIG_REGS_STRETCH_COUNT_SHIFT 0
#define  DEC_CONFIG_REGS_STRETCH_COUNT_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_STRETCH_COUNT_MASK) >> DEC_CONFIG_REGS_STRETCH_COUNT_SHIFT)
#define  DEC_CONFIG_REGS_STRETCH_COUNT_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_STRETCH_COUNT_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_STRETCH_COUNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read hardware revision information.*/
//====================================================================

#define  DEC_CONFIG_REGS_REV0_MAJ_MASK 0xffff0000
#define  DEC_CONFIG_REGS_REV0_MAJ_SHIFT 16
#define  DEC_CONFIG_REGS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_REV0_MAJ_MASK) >> DEC_CONFIG_REGS_REV0_MAJ_SHIFT)
#define  DEC_CONFIG_REGS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_REV0_MAJ_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_REV0_MAJ_SHIFT))

#define  DEC_CONFIG_REGS_REV0_MID_MASK 0xffff
#define  DEC_CONFIG_REGS_REV0_MID_SHIFT 0
#define  DEC_CONFIG_REGS_REV0_MID_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_REV0_MID_MASK) >> DEC_CONFIG_REGS_REV0_MID_SHIFT)
#define  DEC_CONFIG_REGS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_REV0_MID_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read hardware revision information.*/
//====================================================================

#define  DEC_CONFIG_REGS_REV1_RESERVED1_MASK 0xffff0000
#define  DEC_CONFIG_REGS_REV1_RESERVED1_SHIFT 16
#define  DEC_CONFIG_REGS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_REV1_RESERVED1_MASK) >> DEC_CONFIG_REGS_REV1_RESERVED1_SHIFT)
#define  DEC_CONFIG_REGS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_REV1_RESERVED1_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_REV1_RESERVED1_SHIFT))

#define  DEC_CONFIG_REGS_REV1_CFG_MASK 0xffff
#define  DEC_CONFIG_REGS_REV1_CFG_SHIFT 0
#define  DEC_CONFIG_REGS_REV1_CFG_MASK_SHIFT(reg) (((reg) & DEC_CONFIG_REGS_REV1_CFG_MASK) >> DEC_CONFIG_REGS_REV1_CFG_SHIFT)
#define  DEC_CONFIG_REGS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DEC_CONFIG_REGS_REV1_CFG_MASK) | (((uint32_t)val) << DEC_CONFIG_REGS_REV1_CFG_SHIFT))

#endif // DEC_CONFIG_REGS
