 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file DECIM_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _DECIM_REGMASKS_H_
#define _DECIM_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Decimate (DECIM)
/** \brief Top-level register file for the Decimate block <br/> (rev 0 . 1 . 0 . 3)*/
//
//====================================================================

//====================================================================
//Register: Divisor Register (div)
/** \brief This register sets the horizontal and vertical decimation factors. The programmed value should be one less than the desired divisor. For example, when the horizontal period register is set to 2, every third pixel will be output (0, 3, 6, etc.), and the resulting line will be one-third as wide as the input. The division is truncating, for example a 64-pixel wide line divided by 3 will output a 21-pixel wide line. The first input pixel and line will always be output. A setting of 0 will pass all pixels.*/
//====================================================================

#define  DECIM_DIV_RESERVED1_MASK 0xfffff800
#define  DECIM_DIV_RESERVED1_SHIFT 11
#define  DECIM_DIV_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_DIV_RESERVED1_MASK) >> DECIM_DIV_RESERVED1_SHIFT)
#define  DECIM_DIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_RESERVED1_MASK) | (((uint32_t)val) << DECIM_DIV_RESERVED1_SHIFT))

#define  DECIM_DIV_DIV_X_MASK 0x700
#define  DECIM_DIV_DIV_X_SHIFT 8
#define  DECIM_DIV_DIV_X_MASK_SHIFT(reg) (((reg) & DECIM_DIV_DIV_X_MASK) >> DECIM_DIV_DIV_X_SHIFT)
#define  DECIM_DIV_DIV_X_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_DIV_X_MASK) | (((uint32_t)val) << DECIM_DIV_DIV_X_SHIFT))

#define  DECIM_DIV_RESERVED2_MASK 0xf8
#define  DECIM_DIV_RESERVED2_SHIFT 3
#define  DECIM_DIV_RESERVED2_MASK_SHIFT(reg) (((reg) & DECIM_DIV_RESERVED2_MASK) >> DECIM_DIV_RESERVED2_SHIFT)
#define  DECIM_DIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_RESERVED2_MASK) | (((uint32_t)val) << DECIM_DIV_RESERVED2_SHIFT))

#define  DECIM_DIV_DIV_Y_MASK 0x7
#define  DECIM_DIV_DIV_Y_SHIFT 0
#define  DECIM_DIV_DIV_Y_MASK_SHIFT(reg) (((reg) & DECIM_DIV_DIV_Y_MASK) >> DECIM_DIV_DIV_Y_SHIFT)
#define  DECIM_DIV_DIV_Y_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_DIV_Y_MASK) | (((uint32_t)val) << DECIM_DIV_DIV_Y_SHIFT))

//====================================================================
//Register: Vertical Start Register (start)
/** \brief Normally, the first line of an image is a sampled line. However, if a strip has a height that is not a multiple of the vertical divisor, the first line of the next strip should not be sampled. This register sets the number of the line in the strip which will be the first sampled. When a strip is completed, this register will be automatically updated to have the correct starting line for the next strip, assuming that the divisors are not changed. At the start of an image, this register should be set to 0. This register should always be set to a value less than or equal to the vertical divisor register.*/
//====================================================================

#define  DECIM_START_RESERVED1_MASK 0xfffffff8
#define  DECIM_START_RESERVED1_SHIFT 3
#define  DECIM_START_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_START_RESERVED1_MASK) >> DECIM_START_RESERVED1_SHIFT)
#define  DECIM_START_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_START_RESERVED1_MASK) | (((uint32_t)val) << DECIM_START_RESERVED1_SHIFT))

#define  DECIM_START_Y_START_POS_MASK 0x7
#define  DECIM_START_Y_START_POS_SHIFT 0
#define  DECIM_START_Y_START_POS_MASK_SHIFT(reg) (((reg) & DECIM_START_Y_START_POS_MASK) >> DECIM_START_Y_START_POS_SHIFT)
#define  DECIM_START_Y_START_POS_REPLACE_VAL(reg,val) (((reg) & ~DECIM_START_Y_START_POS_MASK) | (((uint32_t)val) << DECIM_START_Y_START_POS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DECIM_REV0_MAJ_MASK 0xffff0000
#define  DECIM_REV0_MAJ_SHIFT 16
#define  DECIM_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DECIM_REV0_MAJ_MASK) >> DECIM_REV0_MAJ_SHIFT)
#define  DECIM_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV0_MAJ_MASK) | (((uint32_t)val) << DECIM_REV0_MAJ_SHIFT))

#define  DECIM_REV0_MID_MASK 0xffff
#define  DECIM_REV0_MID_SHIFT 0
#define  DECIM_REV0_MID_MASK_SHIFT(reg) (((reg) & DECIM_REV0_MID_MASK) >> DECIM_REV0_MID_SHIFT)
#define  DECIM_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV0_MID_MASK) | (((uint32_t)val) << DECIM_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DECIM_REV1_RESERVED1_MASK 0xffff0000
#define  DECIM_REV1_RESERVED1_SHIFT 16
#define  DECIM_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_REV1_RESERVED1_MASK) >> DECIM_REV1_RESERVED1_SHIFT)
#define  DECIM_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV1_RESERVED1_MASK) | (((uint32_t)val) << DECIM_REV1_RESERVED1_SHIFT))

#define  DECIM_REV1_CFG_MASK 0xffff
#define  DECIM_REV1_CFG_SHIFT 0
#define  DECIM_REV1_CFG_MASK_SHIFT(reg) (((reg) & DECIM_REV1_CFG_MASK) >> DECIM_REV1_CFG_SHIFT)
#define  DECIM_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV1_CFG_MASK) | (((uint32_t)val) << DECIM_REV1_CFG_SHIFT))

#endif // DECIM
