 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CTWIN_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CTWIN_REGSTRUCTS_H_
#define _CTWIN_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CTWIN (CTWIN)
/** \brief Registers for the Contone Window module <br/> (rev 0 . 0 . 1 . 5)*/
//
//====================================================================

typedef struct CTWIN_REGS_s
{
  volatile uint32_t CCR;  ///< 0x0 [R/W]: CTWin Configuration Register
  volatile uint32_t W1CR;  ///< 0x4 [R/W]: Window 1 Configuration Register
  volatile uint32_t W2CR;  ///< 0x8 [R/W]: Window 2 Configuration Register
  volatile uint32_t OCR;  ///< 0xc [R/W]: Output Control Register
  volatile uint32_t OVR1;  ///< 0x10 [R/W]: Output Value Register 1
  volatile uint32_t OVR2;  ///< 0x14 [R/W]: Output Value Register 2
  volatile uint32_t KMR1;  ///< 0x18 [R/W]: Kt Merge Value Register 1
  volatile uint32_t KMR2;  ///< 0x1c [R/W]: Kt Merge Value Register 2
  volatile uint32_t W1TH0R1;  ///< 0x20 [R/W]: Window 1 Threshold_0 Register 1
  volatile uint32_t W1TH0R2;  ///< 0x24 [R/W]: Window 1 Threshold_0 Register 2
  volatile uint32_t W1TH1R1;  ///< 0x28 [R/W]: Window 1 Threshold_1 Register 1
  volatile uint32_t W1TH1R2;  ///< 0x2c [R/W]: Window 1 Threshold_1 Register 2
  volatile uint32_t W1TH2R1;  ///< 0x30 [R/W]: Window 1 Threshold_2 Register 1
  volatile uint32_t W1TH2R2;  ///< 0x34 [R/W]: Window 1 Threshold_2 Register 2
  volatile uint32_t W2TH0R1;  ///< 0x38 [R/W]: Window 2 Threshold_0 Register 1
  volatile uint32_t W2TH0R2;  ///< 0x3c [R/W]: Window 2 Threshold_0 Register 2
  volatile uint32_t W2TH1R1;  ///< 0x40 [R/W]: Window 2 Threshold_1 Register 1
  volatile uint32_t W2TH1R2;  ///< 0x44 [R/W]: Window 2 Threshold_1 Register 2
  volatile uint32_t W2TH2R1;  ///< 0x48 [R/W]: Window 2 Threshold_2 Register 1
  volatile uint32_t W2TH2R2;  ///< 0x4c [R/W]: Window 2 Threshold_2 Register 2
  volatile uint32_t ESCR1;  ///< 0x50 [R/W]: Edge Scale Register 1
  volatile uint32_t ESCR2;  ///< 0x54 [R/W]: Edge Scale Register 2
  volatile uint32_t ESCR3;  ///< 0x58 [R/W]: Edge Scale Register 3
  volatile uint32_t ESCR4;  ///< 0x5c [R/W]: Edge Scale Register 4
  volatile uint32_t ESCR5;  ///< 0x60 [R/W]: Edge Scale Register 5
  volatile uint32_t ESCR6;  ///< 0x64 [R/W]: Edge Scale Register 6
  volatile uint32_t ETHR1;  ///< 0x68 [R/W]: Edge Threshold Register 1
  volatile uint32_t ETHR2;  ///< 0x6c [R/W]: Edge Threshold Register 2
  volatile uint32_t ETHR3;  ///< 0x70 [R/W]: Edge Threshold Register 3
  volatile uint32_t ETHR4;  ///< 0x74 [R/W]: Edge Threshold Register 4
  volatile uint32_t ETHR5;  ///< 0x78 [R/W]: Edge Threshold Register 5
  volatile uint32_t ETHR6;  ///< 0x7c [R/W]: Edge Threshold Register 6
  volatile uint32_t P0R0;  ///< 0x80 [R/W]: CTWIN Pattern 0 Register 0
  volatile uint32_t P0R1;  ///< 0x84 [R/W]: CTWIN Pattern 0 Register 1
  volatile uint32_t P0R2;  ///< 0x88 [R/W]: CTWIN Pattern 0 Register 2
  volatile uint32_t P0R3;  ///< 0x8c [R/W]: CTWIN Pattern 0 Register 3
  volatile uint32_t P1R0;  ///< 0x90 [R/W]: CTWIN Pattern 1 Register 0
  volatile uint32_t P1R1;  ///< 0x94 [R/W]: CTWIN Pattern 1 Register 1
  volatile uint32_t P1R2;  ///< 0x98 [R/W]: CTWIN Pattern 1 Register 2
  volatile uint32_t P1R3;  ///< 0x9c [R/W]: CTWIN Pattern 1 Register 3
  volatile uint32_t P2R0;  ///< 0xa0 [R/W]: CTWIN Pattern 2 Register 0
  volatile uint32_t P2R1;  ///< 0xa4 [R/W]: CTWIN Pattern 2 Register 1
  volatile uint32_t P2R2;  ///< 0xa8 [R/W]: CTWIN Pattern 2 Register 2
  volatile uint32_t P2R3;  ///< 0xac [R/W]: CTWIN Pattern 2 Register 3
  volatile uint32_t P3R0;  ///< 0xb0 [R/W]: CTWIN Pattern 3 Register 0
  volatile uint32_t P3R1;  ///< 0xb4 [R/W]: CTWIN Pattern 3 Register 1
  volatile uint32_t P3R2;  ///< 0xb8 [R/W]: CTWIN Pattern 3 Register 2
  volatile uint32_t P3R3;  ///< 0xbc [R/W]: CTWIN Pattern 3 Register 3
  volatile uint32_t CBAR;  ///< 0xc0 [R/W]: CTWIN LineBuffer Access Control Register
  volatile uint32_t CBAWR;  ///< 0xc4 [W]: CTWIN LineBuffer Address Write Register
  volatile uint32_t CBSAR;  ///< 0xc8 [R]: CTWIN LineBuffer Address Status Register
  volatile uint32_t CBD0WR;  ///< 0xcc [W]: CTWIN LineBuffer Data0 Write Register
  volatile uint32_t CBD1WR;  ///< 0xd0 [W]: CTWIN LineBuffer Data1 Write Register
  volatile uint32_t CBD2WR;  ///< 0xd4 [W]: CTWIN LineBuffer Data2 Write Register
  volatile uint32_t CBD3WR;  ///< 0xd8 [W]: CTWIN LineBuffer Data3 Write Register
  volatile uint32_t CBD4WR;  ///< 0xdc [W]: CTWIN LineBuffer Data4 Write Register
  volatile uint32_t CBD5WR;  ///< 0xe0 [W]: CTWIN LineBuffer Data5 Write Register
  volatile uint32_t CBD6WR;  ///< 0xe4 [W]: CTWIN LineBuffer Data6 Write Register
  volatile uint32_t CBD0RR;  ///< 0xe8 [R]: CTWIN LineBuffer Data0 Read Register
  volatile uint32_t CBD1RR;  ///< 0xec [R]: CTWIN LineBuffer Data1 Read Register
  volatile uint32_t CBD2RR;  ///< 0xf0 [R]: CTWIN LineBuffer Data2 Read Register
  volatile uint32_t CBD3RR;  ///< 0xf4 [R]: CTWIN LineBuffer Data3 Read Register
  volatile uint32_t CBD4RR;  ///< 0xf8 [R]: CTWIN LineBuffer Data4 Read Register
  volatile uint32_t CBD5RR;  ///< 0xfc [R]: CTWIN LineBuffer Data5 Read Register
  volatile uint32_t CBD6RR;  ///< 0x100 [R]: CTWIN LineBuffer Data6 Read Register
  volatile uint32_t CSRR;  ///< 0x104 [R]: CTWIN Save Restore Read Register
  volatile uint32_t CSRW;  ///< 0x108 [W]: CTWIN Save Restore Write Register
  volatile uint32_t REV0;  ///< 0x10c [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x110 [R]: IP Tagging Revision 1
} CTWIN_REGS_t;

#endif // CTWIN
