 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CTWIN_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CTWIN_REGMASKS_H_
#define _CTWIN_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CTWIN (CTWIN)
/** \brief Registers for the Contone Window module <br/> (rev 0 . 0 . 1 . 5)*/
//
//====================================================================

//====================================================================
//Register: CTWin Configuration Register (CCR)
//====================================================================

#define  CTWIN_CCR_LINE_WIDTH_MASK 0xffff0000
#define  CTWIN_CCR_LINE_WIDTH_SHIFT 16
#define  CTWIN_CCR_LINE_WIDTH_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_LINE_WIDTH_MASK) >> CTWIN_CCR_LINE_WIDTH_SHIFT)
#define  CTWIN_CCR_LINE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_LINE_WIDTH_MASK) | (((uint32_t)val) << CTWIN_CCR_LINE_WIDTH_SHIFT))

#define  CTWIN_CCR_RESERVED1_MASK 0xff80
#define  CTWIN_CCR_RESERVED1_SHIFT 7
#define  CTWIN_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_RESERVED1_MASK) >> CTWIN_CCR_RESERVED1_SHIFT)
#define  CTWIN_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CCR_RESERVED1_SHIFT))

#define  CTWIN_CCR_KT_MERGE_FUNC_MASK 0x40
#define  CTWIN_CCR_KT_MERGE_FUNC_SHIFT 6
#define  CTWIN_CCR_KT_MERGE_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_KT_MERGE_FUNC_MASK) >> CTWIN_CCR_KT_MERGE_FUNC_SHIFT)
#define  CTWIN_CCR_KT_MERGE_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_KT_MERGE_FUNC_MASK) | (((uint32_t)val) << CTWIN_CCR_KT_MERGE_FUNC_SHIFT))

#define  CTWIN_CCR_TEXT_MODE_MASK 0x30
#define  CTWIN_CCR_TEXT_MODE_SHIFT 4
#define  CTWIN_CCR_TEXT_MODE_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_TEXT_MODE_MASK) >> CTWIN_CCR_TEXT_MODE_SHIFT)
#define  CTWIN_CCR_TEXT_MODE_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_TEXT_MODE_MASK) | (((uint32_t)val) << CTWIN_CCR_TEXT_MODE_SHIFT))

#define  CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_MASK 0x8
#define  CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_SHIFT 3
#define  CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_MASK) >> CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_SHIFT)
#define  CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_MASK) | (((uint32_t)val) << CTWIN_CCR_LB_SRAM_ACCESS_ENABLE_SHIFT))

#define  CTWIN_CCR_SAVE_RESTORE_MODE_MASK 0x4
#define  CTWIN_CCR_SAVE_RESTORE_MODE_SHIFT 2
#define  CTWIN_CCR_SAVE_RESTORE_MODE_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_SAVE_RESTORE_MODE_MASK) >> CTWIN_CCR_SAVE_RESTORE_MODE_SHIFT)
#define  CTWIN_CCR_SAVE_RESTORE_MODE_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_SAVE_RESTORE_MODE_MASK) | (((uint32_t)val) << CTWIN_CCR_SAVE_RESTORE_MODE_SHIFT))

#define  CTWIN_CCR_SERP_MASK 0x2
#define  CTWIN_CCR_SERP_SHIFT 1
#define  CTWIN_CCR_SERP_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_SERP_MASK) >> CTWIN_CCR_SERP_SHIFT)
#define  CTWIN_CCR_SERP_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_SERP_MASK) | (((uint32_t)val) << CTWIN_CCR_SERP_SHIFT))

#define  CTWIN_CCR_BYPASS_MASK 0x1
#define  CTWIN_CCR_BYPASS_SHIFT 0
#define  CTWIN_CCR_BYPASS_MASK_SHIFT(reg) (((reg) & CTWIN_CCR_BYPASS_MASK) >> CTWIN_CCR_BYPASS_SHIFT)
#define  CTWIN_CCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CCR_BYPASS_MASK) | (((uint32_t)val) << CTWIN_CCR_BYPASS_SHIFT))

//====================================================================
//Register: Window 1 Configuration Register (W1CR)
/** \brief Configures window 1*/
//====================================================================

#define  CTWIN_W1CR_RESERVED1_MASK 0xf0000000
#define  CTWIN_W1CR_RESERVED1_SHIFT 28
#define  CTWIN_W1CR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_RESERVED1_MASK) >> CTWIN_W1CR_RESERVED1_SHIFT)
#define  CTWIN_W1CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1CR_RESERVED1_SHIFT))

#define  CTWIN_W1CR_WIN1_PAT_SEL_MASK 0xf000000
#define  CTWIN_W1CR_WIN1_PAT_SEL_SHIFT 24
#define  CTWIN_W1CR_WIN1_PAT_SEL_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_PAT_SEL_MASK) >> CTWIN_W1CR_WIN1_PAT_SEL_SHIFT)
#define  CTWIN_W1CR_WIN1_PAT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_PAT_SEL_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_PAT_SEL_SHIFT))

#define  CTWIN_W1CR_WIN1_PAT_INV_MASK 0xf00000
#define  CTWIN_W1CR_WIN1_PAT_INV_SHIFT 20
#define  CTWIN_W1CR_WIN1_PAT_INV_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_PAT_INV_MASK) >> CTWIN_W1CR_WIN1_PAT_INV_SHIFT)
#define  CTWIN_W1CR_WIN1_PAT_INV_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_PAT_INV_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_PAT_INV_SHIFT))

#define  CTWIN_W1CR_RESERVED2_MASK 0xc0000
#define  CTWIN_W1CR_RESERVED2_SHIFT 18
#define  CTWIN_W1CR_RESERVED2_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_RESERVED2_MASK) >> CTWIN_W1CR_RESERVED2_SHIFT)
#define  CTWIN_W1CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_RESERVED2_MASK) | (((uint32_t)val) << CTWIN_W1CR_RESERVED2_SHIFT))

#define  CTWIN_W1CR_WIN1_PAT_FUNC_MASK 0x20000
#define  CTWIN_W1CR_WIN1_PAT_FUNC_SHIFT 17
#define  CTWIN_W1CR_WIN1_PAT_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_PAT_FUNC_MASK) >> CTWIN_W1CR_WIN1_PAT_FUNC_SHIFT)
#define  CTWIN_W1CR_WIN1_PAT_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_PAT_FUNC_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_PAT_FUNC_SHIFT))

#define  CTWIN_W1CR_WIN1_INPUT_FUNC_MASK 0x10000
#define  CTWIN_W1CR_WIN1_INPUT_FUNC_SHIFT 16
#define  CTWIN_W1CR_WIN1_INPUT_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_INPUT_FUNC_MASK) >> CTWIN_W1CR_WIN1_INPUT_FUNC_SHIFT)
#define  CTWIN_W1CR_WIN1_INPUT_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_INPUT_FUNC_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_INPUT_FUNC_SHIFT))

#define  CTWIN_W1CR_RESERVED3_MASK 0xc000
#define  CTWIN_W1CR_RESERVED3_SHIFT 14
#define  CTWIN_W1CR_RESERVED3_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_RESERVED3_MASK) >> CTWIN_W1CR_RESERVED3_SHIFT)
#define  CTWIN_W1CR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_RESERVED3_MASK) | (((uint32_t)val) << CTWIN_W1CR_RESERVED3_SHIFT))

#define  CTWIN_W1CR_WIN1_INPUT_INV_MASK 0x3f00
#define  CTWIN_W1CR_WIN1_INPUT_INV_SHIFT 8
#define  CTWIN_W1CR_WIN1_INPUT_INV_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_INPUT_INV_MASK) >> CTWIN_W1CR_WIN1_INPUT_INV_SHIFT)
#define  CTWIN_W1CR_WIN1_INPUT_INV_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_INPUT_INV_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_INPUT_INV_SHIFT))

#define  CTWIN_W1CR_RESERVED4_MASK 0xc0
#define  CTWIN_W1CR_RESERVED4_SHIFT 6
#define  CTWIN_W1CR_RESERVED4_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_RESERVED4_MASK) >> CTWIN_W1CR_RESERVED4_SHIFT)
#define  CTWIN_W1CR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_RESERVED4_MASK) | (((uint32_t)val) << CTWIN_W1CR_RESERVED4_SHIFT))

#define  CTWIN_W1CR_WIN1_INPUT_SEL_MASK 0x3f
#define  CTWIN_W1CR_WIN1_INPUT_SEL_SHIFT 0
#define  CTWIN_W1CR_WIN1_INPUT_SEL_MASK_SHIFT(reg) (((reg) & CTWIN_W1CR_WIN1_INPUT_SEL_MASK) >> CTWIN_W1CR_WIN1_INPUT_SEL_SHIFT)
#define  CTWIN_W1CR_WIN1_INPUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1CR_WIN1_INPUT_SEL_MASK) | (((uint32_t)val) << CTWIN_W1CR_WIN1_INPUT_SEL_SHIFT))

//====================================================================
//Register: Window 2 Configuration Register (W2CR)
/** \brief Configures window 2*/
//====================================================================

#define  CTWIN_W2CR_RESERVED1_MASK 0xf0000000
#define  CTWIN_W2CR_RESERVED1_SHIFT 28
#define  CTWIN_W2CR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_RESERVED1_MASK) >> CTWIN_W2CR_RESERVED1_SHIFT)
#define  CTWIN_W2CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2CR_RESERVED1_SHIFT))

#define  CTWIN_W2CR_WIN2_PAT_SEL_MASK 0xf000000
#define  CTWIN_W2CR_WIN2_PAT_SEL_SHIFT 24
#define  CTWIN_W2CR_WIN2_PAT_SEL_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_PAT_SEL_MASK) >> CTWIN_W2CR_WIN2_PAT_SEL_SHIFT)
#define  CTWIN_W2CR_WIN2_PAT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_PAT_SEL_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_PAT_SEL_SHIFT))

#define  CTWIN_W2CR_WIN2_PAT_INV_MASK 0xf00000
#define  CTWIN_W2CR_WIN2_PAT_INV_SHIFT 20
#define  CTWIN_W2CR_WIN2_PAT_INV_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_PAT_INV_MASK) >> CTWIN_W2CR_WIN2_PAT_INV_SHIFT)
#define  CTWIN_W2CR_WIN2_PAT_INV_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_PAT_INV_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_PAT_INV_SHIFT))

#define  CTWIN_W2CR_RESERVED2_MASK 0xc0000
#define  CTWIN_W2CR_RESERVED2_SHIFT 18
#define  CTWIN_W2CR_RESERVED2_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_RESERVED2_MASK) >> CTWIN_W2CR_RESERVED2_SHIFT)
#define  CTWIN_W2CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_RESERVED2_MASK) | (((uint32_t)val) << CTWIN_W2CR_RESERVED2_SHIFT))

#define  CTWIN_W2CR_WIN2_PAT_FUNC_MASK 0x20000
#define  CTWIN_W2CR_WIN2_PAT_FUNC_SHIFT 17
#define  CTWIN_W2CR_WIN2_PAT_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_PAT_FUNC_MASK) >> CTWIN_W2CR_WIN2_PAT_FUNC_SHIFT)
#define  CTWIN_W2CR_WIN2_PAT_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_PAT_FUNC_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_PAT_FUNC_SHIFT))

#define  CTWIN_W2CR_WIN2_INPUT_FUNC_MASK 0x10000
#define  CTWIN_W2CR_WIN2_INPUT_FUNC_SHIFT 16
#define  CTWIN_W2CR_WIN2_INPUT_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_INPUT_FUNC_MASK) >> CTWIN_W2CR_WIN2_INPUT_FUNC_SHIFT)
#define  CTWIN_W2CR_WIN2_INPUT_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_INPUT_FUNC_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_INPUT_FUNC_SHIFT))

#define  CTWIN_W2CR_RESERVED3_MASK 0xc000
#define  CTWIN_W2CR_RESERVED3_SHIFT 14
#define  CTWIN_W2CR_RESERVED3_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_RESERVED3_MASK) >> CTWIN_W2CR_RESERVED3_SHIFT)
#define  CTWIN_W2CR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_RESERVED3_MASK) | (((uint32_t)val) << CTWIN_W2CR_RESERVED3_SHIFT))

#define  CTWIN_W2CR_WIN2_INPUT_INV_MASK 0x3f00
#define  CTWIN_W2CR_WIN2_INPUT_INV_SHIFT 8
#define  CTWIN_W2CR_WIN2_INPUT_INV_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_INPUT_INV_MASK) >> CTWIN_W2CR_WIN2_INPUT_INV_SHIFT)
#define  CTWIN_W2CR_WIN2_INPUT_INV_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_INPUT_INV_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_INPUT_INV_SHIFT))

#define  CTWIN_W2CR_RESERVED4_MASK 0xc0
#define  CTWIN_W2CR_RESERVED4_SHIFT 6
#define  CTWIN_W2CR_RESERVED4_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_RESERVED4_MASK) >> CTWIN_W2CR_RESERVED4_SHIFT)
#define  CTWIN_W2CR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_RESERVED4_MASK) | (((uint32_t)val) << CTWIN_W2CR_RESERVED4_SHIFT))

#define  CTWIN_W2CR_WIN2_INPUT_SEL_MASK 0x3f
#define  CTWIN_W2CR_WIN2_INPUT_SEL_SHIFT 0
#define  CTWIN_W2CR_WIN2_INPUT_SEL_MASK_SHIFT(reg) (((reg) & CTWIN_W2CR_WIN2_INPUT_SEL_MASK) >> CTWIN_W2CR_WIN2_INPUT_SEL_SHIFT)
#define  CTWIN_W2CR_WIN2_INPUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2CR_WIN2_INPUT_SEL_MASK) | (((uint32_t)val) << CTWIN_W2CR_WIN2_INPUT_SEL_SHIFT))

//====================================================================
//Register: Output Control Register (OCR)
/** \brief Output control register 1*/
//====================================================================

#define  CTWIN_OCR_EDGE_PAT_SEL_MASK 0xc0000000
#define  CTWIN_OCR_EDGE_PAT_SEL_SHIFT 30
#define  CTWIN_OCR_EDGE_PAT_SEL_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_EDGE_PAT_SEL_MASK) >> CTWIN_OCR_EDGE_PAT_SEL_SHIFT)
#define  CTWIN_OCR_EDGE_PAT_SEL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_EDGE_PAT_SEL_MASK) | (((uint32_t)val) << CTWIN_OCR_EDGE_PAT_SEL_SHIFT))

#define  CTWIN_OCR_OUT_WIN_FUNC_MASK 0x3f000000
#define  CTWIN_OCR_OUT_WIN_FUNC_SHIFT 24
#define  CTWIN_OCR_OUT_WIN_FUNC_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_FUNC_MASK) >> CTWIN_OCR_OUT_WIN_FUNC_SHIFT)
#define  CTWIN_OCR_OUT_WIN_FUNC_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_FUNC_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_FUNC_SHIFT))

#define  CTWIN_OCR_OUT_MODE5_MASK 0xc00000
#define  CTWIN_OCR_OUT_MODE5_SHIFT 22
#define  CTWIN_OCR_OUT_MODE5_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE5_MASK) >> CTWIN_OCR_OUT_MODE5_SHIFT)
#define  CTWIN_OCR_OUT_MODE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE5_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE5_SHIFT))

#define  CTWIN_OCR_OUT_MODE4_MASK 0x300000
#define  CTWIN_OCR_OUT_MODE4_SHIFT 20
#define  CTWIN_OCR_OUT_MODE4_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE4_MASK) >> CTWIN_OCR_OUT_MODE4_SHIFT)
#define  CTWIN_OCR_OUT_MODE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE4_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE4_SHIFT))

#define  CTWIN_OCR_OUT_MODE3_MASK 0xc0000
#define  CTWIN_OCR_OUT_MODE3_SHIFT 18
#define  CTWIN_OCR_OUT_MODE3_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE3_MASK) >> CTWIN_OCR_OUT_MODE3_SHIFT)
#define  CTWIN_OCR_OUT_MODE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE3_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE3_SHIFT))

#define  CTWIN_OCR_OUT_MODE2_MASK 0x30000
#define  CTWIN_OCR_OUT_MODE2_SHIFT 16
#define  CTWIN_OCR_OUT_MODE2_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE2_MASK) >> CTWIN_OCR_OUT_MODE2_SHIFT)
#define  CTWIN_OCR_OUT_MODE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE2_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE2_SHIFT))

#define  CTWIN_OCR_OUT_MODE1_MASK 0xc000
#define  CTWIN_OCR_OUT_MODE1_SHIFT 14
#define  CTWIN_OCR_OUT_MODE1_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE1_MASK) >> CTWIN_OCR_OUT_MODE1_SHIFT)
#define  CTWIN_OCR_OUT_MODE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE1_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE1_SHIFT))

#define  CTWIN_OCR_OUT_MODE0_MASK 0x3000
#define  CTWIN_OCR_OUT_MODE0_SHIFT 12
#define  CTWIN_OCR_OUT_MODE0_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_MODE0_MASK) >> CTWIN_OCR_OUT_MODE0_SHIFT)
#define  CTWIN_OCR_OUT_MODE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_MODE0_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_MODE0_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL5_MASK 0xc00
#define  CTWIN_OCR_OUT_WIN_SEL5_SHIFT 10
#define  CTWIN_OCR_OUT_WIN_SEL5_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL5_MASK) >> CTWIN_OCR_OUT_WIN_SEL5_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL5_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL5_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL4_MASK 0x300
#define  CTWIN_OCR_OUT_WIN_SEL4_SHIFT 8
#define  CTWIN_OCR_OUT_WIN_SEL4_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL4_MASK) >> CTWIN_OCR_OUT_WIN_SEL4_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL4_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL4_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL3_MASK 0xc0
#define  CTWIN_OCR_OUT_WIN_SEL3_SHIFT 6
#define  CTWIN_OCR_OUT_WIN_SEL3_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL3_MASK) >> CTWIN_OCR_OUT_WIN_SEL3_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL3_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL3_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL2_MASK 0x30
#define  CTWIN_OCR_OUT_WIN_SEL2_SHIFT 4
#define  CTWIN_OCR_OUT_WIN_SEL2_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL2_MASK) >> CTWIN_OCR_OUT_WIN_SEL2_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL2_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL2_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL1_MASK 0xc
#define  CTWIN_OCR_OUT_WIN_SEL1_SHIFT 2
#define  CTWIN_OCR_OUT_WIN_SEL1_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL1_MASK) >> CTWIN_OCR_OUT_WIN_SEL1_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL1_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL1_SHIFT))

#define  CTWIN_OCR_OUT_WIN_SEL0_MASK 0x3
#define  CTWIN_OCR_OUT_WIN_SEL0_SHIFT 0
#define  CTWIN_OCR_OUT_WIN_SEL0_MASK_SHIFT(reg) (((reg) & CTWIN_OCR_OUT_WIN_SEL0_MASK) >> CTWIN_OCR_OUT_WIN_SEL0_SHIFT)
#define  CTWIN_OCR_OUT_WIN_SEL0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OCR_OUT_WIN_SEL0_MASK) | (((uint32_t)val) << CTWIN_OCR_OUT_WIN_SEL0_SHIFT))

//====================================================================
//Register: Output Value Register 1 (OVR1)
/** \brief six, 10-bit values used in output plane generation. The actual use of these depends on the output_mode selection described in the Output Control Register section. This 6x10 LUT is implemented as two registers. The first field is associated with plane 0, the second field plane 1, etc.*/
//====================================================================

#define  CTWIN_OVR1_RESERVED1_MASK 0xc0000000
#define  CTWIN_OVR1_RESERVED1_SHIFT 30
#define  CTWIN_OVR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_OVR1_RESERVED1_MASK) >> CTWIN_OVR1_RESERVED1_SHIFT)
#define  CTWIN_OVR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_OVR1_RESERVED1_SHIFT))

#define  CTWIN_OVR1_OUT_VAL2_MASK 0x3ff00000
#define  CTWIN_OVR1_OUT_VAL2_SHIFT 20
#define  CTWIN_OVR1_OUT_VAL2_MASK_SHIFT(reg) (((reg) & CTWIN_OVR1_OUT_VAL2_MASK) >> CTWIN_OVR1_OUT_VAL2_SHIFT)
#define  CTWIN_OVR1_OUT_VAL2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR1_OUT_VAL2_MASK) | (((uint32_t)val) << CTWIN_OVR1_OUT_VAL2_SHIFT))

#define  CTWIN_OVR1_OUT_VAL1_MASK 0xffc00
#define  CTWIN_OVR1_OUT_VAL1_SHIFT 10
#define  CTWIN_OVR1_OUT_VAL1_MASK_SHIFT(reg) (((reg) & CTWIN_OVR1_OUT_VAL1_MASK) >> CTWIN_OVR1_OUT_VAL1_SHIFT)
#define  CTWIN_OVR1_OUT_VAL1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR1_OUT_VAL1_MASK) | (((uint32_t)val) << CTWIN_OVR1_OUT_VAL1_SHIFT))

#define  CTWIN_OVR1_OUT_VAL0_MASK 0x3ff
#define  CTWIN_OVR1_OUT_VAL0_SHIFT 0
#define  CTWIN_OVR1_OUT_VAL0_MASK_SHIFT(reg) (((reg) & CTWIN_OVR1_OUT_VAL0_MASK) >> CTWIN_OVR1_OUT_VAL0_SHIFT)
#define  CTWIN_OVR1_OUT_VAL0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR1_OUT_VAL0_MASK) | (((uint32_t)val) << CTWIN_OVR1_OUT_VAL0_SHIFT))

//====================================================================
//Register: Output Value Register 2 (OVR2)
/** \brief six, 10-bit values used in output plane generation. The actual use of these depends on the output_mode selection described in the Output Control Register section. This 6x10 LUT is implemented as two This is the second of the two registers. The first field is associated with plane 3, the second field plane 4, etc.*/
//====================================================================

#define  CTWIN_OVR2_RESERVED1_MASK 0xc0000000
#define  CTWIN_OVR2_RESERVED1_SHIFT 30
#define  CTWIN_OVR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_OVR2_RESERVED1_MASK) >> CTWIN_OVR2_RESERVED1_SHIFT)
#define  CTWIN_OVR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_OVR2_RESERVED1_SHIFT))

#define  CTWIN_OVR2_OUT_VAL5_MASK 0x3ff00000
#define  CTWIN_OVR2_OUT_VAL5_SHIFT 20
#define  CTWIN_OVR2_OUT_VAL5_MASK_SHIFT(reg) (((reg) & CTWIN_OVR2_OUT_VAL5_MASK) >> CTWIN_OVR2_OUT_VAL5_SHIFT)
#define  CTWIN_OVR2_OUT_VAL5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR2_OUT_VAL5_MASK) | (((uint32_t)val) << CTWIN_OVR2_OUT_VAL5_SHIFT))

#define  CTWIN_OVR2_OUT_VAL4_MASK 0xffc00
#define  CTWIN_OVR2_OUT_VAL4_SHIFT 10
#define  CTWIN_OVR2_OUT_VAL4_MASK_SHIFT(reg) (((reg) & CTWIN_OVR2_OUT_VAL4_MASK) >> CTWIN_OVR2_OUT_VAL4_SHIFT)
#define  CTWIN_OVR2_OUT_VAL4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR2_OUT_VAL4_MASK) | (((uint32_t)val) << CTWIN_OVR2_OUT_VAL4_SHIFT))

#define  CTWIN_OVR2_OUT_VAL3_MASK 0x3ff
#define  CTWIN_OVR2_OUT_VAL3_SHIFT 0
#define  CTWIN_OVR2_OUT_VAL3_MASK_SHIFT(reg) (((reg) & CTWIN_OVR2_OUT_VAL3_MASK) >> CTWIN_OVR2_OUT_VAL3_SHIFT)
#define  CTWIN_OVR2_OUT_VAL3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_OVR2_OUT_VAL3_MASK) | (((uint32_t)val) << CTWIN_OVR2_OUT_VAL3_SHIFT))

//====================================================================
//Register: Kt Merge Value Register 1 (KMR1)
/** \brief Kt merge LUT. 5 10 bits values used to modify the incoming Kt contone plane. Each value corresponds to the number of "on" pixels in the 2x2 cell.*/
//====================================================================

#define  CTWIN_KMR1_RESERVED1_MASK 0xc0000000
#define  CTWIN_KMR1_RESERVED1_SHIFT 30
#define  CTWIN_KMR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_KMR1_RESERVED1_MASK) >> CTWIN_KMR1_RESERVED1_SHIFT)
#define  CTWIN_KMR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_KMR1_RESERVED1_SHIFT))

#define  CTWIN_KMR1_KT_MERGE_VAL_2_MASK 0x3ff00000
#define  CTWIN_KMR1_KT_MERGE_VAL_2_SHIFT 20
#define  CTWIN_KMR1_KT_MERGE_VAL_2_MASK_SHIFT(reg) (((reg) & CTWIN_KMR1_KT_MERGE_VAL_2_MASK) >> CTWIN_KMR1_KT_MERGE_VAL_2_SHIFT)
#define  CTWIN_KMR1_KT_MERGE_VAL_2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR1_KT_MERGE_VAL_2_MASK) | (((uint32_t)val) << CTWIN_KMR1_KT_MERGE_VAL_2_SHIFT))

#define  CTWIN_KMR1_KT_MERGE_VAL_1_MASK 0xffc00
#define  CTWIN_KMR1_KT_MERGE_VAL_1_SHIFT 10
#define  CTWIN_KMR1_KT_MERGE_VAL_1_MASK_SHIFT(reg) (((reg) & CTWIN_KMR1_KT_MERGE_VAL_1_MASK) >> CTWIN_KMR1_KT_MERGE_VAL_1_SHIFT)
#define  CTWIN_KMR1_KT_MERGE_VAL_1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR1_KT_MERGE_VAL_1_MASK) | (((uint32_t)val) << CTWIN_KMR1_KT_MERGE_VAL_1_SHIFT))

#define  CTWIN_KMR1_KT_MERGE_VAL_0_MASK 0x3ff
#define  CTWIN_KMR1_KT_MERGE_VAL_0_SHIFT 0
#define  CTWIN_KMR1_KT_MERGE_VAL_0_MASK_SHIFT(reg) (((reg) & CTWIN_KMR1_KT_MERGE_VAL_0_MASK) >> CTWIN_KMR1_KT_MERGE_VAL_0_SHIFT)
#define  CTWIN_KMR1_KT_MERGE_VAL_0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR1_KT_MERGE_VAL_0_MASK) | (((uint32_t)val) << CTWIN_KMR1_KT_MERGE_VAL_0_SHIFT))

//====================================================================
//Register: Kt Merge Value Register 2 (KMR2)
/** \brief Kt merge LUT. 5 10 bits values used to modify the incoming Kt contone plane. Each value corresponds to the number of "on" pixels in the 2x2 cell.*/
//====================================================================

#define  CTWIN_KMR2_RESERVED1_MASK 0xfff00000
#define  CTWIN_KMR2_RESERVED1_SHIFT 20
#define  CTWIN_KMR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_KMR2_RESERVED1_MASK) >> CTWIN_KMR2_RESERVED1_SHIFT)
#define  CTWIN_KMR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_KMR2_RESERVED1_SHIFT))

#define  CTWIN_KMR2_KT_MERGE_VAL_4_MASK 0xffc00
#define  CTWIN_KMR2_KT_MERGE_VAL_4_SHIFT 10
#define  CTWIN_KMR2_KT_MERGE_VAL_4_MASK_SHIFT(reg) (((reg) & CTWIN_KMR2_KT_MERGE_VAL_4_MASK) >> CTWIN_KMR2_KT_MERGE_VAL_4_SHIFT)
#define  CTWIN_KMR2_KT_MERGE_VAL_4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR2_KT_MERGE_VAL_4_MASK) | (((uint32_t)val) << CTWIN_KMR2_KT_MERGE_VAL_4_SHIFT))

#define  CTWIN_KMR2_KT_MERGE_VAL_3_MASK 0x3ff
#define  CTWIN_KMR2_KT_MERGE_VAL_3_SHIFT 0
#define  CTWIN_KMR2_KT_MERGE_VAL_3_MASK_SHIFT(reg) (((reg) & CTWIN_KMR2_KT_MERGE_VAL_3_MASK) >> CTWIN_KMR2_KT_MERGE_VAL_3_SHIFT)
#define  CTWIN_KMR2_KT_MERGE_VAL_3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_KMR2_KT_MERGE_VAL_3_MASK) | (((uint32_t)val) << CTWIN_KMR2_KT_MERGE_VAL_3_SHIFT))

//====================================================================
//Register: Window 1 Threshold_0 Register 1 (W1TH0R1)
/** \brief Threshold values used to determine a '0' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh0_plane0 is for plane 0, win1_thresh0_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH0R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH0R1_RESERVED1_SHIFT 30
#define  CTWIN_W1TH0R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R1_RESERVED1_MASK) >> CTWIN_W1TH0R1_RESERVED1_SHIFT)
#define  CTWIN_W1TH0R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH0R1_RESERVED1_SHIFT))

#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_MASK 0x3ff00000
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_SHIFT 20
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_MASK) >> CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_SHIFT)
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W1TH0R1_WIN1_THRESH0_PLANE2_SHIFT))

#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_MASK 0xffc00
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_SHIFT 10
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_MASK) >> CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_SHIFT)
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W1TH0R1_WIN1_THRESH0_PLANE1_SHIFT))

#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_MASK 0x3ff
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_SHIFT 0
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_MASK) >> CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_SHIFT)
#define  CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W1TH0R1_WIN1_THRESH0_PLANE0_SHIFT))

//====================================================================
//Register: Window 1 Threshold_0 Register 2 (W1TH0R2)
/** \brief Threshold values used to determine a '0' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh0_plane0 is for plane 0, win1_thresh0_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH0R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH0R2_RESERVED1_SHIFT 30
#define  CTWIN_W1TH0R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R2_RESERVED1_MASK) >> CTWIN_W1TH0R2_RESERVED1_SHIFT)
#define  CTWIN_W1TH0R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH0R2_RESERVED1_SHIFT))

#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_MASK 0x3ff00000
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_SHIFT 20
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_MASK) >> CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_SHIFT)
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W1TH0R2_WIN1_THRESH0_PLANE5_SHIFT))

#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_MASK 0xffc00
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_SHIFT 10
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_MASK) >> CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_SHIFT)
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W1TH0R2_WIN1_THRESH0_PLANE4_SHIFT))

#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_MASK 0x3ff
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_SHIFT 0
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_MASK) >> CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_SHIFT)
#define  CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W1TH0R2_WIN1_THRESH0_PLANE3_SHIFT))

//====================================================================
//Register: Window 1 Threshold_1 Register 1 (W1TH1R1)
/** \brief Threshold values used to determine a '1' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh1_plane0 is for plane 0, win1_thresh1_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH1R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH1R1_RESERVED1_SHIFT 30
#define  CTWIN_W1TH1R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R1_RESERVED1_MASK) >> CTWIN_W1TH1R1_RESERVED1_SHIFT)
#define  CTWIN_W1TH1R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH1R1_RESERVED1_SHIFT))

#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_MASK 0x3ff00000
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_SHIFT 20
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_MASK) >> CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_SHIFT)
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W1TH1R1_WIN1_THRESH1_PLANE2_SHIFT))

#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_MASK 0xffc00
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_SHIFT 10
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_MASK) >> CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_SHIFT)
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W1TH1R1_WIN1_THRESH1_PLANE1_SHIFT))

#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_MASK 0x3ff
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_SHIFT 0
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_MASK) >> CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_SHIFT)
#define  CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W1TH1R1_WIN1_THRESH1_PLANE0_SHIFT))

//====================================================================
//Register: Window 1 Threshold_1 Register 2 (W1TH1R2)
/** \brief Threshold values used to determine a '1' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh1_plane0 is for plane 0, win1_thresh1_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH1R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH1R2_RESERVED1_SHIFT 30
#define  CTWIN_W1TH1R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R2_RESERVED1_MASK) >> CTWIN_W1TH1R2_RESERVED1_SHIFT)
#define  CTWIN_W1TH1R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH1R2_RESERVED1_SHIFT))

#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_MASK 0x3ff00000
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_SHIFT 20
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_MASK) >> CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_SHIFT)
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W1TH1R2_WIN1_THRESH1_PLANE5_SHIFT))

#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_MASK 0xffc00
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_SHIFT 10
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_MASK) >> CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_SHIFT)
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W1TH1R2_WIN1_THRESH1_PLANE4_SHIFT))

#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_MASK 0x3ff
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_SHIFT 0
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_MASK) >> CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_SHIFT)
#define  CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W1TH1R2_WIN1_THRESH1_PLANE3_SHIFT))

//====================================================================
//Register: Window 1 Threshold_2 Register 1 (W1TH2R1)
/** \brief Threshold values used to determine a '2' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh2_plane0 is for plane 0, win1_thresh2_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH2R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH2R1_RESERVED1_SHIFT 30
#define  CTWIN_W1TH2R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R1_RESERVED1_MASK) >> CTWIN_W1TH2R1_RESERVED1_SHIFT)
#define  CTWIN_W1TH2R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH2R1_RESERVED1_SHIFT))

#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_MASK 0x3ff00000
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_SHIFT 20
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_MASK) >> CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_SHIFT)
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W1TH2R1_WIN1_THRESH2_PLANE2_SHIFT))

#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_MASK 0xffc00
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_SHIFT 10
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_MASK) >> CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_SHIFT)
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W1TH2R1_WIN1_THRESH2_PLANE1_SHIFT))

#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_MASK 0x3ff
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_SHIFT 0
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_MASK) >> CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_SHIFT)
#define  CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W1TH2R1_WIN1_THRESH2_PLANE0_SHIFT))

//====================================================================
//Register: Window 1 Threshold_2 Register 2 (W1TH2R2)
/** \brief Threshold values used to determine a '2' level in window 1 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win1_thresh2_plane0 is for plane 0, win1_thresh2_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W1TH2R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W1TH2R2_RESERVED1_SHIFT 30
#define  CTWIN_W1TH2R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R2_RESERVED1_MASK) >> CTWIN_W1TH2R2_RESERVED1_SHIFT)
#define  CTWIN_W1TH2R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W1TH2R2_RESERVED1_SHIFT))

#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_MASK 0x3ff00000
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_SHIFT 20
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_MASK) >> CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_SHIFT)
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W1TH2R2_WIN1_THRESH2_PLANE5_SHIFT))

#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_MASK 0xffc00
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_SHIFT 10
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_MASK) >> CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_SHIFT)
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W1TH2R2_WIN1_THRESH2_PLANE4_SHIFT))

#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_MASK 0x3ff
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_SHIFT 0
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_MASK) >> CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_SHIFT)
#define  CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W1TH2R2_WIN1_THRESH2_PLANE3_SHIFT))

//====================================================================
//Register: Window 2 Threshold_0 Register 1 (W2TH0R1)
/** \brief Threshold values used to determine a '0' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh0_plane0 is for plane 0, win2_thresh0_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH0R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH0R1_RESERVED1_SHIFT 30
#define  CTWIN_W2TH0R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R1_RESERVED1_MASK) >> CTWIN_W2TH0R1_RESERVED1_SHIFT)
#define  CTWIN_W2TH0R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH0R1_RESERVED1_SHIFT))

#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_MASK 0x3ff00000
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_SHIFT 20
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_MASK) >> CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_SHIFT)
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W2TH0R1_WIN2_THRESH0_PLANE2_SHIFT))

#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_MASK 0xffc00
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_SHIFT 10
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_MASK) >> CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_SHIFT)
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W2TH0R1_WIN2_THRESH0_PLANE1_SHIFT))

#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_MASK 0x3ff
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_SHIFT 0
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_MASK) >> CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_SHIFT)
#define  CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W2TH0R1_WIN2_THRESH0_PLANE0_SHIFT))

//====================================================================
//Register: Window 2 Threshold_0 Register 2 (W2TH0R2)
/** \brief Threshold values used to determine a '0' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh0_plane0 is for plane 0, win2_thresh0_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH0R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH0R2_RESERVED1_SHIFT 30
#define  CTWIN_W2TH0R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R2_RESERVED1_MASK) >> CTWIN_W2TH0R2_RESERVED1_SHIFT)
#define  CTWIN_W2TH0R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH0R2_RESERVED1_SHIFT))

#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_MASK 0x3ff00000
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_SHIFT 20
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_MASK) >> CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_SHIFT)
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W2TH0R2_WIN2_THRESH0_PLANE5_SHIFT))

#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_MASK 0xffc00
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_SHIFT 10
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_MASK) >> CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_SHIFT)
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W2TH0R2_WIN2_THRESH0_PLANE4_SHIFT))

#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_MASK 0x3ff
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_SHIFT 0
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_MASK) >> CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_SHIFT)
#define  CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W2TH0R2_WIN2_THRESH0_PLANE3_SHIFT))

//====================================================================
//Register: Window 2 Threshold_1 Register 1 (W2TH1R1)
/** \brief Threshold values used to determine a '1' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh1_plane0 is for plane 0, win2_thresh1_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH1R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH1R1_RESERVED1_SHIFT 30
#define  CTWIN_W2TH1R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R1_RESERVED1_MASK) >> CTWIN_W2TH1R1_RESERVED1_SHIFT)
#define  CTWIN_W2TH1R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH1R1_RESERVED1_SHIFT))

#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_MASK 0x3ff00000
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_SHIFT 20
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_MASK) >> CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_SHIFT)
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W2TH1R1_WIN2_THRESH1_PLANE2_SHIFT))

#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_MASK 0xffc00
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_SHIFT 10
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_MASK) >> CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_SHIFT)
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W2TH1R1_WIN2_THRESH1_PLANE1_SHIFT))

#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_MASK 0x3ff
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_SHIFT 0
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_MASK) >> CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_SHIFT)
#define  CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W2TH1R1_WIN2_THRESH1_PLANE0_SHIFT))

//====================================================================
//Register: Window 2 Threshold_1 Register 2 (W2TH1R2)
/** \brief Threshold values used to determine a '1' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh1_plane0 is for plane 0, win2_thresh1_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH1R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH1R2_RESERVED1_SHIFT 30
#define  CTWIN_W2TH1R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R2_RESERVED1_MASK) >> CTWIN_W2TH1R2_RESERVED1_SHIFT)
#define  CTWIN_W2TH1R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH1R2_RESERVED1_SHIFT))

#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_MASK 0x3ff00000
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_SHIFT 20
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_MASK) >> CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_SHIFT)
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W2TH1R2_WIN2_THRESH1_PLANE5_SHIFT))

#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_MASK 0xffc00
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_SHIFT 10
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_MASK) >> CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_SHIFT)
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W2TH1R2_WIN2_THRESH1_PLANE4_SHIFT))

#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_MASK 0x3ff
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_SHIFT 0
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_MASK) >> CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_SHIFT)
#define  CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W2TH1R2_WIN2_THRESH1_PLANE3_SHIFT))

//====================================================================
//Register: Window 2 Threshold_2 Register 1 (W2TH2R1)
/** \brief Threshold values used to determine a '2' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh2_plane0 is for plane 0, win2_thresh2_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH2R1_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH2R1_RESERVED1_SHIFT 30
#define  CTWIN_W2TH2R1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R1_RESERVED1_MASK) >> CTWIN_W2TH2R1_RESERVED1_SHIFT)
#define  CTWIN_W2TH2R1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH2R1_RESERVED1_SHIFT))

#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_MASK 0x3ff00000
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_SHIFT 20
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_MASK) >> CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_SHIFT)
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_MASK) | (((uint32_t)val) << CTWIN_W2TH2R1_WIN2_THRESH2_PLANE2_SHIFT))

#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_MASK 0xffc00
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_SHIFT 10
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_MASK) >> CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_SHIFT)
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_MASK) | (((uint32_t)val) << CTWIN_W2TH2R1_WIN2_THRESH2_PLANE1_SHIFT))

#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_MASK 0x3ff
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_SHIFT 0
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_MASK) >> CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_SHIFT)
#define  CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_MASK) | (((uint32_t)val) << CTWIN_W2TH2R1_WIN2_THRESH2_PLANE0_SHIFT))

//====================================================================
//Register: Window 2 Threshold_2 Register 2 (W2TH2R2)
/** \brief Threshold values used to determine a '2' level in window 2 for each incoming plane. The
      number appended to the end of the register field indicates the plane the threshold is
      applied to, win2_thresh2_plane0 is for plane 0, win2_thresh2_plane1 is for plane 1, etc.*/
//====================================================================

#define  CTWIN_W2TH2R2_RESERVED1_MASK 0xc0000000
#define  CTWIN_W2TH2R2_RESERVED1_SHIFT 30
#define  CTWIN_W2TH2R2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R2_RESERVED1_MASK) >> CTWIN_W2TH2R2_RESERVED1_SHIFT)
#define  CTWIN_W2TH2R2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_W2TH2R2_RESERVED1_SHIFT))

#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_MASK 0x3ff00000
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_SHIFT 20
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_MASK) >> CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_SHIFT)
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_MASK) | (((uint32_t)val) << CTWIN_W2TH2R2_WIN2_THRESH2_PLANE5_SHIFT))

#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_MASK 0xffc00
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_SHIFT 10
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_MASK) >> CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_SHIFT)
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_MASK) | (((uint32_t)val) << CTWIN_W2TH2R2_WIN2_THRESH2_PLANE4_SHIFT))

#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_MASK 0x3ff
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_SHIFT 0
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_MASK_SHIFT(reg) (((reg) & CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_MASK) >> CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_SHIFT)
#define  CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_MASK) | (((uint32_t)val) << CTWIN_W2TH2R2_WIN2_THRESH2_PLANE3_SHIFT))

//====================================================================
//Register: Edge Scale Register 1 (ESCR1)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. The first two registers contain the edge scale value for pixels 1 away from an edge. The six fields in these two registers correspond to the 6 planes. The second set of registers contain the edge scale value for pixels 2 away from an edge and the last two registers contain the edge scale value for pixels 3 away from an edge. The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_one_away0 is for plane 0, edge_sc_one_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR1_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR1_RESERVED1_SHIFT 30
#define  CTWIN_ESCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR1_RESERVED1_MASK) >> CTWIN_ESCR1_RESERVED1_SHIFT)
#define  CTWIN_ESCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR1_RESERVED1_SHIFT))

#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_MASK 0x3ff00000
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_SHIFT 20
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_MASK) >> CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_SHIFT)
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ESCR1_EDGE_SC_ONE_AWAY2_SHIFT))

#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_MASK 0xffc00
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_SHIFT 10
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_MASK) >> CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_SHIFT)
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ESCR1_EDGE_SC_ONE_AWAY1_SHIFT))

#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_MASK 0x3ff
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_SHIFT 0
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_MASK) >> CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_SHIFT)
#define  CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ESCR1_EDGE_SC_ONE_AWAY0_SHIFT))

//====================================================================
//Register: Edge Scale Register 2 (ESCR2)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge scale value for pixels 1 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_one_away0 is for plane 0, edge_sc_one_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR2_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR2_RESERVED1_SHIFT 30
#define  CTWIN_ESCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR2_RESERVED1_MASK) >> CTWIN_ESCR2_RESERVED1_SHIFT)
#define  CTWIN_ESCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR2_RESERVED1_SHIFT))

#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_MASK 0x3ff00000
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_SHIFT 20
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_MASK) >> CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_SHIFT)
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ESCR2_EDGE_SC_ONE_AWAY5_SHIFT))

#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_MASK 0xffc00
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_SHIFT 10
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_MASK) >> CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_SHIFT)
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ESCR2_EDGE_SC_ONE_AWAY4_SHIFT))

#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_MASK 0x3ff
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_SHIFT 0
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_MASK) >> CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_SHIFT)
#define  CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ESCR2_EDGE_SC_ONE_AWAY3_SHIFT))

//====================================================================
//Register: Edge Scale Register 3 (ESCR3)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. This is the first register associated with the edge scale value for pixels 2 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_two_away0 is for plane 0, edge_sc_two_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR3_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR3_RESERVED1_SHIFT 30
#define  CTWIN_ESCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR3_RESERVED1_MASK) >> CTWIN_ESCR3_RESERVED1_SHIFT)
#define  CTWIN_ESCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR3_RESERVED1_SHIFT))

#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_MASK 0x3ff00000
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_SHIFT 20
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_MASK) >> CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_SHIFT)
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ESCR3_EDGE_SC_TWO_AWAY2_SHIFT))

#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_MASK 0xffc00
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_SHIFT 10
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_MASK) >> CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_SHIFT)
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ESCR3_EDGE_SC_TWO_AWAY1_SHIFT))

#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_MASK 0x3ff
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_SHIFT 0
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_MASK) >> CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_SHIFT)
#define  CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ESCR3_EDGE_SC_TWO_AWAY0_SHIFT))

//====================================================================
//Register: Edge Scale Register 4 (ESCR4)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge scale value for pixels 2 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_two_away0 is for plane 0, edge_sc_two_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR4_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR4_RESERVED1_SHIFT 30
#define  CTWIN_ESCR4_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR4_RESERVED1_MASK) >> CTWIN_ESCR4_RESERVED1_SHIFT)
#define  CTWIN_ESCR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR4_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR4_RESERVED1_SHIFT))

#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_MASK 0x3ff00000
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_SHIFT 20
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_MASK) >> CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_SHIFT)
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ESCR4_EDGE_SC_TWO_AWAY5_SHIFT))

#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_MASK 0xffc00
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_SHIFT 10
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_MASK) >> CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_SHIFT)
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ESCR4_EDGE_SC_TWO_AWAY4_SHIFT))

#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_MASK 0x3ff
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_SHIFT 0
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_MASK) >> CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_SHIFT)
#define  CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ESCR4_EDGE_SC_TWO_AWAY3_SHIFT))

//====================================================================
//Register: Edge Scale Register 5 (ESCR5)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. This is the first register associated with the edge scale value for pixels 3 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_three_away0 is for plane 0, edge_sc_three_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR5_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR5_RESERVED1_SHIFT 30
#define  CTWIN_ESCR5_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR5_RESERVED1_MASK) >> CTWIN_ESCR5_RESERVED1_SHIFT)
#define  CTWIN_ESCR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR5_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR5_RESERVED1_SHIFT))

#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_MASK 0x3ff00000
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_SHIFT 20
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_MASK) >> CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_SHIFT)
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ESCR5_EDGE_SC_THREE_AWAY2_SHIFT))

#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_MASK 0xffc00
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_SHIFT 10
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_MASK) >> CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_SHIFT)
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ESCR5_EDGE_SC_THREE_AWAY1_SHIFT))

#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_MASK 0x3ff
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_SHIFT 0
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_MASK) >> CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_SHIFT)
#define  CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ESCR5_EDGE_SC_THREE_AWAY0_SHIFT))

//====================================================================
//Register: Edge Scale Register 6 (ESCR6)
/** \brief 18, 10-bit values used for scaling data when edge patterns match. There is a value for each plane when a pixel is determined to be 1 pixel from an edge. There are also corresponding values for each plane for pixels that are 2 away and those that are 3 away. When an edge match is seen, the incoming data is multiplied by the corresponding scale value and then divided by 512. <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge scale value for pixels 3 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      scale is applied to, edge_sc_three_away0 is for plane 0, edge_sc_three_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ESCR6_RESERVED1_MASK 0xc0000000
#define  CTWIN_ESCR6_RESERVED1_SHIFT 30
#define  CTWIN_ESCR6_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR6_RESERVED1_MASK) >> CTWIN_ESCR6_RESERVED1_SHIFT)
#define  CTWIN_ESCR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR6_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ESCR6_RESERVED1_SHIFT))

#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_MASK 0x3ff00000
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_SHIFT 20
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_MASK) >> CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_SHIFT)
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ESCR6_EDGE_SC_THREE_AWAY5_SHIFT))

#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_MASK 0xffc00
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_SHIFT 10
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_MASK) >> CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_SHIFT)
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ESCR6_EDGE_SC_THREE_AWAY4_SHIFT))

#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_MASK 0x3ff
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_SHIFT 0
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_MASK) >> CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_SHIFT)
#define  CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ESCR6_EDGE_SC_THREE_AWAY3_SHIFT))

//====================================================================
//Register: Edge Threshold Register 1 (ETHR1)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. The first two registers contain the edge threshold value for pixels 1 away from an edge. The six fields in these two registers correspond to the 6 planes. The second set of registers contain the edge threshold value for pixels 2 away from an edge and the last two registers contain the edge threshold value for pixels 3 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_one_away0 is for plane 0, edge_th_one_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR1_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR1_RESERVED1_SHIFT 30
#define  CTWIN_ETHR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR1_RESERVED1_MASK) >> CTWIN_ETHR1_RESERVED1_SHIFT)
#define  CTWIN_ETHR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR1_RESERVED1_SHIFT))

#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_MASK 0x3ff00000
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_SHIFT 20
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_MASK) >> CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_SHIFT)
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ETHR1_EDGE_TH_ONE_AWAY2_SHIFT))

#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_MASK 0xffc00
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_SHIFT 10
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_MASK) >> CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_SHIFT)
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ETHR1_EDGE_TH_ONE_AWAY1_SHIFT))

#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_MASK 0x3ff
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_SHIFT 0
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_MASK) >> CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_SHIFT)
#define  CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ETHR1_EDGE_TH_ONE_AWAY0_SHIFT))

//====================================================================
//Register: Edge Threshold Register 2 (ETHR2)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge threshold value for pixels 1 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_one_away0 is for plane 0, edge_th_one_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR2_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR2_RESERVED1_SHIFT 30
#define  CTWIN_ETHR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR2_RESERVED1_MASK) >> CTWIN_ETHR2_RESERVED1_SHIFT)
#define  CTWIN_ETHR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR2_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR2_RESERVED1_SHIFT))

#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_MASK 0x3ff00000
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_SHIFT 20
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_MASK) >> CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_SHIFT)
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ETHR2_EDGE_TH_ONE_AWAY5_SHIFT))

#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_MASK 0xffc00
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_SHIFT 10
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_MASK) >> CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_SHIFT)
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ETHR2_EDGE_TH_ONE_AWAY4_SHIFT))

#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_MASK 0x3ff
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_SHIFT 0
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_MASK) >> CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_SHIFT)
#define  CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ETHR2_EDGE_TH_ONE_AWAY3_SHIFT))

//====================================================================
//Register: Edge Threshold Register 3 (ETHR3)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. This is the first register associated with the edge threshold value for pixels 2 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_two_away0 is for plane 0, edge_th_two_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR3_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR3_RESERVED1_SHIFT 30
#define  CTWIN_ETHR3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR3_RESERVED1_MASK) >> CTWIN_ETHR3_RESERVED1_SHIFT)
#define  CTWIN_ETHR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR3_RESERVED1_SHIFT))

#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_MASK 0x3ff00000
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_SHIFT 20
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_MASK) >> CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_SHIFT)
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ETHR3_EDGE_TH_TWO_AWAY2_SHIFT))

#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_MASK 0xffc00
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_SHIFT 10
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_MASK) >> CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_SHIFT)
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ETHR3_EDGE_TH_TWO_AWAY1_SHIFT))

#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_MASK 0x3ff
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_SHIFT 0
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_MASK) >> CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_SHIFT)
#define  CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ETHR3_EDGE_TH_TWO_AWAY0_SHIFT))

//====================================================================
//Register: Edge Threshold Register 4 (ETHR4)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge threshold value for pixels 2 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_two_away0 is for plane 0, edge_th_two_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR4_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR4_RESERVED1_SHIFT 30
#define  CTWIN_ETHR4_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR4_RESERVED1_MASK) >> CTWIN_ETHR4_RESERVED1_SHIFT)
#define  CTWIN_ETHR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR4_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR4_RESERVED1_SHIFT))

#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_MASK 0x3ff00000
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_SHIFT 20
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_MASK) >> CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_SHIFT)
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ETHR4_EDGE_TH_TWO_AWAY5_SHIFT))

#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_MASK 0xffc00
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_SHIFT 10
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_MASK) >> CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_SHIFT)
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ETHR4_EDGE_TH_TWO_AWAY4_SHIFT))

#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_MASK 0x3ff
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_SHIFT 0
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_MASK) >> CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_SHIFT)
#define  CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ETHR4_EDGE_TH_TWO_AWAY3_SHIFT))

//====================================================================
//Register: Edge Threshold Register 5 (ETHR5)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. This is the first register associated with the edge threshold value for pixels 3 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_three_away0 is for plane 0, edge_th_three_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR5_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR5_RESERVED1_SHIFT 30
#define  CTWIN_ETHR5_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR5_RESERVED1_MASK) >> CTWIN_ETHR5_RESERVED1_SHIFT)
#define  CTWIN_ETHR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR5_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR5_RESERVED1_SHIFT))

#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_MASK 0x3ff00000
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_SHIFT 20
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_MASK) >> CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_SHIFT)
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_MASK) | (((uint32_t)val) << CTWIN_ETHR5_EDGE_TH_THREE_AWAY2_SHIFT))

#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_MASK 0xffc00
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_SHIFT 10
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_MASK) >> CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_SHIFT)
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_MASK) | (((uint32_t)val) << CTWIN_ETHR5_EDGE_TH_THREE_AWAY1_SHIFT))

#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_MASK 0x3ff
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_SHIFT 0
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_MASK) >> CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_SHIFT)
#define  CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_MASK) | (((uint32_t)val) << CTWIN_ETHR5_EDGE_TH_THREE_AWAY0_SHIFT))

//====================================================================
//Register: Edge Threshold Register 6 (ETHR6)
/** \brief 18, 10-bit values used with edge scaling. These values set a lower threshold for each plane at each distance for the contone value, and scaling will not cause the output tone to go below this threshold. For example, if the threshold is set to 128 and the scaling factor says to multiply by 0.25, an incoming tone of 384 would be reduced to 128 (the threshold) instead of 96 (384*0.25). <br/> This 18x10 LUT is implemented as 6 registers. This is the second register associated with the edge threshold value for pixels 3 away from an edge.
      The number appended to the end of the register field indicates the plane the edge
      threshold is applied to, edge_th_three_away0 is for plane 0, edge_th_three_away1 is for
      plane 1, etc.*/
//====================================================================

#define  CTWIN_ETHR6_RESERVED1_MASK 0xc0000000
#define  CTWIN_ETHR6_RESERVED1_SHIFT 30
#define  CTWIN_ETHR6_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR6_RESERVED1_MASK) >> CTWIN_ETHR6_RESERVED1_SHIFT)
#define  CTWIN_ETHR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR6_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_ETHR6_RESERVED1_SHIFT))

#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_MASK 0x3ff00000
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_SHIFT 20
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_MASK) >> CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_SHIFT)
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_MASK) | (((uint32_t)val) << CTWIN_ETHR6_EDGE_TH_THREE_AWAY5_SHIFT))

#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_MASK 0xffc00
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_SHIFT 10
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_MASK) >> CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_SHIFT)
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_MASK) | (((uint32_t)val) << CTWIN_ETHR6_EDGE_TH_THREE_AWAY4_SHIFT))

#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_MASK 0x3ff
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_SHIFT 0
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_MASK_SHIFT(reg) (((reg) & CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_MASK) >> CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_SHIFT)
#define  CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_MASK) | (((uint32_t)val) << CTWIN_ETHR6_EDGE_TH_THREE_AWAY3_SHIFT))

//====================================================================
//Register: CTWIN Pattern 0 Register 0 (P0R0)
/** \brief Each programmable pattern is implemented as a 7x7 array which is implemented with a set of 4 registers. There are 2 bits associated with each location in the window, with a 0 meaning the window must have a 0 in the zero-threshold bit, 1 meaning there must be a 1 in the one-threshold bit and 2 or 3 meaning the location in the window is a don't care. Each two bit field     represents a location in the 7x7 array. It is numbered as follows: <br/>     <table align="left">     <tr><td>0  </td ><td>1  </td ><td>2  </td 
              <td>3 </td ><td>4 </td ><td>5 </td
              <td>6 </td ></tr> <tr><td>7 </td ><td>8 </td ><td>9 </td
              <td>10 </td ><td>11 </td ><td>12 </td
              <td>13 </td ></tr> <tr><td>14 </td ><td>15 </td ><td>16 </td
              <td>17 </td ><td>18 </td ><td>19 </td
              <td>20 </td ></tr> <tr><td>21 </td ><td>22 </td ><td>23 </td
              <td>24 </td ><td>25 </td ><td>26 </td
              <td>27 </td ></tr> <tr><td>28 </td ><td>29 </td ><td>30 </td
              <td>31 </td ><td>32 </td ><td>33 </td
              <td>34 </td ></tr> <tr><td>35 </td ><td>36 </td ><td>37 </td
              <td>38 </td ><td>39 </td ><td>40 </td
              <td>41 </td ></tr> <tr><td>42 </td ><td>43 </td ><td>44 </td
              <td>45 </td ><td>46 </td ><td>47 </td
              <td>48 </td ></tr> </table>*/
//====================================================================

#define  CTWIN_P0R0_LOC15_MASK 0xc0000000
#define  CTWIN_P0R0_LOC15_SHIFT 30
#define  CTWIN_P0R0_LOC15_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC15_MASK) >> CTWIN_P0R0_LOC15_SHIFT)
#define  CTWIN_P0R0_LOC15_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC15_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC15_SHIFT))

#define  CTWIN_P0R0_LOC14_MASK 0x30000000
#define  CTWIN_P0R0_LOC14_SHIFT 28
#define  CTWIN_P0R0_LOC14_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC14_MASK) >> CTWIN_P0R0_LOC14_SHIFT)
#define  CTWIN_P0R0_LOC14_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC14_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC14_SHIFT))

#define  CTWIN_P0R0_LOC13_MASK 0xc000000
#define  CTWIN_P0R0_LOC13_SHIFT 26
#define  CTWIN_P0R0_LOC13_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC13_MASK) >> CTWIN_P0R0_LOC13_SHIFT)
#define  CTWIN_P0R0_LOC13_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC13_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC13_SHIFT))

#define  CTWIN_P0R0_LOC12_MASK 0x3000000
#define  CTWIN_P0R0_LOC12_SHIFT 24
#define  CTWIN_P0R0_LOC12_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC12_MASK) >> CTWIN_P0R0_LOC12_SHIFT)
#define  CTWIN_P0R0_LOC12_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC12_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC12_SHIFT))

#define  CTWIN_P0R0_LOC11_MASK 0xc00000
#define  CTWIN_P0R0_LOC11_SHIFT 22
#define  CTWIN_P0R0_LOC11_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC11_MASK) >> CTWIN_P0R0_LOC11_SHIFT)
#define  CTWIN_P0R0_LOC11_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC11_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC11_SHIFT))

#define  CTWIN_P0R0_LOC10_MASK 0x300000
#define  CTWIN_P0R0_LOC10_SHIFT 20
#define  CTWIN_P0R0_LOC10_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC10_MASK) >> CTWIN_P0R0_LOC10_SHIFT)
#define  CTWIN_P0R0_LOC10_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC10_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC10_SHIFT))

#define  CTWIN_P0R0_LOC9_MASK 0xc0000
#define  CTWIN_P0R0_LOC9_SHIFT 18
#define  CTWIN_P0R0_LOC9_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC9_MASK) >> CTWIN_P0R0_LOC9_SHIFT)
#define  CTWIN_P0R0_LOC9_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC9_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC9_SHIFT))

#define  CTWIN_P0R0_LOC8_MASK 0x30000
#define  CTWIN_P0R0_LOC8_SHIFT 16
#define  CTWIN_P0R0_LOC8_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC8_MASK) >> CTWIN_P0R0_LOC8_SHIFT)
#define  CTWIN_P0R0_LOC8_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC8_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC8_SHIFT))

#define  CTWIN_P0R0_LOC7_MASK 0xc000
#define  CTWIN_P0R0_LOC7_SHIFT 14
#define  CTWIN_P0R0_LOC7_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC7_MASK) >> CTWIN_P0R0_LOC7_SHIFT)
#define  CTWIN_P0R0_LOC7_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC7_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC7_SHIFT))

#define  CTWIN_P0R0_LOC6_MASK 0x3000
#define  CTWIN_P0R0_LOC6_SHIFT 12
#define  CTWIN_P0R0_LOC6_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC6_MASK) >> CTWIN_P0R0_LOC6_SHIFT)
#define  CTWIN_P0R0_LOC6_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC6_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC6_SHIFT))

#define  CTWIN_P0R0_LOC5_MASK 0xc00
#define  CTWIN_P0R0_LOC5_SHIFT 10
#define  CTWIN_P0R0_LOC5_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC5_MASK) >> CTWIN_P0R0_LOC5_SHIFT)
#define  CTWIN_P0R0_LOC5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC5_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC5_SHIFT))

#define  CTWIN_P0R0_LOC4_MASK 0x300
#define  CTWIN_P0R0_LOC4_SHIFT 8
#define  CTWIN_P0R0_LOC4_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC4_MASK) >> CTWIN_P0R0_LOC4_SHIFT)
#define  CTWIN_P0R0_LOC4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC4_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC4_SHIFT))

#define  CTWIN_P0R0_LOC3_MASK 0xc0
#define  CTWIN_P0R0_LOC3_SHIFT 6
#define  CTWIN_P0R0_LOC3_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC3_MASK) >> CTWIN_P0R0_LOC3_SHIFT)
#define  CTWIN_P0R0_LOC3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC3_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC3_SHIFT))

#define  CTWIN_P0R0_LOC2_MASK 0x30
#define  CTWIN_P0R0_LOC2_SHIFT 4
#define  CTWIN_P0R0_LOC2_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC2_MASK) >> CTWIN_P0R0_LOC2_SHIFT)
#define  CTWIN_P0R0_LOC2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC2_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC2_SHIFT))

#define  CTWIN_P0R0_LOC1_MASK 0xc
#define  CTWIN_P0R0_LOC1_SHIFT 2
#define  CTWIN_P0R0_LOC1_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC1_MASK) >> CTWIN_P0R0_LOC1_SHIFT)
#define  CTWIN_P0R0_LOC1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC1_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC1_SHIFT))

#define  CTWIN_P0R0_LOC0_MASK 0x3
#define  CTWIN_P0R0_LOC0_SHIFT 0
#define  CTWIN_P0R0_LOC0_MASK_SHIFT(reg) (((reg) & CTWIN_P0R0_LOC0_MASK) >> CTWIN_P0R0_LOC0_SHIFT)
#define  CTWIN_P0R0_LOC0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R0_LOC0_MASK) | (((uint32_t)val) << CTWIN_P0R0_LOC0_SHIFT))

//====================================================================
//Register: CTWIN Pattern 0 Register 1 (P0R1)
//====================================================================

#define  CTWIN_P0R1_LOC31_MASK 0xc0000000
#define  CTWIN_P0R1_LOC31_SHIFT 30
#define  CTWIN_P0R1_LOC31_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC31_MASK) >> CTWIN_P0R1_LOC31_SHIFT)
#define  CTWIN_P0R1_LOC31_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC31_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC31_SHIFT))

#define  CTWIN_P0R1_LOC30_MASK 0x30000000
#define  CTWIN_P0R1_LOC30_SHIFT 28
#define  CTWIN_P0R1_LOC30_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC30_MASK) >> CTWIN_P0R1_LOC30_SHIFT)
#define  CTWIN_P0R1_LOC30_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC30_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC30_SHIFT))

#define  CTWIN_P0R1_LOC29_MASK 0xc000000
#define  CTWIN_P0R1_LOC29_SHIFT 26
#define  CTWIN_P0R1_LOC29_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC29_MASK) >> CTWIN_P0R1_LOC29_SHIFT)
#define  CTWIN_P0R1_LOC29_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC29_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC29_SHIFT))

#define  CTWIN_P0R1_LOC28_MASK 0x3000000
#define  CTWIN_P0R1_LOC28_SHIFT 24
#define  CTWIN_P0R1_LOC28_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC28_MASK) >> CTWIN_P0R1_LOC28_SHIFT)
#define  CTWIN_P0R1_LOC28_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC28_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC28_SHIFT))

#define  CTWIN_P0R1_LOC27_MASK 0xc00000
#define  CTWIN_P0R1_LOC27_SHIFT 22
#define  CTWIN_P0R1_LOC27_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC27_MASK) >> CTWIN_P0R1_LOC27_SHIFT)
#define  CTWIN_P0R1_LOC27_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC27_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC27_SHIFT))

#define  CTWIN_P0R1_LOC26_MASK 0x300000
#define  CTWIN_P0R1_LOC26_SHIFT 20
#define  CTWIN_P0R1_LOC26_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC26_MASK) >> CTWIN_P0R1_LOC26_SHIFT)
#define  CTWIN_P0R1_LOC26_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC26_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC26_SHIFT))

#define  CTWIN_P0R1_LOC25_MASK 0xc0000
#define  CTWIN_P0R1_LOC25_SHIFT 18
#define  CTWIN_P0R1_LOC25_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC25_MASK) >> CTWIN_P0R1_LOC25_SHIFT)
#define  CTWIN_P0R1_LOC25_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC25_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC25_SHIFT))

#define  CTWIN_P0R1_LOC24_MASK 0x30000
#define  CTWIN_P0R1_LOC24_SHIFT 16
#define  CTWIN_P0R1_LOC24_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC24_MASK) >> CTWIN_P0R1_LOC24_SHIFT)
#define  CTWIN_P0R1_LOC24_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC24_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC24_SHIFT))

#define  CTWIN_P0R1_LOC23_MASK 0xc000
#define  CTWIN_P0R1_LOC23_SHIFT 14
#define  CTWIN_P0R1_LOC23_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC23_MASK) >> CTWIN_P0R1_LOC23_SHIFT)
#define  CTWIN_P0R1_LOC23_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC23_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC23_SHIFT))

#define  CTWIN_P0R1_LOC22_MASK 0x3000
#define  CTWIN_P0R1_LOC22_SHIFT 12
#define  CTWIN_P0R1_LOC22_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC22_MASK) >> CTWIN_P0R1_LOC22_SHIFT)
#define  CTWIN_P0R1_LOC22_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC22_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC22_SHIFT))

#define  CTWIN_P0R1_LOC21_MASK 0xc00
#define  CTWIN_P0R1_LOC21_SHIFT 10
#define  CTWIN_P0R1_LOC21_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC21_MASK) >> CTWIN_P0R1_LOC21_SHIFT)
#define  CTWIN_P0R1_LOC21_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC21_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC21_SHIFT))

#define  CTWIN_P0R1_LOC20_MASK 0x300
#define  CTWIN_P0R1_LOC20_SHIFT 8
#define  CTWIN_P0R1_LOC20_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC20_MASK) >> CTWIN_P0R1_LOC20_SHIFT)
#define  CTWIN_P0R1_LOC20_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC20_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC20_SHIFT))

#define  CTWIN_P0R1_LOC19_MASK 0xc0
#define  CTWIN_P0R1_LOC19_SHIFT 6
#define  CTWIN_P0R1_LOC19_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC19_MASK) >> CTWIN_P0R1_LOC19_SHIFT)
#define  CTWIN_P0R1_LOC19_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC19_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC19_SHIFT))

#define  CTWIN_P0R1_LOC18_MASK 0x30
#define  CTWIN_P0R1_LOC18_SHIFT 4
#define  CTWIN_P0R1_LOC18_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC18_MASK) >> CTWIN_P0R1_LOC18_SHIFT)
#define  CTWIN_P0R1_LOC18_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC18_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC18_SHIFT))

#define  CTWIN_P0R1_LOC17_MASK 0xc
#define  CTWIN_P0R1_LOC17_SHIFT 2
#define  CTWIN_P0R1_LOC17_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC17_MASK) >> CTWIN_P0R1_LOC17_SHIFT)
#define  CTWIN_P0R1_LOC17_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC17_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC17_SHIFT))

#define  CTWIN_P0R1_LOC16_MASK 0x3
#define  CTWIN_P0R1_LOC16_SHIFT 0
#define  CTWIN_P0R1_LOC16_MASK_SHIFT(reg) (((reg) & CTWIN_P0R1_LOC16_MASK) >> CTWIN_P0R1_LOC16_SHIFT)
#define  CTWIN_P0R1_LOC16_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R1_LOC16_MASK) | (((uint32_t)val) << CTWIN_P0R1_LOC16_SHIFT))

//====================================================================
//Register: CTWIN Pattern 0 Register 2 (P0R2)
//====================================================================

#define  CTWIN_P0R2_LOC47_MASK 0xc0000000
#define  CTWIN_P0R2_LOC47_SHIFT 30
#define  CTWIN_P0R2_LOC47_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC47_MASK) >> CTWIN_P0R2_LOC47_SHIFT)
#define  CTWIN_P0R2_LOC47_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC47_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC47_SHIFT))

#define  CTWIN_P0R2_LOC46_MASK 0x30000000
#define  CTWIN_P0R2_LOC46_SHIFT 28
#define  CTWIN_P0R2_LOC46_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC46_MASK) >> CTWIN_P0R2_LOC46_SHIFT)
#define  CTWIN_P0R2_LOC46_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC46_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC46_SHIFT))

#define  CTWIN_P0R2_LOC45_MASK 0xc000000
#define  CTWIN_P0R2_LOC45_SHIFT 26
#define  CTWIN_P0R2_LOC45_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC45_MASK) >> CTWIN_P0R2_LOC45_SHIFT)
#define  CTWIN_P0R2_LOC45_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC45_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC45_SHIFT))

#define  CTWIN_P0R2_LOC44_MASK 0x3000000
#define  CTWIN_P0R2_LOC44_SHIFT 24
#define  CTWIN_P0R2_LOC44_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC44_MASK) >> CTWIN_P0R2_LOC44_SHIFT)
#define  CTWIN_P0R2_LOC44_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC44_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC44_SHIFT))

#define  CTWIN_P0R2_LOC43_MASK 0xc00000
#define  CTWIN_P0R2_LOC43_SHIFT 22
#define  CTWIN_P0R2_LOC43_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC43_MASK) >> CTWIN_P0R2_LOC43_SHIFT)
#define  CTWIN_P0R2_LOC43_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC43_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC43_SHIFT))

#define  CTWIN_P0R2_LOC42_MASK 0x300000
#define  CTWIN_P0R2_LOC42_SHIFT 20
#define  CTWIN_P0R2_LOC42_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC42_MASK) >> CTWIN_P0R2_LOC42_SHIFT)
#define  CTWIN_P0R2_LOC42_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC42_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC42_SHIFT))

#define  CTWIN_P0R2_LOC41_MASK 0xc0000
#define  CTWIN_P0R2_LOC41_SHIFT 18
#define  CTWIN_P0R2_LOC41_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC41_MASK) >> CTWIN_P0R2_LOC41_SHIFT)
#define  CTWIN_P0R2_LOC41_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC41_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC41_SHIFT))

#define  CTWIN_P0R2_LOC40_MASK 0x30000
#define  CTWIN_P0R2_LOC40_SHIFT 16
#define  CTWIN_P0R2_LOC40_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC40_MASK) >> CTWIN_P0R2_LOC40_SHIFT)
#define  CTWIN_P0R2_LOC40_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC40_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC40_SHIFT))

#define  CTWIN_P0R2_LOC39_MASK 0xc000
#define  CTWIN_P0R2_LOC39_SHIFT 14
#define  CTWIN_P0R2_LOC39_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC39_MASK) >> CTWIN_P0R2_LOC39_SHIFT)
#define  CTWIN_P0R2_LOC39_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC39_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC39_SHIFT))

#define  CTWIN_P0R2_LOC38_MASK 0x3000
#define  CTWIN_P0R2_LOC38_SHIFT 12
#define  CTWIN_P0R2_LOC38_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC38_MASK) >> CTWIN_P0R2_LOC38_SHIFT)
#define  CTWIN_P0R2_LOC38_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC38_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC38_SHIFT))

#define  CTWIN_P0R2_LOC37_MASK 0xc00
#define  CTWIN_P0R2_LOC37_SHIFT 10
#define  CTWIN_P0R2_LOC37_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC37_MASK) >> CTWIN_P0R2_LOC37_SHIFT)
#define  CTWIN_P0R2_LOC37_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC37_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC37_SHIFT))

#define  CTWIN_P0R2_LOC36_MASK 0x300
#define  CTWIN_P0R2_LOC36_SHIFT 8
#define  CTWIN_P0R2_LOC36_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC36_MASK) >> CTWIN_P0R2_LOC36_SHIFT)
#define  CTWIN_P0R2_LOC36_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC36_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC36_SHIFT))

#define  CTWIN_P0R2_LOC35_MASK 0xc0
#define  CTWIN_P0R2_LOC35_SHIFT 6
#define  CTWIN_P0R2_LOC35_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC35_MASK) >> CTWIN_P0R2_LOC35_SHIFT)
#define  CTWIN_P0R2_LOC35_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC35_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC35_SHIFT))

#define  CTWIN_P0R2_LOC34_MASK 0x30
#define  CTWIN_P0R2_LOC34_SHIFT 4
#define  CTWIN_P0R2_LOC34_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC34_MASK) >> CTWIN_P0R2_LOC34_SHIFT)
#define  CTWIN_P0R2_LOC34_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC34_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC34_SHIFT))

#define  CTWIN_P0R2_LOC33_MASK 0xc
#define  CTWIN_P0R2_LOC33_SHIFT 2
#define  CTWIN_P0R2_LOC33_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC33_MASK) >> CTWIN_P0R2_LOC33_SHIFT)
#define  CTWIN_P0R2_LOC33_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC33_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC33_SHIFT))

#define  CTWIN_P0R2_LOC32_MASK 0x3
#define  CTWIN_P0R2_LOC32_SHIFT 0
#define  CTWIN_P0R2_LOC32_MASK_SHIFT(reg) (((reg) & CTWIN_P0R2_LOC32_MASK) >> CTWIN_P0R2_LOC32_SHIFT)
#define  CTWIN_P0R2_LOC32_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R2_LOC32_MASK) | (((uint32_t)val) << CTWIN_P0R2_LOC32_SHIFT))

//====================================================================
//Register: CTWIN Pattern 0 Register 3 (P0R3)
//====================================================================

#define  CTWIN_P0R3_RESERVED1_MASK 0xfffffffc
#define  CTWIN_P0R3_RESERVED1_SHIFT 2
#define  CTWIN_P0R3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_P0R3_RESERVED1_MASK) >> CTWIN_P0R3_RESERVED1_SHIFT)
#define  CTWIN_P0R3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_P0R3_RESERVED1_SHIFT))

#define  CTWIN_P0R3_LOC48_MASK 0x3
#define  CTWIN_P0R3_LOC48_SHIFT 0
#define  CTWIN_P0R3_LOC48_MASK_SHIFT(reg) (((reg) & CTWIN_P0R3_LOC48_MASK) >> CTWIN_P0R3_LOC48_SHIFT)
#define  CTWIN_P0R3_LOC48_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P0R3_LOC48_MASK) | (((uint32_t)val) << CTWIN_P0R3_LOC48_SHIFT))

//====================================================================
//Register: CTWIN Pattern 1 Register 0 (P1R0)
/** \brief Each programmable pattern is implemented as a 7x7 array which is implemented with a set of 4 registers. There are 2 bits associated with each location in the window, with a 0 meaning the window must have a 0 in the zero-threshold bit, 1 meaning there must be a 1 in the one-threshold bit and 2 or 3 meaning the location in the window is a don't care. Each two bit field     represents a location in the 7x7 array. It is numbered as follows: <br/>     <table align="left">     <tr><td>0  </td ><td>1  </td ><td>2  </td 
              <td>3 </td ><td>4 </td ><td>5 </td
              <td>6 </td ></tr> <tr><td>7 </td ><td>8 </td ><td>9 </td
              <td>10 </td ><td>11 </td ><td>12 </td
              <td>13 </td ></tr> <tr><td>14 </td ><td>15 </td ><td>16 </td
              <td>17 </td ><td>18 </td ><td>19 </td
              <td>20 </td ></tr> <tr><td>21 </td ><td>22 </td ><td>23 </td
              <td>24 </td ><td>25 </td ><td>26 </td
              <td>27 </td ></tr> <tr><td>28 </td ><td>29 </td ><td>30 </td
              <td>31 </td ><td>32 </td ><td>33 </td
              <td>34 </td ></tr> <tr><td>35 </td ><td>36 </td ><td>37 </td
              <td>38 </td ><td>39 </td ><td>40 </td
              <td>41 </td ></tr> <tr><td>42 </td ><td>43 </td ><td>44 </td
              <td>45 </td ><td>46 </td ><td>47 </td
              <td>48 </td ></tr> </table>*/
//====================================================================

#define  CTWIN_P1R0_LOC15_MASK 0xc0000000
#define  CTWIN_P1R0_LOC15_SHIFT 30
#define  CTWIN_P1R0_LOC15_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC15_MASK) >> CTWIN_P1R0_LOC15_SHIFT)
#define  CTWIN_P1R0_LOC15_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC15_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC15_SHIFT))

#define  CTWIN_P1R0_LOC14_MASK 0x30000000
#define  CTWIN_P1R0_LOC14_SHIFT 28
#define  CTWIN_P1R0_LOC14_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC14_MASK) >> CTWIN_P1R0_LOC14_SHIFT)
#define  CTWIN_P1R0_LOC14_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC14_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC14_SHIFT))

#define  CTWIN_P1R0_LOC13_MASK 0xc000000
#define  CTWIN_P1R0_LOC13_SHIFT 26
#define  CTWIN_P1R0_LOC13_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC13_MASK) >> CTWIN_P1R0_LOC13_SHIFT)
#define  CTWIN_P1R0_LOC13_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC13_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC13_SHIFT))

#define  CTWIN_P1R0_LOC12_MASK 0x3000000
#define  CTWIN_P1R0_LOC12_SHIFT 24
#define  CTWIN_P1R0_LOC12_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC12_MASK) >> CTWIN_P1R0_LOC12_SHIFT)
#define  CTWIN_P1R0_LOC12_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC12_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC12_SHIFT))

#define  CTWIN_P1R0_LOC11_MASK 0xc00000
#define  CTWIN_P1R0_LOC11_SHIFT 22
#define  CTWIN_P1R0_LOC11_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC11_MASK) >> CTWIN_P1R0_LOC11_SHIFT)
#define  CTWIN_P1R0_LOC11_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC11_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC11_SHIFT))

#define  CTWIN_P1R0_LOC10_MASK 0x300000
#define  CTWIN_P1R0_LOC10_SHIFT 20
#define  CTWIN_P1R0_LOC10_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC10_MASK) >> CTWIN_P1R0_LOC10_SHIFT)
#define  CTWIN_P1R0_LOC10_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC10_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC10_SHIFT))

#define  CTWIN_P1R0_LOC9_MASK 0xc0000
#define  CTWIN_P1R0_LOC9_SHIFT 18
#define  CTWIN_P1R0_LOC9_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC9_MASK) >> CTWIN_P1R0_LOC9_SHIFT)
#define  CTWIN_P1R0_LOC9_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC9_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC9_SHIFT))

#define  CTWIN_P1R0_LOC8_MASK 0x30000
#define  CTWIN_P1R0_LOC8_SHIFT 16
#define  CTWIN_P1R0_LOC8_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC8_MASK) >> CTWIN_P1R0_LOC8_SHIFT)
#define  CTWIN_P1R0_LOC8_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC8_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC8_SHIFT))

#define  CTWIN_P1R0_LOC7_MASK 0xc000
#define  CTWIN_P1R0_LOC7_SHIFT 14
#define  CTWIN_P1R0_LOC7_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC7_MASK) >> CTWIN_P1R0_LOC7_SHIFT)
#define  CTWIN_P1R0_LOC7_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC7_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC7_SHIFT))

#define  CTWIN_P1R0_LOC6_MASK 0x3000
#define  CTWIN_P1R0_LOC6_SHIFT 12
#define  CTWIN_P1R0_LOC6_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC6_MASK) >> CTWIN_P1R0_LOC6_SHIFT)
#define  CTWIN_P1R0_LOC6_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC6_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC6_SHIFT))

#define  CTWIN_P1R0_LOC5_MASK 0xc00
#define  CTWIN_P1R0_LOC5_SHIFT 10
#define  CTWIN_P1R0_LOC5_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC5_MASK) >> CTWIN_P1R0_LOC5_SHIFT)
#define  CTWIN_P1R0_LOC5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC5_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC5_SHIFT))

#define  CTWIN_P1R0_LOC4_MASK 0x300
#define  CTWIN_P1R0_LOC4_SHIFT 8
#define  CTWIN_P1R0_LOC4_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC4_MASK) >> CTWIN_P1R0_LOC4_SHIFT)
#define  CTWIN_P1R0_LOC4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC4_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC4_SHIFT))

#define  CTWIN_P1R0_LOC3_MASK 0xc0
#define  CTWIN_P1R0_LOC3_SHIFT 6
#define  CTWIN_P1R0_LOC3_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC3_MASK) >> CTWIN_P1R0_LOC3_SHIFT)
#define  CTWIN_P1R0_LOC3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC3_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC3_SHIFT))

#define  CTWIN_P1R0_LOC2_MASK 0x30
#define  CTWIN_P1R0_LOC2_SHIFT 4
#define  CTWIN_P1R0_LOC2_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC2_MASK) >> CTWIN_P1R0_LOC2_SHIFT)
#define  CTWIN_P1R0_LOC2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC2_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC2_SHIFT))

#define  CTWIN_P1R0_LOC1_MASK 0xc
#define  CTWIN_P1R0_LOC1_SHIFT 2
#define  CTWIN_P1R0_LOC1_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC1_MASK) >> CTWIN_P1R0_LOC1_SHIFT)
#define  CTWIN_P1R0_LOC1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC1_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC1_SHIFT))

#define  CTWIN_P1R0_LOC0_MASK 0x3
#define  CTWIN_P1R0_LOC0_SHIFT 0
#define  CTWIN_P1R0_LOC0_MASK_SHIFT(reg) (((reg) & CTWIN_P1R0_LOC0_MASK) >> CTWIN_P1R0_LOC0_SHIFT)
#define  CTWIN_P1R0_LOC0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R0_LOC0_MASK) | (((uint32_t)val) << CTWIN_P1R0_LOC0_SHIFT))

//====================================================================
//Register: CTWIN Pattern 1 Register 1 (P1R1)
//====================================================================

#define  CTWIN_P1R1_LOC31_MASK 0xc0000000
#define  CTWIN_P1R1_LOC31_SHIFT 30
#define  CTWIN_P1R1_LOC31_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC31_MASK) >> CTWIN_P1R1_LOC31_SHIFT)
#define  CTWIN_P1R1_LOC31_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC31_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC31_SHIFT))

#define  CTWIN_P1R1_LOC30_MASK 0x30000000
#define  CTWIN_P1R1_LOC30_SHIFT 28
#define  CTWIN_P1R1_LOC30_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC30_MASK) >> CTWIN_P1R1_LOC30_SHIFT)
#define  CTWIN_P1R1_LOC30_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC30_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC30_SHIFT))

#define  CTWIN_P1R1_LOC29_MASK 0xc000000
#define  CTWIN_P1R1_LOC29_SHIFT 26
#define  CTWIN_P1R1_LOC29_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC29_MASK) >> CTWIN_P1R1_LOC29_SHIFT)
#define  CTWIN_P1R1_LOC29_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC29_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC29_SHIFT))

#define  CTWIN_P1R1_LOC28_MASK 0x3000000
#define  CTWIN_P1R1_LOC28_SHIFT 24
#define  CTWIN_P1R1_LOC28_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC28_MASK) >> CTWIN_P1R1_LOC28_SHIFT)
#define  CTWIN_P1R1_LOC28_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC28_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC28_SHIFT))

#define  CTWIN_P1R1_LOC27_MASK 0xc00000
#define  CTWIN_P1R1_LOC27_SHIFT 22
#define  CTWIN_P1R1_LOC27_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC27_MASK) >> CTWIN_P1R1_LOC27_SHIFT)
#define  CTWIN_P1R1_LOC27_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC27_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC27_SHIFT))

#define  CTWIN_P1R1_LOC26_MASK 0x300000
#define  CTWIN_P1R1_LOC26_SHIFT 20
#define  CTWIN_P1R1_LOC26_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC26_MASK) >> CTWIN_P1R1_LOC26_SHIFT)
#define  CTWIN_P1R1_LOC26_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC26_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC26_SHIFT))

#define  CTWIN_P1R1_LOC25_MASK 0xc0000
#define  CTWIN_P1R1_LOC25_SHIFT 18
#define  CTWIN_P1R1_LOC25_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC25_MASK) >> CTWIN_P1R1_LOC25_SHIFT)
#define  CTWIN_P1R1_LOC25_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC25_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC25_SHIFT))

#define  CTWIN_P1R1_LOC24_MASK 0x30000
#define  CTWIN_P1R1_LOC24_SHIFT 16
#define  CTWIN_P1R1_LOC24_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC24_MASK) >> CTWIN_P1R1_LOC24_SHIFT)
#define  CTWIN_P1R1_LOC24_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC24_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC24_SHIFT))

#define  CTWIN_P1R1_LOC23_MASK 0xc000
#define  CTWIN_P1R1_LOC23_SHIFT 14
#define  CTWIN_P1R1_LOC23_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC23_MASK) >> CTWIN_P1R1_LOC23_SHIFT)
#define  CTWIN_P1R1_LOC23_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC23_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC23_SHIFT))

#define  CTWIN_P1R1_LOC22_MASK 0x3000
#define  CTWIN_P1R1_LOC22_SHIFT 12
#define  CTWIN_P1R1_LOC22_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC22_MASK) >> CTWIN_P1R1_LOC22_SHIFT)
#define  CTWIN_P1R1_LOC22_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC22_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC22_SHIFT))

#define  CTWIN_P1R1_LOC21_MASK 0xc00
#define  CTWIN_P1R1_LOC21_SHIFT 10
#define  CTWIN_P1R1_LOC21_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC21_MASK) >> CTWIN_P1R1_LOC21_SHIFT)
#define  CTWIN_P1R1_LOC21_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC21_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC21_SHIFT))

#define  CTWIN_P1R1_LOC20_MASK 0x300
#define  CTWIN_P1R1_LOC20_SHIFT 8
#define  CTWIN_P1R1_LOC20_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC20_MASK) >> CTWIN_P1R1_LOC20_SHIFT)
#define  CTWIN_P1R1_LOC20_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC20_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC20_SHIFT))

#define  CTWIN_P1R1_LOC19_MASK 0xc0
#define  CTWIN_P1R1_LOC19_SHIFT 6
#define  CTWIN_P1R1_LOC19_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC19_MASK) >> CTWIN_P1R1_LOC19_SHIFT)
#define  CTWIN_P1R1_LOC19_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC19_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC19_SHIFT))

#define  CTWIN_P1R1_LOC18_MASK 0x30
#define  CTWIN_P1R1_LOC18_SHIFT 4
#define  CTWIN_P1R1_LOC18_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC18_MASK) >> CTWIN_P1R1_LOC18_SHIFT)
#define  CTWIN_P1R1_LOC18_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC18_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC18_SHIFT))

#define  CTWIN_P1R1_LOC17_MASK 0xc
#define  CTWIN_P1R1_LOC17_SHIFT 2
#define  CTWIN_P1R1_LOC17_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC17_MASK) >> CTWIN_P1R1_LOC17_SHIFT)
#define  CTWIN_P1R1_LOC17_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC17_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC17_SHIFT))

#define  CTWIN_P1R1_LOC16_MASK 0x3
#define  CTWIN_P1R1_LOC16_SHIFT 0
#define  CTWIN_P1R1_LOC16_MASK_SHIFT(reg) (((reg) & CTWIN_P1R1_LOC16_MASK) >> CTWIN_P1R1_LOC16_SHIFT)
#define  CTWIN_P1R1_LOC16_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R1_LOC16_MASK) | (((uint32_t)val) << CTWIN_P1R1_LOC16_SHIFT))

//====================================================================
//Register: CTWIN Pattern 1 Register 2 (P1R2)
//====================================================================

#define  CTWIN_P1R2_LOC47_MASK 0xc0000000
#define  CTWIN_P1R2_LOC47_SHIFT 30
#define  CTWIN_P1R2_LOC47_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC47_MASK) >> CTWIN_P1R2_LOC47_SHIFT)
#define  CTWIN_P1R2_LOC47_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC47_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC47_SHIFT))

#define  CTWIN_P1R2_LOC46_MASK 0x30000000
#define  CTWIN_P1R2_LOC46_SHIFT 28
#define  CTWIN_P1R2_LOC46_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC46_MASK) >> CTWIN_P1R2_LOC46_SHIFT)
#define  CTWIN_P1R2_LOC46_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC46_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC46_SHIFT))

#define  CTWIN_P1R2_LOC45_MASK 0xc000000
#define  CTWIN_P1R2_LOC45_SHIFT 26
#define  CTWIN_P1R2_LOC45_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC45_MASK) >> CTWIN_P1R2_LOC45_SHIFT)
#define  CTWIN_P1R2_LOC45_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC45_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC45_SHIFT))

#define  CTWIN_P1R2_LOC44_MASK 0x3000000
#define  CTWIN_P1R2_LOC44_SHIFT 24
#define  CTWIN_P1R2_LOC44_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC44_MASK) >> CTWIN_P1R2_LOC44_SHIFT)
#define  CTWIN_P1R2_LOC44_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC44_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC44_SHIFT))

#define  CTWIN_P1R2_LOC43_MASK 0xc00000
#define  CTWIN_P1R2_LOC43_SHIFT 22
#define  CTWIN_P1R2_LOC43_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC43_MASK) >> CTWIN_P1R2_LOC43_SHIFT)
#define  CTWIN_P1R2_LOC43_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC43_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC43_SHIFT))

#define  CTWIN_P1R2_LOC42_MASK 0x300000
#define  CTWIN_P1R2_LOC42_SHIFT 20
#define  CTWIN_P1R2_LOC42_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC42_MASK) >> CTWIN_P1R2_LOC42_SHIFT)
#define  CTWIN_P1R2_LOC42_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC42_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC42_SHIFT))

#define  CTWIN_P1R2_LOC41_MASK 0xc0000
#define  CTWIN_P1R2_LOC41_SHIFT 18
#define  CTWIN_P1R2_LOC41_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC41_MASK) >> CTWIN_P1R2_LOC41_SHIFT)
#define  CTWIN_P1R2_LOC41_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC41_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC41_SHIFT))

#define  CTWIN_P1R2_LOC40_MASK 0x30000
#define  CTWIN_P1R2_LOC40_SHIFT 16
#define  CTWIN_P1R2_LOC40_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC40_MASK) >> CTWIN_P1R2_LOC40_SHIFT)
#define  CTWIN_P1R2_LOC40_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC40_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC40_SHIFT))

#define  CTWIN_P1R2_LOC39_MASK 0xc000
#define  CTWIN_P1R2_LOC39_SHIFT 14
#define  CTWIN_P1R2_LOC39_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC39_MASK) >> CTWIN_P1R2_LOC39_SHIFT)
#define  CTWIN_P1R2_LOC39_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC39_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC39_SHIFT))

#define  CTWIN_P1R2_LOC38_MASK 0x3000
#define  CTWIN_P1R2_LOC38_SHIFT 12
#define  CTWIN_P1R2_LOC38_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC38_MASK) >> CTWIN_P1R2_LOC38_SHIFT)
#define  CTWIN_P1R2_LOC38_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC38_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC38_SHIFT))

#define  CTWIN_P1R2_LOC37_MASK 0xc00
#define  CTWIN_P1R2_LOC37_SHIFT 10
#define  CTWIN_P1R2_LOC37_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC37_MASK) >> CTWIN_P1R2_LOC37_SHIFT)
#define  CTWIN_P1R2_LOC37_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC37_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC37_SHIFT))

#define  CTWIN_P1R2_LOC36_MASK 0x300
#define  CTWIN_P1R2_LOC36_SHIFT 8
#define  CTWIN_P1R2_LOC36_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC36_MASK) >> CTWIN_P1R2_LOC36_SHIFT)
#define  CTWIN_P1R2_LOC36_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC36_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC36_SHIFT))

#define  CTWIN_P1R2_LOC35_MASK 0xc0
#define  CTWIN_P1R2_LOC35_SHIFT 6
#define  CTWIN_P1R2_LOC35_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC35_MASK) >> CTWIN_P1R2_LOC35_SHIFT)
#define  CTWIN_P1R2_LOC35_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC35_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC35_SHIFT))

#define  CTWIN_P1R2_LOC34_MASK 0x30
#define  CTWIN_P1R2_LOC34_SHIFT 4
#define  CTWIN_P1R2_LOC34_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC34_MASK) >> CTWIN_P1R2_LOC34_SHIFT)
#define  CTWIN_P1R2_LOC34_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC34_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC34_SHIFT))

#define  CTWIN_P1R2_LOC33_MASK 0xc
#define  CTWIN_P1R2_LOC33_SHIFT 2
#define  CTWIN_P1R2_LOC33_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC33_MASK) >> CTWIN_P1R2_LOC33_SHIFT)
#define  CTWIN_P1R2_LOC33_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC33_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC33_SHIFT))

#define  CTWIN_P1R2_LOC32_MASK 0x3
#define  CTWIN_P1R2_LOC32_SHIFT 0
#define  CTWIN_P1R2_LOC32_MASK_SHIFT(reg) (((reg) & CTWIN_P1R2_LOC32_MASK) >> CTWIN_P1R2_LOC32_SHIFT)
#define  CTWIN_P1R2_LOC32_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R2_LOC32_MASK) | (((uint32_t)val) << CTWIN_P1R2_LOC32_SHIFT))

//====================================================================
//Register: CTWIN Pattern 1 Register 3 (P1R3)
//====================================================================

#define  CTWIN_P1R3_RESERVED1_MASK 0xfffffffc
#define  CTWIN_P1R3_RESERVED1_SHIFT 2
#define  CTWIN_P1R3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_P1R3_RESERVED1_MASK) >> CTWIN_P1R3_RESERVED1_SHIFT)
#define  CTWIN_P1R3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_P1R3_RESERVED1_SHIFT))

#define  CTWIN_P1R3_LOC48_MASK 0x3
#define  CTWIN_P1R3_LOC48_SHIFT 0
#define  CTWIN_P1R3_LOC48_MASK_SHIFT(reg) (((reg) & CTWIN_P1R3_LOC48_MASK) >> CTWIN_P1R3_LOC48_SHIFT)
#define  CTWIN_P1R3_LOC48_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P1R3_LOC48_MASK) | (((uint32_t)val) << CTWIN_P1R3_LOC48_SHIFT))

//====================================================================
//Register: CTWIN Pattern 2 Register 0 (P2R0)
/** \brief Each programmable pattern is implemented as a 7x7 array which is implemented with a set of 4 registers. There are 2 bits associated with each location in the window, with a 0 meaning the window must have a 0 in the zero-threshold bit, 1 meaning there must be a 1 in the one-threshold bit and 2 or 3 meaning the location in the window is a don't care. Each two bit field     represents a location in the 7x7 array. It is numbered as follows: <br/>     <table align="left">     <tr><td>0  </td ><td>1  </td ><td>2  </td 
              <td>3 </td ><td>4 </td ><td>5 </td
              <td>6 </td ></tr> <tr><td>7 </td ><td>8 </td ><td>9 </td
              <td>10 </td ><td>11 </td ><td>12 </td
              <td>13 </td ></tr> <tr><td>14 </td ><td>15 </td ><td>16 </td
              <td>17 </td ><td>18 </td ><td>19 </td
              <td>20 </td ></tr> <tr><td>21 </td ><td>22 </td ><td>23 </td
              <td>24 </td ><td>25 </td ><td>26 </td
              <td>27 </td ></tr> <tr><td>28 </td ><td>29 </td ><td>30 </td
              <td>31 </td ><td>32 </td ><td>33 </td
              <td>34 </td ></tr> <tr><td>35 </td ><td>36 </td ><td>37 </td
              <td>38 </td ><td>39 </td ><td>40 </td
              <td>41 </td ></tr> <tr><td>42 </td ><td>43 </td ><td>44 </td
              <td>45 </td ><td>46 </td ><td>47 </td
              <td>48 </td ></tr> </table>*/
//====================================================================

#define  CTWIN_P2R0_LOC15_MASK 0xc0000000
#define  CTWIN_P2R0_LOC15_SHIFT 30
#define  CTWIN_P2R0_LOC15_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC15_MASK) >> CTWIN_P2R0_LOC15_SHIFT)
#define  CTWIN_P2R0_LOC15_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC15_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC15_SHIFT))

#define  CTWIN_P2R0_LOC14_MASK 0x30000000
#define  CTWIN_P2R0_LOC14_SHIFT 28
#define  CTWIN_P2R0_LOC14_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC14_MASK) >> CTWIN_P2R0_LOC14_SHIFT)
#define  CTWIN_P2R0_LOC14_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC14_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC14_SHIFT))

#define  CTWIN_P2R0_LOC13_MASK 0xc000000
#define  CTWIN_P2R0_LOC13_SHIFT 26
#define  CTWIN_P2R0_LOC13_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC13_MASK) >> CTWIN_P2R0_LOC13_SHIFT)
#define  CTWIN_P2R0_LOC13_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC13_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC13_SHIFT))

#define  CTWIN_P2R0_LOC12_MASK 0x3000000
#define  CTWIN_P2R0_LOC12_SHIFT 24
#define  CTWIN_P2R0_LOC12_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC12_MASK) >> CTWIN_P2R0_LOC12_SHIFT)
#define  CTWIN_P2R0_LOC12_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC12_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC12_SHIFT))

#define  CTWIN_P2R0_LOC11_MASK 0xc00000
#define  CTWIN_P2R0_LOC11_SHIFT 22
#define  CTWIN_P2R0_LOC11_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC11_MASK) >> CTWIN_P2R0_LOC11_SHIFT)
#define  CTWIN_P2R0_LOC11_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC11_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC11_SHIFT))

#define  CTWIN_P2R0_LOC10_MASK 0x300000
#define  CTWIN_P2R0_LOC10_SHIFT 20
#define  CTWIN_P2R0_LOC10_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC10_MASK) >> CTWIN_P2R0_LOC10_SHIFT)
#define  CTWIN_P2R0_LOC10_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC10_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC10_SHIFT))

#define  CTWIN_P2R0_LOC9_MASK 0xc0000
#define  CTWIN_P2R0_LOC9_SHIFT 18
#define  CTWIN_P2R0_LOC9_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC9_MASK) >> CTWIN_P2R0_LOC9_SHIFT)
#define  CTWIN_P2R0_LOC9_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC9_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC9_SHIFT))

#define  CTWIN_P2R0_LOC8_MASK 0x30000
#define  CTWIN_P2R0_LOC8_SHIFT 16
#define  CTWIN_P2R0_LOC8_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC8_MASK) >> CTWIN_P2R0_LOC8_SHIFT)
#define  CTWIN_P2R0_LOC8_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC8_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC8_SHIFT))

#define  CTWIN_P2R0_LOC7_MASK 0xc000
#define  CTWIN_P2R0_LOC7_SHIFT 14
#define  CTWIN_P2R0_LOC7_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC7_MASK) >> CTWIN_P2R0_LOC7_SHIFT)
#define  CTWIN_P2R0_LOC7_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC7_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC7_SHIFT))

#define  CTWIN_P2R0_LOC6_MASK 0x3000
#define  CTWIN_P2R0_LOC6_SHIFT 12
#define  CTWIN_P2R0_LOC6_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC6_MASK) >> CTWIN_P2R0_LOC6_SHIFT)
#define  CTWIN_P2R0_LOC6_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC6_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC6_SHIFT))

#define  CTWIN_P2R0_LOC5_MASK 0xc00
#define  CTWIN_P2R0_LOC5_SHIFT 10
#define  CTWIN_P2R0_LOC5_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC5_MASK) >> CTWIN_P2R0_LOC5_SHIFT)
#define  CTWIN_P2R0_LOC5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC5_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC5_SHIFT))

#define  CTWIN_P2R0_LOC4_MASK 0x300
#define  CTWIN_P2R0_LOC4_SHIFT 8
#define  CTWIN_P2R0_LOC4_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC4_MASK) >> CTWIN_P2R0_LOC4_SHIFT)
#define  CTWIN_P2R0_LOC4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC4_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC4_SHIFT))

#define  CTWIN_P2R0_LOC3_MASK 0xc0
#define  CTWIN_P2R0_LOC3_SHIFT 6
#define  CTWIN_P2R0_LOC3_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC3_MASK) >> CTWIN_P2R0_LOC3_SHIFT)
#define  CTWIN_P2R0_LOC3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC3_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC3_SHIFT))

#define  CTWIN_P2R0_LOC2_MASK 0x30
#define  CTWIN_P2R0_LOC2_SHIFT 4
#define  CTWIN_P2R0_LOC2_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC2_MASK) >> CTWIN_P2R0_LOC2_SHIFT)
#define  CTWIN_P2R0_LOC2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC2_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC2_SHIFT))

#define  CTWIN_P2R0_LOC1_MASK 0xc
#define  CTWIN_P2R0_LOC1_SHIFT 2
#define  CTWIN_P2R0_LOC1_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC1_MASK) >> CTWIN_P2R0_LOC1_SHIFT)
#define  CTWIN_P2R0_LOC1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC1_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC1_SHIFT))

#define  CTWIN_P2R0_LOC0_MASK 0x3
#define  CTWIN_P2R0_LOC0_SHIFT 0
#define  CTWIN_P2R0_LOC0_MASK_SHIFT(reg) (((reg) & CTWIN_P2R0_LOC0_MASK) >> CTWIN_P2R0_LOC0_SHIFT)
#define  CTWIN_P2R0_LOC0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R0_LOC0_MASK) | (((uint32_t)val) << CTWIN_P2R0_LOC0_SHIFT))

//====================================================================
//Register: CTWIN Pattern 2 Register 1 (P2R1)
//====================================================================

#define  CTWIN_P2R1_LOC31_MASK 0xc0000000
#define  CTWIN_P2R1_LOC31_SHIFT 30
#define  CTWIN_P2R1_LOC31_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC31_MASK) >> CTWIN_P2R1_LOC31_SHIFT)
#define  CTWIN_P2R1_LOC31_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC31_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC31_SHIFT))

#define  CTWIN_P2R1_LOC30_MASK 0x30000000
#define  CTWIN_P2R1_LOC30_SHIFT 28
#define  CTWIN_P2R1_LOC30_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC30_MASK) >> CTWIN_P2R1_LOC30_SHIFT)
#define  CTWIN_P2R1_LOC30_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC30_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC30_SHIFT))

#define  CTWIN_P2R1_LOC29_MASK 0xc000000
#define  CTWIN_P2R1_LOC29_SHIFT 26
#define  CTWIN_P2R1_LOC29_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC29_MASK) >> CTWIN_P2R1_LOC29_SHIFT)
#define  CTWIN_P2R1_LOC29_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC29_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC29_SHIFT))

#define  CTWIN_P2R1_LOC28_MASK 0x3000000
#define  CTWIN_P2R1_LOC28_SHIFT 24
#define  CTWIN_P2R1_LOC28_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC28_MASK) >> CTWIN_P2R1_LOC28_SHIFT)
#define  CTWIN_P2R1_LOC28_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC28_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC28_SHIFT))

#define  CTWIN_P2R1_LOC27_MASK 0xc00000
#define  CTWIN_P2R1_LOC27_SHIFT 22
#define  CTWIN_P2R1_LOC27_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC27_MASK) >> CTWIN_P2R1_LOC27_SHIFT)
#define  CTWIN_P2R1_LOC27_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC27_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC27_SHIFT))

#define  CTWIN_P2R1_LOC26_MASK 0x300000
#define  CTWIN_P2R1_LOC26_SHIFT 20
#define  CTWIN_P2R1_LOC26_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC26_MASK) >> CTWIN_P2R1_LOC26_SHIFT)
#define  CTWIN_P2R1_LOC26_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC26_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC26_SHIFT))

#define  CTWIN_P2R1_LOC25_MASK 0xc0000
#define  CTWIN_P2R1_LOC25_SHIFT 18
#define  CTWIN_P2R1_LOC25_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC25_MASK) >> CTWIN_P2R1_LOC25_SHIFT)
#define  CTWIN_P2R1_LOC25_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC25_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC25_SHIFT))

#define  CTWIN_P2R1_LOC24_MASK 0x30000
#define  CTWIN_P2R1_LOC24_SHIFT 16
#define  CTWIN_P2R1_LOC24_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC24_MASK) >> CTWIN_P2R1_LOC24_SHIFT)
#define  CTWIN_P2R1_LOC24_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC24_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC24_SHIFT))

#define  CTWIN_P2R1_LOC23_MASK 0xc000
#define  CTWIN_P2R1_LOC23_SHIFT 14
#define  CTWIN_P2R1_LOC23_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC23_MASK) >> CTWIN_P2R1_LOC23_SHIFT)
#define  CTWIN_P2R1_LOC23_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC23_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC23_SHIFT))

#define  CTWIN_P2R1_LOC22_MASK 0x3000
#define  CTWIN_P2R1_LOC22_SHIFT 12
#define  CTWIN_P2R1_LOC22_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC22_MASK) >> CTWIN_P2R1_LOC22_SHIFT)
#define  CTWIN_P2R1_LOC22_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC22_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC22_SHIFT))

#define  CTWIN_P2R1_LOC21_MASK 0xc00
#define  CTWIN_P2R1_LOC21_SHIFT 10
#define  CTWIN_P2R1_LOC21_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC21_MASK) >> CTWIN_P2R1_LOC21_SHIFT)
#define  CTWIN_P2R1_LOC21_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC21_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC21_SHIFT))

#define  CTWIN_P2R1_LOC20_MASK 0x300
#define  CTWIN_P2R1_LOC20_SHIFT 8
#define  CTWIN_P2R1_LOC20_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC20_MASK) >> CTWIN_P2R1_LOC20_SHIFT)
#define  CTWIN_P2R1_LOC20_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC20_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC20_SHIFT))

#define  CTWIN_P2R1_LOC19_MASK 0xc0
#define  CTWIN_P2R1_LOC19_SHIFT 6
#define  CTWIN_P2R1_LOC19_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC19_MASK) >> CTWIN_P2R1_LOC19_SHIFT)
#define  CTWIN_P2R1_LOC19_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC19_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC19_SHIFT))

#define  CTWIN_P2R1_LOC18_MASK 0x30
#define  CTWIN_P2R1_LOC18_SHIFT 4
#define  CTWIN_P2R1_LOC18_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC18_MASK) >> CTWIN_P2R1_LOC18_SHIFT)
#define  CTWIN_P2R1_LOC18_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC18_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC18_SHIFT))

#define  CTWIN_P2R1_LOC17_MASK 0xc
#define  CTWIN_P2R1_LOC17_SHIFT 2
#define  CTWIN_P2R1_LOC17_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC17_MASK) >> CTWIN_P2R1_LOC17_SHIFT)
#define  CTWIN_P2R1_LOC17_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC17_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC17_SHIFT))

#define  CTWIN_P2R1_LOC16_MASK 0x3
#define  CTWIN_P2R1_LOC16_SHIFT 0
#define  CTWIN_P2R1_LOC16_MASK_SHIFT(reg) (((reg) & CTWIN_P2R1_LOC16_MASK) >> CTWIN_P2R1_LOC16_SHIFT)
#define  CTWIN_P2R1_LOC16_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R1_LOC16_MASK) | (((uint32_t)val) << CTWIN_P2R1_LOC16_SHIFT))

//====================================================================
//Register: CTWIN Pattern 2 Register 2 (P2R2)
//====================================================================

#define  CTWIN_P2R2_LOC47_MASK 0xc0000000
#define  CTWIN_P2R2_LOC47_SHIFT 30
#define  CTWIN_P2R2_LOC47_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC47_MASK) >> CTWIN_P2R2_LOC47_SHIFT)
#define  CTWIN_P2R2_LOC47_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC47_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC47_SHIFT))

#define  CTWIN_P2R2_LOC46_MASK 0x30000000
#define  CTWIN_P2R2_LOC46_SHIFT 28
#define  CTWIN_P2R2_LOC46_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC46_MASK) >> CTWIN_P2R2_LOC46_SHIFT)
#define  CTWIN_P2R2_LOC46_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC46_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC46_SHIFT))

#define  CTWIN_P2R2_LOC45_MASK 0xc000000
#define  CTWIN_P2R2_LOC45_SHIFT 26
#define  CTWIN_P2R2_LOC45_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC45_MASK) >> CTWIN_P2R2_LOC45_SHIFT)
#define  CTWIN_P2R2_LOC45_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC45_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC45_SHIFT))

#define  CTWIN_P2R2_LOC44_MASK 0x3000000
#define  CTWIN_P2R2_LOC44_SHIFT 24
#define  CTWIN_P2R2_LOC44_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC44_MASK) >> CTWIN_P2R2_LOC44_SHIFT)
#define  CTWIN_P2R2_LOC44_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC44_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC44_SHIFT))

#define  CTWIN_P2R2_LOC43_MASK 0xc00000
#define  CTWIN_P2R2_LOC43_SHIFT 22
#define  CTWIN_P2R2_LOC43_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC43_MASK) >> CTWIN_P2R2_LOC43_SHIFT)
#define  CTWIN_P2R2_LOC43_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC43_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC43_SHIFT))

#define  CTWIN_P2R2_LOC42_MASK 0x300000
#define  CTWIN_P2R2_LOC42_SHIFT 20
#define  CTWIN_P2R2_LOC42_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC42_MASK) >> CTWIN_P2R2_LOC42_SHIFT)
#define  CTWIN_P2R2_LOC42_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC42_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC42_SHIFT))

#define  CTWIN_P2R2_LOC41_MASK 0xc0000
#define  CTWIN_P2R2_LOC41_SHIFT 18
#define  CTWIN_P2R2_LOC41_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC41_MASK) >> CTWIN_P2R2_LOC41_SHIFT)
#define  CTWIN_P2R2_LOC41_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC41_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC41_SHIFT))

#define  CTWIN_P2R2_LOC40_MASK 0x30000
#define  CTWIN_P2R2_LOC40_SHIFT 16
#define  CTWIN_P2R2_LOC40_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC40_MASK) >> CTWIN_P2R2_LOC40_SHIFT)
#define  CTWIN_P2R2_LOC40_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC40_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC40_SHIFT))

#define  CTWIN_P2R2_LOC39_MASK 0xc000
#define  CTWIN_P2R2_LOC39_SHIFT 14
#define  CTWIN_P2R2_LOC39_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC39_MASK) >> CTWIN_P2R2_LOC39_SHIFT)
#define  CTWIN_P2R2_LOC39_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC39_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC39_SHIFT))

#define  CTWIN_P2R2_LOC38_MASK 0x3000
#define  CTWIN_P2R2_LOC38_SHIFT 12
#define  CTWIN_P2R2_LOC38_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC38_MASK) >> CTWIN_P2R2_LOC38_SHIFT)
#define  CTWIN_P2R2_LOC38_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC38_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC38_SHIFT))

#define  CTWIN_P2R2_LOC37_MASK 0xc00
#define  CTWIN_P2R2_LOC37_SHIFT 10
#define  CTWIN_P2R2_LOC37_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC37_MASK) >> CTWIN_P2R2_LOC37_SHIFT)
#define  CTWIN_P2R2_LOC37_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC37_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC37_SHIFT))

#define  CTWIN_P2R2_LOC36_MASK 0x300
#define  CTWIN_P2R2_LOC36_SHIFT 8
#define  CTWIN_P2R2_LOC36_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC36_MASK) >> CTWIN_P2R2_LOC36_SHIFT)
#define  CTWIN_P2R2_LOC36_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC36_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC36_SHIFT))

#define  CTWIN_P2R2_LOC35_MASK 0xc0
#define  CTWIN_P2R2_LOC35_SHIFT 6
#define  CTWIN_P2R2_LOC35_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC35_MASK) >> CTWIN_P2R2_LOC35_SHIFT)
#define  CTWIN_P2R2_LOC35_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC35_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC35_SHIFT))

#define  CTWIN_P2R2_LOC34_MASK 0x30
#define  CTWIN_P2R2_LOC34_SHIFT 4
#define  CTWIN_P2R2_LOC34_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC34_MASK) >> CTWIN_P2R2_LOC34_SHIFT)
#define  CTWIN_P2R2_LOC34_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC34_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC34_SHIFT))

#define  CTWIN_P2R2_LOC33_MASK 0xc
#define  CTWIN_P2R2_LOC33_SHIFT 2
#define  CTWIN_P2R2_LOC33_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC33_MASK) >> CTWIN_P2R2_LOC33_SHIFT)
#define  CTWIN_P2R2_LOC33_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC33_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC33_SHIFT))

#define  CTWIN_P2R2_LOC32_MASK 0x3
#define  CTWIN_P2R2_LOC32_SHIFT 0
#define  CTWIN_P2R2_LOC32_MASK_SHIFT(reg) (((reg) & CTWIN_P2R2_LOC32_MASK) >> CTWIN_P2R2_LOC32_SHIFT)
#define  CTWIN_P2R2_LOC32_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R2_LOC32_MASK) | (((uint32_t)val) << CTWIN_P2R2_LOC32_SHIFT))

//====================================================================
//Register: CTWIN Pattern 2 Register 3 (P2R3)
//====================================================================

#define  CTWIN_P2R3_RESERVED1_MASK 0xfffffffc
#define  CTWIN_P2R3_RESERVED1_SHIFT 2
#define  CTWIN_P2R3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_P2R3_RESERVED1_MASK) >> CTWIN_P2R3_RESERVED1_SHIFT)
#define  CTWIN_P2R3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_P2R3_RESERVED1_SHIFT))

#define  CTWIN_P2R3_LOC48_MASK 0x3
#define  CTWIN_P2R3_LOC48_SHIFT 0
#define  CTWIN_P2R3_LOC48_MASK_SHIFT(reg) (((reg) & CTWIN_P2R3_LOC48_MASK) >> CTWIN_P2R3_LOC48_SHIFT)
#define  CTWIN_P2R3_LOC48_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P2R3_LOC48_MASK) | (((uint32_t)val) << CTWIN_P2R3_LOC48_SHIFT))

//====================================================================
//Register: CTWIN Pattern 3 Register 0 (P3R0)
/** \brief Each programmable pattern is implemented as a 7x7 array which is implemented with a set of 4 registers. There are 2 bits associated with each location in the window, with a 0 meaning the window must have a 0 in the zero-threshold bit, 1 meaning there must be a 1 in the one-threshold bit and 2 or 3 meaning the location in the window is a don't care. Each two bit field     represents a location in the 7x7 array. It is numbered as follows: <br/>     <table align="left">     <tr><td>0  </td ><td>1  </td ><td>2  </td 
              <td>3 </td ><td>4 </td ><td>5 </td
              <td>6 </td ></tr> <tr><td>7 </td ><td>8 </td ><td>9 </td
              <td>10 </td ><td>11 </td ><td>12 </td
              <td>13 </td ></tr> <tr><td>14 </td ><td>15 </td ><td>16 </td
              <td>17 </td ><td>18 </td ><td>19 </td
              <td>20 </td ></tr> <tr><td>21 </td ><td>22 </td ><td>23 </td
              <td>24 </td ><td>25 </td ><td>26 </td
              <td>27 </td ></tr> <tr><td>28 </td ><td>29 </td ><td>30 </td
              <td>31 </td ><td>32 </td ><td>33 </td
              <td>34 </td ></tr> <tr><td>35 </td ><td>36 </td ><td>37 </td
              <td>38 </td ><td>39 </td ><td>40 </td
              <td>41 </td ></tr> <tr><td>42 </td ><td>43 </td ><td>44 </td
              <td>45 </td ><td>46 </td ><td>47 </td
              <td>48 </td ></tr> </table>*/
//====================================================================

#define  CTWIN_P3R0_LOC15_MASK 0xc0000000
#define  CTWIN_P3R0_LOC15_SHIFT 30
#define  CTWIN_P3R0_LOC15_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC15_MASK) >> CTWIN_P3R0_LOC15_SHIFT)
#define  CTWIN_P3R0_LOC15_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC15_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC15_SHIFT))

#define  CTWIN_P3R0_LOC14_MASK 0x30000000
#define  CTWIN_P3R0_LOC14_SHIFT 28
#define  CTWIN_P3R0_LOC14_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC14_MASK) >> CTWIN_P3R0_LOC14_SHIFT)
#define  CTWIN_P3R0_LOC14_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC14_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC14_SHIFT))

#define  CTWIN_P3R0_LOC13_MASK 0xc000000
#define  CTWIN_P3R0_LOC13_SHIFT 26
#define  CTWIN_P3R0_LOC13_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC13_MASK) >> CTWIN_P3R0_LOC13_SHIFT)
#define  CTWIN_P3R0_LOC13_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC13_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC13_SHIFT))

#define  CTWIN_P3R0_LOC12_MASK 0x3000000
#define  CTWIN_P3R0_LOC12_SHIFT 24
#define  CTWIN_P3R0_LOC12_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC12_MASK) >> CTWIN_P3R0_LOC12_SHIFT)
#define  CTWIN_P3R0_LOC12_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC12_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC12_SHIFT))

#define  CTWIN_P3R0_LOC11_MASK 0xc00000
#define  CTWIN_P3R0_LOC11_SHIFT 22
#define  CTWIN_P3R0_LOC11_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC11_MASK) >> CTWIN_P3R0_LOC11_SHIFT)
#define  CTWIN_P3R0_LOC11_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC11_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC11_SHIFT))

#define  CTWIN_P3R0_LOC10_MASK 0x300000
#define  CTWIN_P3R0_LOC10_SHIFT 20
#define  CTWIN_P3R0_LOC10_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC10_MASK) >> CTWIN_P3R0_LOC10_SHIFT)
#define  CTWIN_P3R0_LOC10_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC10_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC10_SHIFT))

#define  CTWIN_P3R0_LOC9_MASK 0xc0000
#define  CTWIN_P3R0_LOC9_SHIFT 18
#define  CTWIN_P3R0_LOC9_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC9_MASK) >> CTWIN_P3R0_LOC9_SHIFT)
#define  CTWIN_P3R0_LOC9_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC9_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC9_SHIFT))

#define  CTWIN_P3R0_LOC8_MASK 0x30000
#define  CTWIN_P3R0_LOC8_SHIFT 16
#define  CTWIN_P3R0_LOC8_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC8_MASK) >> CTWIN_P3R0_LOC8_SHIFT)
#define  CTWIN_P3R0_LOC8_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC8_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC8_SHIFT))

#define  CTWIN_P3R0_LOC7_MASK 0xc000
#define  CTWIN_P3R0_LOC7_SHIFT 14
#define  CTWIN_P3R0_LOC7_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC7_MASK) >> CTWIN_P3R0_LOC7_SHIFT)
#define  CTWIN_P3R0_LOC7_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC7_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC7_SHIFT))

#define  CTWIN_P3R0_LOC6_MASK 0x3000
#define  CTWIN_P3R0_LOC6_SHIFT 12
#define  CTWIN_P3R0_LOC6_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC6_MASK) >> CTWIN_P3R0_LOC6_SHIFT)
#define  CTWIN_P3R0_LOC6_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC6_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC6_SHIFT))

#define  CTWIN_P3R0_LOC5_MASK 0xc00
#define  CTWIN_P3R0_LOC5_SHIFT 10
#define  CTWIN_P3R0_LOC5_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC5_MASK) >> CTWIN_P3R0_LOC5_SHIFT)
#define  CTWIN_P3R0_LOC5_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC5_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC5_SHIFT))

#define  CTWIN_P3R0_LOC4_MASK 0x300
#define  CTWIN_P3R0_LOC4_SHIFT 8
#define  CTWIN_P3R0_LOC4_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC4_MASK) >> CTWIN_P3R0_LOC4_SHIFT)
#define  CTWIN_P3R0_LOC4_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC4_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC4_SHIFT))

#define  CTWIN_P3R0_LOC3_MASK 0xc0
#define  CTWIN_P3R0_LOC3_SHIFT 6
#define  CTWIN_P3R0_LOC3_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC3_MASK) >> CTWIN_P3R0_LOC3_SHIFT)
#define  CTWIN_P3R0_LOC3_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC3_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC3_SHIFT))

#define  CTWIN_P3R0_LOC2_MASK 0x30
#define  CTWIN_P3R0_LOC2_SHIFT 4
#define  CTWIN_P3R0_LOC2_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC2_MASK) >> CTWIN_P3R0_LOC2_SHIFT)
#define  CTWIN_P3R0_LOC2_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC2_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC2_SHIFT))

#define  CTWIN_P3R0_LOC1_MASK 0xc
#define  CTWIN_P3R0_LOC1_SHIFT 2
#define  CTWIN_P3R0_LOC1_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC1_MASK) >> CTWIN_P3R0_LOC1_SHIFT)
#define  CTWIN_P3R0_LOC1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC1_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC1_SHIFT))

#define  CTWIN_P3R0_LOC0_MASK 0x3
#define  CTWIN_P3R0_LOC0_SHIFT 0
#define  CTWIN_P3R0_LOC0_MASK_SHIFT(reg) (((reg) & CTWIN_P3R0_LOC0_MASK) >> CTWIN_P3R0_LOC0_SHIFT)
#define  CTWIN_P3R0_LOC0_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R0_LOC0_MASK) | (((uint32_t)val) << CTWIN_P3R0_LOC0_SHIFT))

//====================================================================
//Register: CTWIN Pattern 3 Register 1 (P3R1)
//====================================================================

#define  CTWIN_P3R1_LOC31_MASK 0xc0000000
#define  CTWIN_P3R1_LOC31_SHIFT 30
#define  CTWIN_P3R1_LOC31_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC31_MASK) >> CTWIN_P3R1_LOC31_SHIFT)
#define  CTWIN_P3R1_LOC31_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC31_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC31_SHIFT))

#define  CTWIN_P3R1_LOC30_MASK 0x30000000
#define  CTWIN_P3R1_LOC30_SHIFT 28
#define  CTWIN_P3R1_LOC30_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC30_MASK) >> CTWIN_P3R1_LOC30_SHIFT)
#define  CTWIN_P3R1_LOC30_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC30_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC30_SHIFT))

#define  CTWIN_P3R1_LOC29_MASK 0xc000000
#define  CTWIN_P3R1_LOC29_SHIFT 26
#define  CTWIN_P3R1_LOC29_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC29_MASK) >> CTWIN_P3R1_LOC29_SHIFT)
#define  CTWIN_P3R1_LOC29_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC29_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC29_SHIFT))

#define  CTWIN_P3R1_LOC28_MASK 0x3000000
#define  CTWIN_P3R1_LOC28_SHIFT 24
#define  CTWIN_P3R1_LOC28_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC28_MASK) >> CTWIN_P3R1_LOC28_SHIFT)
#define  CTWIN_P3R1_LOC28_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC28_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC28_SHIFT))

#define  CTWIN_P3R1_LOC27_MASK 0xc00000
#define  CTWIN_P3R1_LOC27_SHIFT 22
#define  CTWIN_P3R1_LOC27_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC27_MASK) >> CTWIN_P3R1_LOC27_SHIFT)
#define  CTWIN_P3R1_LOC27_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC27_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC27_SHIFT))

#define  CTWIN_P3R1_LOC26_MASK 0x300000
#define  CTWIN_P3R1_LOC26_SHIFT 20
#define  CTWIN_P3R1_LOC26_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC26_MASK) >> CTWIN_P3R1_LOC26_SHIFT)
#define  CTWIN_P3R1_LOC26_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC26_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC26_SHIFT))

#define  CTWIN_P3R1_LOC25_MASK 0xc0000
#define  CTWIN_P3R1_LOC25_SHIFT 18
#define  CTWIN_P3R1_LOC25_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC25_MASK) >> CTWIN_P3R1_LOC25_SHIFT)
#define  CTWIN_P3R1_LOC25_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC25_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC25_SHIFT))

#define  CTWIN_P3R1_LOC24_MASK 0x30000
#define  CTWIN_P3R1_LOC24_SHIFT 16
#define  CTWIN_P3R1_LOC24_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC24_MASK) >> CTWIN_P3R1_LOC24_SHIFT)
#define  CTWIN_P3R1_LOC24_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC24_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC24_SHIFT))

#define  CTWIN_P3R1_LOC23_MASK 0xc000
#define  CTWIN_P3R1_LOC23_SHIFT 14
#define  CTWIN_P3R1_LOC23_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC23_MASK) >> CTWIN_P3R1_LOC23_SHIFT)
#define  CTWIN_P3R1_LOC23_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC23_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC23_SHIFT))

#define  CTWIN_P3R1_LOC22_MASK 0x3000
#define  CTWIN_P3R1_LOC22_SHIFT 12
#define  CTWIN_P3R1_LOC22_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC22_MASK) >> CTWIN_P3R1_LOC22_SHIFT)
#define  CTWIN_P3R1_LOC22_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC22_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC22_SHIFT))

#define  CTWIN_P3R1_LOC21_MASK 0xc00
#define  CTWIN_P3R1_LOC21_SHIFT 10
#define  CTWIN_P3R1_LOC21_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC21_MASK) >> CTWIN_P3R1_LOC21_SHIFT)
#define  CTWIN_P3R1_LOC21_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC21_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC21_SHIFT))

#define  CTWIN_P3R1_LOC20_MASK 0x300
#define  CTWIN_P3R1_LOC20_SHIFT 8
#define  CTWIN_P3R1_LOC20_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC20_MASK) >> CTWIN_P3R1_LOC20_SHIFT)
#define  CTWIN_P3R1_LOC20_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC20_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC20_SHIFT))

#define  CTWIN_P3R1_LOC19_MASK 0xc0
#define  CTWIN_P3R1_LOC19_SHIFT 6
#define  CTWIN_P3R1_LOC19_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC19_MASK) >> CTWIN_P3R1_LOC19_SHIFT)
#define  CTWIN_P3R1_LOC19_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC19_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC19_SHIFT))

#define  CTWIN_P3R1_LOC18_MASK 0x30
#define  CTWIN_P3R1_LOC18_SHIFT 4
#define  CTWIN_P3R1_LOC18_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC18_MASK) >> CTWIN_P3R1_LOC18_SHIFT)
#define  CTWIN_P3R1_LOC18_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC18_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC18_SHIFT))

#define  CTWIN_P3R1_LOC17_MASK 0xc
#define  CTWIN_P3R1_LOC17_SHIFT 2
#define  CTWIN_P3R1_LOC17_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC17_MASK) >> CTWIN_P3R1_LOC17_SHIFT)
#define  CTWIN_P3R1_LOC17_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC17_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC17_SHIFT))

#define  CTWIN_P3R1_LOC16_MASK 0x3
#define  CTWIN_P3R1_LOC16_SHIFT 0
#define  CTWIN_P3R1_LOC16_MASK_SHIFT(reg) (((reg) & CTWIN_P3R1_LOC16_MASK) >> CTWIN_P3R1_LOC16_SHIFT)
#define  CTWIN_P3R1_LOC16_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R1_LOC16_MASK) | (((uint32_t)val) << CTWIN_P3R1_LOC16_SHIFT))

//====================================================================
//Register: CTWIN Pattern 3 Register 2 (P3R2)
//====================================================================

#define  CTWIN_P3R2_LOC47_MASK 0xc0000000
#define  CTWIN_P3R2_LOC47_SHIFT 30
#define  CTWIN_P3R2_LOC47_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC47_MASK) >> CTWIN_P3R2_LOC47_SHIFT)
#define  CTWIN_P3R2_LOC47_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC47_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC47_SHIFT))

#define  CTWIN_P3R2_LOC46_MASK 0x30000000
#define  CTWIN_P3R2_LOC46_SHIFT 28
#define  CTWIN_P3R2_LOC46_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC46_MASK) >> CTWIN_P3R2_LOC46_SHIFT)
#define  CTWIN_P3R2_LOC46_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC46_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC46_SHIFT))

#define  CTWIN_P3R2_LOC45_MASK 0xc000000
#define  CTWIN_P3R2_LOC45_SHIFT 26
#define  CTWIN_P3R2_LOC45_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC45_MASK) >> CTWIN_P3R2_LOC45_SHIFT)
#define  CTWIN_P3R2_LOC45_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC45_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC45_SHIFT))

#define  CTWIN_P3R2_LOC44_MASK 0x3000000
#define  CTWIN_P3R2_LOC44_SHIFT 24
#define  CTWIN_P3R2_LOC44_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC44_MASK) >> CTWIN_P3R2_LOC44_SHIFT)
#define  CTWIN_P3R2_LOC44_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC44_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC44_SHIFT))

#define  CTWIN_P3R2_LOC43_MASK 0xc00000
#define  CTWIN_P3R2_LOC43_SHIFT 22
#define  CTWIN_P3R2_LOC43_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC43_MASK) >> CTWIN_P3R2_LOC43_SHIFT)
#define  CTWIN_P3R2_LOC43_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC43_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC43_SHIFT))

#define  CTWIN_P3R2_LOC42_MASK 0x300000
#define  CTWIN_P3R2_LOC42_SHIFT 20
#define  CTWIN_P3R2_LOC42_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC42_MASK) >> CTWIN_P3R2_LOC42_SHIFT)
#define  CTWIN_P3R2_LOC42_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC42_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC42_SHIFT))

#define  CTWIN_P3R2_LOC41_MASK 0xc0000
#define  CTWIN_P3R2_LOC41_SHIFT 18
#define  CTWIN_P3R2_LOC41_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC41_MASK) >> CTWIN_P3R2_LOC41_SHIFT)
#define  CTWIN_P3R2_LOC41_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC41_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC41_SHIFT))

#define  CTWIN_P3R2_LOC40_MASK 0x30000
#define  CTWIN_P3R2_LOC40_SHIFT 16
#define  CTWIN_P3R2_LOC40_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC40_MASK) >> CTWIN_P3R2_LOC40_SHIFT)
#define  CTWIN_P3R2_LOC40_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC40_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC40_SHIFT))

#define  CTWIN_P3R2_LOC39_MASK 0xc000
#define  CTWIN_P3R2_LOC39_SHIFT 14
#define  CTWIN_P3R2_LOC39_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC39_MASK) >> CTWIN_P3R2_LOC39_SHIFT)
#define  CTWIN_P3R2_LOC39_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC39_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC39_SHIFT))

#define  CTWIN_P3R2_LOC38_MASK 0x3000
#define  CTWIN_P3R2_LOC38_SHIFT 12
#define  CTWIN_P3R2_LOC38_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC38_MASK) >> CTWIN_P3R2_LOC38_SHIFT)
#define  CTWIN_P3R2_LOC38_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC38_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC38_SHIFT))

#define  CTWIN_P3R2_LOC37_MASK 0xc00
#define  CTWIN_P3R2_LOC37_SHIFT 10
#define  CTWIN_P3R2_LOC37_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC37_MASK) >> CTWIN_P3R2_LOC37_SHIFT)
#define  CTWIN_P3R2_LOC37_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC37_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC37_SHIFT))

#define  CTWIN_P3R2_LOC36_MASK 0x300
#define  CTWIN_P3R2_LOC36_SHIFT 8
#define  CTWIN_P3R2_LOC36_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC36_MASK) >> CTWIN_P3R2_LOC36_SHIFT)
#define  CTWIN_P3R2_LOC36_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC36_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC36_SHIFT))

#define  CTWIN_P3R2_LOC35_MASK 0xc0
#define  CTWIN_P3R2_LOC35_SHIFT 6
#define  CTWIN_P3R2_LOC35_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC35_MASK) >> CTWIN_P3R2_LOC35_SHIFT)
#define  CTWIN_P3R2_LOC35_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC35_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC35_SHIFT))

#define  CTWIN_P3R2_LOC34_MASK 0x30
#define  CTWIN_P3R2_LOC34_SHIFT 4
#define  CTWIN_P3R2_LOC34_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC34_MASK) >> CTWIN_P3R2_LOC34_SHIFT)
#define  CTWIN_P3R2_LOC34_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC34_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC34_SHIFT))

#define  CTWIN_P3R2_LOC33_MASK 0xc
#define  CTWIN_P3R2_LOC33_SHIFT 2
#define  CTWIN_P3R2_LOC33_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC33_MASK) >> CTWIN_P3R2_LOC33_SHIFT)
#define  CTWIN_P3R2_LOC33_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC33_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC33_SHIFT))

#define  CTWIN_P3R2_LOC32_MASK 0x3
#define  CTWIN_P3R2_LOC32_SHIFT 0
#define  CTWIN_P3R2_LOC32_MASK_SHIFT(reg) (((reg) & CTWIN_P3R2_LOC32_MASK) >> CTWIN_P3R2_LOC32_SHIFT)
#define  CTWIN_P3R2_LOC32_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R2_LOC32_MASK) | (((uint32_t)val) << CTWIN_P3R2_LOC32_SHIFT))

//====================================================================
//Register: CTWIN Pattern 3 Register 3 (P3R3)
//====================================================================

#define  CTWIN_P3R3_RESERVED1_MASK 0xfffffffc
#define  CTWIN_P3R3_RESERVED1_SHIFT 2
#define  CTWIN_P3R3_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_P3R3_RESERVED1_MASK) >> CTWIN_P3R3_RESERVED1_SHIFT)
#define  CTWIN_P3R3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R3_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_P3R3_RESERVED1_SHIFT))

#define  CTWIN_P3R3_LOC48_MASK 0x3
#define  CTWIN_P3R3_LOC48_SHIFT 0
#define  CTWIN_P3R3_LOC48_MASK_SHIFT(reg) (((reg) & CTWIN_P3R3_LOC48_MASK) >> CTWIN_P3R3_LOC48_SHIFT)
#define  CTWIN_P3R3_LOC48_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_P3R3_LOC48_MASK) | (((uint32_t)val) << CTWIN_P3R3_LOC48_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Access Control Register (CBAR)
//====================================================================

#define  CTWIN_CBAR_RESERVED1_MASK 0xfffffffc
#define  CTWIN_CBAR_RESERVED1_SHIFT 2
#define  CTWIN_CBAR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CBAR_RESERVED1_MASK) >> CTWIN_CBAR_RESERVED1_SHIFT)
#define  CTWIN_CBAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBAR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CBAR_RESERVED1_SHIFT))

#define  CTWIN_CBAR_INC_ADDR_MODE_MASK 0x2
#define  CTWIN_CBAR_INC_ADDR_MODE_SHIFT 1
#define  CTWIN_CBAR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & CTWIN_CBAR_INC_ADDR_MODE_MASK) >> CTWIN_CBAR_INC_ADDR_MODE_SHIFT)
#define  CTWIN_CBAR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBAR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << CTWIN_CBAR_INC_ADDR_MODE_SHIFT))

#define  CTWIN_CBAR_LB_RNW_MASK 0x1
#define  CTWIN_CBAR_LB_RNW_SHIFT 0
#define  CTWIN_CBAR_LB_RNW_MASK_SHIFT(reg) (((reg) & CTWIN_CBAR_LB_RNW_MASK) >> CTWIN_CBAR_LB_RNW_SHIFT)
#define  CTWIN_CBAR_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBAR_LB_RNW_MASK) | (((uint32_t)val) << CTWIN_CBAR_LB_RNW_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Address Write Register (CBAWR)
//====================================================================

#define  CTWIN_CBAWR_RESERVED1_MASK 0xffff0000
#define  CTWIN_CBAWR_RESERVED1_SHIFT 16
#define  CTWIN_CBAWR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CBAWR_RESERVED1_MASK) >> CTWIN_CBAWR_RESERVED1_SHIFT)
#define  CTWIN_CBAWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBAWR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CBAWR_RESERVED1_SHIFT))

#define  CTWIN_CBAWR_ADDRESS_MASK 0xffff
#define  CTWIN_CBAWR_ADDRESS_SHIFT 0
#define  CTWIN_CBAWR_ADDRESS_MASK_SHIFT(reg) (((reg) & CTWIN_CBAWR_ADDRESS_MASK) >> CTWIN_CBAWR_ADDRESS_SHIFT)
#define  CTWIN_CBAWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBAWR_ADDRESS_MASK) | (((uint32_t)val) << CTWIN_CBAWR_ADDRESS_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Address Status Register (CBSAR)
//====================================================================

#define  CTWIN_CBSAR_RESERVED1_MASK 0xffff0000
#define  CTWIN_CBSAR_RESERVED1_SHIFT 16
#define  CTWIN_CBSAR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CBSAR_RESERVED1_MASK) >> CTWIN_CBSAR_RESERVED1_SHIFT)
#define  CTWIN_CBSAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBSAR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CBSAR_RESERVED1_SHIFT))

#define  CTWIN_CBSAR_ADDRESS_MASK 0xffff
#define  CTWIN_CBSAR_ADDRESS_SHIFT 0
#define  CTWIN_CBSAR_ADDRESS_MASK_SHIFT(reg) (((reg) & CTWIN_CBSAR_ADDRESS_MASK) >> CTWIN_CBSAR_ADDRESS_SHIFT)
#define  CTWIN_CBSAR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBSAR_ADDRESS_MASK) | (((uint32_t)val) << CTWIN_CBSAR_ADDRESS_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data0 Write Register (CBD0WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD0WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD0WR_DATA_SHIFT 0
#define  CTWIN_CBD0WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD0WR_DATA_MASK) >> CTWIN_CBD0WR_DATA_SHIFT)
#define  CTWIN_CBD0WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD0WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD0WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data1 Write Register (CBD1WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD1WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD1WR_DATA_SHIFT 0
#define  CTWIN_CBD1WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD1WR_DATA_MASK) >> CTWIN_CBD1WR_DATA_SHIFT)
#define  CTWIN_CBD1WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD1WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD1WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data2 Write Register (CBD2WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD2WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD2WR_DATA_SHIFT 0
#define  CTWIN_CBD2WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD2WR_DATA_MASK) >> CTWIN_CBD2WR_DATA_SHIFT)
#define  CTWIN_CBD2WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD2WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD2WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data3 Write Register (CBD3WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD3WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD3WR_DATA_SHIFT 0
#define  CTWIN_CBD3WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD3WR_DATA_MASK) >> CTWIN_CBD3WR_DATA_SHIFT)
#define  CTWIN_CBD3WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD3WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD3WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data4 Write Register (CBD4WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD4WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD4WR_DATA_SHIFT 0
#define  CTWIN_CBD4WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD4WR_DATA_MASK) >> CTWIN_CBD4WR_DATA_SHIFT)
#define  CTWIN_CBD4WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD4WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD4WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data5 Write Register (CBD5WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD5WR_DATA_MASK 0xffffffff
#define  CTWIN_CBD5WR_DATA_SHIFT 0
#define  CTWIN_CBD5WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD5WR_DATA_MASK) >> CTWIN_CBD5WR_DATA_SHIFT)
#define  CTWIN_CBD5WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD5WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD5WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data6 Write Register (CBD6WR)
/** \brief CTWIN Line Buffer SRAM Write Data*/
//====================================================================

#define  CTWIN_CBD6WR_RESERVED1_MASK 0xfffff000
#define  CTWIN_CBD6WR_RESERVED1_SHIFT 12
#define  CTWIN_CBD6WR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CBD6WR_RESERVED1_MASK) >> CTWIN_CBD6WR_RESERVED1_SHIFT)
#define  CTWIN_CBD6WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD6WR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CBD6WR_RESERVED1_SHIFT))

#define  CTWIN_CBD6WR_DATA_MASK 0xfff
#define  CTWIN_CBD6WR_DATA_SHIFT 0
#define  CTWIN_CBD6WR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD6WR_DATA_MASK) >> CTWIN_CBD6WR_DATA_SHIFT)
#define  CTWIN_CBD6WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD6WR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD6WR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data0 Read Register (CBD0RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD0RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD0RR_DATA_SHIFT 0
#define  CTWIN_CBD0RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD0RR_DATA_MASK) >> CTWIN_CBD0RR_DATA_SHIFT)
#define  CTWIN_CBD0RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD0RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD0RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data1 Read Register (CBD1RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD1RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD1RR_DATA_SHIFT 0
#define  CTWIN_CBD1RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD1RR_DATA_MASK) >> CTWIN_CBD1RR_DATA_SHIFT)
#define  CTWIN_CBD1RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD1RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD1RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data2 Read Register (CBD2RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD2RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD2RR_DATA_SHIFT 0
#define  CTWIN_CBD2RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD2RR_DATA_MASK) >> CTWIN_CBD2RR_DATA_SHIFT)
#define  CTWIN_CBD2RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD2RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD2RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data3 Read Register (CBD3RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD3RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD3RR_DATA_SHIFT 0
#define  CTWIN_CBD3RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD3RR_DATA_MASK) >> CTWIN_CBD3RR_DATA_SHIFT)
#define  CTWIN_CBD3RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD3RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD3RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data4 Read Register (CBD4RR)
//====================================================================

#define  CTWIN_CBD4RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD4RR_DATA_SHIFT 0
#define  CTWIN_CBD4RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD4RR_DATA_MASK) >> CTWIN_CBD4RR_DATA_SHIFT)
#define  CTWIN_CBD4RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD4RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD4RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data5 Read Register (CBD5RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD5RR_DATA_MASK 0xffffffff
#define  CTWIN_CBD5RR_DATA_SHIFT 0
#define  CTWIN_CBD5RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD5RR_DATA_MASK) >> CTWIN_CBD5RR_DATA_SHIFT)
#define  CTWIN_CBD5RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD5RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD5RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN LineBuffer Data6 Read Register (CBD6RR)
/** \brief CTWIN Line Buffer SRAM Read Data*/
//====================================================================

#define  CTWIN_CBD6RR_RESERVED1_MASK 0xfffff000
#define  CTWIN_CBD6RR_RESERVED1_SHIFT 12
#define  CTWIN_CBD6RR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CBD6RR_RESERVED1_MASK) >> CTWIN_CBD6RR_RESERVED1_SHIFT)
#define  CTWIN_CBD6RR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD6RR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CBD6RR_RESERVED1_SHIFT))

#define  CTWIN_CBD6RR_DATA_MASK 0xfff
#define  CTWIN_CBD6RR_DATA_SHIFT 0
#define  CTWIN_CBD6RR_DATA_MASK_SHIFT(reg) (((reg) & CTWIN_CBD6RR_DATA_MASK) >> CTWIN_CBD6RR_DATA_SHIFT)
#define  CTWIN_CBD6RR_DATA_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CBD6RR_DATA_MASK) | (((uint32_t)val) << CTWIN_CBD6RR_DATA_SHIFT))

//====================================================================
//Register: CTWIN Save Restore Read Register (CSRR)
/** \brief This read-only register is provided for the save portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access this register.*/
//====================================================================

#define  CTWIN_CSRR_RESERVED1_MASK 0xfff80000
#define  CTWIN_CSRR_RESERVED1_SHIFT 19
#define  CTWIN_CSRR_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CSRR_RESERVED1_MASK) >> CTWIN_CSRR_RESERVED1_SHIFT)
#define  CTWIN_CSRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CSRR_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CSRR_RESERVED1_SHIFT))

#define  CTWIN_CSRR_SAVE_VAL_MASK 0x7ffff
#define  CTWIN_CSRR_SAVE_VAL_SHIFT 0
#define  CTWIN_CSRR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & CTWIN_CSRR_SAVE_VAL_MASK) >> CTWIN_CSRR_SAVE_VAL_SHIFT)
#define  CTWIN_CSRR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CSRR_SAVE_VAL_MASK) | (((uint32_t)val) << CTWIN_CSRR_SAVE_VAL_SHIFT))

//====================================================================
//Register: CTWIN Save Restore Write Register (CSRW)
/** \brief This write-only register is provided for the restore portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access
      this register.*/
//====================================================================

#define  CTWIN_CSRW_RESERVED1_MASK 0xfff80000
#define  CTWIN_CSRW_RESERVED1_SHIFT 19
#define  CTWIN_CSRW_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_CSRW_RESERVED1_MASK) >> CTWIN_CSRW_RESERVED1_SHIFT)
#define  CTWIN_CSRW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CSRW_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_CSRW_RESERVED1_SHIFT))

#define  CTWIN_CSRW_RESTORE_VAL_MASK 0x7ffff
#define  CTWIN_CSRW_RESTORE_VAL_SHIFT 0
#define  CTWIN_CSRW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & CTWIN_CSRW_RESTORE_VAL_MASK) >> CTWIN_CSRW_RESTORE_VAL_SHIFT)
#define  CTWIN_CSRW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_CSRW_RESTORE_VAL_MASK) | (((uint32_t)val) << CTWIN_CSRW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  CTWIN_REV0_MAJ_MASK 0xffff0000
#define  CTWIN_REV0_MAJ_SHIFT 16
#define  CTWIN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CTWIN_REV0_MAJ_MASK) >> CTWIN_REV0_MAJ_SHIFT)
#define  CTWIN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_REV0_MAJ_MASK) | (((uint32_t)val) << CTWIN_REV0_MAJ_SHIFT))

#define  CTWIN_REV0_MID_MASK 0xffff
#define  CTWIN_REV0_MID_SHIFT 0
#define  CTWIN_REV0_MID_MASK_SHIFT(reg) (((reg) & CTWIN_REV0_MID_MASK) >> CTWIN_REV0_MID_SHIFT)
#define  CTWIN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_REV0_MID_MASK) | (((uint32_t)val) << CTWIN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CTWIN_REV1_RESERVED1_MASK 0xffff0000
#define  CTWIN_REV1_RESERVED1_SHIFT 16
#define  CTWIN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CTWIN_REV1_RESERVED1_MASK) >> CTWIN_REV1_RESERVED1_SHIFT)
#define  CTWIN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_REV1_RESERVED1_MASK) | (((uint32_t)val) << CTWIN_REV1_RESERVED1_SHIFT))

#define  CTWIN_REV1_CFG_MASK 0xffff
#define  CTWIN_REV1_CFG_SHIFT 0
#define  CTWIN_REV1_CFG_MASK_SHIFT(reg) (((reg) & CTWIN_REV1_CFG_MASK) >> CTWIN_REV1_CFG_SHIFT)
#define  CTWIN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CTWIN_REV1_CFG_MASK) | (((uint32_t)val) << CTWIN_REV1_CFG_SHIFT))

#endif // CTWIN
