 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CSC_Y2ES_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CSC_Y2ES_REGMASKS_H_
#define _CSC_Y2ES_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: YCC2esRGB Configuration (CSC_Y2ES)
/** \brief (rev 0 . 4 . 2 . 1)
    Register Descriptions for the Y2ES CSC block*/
//
//====================================================================

//====================================================================
//Register: CSC Configuration Register (CCR)
/** \brief The CSC Configuration Register (CCR) manages the configuration of the CSC block. For normal operation of the CSC block, all bits in this register should be set to '0'.*/
//====================================================================

#define  CSC_Y2ES_CCR_RESERVED1_MASK 0xffffff00
#define  CSC_Y2ES_CCR_RESERVED1_SHIFT 8
#define  CSC_Y2ES_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED1_MASK) >> CSC_Y2ES_CCR_RESERVED1_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED1_SHIFT))

#define  CSC_Y2ES_CCR_RESERVED2_MASK 0x80
#define  CSC_Y2ES_CCR_RESERVED2_SHIFT 7
#define  CSC_Y2ES_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED2_MASK) >> CSC_Y2ES_CCR_RESERVED2_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED2_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED2_SHIFT))

#define  CSC_Y2ES_CCR_RESERVED3_MASK 0x40
#define  CSC_Y2ES_CCR_RESERVED3_SHIFT 6
#define  CSC_Y2ES_CCR_RESERVED3_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED3_MASK) >> CSC_Y2ES_CCR_RESERVED3_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED3_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED3_SHIFT))

#define  CSC_Y2ES_CCR_PREOFFBYPASS_MASK 0x20
#define  CSC_Y2ES_CCR_PREOFFBYPASS_SHIFT 5
#define  CSC_Y2ES_CCR_PREOFFBYPASS_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_PREOFFBYPASS_MASK) >> CSC_Y2ES_CCR_PREOFFBYPASS_SHIFT)
#define  CSC_Y2ES_CCR_PREOFFBYPASS_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_PREOFFBYPASS_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_PREOFFBYPASS_SHIFT))

#define  CSC_Y2ES_CCR_RESERVED4_MASK 0x10
#define  CSC_Y2ES_CCR_RESERVED4_SHIFT 4
#define  CSC_Y2ES_CCR_RESERVED4_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED4_MASK) >> CSC_Y2ES_CCR_RESERVED4_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED4_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED4_SHIFT))

#define  CSC_Y2ES_CCR_RESERVED5_MASK 0x8
#define  CSC_Y2ES_CCR_RESERVED5_SHIFT 3
#define  CSC_Y2ES_CCR_RESERVED5_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED5_MASK) >> CSC_Y2ES_CCR_RESERVED5_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED5_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED5_SHIFT))

#define  CSC_Y2ES_CCR_RESERVED6_MASK 0x4
#define  CSC_Y2ES_CCR_RESERVED6_SHIFT 2
#define  CSC_Y2ES_CCR_RESERVED6_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_RESERVED6_MASK) >> CSC_Y2ES_CCR_RESERVED6_SHIFT)
#define  CSC_Y2ES_CCR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_RESERVED6_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_RESERVED6_SHIFT))

#define  CSC_Y2ES_CCR_OFFSETBYPASS_MASK 0x2
#define  CSC_Y2ES_CCR_OFFSETBYPASS_SHIFT 1
#define  CSC_Y2ES_CCR_OFFSETBYPASS_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_OFFSETBYPASS_MASK) >> CSC_Y2ES_CCR_OFFSETBYPASS_SHIFT)
#define  CSC_Y2ES_CCR_OFFSETBYPASS_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_OFFSETBYPASS_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_OFFSETBYPASS_SHIFT))

#define  CSC_Y2ES_CCR_BYPASSALL_MASK 0x1
#define  CSC_Y2ES_CCR_BYPASSALL_SHIFT 0
#define  CSC_Y2ES_CCR_BYPASSALL_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_CCR_BYPASSALL_MASK) >> CSC_Y2ES_CCR_BYPASSALL_SHIFT)
#define  CSC_Y2ES_CCR_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_CCR_BYPASSALL_MASK) | (((uint32_t)val) << CSC_Y2ES_CCR_BYPASSALL_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 0 (row 0, col 0) (MCR0)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR0_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR0_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR0_RESERVED1_MASK) >> CSC_Y2ES_MCR0_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR0_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR0_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR0_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR0_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR0_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR0_COEFF_MASK) >> CSC_Y2ES_MCR0_COEFF_SHIFT)
#define  CSC_Y2ES_MCR0_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR0_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR0_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 1 (row 0, col 1) (MCR1)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR1_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR1_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR1_RESERVED1_MASK) >> CSC_Y2ES_MCR1_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR1_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR1_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR1_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR1_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR1_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR1_COEFF_MASK) >> CSC_Y2ES_MCR1_COEFF_SHIFT)
#define  CSC_Y2ES_MCR1_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR1_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR1_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 2 (row 0, col 2) (MCR2)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR2_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR2_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR2_RESERVED1_MASK) >> CSC_Y2ES_MCR2_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR2_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR2_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR2_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR2_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR2_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR2_COEFF_MASK) >> CSC_Y2ES_MCR2_COEFF_SHIFT)
#define  CSC_Y2ES_MCR2_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR2_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR2_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 3 (row 1, col 0) (MCR3)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR3_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR3_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR3_RESERVED1_MASK) >> CSC_Y2ES_MCR3_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR3_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR3_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR3_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR3_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR3_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR3_COEFF_MASK) >> CSC_Y2ES_MCR3_COEFF_SHIFT)
#define  CSC_Y2ES_MCR3_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR3_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR3_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 4 (row 1, col 1) (MCR4)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR4_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR4_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR4_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR4_RESERVED1_MASK) >> CSC_Y2ES_MCR4_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR4_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR4_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR4_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR4_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR4_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR4_COEFF_MASK) >> CSC_Y2ES_MCR4_COEFF_SHIFT)
#define  CSC_Y2ES_MCR4_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR4_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR4_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 5 (row 1, col 2) (MCR5)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR5_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR5_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR5_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR5_RESERVED1_MASK) >> CSC_Y2ES_MCR5_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR5_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR5_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR5_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR5_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR5_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR5_COEFF_MASK) >> CSC_Y2ES_MCR5_COEFF_SHIFT)
#define  CSC_Y2ES_MCR5_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR5_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR5_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 6 (row 2, col 0) (MCR6)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR6_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR6_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR6_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR6_RESERVED1_MASK) >> CSC_Y2ES_MCR6_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR6_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR6_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR6_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR6_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR6_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR6_COEFF_MASK) >> CSC_Y2ES_MCR6_COEFF_SHIFT)
#define  CSC_Y2ES_MCR6_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR6_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR6_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 7 (row 2, col 1) (MCR7)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR7_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR7_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR7_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR7_RESERVED1_MASK) >> CSC_Y2ES_MCR7_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR7_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR7_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR7_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR7_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR7_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR7_COEFF_MASK) >> CSC_Y2ES_MCR7_COEFF_SHIFT)
#define  CSC_Y2ES_MCR7_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR7_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR7_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 8 (row 2, col 2) (MCR8)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  CSC_Y2ES_MCR8_RESERVED1_MASK 0xffffc000
#define  CSC_Y2ES_MCR8_RESERVED1_SHIFT 14
#define  CSC_Y2ES_MCR8_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR8_RESERVED1_MASK) >> CSC_Y2ES_MCR8_RESERVED1_SHIFT)
#define  CSC_Y2ES_MCR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR8_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR8_RESERVED1_SHIFT))

#define  CSC_Y2ES_MCR8_COEFF_MASK 0x3fff
#define  CSC_Y2ES_MCR8_COEFF_SHIFT 0
#define  CSC_Y2ES_MCR8_COEFF_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_MCR8_COEFF_MASK) >> CSC_Y2ES_MCR8_COEFF_SHIFT)
#define  CSC_Y2ES_MCR8_COEFF_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_MCR8_COEFF_MASK) | (((uint32_t)val) << CSC_Y2ES_MCR8_COEFF_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  CSC_Y2ES_REV0_MAJ_MASK 0xffff0000
#define  CSC_Y2ES_REV0_MAJ_SHIFT 16
#define  CSC_Y2ES_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_REV0_MAJ_MASK) >> CSC_Y2ES_REV0_MAJ_SHIFT)
#define  CSC_Y2ES_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_REV0_MAJ_MASK) | (((uint32_t)val) << CSC_Y2ES_REV0_MAJ_SHIFT))

#define  CSC_Y2ES_REV0_MID_MASK 0xffff
#define  CSC_Y2ES_REV0_MID_SHIFT 0
#define  CSC_Y2ES_REV0_MID_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_REV0_MID_MASK) >> CSC_Y2ES_REV0_MID_SHIFT)
#define  CSC_Y2ES_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_REV0_MID_MASK) | (((uint32_t)val) << CSC_Y2ES_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CSC_Y2ES_REV1_RESERVED1_MASK 0xffff0000
#define  CSC_Y2ES_REV1_RESERVED1_SHIFT 16
#define  CSC_Y2ES_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_REV1_RESERVED1_MASK) >> CSC_Y2ES_REV1_RESERVED1_SHIFT)
#define  CSC_Y2ES_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_REV1_RESERVED1_MASK) | (((uint32_t)val) << CSC_Y2ES_REV1_RESERVED1_SHIFT))

#define  CSC_Y2ES_REV1_CFG_MASK 0xffff
#define  CSC_Y2ES_REV1_CFG_SHIFT 0
#define  CSC_Y2ES_REV1_CFG_MASK_SHIFT(reg) (((reg) & CSC_Y2ES_REV1_CFG_MASK) >> CSC_Y2ES_REV1_CFG_SHIFT)
#define  CSC_Y2ES_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CSC_Y2ES_REV1_CFG_MASK) | (((uint32_t)val) << CSC_Y2ES_REV1_CFG_SHIFT))

#endif // CSC_Y2ES
