 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CSC_RGB2ES_3L_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CSC_RGB2ES_3L_REGSTRUCTS_H_
#define _CSC_RGB2ES_3L_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: RGB2ES Configuration with three LUTs (CSC_RGB2ES_3L)
/** \brief (rev 0 . 4 . 2 . 1)
    Register Descriptions for the RGB2ES 3 LUTs CSC block*/
//
//====================================================================

typedef struct CSC_RGB2ES_3L_REGS_s
{
  volatile uint32_t CCR;  ///< 0x0 [R/W]: CSC Configuration Register
  volatile uint32_t reserved0[3];
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[58];
  volatile uint32_t MCR0;  ///< 0x100 [R/W]: Multiply Coefficient Register 0 (row 0, col 0)
  volatile uint32_t MCR1;  ///< 0x104 [R/W]: Multiply Coefficient Register 1 (row 0, col 1)
  volatile uint32_t MCR2;  ///< 0x108 [R/W]: Multiply Coefficient Register 2 (row 0, col 2)
  volatile uint32_t MCR3;  ///< 0x10c [R/W]: Multiply Coefficient Register 3 (row 1, col 0)
  volatile uint32_t MCR4;  ///< 0x110 [R/W]: Multiply Coefficient Register 4 (row 1, col 1)
  volatile uint32_t MCR5;  ///< 0x114 [R/W]: Multiply Coefficient Register 5 (row 1, col 2)
  volatile uint32_t MCR6;  ///< 0x118 [R/W]: Multiply Coefficient Register 6 (row 2, col 0)
  volatile uint32_t MCR7;  ///< 0x11c [R/W]: Multiply Coefficient Register 7 (row 2, col 1)
  volatile uint32_t MCR8;  ///< 0x120 [R/W]: Multiply Coefficient Register 8 (row 2, col 2)
  volatile uint32_t reserved2[183];
  volatile uint32_t OLOR0;  ///< 0x400 [R/W]: Output LUT Overflow Register (OLOR) (Instance 1 of 3)
  volatile uint32_t OLOR1;  ///< 0x404 [R/W]: Output LUT Overflow Register (OLOR) (Instance 2 of 3)
  volatile uint32_t OLOR2;  ///< 0x408 [R/W]: Output LUT Overflow Register (OLOR) (Instance 3 of 3)
  volatile uint32_t reserved3[1789];
  volatile uint32_t OLIW[768];  ///< 0x2000 [R/W]: CSC Output Look Up Table (OLIW)
} CSC_RGB2ES_3L_REGS_t;

#endif // CSC_RGB2ES_3L
