 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CLIPPAD_PIP_4x8_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CLIPPAD_PIP_4X8_REGSTRUCTS_H_
#define _CLIPPAD_PIP_4X8_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CLIPPAD (CLIPPAD_PIP_4x8)
/** \brief Top-level register file for the Clip Pad block*/
//
//====================================================================

typedef struct CLIPPAD_PIP_4X8_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: CLIPPAD Configuration Register
  volatile uint32_t LPad;  ///< 0x4 [R/W]: Left Side Padding Register
  volatile uint32_t RPad;  ///< 0x8 [R/W]: Right Side Padding Register
  volatile uint32_t reserved0;
  volatile uint32_t LVal0;  ///< 0x10 [R/W]: Left Side Padding Value Register (Instance 1 of 4)
  volatile uint32_t LVal1;  ///< 0x14 [R/W]: Left Side Padding Value Register (Instance 2 of 4)
  volatile uint32_t LVal2;  ///< 0x18 [R/W]: Left Side Padding Value Register (Instance 3 of 4)
  volatile uint32_t LVal3;  ///< 0x1c [R/W]: Left Side Padding Value Register (Instance 4 of 4)
  volatile uint32_t reserved1[4];
  volatile uint32_t RVal0;  ///< 0x30 [R/W]: Right Side Padding Value Register (Instance 1 of 4)
  volatile uint32_t RVal1;  ///< 0x34 [R/W]: Right Side Padding Value Register (Instance 2 of 4)
  volatile uint32_t RVal2;  ///< 0x38 [R/W]: Right Side Padding Value Register (Instance 3 of 4)
  volatile uint32_t RVal3;  ///< 0x3c [R/W]: Right Side Padding Value Register (Instance 4 of 4)
  volatile uint32_t reserved2[4];
  volatile uint32_t LTrunc;  ///< 0x50 [R/W]: Left Side Truncation Boundary
  volatile uint32_t RTrunc;  ///< 0x54 [R/W]: Right Side Truncation Boundary
  volatile uint32_t LineWidth;  ///< 0x58 [R/W]: Line Width Register
  volatile uint32_t CLIPPADPR;  ///< 0x5c [R]: CLIPPAD Parameter Register
  volatile uint32_t REV0;  ///< 0x60 [R]: CLIPPAD Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x64 [R]: CLIPPAD Tagging Revision 1
} CLIPPAD_PIP_4X8_REGS_t;

#endif // CLIPPAD_PIP_4X8
