 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CLIPPAD_PIP_1x8_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CLIPPAD_PIP_1X8_REGMASKS_H_
#define _CLIPPAD_PIP_1X8_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CLIPPAD (CLIPPAD_PIP_1x8)
/** \brief Top-level register file for the Clip Pad block*/
//
//====================================================================

//====================================================================
//Register: CLIPPAD Configuration Register (Cfg)
/** \brief This register configures the major features of the CLIPPAD module*/
//====================================================================

#define  CLIPPAD_PIP_1X8_CFG_RESERVED1_MASK 0xfffffe00
#define  CLIPPAD_PIP_1X8_CFG_RESERVED1_SHIFT 9
#define  CLIPPAD_PIP_1X8_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_CFG_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_PIXORDER_MASK 0x100
#define  CLIPPAD_PIP_1X8_CFG_PIXORDER_SHIFT 8
#define  CLIPPAD_PIP_1X8_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_PIXORDER_MASK) >> CLIPPAD_PIP_1X8_CFG_PIXORDER_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_PIXORDER_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_PIXORDER_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_RESERVED2_MASK 0xe0
#define  CLIPPAD_PIP_1X8_CFG_RESERVED2_SHIFT 5
#define  CLIPPAD_PIP_1X8_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_RESERVED2_MASK) >> CLIPPAD_PIP_1X8_CFG_RESERVED2_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_RESERVED2_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_RESERVED2_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_NIBBLESEL_MASK 0x10
#define  CLIPPAD_PIP_1X8_CFG_NIBBLESEL_SHIFT 4
#define  CLIPPAD_PIP_1X8_CFG_NIBBLESEL_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_NIBBLESEL_MASK) >> CLIPPAD_PIP_1X8_CFG_NIBBLESEL_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_NIBBLESEL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_NIBBLESEL_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_NIBBLESEL_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_RESERVED3_MASK 0x8
#define  CLIPPAD_PIP_1X8_CFG_RESERVED3_SHIFT 3
#define  CLIPPAD_PIP_1X8_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_RESERVED3_MASK) >> CLIPPAD_PIP_1X8_CFG_RESERVED3_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_RESERVED3_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_RESERVED3_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_BPP_MASK 0x6
#define  CLIPPAD_PIP_1X8_CFG_BPP_SHIFT 1
#define  CLIPPAD_PIP_1X8_CFG_BPP_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_BPP_MASK) >> CLIPPAD_PIP_1X8_CFG_BPP_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_BPP_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_BPP_SHIFT))

#define  CLIPPAD_PIP_1X8_CFG_BYPASS_MASK 0x1
#define  CLIPPAD_PIP_1X8_CFG_BYPASS_SHIFT 0
#define  CLIPPAD_PIP_1X8_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CFG_BYPASS_MASK) >> CLIPPAD_PIP_1X8_CFG_BYPASS_SHIFT)
#define  CLIPPAD_PIP_1X8_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CFG_BYPASS_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Left Side Padding Register (LPad)
/** \brief This register configures left side padding.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_LPAD_RESERVED1_MASK 0xfffe0000
#define  CLIPPAD_PIP_1X8_LPAD_RESERVED1_SHIFT 17
#define  CLIPPAD_PIP_1X8_LPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LPAD_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_LPAD_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_LPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LPAD_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LPAD_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_MASK 0x10000
#define  CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_SHIFT 16
#define  CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_MASK) >> CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_SHIFT)
#define  CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LPAD_LEFTEDGEFILL_SHIFT))

#define  CLIPPAD_PIP_1X8_LPAD_LEFTLEN_MASK 0xffff
#define  CLIPPAD_PIP_1X8_LPAD_LEFTLEN_SHIFT 0
#define  CLIPPAD_PIP_1X8_LPAD_LEFTLEN_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LPAD_LEFTLEN_MASK) >> CLIPPAD_PIP_1X8_LPAD_LEFTLEN_SHIFT)
#define  CLIPPAD_PIP_1X8_LPAD_LEFTLEN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LPAD_LEFTLEN_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LPAD_LEFTLEN_SHIFT))

//====================================================================
//Register: Right Side Padding Register (RPad)
/** \brief This register configures right side padding.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_RPAD_RESERVED1_MASK 0xfffe0000
#define  CLIPPAD_PIP_1X8_RPAD_RESERVED1_SHIFT 17
#define  CLIPPAD_PIP_1X8_RPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RPAD_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_RPAD_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_RPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RPAD_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RPAD_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_MASK 0x10000
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_SHIFT 16
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_MASK) >> CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_SHIFT)
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RPAD_RIGHTEDGEFILL_SHIFT))

#define  CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_MASK 0xffff
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_SHIFT 0
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_MASK) >> CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_SHIFT)
#define  CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RPAD_RIGHTLEN_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 1 of 1) (LVal0)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 1 of 1)*/
//====================================================================

#define  CLIPPAD_PIP_1X8_LVAL0_RESERVED1_MASK 0xfffffff0
#define  CLIPPAD_PIP_1X8_LVAL0_RESERVED1_SHIFT 4
#define  CLIPPAD_PIP_1X8_LVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LVAL0_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_LVAL0_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_LVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LVAL0_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LVAL0_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_MASK 0xf
#define  CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_SHIFT 0
#define  CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_MASK) >> CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_SHIFT)
#define  CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LVAL0_LEFTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 1 of 1) (RVal0)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 1 of 1)*/
//====================================================================

#define  CLIPPAD_PIP_1X8_RVAL0_RESERVED1_MASK 0xfffffff0
#define  CLIPPAD_PIP_1X8_RVAL0_RESERVED1_SHIFT 4
#define  CLIPPAD_PIP_1X8_RVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RVAL0_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_RVAL0_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_RVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RVAL0_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RVAL0_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_MASK 0xf
#define  CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_SHIFT 0
#define  CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_MASK) >> CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_SHIFT)
#define  CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RVAL0_RIGHTVAL_SHIFT))

//====================================================================
//Register: Left Side Truncation Boundary (LTrunc)
/** \brief This register is used to specify the left side truncation boundary. Specify the first
       column of the input image that should be included in the output. Note that if
       left side replicate padding is also specified, the specified column will be the one
       that is replicated on the left side of the image.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_SHIFT 16
#define  CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LTRUNC_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_MASK 0xffff
#define  CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_SHIFT 0
#define  CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_MASK) >> CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_SHIFT)
#define  CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LTRUNC_FIRSTCOLUMN_SHIFT))

//====================================================================
//Register: Right Side Truncation Boundary (RTrunc)
/** \brief This register is used to specify the right side truncation boundary. Specify the last
      column of the input image that should be included in the output. Note that if
      right side replicate padding is also specified, the specified column will be the one
      that is replicated on the right side of the image.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_SHIFT 16
#define  CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RTRUNC_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_MASK 0xffff
#define  CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_SHIFT 0
#define  CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_MASK) >> CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_SHIFT)
#define  CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_RTRUNC_LASTCOLUMN_SHIFT))

//====================================================================
//Register: Line Width Register (LineWidth)
/** \brief This register contains the line width in pixels*/
//====================================================================

#define  CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_SHIFT 16
#define  CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LINEWIDTH_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_MASK 0xffff
#define  CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_SHIFT 0
#define  CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_MASK) >> CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_SHIFT)
#define  CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_LINEWIDTH_LINEWIDTH_SHIFT))

//====================================================================
//Register: CLIPPAD Parameter Register (CLIPPADPR)
/** \brief Contains the parameter settings for this instantiation of CLIPPAD*/
//====================================================================

#define  CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_MASK 0x80000000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_SHIFT 31
#define  CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_MASK 0x7e000000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_SHIFT 25
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_POGO_HEIGHT_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_MASK 0x1000000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_SHIFT 24
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_POGO_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_POGO_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_POGO_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_POGO_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_POGO_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_SERP_MASK 0x800000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_SERP_SHIFT 23
#define  CLIPPAD_PIP_1X8_CLIPPADPR_SERP_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_SERP_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_SERP_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_SERP_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_SERP_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_SERP_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_MASK 0x400000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_SHIFT 22
#define  CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_UNPACK_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_MASK 0x3f0000
#define  CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_SHIFT 16
#define  CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_NUM_CHAN_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_MASK 0xfc00
#define  CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_SHIFT 10
#define  CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_OUT_WIDTH_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_MASK 0x3f0
#define  CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_SHIFT 4
#define  CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_IN_WIDTH_SHIFT))

#define  CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_MASK 0xf
#define  CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_SHIFT 0
#define  CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_MASK) >> CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_SHIFT)
#define  CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_CLIPPADPR_AWIDTH_SHIFT))

//====================================================================
//Register: CLIPPAD Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_REV0_MAJ_MASK 0xffff0000
#define  CLIPPAD_PIP_1X8_REV0_MAJ_SHIFT 16
#define  CLIPPAD_PIP_1X8_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_REV0_MAJ_MASK) >> CLIPPAD_PIP_1X8_REV0_MAJ_SHIFT)
#define  CLIPPAD_PIP_1X8_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_REV0_MAJ_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_REV0_MAJ_SHIFT))

#define  CLIPPAD_PIP_1X8_REV0_MID_MASK 0xffff
#define  CLIPPAD_PIP_1X8_REV0_MID_SHIFT 0
#define  CLIPPAD_PIP_1X8_REV0_MID_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_REV0_MID_MASK) >> CLIPPAD_PIP_1X8_REV0_MID_SHIFT)
#define  CLIPPAD_PIP_1X8_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_REV0_MID_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_REV0_MID_SHIFT))

//====================================================================
//Register: CLIPPAD Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CLIPPAD_PIP_1X8_REV1_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_PIP_1X8_REV1_RESERVED1_SHIFT 16
#define  CLIPPAD_PIP_1X8_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_REV1_RESERVED1_MASK) >> CLIPPAD_PIP_1X8_REV1_RESERVED1_SHIFT)
#define  CLIPPAD_PIP_1X8_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_REV1_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_REV1_RESERVED1_SHIFT))

#define  CLIPPAD_PIP_1X8_REV1_CFG_MASK 0xffff
#define  CLIPPAD_PIP_1X8_REV1_CFG_SHIFT 0
#define  CLIPPAD_PIP_1X8_REV1_CFG_MASK_SHIFT(reg) (((reg) & CLIPPAD_PIP_1X8_REV1_CFG_MASK) >> CLIPPAD_PIP_1X8_REV1_CFG_SHIFT)
#define  CLIPPAD_PIP_1X8_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_PIP_1X8_REV1_CFG_MASK) | (((uint32_t)val) << CLIPPAD_PIP_1X8_REV1_CFG_SHIFT))

#endif // CLIPPAD_PIP_1X8
