 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CISX_int_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CISX_INT_REGMASKS_H_
#define _CISX_INT_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CISX_int (CISX_int)
//
//====================================================================

//====================================================================
//Register: CISX Configuration Register (CisxCfg)
//====================================================================

#define  CISX_INT_CISXCFG_ENABLE_MASK 0x80000000
#define  CISX_INT_CISXCFG_ENABLE_SHIFT 31
#define  CISX_INT_CISXCFG_ENABLE_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_ENABLE_MASK) >> CISX_INT_CISXCFG_ENABLE_SHIFT)
#define  CISX_INT_CISXCFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_ENABLE_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_ENABLE_SHIFT))

#define  CISX_INT_CISXCFG_RESERVED1_MASK 0x78000000
#define  CISX_INT_CISXCFG_RESERVED1_SHIFT 27
#define  CISX_INT_CISXCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_RESERVED1_MASK) >> CISX_INT_CISXCFG_RESERVED1_SHIFT)
#define  CISX_INT_CISXCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_RESERVED1_SHIFT))

#define  CISX_INT_CISXCFG_SLAVE_INP_SEL_MASK 0x4000000
#define  CISX_INT_CISXCFG_SLAVE_INP_SEL_SHIFT 26
#define  CISX_INT_CISXCFG_SLAVE_INP_SEL_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_SLAVE_INP_SEL_MASK) >> CISX_INT_CISXCFG_SLAVE_INP_SEL_SHIFT)
#define  CISX_INT_CISXCFG_SLAVE_INP_SEL_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_SLAVE_INP_SEL_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_SLAVE_INP_SEL_SHIFT))

#define  CISX_INT_CISXCFG_BYPASS_MASK 0x2000000
#define  CISX_INT_CISXCFG_BYPASS_SHIFT 25
#define  CISX_INT_CISXCFG_BYPASS_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_BYPASS_MASK) >> CISX_INT_CISXCFG_BYPASS_SHIFT)
#define  CISX_INT_CISXCFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_BYPASS_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_BYPASS_SHIFT))

#define  CISX_INT_CISXCFG_MODE_MASK 0x1c00000
#define  CISX_INT_CISXCFG_MODE_SHIFT 22
#define  CISX_INT_CISXCFG_MODE_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_MODE_MASK) >> CISX_INT_CISXCFG_MODE_SHIFT)
#define  CISX_INT_CISXCFG_MODE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_MODE_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_MODE_SHIFT))

#define  CISX_INT_CISXCFG_CBIOUT_PACE_MASK 0x3e0000
#define  CISX_INT_CISXCFG_CBIOUT_PACE_SHIFT 17
#define  CISX_INT_CISXCFG_CBIOUT_PACE_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_CBIOUT_PACE_MASK) >> CISX_INT_CISXCFG_CBIOUT_PACE_SHIFT)
#define  CISX_INT_CISXCFG_CBIOUT_PACE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_CBIOUT_PACE_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_CBIOUT_PACE_SHIFT))

#define  CISX_INT_CISXCFG_CPU_ACCESS_LUT_MASK 0x10000
#define  CISX_INT_CISXCFG_CPU_ACCESS_LUT_SHIFT 16
#define  CISX_INT_CISXCFG_CPU_ACCESS_LUT_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_CPU_ACCESS_LUT_MASK) >> CISX_INT_CISXCFG_CPU_ACCESS_LUT_SHIFT)
#define  CISX_INT_CISXCFG_CPU_ACCESS_LUT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_CPU_ACCESS_LUT_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_CPU_ACCESS_LUT_SHIFT))

#define  CISX_INT_CISXCFG_NUMCHANS_MASK 0xf000
#define  CISX_INT_CISXCFG_NUMCHANS_SHIFT 12
#define  CISX_INT_CISXCFG_NUMCHANS_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_NUMCHANS_MASK) >> CISX_INT_CISXCFG_NUMCHANS_SHIFT)
#define  CISX_INT_CISXCFG_NUMCHANS_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_NUMCHANS_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_NUMCHANS_SHIFT))

#define  CISX_INT_CISXCFG_CCD_ORDER_MASK 0xe00
#define  CISX_INT_CISXCFG_CCD_ORDER_SHIFT 9
#define  CISX_INT_CISXCFG_CCD_ORDER_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_CCD_ORDER_MASK) >> CISX_INT_CISXCFG_CCD_ORDER_SHIFT)
#define  CISX_INT_CISXCFG_CCD_ORDER_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_CCD_ORDER_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_CCD_ORDER_SHIFT))

#define  CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_MASK 0x100
#define  CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_SHIFT 8
#define  CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_MASK) >> CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_SHIFT)
#define  CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_COLOR_OUT_TBL_EN_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN_IDATA_MASK 0x80
#define  CISX_INT_CISXCFG_APPCHAN_IDATA_SHIFT 7
#define  CISX_INT_CISXCFG_APPCHAN_IDATA_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN_IDATA_MASK) >> CISX_INT_CISXCFG_APPCHAN_IDATA_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN_IDATA_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN_IDATA_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN_IDATA_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN_EXT_MASK 0x40
#define  CISX_INT_CISXCFG_APPCHAN_EXT_SHIFT 6
#define  CISX_INT_CISXCFG_APPCHAN_EXT_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN_EXT_MASK) >> CISX_INT_CISXCFG_APPCHAN_EXT_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN_EXT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN_EXT_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN_EXT_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN5_MASK 0x20
#define  CISX_INT_CISXCFG_APPCHAN5_SHIFT 5
#define  CISX_INT_CISXCFG_APPCHAN5_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN5_MASK) >> CISX_INT_CISXCFG_APPCHAN5_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN5_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN5_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN5_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN4_MASK 0x10
#define  CISX_INT_CISXCFG_APPCHAN4_SHIFT 4
#define  CISX_INT_CISXCFG_APPCHAN4_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN4_MASK) >> CISX_INT_CISXCFG_APPCHAN4_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN4_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN4_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN4_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN3_MASK 0x8
#define  CISX_INT_CISXCFG_APPCHAN3_SHIFT 3
#define  CISX_INT_CISXCFG_APPCHAN3_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN3_MASK) >> CISX_INT_CISXCFG_APPCHAN3_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN3_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN3_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN3_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN2_MASK 0x4
#define  CISX_INT_CISXCFG_APPCHAN2_SHIFT 2
#define  CISX_INT_CISXCFG_APPCHAN2_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN2_MASK) >> CISX_INT_CISXCFG_APPCHAN2_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN2_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN2_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN1_MASK 0x2
#define  CISX_INT_CISXCFG_APPCHAN1_SHIFT 1
#define  CISX_INT_CISXCFG_APPCHAN1_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN1_MASK) >> CISX_INT_CISXCFG_APPCHAN1_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN1_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN1_SHIFT))

#define  CISX_INT_CISXCFG_APPCHAN0_MASK 0x1
#define  CISX_INT_CISXCFG_APPCHAN0_SHIFT 0
#define  CISX_INT_CISXCFG_APPCHAN0_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXCFG_APPCHAN0_MASK) >> CISX_INT_CISXCFG_APPCHAN0_SHIFT)
#define  CISX_INT_CISXCFG_APPCHAN0_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXCFG_APPCHAN0_MASK) | (((uint32_t)val) << CISX_INT_CISXCFG_APPCHAN0_SHIFT))

//====================================================================
//Register: Status register (CisxStat)
//====================================================================

#define  CISX_INT_CISXSTAT_RESERVED1_MASK 0xffffff80
#define  CISX_INT_CISXSTAT_RESERVED1_SHIFT 7
#define  CISX_INT_CISXSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXSTAT_RESERVED1_MASK) >> CISX_INT_CISXSTAT_RESERVED1_SHIFT)
#define  CISX_INT_CISXSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXSTAT_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CISXSTAT_RESERVED1_SHIFT))

#define  CISX_INT_CISXSTAT_LINE_SM_MASK 0x70
#define  CISX_INT_CISXSTAT_LINE_SM_SHIFT 4
#define  CISX_INT_CISXSTAT_LINE_SM_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXSTAT_LINE_SM_MASK) >> CISX_INT_CISXSTAT_LINE_SM_SHIFT)
#define  CISX_INT_CISXSTAT_LINE_SM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXSTAT_LINE_SM_MASK) | (((uint32_t)val) << CISX_INT_CISXSTAT_LINE_SM_SHIFT))

#define  CISX_INT_CISXSTAT_RESERVED2_MASK 0xc
#define  CISX_INT_CISXSTAT_RESERVED2_SHIFT 2
#define  CISX_INT_CISXSTAT_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXSTAT_RESERVED2_MASK) >> CISX_INT_CISXSTAT_RESERVED2_SHIFT)
#define  CISX_INT_CISXSTAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXSTAT_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_CISXSTAT_RESERVED2_SHIFT))

#define  CISX_INT_CISXSTAT_ODMA_BUSY_MASK 0x2
#define  CISX_INT_CISXSTAT_ODMA_BUSY_SHIFT 1
#define  CISX_INT_CISXSTAT_ODMA_BUSY_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXSTAT_ODMA_BUSY_MASK) >> CISX_INT_CISXSTAT_ODMA_BUSY_SHIFT)
#define  CISX_INT_CISXSTAT_ODMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXSTAT_ODMA_BUSY_MASK) | (((uint32_t)val) << CISX_INT_CISXSTAT_ODMA_BUSY_SHIFT))

#define  CISX_INT_CISXSTAT_IDMA_BUSY_MASK 0x1
#define  CISX_INT_CISXSTAT_IDMA_BUSY_SHIFT 0
#define  CISX_INT_CISXSTAT_IDMA_BUSY_MASK_SHIFT(reg) (((reg) & CISX_INT_CISXSTAT_IDMA_BUSY_MASK) >> CISX_INT_CISXSTAT_IDMA_BUSY_SHIFT)
#define  CISX_INT_CISXSTAT_IDMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CISXSTAT_IDMA_BUSY_MASK) | (((uint32_t)val) << CISX_INT_CISXSTAT_IDMA_BUSY_SHIFT))

//====================================================================
//Register: Channel 0 pixels (Chan0Pix)
//====================================================================

#define  CISX_INT_CHAN0PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN0PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN0PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN0PIX_RESERVED1_MASK) >> CISX_INT_CHAN0PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN0PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN0PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN0PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN0PIX_CHAN0DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN0PIX_CHAN0DUM_SHIFT 16
#define  CISX_INT_CHAN0PIX_CHAN0DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN0PIX_CHAN0DUM_MASK) >> CISX_INT_CHAN0PIX_CHAN0DUM_SHIFT)
#define  CISX_INT_CHAN0PIX_CHAN0DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN0PIX_CHAN0DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN0PIX_CHAN0DUM_SHIFT))

#define  CISX_INT_CHAN0PIX_CHAN0DAT_MASK 0xffff
#define  CISX_INT_CHAN0PIX_CHAN0DAT_SHIFT 0
#define  CISX_INT_CHAN0PIX_CHAN0DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN0PIX_CHAN0DAT_MASK) >> CISX_INT_CHAN0PIX_CHAN0DAT_SHIFT)
#define  CISX_INT_CHAN0PIX_CHAN0DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN0PIX_CHAN0DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN0PIX_CHAN0DAT_SHIFT))

//====================================================================
//Register: Channel 1 pixels (Chan1Pix)
//====================================================================

#define  CISX_INT_CHAN1PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN1PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN1PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN1PIX_RESERVED1_MASK) >> CISX_INT_CHAN1PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN1PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN1PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN1PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN1PIX_CHAN1DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN1PIX_CHAN1DUM_SHIFT 16
#define  CISX_INT_CHAN1PIX_CHAN1DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN1PIX_CHAN1DUM_MASK) >> CISX_INT_CHAN1PIX_CHAN1DUM_SHIFT)
#define  CISX_INT_CHAN1PIX_CHAN1DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN1PIX_CHAN1DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN1PIX_CHAN1DUM_SHIFT))

#define  CISX_INT_CHAN1PIX_CHAN1DAT_MASK 0xffff
#define  CISX_INT_CHAN1PIX_CHAN1DAT_SHIFT 0
#define  CISX_INT_CHAN1PIX_CHAN1DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN1PIX_CHAN1DAT_MASK) >> CISX_INT_CHAN1PIX_CHAN1DAT_SHIFT)
#define  CISX_INT_CHAN1PIX_CHAN1DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN1PIX_CHAN1DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN1PIX_CHAN1DAT_SHIFT))

//====================================================================
//Register: Channel 2 pixels (Chan2Pix)
//====================================================================

#define  CISX_INT_CHAN2PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN2PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN2PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN2PIX_RESERVED1_MASK) >> CISX_INT_CHAN2PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN2PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN2PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN2PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN2PIX_CHAN2DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN2PIX_CHAN2DUM_SHIFT 16
#define  CISX_INT_CHAN2PIX_CHAN2DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN2PIX_CHAN2DUM_MASK) >> CISX_INT_CHAN2PIX_CHAN2DUM_SHIFT)
#define  CISX_INT_CHAN2PIX_CHAN2DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN2PIX_CHAN2DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN2PIX_CHAN2DUM_SHIFT))

#define  CISX_INT_CHAN2PIX_CHAN2DAT_MASK 0xffff
#define  CISX_INT_CHAN2PIX_CHAN2DAT_SHIFT 0
#define  CISX_INT_CHAN2PIX_CHAN2DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN2PIX_CHAN2DAT_MASK) >> CISX_INT_CHAN2PIX_CHAN2DAT_SHIFT)
#define  CISX_INT_CHAN2PIX_CHAN2DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN2PIX_CHAN2DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN2PIX_CHAN2DAT_SHIFT))

//====================================================================
//Register: Channel 3 pixels (Chan3Pix)
//====================================================================

#define  CISX_INT_CHAN3PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN3PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN3PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN3PIX_RESERVED1_MASK) >> CISX_INT_CHAN3PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN3PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN3PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN3PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN3PIX_CHAN3DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN3PIX_CHAN3DUM_SHIFT 16
#define  CISX_INT_CHAN3PIX_CHAN3DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN3PIX_CHAN3DUM_MASK) >> CISX_INT_CHAN3PIX_CHAN3DUM_SHIFT)
#define  CISX_INT_CHAN3PIX_CHAN3DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN3PIX_CHAN3DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN3PIX_CHAN3DUM_SHIFT))

#define  CISX_INT_CHAN3PIX_CHAN3DAT_MASK 0xffff
#define  CISX_INT_CHAN3PIX_CHAN3DAT_SHIFT 0
#define  CISX_INT_CHAN3PIX_CHAN3DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN3PIX_CHAN3DAT_MASK) >> CISX_INT_CHAN3PIX_CHAN3DAT_SHIFT)
#define  CISX_INT_CHAN3PIX_CHAN3DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN3PIX_CHAN3DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN3PIX_CHAN3DAT_SHIFT))

//====================================================================
//Register: Channel 4 pixels (Chan4Pix)
//====================================================================

#define  CISX_INT_CHAN4PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN4PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN4PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN4PIX_RESERVED1_MASK) >> CISX_INT_CHAN4PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN4PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN4PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN4PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN4PIX_CHAN4DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN4PIX_CHAN4DUM_SHIFT 16
#define  CISX_INT_CHAN4PIX_CHAN4DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN4PIX_CHAN4DUM_MASK) >> CISX_INT_CHAN4PIX_CHAN4DUM_SHIFT)
#define  CISX_INT_CHAN4PIX_CHAN4DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN4PIX_CHAN4DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN4PIX_CHAN4DUM_SHIFT))

#define  CISX_INT_CHAN4PIX_CHAN4DAT_MASK 0xffff
#define  CISX_INT_CHAN4PIX_CHAN4DAT_SHIFT 0
#define  CISX_INT_CHAN4PIX_CHAN4DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN4PIX_CHAN4DAT_MASK) >> CISX_INT_CHAN4PIX_CHAN4DAT_SHIFT)
#define  CISX_INT_CHAN4PIX_CHAN4DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN4PIX_CHAN4DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN4PIX_CHAN4DAT_SHIFT))

//====================================================================
//Register: Channel 5 pixels (Chan5Pix)
//====================================================================

#define  CISX_INT_CHAN5PIX_RESERVED1_MASK 0xfc000000
#define  CISX_INT_CHAN5PIX_RESERVED1_SHIFT 26
#define  CISX_INT_CHAN5PIX_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN5PIX_RESERVED1_MASK) >> CISX_INT_CHAN5PIX_RESERVED1_SHIFT)
#define  CISX_INT_CHAN5PIX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN5PIX_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN5PIX_RESERVED1_SHIFT))

#define  CISX_INT_CHAN5PIX_CHAN5DUM_MASK 0x3ff0000
#define  CISX_INT_CHAN5PIX_CHAN5DUM_SHIFT 16
#define  CISX_INT_CHAN5PIX_CHAN5DUM_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN5PIX_CHAN5DUM_MASK) >> CISX_INT_CHAN5PIX_CHAN5DUM_SHIFT)
#define  CISX_INT_CHAN5PIX_CHAN5DUM_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN5PIX_CHAN5DUM_MASK) | (((uint32_t)val) << CISX_INT_CHAN5PIX_CHAN5DUM_SHIFT))

#define  CISX_INT_CHAN5PIX_CHAN5DAT_MASK 0xffff
#define  CISX_INT_CHAN5PIX_CHAN5DAT_SHIFT 0
#define  CISX_INT_CHAN5PIX_CHAN5DAT_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN5PIX_CHAN5DAT_MASK) >> CISX_INT_CHAN5PIX_CHAN5DAT_SHIFT)
#define  CISX_INT_CHAN5PIX_CHAN5DAT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN5PIX_CHAN5DAT_MASK) | (((uint32_t)val) << CISX_INT_CHAN5PIX_CHAN5DAT_SHIFT))

//====================================================================
//Register: Channel 0 Shuffle Separation Pixels (Chan0Shuffle)
//====================================================================

#define  CISX_INT_CHAN0SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN0SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN0SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN0SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN0SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN0SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN0SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN0SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN0SHUFFLE_CHAN0SEP_MASK 0x3ff
#define  CISX_INT_CHAN0SHUFFLE_CHAN0SEP_SHIFT 0
#define  CISX_INT_CHAN0SHUFFLE_CHAN0SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN0SHUFFLE_CHAN0SEP_MASK) >> CISX_INT_CHAN0SHUFFLE_CHAN0SEP_SHIFT)
#define  CISX_INT_CHAN0SHUFFLE_CHAN0SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN0SHUFFLE_CHAN0SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN0SHUFFLE_CHAN0SEP_SHIFT))

//====================================================================
//Register: Channel 1 Shuffle Separation Pixels (Chan1Shuffle)
//====================================================================

#define  CISX_INT_CHAN1SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN1SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN1SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN1SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN1SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN1SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN1SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN1SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN1SHUFFLE_CHAN1SEP_MASK 0x3ff
#define  CISX_INT_CHAN1SHUFFLE_CHAN1SEP_SHIFT 0
#define  CISX_INT_CHAN1SHUFFLE_CHAN1SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN1SHUFFLE_CHAN1SEP_MASK) >> CISX_INT_CHAN1SHUFFLE_CHAN1SEP_SHIFT)
#define  CISX_INT_CHAN1SHUFFLE_CHAN1SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN1SHUFFLE_CHAN1SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN1SHUFFLE_CHAN1SEP_SHIFT))

//====================================================================
//Register: Channel 2 Shuffle Separation Pixels (Chan2Shuffle)
//====================================================================

#define  CISX_INT_CHAN2SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN2SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN2SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN2SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN2SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN2SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN2SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN2SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN2SHUFFLE_CHAN2SEP_MASK 0x3ff
#define  CISX_INT_CHAN2SHUFFLE_CHAN2SEP_SHIFT 0
#define  CISX_INT_CHAN2SHUFFLE_CHAN2SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN2SHUFFLE_CHAN2SEP_MASK) >> CISX_INT_CHAN2SHUFFLE_CHAN2SEP_SHIFT)
#define  CISX_INT_CHAN2SHUFFLE_CHAN2SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN2SHUFFLE_CHAN2SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN2SHUFFLE_CHAN2SEP_SHIFT))

//====================================================================
//Register: Channel 3 Shuffle Separation Pixels (Chan3Shuffle)
//====================================================================

#define  CISX_INT_CHAN3SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN3SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN3SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN3SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN3SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN3SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN3SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN3SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN3SHUFFLE_CHAN3SEP_MASK 0x3ff
#define  CISX_INT_CHAN3SHUFFLE_CHAN3SEP_SHIFT 0
#define  CISX_INT_CHAN3SHUFFLE_CHAN3SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN3SHUFFLE_CHAN3SEP_MASK) >> CISX_INT_CHAN3SHUFFLE_CHAN3SEP_SHIFT)
#define  CISX_INT_CHAN3SHUFFLE_CHAN3SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN3SHUFFLE_CHAN3SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN3SHUFFLE_CHAN3SEP_SHIFT))

//====================================================================
//Register: Channel 4 Shuffle Separation Pixels (Chan4Shuffle)
//====================================================================

#define  CISX_INT_CHAN4SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN4SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN4SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN4SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN4SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN4SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN4SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN4SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN4SHUFFLE_CHAN4SEP_MASK 0x3ff
#define  CISX_INT_CHAN4SHUFFLE_CHAN4SEP_SHIFT 0
#define  CISX_INT_CHAN4SHUFFLE_CHAN4SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN4SHUFFLE_CHAN4SEP_MASK) >> CISX_INT_CHAN4SHUFFLE_CHAN4SEP_SHIFT)
#define  CISX_INT_CHAN4SHUFFLE_CHAN4SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN4SHUFFLE_CHAN4SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN4SHUFFLE_CHAN4SEP_SHIFT))

//====================================================================
//Register: Channel 5 Shuffle Separation Pixels (Chan5Shuffle)
//====================================================================

#define  CISX_INT_CHAN5SHUFFLE_RESERVED1_MASK 0xfffffc00
#define  CISX_INT_CHAN5SHUFFLE_RESERVED1_SHIFT 10
#define  CISX_INT_CHAN5SHUFFLE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN5SHUFFLE_RESERVED1_MASK) >> CISX_INT_CHAN5SHUFFLE_RESERVED1_SHIFT)
#define  CISX_INT_CHAN5SHUFFLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN5SHUFFLE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_CHAN5SHUFFLE_RESERVED1_SHIFT))

#define  CISX_INT_CHAN5SHUFFLE_CHAN5SEP_MASK 0x3ff
#define  CISX_INT_CHAN5SHUFFLE_CHAN5SEP_SHIFT 0
#define  CISX_INT_CHAN5SHUFFLE_CHAN5SEP_MASK_SHIFT(reg) (((reg) & CISX_INT_CHAN5SHUFFLE_CHAN5SEP_MASK) >> CISX_INT_CHAN5SHUFFLE_CHAN5SEP_SHIFT)
#define  CISX_INT_CHAN5SHUFFLE_CHAN5SEP_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_CHAN5SHUFFLE_CHAN5SEP_MASK) | (((uint32_t)val) << CISX_INT_CHAN5SHUFFLE_CHAN5SEP_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IntEn)
//====================================================================

#define  CISX_INT_INTEN_RESERVED1_MASK 0xffff0000
#define  CISX_INT_INTEN_RESERVED1_SHIFT 16
#define  CISX_INT_INTEN_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_RESERVED1_MASK) >> CISX_INT_INTEN_RESERVED1_SHIFT)
#define  CISX_INT_INTEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_INTEN_RESERVED1_SHIFT))

#define  CISX_INT_INTEN_IMAGEDONE_EN_MASK 0x8000
#define  CISX_INT_INTEN_IMAGEDONE_EN_SHIFT 15
#define  CISX_INT_INTEN_IMAGEDONE_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_IMAGEDONE_EN_MASK) >> CISX_INT_INTEN_IMAGEDONE_EN_SHIFT)
#define  CISX_INT_INTEN_IMAGEDONE_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_IMAGEDONE_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_IMAGEDONE_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA5_IRQ_EN_MASK 0x4000
#define  CISX_INT_INTEN_ODMA5_IRQ_EN_SHIFT 14
#define  CISX_INT_INTEN_ODMA5_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA5_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA5_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA5_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA5_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA5_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA4_IRQ_EN_MASK 0x2000
#define  CISX_INT_INTEN_ODMA4_IRQ_EN_SHIFT 13
#define  CISX_INT_INTEN_ODMA4_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA4_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA4_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA4_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA4_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA4_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA3_IRQ_EN_MASK 0x1000
#define  CISX_INT_INTEN_ODMA3_IRQ_EN_SHIFT 12
#define  CISX_INT_INTEN_ODMA3_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA3_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA3_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA3_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA3_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA3_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA2_IRQ_EN_MASK 0x800
#define  CISX_INT_INTEN_ODMA2_IRQ_EN_SHIFT 11
#define  CISX_INT_INTEN_ODMA2_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA2_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA2_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA2_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA2_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA2_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA1_IRQ_EN_MASK 0x400
#define  CISX_INT_INTEN_ODMA1_IRQ_EN_SHIFT 10
#define  CISX_INT_INTEN_ODMA1_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA1_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA1_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA1_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA1_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA1_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_ODMA0_IRQ_EN_MASK 0x200
#define  CISX_INT_INTEN_ODMA0_IRQ_EN_SHIFT 9
#define  CISX_INT_INTEN_ODMA0_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_ODMA0_IRQ_EN_MASK) >> CISX_INT_INTEN_ODMA0_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_ODMA0_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_ODMA0_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_ODMA0_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_IDMA1_IRQ_EN_MASK 0x100
#define  CISX_INT_INTEN_IDMA1_IRQ_EN_SHIFT 8
#define  CISX_INT_INTEN_IDMA1_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_IDMA1_IRQ_EN_MASK) >> CISX_INT_INTEN_IDMA1_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_IDMA1_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_IDMA1_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_IDMA1_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_IDMA0_IRQ_EN_MASK 0x80
#define  CISX_INT_INTEN_IDMA0_IRQ_EN_SHIFT 7
#define  CISX_INT_INTEN_IDMA0_IRQ_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_IDMA0_IRQ_EN_MASK) >> CISX_INT_INTEN_IDMA0_IRQ_EN_SHIFT)
#define  CISX_INT_INTEN_IDMA0_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_IDMA0_IRQ_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_IDMA0_IRQ_EN_SHIFT))

#define  CISX_INT_INTEN_DMABUSERR_EN_MASK 0x40
#define  CISX_INT_INTEN_DMABUSERR_EN_SHIFT 6
#define  CISX_INT_INTEN_DMABUSERR_EN_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_DMABUSERR_EN_MASK) >> CISX_INT_INTEN_DMABUSERR_EN_SHIFT)
#define  CISX_INT_INTEN_DMABUSERR_EN_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_DMABUSERR_EN_MASK) | (((uint32_t)val) << CISX_INT_INTEN_DMABUSERR_EN_SHIFT))

#define  CISX_INT_INTEN_RESERVED2_MASK 0x3f
#define  CISX_INT_INTEN_RESERVED2_SHIFT 0
#define  CISX_INT_INTEN_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_INTEN_RESERVED2_MASK) >> CISX_INT_INTEN_RESERVED2_SHIFT)
#define  CISX_INT_INTEN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTEN_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_INTEN_RESERVED2_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IntPend)
//====================================================================

#define  CISX_INT_INTPEND_RESERVED1_MASK 0xffff0000
#define  CISX_INT_INTPEND_RESERVED1_SHIFT 16
#define  CISX_INT_INTPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_RESERVED1_MASK) >> CISX_INT_INTPEND_RESERVED1_SHIFT)
#define  CISX_INT_INTPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_RESERVED1_SHIFT))

#define  CISX_INT_INTPEND_IMAGEDONE_PEND_MASK 0x8000
#define  CISX_INT_INTPEND_IMAGEDONE_PEND_SHIFT 15
#define  CISX_INT_INTPEND_IMAGEDONE_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_IMAGEDONE_PEND_MASK) >> CISX_INT_INTPEND_IMAGEDONE_PEND_SHIFT)
#define  CISX_INT_INTPEND_IMAGEDONE_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_IMAGEDONE_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_IMAGEDONE_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA5_IRQ_PEND_MASK 0x4000
#define  CISX_INT_INTPEND_ODMA5_IRQ_PEND_SHIFT 14
#define  CISX_INT_INTPEND_ODMA5_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA5_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA5_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA5_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA5_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA5_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA4_IRQ_PEND_MASK 0x2000
#define  CISX_INT_INTPEND_ODMA4_IRQ_PEND_SHIFT 13
#define  CISX_INT_INTPEND_ODMA4_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA4_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA4_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA4_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA4_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA4_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA3_IRQ_PEND_MASK 0x1000
#define  CISX_INT_INTPEND_ODMA3_IRQ_PEND_SHIFT 12
#define  CISX_INT_INTPEND_ODMA3_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA3_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA3_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA3_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA3_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA3_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA2_IRQ_PEND_MASK 0x800
#define  CISX_INT_INTPEND_ODMA2_IRQ_PEND_SHIFT 11
#define  CISX_INT_INTPEND_ODMA2_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA2_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA2_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA2_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA2_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA2_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA1_IRQ_PEND_MASK 0x400
#define  CISX_INT_INTPEND_ODMA1_IRQ_PEND_SHIFT 10
#define  CISX_INT_INTPEND_ODMA1_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA1_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA1_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA1_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA1_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA1_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_ODMA0_IRQ_PEND_MASK 0x200
#define  CISX_INT_INTPEND_ODMA0_IRQ_PEND_SHIFT 9
#define  CISX_INT_INTPEND_ODMA0_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_ODMA0_IRQ_PEND_MASK) >> CISX_INT_INTPEND_ODMA0_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_ODMA0_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_ODMA0_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_ODMA0_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_IDMA1_IRQ_PEND_MASK 0x100
#define  CISX_INT_INTPEND_IDMA1_IRQ_PEND_SHIFT 8
#define  CISX_INT_INTPEND_IDMA1_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_IDMA1_IRQ_PEND_MASK) >> CISX_INT_INTPEND_IDMA1_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_IDMA1_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_IDMA1_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_IDMA1_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_IDMA0_IRQ_PEND_MASK 0x80
#define  CISX_INT_INTPEND_IDMA0_IRQ_PEND_SHIFT 7
#define  CISX_INT_INTPEND_IDMA0_IRQ_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_IDMA0_IRQ_PEND_MASK) >> CISX_INT_INTPEND_IDMA0_IRQ_PEND_SHIFT)
#define  CISX_INT_INTPEND_IDMA0_IRQ_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_IDMA0_IRQ_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_IDMA0_IRQ_PEND_SHIFT))

#define  CISX_INT_INTPEND_DMABUSERR_PEND_MASK 0x40
#define  CISX_INT_INTPEND_DMABUSERR_PEND_SHIFT 6
#define  CISX_INT_INTPEND_DMABUSERR_PEND_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_DMABUSERR_PEND_MASK) >> CISX_INT_INTPEND_DMABUSERR_PEND_SHIFT)
#define  CISX_INT_INTPEND_DMABUSERR_PEND_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_DMABUSERR_PEND_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_DMABUSERR_PEND_SHIFT))

#define  CISX_INT_INTPEND_RESERVED2_MASK 0x3f
#define  CISX_INT_INTPEND_RESERVED2_SHIFT 0
#define  CISX_INT_INTPEND_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_INTPEND_RESERVED2_MASK) >> CISX_INT_INTPEND_RESERVED2_SHIFT)
#define  CISX_INT_INTPEND_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTPEND_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_INTPEND_RESERVED2_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IntAck)
//====================================================================

#define  CISX_INT_INTACK_RESERVED1_MASK 0xffff0000
#define  CISX_INT_INTACK_RESERVED1_SHIFT 16
#define  CISX_INT_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_RESERVED1_MASK) >> CISX_INT_INTACK_RESERVED1_SHIFT)
#define  CISX_INT_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_INTACK_RESERVED1_SHIFT))

#define  CISX_INT_INTACK_IMAGEDONE_ACK_MASK 0x8000
#define  CISX_INT_INTACK_IMAGEDONE_ACK_SHIFT 15
#define  CISX_INT_INTACK_IMAGEDONE_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_IMAGEDONE_ACK_MASK) >> CISX_INT_INTACK_IMAGEDONE_ACK_SHIFT)
#define  CISX_INT_INTACK_IMAGEDONE_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_IMAGEDONE_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_IMAGEDONE_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA5_IRQ_ACK_MASK 0x4000
#define  CISX_INT_INTACK_ODMA5_IRQ_ACK_SHIFT 14
#define  CISX_INT_INTACK_ODMA5_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA5_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA5_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA5_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA5_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA5_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA4_IRQ_ACK_MASK 0x2000
#define  CISX_INT_INTACK_ODMA4_IRQ_ACK_SHIFT 13
#define  CISX_INT_INTACK_ODMA4_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA4_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA4_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA4_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA4_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA4_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA3_IRQ_ACK_MASK 0x1000
#define  CISX_INT_INTACK_ODMA3_IRQ_ACK_SHIFT 12
#define  CISX_INT_INTACK_ODMA3_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA3_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA3_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA3_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA3_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA3_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA2_IRQ_ACK_MASK 0x800
#define  CISX_INT_INTACK_ODMA2_IRQ_ACK_SHIFT 11
#define  CISX_INT_INTACK_ODMA2_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA2_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA2_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA2_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA2_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA2_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA1_IRQ_ACK_MASK 0x400
#define  CISX_INT_INTACK_ODMA1_IRQ_ACK_SHIFT 10
#define  CISX_INT_INTACK_ODMA1_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA1_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA1_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA1_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA1_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA1_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_ODMA0_IRQ_ACK_MASK 0x200
#define  CISX_INT_INTACK_ODMA0_IRQ_ACK_SHIFT 9
#define  CISX_INT_INTACK_ODMA0_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_ODMA0_IRQ_ACK_MASK) >> CISX_INT_INTACK_ODMA0_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_ODMA0_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_ODMA0_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_ODMA0_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_IDMA1_IRQ_ACK_MASK 0x100
#define  CISX_INT_INTACK_IDMA1_IRQ_ACK_SHIFT 8
#define  CISX_INT_INTACK_IDMA1_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_IDMA1_IRQ_ACK_MASK) >> CISX_INT_INTACK_IDMA1_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_IDMA1_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_IDMA1_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_IDMA1_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_IDMA0_IRQ_ACK_MASK 0x80
#define  CISX_INT_INTACK_IDMA0_IRQ_ACK_SHIFT 7
#define  CISX_INT_INTACK_IDMA0_IRQ_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_IDMA0_IRQ_ACK_MASK) >> CISX_INT_INTACK_IDMA0_IRQ_ACK_SHIFT)
#define  CISX_INT_INTACK_IDMA0_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_IDMA0_IRQ_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_IDMA0_IRQ_ACK_SHIFT))

#define  CISX_INT_INTACK_DMABUSERR_ACK_MASK 0x40
#define  CISX_INT_INTACK_DMABUSERR_ACK_SHIFT 6
#define  CISX_INT_INTACK_DMABUSERR_ACK_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_DMABUSERR_ACK_MASK) >> CISX_INT_INTACK_DMABUSERR_ACK_SHIFT)
#define  CISX_INT_INTACK_DMABUSERR_ACK_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_DMABUSERR_ACK_MASK) | (((uint32_t)val) << CISX_INT_INTACK_DMABUSERR_ACK_SHIFT))

#define  CISX_INT_INTACK_RESERVED2_MASK 0x3f
#define  CISX_INT_INTACK_RESERVED2_SHIFT 0
#define  CISX_INT_INTACK_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_INTACK_RESERVED2_MASK) >> CISX_INT_INTACK_RESERVED2_SHIFT)
#define  CISX_INT_INTACK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTACK_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_INTACK_RESERVED2_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IntForce)
//====================================================================

#define  CISX_INT_INTFORCE_RESERVED1_MASK 0xffff0000
#define  CISX_INT_INTFORCE_RESERVED1_SHIFT 16
#define  CISX_INT_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_RESERVED1_MASK) >> CISX_INT_INTFORCE_RESERVED1_SHIFT)
#define  CISX_INT_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_RESERVED1_SHIFT))

#define  CISX_INT_INTFORCE_IMAGEDONE_FORCE_MASK 0x8000
#define  CISX_INT_INTFORCE_IMAGEDONE_FORCE_SHIFT 15
#define  CISX_INT_INTFORCE_IMAGEDONE_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_IMAGEDONE_FORCE_MASK) >> CISX_INT_INTFORCE_IMAGEDONE_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_IMAGEDONE_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_IMAGEDONE_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_IMAGEDONE_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_MASK 0x4000
#define  CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_SHIFT 14
#define  CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA5_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_MASK 0x2000
#define  CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_SHIFT 13
#define  CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA4_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_MASK 0x1000
#define  CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_SHIFT 12
#define  CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA3_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_MASK 0x800
#define  CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_SHIFT 11
#define  CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA2_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_MASK 0x400
#define  CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_SHIFT 10
#define  CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA1_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_MASK 0x200
#define  CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_SHIFT 9
#define  CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_ODMA0_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_MASK 0x100
#define  CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_SHIFT 8
#define  CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_IDMA1_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_MASK 0x80
#define  CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_SHIFT 7
#define  CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_MASK) >> CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_IDMA0_IRQ_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_DMABUSERR_FORCE_MASK 0x40
#define  CISX_INT_INTFORCE_DMABUSERR_FORCE_SHIFT 6
#define  CISX_INT_INTFORCE_DMABUSERR_FORCE_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_DMABUSERR_FORCE_MASK) >> CISX_INT_INTFORCE_DMABUSERR_FORCE_SHIFT)
#define  CISX_INT_INTFORCE_DMABUSERR_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_DMABUSERR_FORCE_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_DMABUSERR_FORCE_SHIFT))

#define  CISX_INT_INTFORCE_RESERVED2_MASK 0x3f
#define  CISX_INT_INTFORCE_RESERVED2_SHIFT 0
#define  CISX_INT_INTFORCE_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_INTFORCE_RESERVED2_MASK) >> CISX_INT_INTFORCE_RESERVED2_SHIFT)
#define  CISX_INT_INTFORCE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_INTFORCE_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_INTFORCE_RESERVED2_SHIFT))

//====================================================================
//Register: Color Out, ODMA Destination Table Count (TBL_CNT)
//====================================================================

#define  CISX_INT_TBL_CNT_RESERVED1_MASK 0xfffc0000
#define  CISX_INT_TBL_CNT_RESERVED1_SHIFT 18
#define  CISX_INT_TBL_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_TBL_CNT_RESERVED1_MASK) >> CISX_INT_TBL_CNT_RESERVED1_SHIFT)
#define  CISX_INT_TBL_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_TBL_CNT_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_TBL_CNT_RESERVED1_SHIFT))

#define  CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_MASK 0x30000
#define  CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_SHIFT 16
#define  CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_MASK_SHIFT(reg) (((reg) & CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_MASK) >> CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_SHIFT)
#define  CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_MASK) | (((uint32_t)val) << CISX_INT_TBL_CNT_COLOR_OUT_TBL_CNT_SHIFT))

#define  CISX_INT_TBL_CNT_RESERVED2_MASK 0xffc0
#define  CISX_INT_TBL_CNT_RESERVED2_SHIFT 6
#define  CISX_INT_TBL_CNT_RESERVED2_MASK_SHIFT(reg) (((reg) & CISX_INT_TBL_CNT_RESERVED2_MASK) >> CISX_INT_TBL_CNT_RESERVED2_SHIFT)
#define  CISX_INT_TBL_CNT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_TBL_CNT_RESERVED2_MASK) | (((uint32_t)val) << CISX_INT_TBL_CNT_RESERVED2_SHIFT))

#define  CISX_INT_TBL_CNT_ODMA_TBL_CNT_MASK 0x3f
#define  CISX_INT_TBL_CNT_ODMA_TBL_CNT_SHIFT 0
#define  CISX_INT_TBL_CNT_ODMA_TBL_CNT_MASK_SHIFT(reg) (((reg) & CISX_INT_TBL_CNT_ODMA_TBL_CNT_MASK) >> CISX_INT_TBL_CNT_ODMA_TBL_CNT_SHIFT)
#define  CISX_INT_TBL_CNT_ODMA_TBL_CNT_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_TBL_CNT_ODMA_TBL_CNT_MASK) | (((uint32_t)val) << CISX_INT_TBL_CNT_ODMA_TBL_CNT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
        This register is of particular interest to firmware.*/
//====================================================================

#define  CISX_INT_REV0_MAJ_MASK 0xffff0000
#define  CISX_INT_REV0_MAJ_SHIFT 16
#define  CISX_INT_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CISX_INT_REV0_MAJ_MASK) >> CISX_INT_REV0_MAJ_SHIFT)
#define  CISX_INT_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_REV0_MAJ_MASK) | (((uint32_t)val) << CISX_INT_REV0_MAJ_SHIFT))

#define  CISX_INT_REV0_MID_MASK 0xffff
#define  CISX_INT_REV0_MID_SHIFT 0
#define  CISX_INT_REV0_MID_MASK_SHIFT(reg) (((reg) & CISX_INT_REV0_MID_MASK) >> CISX_INT_REV0_MID_SHIFT)
#define  CISX_INT_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_REV0_MID_MASK) | (((uint32_t)val) << CISX_INT_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CISX_INT_REV1_RESERVED1_MASK 0xffff0000
#define  CISX_INT_REV1_RESERVED1_SHIFT 16
#define  CISX_INT_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_REV1_RESERVED1_MASK) >> CISX_INT_REV1_RESERVED1_SHIFT)
#define  CISX_INT_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_REV1_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_REV1_RESERVED1_SHIFT))

#define  CISX_INT_REV1_CFG_MASK 0xffff
#define  CISX_INT_REV1_CFG_SHIFT 0
#define  CISX_INT_REV1_CFG_MASK_SHIFT(reg) (((reg) & CISX_INT_REV1_CFG_MASK) >> CISX_INT_REV1_CFG_SHIFT)
#define  CISX_INT_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_REV1_CFG_MASK) | (((uint32_t)val) << CISX_INT_REV1_CFG_SHIFT))

//====================================================================
//Register: ODMA Destination Table LUT (ODMA_TBL_LUT)
//====================================================================

#define  CISX_INT_ODMA_TBL_LUT_RESERVED1_MASK 0xfffffff0
#define  CISX_INT_ODMA_TBL_LUT_RESERVED1_SHIFT 4
#define  CISX_INT_ODMA_TBL_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_ODMA_TBL_LUT_RESERVED1_MASK) >> CISX_INT_ODMA_TBL_LUT_RESERVED1_SHIFT)
#define  CISX_INT_ODMA_TBL_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_ODMA_TBL_LUT_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_ODMA_TBL_LUT_RESERVED1_SHIFT))

#define  CISX_INT_ODMA_TBL_LUT_D_MASK 0xf
#define  CISX_INT_ODMA_TBL_LUT_D_SHIFT 0
#define  CISX_INT_ODMA_TBL_LUT_D_MASK_SHIFT(reg) (((reg) & CISX_INT_ODMA_TBL_LUT_D_MASK) >> CISX_INT_ODMA_TBL_LUT_D_SHIFT)
#define  CISX_INT_ODMA_TBL_LUT_D_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_ODMA_TBL_LUT_D_MASK) | (((uint32_t)val) << CISX_INT_ODMA_TBL_LUT_D_SHIFT))

//====================================================================
//Register: Color Out Table LUT (COLOR_OUT_TBL_LUT)
//====================================================================

#define  CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_MASK 0xfffffffc
#define  CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_SHIFT 2
#define  CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_MASK) >> CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_SHIFT)
#define  CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_MASK) | (((uint32_t)val) << CISX_INT_COLOR_OUT_TBL_LUT_RESERVED1_SHIFT))

#define  CISX_INT_COLOR_OUT_TBL_LUT_D_MASK 0x3
#define  CISX_INT_COLOR_OUT_TBL_LUT_D_SHIFT 0
#define  CISX_INT_COLOR_OUT_TBL_LUT_D_MASK_SHIFT(reg) (((reg) & CISX_INT_COLOR_OUT_TBL_LUT_D_MASK) >> CISX_INT_COLOR_OUT_TBL_LUT_D_SHIFT)
#define  CISX_INT_COLOR_OUT_TBL_LUT_D_REPLACE_VAL(reg,val) (((reg) & ~CISX_INT_COLOR_OUT_TBL_LUT_D_MASK) | (((uint32_t)val) << CISX_INT_COLOR_OUT_TBL_LUT_D_SHIFT))

#endif // CISX_INT
