 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CDMA_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CDMA_REGSTRUCTS_H_
#define _CDMA_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CDMA AXI Registers (CDMA)
/** \brief Register descriptions for the CDMA block*/
//
//====================================================================

typedef struct CDMA_REGS_s
{
  volatile uint32_t CFG;  ///< 0x0 [R/W]: DMA Configuration Register
  volatile uint32_t Control;  ///< 0x4 [R/W]: DMA Control Register
  volatile uint32_t Status;  ///< 0x8 [R]: DMA Status Register
  volatile uint32_t reserved0;
  volatile uint32_t CPR;  ///< 0x10 [R]: CDMA Parameter Register
  volatile uint32_t CDR;  ///< 0x14 [R/W]: CDMA Descriptor Register
  volatile uint32_t CNDAR;  ///< 0x18 [R]: CDMA Next Descriptor Address Register
  volatile uint32_t FillValue;  ///< 0x1c [R/W]: Fill Value Register
  volatile uint32_t intEn;  ///< 0x20 [R/W]: CDMA Interrupt Enable Register
  volatile uint32_t intPend;  ///< 0x24 [R]: CDMA Interrupt Pending Register
  volatile uint32_t intAck;  ///< 0x28 [W]: CDMA Interrupt Acknowledge Register
  volatile uint32_t intForce;  ///< 0x2c [W]: CDMA Interrupt Force Register
  volatile uint32_t TimerControl;  ///< 0x30 [R/W]: CDMA Timer Control Register
  volatile uint32_t TimeOutStat;  ///< 0x34 [R]: CDMA Timeout Count Status Register
  volatile uint32_t CRBAR;  ///< 0x38 [R]: CDMA Read Burst Address Register
  volatile uint32_t CRBLR;  ///< 0x3c [R]: CDMA Read Burst Length Register
  volatile uint32_t CWBAR;  ///< 0x40 [R]: CDMA Write Burst Address Register
  volatile uint32_t CWBLR;  ///< 0x44 [R]: CDMA Write Burst Length Register
  volatile uint32_t CWBRR;  ///< 0x48 [R]: CDMA Write Bytes Remain Register
  volatile uint32_t CSRR;  ///< 0x4c [R/W]: DMA Save/Restore Control Register
  volatile uint32_t CSRLI;  ///< 0x50 [R/W]: Save/Restore Lower DMA ID Register
  volatile uint32_t CSRUI;  ///< 0x54 [R/W]: Save/Restore Upper DMA ID Register
  volatile uint32_t CRSL;  ///< 0x58 [R]: DMA Lower Request Status Register
  volatile uint32_t CRSU;  ///< 0x5c [R]: DMA Upper Request Stautus Register
  volatile uint32_t CAFR;  ///< 0x60 [W]: DMA Ack Force Register
} CDMA_REGS_t;

#endif // CDMA
