 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CDMA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CDMA_REGMASKS_H_
#define _CDMA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CDMA AXI Registers (CDMA)
/** \brief Register descriptions for the CDMA block*/
//
//====================================================================

//====================================================================
//Register: DMA Configuration Register (CFG)
//====================================================================

#define  CDMA_CFG_WRDELAY_MASK 0xf0000000
#define  CDMA_CFG_WRDELAY_SHIFT 28
#define  CDMA_CFG_WRDELAY_MASK_SHIFT(reg) (((reg) & CDMA_CFG_WRDELAY_MASK) >> CDMA_CFG_WRDELAY_SHIFT)
#define  CDMA_CFG_WRDELAY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_WRDELAY_MASK) | (((uint32_t)val) << CDMA_CFG_WRDELAY_SHIFT))

#define  CDMA_CFG_RESERVED1_MASK 0x8000000
#define  CDMA_CFG_RESERVED1_SHIFT 27
#define  CDMA_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CFG_RESERVED1_MASK) >> CDMA_CFG_RESERVED1_SHIFT)
#define  CDMA_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CFG_RESERVED1_SHIFT))

#define  CDMA_CFG_SAVERESTOREEN_MASK 0x4000000
#define  CDMA_CFG_SAVERESTOREEN_SHIFT 26
#define  CDMA_CFG_SAVERESTOREEN_MASK_SHIFT(reg) (((reg) & CDMA_CFG_SAVERESTOREEN_MASK) >> CDMA_CFG_SAVERESTOREEN_SHIFT)
#define  CDMA_CFG_SAVERESTOREEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_SAVERESTOREEN_MASK) | (((uint32_t)val) << CDMA_CFG_SAVERESTOREEN_SHIFT))

#define  CDMA_CFG_DATAUNITSIZE_MASK 0x3000000
#define  CDMA_CFG_DATAUNITSIZE_SHIFT 24
#define  CDMA_CFG_DATAUNITSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CFG_DATAUNITSIZE_MASK) >> CDMA_CFG_DATAUNITSIZE_SHIFT)
#define  CDMA_CFG_DATAUNITSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_DATAUNITSIZE_MASK) | (((uint32_t)val) << CDMA_CFG_DATAUNITSIZE_SHIFT))

#define  CDMA_CFG_HALT_MASK 0x800000
#define  CDMA_CFG_HALT_SHIFT 23
#define  CDMA_CFG_HALT_MASK_SHIFT(reg) (((reg) & CDMA_CFG_HALT_MASK) >> CDMA_CFG_HALT_SHIFT)
#define  CDMA_CFG_HALT_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_HALT_MASK) | (((uint32_t)val) << CDMA_CFG_HALT_SHIFT))

#define  CDMA_CFG_RESERVED2_MASK 0x400000
#define  CDMA_CFG_RESERVED2_SHIFT 22
#define  CDMA_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & CDMA_CFG_RESERVED2_MASK) >> CDMA_CFG_RESERVED2_SHIFT)
#define  CDMA_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_RESERVED2_MASK) | (((uint32_t)val) << CDMA_CFG_RESERVED2_SHIFT))

#define  CDMA_CFG_FLOWCTRL_MASK 0x300000
#define  CDMA_CFG_FLOWCTRL_SHIFT 20
#define  CDMA_CFG_FLOWCTRL_MASK_SHIFT(reg) (((reg) & CDMA_CFG_FLOWCTRL_MASK) >> CDMA_CFG_FLOWCTRL_SHIFT)
#define  CDMA_CFG_FLOWCTRL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_FLOWCTRL_MASK) | (((uint32_t)val) << CDMA_CFG_FLOWCTRL_SHIFT))

#define  CDMA_CFG_RESERVED3_MASK 0xc0000
#define  CDMA_CFG_RESERVED3_SHIFT 18
#define  CDMA_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & CDMA_CFG_RESERVED3_MASK) >> CDMA_CFG_RESERVED3_SHIFT)
#define  CDMA_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_RESERVED3_MASK) | (((uint32_t)val) << CDMA_CFG_RESERVED3_SHIFT))

#define  CDMA_CFG_DESTPID_MASK 0x3f000
#define  CDMA_CFG_DESTPID_SHIFT 12
#define  CDMA_CFG_DESTPID_MASK_SHIFT(reg) (((reg) & CDMA_CFG_DESTPID_MASK) >> CDMA_CFG_DESTPID_SHIFT)
#define  CDMA_CFG_DESTPID_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_DESTPID_MASK) | (((uint32_t)val) << CDMA_CFG_DESTPID_SHIFT))

#define  CDMA_CFG_RESERVED4_MASK 0xc00
#define  CDMA_CFG_RESERVED4_SHIFT 10
#define  CDMA_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & CDMA_CFG_RESERVED4_MASK) >> CDMA_CFG_RESERVED4_SHIFT)
#define  CDMA_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_RESERVED4_MASK) | (((uint32_t)val) << CDMA_CFG_RESERVED4_SHIFT))

#define  CDMA_CFG_SRCPID_MASK 0x3f0
#define  CDMA_CFG_SRCPID_SHIFT 4
#define  CDMA_CFG_SRCPID_MASK_SHIFT(reg) (((reg) & CDMA_CFG_SRCPID_MASK) >> CDMA_CFG_SRCPID_SHIFT)
#define  CDMA_CFG_SRCPID_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_SRCPID_MASK) | (((uint32_t)val) << CDMA_CFG_SRCPID_SHIFT))

#define  CDMA_CFG_DESTENDIAN_MASK 0x8
#define  CDMA_CFG_DESTENDIAN_SHIFT 3
#define  CDMA_CFG_DESTENDIAN_MASK_SHIFT(reg) (((reg) & CDMA_CFG_DESTENDIAN_MASK) >> CDMA_CFG_DESTENDIAN_SHIFT)
#define  CDMA_CFG_DESTENDIAN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_DESTENDIAN_MASK) | (((uint32_t)val) << CDMA_CFG_DESTENDIAN_SHIFT))

#define  CDMA_CFG_SRCENDIAN_MASK 0x4
#define  CDMA_CFG_SRCENDIAN_SHIFT 2
#define  CDMA_CFG_SRCENDIAN_MASK_SHIFT(reg) (((reg) & CDMA_CFG_SRCENDIAN_MASK) >> CDMA_CFG_SRCENDIAN_SHIFT)
#define  CDMA_CFG_SRCENDIAN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_SRCENDIAN_MASK) | (((uint32_t)val) << CDMA_CFG_SRCENDIAN_SHIFT))

#define  CDMA_CFG_FILL_MASK 0x2
#define  CDMA_CFG_FILL_SHIFT 1
#define  CDMA_CFG_FILL_MASK_SHIFT(reg) (((reg) & CDMA_CFG_FILL_MASK) >> CDMA_CFG_FILL_SHIFT)
#define  CDMA_CFG_FILL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_FILL_MASK) | (((uint32_t)val) << CDMA_CFG_FILL_SHIFT))

#define  CDMA_CFG_ENABLE_MASK 0x1
#define  CDMA_CFG_ENABLE_SHIFT 0
#define  CDMA_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & CDMA_CFG_ENABLE_MASK) >> CDMA_CFG_ENABLE_SHIFT)
#define  CDMA_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CFG_ENABLE_MASK) | (((uint32_t)val) << CDMA_CFG_ENABLE_SHIFT))

//====================================================================
//Register: DMA Control Register (Control)
//====================================================================

#define  CDMA_CONTROL_RESERVED1_MASK 0xc0000000
#define  CDMA_CONTROL_RESERVED1_SHIFT 30
#define  CDMA_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_RESERVED1_MASK) >> CDMA_CONTROL_RESERVED1_SHIFT)
#define  CDMA_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CONTROL_RESERVED1_SHIFT))

#define  CDMA_CONTROL_DATAAXCACHE_MASK 0x3c000000
#define  CDMA_CONTROL_DATAAXCACHE_SHIFT 26
#define  CDMA_CONTROL_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DATAAXCACHE_MASK) >> CDMA_CONTROL_DATAAXCACHE_SHIFT)
#define  CDMA_CONTROL_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DATAAXCACHE_MASK) | (((uint32_t)val) << CDMA_CONTROL_DATAAXCACHE_SHIFT))

#define  CDMA_CONTROL_DESCARCACHE_MASK 0x3c00000
#define  CDMA_CONTROL_DESCARCACHE_SHIFT 22
#define  CDMA_CONTROL_DESCARCACHE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DESCARCACHE_MASK) >> CDMA_CONTROL_DESCARCACHE_SHIFT)
#define  CDMA_CONTROL_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DESCARCACHE_MASK) | (((uint32_t)val) << CDMA_CONTROL_DESCARCACHE_SHIFT))

#define  CDMA_CONTROL_DESCAWCACHE_MASK 0x3c0000
#define  CDMA_CONTROL_DESCAWCACHE_SHIFT 18
#define  CDMA_CONTROL_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DESCAWCACHE_MASK) >> CDMA_CONTROL_DESCAWCACHE_SHIFT)
#define  CDMA_CONTROL_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DESCAWCACHE_MASK) | (((uint32_t)val) << CDMA_CONTROL_DESCAWCACHE_SHIFT))

#define  CDMA_CONTROL_OWNWRITEDISABLE_MASK 0x20000
#define  CDMA_CONTROL_OWNWRITEDISABLE_SHIFT 17
#define  CDMA_CONTROL_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_OWNWRITEDISABLE_MASK) >> CDMA_CONTROL_OWNWRITEDISABLE_SHIFT)
#define  CDMA_CONTROL_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << CDMA_CONTROL_OWNWRITEDISABLE_SHIFT))

#define  CDMA_CONTROL_OWNPOLARITY_MASK 0x10000
#define  CDMA_CONTROL_OWNPOLARITY_SHIFT 16
#define  CDMA_CONTROL_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_OWNPOLARITY_MASK) >> CDMA_CONTROL_OWNPOLARITY_SHIFT)
#define  CDMA_CONTROL_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_OWNPOLARITY_MASK) | (((uint32_t)val) << CDMA_CONTROL_OWNPOLARITY_SHIFT))

#define  CDMA_CONTROL_RESERVED2_MASK 0xc000
#define  CDMA_CONTROL_RESERVED2_SHIFT 14
#define  CDMA_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_RESERVED2_MASK) >> CDMA_CONTROL_RESERVED2_SHIFT)
#define  CDMA_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << CDMA_CONTROL_RESERVED2_SHIFT))

#define  CDMA_CONTROL_DESTADDRINC_MASK 0x2000
#define  CDMA_CONTROL_DESTADDRINC_SHIFT 13
#define  CDMA_CONTROL_DESTADDRINC_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DESTADDRINC_MASK) >> CDMA_CONTROL_DESTADDRINC_SHIFT)
#define  CDMA_CONTROL_DESTADDRINC_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DESTADDRINC_MASK) | (((uint32_t)val) << CDMA_CONTROL_DESTADDRINC_SHIFT))

#define  CDMA_CONTROL_SRCADDRINC_MASK 0x1000
#define  CDMA_CONTROL_SRCADDRINC_SHIFT 12
#define  CDMA_CONTROL_SRCADDRINC_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_SRCADDRINC_MASK) >> CDMA_CONTROL_SRCADDRINC_SHIFT)
#define  CDMA_CONTROL_SRCADDRINC_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_SRCADDRINC_MASK) | (((uint32_t)val) << CDMA_CONTROL_SRCADDRINC_SHIFT))

#define  CDMA_CONTROL_DESTXFERWIDTH_MASK 0xc00
#define  CDMA_CONTROL_DESTXFERWIDTH_SHIFT 10
#define  CDMA_CONTROL_DESTXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DESTXFERWIDTH_MASK) >> CDMA_CONTROL_DESTXFERWIDTH_SHIFT)
#define  CDMA_CONTROL_DESTXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DESTXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CONTROL_DESTXFERWIDTH_SHIFT))

#define  CDMA_CONTROL_SRCXFERWIDTH_MASK 0x300
#define  CDMA_CONTROL_SRCXFERWIDTH_SHIFT 8
#define  CDMA_CONTROL_SRCXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_SRCXFERWIDTH_MASK) >> CDMA_CONTROL_SRCXFERWIDTH_SHIFT)
#define  CDMA_CONTROL_SRCXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_SRCXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CONTROL_SRCXFERWIDTH_SHIFT))

#define  CDMA_CONTROL_RESERVED3_MASK 0xc0
#define  CDMA_CONTROL_RESERVED3_SHIFT 6
#define  CDMA_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_RESERVED3_MASK) >> CDMA_CONTROL_RESERVED3_SHIFT)
#define  CDMA_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << CDMA_CONTROL_RESERVED3_SHIFT))

#define  CDMA_CONTROL_DESTBURSTSIZE_MASK 0x30
#define  CDMA_CONTROL_DESTBURSTSIZE_SHIFT 4
#define  CDMA_CONTROL_DESTBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_DESTBURSTSIZE_MASK) >> CDMA_CONTROL_DESTBURSTSIZE_SHIFT)
#define  CDMA_CONTROL_DESTBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_DESTBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CONTROL_DESTBURSTSIZE_SHIFT))

#define  CDMA_CONTROL_RESERVED4_MASK 0xc
#define  CDMA_CONTROL_RESERVED4_SHIFT 2
#define  CDMA_CONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_RESERVED4_MASK) >> CDMA_CONTROL_RESERVED4_SHIFT)
#define  CDMA_CONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_RESERVED4_MASK) | (((uint32_t)val) << CDMA_CONTROL_RESERVED4_SHIFT))

#define  CDMA_CONTROL_SRCBURSTSIZE_MASK 0x3
#define  CDMA_CONTROL_SRCBURSTSIZE_SHIFT 0
#define  CDMA_CONTROL_SRCBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CONTROL_SRCBURSTSIZE_MASK) >> CDMA_CONTROL_SRCBURSTSIZE_SHIFT)
#define  CDMA_CONTROL_SRCBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CONTROL_SRCBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CONTROL_SRCBURSTSIZE_SHIFT))

//====================================================================
//Register: DMA Status Register (Status)
//====================================================================

#define  CDMA_STATUS_RESERVED1_MASK 0xe0000000
#define  CDMA_STATUS_RESERVED1_SHIFT 29
#define  CDMA_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_RESERVED1_MASK) >> CDMA_STATUS_RESERVED1_SHIFT)
#define  CDMA_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_RESERVED1_MASK) | (((uint32_t)val) << CDMA_STATUS_RESERVED1_SHIFT))

#define  CDMA_STATUS_HSSTATE_MASK 0x1c000000
#define  CDMA_STATUS_HSSTATE_SHIFT 26
#define  CDMA_STATUS_HSSTATE_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_HSSTATE_MASK) >> CDMA_STATUS_HSSTATE_SHIFT)
#define  CDMA_STATUS_HSSTATE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_HSSTATE_MASK) | (((uint32_t)val) << CDMA_STATUS_HSSTATE_SHIFT))

#define  CDMA_STATUS_SRSTATE_MASK 0x3c00000
#define  CDMA_STATUS_SRSTATE_SHIFT 22
#define  CDMA_STATUS_SRSTATE_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_SRSTATE_MASK) >> CDMA_STATUS_SRSTATE_SHIFT)
#define  CDMA_STATUS_SRSTATE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_SRSTATE_MASK) | (((uint32_t)val) << CDMA_STATUS_SRSTATE_SHIFT))

#define  CDMA_STATUS_DMASTATE_MASK 0x3e0000
#define  CDMA_STATUS_DMASTATE_SHIFT 17
#define  CDMA_STATUS_DMASTATE_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_DMASTATE_MASK) >> CDMA_STATUS_DMASTATE_SHIFT)
#define  CDMA_STATUS_DMASTATE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_DMASTATE_MASK) | (((uint32_t)val) << CDMA_STATUS_DMASTATE_SHIFT))

#define  CDMA_STATUS_DMAPAUSED_MASK 0x10000
#define  CDMA_STATUS_DMAPAUSED_SHIFT 16
#define  CDMA_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_DMAPAUSED_MASK) >> CDMA_STATUS_DMAPAUSED_SHIFT)
#define  CDMA_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << CDMA_STATUS_DMAPAUSED_SHIFT))

#define  CDMA_STATUS_PAUSEAFTER_MASK 0x8000
#define  CDMA_STATUS_PAUSEAFTER_SHIFT 15
#define  CDMA_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_PAUSEAFTER_MASK) >> CDMA_STATUS_PAUSEAFTER_SHIFT)
#define  CDMA_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << CDMA_STATUS_PAUSEAFTER_SHIFT))

#define  CDMA_STATUS_PAUSEBEFORE_MASK 0x4000
#define  CDMA_STATUS_PAUSEBEFORE_SHIFT 14
#define  CDMA_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_PAUSEBEFORE_MASK) >> CDMA_STATUS_PAUSEBEFORE_SHIFT)
#define  CDMA_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << CDMA_STATUS_PAUSEBEFORE_SHIFT))

#define  CDMA_STATUS_INTONFINISH_MASK 0x2000
#define  CDMA_STATUS_INTONFINISH_SHIFT 13
#define  CDMA_STATUS_INTONFINISH_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_INTONFINISH_MASK) >> CDMA_STATUS_INTONFINISH_SHIFT)
#define  CDMA_STATUS_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_INTONFINISH_MASK) | (((uint32_t)val) << CDMA_STATUS_INTONFINISH_SHIFT))

#define  CDMA_STATUS_STOPONFINISH_MASK 0x1000
#define  CDMA_STATUS_STOPONFINISH_SHIFT 12
#define  CDMA_STATUS_STOPONFINISH_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_STOPONFINISH_MASK) >> CDMA_STATUS_STOPONFINISH_SHIFT)
#define  CDMA_STATUS_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_STOPONFINISH_MASK) | (((uint32_t)val) << CDMA_STATUS_STOPONFINISH_SHIFT))

#define  CDMA_STATUS_UNPACKFULL_MASK 0x800
#define  CDMA_STATUS_UNPACKFULL_SHIFT 11
#define  CDMA_STATUS_UNPACKFULL_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_UNPACKFULL_MASK) >> CDMA_STATUS_UNPACKFULL_SHIFT)
#define  CDMA_STATUS_UNPACKFULL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_UNPACKFULL_MASK) | (((uint32_t)val) << CDMA_STATUS_UNPACKFULL_SHIFT))

#define  CDMA_STATUS_UNPACKEMPTY_MASK 0x400
#define  CDMA_STATUS_UNPACKEMPTY_SHIFT 10
#define  CDMA_STATUS_UNPACKEMPTY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_UNPACKEMPTY_MASK) >> CDMA_STATUS_UNPACKEMPTY_SHIFT)
#define  CDMA_STATUS_UNPACKEMPTY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_UNPACKEMPTY_MASK) | (((uint32_t)val) << CDMA_STATUS_UNPACKEMPTY_SHIFT))

#define  CDMA_STATUS_PACKFULL_MASK 0x200
#define  CDMA_STATUS_PACKFULL_SHIFT 9
#define  CDMA_STATUS_PACKFULL_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_PACKFULL_MASK) >> CDMA_STATUS_PACKFULL_SHIFT)
#define  CDMA_STATUS_PACKFULL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_PACKFULL_MASK) | (((uint32_t)val) << CDMA_STATUS_PACKFULL_SHIFT))

#define  CDMA_STATUS_PACKEMPTY_MASK 0x100
#define  CDMA_STATUS_PACKEMPTY_SHIFT 8
#define  CDMA_STATUS_PACKEMPTY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_PACKEMPTY_MASK) >> CDMA_STATUS_PACKEMPTY_SHIFT)
#define  CDMA_STATUS_PACKEMPTY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_PACKEMPTY_MASK) | (((uint32_t)val) << CDMA_STATUS_PACKEMPTY_SHIFT))

#define  CDMA_STATUS_WRCMDBUFFULL_MASK 0x80
#define  CDMA_STATUS_WRCMDBUFFULL_SHIFT 7
#define  CDMA_STATUS_WRCMDBUFFULL_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_WRCMDBUFFULL_MASK) >> CDMA_STATUS_WRCMDBUFFULL_SHIFT)
#define  CDMA_STATUS_WRCMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_WRCMDBUFFULL_MASK) | (((uint32_t)val) << CDMA_STATUS_WRCMDBUFFULL_SHIFT))

#define  CDMA_STATUS_WRCMDBUFEMPTY_MASK 0x40
#define  CDMA_STATUS_WRCMDBUFEMPTY_SHIFT 6
#define  CDMA_STATUS_WRCMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_WRCMDBUFEMPTY_MASK) >> CDMA_STATUS_WRCMDBUFEMPTY_SHIFT)
#define  CDMA_STATUS_WRCMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_WRCMDBUFEMPTY_MASK) | (((uint32_t)val) << CDMA_STATUS_WRCMDBUFEMPTY_SHIFT))

#define  CDMA_STATUS_RDCMDBUFFULL_MASK 0x20
#define  CDMA_STATUS_RDCMDBUFFULL_SHIFT 5
#define  CDMA_STATUS_RDCMDBUFFULL_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_RDCMDBUFFULL_MASK) >> CDMA_STATUS_RDCMDBUFFULL_SHIFT)
#define  CDMA_STATUS_RDCMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_RDCMDBUFFULL_MASK) | (((uint32_t)val) << CDMA_STATUS_RDCMDBUFFULL_SHIFT))

#define  CDMA_STATUS_RDCMDBUFEMPTY_MASK 0x10
#define  CDMA_STATUS_RDCMDBUFEMPTY_SHIFT 4
#define  CDMA_STATUS_RDCMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_RDCMDBUFEMPTY_MASK) >> CDMA_STATUS_RDCMDBUFEMPTY_SHIFT)
#define  CDMA_STATUS_RDCMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_RDCMDBUFEMPTY_MASK) | (((uint32_t)val) << CDMA_STATUS_RDCMDBUFEMPTY_SHIFT))

#define  CDMA_STATUS_DATABUFFULL_MASK 0x8
#define  CDMA_STATUS_DATABUFFULL_SHIFT 3
#define  CDMA_STATUS_DATABUFFULL_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_DATABUFFULL_MASK) >> CDMA_STATUS_DATABUFFULL_SHIFT)
#define  CDMA_STATUS_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_DATABUFFULL_MASK) | (((uint32_t)val) << CDMA_STATUS_DATABUFFULL_SHIFT))

#define  CDMA_STATUS_DATABUFEMPTY_MASK 0x4
#define  CDMA_STATUS_DATABUFEMPTY_SHIFT 2
#define  CDMA_STATUS_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_DATABUFEMPTY_MASK) >> CDMA_STATUS_DATABUFEMPTY_SHIFT)
#define  CDMA_STATUS_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_DATABUFEMPTY_MASK) | (((uint32_t)val) << CDMA_STATUS_DATABUFEMPTY_SHIFT))

#define  CDMA_STATUS_CLEAR_MASK 0x2
#define  CDMA_STATUS_CLEAR_SHIFT 1
#define  CDMA_STATUS_CLEAR_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_CLEAR_MASK) >> CDMA_STATUS_CLEAR_SHIFT)
#define  CDMA_STATUS_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_CLEAR_MASK) | (((uint32_t)val) << CDMA_STATUS_CLEAR_SHIFT))

#define  CDMA_STATUS_BUSY_MASK 0x1
#define  CDMA_STATUS_BUSY_SHIFT 0
#define  CDMA_STATUS_BUSY_MASK_SHIFT(reg) (((reg) & CDMA_STATUS_BUSY_MASK) >> CDMA_STATUS_BUSY_SHIFT)
#define  CDMA_STATUS_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CDMA_STATUS_BUSY_MASK) | (((uint32_t)val) << CDMA_STATUS_BUSY_SHIFT))

//====================================================================
//Register: CDMA Parameter Register (CPR)
//====================================================================

#define  CDMA_CPR_LENGTHWIDTH_MASK 0xff000000
#define  CDMA_CPR_LENGTHWIDTH_SHIFT 24
#define  CDMA_CPR_LENGTHWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CPR_LENGTHWIDTH_MASK) >> CDMA_CPR_LENGTHWIDTH_SHIFT)
#define  CDMA_CPR_LENGTHWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_LENGTHWIDTH_MASK) | (((uint32_t)val) << CDMA_CPR_LENGTHWIDTH_SHIFT))

#define  CDMA_CPR_FIFODEPTH_MASK 0xffff00
#define  CDMA_CPR_FIFODEPTH_SHIFT 8
#define  CDMA_CPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & CDMA_CPR_FIFODEPTH_MASK) >> CDMA_CPR_FIFODEPTH_SHIFT)
#define  CDMA_CPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_FIFODEPTH_MASK) | (((uint32_t)val) << CDMA_CPR_FIFODEPTH_SHIFT))

#define  CDMA_CPR_RESERVED1_MASK 0xf0
#define  CDMA_CPR_RESERVED1_SHIFT 4
#define  CDMA_CPR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CPR_RESERVED1_MASK) >> CDMA_CPR_RESERVED1_SHIFT)
#define  CDMA_CPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CPR_RESERVED1_SHIFT))

#define  CDMA_CPR_SAVERESTORE_MASK 0x8
#define  CDMA_CPR_SAVERESTORE_SHIFT 3
#define  CDMA_CPR_SAVERESTORE_MASK_SHIFT(reg) (((reg) & CDMA_CPR_SAVERESTORE_MASK) >> CDMA_CPR_SAVERESTORE_SHIFT)
#define  CDMA_CPR_SAVERESTORE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_SAVERESTORE_MASK) | (((uint32_t)val) << CDMA_CPR_SAVERESTORE_SHIFT))

#define  CDMA_CPR_BUSWIDTH_MASK 0x4
#define  CDMA_CPR_BUSWIDTH_SHIFT 2
#define  CDMA_CPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CPR_BUSWIDTH_MASK) >> CDMA_CPR_BUSWIDTH_SHIFT)
#define  CDMA_CPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_BUSWIDTH_MASK) | (((uint32_t)val) << CDMA_CPR_BUSWIDTH_SHIFT))

#define  CDMA_CPR_MEMALIGN_MASK 0x3
#define  CDMA_CPR_MEMALIGN_SHIFT 0
#define  CDMA_CPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & CDMA_CPR_MEMALIGN_MASK) >> CDMA_CPR_MEMALIGN_SHIFT)
#define  CDMA_CPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CPR_MEMALIGN_MASK) | (((uint32_t)val) << CDMA_CPR_MEMALIGN_SHIFT))

//====================================================================
//Register: CDMA Descriptor Register (CDR)
//====================================================================

#define  CDMA_CDR_DESC_MASK 0xffffffff
#define  CDMA_CDR_DESC_SHIFT 0
#define  CDMA_CDR_DESC_MASK_SHIFT(reg) (((reg) & CDMA_CDR_DESC_MASK) >> CDMA_CDR_DESC_SHIFT)
#define  CDMA_CDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CDR_DESC_MASK) | (((uint32_t)val) << CDMA_CDR_DESC_SHIFT))

//====================================================================
//Register: CDMA Next Descriptor Address Register (CNDAR)
//====================================================================

#define  CDMA_CNDAR_NEXTDESC_MASK 0xfffffffc
#define  CDMA_CNDAR_NEXTDESC_SHIFT 2
#define  CDMA_CNDAR_NEXTDESC_MASK_SHIFT(reg) (((reg) & CDMA_CNDAR_NEXTDESC_MASK) >> CDMA_CNDAR_NEXTDESC_SHIFT)
#define  CDMA_CNDAR_NEXTDESC_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CNDAR_NEXTDESC_MASK) | (((uint32_t)val) << CDMA_CNDAR_NEXTDESC_SHIFT))

#define  CDMA_CNDAR_RESERVED1_MASK 0x3
#define  CDMA_CNDAR_RESERVED1_SHIFT 0
#define  CDMA_CNDAR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CNDAR_RESERVED1_MASK) >> CDMA_CNDAR_RESERVED1_SHIFT)
#define  CDMA_CNDAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CNDAR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CNDAR_RESERVED1_SHIFT))

//====================================================================
//Register: Fill Value Register (FillValue)
/** \brief This register contains the data value to write to the destination
      address.*/
//====================================================================

#define  CDMA_FILLVALUE_FILLVAL_MASK 0xffffffff
#define  CDMA_FILLVALUE_FILLVAL_SHIFT 0
#define  CDMA_FILLVALUE_FILLVAL_MASK_SHIFT(reg) (((reg) & CDMA_FILLVALUE_FILLVAL_MASK) >> CDMA_FILLVALUE_FILLVAL_SHIFT)
#define  CDMA_FILLVALUE_FILLVAL_REPLACE_VAL(reg,val) (((reg) & ~CDMA_FILLVALUE_FILLVAL_MASK) | (((uint32_t)val) << CDMA_FILLVALUE_FILLVAL_SHIFT))

//====================================================================
//Register: CDMA Interrupt Enable Register (intEn)
//====================================================================

#define  CDMA_INTEN_RESERVED1_MASK 0xfffffe00
#define  CDMA_INTEN_RESERVED1_SHIFT 9
#define  CDMA_INTEN_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_RESERVED1_MASK) >> CDMA_INTEN_RESERVED1_SHIFT)
#define  CDMA_INTEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_RESERVED1_MASK) | (((uint32_t)val) << CDMA_INTEN_RESERVED1_SHIFT))

#define  CDMA_INTEN_SRDONEEN_MASK 0x100
#define  CDMA_INTEN_SRDONEEN_SHIFT 8
#define  CDMA_INTEN_SRDONEEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_SRDONEEN_MASK) >> CDMA_INTEN_SRDONEEN_SHIFT)
#define  CDMA_INTEN_SRDONEEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_SRDONEEN_MASK) | (((uint32_t)val) << CDMA_INTEN_SRDONEEN_SHIFT))

#define  CDMA_INTEN_HALTDONEEN_MASK 0x80
#define  CDMA_INTEN_HALTDONEEN_SHIFT 7
#define  CDMA_INTEN_HALTDONEEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_HALTDONEEN_MASK) >> CDMA_INTEN_HALTDONEEN_SHIFT)
#define  CDMA_INTEN_HALTDONEEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_HALTDONEEN_MASK) | (((uint32_t)val) << CDMA_INTEN_HALTDONEEN_SHIFT))

#define  CDMA_INTEN_RRESPEN_MASK 0x40
#define  CDMA_INTEN_RRESPEN_SHIFT 6
#define  CDMA_INTEN_RRESPEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_RRESPEN_MASK) >> CDMA_INTEN_RRESPEN_SHIFT)
#define  CDMA_INTEN_RRESPEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_RRESPEN_MASK) | (((uint32_t)val) << CDMA_INTEN_RRESPEN_SHIFT))

#define  CDMA_INTEN_BRESPEN_MASK 0x20
#define  CDMA_INTEN_BRESPEN_SHIFT 5
#define  CDMA_INTEN_BRESPEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_BRESPEN_MASK) >> CDMA_INTEN_BRESPEN_SHIFT)
#define  CDMA_INTEN_BRESPEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_BRESPEN_MASK) | (((uint32_t)val) << CDMA_INTEN_BRESPEN_SHIFT))

#define  CDMA_INTEN_OWNEN_MASK 0x10
#define  CDMA_INTEN_OWNEN_SHIFT 4
#define  CDMA_INTEN_OWNEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_OWNEN_MASK) >> CDMA_INTEN_OWNEN_SHIFT)
#define  CDMA_INTEN_OWNEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_OWNEN_MASK) | (((uint32_t)val) << CDMA_INTEN_OWNEN_SHIFT))

#define  CDMA_INTEN_CLEARCOMPLETEEN_MASK 0x8
#define  CDMA_INTEN_CLEARCOMPLETEEN_SHIFT 3
#define  CDMA_INTEN_CLEARCOMPLETEEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_CLEARCOMPLETEEN_MASK) >> CDMA_INTEN_CLEARCOMPLETEEN_SHIFT)
#define  CDMA_INTEN_CLEARCOMPLETEEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_CLEARCOMPLETEEN_MASK) | (((uint32_t)val) << CDMA_INTEN_CLEARCOMPLETEEN_SHIFT))

#define  CDMA_INTEN_CHAINDONEEN_MASK 0x4
#define  CDMA_INTEN_CHAINDONEEN_SHIFT 2
#define  CDMA_INTEN_CHAINDONEEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_CHAINDONEEN_MASK) >> CDMA_INTEN_CHAINDONEEN_SHIFT)
#define  CDMA_INTEN_CHAINDONEEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_CHAINDONEEN_MASK) | (((uint32_t)val) << CDMA_INTEN_CHAINDONEEN_SHIFT))

#define  CDMA_INTEN_TIMEOUTEN_MASK 0x2
#define  CDMA_INTEN_TIMEOUTEN_SHIFT 1
#define  CDMA_INTEN_TIMEOUTEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_TIMEOUTEN_MASK) >> CDMA_INTEN_TIMEOUTEN_SHIFT)
#define  CDMA_INTEN_TIMEOUTEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_TIMEOUTEN_MASK) | (((uint32_t)val) << CDMA_INTEN_TIMEOUTEN_SHIFT))

#define  CDMA_INTEN_TERMCNTEN_MASK 0x1
#define  CDMA_INTEN_TERMCNTEN_SHIFT 0
#define  CDMA_INTEN_TERMCNTEN_MASK_SHIFT(reg) (((reg) & CDMA_INTEN_TERMCNTEN_MASK) >> CDMA_INTEN_TERMCNTEN_SHIFT)
#define  CDMA_INTEN_TERMCNTEN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTEN_TERMCNTEN_MASK) | (((uint32_t)val) << CDMA_INTEN_TERMCNTEN_SHIFT))

//====================================================================
//Register: CDMA Interrupt Pending Register (intPend)
//====================================================================

#define  CDMA_INTPEND_RESERVED1_MASK 0xfffffe00
#define  CDMA_INTPEND_RESERVED1_SHIFT 9
#define  CDMA_INTPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_RESERVED1_MASK) >> CDMA_INTPEND_RESERVED1_SHIFT)
#define  CDMA_INTPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_RESERVED1_MASK) | (((uint32_t)val) << CDMA_INTPEND_RESERVED1_SHIFT))

#define  CDMA_INTPEND_SRDONEPEND_MASK 0x100
#define  CDMA_INTPEND_SRDONEPEND_SHIFT 8
#define  CDMA_INTPEND_SRDONEPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_SRDONEPEND_MASK) >> CDMA_INTPEND_SRDONEPEND_SHIFT)
#define  CDMA_INTPEND_SRDONEPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_SRDONEPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_SRDONEPEND_SHIFT))

#define  CDMA_INTPEND_HALTDONEPEND_MASK 0x80
#define  CDMA_INTPEND_HALTDONEPEND_SHIFT 7
#define  CDMA_INTPEND_HALTDONEPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_HALTDONEPEND_MASK) >> CDMA_INTPEND_HALTDONEPEND_SHIFT)
#define  CDMA_INTPEND_HALTDONEPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_HALTDONEPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_HALTDONEPEND_SHIFT))

#define  CDMA_INTPEND_RRESPPEND_MASK 0x40
#define  CDMA_INTPEND_RRESPPEND_SHIFT 6
#define  CDMA_INTPEND_RRESPPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_RRESPPEND_MASK) >> CDMA_INTPEND_RRESPPEND_SHIFT)
#define  CDMA_INTPEND_RRESPPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_RRESPPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_RRESPPEND_SHIFT))

#define  CDMA_INTPEND_BRESPPEND_MASK 0x20
#define  CDMA_INTPEND_BRESPPEND_SHIFT 5
#define  CDMA_INTPEND_BRESPPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_BRESPPEND_MASK) >> CDMA_INTPEND_BRESPPEND_SHIFT)
#define  CDMA_INTPEND_BRESPPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_BRESPPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_BRESPPEND_SHIFT))

#define  CDMA_INTPEND_OWNPEND_MASK 0x10
#define  CDMA_INTPEND_OWNPEND_SHIFT 4
#define  CDMA_INTPEND_OWNPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_OWNPEND_MASK) >> CDMA_INTPEND_OWNPEND_SHIFT)
#define  CDMA_INTPEND_OWNPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_OWNPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_OWNPEND_SHIFT))

#define  CDMA_INTPEND_CLEARCOMPLETEPEND_MASK 0x8
#define  CDMA_INTPEND_CLEARCOMPLETEPEND_SHIFT 3
#define  CDMA_INTPEND_CLEARCOMPLETEPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_CLEARCOMPLETEPEND_MASK) >> CDMA_INTPEND_CLEARCOMPLETEPEND_SHIFT)
#define  CDMA_INTPEND_CLEARCOMPLETEPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_CLEARCOMPLETEPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_CLEARCOMPLETEPEND_SHIFT))

#define  CDMA_INTPEND_CHAINDONEPEND_MASK 0x4
#define  CDMA_INTPEND_CHAINDONEPEND_SHIFT 2
#define  CDMA_INTPEND_CHAINDONEPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_CHAINDONEPEND_MASK) >> CDMA_INTPEND_CHAINDONEPEND_SHIFT)
#define  CDMA_INTPEND_CHAINDONEPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_CHAINDONEPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_CHAINDONEPEND_SHIFT))

#define  CDMA_INTPEND_TIMEOUTPEND_MASK 0x2
#define  CDMA_INTPEND_TIMEOUTPEND_SHIFT 1
#define  CDMA_INTPEND_TIMEOUTPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_TIMEOUTPEND_MASK) >> CDMA_INTPEND_TIMEOUTPEND_SHIFT)
#define  CDMA_INTPEND_TIMEOUTPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_TIMEOUTPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_TIMEOUTPEND_SHIFT))

#define  CDMA_INTPEND_TERMCNTPEND_MASK 0x1
#define  CDMA_INTPEND_TERMCNTPEND_SHIFT 0
#define  CDMA_INTPEND_TERMCNTPEND_MASK_SHIFT(reg) (((reg) & CDMA_INTPEND_TERMCNTPEND_MASK) >> CDMA_INTPEND_TERMCNTPEND_SHIFT)
#define  CDMA_INTPEND_TERMCNTPEND_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTPEND_TERMCNTPEND_MASK) | (((uint32_t)val) << CDMA_INTPEND_TERMCNTPEND_SHIFT))

//====================================================================
//Register: CDMA Interrupt Acknowledge Register (intAck)
//====================================================================

#define  CDMA_INTACK_RESERVED1_MASK 0xfffffe00
#define  CDMA_INTACK_RESERVED1_SHIFT 9
#define  CDMA_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_RESERVED1_MASK) >> CDMA_INTACK_RESERVED1_SHIFT)
#define  CDMA_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_RESERVED1_MASK) | (((uint32_t)val) << CDMA_INTACK_RESERVED1_SHIFT))

#define  CDMA_INTACK_SRDONEACK_MASK 0x100
#define  CDMA_INTACK_SRDONEACK_SHIFT 8
#define  CDMA_INTACK_SRDONEACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_SRDONEACK_MASK) >> CDMA_INTACK_SRDONEACK_SHIFT)
#define  CDMA_INTACK_SRDONEACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_SRDONEACK_MASK) | (((uint32_t)val) << CDMA_INTACK_SRDONEACK_SHIFT))

#define  CDMA_INTACK_HALTDONEACK_MASK 0x80
#define  CDMA_INTACK_HALTDONEACK_SHIFT 7
#define  CDMA_INTACK_HALTDONEACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_HALTDONEACK_MASK) >> CDMA_INTACK_HALTDONEACK_SHIFT)
#define  CDMA_INTACK_HALTDONEACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_HALTDONEACK_MASK) | (((uint32_t)val) << CDMA_INTACK_HALTDONEACK_SHIFT))

#define  CDMA_INTACK_RRESPACK_MASK 0x40
#define  CDMA_INTACK_RRESPACK_SHIFT 6
#define  CDMA_INTACK_RRESPACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_RRESPACK_MASK) >> CDMA_INTACK_RRESPACK_SHIFT)
#define  CDMA_INTACK_RRESPACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_RRESPACK_MASK) | (((uint32_t)val) << CDMA_INTACK_RRESPACK_SHIFT))

#define  CDMA_INTACK_BRESPACK_MASK 0x20
#define  CDMA_INTACK_BRESPACK_SHIFT 5
#define  CDMA_INTACK_BRESPACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_BRESPACK_MASK) >> CDMA_INTACK_BRESPACK_SHIFT)
#define  CDMA_INTACK_BRESPACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_BRESPACK_MASK) | (((uint32_t)val) << CDMA_INTACK_BRESPACK_SHIFT))

#define  CDMA_INTACK_OWNACK_MASK 0x10
#define  CDMA_INTACK_OWNACK_SHIFT 4
#define  CDMA_INTACK_OWNACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_OWNACK_MASK) >> CDMA_INTACK_OWNACK_SHIFT)
#define  CDMA_INTACK_OWNACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_OWNACK_MASK) | (((uint32_t)val) << CDMA_INTACK_OWNACK_SHIFT))

#define  CDMA_INTACK_CLEARCOMPLETEACK_MASK 0x8
#define  CDMA_INTACK_CLEARCOMPLETEACK_SHIFT 3
#define  CDMA_INTACK_CLEARCOMPLETEACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_CLEARCOMPLETEACK_MASK) >> CDMA_INTACK_CLEARCOMPLETEACK_SHIFT)
#define  CDMA_INTACK_CLEARCOMPLETEACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_CLEARCOMPLETEACK_MASK) | (((uint32_t)val) << CDMA_INTACK_CLEARCOMPLETEACK_SHIFT))

#define  CDMA_INTACK_CHAINDONEACK_MASK 0x4
#define  CDMA_INTACK_CHAINDONEACK_SHIFT 2
#define  CDMA_INTACK_CHAINDONEACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_CHAINDONEACK_MASK) >> CDMA_INTACK_CHAINDONEACK_SHIFT)
#define  CDMA_INTACK_CHAINDONEACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_CHAINDONEACK_MASK) | (((uint32_t)val) << CDMA_INTACK_CHAINDONEACK_SHIFT))

#define  CDMA_INTACK_TIMEOUTACK_MASK 0x2
#define  CDMA_INTACK_TIMEOUTACK_SHIFT 1
#define  CDMA_INTACK_TIMEOUTACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_TIMEOUTACK_MASK) >> CDMA_INTACK_TIMEOUTACK_SHIFT)
#define  CDMA_INTACK_TIMEOUTACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_TIMEOUTACK_MASK) | (((uint32_t)val) << CDMA_INTACK_TIMEOUTACK_SHIFT))

#define  CDMA_INTACK_TERMCNTACK_MASK 0x1
#define  CDMA_INTACK_TERMCNTACK_SHIFT 0
#define  CDMA_INTACK_TERMCNTACK_MASK_SHIFT(reg) (((reg) & CDMA_INTACK_TERMCNTACK_MASK) >> CDMA_INTACK_TERMCNTACK_SHIFT)
#define  CDMA_INTACK_TERMCNTACK_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTACK_TERMCNTACK_MASK) | (((uint32_t)val) << CDMA_INTACK_TERMCNTACK_SHIFT))

//====================================================================
//Register: CDMA Interrupt Force Register (intForce)
//====================================================================

#define  CDMA_INTFORCE_RESERVED1_MASK 0xfffffe00
#define  CDMA_INTFORCE_RESERVED1_SHIFT 9
#define  CDMA_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_RESERVED1_MASK) >> CDMA_INTFORCE_RESERVED1_SHIFT)
#define  CDMA_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << CDMA_INTFORCE_RESERVED1_SHIFT))

#define  CDMA_INTFORCE_SRDONEFOR_MASK 0x100
#define  CDMA_INTFORCE_SRDONEFOR_SHIFT 8
#define  CDMA_INTFORCE_SRDONEFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_SRDONEFOR_MASK) >> CDMA_INTFORCE_SRDONEFOR_SHIFT)
#define  CDMA_INTFORCE_SRDONEFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_SRDONEFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_SRDONEFOR_SHIFT))

#define  CDMA_INTFORCE_HALTDONEFOR_MASK 0x80
#define  CDMA_INTFORCE_HALTDONEFOR_SHIFT 7
#define  CDMA_INTFORCE_HALTDONEFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_HALTDONEFOR_MASK) >> CDMA_INTFORCE_HALTDONEFOR_SHIFT)
#define  CDMA_INTFORCE_HALTDONEFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_HALTDONEFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_HALTDONEFOR_SHIFT))

#define  CDMA_INTFORCE_RRESPFOR_MASK 0x40
#define  CDMA_INTFORCE_RRESPFOR_SHIFT 6
#define  CDMA_INTFORCE_RRESPFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_RRESPFOR_MASK) >> CDMA_INTFORCE_RRESPFOR_SHIFT)
#define  CDMA_INTFORCE_RRESPFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_RRESPFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_RRESPFOR_SHIFT))

#define  CDMA_INTFORCE_BRESPFOR_MASK 0x20
#define  CDMA_INTFORCE_BRESPFOR_SHIFT 5
#define  CDMA_INTFORCE_BRESPFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_BRESPFOR_MASK) >> CDMA_INTFORCE_BRESPFOR_SHIFT)
#define  CDMA_INTFORCE_BRESPFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_BRESPFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_BRESPFOR_SHIFT))

#define  CDMA_INTFORCE_OWNFOR_MASK 0x10
#define  CDMA_INTFORCE_OWNFOR_SHIFT 4
#define  CDMA_INTFORCE_OWNFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_OWNFOR_MASK) >> CDMA_INTFORCE_OWNFOR_SHIFT)
#define  CDMA_INTFORCE_OWNFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_OWNFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_OWNFOR_SHIFT))

#define  CDMA_INTFORCE_CLEARCOMPLETEFOR_MASK 0x8
#define  CDMA_INTFORCE_CLEARCOMPLETEFOR_SHIFT 3
#define  CDMA_INTFORCE_CLEARCOMPLETEFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_CLEARCOMPLETEFOR_MASK) >> CDMA_INTFORCE_CLEARCOMPLETEFOR_SHIFT)
#define  CDMA_INTFORCE_CLEARCOMPLETEFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_CLEARCOMPLETEFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_CLEARCOMPLETEFOR_SHIFT))

#define  CDMA_INTFORCE_CHAINDONEFOR_MASK 0x4
#define  CDMA_INTFORCE_CHAINDONEFOR_SHIFT 2
#define  CDMA_INTFORCE_CHAINDONEFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_CHAINDONEFOR_MASK) >> CDMA_INTFORCE_CHAINDONEFOR_SHIFT)
#define  CDMA_INTFORCE_CHAINDONEFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_CHAINDONEFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_CHAINDONEFOR_SHIFT))

#define  CDMA_INTFORCE_TIMEOUTFOR_MASK 0x2
#define  CDMA_INTFORCE_TIMEOUTFOR_SHIFT 1
#define  CDMA_INTFORCE_TIMEOUTFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_TIMEOUTFOR_MASK) >> CDMA_INTFORCE_TIMEOUTFOR_SHIFT)
#define  CDMA_INTFORCE_TIMEOUTFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_TIMEOUTFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_TIMEOUTFOR_SHIFT))

#define  CDMA_INTFORCE_TERMCNTFOR_MASK 0x1
#define  CDMA_INTFORCE_TERMCNTFOR_SHIFT 0
#define  CDMA_INTFORCE_TERMCNTFOR_MASK_SHIFT(reg) (((reg) & CDMA_INTFORCE_TERMCNTFOR_MASK) >> CDMA_INTFORCE_TERMCNTFOR_SHIFT)
#define  CDMA_INTFORCE_TERMCNTFOR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_INTFORCE_TERMCNTFOR_MASK) | (((uint32_t)val) << CDMA_INTFORCE_TERMCNTFOR_SHIFT))

//====================================================================
//Register: CDMA Timer Control Register (TimerControl)
/** \brief The Timer Control register specifies the number of timebase cycles between word
      transfers before generating a timeout interrupt. The timer is reset each time
      a transfer occurs.*/
//====================================================================

#define  CDMA_TIMERCONTROL_RESERVED1_MASK 0xffff0000
#define  CDMA_TIMERCONTROL_RESERVED1_SHIFT 16
#define  CDMA_TIMERCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TIMERCONTROL_RESERVED1_MASK) >> CDMA_TIMERCONTROL_RESERVED1_SHIFT)
#define  CDMA_TIMERCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMERCONTROL_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TIMERCONTROL_RESERVED1_SHIFT))

#define  CDMA_TIMERCONTROL_TIMERENABLE_MASK 0x8000
#define  CDMA_TIMERCONTROL_TIMERENABLE_SHIFT 15
#define  CDMA_TIMERCONTROL_TIMERENABLE_MASK_SHIFT(reg) (((reg) & CDMA_TIMERCONTROL_TIMERENABLE_MASK) >> CDMA_TIMERCONTROL_TIMERENABLE_SHIFT)
#define  CDMA_TIMERCONTROL_TIMERENABLE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMERCONTROL_TIMERENABLE_MASK) | (((uint32_t)val) << CDMA_TIMERCONTROL_TIMERENABLE_SHIFT))

#define  CDMA_TIMERCONTROL_TIMEBASE_MASK 0x7000
#define  CDMA_TIMERCONTROL_TIMEBASE_SHIFT 12
#define  CDMA_TIMERCONTROL_TIMEBASE_MASK_SHIFT(reg) (((reg) & CDMA_TIMERCONTROL_TIMEBASE_MASK) >> CDMA_TIMERCONTROL_TIMEBASE_SHIFT)
#define  CDMA_TIMERCONTROL_TIMEBASE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMERCONTROL_TIMEBASE_MASK) | (((uint32_t)val) << CDMA_TIMERCONTROL_TIMEBASE_SHIFT))

#define  CDMA_TIMERCONTROL_RESERVED2_MASK 0x800
#define  CDMA_TIMERCONTROL_RESERVED2_SHIFT 11
#define  CDMA_TIMERCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & CDMA_TIMERCONTROL_RESERVED2_MASK) >> CDMA_TIMERCONTROL_RESERVED2_SHIFT)
#define  CDMA_TIMERCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMERCONTROL_RESERVED2_MASK) | (((uint32_t)val) << CDMA_TIMERCONTROL_RESERVED2_SHIFT))

#define  CDMA_TIMERCONTROL_COUNT_MASK 0x7ff
#define  CDMA_TIMERCONTROL_COUNT_SHIFT 0
#define  CDMA_TIMERCONTROL_COUNT_MASK_SHIFT(reg) (((reg) & CDMA_TIMERCONTROL_COUNT_MASK) >> CDMA_TIMERCONTROL_COUNT_SHIFT)
#define  CDMA_TIMERCONTROL_COUNT_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMERCONTROL_COUNT_MASK) | (((uint32_t)val) << CDMA_TIMERCONTROL_COUNT_SHIFT))

//====================================================================
//Register: CDMA Timeout Count Status Register (TimeOutStat)
/** \brief This register contains the current timeout count.*/
//====================================================================

#define  CDMA_TIMEOUTSTAT_RESERVED1_MASK 0xfffff800
#define  CDMA_TIMEOUTSTAT_RESERVED1_SHIFT 11
#define  CDMA_TIMEOUTSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TIMEOUTSTAT_RESERVED1_MASK) >> CDMA_TIMEOUTSTAT_RESERVED1_SHIFT)
#define  CDMA_TIMEOUTSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMEOUTSTAT_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TIMEOUTSTAT_RESERVED1_SHIFT))

#define  CDMA_TIMEOUTSTAT_CURRTOCNT_MASK 0x7ff
#define  CDMA_TIMEOUTSTAT_CURRTOCNT_SHIFT 0
#define  CDMA_TIMEOUTSTAT_CURRTOCNT_MASK_SHIFT(reg) (((reg) & CDMA_TIMEOUTSTAT_CURRTOCNT_MASK) >> CDMA_TIMEOUTSTAT_CURRTOCNT_SHIFT)
#define  CDMA_TIMEOUTSTAT_CURRTOCNT_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TIMEOUTSTAT_CURRTOCNT_MASK) | (((uint32_t)val) << CDMA_TIMEOUTSTAT_CURRTOCNT_SHIFT))

//====================================================================
//Register: CDMA Read Burst Address Register (CRBAR)
//====================================================================

#define  CDMA_CRBAR_RDBURSTADDR_MASK 0xffffffff
#define  CDMA_CRBAR_RDBURSTADDR_SHIFT 0
#define  CDMA_CRBAR_RDBURSTADDR_MASK_SHIFT(reg) (((reg) & CDMA_CRBAR_RDBURSTADDR_MASK) >> CDMA_CRBAR_RDBURSTADDR_SHIFT)
#define  CDMA_CRBAR_RDBURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRBAR_RDBURSTADDR_MASK) | (((uint32_t)val) << CDMA_CRBAR_RDBURSTADDR_SHIFT))

//====================================================================
//Register: CDMA Read Burst Length Register (CRBLR)
//====================================================================

#define  CDMA_CRBLR_RESERVED1_MASK 0xfffffe00
#define  CDMA_CRBLR_RESERVED1_SHIFT 9
#define  CDMA_CRBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CRBLR_RESERVED1_MASK) >> CDMA_CRBLR_RESERVED1_SHIFT)
#define  CDMA_CRBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRBLR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CRBLR_RESERVED1_SHIFT))

#define  CDMA_CRBLR_RDBURSTLAST_MASK 0x100
#define  CDMA_CRBLR_RDBURSTLAST_SHIFT 8
#define  CDMA_CRBLR_RDBURSTLAST_MASK_SHIFT(reg) (((reg) & CDMA_CRBLR_RDBURSTLAST_MASK) >> CDMA_CRBLR_RDBURSTLAST_SHIFT)
#define  CDMA_CRBLR_RDBURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRBLR_RDBURSTLAST_MASK) | (((uint32_t)val) << CDMA_CRBLR_RDBURSTLAST_SHIFT))

#define  CDMA_CRBLR_RDBURSTLENGTH_MASK 0xff
#define  CDMA_CRBLR_RDBURSTLENGTH_SHIFT 0
#define  CDMA_CRBLR_RDBURSTLENGTH_MASK_SHIFT(reg) (((reg) & CDMA_CRBLR_RDBURSTLENGTH_MASK) >> CDMA_CRBLR_RDBURSTLENGTH_SHIFT)
#define  CDMA_CRBLR_RDBURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRBLR_RDBURSTLENGTH_MASK) | (((uint32_t)val) << CDMA_CRBLR_RDBURSTLENGTH_SHIFT))

//====================================================================
//Register: CDMA Write Burst Address Register (CWBAR)
//====================================================================

#define  CDMA_CWBAR_WRBURSTADDR_MASK 0xffffffff
#define  CDMA_CWBAR_WRBURSTADDR_SHIFT 0
#define  CDMA_CWBAR_WRBURSTADDR_MASK_SHIFT(reg) (((reg) & CDMA_CWBAR_WRBURSTADDR_MASK) >> CDMA_CWBAR_WRBURSTADDR_SHIFT)
#define  CDMA_CWBAR_WRBURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CWBAR_WRBURSTADDR_MASK) | (((uint32_t)val) << CDMA_CWBAR_WRBURSTADDR_SHIFT))

//====================================================================
//Register: CDMA Write Burst Length Register (CWBLR)
//====================================================================

#define  CDMA_CWBLR_RESERVED1_MASK 0xfffffe00
#define  CDMA_CWBLR_RESERVED1_SHIFT 9
#define  CDMA_CWBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CWBLR_RESERVED1_MASK) >> CDMA_CWBLR_RESERVED1_SHIFT)
#define  CDMA_CWBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CWBLR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CWBLR_RESERVED1_SHIFT))

#define  CDMA_CWBLR_WRBURSTLAST_MASK 0x100
#define  CDMA_CWBLR_WRBURSTLAST_SHIFT 8
#define  CDMA_CWBLR_WRBURSTLAST_MASK_SHIFT(reg) (((reg) & CDMA_CWBLR_WRBURSTLAST_MASK) >> CDMA_CWBLR_WRBURSTLAST_SHIFT)
#define  CDMA_CWBLR_WRBURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CWBLR_WRBURSTLAST_MASK) | (((uint32_t)val) << CDMA_CWBLR_WRBURSTLAST_SHIFT))

#define  CDMA_CWBLR_WRBURSTLENGTH_MASK 0xff
#define  CDMA_CWBLR_WRBURSTLENGTH_SHIFT 0
#define  CDMA_CWBLR_WRBURSTLENGTH_MASK_SHIFT(reg) (((reg) & CDMA_CWBLR_WRBURSTLENGTH_MASK) >> CDMA_CWBLR_WRBURSTLENGTH_SHIFT)
#define  CDMA_CWBLR_WRBURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CWBLR_WRBURSTLENGTH_MASK) | (((uint32_t)val) << CDMA_CWBLR_WRBURSTLENGTH_SHIFT))

//====================================================================
//Register: CDMA Write Bytes Remain Register (CWBRR)
//====================================================================

#define  CDMA_CWBRR_BYTESREMAIN_MASK 0xffffffff
#define  CDMA_CWBRR_BYTESREMAIN_SHIFT 0
#define  CDMA_CWBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & CDMA_CWBRR_BYTESREMAIN_MASK) >> CDMA_CWBRR_BYTESREMAIN_SHIFT)
#define  CDMA_CWBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CWBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << CDMA_CWBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: DMA Save/Restore Control Register (CSRR)
//====================================================================

#define  CDMA_CSRR_RESERVED1_MASK 0xffff0000
#define  CDMA_CSRR_RESERVED1_SHIFT 16
#define  CDMA_CSRR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_RESERVED1_MASK) >> CDMA_CSRR_RESERVED1_SHIFT)
#define  CDMA_CSRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CSRR_RESERVED1_SHIFT))

#define  CDMA_CSRR_RSTRDESTXFERWIDTH_MASK 0xc000
#define  CDMA_CSRR_RSTRDESTXFERWIDTH_SHIFT 14
#define  CDMA_CSRR_RSTRDESTXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_RSTRDESTXFERWIDTH_MASK) >> CDMA_CSRR_RSTRDESTXFERWIDTH_SHIFT)
#define  CDMA_CSRR_RSTRDESTXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_RSTRDESTXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CSRR_RSTRDESTXFERWIDTH_SHIFT))

#define  CDMA_CSRR_SAVEDESTXFERWIDTH_MASK 0x3000
#define  CDMA_CSRR_SAVEDESTXFERWIDTH_SHIFT 12
#define  CDMA_CSRR_SAVEDESTXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_SAVEDESTXFERWIDTH_MASK) >> CDMA_CSRR_SAVEDESTXFERWIDTH_SHIFT)
#define  CDMA_CSRR_SAVEDESTXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_SAVEDESTXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CSRR_SAVEDESTXFERWIDTH_SHIFT))

#define  CDMA_CSRR_RSTRSRCXFERWIDTH_MASK 0xc00
#define  CDMA_CSRR_RSTRSRCXFERWIDTH_SHIFT 10
#define  CDMA_CSRR_RSTRSRCXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_RSTRSRCXFERWIDTH_MASK) >> CDMA_CSRR_RSTRSRCXFERWIDTH_SHIFT)
#define  CDMA_CSRR_RSTRSRCXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_RSTRSRCXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CSRR_RSTRSRCXFERWIDTH_SHIFT))

#define  CDMA_CSRR_SAVESRCXFERWIDTH_MASK 0x300
#define  CDMA_CSRR_SAVESRCXFERWIDTH_SHIFT 8
#define  CDMA_CSRR_SAVESRCXFERWIDTH_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_SAVESRCXFERWIDTH_MASK) >> CDMA_CSRR_SAVESRCXFERWIDTH_SHIFT)
#define  CDMA_CSRR_SAVESRCXFERWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_SAVESRCXFERWIDTH_MASK) | (((uint32_t)val) << CDMA_CSRR_SAVESRCXFERWIDTH_SHIFT))

#define  CDMA_CSRR_RSTRDESTBURSTSIZE_MASK 0xc0
#define  CDMA_CSRR_RSTRDESTBURSTSIZE_SHIFT 6
#define  CDMA_CSRR_RSTRDESTBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_RSTRDESTBURSTSIZE_MASK) >> CDMA_CSRR_RSTRDESTBURSTSIZE_SHIFT)
#define  CDMA_CSRR_RSTRDESTBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_RSTRDESTBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CSRR_RSTRDESTBURSTSIZE_SHIFT))

#define  CDMA_CSRR_SAVEDESTBURSTSIZE_MASK 0x30
#define  CDMA_CSRR_SAVEDESTBURSTSIZE_SHIFT 4
#define  CDMA_CSRR_SAVEDESTBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_SAVEDESTBURSTSIZE_MASK) >> CDMA_CSRR_SAVEDESTBURSTSIZE_SHIFT)
#define  CDMA_CSRR_SAVEDESTBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_SAVEDESTBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CSRR_SAVEDESTBURSTSIZE_SHIFT))

#define  CDMA_CSRR_RSTRSRCBURSTSIZE_MASK 0xc
#define  CDMA_CSRR_RSTRSRCBURSTSIZE_SHIFT 2
#define  CDMA_CSRR_RSTRSRCBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_RSTRSRCBURSTSIZE_MASK) >> CDMA_CSRR_RSTRSRCBURSTSIZE_SHIFT)
#define  CDMA_CSRR_RSTRSRCBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_RSTRSRCBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CSRR_RSTRSRCBURSTSIZE_SHIFT))

#define  CDMA_CSRR_SAVESRCBURSTSIZE_MASK 0x3
#define  CDMA_CSRR_SAVESRCBURSTSIZE_SHIFT 0
#define  CDMA_CSRR_SAVESRCBURSTSIZE_MASK_SHIFT(reg) (((reg) & CDMA_CSRR_SAVESRCBURSTSIZE_MASK) >> CDMA_CSRR_SAVESRCBURSTSIZE_SHIFT)
#define  CDMA_CSRR_SAVESRCBURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRR_SAVESRCBURSTSIZE_MASK) | (((uint32_t)val) << CDMA_CSRR_SAVESRCBURSTSIZE_SHIFT))

//====================================================================
//Register: Save/Restore Lower DMA ID Register (CSRLI)
//====================================================================

#define  CDMA_CSRLI_SR_ID_LOWER_MASK 0xffffffff
#define  CDMA_CSRLI_SR_ID_LOWER_SHIFT 0
#define  CDMA_CSRLI_SR_ID_LOWER_MASK_SHIFT(reg) (((reg) & CDMA_CSRLI_SR_ID_LOWER_MASK) >> CDMA_CSRLI_SR_ID_LOWER_SHIFT)
#define  CDMA_CSRLI_SR_ID_LOWER_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRLI_SR_ID_LOWER_MASK) | (((uint32_t)val) << CDMA_CSRLI_SR_ID_LOWER_SHIFT))

//====================================================================
//Register: Save/Restore Upper DMA ID Register (CSRUI)
//====================================================================

#define  CDMA_CSRUI_SR_ID_UPPER_MASK 0xffffffff
#define  CDMA_CSRUI_SR_ID_UPPER_SHIFT 0
#define  CDMA_CSRUI_SR_ID_UPPER_MASK_SHIFT(reg) (((reg) & CDMA_CSRUI_SR_ID_UPPER_MASK) >> CDMA_CSRUI_SR_ID_UPPER_SHIFT)
#define  CDMA_CSRUI_SR_ID_UPPER_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CSRUI_SR_ID_UPPER_MASK) | (((uint32_t)val) << CDMA_CSRUI_SR_ID_UPPER_SHIFT))

//====================================================================
//Register: DMA Lower Request Status Register (CRSL)
//====================================================================

#define  CDMA_CRSL_DMA_REQ_STAT_LOWER_MASK 0xffffffff
#define  CDMA_CRSL_DMA_REQ_STAT_LOWER_SHIFT 0
#define  CDMA_CRSL_DMA_REQ_STAT_LOWER_MASK_SHIFT(reg) (((reg) & CDMA_CRSL_DMA_REQ_STAT_LOWER_MASK) >> CDMA_CRSL_DMA_REQ_STAT_LOWER_SHIFT)
#define  CDMA_CRSL_DMA_REQ_STAT_LOWER_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRSL_DMA_REQ_STAT_LOWER_MASK) | (((uint32_t)val) << CDMA_CRSL_DMA_REQ_STAT_LOWER_SHIFT))

//====================================================================
//Register: DMA Upper Request Stautus Register (CRSU)
//====================================================================

#define  CDMA_CRSU_DMA_REQ_STAT_UPPER_MASK 0xffffffff
#define  CDMA_CRSU_DMA_REQ_STAT_UPPER_SHIFT 0
#define  CDMA_CRSU_DMA_REQ_STAT_UPPER_MASK_SHIFT(reg) (((reg) & CDMA_CRSU_DMA_REQ_STAT_UPPER_MASK) >> CDMA_CRSU_DMA_REQ_STAT_UPPER_SHIFT)
#define  CDMA_CRSU_DMA_REQ_STAT_UPPER_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CRSU_DMA_REQ_STAT_UPPER_MASK) | (((uint32_t)val) << CDMA_CRSU_DMA_REQ_STAT_UPPER_SHIFT))

//====================================================================
//Register: DMA Ack Force Register (CAFR)
//====================================================================

#define  CDMA_CAFR_RESERVED1_MASK 0xffffffc0
#define  CDMA_CAFR_RESERVED1_SHIFT 6
#define  CDMA_CAFR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_CAFR_RESERVED1_MASK) >> CDMA_CAFR_RESERVED1_SHIFT)
#define  CDMA_CAFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CAFR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_CAFR_RESERVED1_SHIFT))

#define  CDMA_CAFR_ACK_FORCE_MASK 0x3f
#define  CDMA_CAFR_ACK_FORCE_SHIFT 0
#define  CDMA_CAFR_ACK_FORCE_MASK_SHIFT(reg) (((reg) & CDMA_CAFR_ACK_FORCE_MASK) >> CDMA_CAFR_ACK_FORCE_SHIFT)
#define  CDMA_CAFR_ACK_FORCE_REPLACE_VAL(reg,val) (((reg) & ~CDMA_CAFR_ACK_FORCE_MASK) | (((uint32_t)val) << CDMA_CAFR_ACK_FORCE_SHIFT))

#endif // CDMA
