 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file CDMA_Top_Reg_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _CDMA_TOP_REG_REGMASKS_H_
#define _CDMA_TOP_REG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: CDMA Top Registers (CDMA_Top_Reg)
/** \brief CDMA Top Level Register Set <br/> (rev 0 . 1 . 1 . 7)*/
//
//====================================================================

//====================================================================
//Register: CDMA Interrupt Status Register (CDMAInt)
/** \brief Contains the status of current CDMA Channel interrupts*/
//====================================================================

#define  CDMA_TOP_REG_CDMAINT_RESERVED1_MASK 0xffffff00
#define  CDMA_TOP_REG_CDMAINT_RESERVED1_SHIFT 8
#define  CDMA_TOP_REG_CDMAINT_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CDMAINT_RESERVED1_MASK) >> CDMA_TOP_REG_CDMAINT_RESERVED1_SHIFT)
#define  CDMA_TOP_REG_CDMAINT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CDMAINT_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CDMAINT_RESERVED1_SHIFT))

#define  CDMA_TOP_REG_CDMAINT_CDMAINT_MASK 0xff
#define  CDMA_TOP_REG_CDMAINT_CDMAINT_SHIFT 0
#define  CDMA_TOP_REG_CDMAINT_CDMAINT_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CDMAINT_CDMAINT_MASK) >> CDMA_TOP_REG_CDMAINT_CDMAINT_SHIFT)
#define  CDMA_TOP_REG_CDMAINT_CDMAINT_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CDMAINT_CDMAINT_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CDMAINT_CDMAINT_SHIFT))

//====================================================================
//Register: CDMA Top SoftReset Register (CTSR)
//====================================================================

#define  CDMA_TOP_REG_CTSR_RESERVED1_MASK 0xfffffffe
#define  CDMA_TOP_REG_CTSR_RESERVED1_SHIFT 1
#define  CDMA_TOP_REG_CTSR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTSR_RESERVED1_MASK) >> CDMA_TOP_REG_CTSR_RESERVED1_SHIFT)
#define  CDMA_TOP_REG_CTSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTSR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTSR_RESERVED1_SHIFT))

#define  CDMA_TOP_REG_CTSR_SOFTRESET_MASK 0x1
#define  CDMA_TOP_REG_CTSR_SOFTRESET_SHIFT 0
#define  CDMA_TOP_REG_CTSR_SOFTRESET_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTSR_SOFTRESET_MASK) >> CDMA_TOP_REG_CTSR_SOFTRESET_SHIFT)
#define  CDMA_TOP_REG_CTSR_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTSR_SOFTRESET_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTSR_SOFTRESET_SHIFT))

//====================================================================
//Register: CDMA Parameter Register (CDMAPR)
/** \brief Contains the parameter settings for this instantiation of CDMA*/
//====================================================================

#define  CDMA_TOP_REG_CDMAPR_RESERVED1_MASK 0xfffffff0
#define  CDMA_TOP_REG_CDMAPR_RESERVED1_SHIFT 4
#define  CDMA_TOP_REG_CDMAPR_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CDMAPR_RESERVED1_MASK) >> CDMA_TOP_REG_CDMAPR_RESERVED1_SHIFT)
#define  CDMA_TOP_REG_CDMAPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CDMAPR_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CDMAPR_RESERVED1_SHIFT))

#define  CDMA_TOP_REG_CDMAPR_NUMCHAN_MASK 0xf
#define  CDMA_TOP_REG_CDMAPR_NUMCHAN_SHIFT 0
#define  CDMA_TOP_REG_CDMAPR_NUMCHAN_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CDMAPR_NUMCHAN_MASK) >> CDMA_TOP_REG_CDMAPR_NUMCHAN_SHIFT)
#define  CDMA_TOP_REG_CDMAPR_NUMCHAN_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CDMAPR_NUMCHAN_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CDMAPR_NUMCHAN_SHIFT))

//====================================================================
//Register: CDMA Tag Register 0 (CTR0)
//====================================================================

#define  CDMA_TOP_REG_CTR0_TAGMAJ_MASK 0xffff0000
#define  CDMA_TOP_REG_CTR0_TAGMAJ_SHIFT 16
#define  CDMA_TOP_REG_CTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTR0_TAGMAJ_MASK) >> CDMA_TOP_REG_CTR0_TAGMAJ_SHIFT)
#define  CDMA_TOP_REG_CTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTR0_TAGMAJ_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTR0_TAGMAJ_SHIFT))

#define  CDMA_TOP_REG_CTR0_TAGMID_MASK 0xffff
#define  CDMA_TOP_REG_CTR0_TAGMID_SHIFT 0
#define  CDMA_TOP_REG_CTR0_TAGMID_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTR0_TAGMID_MASK) >> CDMA_TOP_REG_CTR0_TAGMID_SHIFT)
#define  CDMA_TOP_REG_CTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTR0_TAGMID_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTR0_TAGMID_SHIFT))

//====================================================================
//Register: CDMA Tag Register 1 (CTR1)
//====================================================================

#define  CDMA_TOP_REG_CTR1_RESERVED1_MASK 0xffff0000
#define  CDMA_TOP_REG_CTR1_RESERVED1_SHIFT 16
#define  CDMA_TOP_REG_CTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTR1_RESERVED1_MASK) >> CDMA_TOP_REG_CTR1_RESERVED1_SHIFT)
#define  CDMA_TOP_REG_CTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTR1_RESERVED1_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTR1_RESERVED1_SHIFT))

#define  CDMA_TOP_REG_CTR1_TAGCFG_MASK 0xffff
#define  CDMA_TOP_REG_CTR1_TAGCFG_SHIFT 0
#define  CDMA_TOP_REG_CTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & CDMA_TOP_REG_CTR1_TAGCFG_MASK) >> CDMA_TOP_REG_CTR1_TAGCFG_SHIFT)
#define  CDMA_TOP_REG_CTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~CDMA_TOP_REG_CTR1_TAGCFG_MASK) | (((uint32_t)val) << CDMA_TOP_REG_CTR1_TAGCFG_SHIFT))

#endif // CDMA_TOP_REG
