 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file BulbMon_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _BULBMON_REGMASKS_H_
#define _BULBMON_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Bulb Monitor (BulbMon)
/** \brief Register Descriptions for the PIC BulbMon block (rev 0 . 0 . 3 . 6)*/
//
//====================================================================

//====================================================================
//Register: Bulb Monitor Configuration Register (BMCR)
/** \brief General configuration register for BulbMon block.*/
//====================================================================

#define  BULBMON_BMCR_BYPASS_MASK 0x80000000
#define  BULBMON_BMCR_BYPASS_SHIFT 31
#define  BULBMON_BMCR_BYPASS_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_BYPASS_MASK) >> BULBMON_BMCR_BYPASS_SHIFT)
#define  BULBMON_BMCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_BYPASS_MASK) | (((uint32_t)val) << BULBMON_BMCR_BYPASS_SHIFT))

#define  BULBMON_BMCR_RESERVED1_MASK 0x78000000
#define  BULBMON_BMCR_RESERVED1_SHIFT 27
#define  BULBMON_BMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_RESERVED1_MASK) >> BULBMON_BMCR_RESERVED1_SHIFT)
#define  BULBMON_BMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMCR_RESERVED1_SHIFT))

#define  BULBMON_BMCR_LINESTOAVE_MASK 0x7000000
#define  BULBMON_BMCR_LINESTOAVE_SHIFT 24
#define  BULBMON_BMCR_LINESTOAVE_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_LINESTOAVE_MASK) >> BULBMON_BMCR_LINESTOAVE_SHIFT)
#define  BULBMON_BMCR_LINESTOAVE_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_LINESTOAVE_MASK) | (((uint32_t)val) << BULBMON_BMCR_LINESTOAVE_SHIFT))

#define  BULBMON_BMCR_WINLEN_MASK 0xff0000
#define  BULBMON_BMCR_WINLEN_SHIFT 16
#define  BULBMON_BMCR_WINLEN_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_WINLEN_MASK) >> BULBMON_BMCR_WINLEN_SHIFT)
#define  BULBMON_BMCR_WINLEN_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_WINLEN_MASK) | (((uint32_t)val) << BULBMON_BMCR_WINLEN_SHIFT))

#define  BULBMON_BMCR_STARTPIX_MASK 0xffff
#define  BULBMON_BMCR_STARTPIX_SHIFT 0
#define  BULBMON_BMCR_STARTPIX_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_STARTPIX_MASK) >> BULBMON_BMCR_STARTPIX_SHIFT)
#define  BULBMON_BMCR_STARTPIX_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_STARTPIX_MASK) | (((uint32_t)val) << BULBMON_BMCR_STARTPIX_SHIFT))

//====================================================================
//Register: Bulb Monitor Color0 Register (BMR0)
/** \brief BMR0 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR0_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR0_RESERVED1_SHIFT 24
#define  BULBMON_BMR0_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR0_RESERVED1_MASK) >> BULBMON_BMR0_RESERVED1_SHIFT)
#define  BULBMON_BMR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR0_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR0_RESERVED1_SHIFT))

#define  BULBMON_BMR0_AVERAGEC0_MASK 0xffffff
#define  BULBMON_BMR0_AVERAGEC0_SHIFT 0
#define  BULBMON_BMR0_AVERAGEC0_MASK_SHIFT(reg) (((reg) & BULBMON_BMR0_AVERAGEC0_MASK) >> BULBMON_BMR0_AVERAGEC0_SHIFT)
#define  BULBMON_BMR0_AVERAGEC0_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR0_AVERAGEC0_MASK) | (((uint32_t)val) << BULBMON_BMR0_AVERAGEC0_SHIFT))

//====================================================================
//Register: Bulb Monitor Color1 Register (BMR1)
/** \brief BMR1 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR1_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR1_RESERVED1_SHIFT 24
#define  BULBMON_BMR1_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR1_RESERVED1_MASK) >> BULBMON_BMR1_RESERVED1_SHIFT)
#define  BULBMON_BMR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR1_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR1_RESERVED1_SHIFT))

#define  BULBMON_BMR1_AVERAGEC1_MASK 0xffffff
#define  BULBMON_BMR1_AVERAGEC1_SHIFT 0
#define  BULBMON_BMR1_AVERAGEC1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR1_AVERAGEC1_MASK) >> BULBMON_BMR1_AVERAGEC1_SHIFT)
#define  BULBMON_BMR1_AVERAGEC1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR1_AVERAGEC1_MASK) | (((uint32_t)val) << BULBMON_BMR1_AVERAGEC1_SHIFT))

//====================================================================
//Register: Bulb Monitor Color2 Register (BMR2)
/** \brief BMR2 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR2_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR2_RESERVED1_SHIFT 24
#define  BULBMON_BMR2_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR2_RESERVED1_MASK) >> BULBMON_BMR2_RESERVED1_SHIFT)
#define  BULBMON_BMR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR2_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR2_RESERVED1_SHIFT))

#define  BULBMON_BMR2_AVERAGEC2_MASK 0xffffff
#define  BULBMON_BMR2_AVERAGEC2_SHIFT 0
#define  BULBMON_BMR2_AVERAGEC2_MASK_SHIFT(reg) (((reg) & BULBMON_BMR2_AVERAGEC2_MASK) >> BULBMON_BMR2_AVERAGEC2_SHIFT)
#define  BULBMON_BMR2_AVERAGEC2_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR2_AVERAGEC2_MASK) | (((uint32_t)val) << BULBMON_BMR2_AVERAGEC2_SHIFT))

//====================================================================
//Register: Bulb Monitor Exposure Register (BMR3)
/** \brief BMR2 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR3_RESERVED1_MASK 0xfff00000
#define  BULBMON_BMR3_RESERVED1_SHIFT 20
#define  BULBMON_BMR3_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR3_RESERVED1_MASK) >> BULBMON_BMR3_RESERVED1_SHIFT)
#define  BULBMON_BMR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR3_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR3_RESERVED1_SHIFT))

#define  BULBMON_BMR3_ACCEXP_MASK 0xfffff
#define  BULBMON_BMR3_ACCEXP_SHIFT 0
#define  BULBMON_BMR3_ACCEXP_MASK_SHIFT(reg) (((reg) & BULBMON_BMR3_ACCEXP_MASK) >> BULBMON_BMR3_ACCEXP_SHIFT)
#define  BULBMON_BMR3_ACCEXP_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR3_ACCEXP_MASK) | (((uint32_t)val) << BULBMON_BMR3_ACCEXP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  BULBMON_REV0_MAJ_MASK 0xffff0000
#define  BULBMON_REV0_MAJ_SHIFT 16
#define  BULBMON_REV0_MAJ_MASK_SHIFT(reg) (((reg) & BULBMON_REV0_MAJ_MASK) >> BULBMON_REV0_MAJ_SHIFT)
#define  BULBMON_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV0_MAJ_MASK) | (((uint32_t)val) << BULBMON_REV0_MAJ_SHIFT))

#define  BULBMON_REV0_MID_MASK 0xffff
#define  BULBMON_REV0_MID_SHIFT 0
#define  BULBMON_REV0_MID_MASK_SHIFT(reg) (((reg) & BULBMON_REV0_MID_MASK) >> BULBMON_REV0_MID_SHIFT)
#define  BULBMON_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV0_MID_MASK) | (((uint32_t)val) << BULBMON_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  BULBMON_REV1_RESERVED1_MASK 0xffff0000
#define  BULBMON_REV1_RESERVED1_SHIFT 16
#define  BULBMON_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_REV1_RESERVED1_MASK) >> BULBMON_REV1_RESERVED1_SHIFT)
#define  BULBMON_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV1_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_REV1_RESERVED1_SHIFT))

#define  BULBMON_REV1_CFG_MASK 0xffff
#define  BULBMON_REV1_CFG_SHIFT 0
#define  BULBMON_REV1_CFG_MASK_SHIFT(reg) (((reg) & BULBMON_REV1_CFG_MASK) >> BULBMON_REV1_CFG_SHIFT)
#define  BULBMON_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV1_CFG_MASK) | (((uint32_t)val) << BULBMON_REV1_CFG_SHIFT))

#endif // BULBMON
