 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file BOOTSPI_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _BOOTSPI_REGMASKS_H_
#define _BOOTSPI_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: BootSPI module (BOOTSPI)
/** \brief (rev 0 . 5 . 4 . 2)
    Registers for the bootspi module.*/
//
//====================================================================

//====================================================================
//Register: Bootspi configuration register (BSCR)
/** \brief Various bitfields used to configure the bootspi module.*/
//====================================================================

#define  BOOTSPI_BSCR_RESERVED1_MASK 0xfff80000
#define  BOOTSPI_BSCR_RESERVED1_SHIFT 19
#define  BOOTSPI_BSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_RESERVED1_MASK) >> BOOTSPI_BSCR_RESERVED1_SHIFT)
#define  BOOTSPI_BSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_RESERVED1_SHIFT))

#define  BOOTSPI_BSCR_CACHEENABLE_MASK 0x40000
#define  BOOTSPI_BSCR_CACHEENABLE_SHIFT 18
#define  BOOTSPI_BSCR_CACHEENABLE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_CACHEENABLE_MASK) >> BOOTSPI_BSCR_CACHEENABLE_SHIFT)
#define  BOOTSPI_BSCR_CACHEENABLE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_CACHEENABLE_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_CACHEENABLE_SHIFT))

#define  BOOTSPI_BSCR_NCSMUXSEL_MASK 0x30000
#define  BOOTSPI_BSCR_NCSMUXSEL_SHIFT 16
#define  BOOTSPI_BSCR_NCSMUXSEL_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_NCSMUXSEL_MASK) >> BOOTSPI_BSCR_NCSMUXSEL_SHIFT)
#define  BOOTSPI_BSCR_NCSMUXSEL_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_NCSMUXSEL_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_NCSMUXSEL_SHIFT))

#define  BOOTSPI_BSCR_DUMMYCLOCKCOUNT_MASK 0xf000
#define  BOOTSPI_BSCR_DUMMYCLOCKCOUNT_SHIFT 12
#define  BOOTSPI_BSCR_DUMMYCLOCKCOUNT_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_DUMMYCLOCKCOUNT_MASK) >> BOOTSPI_BSCR_DUMMYCLOCKCOUNT_SHIFT)
#define  BOOTSPI_BSCR_DUMMYCLOCKCOUNT_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_DUMMYCLOCKCOUNT_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_DUMMYCLOCKCOUNT_SHIFT))

#define  BOOTSPI_BSCR_READMODEBYTECOUNT_MASK 0xc00
#define  BOOTSPI_BSCR_READMODEBYTECOUNT_SHIFT 10
#define  BOOTSPI_BSCR_READMODEBYTECOUNT_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_READMODEBYTECOUNT_MASK) >> BOOTSPI_BSCR_READMODEBYTECOUNT_SHIFT)
#define  BOOTSPI_BSCR_READMODEBYTECOUNT_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_READMODEBYTECOUNT_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_READMODEBYTECOUNT_SHIFT))

#define  BOOTSPI_BSCR_ADDRESSBYTECOUNT_MASK 0x300
#define  BOOTSPI_BSCR_ADDRESSBYTECOUNT_SHIFT 8
#define  BOOTSPI_BSCR_ADDRESSBYTECOUNT_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_ADDRESSBYTECOUNT_MASK) >> BOOTSPI_BSCR_ADDRESSBYTECOUNT_SHIFT)
#define  BOOTSPI_BSCR_ADDRESSBYTECOUNT_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_ADDRESSBYTECOUNT_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_ADDRESSBYTECOUNT_SHIFT))

#define  BOOTSPI_BSCR_RESERVED2_MASK 0x80
#define  BOOTSPI_BSCR_RESERVED2_SHIFT 7
#define  BOOTSPI_BSCR_RESERVED2_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_RESERVED2_MASK) >> BOOTSPI_BSCR_RESERVED2_SHIFT)
#define  BOOTSPI_BSCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_RESERVED2_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_RESERVED2_SHIFT))

#define  BOOTSPI_BSCR_OPCODEBYTECOUNT_MASK 0x60
#define  BOOTSPI_BSCR_OPCODEBYTECOUNT_SHIFT 5
#define  BOOTSPI_BSCR_OPCODEBYTECOUNT_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_OPCODEBYTECOUNT_MASK) >> BOOTSPI_BSCR_OPCODEBYTECOUNT_SHIFT)
#define  BOOTSPI_BSCR_OPCODEBYTECOUNT_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_OPCODEBYTECOUNT_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_OPCODEBYTECOUNT_SHIFT))

#define  BOOTSPI_BSCR_ADDRESSMODE_MASK 0x10
#define  BOOTSPI_BSCR_ADDRESSMODE_SHIFT 4
#define  BOOTSPI_BSCR_ADDRESSMODE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_ADDRESSMODE_MASK) >> BOOTSPI_BSCR_ADDRESSMODE_SHIFT)
#define  BOOTSPI_BSCR_ADDRESSMODE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_ADDRESSMODE_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_ADDRESSMODE_SHIFT))

#define  BOOTSPI_BSCR_DATAMODE_MASK 0xc
#define  BOOTSPI_BSCR_DATAMODE_SHIFT 2
#define  BOOTSPI_BSCR_DATAMODE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_DATAMODE_MASK) >> BOOTSPI_BSCR_DATAMODE_SHIFT)
#define  BOOTSPI_BSCR_DATAMODE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_DATAMODE_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_DATAMODE_SHIFT))

#define  BOOTSPI_BSCR_ERRONMISS_MASK 0x2
#define  BOOTSPI_BSCR_ERRONMISS_SHIFT 1
#define  BOOTSPI_BSCR_ERRONMISS_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_ERRONMISS_MASK) >> BOOTSPI_BSCR_ERRONMISS_SHIFT)
#define  BOOTSPI_BSCR_ERRONMISS_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_ERRONMISS_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_ERRONMISS_SHIFT))

#define  BOOTSPI_BSCR_INTERFACEMODE_MASK 0x1
#define  BOOTSPI_BSCR_INTERFACEMODE_SHIFT 0
#define  BOOTSPI_BSCR_INTERFACEMODE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCR_INTERFACEMODE_MASK) >> BOOTSPI_BSCR_INTERFACEMODE_SHIFT)
#define  BOOTSPI_BSCR_INTERFACEMODE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCR_INTERFACEMODE_MASK) | (((uint32_t)val) << BOOTSPI_BSCR_INTERFACEMODE_SHIFT))

//====================================================================
//Register: Bootspi Command Words Register (BSCOM)
/** \brief This register is used to program certain parts of the command sequence that will be
      sent out to the SPI part on a direct memory read.*/
//====================================================================

#define  BOOTSPI_BSCOM_READMODE_MASK 0xffff0000
#define  BOOTSPI_BSCOM_READMODE_SHIFT 16
#define  BOOTSPI_BSCOM_READMODE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCOM_READMODE_MASK) >> BOOTSPI_BSCOM_READMODE_SHIFT)
#define  BOOTSPI_BSCOM_READMODE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCOM_READMODE_MASK) | (((uint32_t)val) << BOOTSPI_BSCOM_READMODE_SHIFT))

#define  BOOTSPI_BSCOM_OPCODE_MASK 0xffff
#define  BOOTSPI_BSCOM_OPCODE_SHIFT 0
#define  BOOTSPI_BSCOM_OPCODE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCOM_OPCODE_MASK) >> BOOTSPI_BSCOM_OPCODE_SHIFT)
#define  BOOTSPI_BSCOM_OPCODE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCOM_OPCODE_MASK) | (((uint32_t)val) << BOOTSPI_BSCOM_OPCODE_SHIFT))

//====================================================================
//Register: Bootspi Command Mode Register (BSCMDR)
/** \brief This register is used only in "manual half duplex mode". It should be written only when the
      "CommandBusy" bit is clear in the status register. The CommandBusy bit returns low after the
      command has completed.*/
//====================================================================

#define  BOOTSPI_BSCMDR_RESERVED1_MASK 0xfffff800
#define  BOOTSPI_BSCMDR_RESERVED1_SHIFT 11
#define  BOOTSPI_BSCMDR_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCMDR_RESERVED1_MASK) >> BOOTSPI_BSCMDR_RESERVED1_SHIFT)
#define  BOOTSPI_BSCMDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCMDR_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSCMDR_RESERVED1_SHIFT))

#define  BOOTSPI_BSCMDR_COMMAND_MASK 0x700
#define  BOOTSPI_BSCMDR_COMMAND_SHIFT 8
#define  BOOTSPI_BSCMDR_COMMAND_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCMDR_COMMAND_MASK) >> BOOTSPI_BSCMDR_COMMAND_SHIFT)
#define  BOOTSPI_BSCMDR_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCMDR_COMMAND_MASK) | (((uint32_t)val) << BOOTSPI_BSCMDR_COMMAND_SHIFT))

#define  BOOTSPI_BSCMDR_DATA_MASK 0xff
#define  BOOTSPI_BSCMDR_DATA_SHIFT 0
#define  BOOTSPI_BSCMDR_DATA_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSCMDR_DATA_MASK) >> BOOTSPI_BSCMDR_DATA_SHIFT)
#define  BOOTSPI_BSCMDR_DATA_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSCMDR_DATA_MASK) | (((uint32_t)val) << BOOTSPI_BSCMDR_DATA_SHIFT))

//====================================================================
//Register: Bootspi Status Register (BSSR)
/** \brief Bootable SPI status register*/
//====================================================================

#define  BOOTSPI_BSSR_RESERVED1_MASK 0xfffc0000
#define  BOOTSPI_BSSR_RESERVED1_SHIFT 18
#define  BOOTSPI_BSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_RESERVED1_MASK) >> BOOTSPI_BSSR_RESERVED1_SHIFT)
#define  BOOTSPI_BSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_RESERVED1_SHIFT))

#define  BOOTSPI_BSSR_CSS_MASK 0x20000
#define  BOOTSPI_BSSR_CSS_SHIFT 17
#define  BOOTSPI_BSSR_CSS_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_CSS_MASK) >> BOOTSPI_BSSR_CSS_SHIFT)
#define  BOOTSPI_BSSR_CSS_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_CSS_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_CSS_SHIFT))

#define  BOOTSPI_BSSR_EEPROM_MASK 0x10000
#define  BOOTSPI_BSSR_EEPROM_SHIFT 16
#define  BOOTSPI_BSSR_EEPROM_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_EEPROM_MASK) >> BOOTSPI_BSSR_EEPROM_SHIFT)
#define  BOOTSPI_BSSR_EEPROM_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_EEPROM_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_EEPROM_SHIFT))

#define  BOOTSPI_BSSR_RESERVED2_MASK 0xfe00
#define  BOOTSPI_BSSR_RESERVED2_SHIFT 9
#define  BOOTSPI_BSSR_RESERVED2_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_RESERVED2_MASK) >> BOOTSPI_BSSR_RESERVED2_SHIFT)
#define  BOOTSPI_BSSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_RESERVED2_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_RESERVED2_SHIFT))

#define  BOOTSPI_BSSR_COMMANDBUSY_MASK 0x100
#define  BOOTSPI_BSSR_COMMANDBUSY_SHIFT 8
#define  BOOTSPI_BSSR_COMMANDBUSY_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_COMMANDBUSY_MASK) >> BOOTSPI_BSSR_COMMANDBUSY_SHIFT)
#define  BOOTSPI_BSSR_COMMANDBUSY_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_COMMANDBUSY_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_COMMANDBUSY_SHIFT))

#define  BOOTSPI_BSSR_DATA_MASK 0xff
#define  BOOTSPI_BSSR_DATA_SHIFT 0
#define  BOOTSPI_BSSR_DATA_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSSR_DATA_MASK) >> BOOTSPI_BSSR_DATA_SHIFT)
#define  BOOTSPI_BSSR_DATA_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSSR_DATA_MASK) | (((uint32_t)val) << BOOTSPI_BSSR_DATA_SHIFT))

//====================================================================
//Register: Bootspi Interrupt Enable Register (BSIEN)
/** \brief This register is used to enable/disable the BootSPI interrupt.*/
//====================================================================

#define  BOOTSPI_BSIEN_RESERVED1_MASK 0xfffffffe
#define  BOOTSPI_BSIEN_RESERVED1_SHIFT 1
#define  BOOTSPI_BSIEN_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSIEN_RESERVED1_MASK) >> BOOTSPI_BSIEN_RESERVED1_SHIFT)
#define  BOOTSPI_BSIEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSIEN_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSIEN_RESERVED1_SHIFT))

#define  BOOTSPI_BSIEN_DATAREADYINTEN_MASK 0x1
#define  BOOTSPI_BSIEN_DATAREADYINTEN_SHIFT 0
#define  BOOTSPI_BSIEN_DATAREADYINTEN_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSIEN_DATAREADYINTEN_MASK) >> BOOTSPI_BSIEN_DATAREADYINTEN_SHIFT)
#define  BOOTSPI_BSIEN_DATAREADYINTEN_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSIEN_DATAREADYINTEN_MASK) | (((uint32_t)val) << BOOTSPI_BSIEN_DATAREADYINTEN_SHIFT))

//====================================================================
//Register: Bootspi Interrupt Acknowledge Register (BSIACK)
/** \brief This register is used to acknowledge the BootSPI interrupt.*/
//====================================================================

#define  BOOTSPI_BSIACK_RESERVED1_MASK 0xfffffffe
#define  BOOTSPI_BSIACK_RESERVED1_SHIFT 1
#define  BOOTSPI_BSIACK_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSIACK_RESERVED1_MASK) >> BOOTSPI_BSIACK_RESERVED1_SHIFT)
#define  BOOTSPI_BSIACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSIACK_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSIACK_RESERVED1_SHIFT))

#define  BOOTSPI_BSIACK_DATAREADYINTACK_MASK 0x1
#define  BOOTSPI_BSIACK_DATAREADYINTACK_SHIFT 0
#define  BOOTSPI_BSIACK_DATAREADYINTACK_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSIACK_DATAREADYINTACK_MASK) >> BOOTSPI_BSIACK_DATAREADYINTACK_SHIFT)
#define  BOOTSPI_BSIACK_DATAREADYINTACK_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSIACK_DATAREADYINTACK_MASK) | (((uint32_t)val) << BOOTSPI_BSIACK_DATAREADYINTACK_SHIFT))

//====================================================================
//Register: Bootspi Interrupt Status Register (BSISTAT)
/** \brief This register provides the raw interrupt status, prior to masking by the BSIEN bit."*/
//====================================================================

#define  BOOTSPI_BSISTAT_RESERVED1_MASK 0xfffffffe
#define  BOOTSPI_BSISTAT_RESERVED1_SHIFT 1
#define  BOOTSPI_BSISTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSISTAT_RESERVED1_MASK) >> BOOTSPI_BSISTAT_RESERVED1_SHIFT)
#define  BOOTSPI_BSISTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSISTAT_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSISTAT_RESERVED1_SHIFT))

#define  BOOTSPI_BSISTAT_DATAREADYINTPEND_MASK 0x1
#define  BOOTSPI_BSISTAT_DATAREADYINTPEND_SHIFT 0
#define  BOOTSPI_BSISTAT_DATAREADYINTPEND_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSISTAT_DATAREADYINTPEND_MASK) >> BOOTSPI_BSISTAT_DATAREADYINTPEND_SHIFT)
#define  BOOTSPI_BSISTAT_DATAREADYINTPEND_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSISTAT_DATAREADYINTPEND_MASK) | (((uint32_t)val) << BOOTSPI_BSISTAT_DATAREADYINTPEND_SHIFT))

//====================================================================
//Register: Bootspi Interrupt Test Register (BSITEST)
/** \brief This register provides firmware with the means to manually generate a BootSPI interrupt."*/
//====================================================================

#define  BOOTSPI_BSITEST_RESERVED1_MASK 0xfffffffe
#define  BOOTSPI_BSITEST_RESERVED1_SHIFT 1
#define  BOOTSPI_BSITEST_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSITEST_RESERVED1_MASK) >> BOOTSPI_BSITEST_RESERVED1_SHIFT)
#define  BOOTSPI_BSITEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSITEST_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSITEST_RESERVED1_SHIFT))

#define  BOOTSPI_BSITEST_DATAREADYINTTEST_MASK 0x1
#define  BOOTSPI_BSITEST_DATAREADYINTTEST_SHIFT 0
#define  BOOTSPI_BSITEST_DATAREADYINTTEST_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSITEST_DATAREADYINTTEST_MASK) >> BOOTSPI_BSITEST_DATAREADYINTTEST_SHIFT)
#define  BOOTSPI_BSITEST_DATAREADYINTTEST_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSITEST_DATAREADYINTTEST_MASK) | (((uint32_t)val) << BOOTSPI_BSITEST_DATAREADYINTTEST_SHIFT))

//====================================================================
//Register: Bootspi Active Control/Status Register (BSACTIVE)
/** \brief In order to enable external on-board programming of SPI memories, the chip pins associated
      with the BootSPI modules come up tri-stated. However, in order to allow for booting from the
      SPI memory, the pins have to change to active mode before any code is fetched. The bit in
      this register implements this required functionality. The bit will be '0' at reset causing
      the tri-stating of the interface, but will be automatically set to '1', causing the
      SPI pins to be driven, as soon as the BootSPI data access memory space is read from.
      Firmware can clear the bit here to return the interface to in-active status, or set the bit
      here to activate the interface before using COMMAND mode. Switching pin muxes to bootspi
      mode should be done before setting this bit.*/
//====================================================================

#define  BOOTSPI_BSACTIVE_RESERVED1_MASK 0xfffffffe
#define  BOOTSPI_BSACTIVE_RESERVED1_SHIFT 1
#define  BOOTSPI_BSACTIVE_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSACTIVE_RESERVED1_MASK) >> BOOTSPI_BSACTIVE_RESERVED1_SHIFT)
#define  BOOTSPI_BSACTIVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSACTIVE_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSACTIVE_RESERVED1_SHIFT))

#define  BOOTSPI_BSACTIVE_BSPIACTIVE_MASK 0x1
#define  BOOTSPI_BSACTIVE_BSPIACTIVE_SHIFT 0
#define  BOOTSPI_BSACTIVE_BSPIACTIVE_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSACTIVE_BSPIACTIVE_MASK) >> BOOTSPI_BSACTIVE_BSPIACTIVE_SHIFT)
#define  BOOTSPI_BSACTIVE_BSPIACTIVE_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSACTIVE_BSPIACTIVE_MASK) | (((uint32_t)val) << BOOTSPI_BSACTIVE_BSPIACTIVE_SHIFT))

//====================================================================
//Register: Bootspi Timing Configuration Register (BSTR)
/** \brief The fields in this register configure various timing delays that are used to tune the
      timing of various signals to work with various SPI parts.*/
//====================================================================

#define  BOOTSPI_BSTR_RESERVED1_MASK 0xffc00000
#define  BOOTSPI_BSTR_RESERVED1_SHIFT 22
#define  BOOTSPI_BSTR_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_RESERVED1_MASK) >> BOOTSPI_BSTR_RESERVED1_SHIFT)
#define  BOOTSPI_BSTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_RESERVED1_SHIFT))

#define  BOOTSPI_BSTR_SETUPHOLDDELAY_MASK 0x300000
#define  BOOTSPI_BSTR_SETUPHOLDDELAY_SHIFT 20
#define  BOOTSPI_BSTR_SETUPHOLDDELAY_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_SETUPHOLDDELAY_MASK) >> BOOTSPI_BSTR_SETUPHOLDDELAY_SHIFT)
#define  BOOTSPI_BSTR_SETUPHOLDDELAY_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_SETUPHOLDDELAY_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_SETUPHOLDDELAY_SHIFT))

#define  BOOTSPI_BSTR_DESELDELAY_MASK 0xf0000
#define  BOOTSPI_BSTR_DESELDELAY_SHIFT 16
#define  BOOTSPI_BSTR_DESELDELAY_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_DESELDELAY_MASK) >> BOOTSPI_BSTR_DESELDELAY_SHIFT)
#define  BOOTSPI_BSTR_DESELDELAY_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_DESELDELAY_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_DESELDELAY_SHIFT))

#define  BOOTSPI_BSTR_RESERVED2_MASK 0x8000
#define  BOOTSPI_BSTR_RESERVED2_SHIFT 15
#define  BOOTSPI_BSTR_RESERVED2_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_RESERVED2_MASK) >> BOOTSPI_BSTR_RESERVED2_SHIFT)
#define  BOOTSPI_BSTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_RESERVED2_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_RESERVED2_SHIFT))

#define  BOOTSPI_BSTR_RXDELAY_MASK 0x7f00
#define  BOOTSPI_BSTR_RXDELAY_SHIFT 8
#define  BOOTSPI_BSTR_RXDELAY_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_RXDELAY_MASK) >> BOOTSPI_BSTR_RXDELAY_SHIFT)
#define  BOOTSPI_BSTR_RXDELAY_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_RXDELAY_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_RXDELAY_SHIFT))

#define  BOOTSPI_BSTR_RESERVED3_MASK 0x80
#define  BOOTSPI_BSTR_RESERVED3_SHIFT 7
#define  BOOTSPI_BSTR_RESERVED3_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_RESERVED3_MASK) >> BOOTSPI_BSTR_RESERVED3_SHIFT)
#define  BOOTSPI_BSTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_RESERVED3_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_RESERVED3_SHIFT))

#define  BOOTSPI_BSTR_TXDELAY_MASK 0x7f
#define  BOOTSPI_BSTR_TXDELAY_SHIFT 0
#define  BOOTSPI_BSTR_TXDELAY_MASK_SHIFT(reg) (((reg) & BOOTSPI_BSTR_TXDELAY_MASK) >> BOOTSPI_BSTR_TXDELAY_SHIFT)
#define  BOOTSPI_BSTR_TXDELAY_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_BSTR_TXDELAY_MASK) | (((uint32_t)val) << BOOTSPI_BSTR_TXDELAY_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register is of particular interest to firmware.*/
//====================================================================

#define  BOOTSPI_REV0_MAJ_MASK 0xffff0000
#define  BOOTSPI_REV0_MAJ_SHIFT 16
#define  BOOTSPI_REV0_MAJ_MASK_SHIFT(reg) (((reg) & BOOTSPI_REV0_MAJ_MASK) >> BOOTSPI_REV0_MAJ_SHIFT)
#define  BOOTSPI_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_REV0_MAJ_MASK) | (((uint32_t)val) << BOOTSPI_REV0_MAJ_SHIFT))

#define  BOOTSPI_REV0_MID_MASK 0xffff
#define  BOOTSPI_REV0_MID_SHIFT 0
#define  BOOTSPI_REV0_MID_MASK_SHIFT(reg) (((reg) & BOOTSPI_REV0_MID_MASK) >> BOOTSPI_REV0_MID_SHIFT)
#define  BOOTSPI_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_REV0_MID_MASK) | (((uint32_t)val) << BOOTSPI_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  BOOTSPI_REV1_RESERVED1_MASK 0xffff0000
#define  BOOTSPI_REV1_RESERVED1_SHIFT 16
#define  BOOTSPI_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & BOOTSPI_REV1_RESERVED1_MASK) >> BOOTSPI_REV1_RESERVED1_SHIFT)
#define  BOOTSPI_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_REV1_RESERVED1_MASK) | (((uint32_t)val) << BOOTSPI_REV1_RESERVED1_SHIFT))

#define  BOOTSPI_REV1_CFG_MASK 0xffff
#define  BOOTSPI_REV1_CFG_SHIFT 0
#define  BOOTSPI_REV1_CFG_MASK_SHIFT(reg) (((reg) & BOOTSPI_REV1_CFG_MASK) >> BOOTSPI_REV1_CFG_SHIFT)
#define  BOOTSPI_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~BOOTSPI_REV1_CFG_MASK) | (((uint32_t)val) << BOOTSPI_REV1_CFG_SHIFT))

#endif // BOOTSPI
