 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file BCM_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _BCM_REGSTRUCTS_H_
#define _BCM_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: G2 BCM TOP LEVEL (BCM)
/** \brief G2 BCM Top Level Register Description*/
//
//====================================================================

//====================================================================
//
//Register File: BIU Registers (BIU)
/** \brief This describes the registers within the BIU design. The purpose of the BIU is to
act as the interface between the Cortex processor, the AXI interfaces, and the
accelerator engines.
The Cortex processor has access to all registers described here, with some
restrictions involving reading or writing, as noted within the register
descriptions.
The host has access to only a subset of the registers described. It can access
only the lowest 128 word locations. The highest address the host shall have
access to is byte address 10'h1FC. Note that while the is its addressable space,
not all registers within this space are implemented, and access to unimplemented
register space will generate address exceptions, along with all accesses outside
the 128 word space.
In general, all registers with a name starting with "SP_" are not accessible to
the host.*/
//
//====================================================================

typedef struct BIU_REGS_s
{
  volatile uint32_t CMD_PARAM0;  ///< 0x0 [W]: Command Parameter 0
  volatile uint32_t CMD_PARAM1;  ///< 0x4 [W]: Command Parameter 1
  volatile uint32_t CMD_PARAM2;  ///< 0x8 [W]: Command Parameter 2
  volatile uint32_t CMD_PARAM3;  ///< 0xc [W]: Command Parameter 3
  volatile uint32_t CMD_PARAM4;  ///< 0x10 [W]: Command Parameter 4
  volatile uint32_t CMD_PARAM5;  ///< 0x14 [W]: Command Parameter 5
  volatile uint32_t CMD_PARAM6;  ///< 0x18 [W]: Command Parameter 6
  volatile uint32_t CMD_PARAM7;  ///< 0x1c [W]: Command Parameter 7
  volatile uint32_t CMD_PARAM8;  ///< 0x20 [W]: Command Parameter 8
  volatile uint32_t CMD_PARAM9;  ///< 0x24 [W]: Command Parameter 9
  volatile uint32_t CMD_PARAM10;  ///< 0x28 [W]: Command Parameter 10
  volatile uint32_t CMD_PARAM11;  ///< 0x2c [W]: Command Parameter 11
  volatile uint32_t CMD_PARAM12;  ///< 0x30 [W]: Command Parameter 12
  volatile uint32_t CMD_PARAM13;  ///< 0x34 [W]: Command Parameter 13
  volatile uint32_t CMD_PARAM14;  ///< 0x38 [W]: Command Parameter 14
  volatile uint32_t CMD_PARAM15;  ///< 0x3c [W]: Command Parameter 15
  volatile uint32_t CMD;  ///< 0x40 [W]: Secure Processor Command
  volatile uint32_t reserved0[15];
  volatile uint32_t CMD_RET_STATUS;  ///< 0x80 [R]: Command Return Status
  volatile uint32_t CMD_STATUS0;  ///< 0x84 [R]: Command Status 0
  volatile uint32_t CMD_STATUS1;  ///< 0x88 [R]: Command Status 1
  volatile uint32_t CMD_STATUS2;  ///< 0x8c [R]: Command Status 2
  volatile uint32_t CMD_STATUS3;  ///< 0x90 [R]: Command Status 3
  volatile uint32_t CMD_STATUS4;  ///< 0x94 [R]: Command Status 4
  volatile uint32_t CMD_STATUS5;  ///< 0x98 [R]: Command Status 5
  volatile uint32_t CMD_STATUS6;  ///< 0x9c [R]: Command Status 6
  volatile uint32_t CMD_STATUS7;  ///< 0xa0 [R]: Command Status 7
  volatile uint32_t CMD_STATUS8;  ///< 0xa4 [R]: Command Status 8
  volatile uint32_t CMD_STATUS9;  ///< 0xa8 [R]: Command Status 9
  volatile uint32_t CMD_STATUS10;  ///< 0xac [R]: Command Status 10
  volatile uint32_t CMD_STATUS11;  ///< 0xb0 [R]: Command Status 11
  volatile uint32_t CMD_STATUS12;  ///< 0xb4 [R]: Command Status 12
  volatile uint32_t CMD_STATUS13;  ///< 0xb8 [R]: Command Status 13
  volatile uint32_t CMD_STATUS14;  ///< 0xbc [R]: Command Status 14
  volatile uint32_t CMD_STATUS15;  ///< 0xc0 [R]: Command Status 15
  volatile uint32_t CMD_FIFO_STATUS;  ///< 0xc4 [R/W]: Command Fifo Status
  volatile uint32_t HST_INTERRUPT_RST;  ///< 0xc8 [R/W]: Host Interrupt Reset
  volatile uint32_t HST_INTERRUPT_MASK;  ///< 0xcc [R/W]: Host Interrupt Mask
  volatile uint32_t HST_EXCEPT_ADDR;  ///< 0xd0 [R/W]: Host Exception Address
  volatile uint32_t HST_TRUST;  ///< 0xd4 [R]: SP Trust Register
  volatile uint32_t WTM_ID;  ///< 0xd8 [R]: WTM Identification
  volatile uint32_t WTM_REV;  ///< 0xdc [R]: WTM Revision
  volatile uint32_t CONTEXT_STATUS;  ///< 0xe0 [R]: Context Status
  volatile uint32_t reserved1[75];
  volatile uint32_t SP_INTERRUPT_SET;  ///< 0x210 [R/W]: SP Interrupt Set
  volatile uint32_t SP_SRAM_CTRL;  ///< 0x214 [R/W]: SP SRAM Control
  volatile uint32_t SP_INTERRUPT_RST;  ///< 0x218 [R/W]: SP Interrupt Reset
  volatile uint32_t SP_INTERRUPT_MASK;  ///< 0x21c [R/W]: SP Interrupt Mask
  volatile uint32_t SP_CONTROL;  ///< 0x220 [R/W]: SP Control
  volatile uint32_t SP_EXCEPT_ADDR;  ///< 0x224 [R/W]: SP Exception Address
  volatile uint32_t SP_EXCEPT_DATA;  ///< 0x228 [R/W]: SP Exception Data
  volatile uint32_t SP_EXCEPT_PAR;  ///< 0x22c [R/W]: SP Exception Parity
  volatile uint32_t reserved2;
  volatile uint32_t HST_INTERRUPT_SET;  ///< 0x234 [R/W]: Host Interrupt Set
  volatile uint32_t reserved3[4];
  volatile uint32_t SP_TL;  ///< 0x248 [R/W]: Trust Level
} BIU_REGS_t;

//====================================================================
//
//Register File: APB ADEC Registers (APB_ADEC)
//
//====================================================================

typedef struct APB_ADEC_REGS_s
{
  volatile uint32_t ADEC_CTRL;  ///< 0x0 [R/W]: Engine Control
  volatile uint32_t ADEC_CTRL2;  ///< 0x4 [R/W]: Engine Control 2
  volatile uint32_t AXI_SL_CTRL;  ///< 0x8 [R/W]: AXI Slave Control Register
  volatile uint32_t ADEC_INT;  ///< 0xc [R/W]: Address Decoder Interrupt Register
  volatile uint32_t ADEC_INT_MSK;  ///< 0x10 [R/W]: Address Decoder Interrupt Mask
  volatile uint32_t ACC_ERR_ADR;  ///< 0x14 [R]: APB Access Error Address Register
  volatile uint32_t MP_FIFO_ERR_ADR;  ///< 0x18 [R]: MP FIFO Error Read Pointer
} APB_ADEC_REGS_t;

//====================================================================
//
//Register File: AXI Master Control Registers (DMA)
//
//====================================================================

typedef struct DMA_REGS_s
{
  volatile uint32_t IN_DMA_CTRL;  ///< 0x0 [R/W]: Input DMA Control Register
  volatile uint32_t IN_DMA_STATUS;  ///< 0x4 [R]: Input DMA Status Register
  volatile uint32_t IN_SRC_ADR;  ///< 0x8 [R/W]: DMA Source Address
  volatile uint32_t IN_XFER_CNTR;  ///< 0xc [R/W]: DMA Input Transfer Counter
  volatile uint32_t IN_NX_LL_ADR;  ///< 0x10 [R/W]: Input DMA Next Link List Address
  volatile uint32_t IN_DMA_INT1;  ///< 0x14 [R/W]: Input DMA Interrupt 1
  volatile uint32_t IN_DMA_INT1_MSK;  ///< 0x18 [R/W]: Input DMA Interrupt 1 Mask
  volatile uint32_t OUT_DMA_CTRL;  ///< 0x1c [R/W]: Output DMA Control Register
  volatile uint32_t OUT_DMA_STATUS;  ///< 0x20 [R]: Output DMA Status Register
  volatile uint32_t OUT_DEST_ADR;  ///< 0x24 [R/W]: DMA Output FIFO Destination Address
  volatile uint32_t OUT_XFER_CNTR;  ///< 0x28 [R/W]: Output DMA Transfer Counter
  volatile uint32_t OUT_NX_LL_ADR;  ///< 0x2c [R/W]: Output DMA Next Link List Address
  volatile uint32_t OUT_DMA_INT1;  ///< 0x30 [R/W]: Output DMA Interrupt 1
  volatile uint32_t OUT_DMA_INT1_MSK;  ///< 0x34 [R/W]: Output DMA Interrupt 1 Mask
  volatile uint32_t AXI_CTRL;  ///< 0x38 [R/W]: AXI Control Register
  volatile uint32_t IF_RCOUNT;  ///< 0x3c [R]: DMA input FIFO Remain Count
  volatile uint32_t IF_RD_PTR_ERR;  ///< 0x40 [R]: DMA input FIFO Error Read Pointer
  volatile uint32_t OF_SPACE;  ///< 0x44 [R]: DMA Output FIFO Remain Space
  volatile uint32_t OF_RD_PTR_ERR;  ///< 0x48 [R]: DMA output FIFO Error Read Pointer
  volatile uint32_t reserved0[45];
  volatile uint32_t IF_RAM[64];  ///< 0x100 [R/W]: DMA input FIFO Access Port
  volatile uint32_t reserved1[64];
  volatile uint32_t OF_RAM[32];  ///< 0x300 [R/W]: DMA Output FIFO Access Port
} DMA_REGS_t;

//====================================================================
//
//Register File: AXI Master Control Registers (WTM_ACCEL_BUS_REG)
/** \brief Accelrator Internal Bus Control Registers
Control Data Flow Between DMA&nbsp; (Input & Output Buffers), Scratch Pad
(Temporary Buffer) and Group A &&nbsp; Group B Accelrators*/
//
//====================================================================

typedef struct WTM_ACCEL_BUS_REG_REGS_s
{
  volatile uint32_t accel_bus_ctrl;  ///< 0x0 [R/W]: Trusted Module Internal Bus Control
} WTM_ACCEL_BUS_REG_REGS_t;

//====================================================================
//
//Register File: CRYPTO Engine Control Registers (CRYPT)
//
//====================================================================

typedef struct CRYPT_REGS_s
{
  volatile uint32_t AES_CFG_REG;  ///< 0x0 [R/W]: AES_CFG_REG
  volatile uint32_t AES_CTRL_REG;  ///< 0x4 [R/W]: AES_CTRL_REG
  volatile uint32_t AES_CMD_REG;  ///< 0x8 [R/W]: AES_CMD_REG
  volatile uint32_t AES_STATUS_REG;  ///< 0xc [R]: AES_STATUS_REG
  volatile uint32_t AES_INTRPT_REG;  ///< 0x10 [R/W]: AES_INTRPT_REG
  volatile uint32_t AES_INTRPT_SRC_EN_REG;  ///< 0x14 [R/W]: AES_INTRPT_SRC_EN_REG
  volatile uint32_t AES_STREAM_SIZE;  ///< 0x18 [R/W]: AES_STREAM_SIZE
  volatile uint32_t DES_CFG_REG;  ///< 0x1c [R/W]: DES_CFG_REG
  volatile uint32_t DES_CTRL_REG;  ///< 0x20 [R/W]: DES_CTRL_REG
  volatile uint32_t DES_CMD_REG;  ///< 0x24 [R/W]: DES_CMD_REG
  volatile uint32_t DES_STATUS_REG;  ///< 0x28 [R]: DES_STATUS_REG
  volatile uint32_t DES_INTRPT_REG;  ///< 0x2c [R/W]: DES_INTRPT_REG
  volatile uint32_t DES_INTRPT_SRC_EN_REG;  ///< 0x30 [R/W]: DES_INTRPT_SRC_EN_REG
  volatile uint32_t DES_STREAM_SIZE;  ///< 0x34 [R/W]: DES_STREAM_SIZE
  volatile uint32_t RC4_CFG_REG;  ///< 0x38 [R/W]: RC4_CFG_REG
  volatile uint32_t RC4_CTRL_REG;  ///< 0x3c [R/W]: RC4_CTRL_REG
  volatile uint32_t RC4_CMD_REG;  ///< 0x40 [R/W]: RC4_CMD_REG
  volatile uint32_t RC4_STATUS_REG;  ///< 0x44 [R]: RC4_STATUS_REG
  volatile uint32_t RC4_INTRPT_REG;  ///< 0x48 [R/W]: RC4_INTRPT_REG
  volatile uint32_t RC4_INTRPT_SRC_EN_REG;  ///< 0x4c [R/W]: RC4_INTRPT_SRC_EN_REG
  volatile uint32_t RC4_STREAM_SIZE;  ///< 0x50 [R/W]: RC4_STREAM_SIZE
  volatile uint32_t RC4_INDEX;  ///< 0x54 [R/W]: RC4_INDEX
  volatile uint32_t KEY2_W0;  ///< 0x58 [R/W]: KEY2_WORD0
  volatile uint32_t KEY2_W1;  ///< 0x5c [R/W]: KEY2_WORD1
  volatile uint32_t KEY2_W2;  ///< 0x60 [R/W]: KEY2_WORD2
  volatile uint32_t KEY2_W3;  ///< 0x64 [R/W]: KEY2_WORD3
  volatile uint32_t KEY2_W4;  ///< 0x68 [R/W]: KEY2_WORD4
  volatile uint32_t KEY2_W5;  ///< 0x6c [R/W]: KEY2_WORD5
  volatile uint32_t KEY2_W6;  ///< 0x70 [R/W]: KEY2_WORD6
  volatile uint32_t KEY2_W7;  ///< 0x74 [R/W]: KEY2_WORD7
  volatile uint32_t KEY1_W0;  ///< 0x78 [R/W]: KEY1_WORD0
  volatile uint32_t KEY1_W1;  ///< 0x7c [R/W]: KEY1_WORD1
  volatile uint32_t KEY1_W2;  ///< 0x80 [R/W]: KEY1_WORD2
  volatile uint32_t KEY1_W3;  ///< 0x84 [R/W]: KEY1_WORD3
  volatile uint32_t KEY1_W4;  ///< 0x88 [R/W]: KEY1_WORD4
  volatile uint32_t KEY1_W5;  ///< 0x8c [R/W]: KEY1_WORD5
  volatile uint32_t KEY1_W6;  ///< 0x90 [R/W]: KEY1_WORD6
  volatile uint32_t KEY1_W7;  ///< 0x94 [R/W]: KEY1_WORD7
  volatile uint32_t IV_W0;  ///< 0x98 [R/W]: IV_WORD0
  volatile uint32_t IV_W1;  ///< 0x9c [R/W]: IV_WORD1
  volatile uint32_t IV_W2;  ///< 0xa0 [R/W]: IV_WORD2
  volatile uint32_t IV_W3;  ///< 0xa4 [R/W]: IV_WORD3
  volatile uint32_t ENGINE_SELECT_REG;  ///< 0xa8 [R/W]: ENGINE_SELECT_REG
} CRYPT_REGS_t;

//====================================================================
//
//Register File: HASH-MAC Engine Control Registers (HASH)
//
//====================================================================

typedef struct HASH_REGS_s
{
  volatile uint32_t Hash_Configure;  ///< 0x0 [R/W]: Hash Configuration
  volatile uint32_t Hash_control;  ///< 0x4 [R/W]: Hash Control
  volatile uint32_t Hash_Command;  ///< 0x8 [R/W]: Hash Command
  volatile uint32_t Hash_Status;  ///< 0xc [R/W]: Hash Status
  volatile uint32_t incoming_segment_size;  ///< 0x10 [R/W]: Incoming Message Segment Size Word
  volatile uint32_t reserved0;
  volatile uint32_t total_message_size_low;  ///< 0x18 [R/W]: Total Message Size Low Word
  volatile uint32_t total_message_size_high;  ///< 0x1c [R/W]: Total Message Size High Word
  volatile uint32_t digest_context_A;  ///< 0x20 [R/W]: Hash Digest and context A
  volatile uint32_t digest_context_B;  ///< 0x24 [R/W]: Hash Digest and context B
  volatile uint32_t digest_context_C;  ///< 0x28 [R/W]: Hash Digest and context C
  volatile uint32_t digest_context_D;  ///< 0x2c [R/W]: Hash Digest and context D
  volatile uint32_t digest_context_E;  ///< 0x30 [R/W]: Hash Digest and context E
  volatile uint32_t digest_context_F;  ///< 0x34 [R/W]: Hash Digest and context F
  volatile uint32_t digest_context_G;  ///< 0x38 [R/W]: Hash Digest and context G
  volatile uint32_t digest_context_H;  ///< 0x3c [R/W]: Hash Digest and context H
  volatile uint32_t digest_context_A_HIGH;  ///< 0x40 [R/W]: Hash Digest and context A High Word
  volatile uint32_t digest_context_B_HIGH;  ///< 0x44 [R/W]: Hash Digest and context B High Word
  volatile uint32_t digest_context_C_HIGH;  ///< 0x48 [R/W]: Hash Digest and context C High Word
  volatile uint32_t digest_context_D_HIGH;  ///< 0x4c [R/W]: Hash Digest and context D High Word
  volatile uint32_t digest_context_E_HIGH;  ///< 0x50 [R/W]: Hash Digest and context E High Word
  volatile uint32_t digest_context_F_HIGH;  ///< 0x54 [R/W]: Hash Digest and context F High Word
  volatile uint32_t digest_context_G_HIGH;  ///< 0x58 [R/W]: Hash Digest and context G High Word
  volatile uint32_t digest_context_H_HIGH;  ///< 0x5c [R/W]: Hash Digest and context H High Word
  volatile uint32_t contexto_A;  ///< 0x60 [R/W]: HMAC Contexto A
  volatile uint32_t contexto_B;  ///< 0x64 [R/W]: HMAC Contexto B
  volatile uint32_t contexto_C;  ///< 0x68 [R/W]: HMAC Contexto C
  volatile uint32_t contexto_D;  ///< 0x6c [R/W]: HMAC Contexto D
  volatile uint32_t contexto_E;  ///< 0x70 [R/W]: HMAC Contexto E
  volatile uint32_t contexto_F;  ///< 0x74 [R/W]: HMAC Contexto F
  volatile uint32_t contexto_G;  ///< 0x78 [R/W]: HMAC Contexto G
  volatile uint32_t contexto_H;  ///< 0x7c [R/W]: HMAC Contexto H
  volatile uint32_t contexto_A_HIGH;  ///< 0x80 [R/W]: HMAC Contexto A High Word
  volatile uint32_t contexto_B_HIGH;  ///< 0x84 [R/W]: HMAC Contexto B High Word
  volatile uint32_t contexto_C_HIGH;  ///< 0x88 [R/W]: HMAC Contexto C High Word
  volatile uint32_t contexto_D_HIGH;  ///< 0x8c [R/W]: HMAC Contexto D High Word
  volatile uint32_t contexto_E_HIGH;  ///< 0x90 [R/W]: HMAC Contexto E High Word
  volatile uint32_t contexto_F_HIGH;  ///< 0x94 [R/W]: HMAC Contexto F High Word
  volatile uint32_t contexto_G_HIGH;  ///< 0x98 [R/W]: HMAC Contexto G High Word
  volatile uint32_t contexto_H_HIGH;  ///< 0x9c [R/W]: HMAC Contexto H High Word
  volatile uint32_t key_len;  ///< 0xa0 [R/W]: HMAC Key Length
  volatile uint32_t key_0;  ///< 0xa4 [R/W]: HMAC Key 0
  volatile uint32_t key_1;  ///< 0xa8 [R/W]: HMAC Key 1
  volatile uint32_t key_2;  ///< 0xac [R/W]: HMAC Key 2
  volatile uint32_t key_3;  ///< 0xb0 [R/W]: HMAC Key 3
  volatile uint32_t key_4;  ///< 0xb4 [R/W]: HMAC Key 4
  volatile uint32_t key_5;  ///< 0xb8 [R/W]: HMAC Key 5
  volatile uint32_t key_6;  ///< 0xbc [R/W]: HMAC Key 6
  volatile uint32_t key_7;  ///< 0xc0 [R/W]: HMAC Key 7
  volatile uint32_t key_8;  ///< 0xc4 [R/W]: HMAC Key 8
  volatile uint32_t key_9;  ///< 0xc8 [R/W]: HMAC Key 9
  volatile uint32_t key_10;  ///< 0xcc [R/W]: HMAC Key 10
  volatile uint32_t key_11;  ///< 0xd0 [R/W]: HMAC Key 11
  volatile uint32_t key_12;  ///< 0xd4 [R/W]: HMAC Key 12
  volatile uint32_t key_13;  ///< 0xd8 [R/W]: HMAC Key 13
  volatile uint32_t key_14;  ///< 0xdc [R/W]: HMAC Key 14
  volatile uint32_t key_15;  ///< 0xe0 [R/W]: HMAC Key 15
  volatile uint32_t key_16;  ///< 0xe4 [R/W]: HMAC Key 16
  volatile uint32_t key_17;  ///< 0xe8 [R/W]: HMAC Key 17
  volatile uint32_t key_18;  ///< 0xec [R/W]: HMAC Key 18
  volatile uint32_t key_19;  ///< 0xf0 [R/W]: HMAC Key 19
  volatile uint32_t key_20;  ///< 0xf4 [R/W]: HMAC Key 20
  volatile uint32_t key_21;  ///< 0xf8 [R/W]: HMAC Key 21
  volatile uint32_t key_22;  ///< 0xfc [R/W]: HMAC Key 22
  volatile uint32_t key_23;  ///< 0x100 [R/W]: HMAC Key 23
  volatile uint32_t key_24;  ///< 0x104 [R/W]: HMAC Key 24
  volatile uint32_t key_25;  ///< 0x108 [R/W]: HMAC Key 25
  volatile uint32_t key_26;  ///< 0x10c [R/W]: HMAC Key 26
  volatile uint32_t key_27;  ///< 0x110 [R/W]: HMAC Key 27
  volatile uint32_t key_28;  ///< 0x114 [R/W]: HMAC Key 28
  volatile uint32_t key_29;  ///< 0x118 [R/W]: HMAC Key 29
  volatile uint32_t key_30;  ///< 0x11c [R/W]: HMAC Key 30
  volatile uint32_t key_31;  ///< 0x120 [R/W]: HMAC Key 31
} HASH_REGS_t;

//====================================================================
//
//Register File: WTM Scratch Pad Control Registers (WTM_SCRATCH_PAD)
/** \brief Scratch Pad for Accelerators
Data RAM
Provides CPU, Random Access & Sequential Access to Data RAM*/
//
//====================================================================

typedef struct WTM_SCRATCH_PAD_REGS_s
{
  volatile uint32_t SP_CTRL;  ///< 0x0 [R/W]: Access Control for Scratch Pad
  volatile uint32_t SP_STATUS;  ///< 0x4 [R/W]: Access Status for Scratch Pad
  volatile uint32_t SP_CPU_WR_ADDR;  ///< 0x8 [R/W]: Write Address for Scratch Pad Data Access
  volatile uint32_t SP_CPU_WR_DATA;  ///< 0xc [W]: Write Data for Scratch Pad for Data Access
  volatile uint32_t SP_CPU_RD_ADDR;  ///< 0x10 [R/W]: Read Address for Scratch Pad Data Access
  volatile uint32_t SP_CPU_RD_DATA;  ///< 0x14 [R]: Read Data for Scratch Pad for Data Access
  volatile uint32_t SP_SET_WR_ADDR;  ///< 0x18 [R/W]: Scratch Pad Set Write Address
  volatile uint32_t SP_SET_RD_ADDR;  ///< 0x1c [R/W]: Scratch Pad Set Read Address
} WTM_SCRATCH_PAD_REGS_t;

//====================================================================
//
//Register File: ZMODP Engine Control Registers (ZMODP)
/** \brief The ZMODP module can be used to perform four kinds of operations: Montgomery
multiplication, ordinary modular multiplication, modular exponentiation and
multiplicative inversion with prime moduli (which can be performed via little
Fermat theorem). The operand size varies from 32 to 2048. Five size
modes, 128, 256, 512, 1024 and 2048-bit are provided. For example, to
perform 101-bit modular exponentiation, one needs to set the size mode
as 128-bit. Two code modes for exponentiation, non-secure mode and secure mode,
are provided. For encryption, non-secure mode should be chosen to obtain faster
operation speed, and for decryption, secure mode should be chosen to counter
against simple powering analysis (SPA).*/
//
//====================================================================

typedef struct ZMODP_REGS_s
{
  volatile uint32_t ZMODP_CFG_REG;  ///< 0x0 [R/W]: ZMODP configuration register
  volatile uint32_t ZMODP_CTRL_REG;  ///< 0x4 [R/W]: ZMODP control register
  volatile uint32_t ZMODP_CMD_REG;  ///< 0x8 [R/W]: ZMODP command register
  volatile uint32_t ZMODP_STATUS_REG;  ///< 0xc [R]: ZMODP status register
  volatile uint32_t ZMODP_INTRPT_SRC_REG;  ///< 0x10 [R/W]: ZMODP interrupt sources register
  volatile uint32_t ZMODP_INTRPT_SRC_EN_REG;  ///< 0x14 [R/W]: ZMODP interrupt sources enable register
  volatile uint32_t ZMODP_MEM[195];  ///< 0x18 [R/W]: ZMODP Register Array
} ZMODP_REGS_t;

//====================================================================
//
//Register File: Security Control Registers (BCMREG)
//
//====================================================================

typedef struct BCMREG_REGS_s
{
  volatile uint32_t reserved0;
  volatile uint32_t OTP_CONTROLLER_CONTROL;  ///< 0x4 [R/W]: OTP Controller Control Register
  volatile uint32_t INV_ACC_INT_MAS;  ///< 0x8 [R/W]: Invalid Access Interrupt Mask Register
  volatile uint32_t INV_ACC_INT_CLR;  ///< 0xc [R/W]: Invalid Access Interrupt Clear Register
  volatile uint32_t INV_ACC_STA;  ///< 0x10 [R/W]: Invalid Access Interrupt Status Register
  volatile uint32_t REGULATOR_CNT_REG;  ///< 0x14 [R/W]: Regulator Counters Control Register
  volatile uint32_t iKey4;  ///< 0x18 [R/W]: iKey Register
  volatile uint32_t iKey5;  ///< 0x1c [R/W]: iKey Register
  volatile uint32_t iKey6;  ///< 0x20 [R/W]: iKey Register
  volatile uint32_t iKey7;  ///< 0x24 [R/W]: iKey Register
  volatile uint32_t SEC_CTRL0;  ///< 0x28 [R/W]: Secure Enable Control Register
  volatile uint32_t SEC_CTRL1;  ///< 0x2c [R/W]: Secure Enable Control Register
  volatile uint32_t DEBUG_VALID_CODE;  ///< 0x30 [R/W]: Debug Valid Code Register
  volatile uint32_t DEBUG_DISABLE;  ///< 0x34 [R/W]: Debug Disable Register
  volatile uint32_t WTM_FUSE_PROG_VAL10;  ///< 0x38 [R/W]: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 1 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL11;  ///< 0x3c [R/W]: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 2 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL12;  ///< 0x40 [R/W]: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 3 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL13;  ///< 0x44 [R/W]: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 4 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL20;  ///< 0x48 [R/W]: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 1 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL21;  ///< 0x4c [R/W]: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 2 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL22;  ///< 0x50 [R/W]: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 3 of 4)
  volatile uint32_t WTM_FUSE_PROG_VAL23;  ///< 0x54 [R/W]: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 4 of 4)
  volatile uint32_t DAP_DEBUG_VALID_CODE;  ///< 0x58 [R/W]: Debug Valid Code Register
  volatile uint32_t DAP_DEBUG_DISABLE;  ///< 0x5c [R/W]: Debug Disable Register
  volatile uint32_t CFG_CORRECTION;  ///< 0x60 [R/W]: iKey Register
  volatile uint32_t DOUT_3;  ///< 0x64 [R]: Reserved Register
  volatile uint32_t RKEK0;  ///< 0x68 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 4)
  volatile uint32_t RKEK1;  ///< 0x6c [R]: Soc Fuse Bank Num Read Register (Instance 2 of 4)
  volatile uint32_t RKEK2;  ///< 0x70 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 4)
  volatile uint32_t RKEK3;  ///< 0x74 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 4)
  volatile uint32_t JTAG_DBG_BYPASS_CNTL0;  ///< 0x78 [R/W]: JTAG Bypass Control Register for various cores
  volatile uint32_t JTAG_DBG_BYPASS_CNTL1;  ///< 0x7c [R/W]: JTAG Bypass Control Register for various cores
  volatile uint32_t DFX;  ///< 0x80 [R/W]: Miscallaneous Security Register
  volatile uint32_t RSVD2;  ///< 0x84 [R]: Reserved Register
  volatile uint32_t Bank30;  ///< 0x88 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank31;  ///< 0x8c [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank32;  ///< 0x90 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank33;  ///< 0x94 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank34;  ///< 0x98 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank35;  ///< 0x9c [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank36;  ///< 0xa0 [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank37;  ///< 0xa4 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank80;  ///< 0xa8 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank81;  ///< 0xac [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank82;  ///< 0xb0 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank83;  ///< 0xb4 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank84;  ///< 0xb8 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank85;  ///< 0xbc [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank86;  ///< 0xc0 [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank87;  ///< 0xc4 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank9_L0;  ///< 0xc8 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 4)
  volatile uint32_t Bank9_L1;  ///< 0xcc [R]: Soc Fuse Bank Num Read Register (Instance 2 of 4)
  volatile uint32_t Bank9_L2;  ///< 0xd0 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 4)
  volatile uint32_t Bank9_L3;  ///< 0xd4 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 4)
  volatile uint32_t SP2JTAG_MBOX0;  ///< 0xd8 [R/W]: Mailbox to JTAG Register (Instance 1 of 8)
  volatile uint32_t SP2JTAG_MBOX1;  ///< 0xdc [R/W]: Mailbox to JTAG Register (Instance 2 of 8)
  volatile uint32_t SP2JTAG_MBOX2;  ///< 0xe0 [R/W]: Mailbox to JTAG Register (Instance 3 of 8)
  volatile uint32_t SP2JTAG_MBOX3;  ///< 0xe4 [R/W]: Mailbox to JTAG Register (Instance 4 of 8)
  volatile uint32_t SP2JTAG_MBOX4;  ///< 0xe8 [R/W]: Mailbox to JTAG Register (Instance 5 of 8)
  volatile uint32_t SP2JTAG_MBOX5;  ///< 0xec [R/W]: Mailbox to JTAG Register (Instance 6 of 8)
  volatile uint32_t SP2JTAG_MBOX6;  ///< 0xf0 [R/W]: Mailbox to JTAG Register (Instance 7 of 8)
  volatile uint32_t SP2JTAG_MBOX7;  ///< 0xf4 [R/W]: Mailbox to JTAG Register (Instance 8 of 8)
  volatile uint32_t reserved1;
  volatile uint32_t FuseTest;  ///< 0xfc [R/W]: Miscallaneous Security Register
  volatile uint32_t reserved2;
  volatile uint32_t Bank00;  ///< 0x104 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank01;  ///< 0x108 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank02;  ///< 0x10c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank03;  ///< 0x110 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank04;  ///< 0x114 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank05;  ///< 0x118 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank06;  ///< 0x11c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank07;  ///< 0x120 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank10;  ///< 0x124 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank11;  ///< 0x128 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank12;  ///< 0x12c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank13;  ///< 0x130 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank14;  ///< 0x134 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank15;  ///< 0x138 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank16;  ///< 0x13c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank17;  ///< 0x140 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH0;  ///< 0x144 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 1 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH1;  ///< 0x148 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 2 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH2;  ///< 0x14c [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 3 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH3;  ///< 0x150 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 4 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH4;  ///< 0x154 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 5 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH5;  ///< 0x158 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 6 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH6;  ///< 0x15c [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 7 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_KEY_HASH7;  ///< 0x160 [R]: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 8 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH0;  ///< 0x164 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 1 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH1;  ///< 0x168 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 2 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH2;  ///< 0x16c [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 3 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH3;  ///< 0x170 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 4 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH4;  ///< 0x174 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 5 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH5;  ///< 0x178 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 6 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH6;  ///< 0x17c [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 7 of 8)
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_HASH7;  ///< 0x180 [R]: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 8 of 8)
  volatile uint32_t WTM_FUSE_STATUS;  ///< 0x184 [R/W]: Fuse Operation Status Register
  volatile uint32_t RSVD3;  ///< 0x188 [R]: Reserved Register
  volatile uint32_t WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC;  ///< 0x18c [R]: Fuse Value for OEM JTAG Key Hash ECC Correction Register
  volatile uint32_t BLOCK7_RESERVED_0;  ///< 0x190 [R]: Block 7 Reserved Fuse Bit Register 0
  volatile uint32_t BLOCK7_RESERVED_1;  ///< 0x194 [R]: Block 7 Reserved Fuse Bit Register 1
  volatile uint32_t BLOCK7_RESERVED_2;  ///< 0x198 [R]: Block 7 Reserved Fuse Bit Register 2
  volatile uint32_t BLOCK7_RESERVED_3;  ///< 0x19c [R]: Block 7 Reserved Fuse Bit Register 3
  volatile uint32_t BLOCK7_RESERVED_4;  ///< 0x1a0 [R]: Block 7 Reserved Fuse Bit Register 4
  volatile uint32_t BLOCK7_RESERVED_5;  ///< 0x1a4 [R]: Block 7 Reserved Fuse Bit Register 5
  volatile uint32_t OEM_KEY_HASH_ECC;  ///< 0x1a8 [R]: OEM Key Hash ECC Correction Register
  volatile uint32_t RSVD4;  ///< 0x1ac [R]: Reserved Register
  volatile uint32_t RSVD5;  ///< 0x1b0 [R]: Reserved Register
  volatile uint32_t RSVD6;  ///< 0x1b4 [R]: Reserved Register
  volatile uint32_t RSVD7;  ///< 0x1b8 [R]: Reserved Register
  volatile uint32_t RSVD8;  ///< 0x1bc [R]: Reserved Register
  volatile uint32_t WTM_ECC_CAL;  ///< 0x1c0 [R]: ECC Calculator Register
  volatile uint32_t WTM_ECC_STATUS;  ///< 0x1c4 [R]: ECC Status Register
  volatile uint32_t JTAG2SP_MBOX0;  ///< 0x1c8 [R]: JTAG to SP Mailbox (Instance 1 of 8)
  volatile uint32_t JTAG2SP_MBOX1;  ///< 0x1cc [R]: JTAG to SP Mailbox (Instance 2 of 8)
  volatile uint32_t JTAG2SP_MBOX2;  ///< 0x1d0 [R]: JTAG to SP Mailbox (Instance 3 of 8)
  volatile uint32_t JTAG2SP_MBOX3;  ///< 0x1d4 [R]: JTAG to SP Mailbox (Instance 4 of 8)
  volatile uint32_t JTAG2SP_MBOX4;  ///< 0x1d8 [R]: JTAG to SP Mailbox (Instance 5 of 8)
  volatile uint32_t JTAG2SP_MBOX5;  ///< 0x1dc [R]: JTAG to SP Mailbox (Instance 6 of 8)
  volatile uint32_t JTAG2SP_MBOX6;  ///< 0x1e0 [R]: JTAG to SP Mailbox (Instance 7 of 8)
  volatile uint32_t JTAG2SP_MBOX7;  ///< 0x1e4 [R]: JTAG to SP Mailbox (Instance 8 of 8)
  volatile uint32_t UID0;  ///< 0x1e8 [R]: UID  Register (Instance 1 of 2)
  volatile uint32_t UID1;  ///< 0x1ec [R]: UID  Register (Instance 2 of 2)
  volatile uint32_t Bank9_U0;  ///< 0x1f0 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 4)
  volatile uint32_t Bank9_U1;  ///< 0x1f4 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 4)
  volatile uint32_t Bank9_U2;  ///< 0x1f8 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 4)
  volatile uint32_t Bank9_U3;  ///< 0x1fc [R]: Soc Fuse Bank Num Read Register (Instance 4 of 4)
  volatile uint32_t reserved3;
  volatile uint32_t Bank100;  ///< 0x204 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank101;  ///< 0x208 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank102;  ///< 0x20c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank103;  ///< 0x210 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank104;  ///< 0x214 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank105;  ///< 0x218 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank106;  ///< 0x21c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank107;  ///< 0x220 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank110;  ///< 0x224 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank111;  ///< 0x228 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank112;  ///< 0x22c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank113;  ///< 0x230 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank114;  ///< 0x234 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank115;  ///< 0x238 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank116;  ///< 0x23c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank117;  ///< 0x240 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank120;  ///< 0x244 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank121;  ///< 0x248 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank122;  ///< 0x24c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank123;  ///< 0x250 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank124;  ///< 0x254 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank125;  ///< 0x258 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank126;  ///< 0x25c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank127;  ///< 0x260 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank130;  ///< 0x264 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank131;  ///< 0x268 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank132;  ///< 0x26c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank133;  ///< 0x270 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank134;  ///< 0x274 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank135;  ///< 0x278 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank136;  ///< 0x27c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank137;  ///< 0x280 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank140;  ///< 0x284 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank141;  ///< 0x288 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank142;  ///< 0x28c [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank143;  ///< 0x290 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank144;  ///< 0x294 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank145;  ///< 0x298 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank146;  ///< 0x29c [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank147;  ///< 0x2a0 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t Bank150;  ///< 0x2a4 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank151;  ///< 0x2a8 [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank152;  ///< 0x2ac [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank153;  ///< 0x2b0 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank154;  ///< 0x2b4 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank155;  ///< 0x2b8 [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank156;  ///< 0x2bc [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank157;  ///< 0x2c0 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
  volatile uint32_t WTM_ECC_STATUS1;  ///< 0x2c4 [R]: ECC Status Register
  volatile uint32_t reserved4[14];
  volatile uint32_t FuseTestStatus0;  ///< 0x300 [R/W]: Miscallaneous Security Register (Instance 1 of 16)
  volatile uint32_t FuseTestStatus1;  ///< 0x304 [R/W]: Miscallaneous Security Register (Instance 2 of 16)
  volatile uint32_t FuseTestStatus2;  ///< 0x308 [R/W]: Miscallaneous Security Register (Instance 3 of 16)
  volatile uint32_t FuseTestStatus3;  ///< 0x30c [R/W]: Miscallaneous Security Register (Instance 4 of 16)
  volatile uint32_t FuseTestStatus4;  ///< 0x310 [R/W]: Miscallaneous Security Register (Instance 5 of 16)
  volatile uint32_t FuseTestStatus5;  ///< 0x314 [R/W]: Miscallaneous Security Register (Instance 6 of 16)
  volatile uint32_t FuseTestStatus6;  ///< 0x318 [R/W]: Miscallaneous Security Register (Instance 7 of 16)
  volatile uint32_t FuseTestStatus7;  ///< 0x31c [R/W]: Miscallaneous Security Register (Instance 8 of 16)
  volatile uint32_t FuseTestStatus8;  ///< 0x320 [R/W]: Miscallaneous Security Register (Instance 9 of 16)
  volatile uint32_t FuseTestStatus9;  ///< 0x324 [R/W]: Miscallaneous Security Register (Instance 10 of 16)
  volatile uint32_t FuseTestStatus10;  ///< 0x328 [R/W]: Miscallaneous Security Register (Instance 11 of 16)
  volatile uint32_t FuseTestStatus11;  ///< 0x32c [R/W]: Miscallaneous Security Register (Instance 12 of 16)
  volatile uint32_t FuseTestStatus12;  ///< 0x330 [R/W]: Miscallaneous Security Register (Instance 13 of 16)
  volatile uint32_t FuseTestStatus13;  ///< 0x334 [R/W]: Miscallaneous Security Register (Instance 14 of 16)
  volatile uint32_t FuseTestStatus14;  ///< 0x338 [R/W]: Miscallaneous Security Register (Instance 15 of 16)
  volatile uint32_t FuseTestStatus15;  ///< 0x33c [R/W]: Miscallaneous Security Register (Instance 16 of 16)
  volatile uint32_t SEC_ENA_CTRL_2;  ///< 0x340 [R/W]: 
  volatile uint32_t JTAGAckPulse;  ///< 0x344 [W]: JTAG Interrupt Acknowledge
  volatile uint32_t IPS_secure;  ///< 0x348 [R/W]: IPS master Secure
  volatile uint32_t IPS_vio_clr;  ///< 0x34c [R/W]: IPS Master Violation Clear
  volatile uint32_t IPS_vio_mask;  ///< 0x350 [R/W]: IPS Master Violation Interrupt Mask
  volatile uint32_t IPS_vio_src;  ///< 0x354 [R]: IPS Master Violation Source
  volatile uint32_t Bank5_L0;  ///< 0x358 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 4)
  volatile uint32_t Bank5_L1;  ///< 0x35c [R]: Soc Fuse Bank Num Read Register (Instance 2 of 4)
  volatile uint32_t Bank5_L2;  ///< 0x360 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 4)
  volatile uint32_t Bank5_L3;  ///< 0x364 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 4)
  volatile uint32_t reserved5[6];
  volatile uint32_t Bank5_U0;  ///< 0x380 [R]: Soc Fuse Bank Num Read Register
  volatile uint32_t Bank5_U1;  ///< 0x384 [R]: Soc Fuse Bank Num Read Register
  volatile uint32_t Bank40;  ///< 0x388 [R]: Soc Fuse Bank Num Read Register (Instance 1 of 8)
  volatile uint32_t Bank41;  ///< 0x38c [R]: Soc Fuse Bank Num Read Register (Instance 2 of 8)
  volatile uint32_t Bank42;  ///< 0x390 [R]: Soc Fuse Bank Num Read Register (Instance 3 of 8)
  volatile uint32_t Bank43;  ///< 0x394 [R]: Soc Fuse Bank Num Read Register (Instance 4 of 8)
  volatile uint32_t Bank44;  ///< 0x398 [R]: Soc Fuse Bank Num Read Register (Instance 5 of 8)
  volatile uint32_t Bank45;  ///< 0x39c [R]: Soc Fuse Bank Num Read Register (Instance 6 of 8)
  volatile uint32_t Bank46;  ///< 0x3a0 [R]: Soc Fuse Bank Num Read Register (Instance 7 of 8)
  volatile uint32_t Bank47;  ///< 0x3a4 [R]: Soc Fuse Bank Num Read Register (Instance 8 of 8)
} BCMREG_REGS_t;

//====================================================================
//
//Register File: EGB Engine Control Registers (EBG)
//
//====================================================================

typedef struct EBG_REGS_s
{
  volatile uint32_t EBG_CTRL_REG;  ///< 0x0 [R/W]: EBG Control Register
  volatile uint32_t EBG_ENTROPY_VALUE_REG;  ///< 0x4 [R]: EBG Entropy Value Register
} EBG_REGS_t;

//====================================================================
//
//Register File: RCT Control Registers (RCTRL)
/** \brief This module contains registers that control the memory timing controls and the
debug monitor.*/
//
//====================================================================

typedef struct RCTRL_REGS_s
{
  volatile uint32_t MEM_CTRL_CORE;  ///< 0x0 [R/W]: Core Memory Timing Control
  volatile uint32_t WTM_MON_MOD_SEL;  ///< 0x4 [R/W]: WTM Monitor Module Select
  volatile uint32_t WTM_MON_SIG_SEL;  ///< 0x8 [R/W]: WtM Monitor Signal Select
  volatile uint32_t WTM_MONITOR;  ///< 0xc [R/W]: WTM Monitor
  volatile uint32_t MEM_CTRL_PROC;  ///< 0x10 [R/W]: Processor Memory Timing Control
  volatile uint32_t PWR_CTRL;  ///< 0x14 [R/W]: Power Control
} RCTRL_REGS_t;

//====================================================================
//
//Register File: APB Control Registers (APB)
/** \brief This module facilitates access to up to 4 separate APB buses. The particular APB
bus is selected via the APB_INTF register. Access to the selected bus is via the
APB_ACCESS register space, which direct accesses 128 32-bit words.*/
//
//====================================================================

typedef struct APB_REGS_s
{
  volatile uint32_t APB_ACCESS[128];  ///< 0x0 [R/W]: APB Access
  volatile uint32_t APB_BASE;  ///< 0x200 [R/W]: APB Base Address
  volatile uint32_t APB_INTF;  ///< 0x204 [R/W]: APB Interface Select
  volatile uint32_t APB_INT_STATUS;  ///< 0x208 [R/W]: APB Interrupt Status
  volatile uint32_t APB_INT_MASK;  ///< 0x20c [R/W]: APB Interrupt Mask
  volatile uint32_t APB_RST;  ///< 0x210 [R/W]: APB Reset
} APB_REGS_t;

#endif // BCM
