 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file BCM_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _BCM_REGMASKS_H_
#define _BCM_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: G2 BCM TOP LEVEL (BCM)
/** \brief G2 BCM Top Level Register Description*/
//
//====================================================================

//====================================================================
//
//Register File: BIU Registers (BIU)
/** \brief This describes the registers within the BIU design. The purpose of the BIU is to
act as the interface between the Cortex processor, the AXI interfaces, and the
accelerator engines.
The Cortex processor has access to all registers described here, with some
restrictions involving reading or writing, as noted within the register
descriptions.
The host has access to only a subset of the registers described. It can access
only the lowest 128 word locations. The highest address the host shall have
access to is byte address 10'h1FC. Note that while the is its addressable space,
not all registers within this space are implemented, and access to unimplemented
register space will generate address exceptions, along with all accesses outside
the 128 word space.
In general, all registers with a name starting with "SP_" are not accessible to
the host.*/
//
//====================================================================

//====================================================================
//Register: Command Parameter 0 (CMD_PARAM0)
/** \brief This register contains parameter 0 associated with a wtm primitive command.
There are a total of 16 spaces for primitive command parameters. When the
host wants to send a primitive command to the wtm, it must first write all
the associated parameters (if any). The host parameter writing must start
at CMD_PARAM0, and then work towards CMD_PARAM15. Once all the parameters
associated with a primitive command have been written, the host can write
the associated primitive command to the CMD register. There is no need to
write to all 16 parameter spaces, only the number associated with the
primitive command need to be written.*/
//====================================================================

#define  BIU_CMD_PARAM0_CMD_PARAM0_MASK 0xffffffff
#define  BIU_CMD_PARAM0_CMD_PARAM0_SHIFT 0
#define  BIU_CMD_PARAM0_CMD_PARAM0_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM0_CMD_PARAM0_MASK) >> BIU_CMD_PARAM0_CMD_PARAM0_SHIFT)
#define  BIU_CMD_PARAM0_CMD_PARAM0_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM0_CMD_PARAM0_MASK) | (((uint32_t)val) << BIU_CMD_PARAM0_CMD_PARAM0_SHIFT))

//====================================================================
//Register: Command Parameter 1 (CMD_PARAM1)
//====================================================================

#define  BIU_CMD_PARAM1_CMD_PARAM1_MASK 0xffffffff
#define  BIU_CMD_PARAM1_CMD_PARAM1_SHIFT 0
#define  BIU_CMD_PARAM1_CMD_PARAM1_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM1_CMD_PARAM1_MASK) >> BIU_CMD_PARAM1_CMD_PARAM1_SHIFT)
#define  BIU_CMD_PARAM1_CMD_PARAM1_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM1_CMD_PARAM1_MASK) | (((uint32_t)val) << BIU_CMD_PARAM1_CMD_PARAM1_SHIFT))

//====================================================================
//Register: Command Parameter 2 (CMD_PARAM2)
//====================================================================

#define  BIU_CMD_PARAM2_CMD_PARAM2_MASK 0xffffffff
#define  BIU_CMD_PARAM2_CMD_PARAM2_SHIFT 0
#define  BIU_CMD_PARAM2_CMD_PARAM2_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM2_CMD_PARAM2_MASK) >> BIU_CMD_PARAM2_CMD_PARAM2_SHIFT)
#define  BIU_CMD_PARAM2_CMD_PARAM2_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM2_CMD_PARAM2_MASK) | (((uint32_t)val) << BIU_CMD_PARAM2_CMD_PARAM2_SHIFT))

//====================================================================
//Register: Command Parameter 3 (CMD_PARAM3)
//====================================================================

#define  BIU_CMD_PARAM3_CMD_PARAM3_MASK 0xffffffff
#define  BIU_CMD_PARAM3_CMD_PARAM3_SHIFT 0
#define  BIU_CMD_PARAM3_CMD_PARAM3_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM3_CMD_PARAM3_MASK) >> BIU_CMD_PARAM3_CMD_PARAM3_SHIFT)
#define  BIU_CMD_PARAM3_CMD_PARAM3_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM3_CMD_PARAM3_MASK) | (((uint32_t)val) << BIU_CMD_PARAM3_CMD_PARAM3_SHIFT))

//====================================================================
//Register: Command Parameter 4 (CMD_PARAM4)
//====================================================================

#define  BIU_CMD_PARAM4_CMD_PARAM4_MASK 0xffffffff
#define  BIU_CMD_PARAM4_CMD_PARAM4_SHIFT 0
#define  BIU_CMD_PARAM4_CMD_PARAM4_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM4_CMD_PARAM4_MASK) >> BIU_CMD_PARAM4_CMD_PARAM4_SHIFT)
#define  BIU_CMD_PARAM4_CMD_PARAM4_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM4_CMD_PARAM4_MASK) | (((uint32_t)val) << BIU_CMD_PARAM4_CMD_PARAM4_SHIFT))

//====================================================================
//Register: Command Parameter 5 (CMD_PARAM5)
//====================================================================

#define  BIU_CMD_PARAM5_CMD_PARAM5_MASK 0xffffffff
#define  BIU_CMD_PARAM5_CMD_PARAM5_SHIFT 0
#define  BIU_CMD_PARAM5_CMD_PARAM5_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM5_CMD_PARAM5_MASK) >> BIU_CMD_PARAM5_CMD_PARAM5_SHIFT)
#define  BIU_CMD_PARAM5_CMD_PARAM5_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM5_CMD_PARAM5_MASK) | (((uint32_t)val) << BIU_CMD_PARAM5_CMD_PARAM5_SHIFT))

//====================================================================
//Register: Command Parameter 6 (CMD_PARAM6)
//====================================================================

#define  BIU_CMD_PARAM6_CMD_PARAM6_MASK 0xffffffff
#define  BIU_CMD_PARAM6_CMD_PARAM6_SHIFT 0
#define  BIU_CMD_PARAM6_CMD_PARAM6_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM6_CMD_PARAM6_MASK) >> BIU_CMD_PARAM6_CMD_PARAM6_SHIFT)
#define  BIU_CMD_PARAM6_CMD_PARAM6_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM6_CMD_PARAM6_MASK) | (((uint32_t)val) << BIU_CMD_PARAM6_CMD_PARAM6_SHIFT))

//====================================================================
//Register: Command Parameter 7 (CMD_PARAM7)
//====================================================================

#define  BIU_CMD_PARAM7_CMD_PARAM7_MASK 0xffffffff
#define  BIU_CMD_PARAM7_CMD_PARAM7_SHIFT 0
#define  BIU_CMD_PARAM7_CMD_PARAM7_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM7_CMD_PARAM7_MASK) >> BIU_CMD_PARAM7_CMD_PARAM7_SHIFT)
#define  BIU_CMD_PARAM7_CMD_PARAM7_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM7_CMD_PARAM7_MASK) | (((uint32_t)val) << BIU_CMD_PARAM7_CMD_PARAM7_SHIFT))

//====================================================================
//Register: Command Parameter 8 (CMD_PARAM8)
//====================================================================

#define  BIU_CMD_PARAM8_CMD_PARAM8_MASK 0xffffffff
#define  BIU_CMD_PARAM8_CMD_PARAM8_SHIFT 0
#define  BIU_CMD_PARAM8_CMD_PARAM8_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM8_CMD_PARAM8_MASK) >> BIU_CMD_PARAM8_CMD_PARAM8_SHIFT)
#define  BIU_CMD_PARAM8_CMD_PARAM8_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM8_CMD_PARAM8_MASK) | (((uint32_t)val) << BIU_CMD_PARAM8_CMD_PARAM8_SHIFT))

//====================================================================
//Register: Command Parameter 9 (CMD_PARAM9)
//====================================================================

#define  BIU_CMD_PARAM9_CMD_PARAM9_MASK 0xffffffff
#define  BIU_CMD_PARAM9_CMD_PARAM9_SHIFT 0
#define  BIU_CMD_PARAM9_CMD_PARAM9_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM9_CMD_PARAM9_MASK) >> BIU_CMD_PARAM9_CMD_PARAM9_SHIFT)
#define  BIU_CMD_PARAM9_CMD_PARAM9_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM9_CMD_PARAM9_MASK) | (((uint32_t)val) << BIU_CMD_PARAM9_CMD_PARAM9_SHIFT))

//====================================================================
//Register: Command Parameter 10 (CMD_PARAM10)
//====================================================================

#define  BIU_CMD_PARAM10_CMD_PARAM10_MASK 0xffffffff
#define  BIU_CMD_PARAM10_CMD_PARAM10_SHIFT 0
#define  BIU_CMD_PARAM10_CMD_PARAM10_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM10_CMD_PARAM10_MASK) >> BIU_CMD_PARAM10_CMD_PARAM10_SHIFT)
#define  BIU_CMD_PARAM10_CMD_PARAM10_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM10_CMD_PARAM10_MASK) | (((uint32_t)val) << BIU_CMD_PARAM10_CMD_PARAM10_SHIFT))

//====================================================================
//Register: Command Parameter 11 (CMD_PARAM11)
//====================================================================

#define  BIU_CMD_PARAM11_CMD_PARAM11_MASK 0xffffffff
#define  BIU_CMD_PARAM11_CMD_PARAM11_SHIFT 0
#define  BIU_CMD_PARAM11_CMD_PARAM11_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM11_CMD_PARAM11_MASK) >> BIU_CMD_PARAM11_CMD_PARAM11_SHIFT)
#define  BIU_CMD_PARAM11_CMD_PARAM11_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM11_CMD_PARAM11_MASK) | (((uint32_t)val) << BIU_CMD_PARAM11_CMD_PARAM11_SHIFT))

//====================================================================
//Register: Command Parameter 12 (CMD_PARAM12)
//====================================================================

#define  BIU_CMD_PARAM12_CMD_PARAM12_MASK 0xffffffff
#define  BIU_CMD_PARAM12_CMD_PARAM12_SHIFT 0
#define  BIU_CMD_PARAM12_CMD_PARAM12_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM12_CMD_PARAM12_MASK) >> BIU_CMD_PARAM12_CMD_PARAM12_SHIFT)
#define  BIU_CMD_PARAM12_CMD_PARAM12_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM12_CMD_PARAM12_MASK) | (((uint32_t)val) << BIU_CMD_PARAM12_CMD_PARAM12_SHIFT))

//====================================================================
//Register: Command Parameter 13 (CMD_PARAM13)
//====================================================================

#define  BIU_CMD_PARAM13_CMD_PARAM13_MASK 0xffffffff
#define  BIU_CMD_PARAM13_CMD_PARAM13_SHIFT 0
#define  BIU_CMD_PARAM13_CMD_PARAM13_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM13_CMD_PARAM13_MASK) >> BIU_CMD_PARAM13_CMD_PARAM13_SHIFT)
#define  BIU_CMD_PARAM13_CMD_PARAM13_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM13_CMD_PARAM13_MASK) | (((uint32_t)val) << BIU_CMD_PARAM13_CMD_PARAM13_SHIFT))

//====================================================================
//Register: Command Parameter 14 (CMD_PARAM14)
//====================================================================

#define  BIU_CMD_PARAM14_CMD_PARAM14_MASK 0xffffffff
#define  BIU_CMD_PARAM14_CMD_PARAM14_SHIFT 0
#define  BIU_CMD_PARAM14_CMD_PARAM14_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM14_CMD_PARAM14_MASK) >> BIU_CMD_PARAM14_CMD_PARAM14_SHIFT)
#define  BIU_CMD_PARAM14_CMD_PARAM14_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM14_CMD_PARAM14_MASK) | (((uint32_t)val) << BIU_CMD_PARAM14_CMD_PARAM14_SHIFT))

//====================================================================
//Register: Command Parameter 15 (CMD_PARAM15)
//====================================================================

#define  BIU_CMD_PARAM15_CMD_PARAM15_MASK 0xffffffff
#define  BIU_CMD_PARAM15_CMD_PARAM15_SHIFT 0
#define  BIU_CMD_PARAM15_CMD_PARAM15_MASK_SHIFT(reg) (((reg) & BIU_CMD_PARAM15_CMD_PARAM15_MASK) >> BIU_CMD_PARAM15_CMD_PARAM15_SHIFT)
#define  BIU_CMD_PARAM15_CMD_PARAM15_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_PARAM15_CMD_PARAM15_MASK) | (((uint32_t)val) << BIU_CMD_PARAM15_CMD_PARAM15_SHIFT))

//====================================================================
//Register: Secure Processor Command (CMD)
/** \brief The host writes this wtm primitive command to this register. When this
register is written, it indicates to the secure processor that all of the
associated primitive command parameters have been written to the parameter
address space.*/
//====================================================================

#define  BIU_CMD_RESERVED1_MASK 0xffff0000
#define  BIU_CMD_RESERVED1_SHIFT 16
#define  BIU_CMD_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_CMD_RESERVED1_MASK) >> BIU_CMD_RESERVED1_SHIFT)
#define  BIU_CMD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_RESERVED1_MASK) | (((uint32_t)val) << BIU_CMD_RESERVED1_SHIFT))

#define  BIU_CMD_CMD_MASK 0xffff
#define  BIU_CMD_CMD_SHIFT 0
#define  BIU_CMD_CMD_MASK_SHIFT(reg) (((reg) & BIU_CMD_CMD_MASK) >> BIU_CMD_CMD_SHIFT)
#define  BIU_CMD_CMD_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_CMD_MASK) | (((uint32_t)val) << BIU_CMD_CMD_SHIFT))

//====================================================================
//Register: Command Return Status (CMD_RET_STATUS)
/** \brief This indicates the return status of the PI.*/
//====================================================================

#define  BIU_CMD_RET_STATUS_CMD_RET_STATUS_MASK 0xffffffff
#define  BIU_CMD_RET_STATUS_CMD_RET_STATUS_SHIFT 0
#define  BIU_CMD_RET_STATUS_CMD_RET_STATUS_MASK_SHIFT(reg) (((reg) & BIU_CMD_RET_STATUS_CMD_RET_STATUS_MASK) >> BIU_CMD_RET_STATUS_CMD_RET_STATUS_SHIFT)
#define  BIU_CMD_RET_STATUS_CMD_RET_STATUS_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_RET_STATUS_CMD_RET_STATUS_MASK) | (((uint32_t)val) << BIU_CMD_RET_STATUS_CMD_RET_STATUS_SHIFT))

//====================================================================
//Register: Command Status 0 (CMD_STATUS0)
//====================================================================

#define  BIU_CMD_STATUS0_CMD_STATUS0_MASK 0xffffffff
#define  BIU_CMD_STATUS0_CMD_STATUS0_SHIFT 0
#define  BIU_CMD_STATUS0_CMD_STATUS0_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS0_CMD_STATUS0_MASK) >> BIU_CMD_STATUS0_CMD_STATUS0_SHIFT)
#define  BIU_CMD_STATUS0_CMD_STATUS0_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS0_CMD_STATUS0_MASK) | (((uint32_t)val) << BIU_CMD_STATUS0_CMD_STATUS0_SHIFT))

//====================================================================
//Register: Command Status 1 (CMD_STATUS1)
//====================================================================

#define  BIU_CMD_STATUS1_CMD_STATUS1_MASK 0xffffffff
#define  BIU_CMD_STATUS1_CMD_STATUS1_SHIFT 0
#define  BIU_CMD_STATUS1_CMD_STATUS1_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS1_CMD_STATUS1_MASK) >> BIU_CMD_STATUS1_CMD_STATUS1_SHIFT)
#define  BIU_CMD_STATUS1_CMD_STATUS1_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS1_CMD_STATUS1_MASK) | (((uint32_t)val) << BIU_CMD_STATUS1_CMD_STATUS1_SHIFT))

//====================================================================
//Register: Command Status 2 (CMD_STATUS2)
//====================================================================

#define  BIU_CMD_STATUS2_CMD_STATUS2_MASK 0xffffffff
#define  BIU_CMD_STATUS2_CMD_STATUS2_SHIFT 0
#define  BIU_CMD_STATUS2_CMD_STATUS2_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS2_CMD_STATUS2_MASK) >> BIU_CMD_STATUS2_CMD_STATUS2_SHIFT)
#define  BIU_CMD_STATUS2_CMD_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS2_CMD_STATUS2_MASK) | (((uint32_t)val) << BIU_CMD_STATUS2_CMD_STATUS2_SHIFT))

//====================================================================
//Register: Command Status 3 (CMD_STATUS3)
//====================================================================

#define  BIU_CMD_STATUS3_CMD_STATUS3_MASK 0xffffffff
#define  BIU_CMD_STATUS3_CMD_STATUS3_SHIFT 0
#define  BIU_CMD_STATUS3_CMD_STATUS3_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS3_CMD_STATUS3_MASK) >> BIU_CMD_STATUS3_CMD_STATUS3_SHIFT)
#define  BIU_CMD_STATUS3_CMD_STATUS3_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS3_CMD_STATUS3_MASK) | (((uint32_t)val) << BIU_CMD_STATUS3_CMD_STATUS3_SHIFT))

//====================================================================
//Register: Command Status 4 (CMD_STATUS4)
//====================================================================

#define  BIU_CMD_STATUS4_CMD_STATUS4_MASK 0xffffffff
#define  BIU_CMD_STATUS4_CMD_STATUS4_SHIFT 0
#define  BIU_CMD_STATUS4_CMD_STATUS4_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS4_CMD_STATUS4_MASK) >> BIU_CMD_STATUS4_CMD_STATUS4_SHIFT)
#define  BIU_CMD_STATUS4_CMD_STATUS4_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS4_CMD_STATUS4_MASK) | (((uint32_t)val) << BIU_CMD_STATUS4_CMD_STATUS4_SHIFT))

//====================================================================
//Register: Command Status 5 (CMD_STATUS5)
//====================================================================

#define  BIU_CMD_STATUS5_CMD_STATUS5_MASK 0xffffffff
#define  BIU_CMD_STATUS5_CMD_STATUS5_SHIFT 0
#define  BIU_CMD_STATUS5_CMD_STATUS5_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS5_CMD_STATUS5_MASK) >> BIU_CMD_STATUS5_CMD_STATUS5_SHIFT)
#define  BIU_CMD_STATUS5_CMD_STATUS5_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS5_CMD_STATUS5_MASK) | (((uint32_t)val) << BIU_CMD_STATUS5_CMD_STATUS5_SHIFT))

//====================================================================
//Register: Command Status 6 (CMD_STATUS6)
//====================================================================

#define  BIU_CMD_STATUS6_CMD_STATUS6_MASK 0xffffffff
#define  BIU_CMD_STATUS6_CMD_STATUS6_SHIFT 0
#define  BIU_CMD_STATUS6_CMD_STATUS6_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS6_CMD_STATUS6_MASK) >> BIU_CMD_STATUS6_CMD_STATUS6_SHIFT)
#define  BIU_CMD_STATUS6_CMD_STATUS6_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS6_CMD_STATUS6_MASK) | (((uint32_t)val) << BIU_CMD_STATUS6_CMD_STATUS6_SHIFT))

//====================================================================
//Register: Command Status 7 (CMD_STATUS7)
//====================================================================

#define  BIU_CMD_STATUS7_CMD_STATUS7_MASK 0xffffffff
#define  BIU_CMD_STATUS7_CMD_STATUS7_SHIFT 0
#define  BIU_CMD_STATUS7_CMD_STATUS7_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS7_CMD_STATUS7_MASK) >> BIU_CMD_STATUS7_CMD_STATUS7_SHIFT)
#define  BIU_CMD_STATUS7_CMD_STATUS7_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS7_CMD_STATUS7_MASK) | (((uint32_t)val) << BIU_CMD_STATUS7_CMD_STATUS7_SHIFT))

//====================================================================
//Register: Command Status 8 (CMD_STATUS8)
//====================================================================

#define  BIU_CMD_STATUS8_CMD_STATUS8_MASK 0xffffffff
#define  BIU_CMD_STATUS8_CMD_STATUS8_SHIFT 0
#define  BIU_CMD_STATUS8_CMD_STATUS8_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS8_CMD_STATUS8_MASK) >> BIU_CMD_STATUS8_CMD_STATUS8_SHIFT)
#define  BIU_CMD_STATUS8_CMD_STATUS8_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS8_CMD_STATUS8_MASK) | (((uint32_t)val) << BIU_CMD_STATUS8_CMD_STATUS8_SHIFT))

//====================================================================
//Register: Command Status 9 (CMD_STATUS9)
//====================================================================

#define  BIU_CMD_STATUS9_CMD_STATUS9_MASK 0xffffffff
#define  BIU_CMD_STATUS9_CMD_STATUS9_SHIFT 0
#define  BIU_CMD_STATUS9_CMD_STATUS9_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS9_CMD_STATUS9_MASK) >> BIU_CMD_STATUS9_CMD_STATUS9_SHIFT)
#define  BIU_CMD_STATUS9_CMD_STATUS9_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS9_CMD_STATUS9_MASK) | (((uint32_t)val) << BIU_CMD_STATUS9_CMD_STATUS9_SHIFT))

//====================================================================
//Register: Command Status 10 (CMD_STATUS10)
//====================================================================

#define  BIU_CMD_STATUS10_CMD_STATUS10_MASK 0xffffffff
#define  BIU_CMD_STATUS10_CMD_STATUS10_SHIFT 0
#define  BIU_CMD_STATUS10_CMD_STATUS10_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS10_CMD_STATUS10_MASK) >> BIU_CMD_STATUS10_CMD_STATUS10_SHIFT)
#define  BIU_CMD_STATUS10_CMD_STATUS10_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS10_CMD_STATUS10_MASK) | (((uint32_t)val) << BIU_CMD_STATUS10_CMD_STATUS10_SHIFT))

//====================================================================
//Register: Command Status 11 (CMD_STATUS11)
//====================================================================

#define  BIU_CMD_STATUS11_CMD_STATUS11_MASK 0xffffffff
#define  BIU_CMD_STATUS11_CMD_STATUS11_SHIFT 0
#define  BIU_CMD_STATUS11_CMD_STATUS11_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS11_CMD_STATUS11_MASK) >> BIU_CMD_STATUS11_CMD_STATUS11_SHIFT)
#define  BIU_CMD_STATUS11_CMD_STATUS11_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS11_CMD_STATUS11_MASK) | (((uint32_t)val) << BIU_CMD_STATUS11_CMD_STATUS11_SHIFT))

//====================================================================
//Register: Command Status 12 (CMD_STATUS12)
//====================================================================

#define  BIU_CMD_STATUS12_CMD_STATUS12_MASK 0xffffffff
#define  BIU_CMD_STATUS12_CMD_STATUS12_SHIFT 0
#define  BIU_CMD_STATUS12_CMD_STATUS12_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS12_CMD_STATUS12_MASK) >> BIU_CMD_STATUS12_CMD_STATUS12_SHIFT)
#define  BIU_CMD_STATUS12_CMD_STATUS12_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS12_CMD_STATUS12_MASK) | (((uint32_t)val) << BIU_CMD_STATUS12_CMD_STATUS12_SHIFT))

//====================================================================
//Register: Command Status 13 (CMD_STATUS13)
//====================================================================

#define  BIU_CMD_STATUS13_CMD_STATUS13_MASK 0xffffffff
#define  BIU_CMD_STATUS13_CMD_STATUS13_SHIFT 0
#define  BIU_CMD_STATUS13_CMD_STATUS13_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS13_CMD_STATUS13_MASK) >> BIU_CMD_STATUS13_CMD_STATUS13_SHIFT)
#define  BIU_CMD_STATUS13_CMD_STATUS13_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS13_CMD_STATUS13_MASK) | (((uint32_t)val) << BIU_CMD_STATUS13_CMD_STATUS13_SHIFT))

//====================================================================
//Register: Command Status 14 (CMD_STATUS14)
//====================================================================

#define  BIU_CMD_STATUS14_CMD_STATUS14_MASK 0xffffffff
#define  BIU_CMD_STATUS14_CMD_STATUS14_SHIFT 0
#define  BIU_CMD_STATUS14_CMD_STATUS14_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS14_CMD_STATUS14_MASK) >> BIU_CMD_STATUS14_CMD_STATUS14_SHIFT)
#define  BIU_CMD_STATUS14_CMD_STATUS14_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS14_CMD_STATUS14_MASK) | (((uint32_t)val) << BIU_CMD_STATUS14_CMD_STATUS14_SHIFT))

//====================================================================
//Register: Command Status 15 (CMD_STATUS15)
//====================================================================

#define  BIU_CMD_STATUS15_CMD_STATUS15_MASK 0xffffffff
#define  BIU_CMD_STATUS15_CMD_STATUS15_SHIFT 0
#define  BIU_CMD_STATUS15_CMD_STATUS15_MASK_SHIFT(reg) (((reg) & BIU_CMD_STATUS15_CMD_STATUS15_MASK) >> BIU_CMD_STATUS15_CMD_STATUS15_SHIFT)
#define  BIU_CMD_STATUS15_CMD_STATUS15_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_STATUS15_CMD_STATUS15_MASK) | (((uint32_t)val) << BIU_CMD_STATUS15_CMD_STATUS15_SHIFT))

//====================================================================
//Register: Command Fifo Status (CMD_FIFO_STATUS)
/** \brief This is the number of wtm primitive commands that are currently in the
command fifo. The current limit is 4 commands.*/
//====================================================================

#define  BIU_CMD_FIFO_STATUS_RESERVED1_MASK 0xffff0000
#define  BIU_CMD_FIFO_STATUS_RESERVED1_SHIFT 16
#define  BIU_CMD_FIFO_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_CMD_FIFO_STATUS_RESERVED1_MASK) >> BIU_CMD_FIFO_STATUS_RESERVED1_SHIFT)
#define  BIU_CMD_FIFO_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_FIFO_STATUS_RESERVED1_MASK) | (((uint32_t)val) << BIU_CMD_FIFO_STATUS_RESERVED1_SHIFT))

#define  BIU_CMD_FIFO_STATUS_CMD_STATUS_MASK 0xff00
#define  BIU_CMD_FIFO_STATUS_CMD_STATUS_SHIFT 8
#define  BIU_CMD_FIFO_STATUS_CMD_STATUS_MASK_SHIFT(reg) (((reg) & BIU_CMD_FIFO_STATUS_CMD_STATUS_MASK) >> BIU_CMD_FIFO_STATUS_CMD_STATUS_SHIFT)
#define  BIU_CMD_FIFO_STATUS_CMD_STATUS_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_FIFO_STATUS_CMD_STATUS_MASK) | (((uint32_t)val) << BIU_CMD_FIFO_STATUS_CMD_STATUS_SHIFT))

#define  BIU_CMD_FIFO_STATUS_RESERVED2_MASK 0xf8
#define  BIU_CMD_FIFO_STATUS_RESERVED2_SHIFT 3
#define  BIU_CMD_FIFO_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & BIU_CMD_FIFO_STATUS_RESERVED2_MASK) >> BIU_CMD_FIFO_STATUS_RESERVED2_SHIFT)
#define  BIU_CMD_FIFO_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_FIFO_STATUS_RESERVED2_MASK) | (((uint32_t)val) << BIU_CMD_FIFO_STATUS_RESERVED2_SHIFT))

#define  BIU_CMD_FIFO_STATUS_CMD_CNTR_MASK 0x7
#define  BIU_CMD_FIFO_STATUS_CMD_CNTR_SHIFT 0
#define  BIU_CMD_FIFO_STATUS_CMD_CNTR_MASK_SHIFT(reg) (((reg) & BIU_CMD_FIFO_STATUS_CMD_CNTR_MASK) >> BIU_CMD_FIFO_STATUS_CMD_CNTR_SHIFT)
#define  BIU_CMD_FIFO_STATUS_CMD_CNTR_REPLACE_VAL(reg,val) (((reg) & ~BIU_CMD_FIFO_STATUS_CMD_CNTR_MASK) | (((uint32_t)val) << BIU_CMD_FIFO_STATUS_CMD_CNTR_SHIFT))

//====================================================================
//Register: Host Interrupt Reset (HST_INTERRUPT_RST)
/** \brief To clear each bit, a '1' must be written to it.
>
See the HST_INTERRUPT_SET register for a description of each bit.
>
Note: that if the host is doing a non-secure read of the host interrupt
register, it must be from this location.*/
//====================================================================

#define  BIU_HST_INTERRUPT_RST_RESERVED1_MASK 0xfff80000
#define  BIU_HST_INTERRUPT_RST_RESERVED1_SHIFT 19
#define  BIU_HST_INTERRUPT_RST_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_RESERVED1_MASK) >> BIU_HST_INTERRUPT_RST_RESERVED1_SHIFT)
#define  BIU_HST_INTERRUPT_RST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_RESERVED1_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_RESERVED1_SHIFT))

#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_MASK 0x40000
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_SHIFT 18
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_MASK) >> BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_SHIFT)
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_SHIFT))

#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_MASK 0x20000
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_SHIFT 17
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_MASK) >> BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_SHIFT)
#define  BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_HST_QUEUE_FULL_ACCESS_SHIFT))

#define  BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_MASK 0x10000
#define  BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT 16
#define  BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_MASK) >> BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT)
#define  BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT))

#define  BIU_HST_INTERRUPT_RST_RESERVED2_MASK 0xfffe
#define  BIU_HST_INTERRUPT_RST_RESERVED2_SHIFT 1
#define  BIU_HST_INTERRUPT_RST_RESERVED2_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_RESERVED2_MASK) >> BIU_HST_INTERRUPT_RST_RESERVED2_SHIFT)
#define  BIU_HST_INTERRUPT_RST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_RESERVED2_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_RESERVED2_SHIFT))

#define  BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_MASK 0x1
#define  BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_SHIFT 0
#define  BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_MASK) >> BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_SHIFT)
#define  BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_RST_SP_CMD_CMPLT_SHIFT))

//====================================================================
//Register: Host Interrupt Mask (HST_INTERRUPT_MASK)
/** \brief Setting a bit to 1 will mask the generation of an interrupt to the host by
the associated bit in the INTERRUPT register.*/
//====================================================================

#define  BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_MASK 0xffffffff
#define  BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_SHIFT 0
#define  BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_MASK) >> BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_SHIFT)
#define  BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_MASK_HST_INTERRUPT_MASK_SHIFT))

//====================================================================
//Register: Host Exception Address (HST_EXCEPT_ADDR)
/** \brief If the host makes an access to a register to which it is not allowed, the
address will be stored within this register for the host to read out.*/
//====================================================================

#define  BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_MASK 0xffffffff
#define  BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_SHIFT 0
#define  BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_MASK_SHIFT(reg) (((reg) & BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_MASK) >> BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_SHIFT)
#define  BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_MASK) | (((uint32_t)val) << BIU_HST_EXCEPT_ADDR_HST_EXCEPT_ADDR_SHIFT))

//====================================================================
//Register: SP Trust Register (HST_TRUST)
/** \brief This register contains the wtm trust register.*/
//====================================================================

#define  BIU_HST_TRUST_HST_TRUST_MASK 0xffffffff
#define  BIU_HST_TRUST_HST_TRUST_SHIFT 0
#define  BIU_HST_TRUST_HST_TRUST_MASK_SHIFT(reg) (((reg) & BIU_HST_TRUST_HST_TRUST_MASK) >> BIU_HST_TRUST_HST_TRUST_SHIFT)
#define  BIU_HST_TRUST_HST_TRUST_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_TRUST_HST_TRUST_MASK) | (((uint32_t)val) << BIU_HST_TRUST_HST_TRUST_SHIFT))

//====================================================================
//Register: WTM Identification (WTM_ID)
/** \brief This is the identification number of the WTM. The value found here will
vary depending upon the project.*/
//====================================================================

#define  BIU_WTM_ID_WTM_ID_MASK 0xffffffff
#define  BIU_WTM_ID_WTM_ID_SHIFT 0
#define  BIU_WTM_ID_WTM_ID_MASK_SHIFT(reg) (((reg) & BIU_WTM_ID_WTM_ID_MASK) >> BIU_WTM_ID_WTM_ID_SHIFT)
#define  BIU_WTM_ID_WTM_ID_REPLACE_VAL(reg,val) (((reg) & ~BIU_WTM_ID_WTM_ID_MASK) | (((uint32_t)val) << BIU_WTM_ID_WTM_ID_SHIFT))

//====================================================================
//Register: WTM Revision (WTM_REV)
/** \brief This is the revision level of the WTM. The value found here will vary
depending upon the project.*/
//====================================================================

#define  BIU_WTM_REV_WTM_REV_MASK 0xffffffff
#define  BIU_WTM_REV_WTM_REV_SHIFT 0
#define  BIU_WTM_REV_WTM_REV_MASK_SHIFT(reg) (((reg) & BIU_WTM_REV_WTM_REV_MASK) >> BIU_WTM_REV_WTM_REV_SHIFT)
#define  BIU_WTM_REV_WTM_REV_REPLACE_VAL(reg,val) (((reg) & ~BIU_WTM_REV_WTM_REV_MASK) | (((uint32_t)val) << BIU_WTM_REV_WTM_REV_SHIFT))

//====================================================================
//Register: Context Status (CONTEXT_STATUS)
/** \brief Each bit indicates whether the associated context/key slot within the wtm
contains a valid context.*/
//====================================================================

#define  BIU_CONTEXT_STATUS_CONTEXT_STATUS_MASK 0xffffffff
#define  BIU_CONTEXT_STATUS_CONTEXT_STATUS_SHIFT 0
#define  BIU_CONTEXT_STATUS_CONTEXT_STATUS_MASK_SHIFT(reg) (((reg) & BIU_CONTEXT_STATUS_CONTEXT_STATUS_MASK) >> BIU_CONTEXT_STATUS_CONTEXT_STATUS_SHIFT)
#define  BIU_CONTEXT_STATUS_CONTEXT_STATUS_REPLACE_VAL(reg,val) (((reg) & ~BIU_CONTEXT_STATUS_CONTEXT_STATUS_MASK) | (((uint32_t)val) << BIU_CONTEXT_STATUS_CONTEXT_STATUS_SHIFT))

//====================================================================
//Register: SP Interrupt Set (SP_INTERRUPT_SET)
/** \brief Write a '1' to each bit position to set these interrupts.*/
//====================================================================

#define  BIU_SP_INTERRUPT_SET_RESERVED1_MASK 0xffffc000
#define  BIU_SP_INTERRUPT_SET_RESERVED1_SHIFT 14
#define  BIU_SP_INTERRUPT_SET_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_RESERVED1_MASK) >> BIU_SP_INTERRUPT_SET_RESERVED1_SHIFT)
#define  BIU_SP_INTERRUPT_SET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_RESERVED1_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_RESERVED1_SHIFT))

#define  BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_MASK 0x2000
#define  BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_SHIFT 13
#define  BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_MASK) >> BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_SHIFT)
#define  BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_SOC_SIDE_CHANNEL_SHIFT))

#define  BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_MASK 0x1000
#define  BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_SHIFT 12
#define  BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_MASK) >> BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_SHIFT)
#define  BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_SOC_PWR_MONITOR_SHIFT))

#define  BIU_SP_INTERRUPT_SET_ENG_SLVERR_MASK 0x800
#define  BIU_SP_INTERRUPT_SET_ENG_SLVERR_SHIFT 11
#define  BIU_SP_INTERRUPT_SET_ENG_SLVERR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_ENG_SLVERR_MASK) >> BIU_SP_INTERRUPT_SET_ENG_SLVERR_SHIFT)
#define  BIU_SP_INTERRUPT_SET_ENG_SLVERR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_ENG_SLVERR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_ENG_SLVERR_SHIFT))

#define  BIU_SP_INTERRUPT_SET_TRUST_REG_RD_MASK 0x400
#define  BIU_SP_INTERRUPT_SET_TRUST_REG_RD_SHIFT 10
#define  BIU_SP_INTERRUPT_SET_TRUST_REG_RD_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_TRUST_REG_RD_MASK) >> BIU_SP_INTERRUPT_SET_TRUST_REG_RD_SHIFT)
#define  BIU_SP_INTERRUPT_SET_TRUST_REG_RD_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_TRUST_REG_RD_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_TRUST_REG_RD_SHIFT))

#define  BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_MASK 0x200
#define  BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT 9
#define  BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_SET_RESERVED2_MASK 0x100
#define  BIU_SP_INTERRUPT_SET_RESERVED2_SHIFT 8
#define  BIU_SP_INTERRUPT_SET_RESERVED2_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_RESERVED2_MASK) >> BIU_SP_INTERRUPT_SET_RESERVED2_SHIFT)
#define  BIU_SP_INTERRUPT_SET_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_RESERVED2_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_RESERVED2_SHIFT))

#define  BIU_SP_INTERRUPT_SET_WTM_ID_ERR_MASK 0x80
#define  BIU_SP_INTERRUPT_SET_WTM_ID_ERR_SHIFT 7
#define  BIU_SP_INTERRUPT_SET_WTM_ID_ERR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_WTM_ID_ERR_MASK) >> BIU_SP_INTERRUPT_SET_WTM_ID_ERR_SHIFT)
#define  BIU_SP_INTERRUPT_SET_WTM_ID_ERR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_WTM_ID_ERR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_WTM_ID_ERR_SHIFT))

#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_MASK 0x40
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_SHIFT 6
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_MASK) >> BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_SHIFT)
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_MEMC_ERR_PAR_SHIFT))

#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_MASK 0x20
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_SHIFT 5
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_MASK) >> BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_SHIFT)
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_MEMC_ERR_DBE_SHIFT))

#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_MASK 0x10
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_SHIFT 4
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_MASK) >> BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_SHIFT)
#define  BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_MEMC_ERR_SBE_SHIFT))

#define  BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_MASK 0x8
#define  BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_SHIFT 3
#define  BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_MEMC_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_MASK 0x4
#define  BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_SHIFT 2
#define  BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_SYS_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_MASK 0x2
#define  BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_SHIFT 1
#define  BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_MASK) >> BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_SHIFT)
#define  BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_CMD_REG_OCCUPIED_SHIFT))

#define  BIU_SP_INTERRUPT_SET_ENG_INT_MASK 0x1
#define  BIU_SP_INTERRUPT_SET_ENG_INT_SHIFT 0
#define  BIU_SP_INTERRUPT_SET_ENG_INT_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_SET_ENG_INT_MASK) >> BIU_SP_INTERRUPT_SET_ENG_INT_SHIFT)
#define  BIU_SP_INTERRUPT_SET_ENG_INT_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_SET_ENG_INT_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_SET_ENG_INT_SHIFT))

//====================================================================
//Register: SP SRAM Control (SP_SRAM_CTRL)
//====================================================================

#define  BIU_SP_SRAM_CTRL_RESERVED1_MASK 0xfffffffe
#define  BIU_SP_SRAM_CTRL_RESERVED1_SHIFT 1
#define  BIU_SP_SRAM_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_SP_SRAM_CTRL_RESERVED1_MASK) >> BIU_SP_SRAM_CTRL_RESERVED1_SHIFT)
#define  BIU_SP_SRAM_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_SRAM_CTRL_RESERVED1_MASK) | (((uint32_t)val) << BIU_SP_SRAM_CTRL_RESERVED1_SHIFT))

#define  BIU_SP_SRAM_CTRL_MEMC_REMAP_MASK 0x1
#define  BIU_SP_SRAM_CTRL_MEMC_REMAP_SHIFT 0
#define  BIU_SP_SRAM_CTRL_MEMC_REMAP_MASK_SHIFT(reg) (((reg) & BIU_SP_SRAM_CTRL_MEMC_REMAP_MASK) >> BIU_SP_SRAM_CTRL_MEMC_REMAP_SHIFT)
#define  BIU_SP_SRAM_CTRL_MEMC_REMAP_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_SRAM_CTRL_MEMC_REMAP_MASK) | (((uint32_t)val) << BIU_SP_SRAM_CTRL_MEMC_REMAP_SHIFT))

//====================================================================
//Register: SP Interrupt Reset (SP_INTERRUPT_RST)
/** \brief Writing a '1' to each bit position in the register will reset the
interrupt.
For a description of each bit, see the SP_INTERRUPT_SET register.*/
//====================================================================

#define  BIU_SP_INTERRUPT_RST_RESERVED1_MASK 0xffffc000
#define  BIU_SP_INTERRUPT_RST_RESERVED1_SHIFT 14
#define  BIU_SP_INTERRUPT_RST_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_RESERVED1_MASK) >> BIU_SP_INTERRUPT_RST_RESERVED1_SHIFT)
#define  BIU_SP_INTERRUPT_RST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_RESERVED1_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_RESERVED1_SHIFT))

#define  BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_MASK 0x2000
#define  BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_SHIFT 13
#define  BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_MASK) >> BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_SHIFT)
#define  BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_SOC_SIDE_CHANNEL_SHIFT))

#define  BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_MASK 0x1000
#define  BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_SHIFT 12
#define  BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_MASK) >> BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_SHIFT)
#define  BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_SOC_PWR_MONITOR_SHIFT))

#define  BIU_SP_INTERRUPT_RST_ENG_SLVERR_MASK 0x800
#define  BIU_SP_INTERRUPT_RST_ENG_SLVERR_SHIFT 11
#define  BIU_SP_INTERRUPT_RST_ENG_SLVERR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_ENG_SLVERR_MASK) >> BIU_SP_INTERRUPT_RST_ENG_SLVERR_SHIFT)
#define  BIU_SP_INTERRUPT_RST_ENG_SLVERR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_ENG_SLVERR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_ENG_SLVERR_SHIFT))

#define  BIU_SP_INTERRUPT_RST_TRUST_REG_RD_MASK 0x400
#define  BIU_SP_INTERRUPT_RST_TRUST_REG_RD_SHIFT 10
#define  BIU_SP_INTERRUPT_RST_TRUST_REG_RD_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_TRUST_REG_RD_MASK) >> BIU_SP_INTERRUPT_RST_TRUST_REG_RD_SHIFT)
#define  BIU_SP_INTERRUPT_RST_TRUST_REG_RD_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_TRUST_REG_RD_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_TRUST_REG_RD_SHIFT))

#define  BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_MASK 0x200
#define  BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT 9
#define  BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_HST_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_RST_RESERVED2_MASK 0x100
#define  BIU_SP_INTERRUPT_RST_RESERVED2_SHIFT 8
#define  BIU_SP_INTERRUPT_RST_RESERVED2_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_RESERVED2_MASK) >> BIU_SP_INTERRUPT_RST_RESERVED2_SHIFT)
#define  BIU_SP_INTERRUPT_RST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_RESERVED2_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_RESERVED2_SHIFT))

#define  BIU_SP_INTERRUPT_RST_WTM_ID_ERR_MASK 0x80
#define  BIU_SP_INTERRUPT_RST_WTM_ID_ERR_SHIFT 7
#define  BIU_SP_INTERRUPT_RST_WTM_ID_ERR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_WTM_ID_ERR_MASK) >> BIU_SP_INTERRUPT_RST_WTM_ID_ERR_SHIFT)
#define  BIU_SP_INTERRUPT_RST_WTM_ID_ERR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_WTM_ID_ERR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_WTM_ID_ERR_SHIFT))

#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_MASK 0x40
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_SHIFT 6
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_MASK) >> BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_SHIFT)
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_MEMC_ERR_PAR_SHIFT))

#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_MASK 0x20
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_SHIFT 5
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_MASK) >> BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_SHIFT)
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_MEMC_ERR_DBE_SHIFT))

#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_MASK 0x10
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_SHIFT 4
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_MASK) >> BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_SHIFT)
#define  BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_MEMC_ERR_SBE_SHIFT))

#define  BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_MASK 0x8
#define  BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_SHIFT 3
#define  BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_MEMC_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_MASK 0x4
#define  BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_SHIFT 2
#define  BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_MASK) >> BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_SHIFT)
#define  BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_SYS_ADDR_RANGE_SHIFT))

#define  BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_MASK 0x2
#define  BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_SHIFT 1
#define  BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_MASK) >> BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_SHIFT)
#define  BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_CMD_REG_OCCUPIED_SHIFT))

#define  BIU_SP_INTERRUPT_RST_ENG_INT_MASK 0x1
#define  BIU_SP_INTERRUPT_RST_ENG_INT_SHIFT 0
#define  BIU_SP_INTERRUPT_RST_ENG_INT_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_RST_ENG_INT_MASK) >> BIU_SP_INTERRUPT_RST_ENG_INT_SHIFT)
#define  BIU_SP_INTERRUPT_RST_ENG_INT_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_RST_ENG_INT_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_RST_ENG_INT_SHIFT))

//====================================================================
//Register: SP Interrupt Mask (SP_INTERRUPT_MASK)
/** \brief When set to '1', each bit will mask the generation of the associated
interrupt to the secure processor.*/
//====================================================================

#define  BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_MASK 0xffffffff
#define  BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_SHIFT 0
#define  BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_MASK_SHIFT(reg) (((reg) & BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_MASK) >> BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_SHIFT)
#define  BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_MASK) | (((uint32_t)val) << BIU_SP_INTERRUPT_MASK_SP_INTERRUPT_MASK_SHIFT))

//====================================================================
//Register: SP Control (SP_CONTROL)
/** \brief This register is used by the secure processor to control various aspects of
the biu interface.*/
//====================================================================

#define  BIU_SP_CONTROL_RESERVED1_MASK 0xfffffff8
#define  BIU_SP_CONTROL_RESERVED1_SHIFT 3
#define  BIU_SP_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_SP_CONTROL_RESERVED1_MASK) >> BIU_SP_CONTROL_RESERVED1_SHIFT)
#define  BIU_SP_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << BIU_SP_CONTROL_RESERVED1_SHIFT))

#define  BIU_SP_CONTROL_MASK_SP_INT_MASK 0x4
#define  BIU_SP_CONTROL_MASK_SP_INT_SHIFT 2
#define  BIU_SP_CONTROL_MASK_SP_INT_MASK_SHIFT(reg) (((reg) & BIU_SP_CONTROL_MASK_SP_INT_MASK) >> BIU_SP_CONTROL_MASK_SP_INT_SHIFT)
#define  BIU_SP_CONTROL_MASK_SP_INT_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_CONTROL_MASK_SP_INT_MASK) | (((uint32_t)val) << BIU_SP_CONTROL_MASK_SP_INT_SHIFT))

#define  BIU_SP_CONTROL_SP_INT_TO_HST_MASK 0x2
#define  BIU_SP_CONTROL_SP_INT_TO_HST_SHIFT 1
#define  BIU_SP_CONTROL_SP_INT_TO_HST_MASK_SHIFT(reg) (((reg) & BIU_SP_CONTROL_SP_INT_TO_HST_MASK) >> BIU_SP_CONTROL_SP_INT_TO_HST_SHIFT)
#define  BIU_SP_CONTROL_SP_INT_TO_HST_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_CONTROL_SP_INT_TO_HST_MASK) | (((uint32_t)val) << BIU_SP_CONTROL_SP_INT_TO_HST_SHIFT))

#define  BIU_SP_CONTROL_CMD_REG_OCCUPIED_MASK 0x1
#define  BIU_SP_CONTROL_CMD_REG_OCCUPIED_SHIFT 0
#define  BIU_SP_CONTROL_CMD_REG_OCCUPIED_MASK_SHIFT(reg) (((reg) & BIU_SP_CONTROL_CMD_REG_OCCUPIED_MASK) >> BIU_SP_CONTROL_CMD_REG_OCCUPIED_SHIFT)
#define  BIU_SP_CONTROL_CMD_REG_OCCUPIED_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_CONTROL_CMD_REG_OCCUPIED_MASK) | (((uint32_t)val) << BIU_SP_CONTROL_CMD_REG_OCCUPIED_SHIFT))

//====================================================================
//Register: SP Exception Address (SP_EXCEPT_ADDR)
/** \brief If this secure processor makes an access to a register out of its range,
the address is stored here. The corresponding exception interrupt will
indicate which interface experienced the problem.*/
//====================================================================

#define  BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_MASK 0xffffffff
#define  BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_SHIFT 0
#define  BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_MASK_SHIFT(reg) (((reg) & BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_MASK) >> BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_SHIFT)
#define  BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_MASK) | (((uint32_t)val) << BIU_SP_EXCEPT_ADDR_SP_EXCEPT_ADDR_SHIFT))

//====================================================================
//Register: SP Exception Data (SP_EXCEPT_DATA)
/** \brief In the case of a parity error over one of the memory interfaces, the data
returned data will be saved here.*/
//====================================================================

#define  BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_MASK 0xffffffff
#define  BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_SHIFT 0
#define  BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_MASK_SHIFT(reg) (((reg) & BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_MASK) >> BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_SHIFT)
#define  BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_MASK) | (((uint32_t)val) << BIU_SP_EXCEPT_DATA_SP_EXCEPT_DATA_SHIFT))

//====================================================================
//Register: SP Exception Parity (SP_EXCEPT_PAR)
/** \brief In the case of a parity error over one of the memory interfaces, the
returned parity will be stored here.
- If the error is over the code memory interface, bit[3:0] will contain the
returned parity.
- If the error occurs when reading the irom, bit[7??:0] will contain the
syndrome.
??*/
//====================================================================

#define  BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_MASK 0xffffffff
#define  BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_SHIFT 0
#define  BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_MASK_SHIFT(reg) (((reg) & BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_MASK) >> BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_SHIFT)
#define  BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_MASK) | (((uint32_t)val) << BIU_SP_EXCEPT_PAR_SP_EXCEPT_PAR_SHIFT))

//====================================================================
//Register: Host Interrupt Set (HST_INTERRUPT_SET)
/** \brief Writing a '1' to each bit position in the register will set it. To reset
any bit, see the HST_INTERRUPT_RST register.
Note: that if the host wishes to read the host interrupt register with
a non-secure access, the read must be done from the HST_INTERRUPT_RST
register.*/
//====================================================================

#define  BIU_HST_INTERRUPT_SET_RESERVED1_MASK 0xfff80000
#define  BIU_HST_INTERRUPT_SET_RESERVED1_SHIFT 19
#define  BIU_HST_INTERRUPT_SET_RESERVED1_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_RESERVED1_MASK) >> BIU_HST_INTERRUPT_SET_RESERVED1_SHIFT)
#define  BIU_HST_INTERRUPT_SET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_RESERVED1_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_RESERVED1_SHIFT))

#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_MASK 0x40000
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_SHIFT 18
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_MASK) >> BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_SHIFT)
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_SHIFT))

#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_MASK 0x20000
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_SHIFT 17
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_MASK) >> BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_SHIFT)
#define  BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_HST_QUEUE_FULL_ACCESS_SHIFT))

#define  BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_MASK 0x10000
#define  BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT 16
#define  BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_MASK) >> BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT)
#define  BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_HST_ADDR_RANGE_SHIFT))

#define  BIU_HST_INTERRUPT_SET_RESERVED2_MASK 0xfffe
#define  BIU_HST_INTERRUPT_SET_RESERVED2_SHIFT 1
#define  BIU_HST_INTERRUPT_SET_RESERVED2_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_RESERVED2_MASK) >> BIU_HST_INTERRUPT_SET_RESERVED2_SHIFT)
#define  BIU_HST_INTERRUPT_SET_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_RESERVED2_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_RESERVED2_SHIFT))

#define  BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_MASK 0x1
#define  BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_SHIFT 0
#define  BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_MASK_SHIFT(reg) (((reg) & BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_MASK) >> BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_SHIFT)
#define  BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_REPLACE_VAL(reg,val) (((reg) & ~BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_MASK) | (((uint32_t)val) << BIU_HST_INTERRUPT_SET_SP_CMD_CMPLT_SHIFT))

//====================================================================
//Register: Trust Level (SP_TL)
/** \brief This is the trust level register. Using the Life Cycle Status, it is
calculated by the WTM firmware.*/
//====================================================================

#define  BIU_SP_TL_SP_TL_MASK 0xffffffff
#define  BIU_SP_TL_SP_TL_SHIFT 0
#define  BIU_SP_TL_SP_TL_MASK_SHIFT(reg) (((reg) & BIU_SP_TL_SP_TL_MASK) >> BIU_SP_TL_SP_TL_SHIFT)
#define  BIU_SP_TL_SP_TL_REPLACE_VAL(reg,val) (((reg) & ~BIU_SP_TL_SP_TL_MASK) | (((uint32_t)val) << BIU_SP_TL_SP_TL_SHIFT))

//====================================================================
//
//Register File: APB ADEC Registers (APB_ADEC)
//
//====================================================================

//====================================================================
//Register: Engine Control (ADEC_CTRL)
//====================================================================

#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_MASK 0x80000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_SHIFT 31
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG15_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_MASK 0x40000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_SHIFT 30
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG14_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_MASK 0x20000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_SHIFT 29
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG13_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_MASK 0x10000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_SHIFT 28
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG12_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_MASK 0x8000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_SHIFT 27
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG11_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_MASK 0x4000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_SHIFT 26
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG10_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_MASK 0x2000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_SHIFT 25
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG9_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_MASK 0x1000000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_SHIFT 24
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG8_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_MASK 0x800000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_SHIFT 23
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG7_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_MASK 0x400000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_SHIFT 22
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG6_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_MASK 0x200000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_SHIFT 21
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG5_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_MASK 0x100000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_SHIFT 20
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG4_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_MASK 0x80000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_SHIFT 19
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG3_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_MASK 0x40000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_SHIFT 18
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG2_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_MASK 0x20000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_SHIFT 17
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG1_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_MASK 0x10000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_SHIFT 16
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG0_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_MASK 0x8000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_SHIFT 15
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG15_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_MASK 0x4000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_SHIFT 14
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG14_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_MASK 0x2000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_SHIFT 13
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG13_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_MASK 0x1000
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_SHIFT 12
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG12_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_MASK 0x800
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_SHIFT 11
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG11_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_MASK 0x400
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_SHIFT 10
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG10_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_MASK 0x200
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_SHIFT 9
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG9_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_MASK 0x100
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_SHIFT 8
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG8_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_MASK 0x80
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_SHIFT 7
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG7_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_MASK 0x40
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_SHIFT 6
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG6_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_MASK 0x20
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_SHIFT 5
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG5_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_MASK 0x10
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_SHIFT 4
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG4_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_MASK 0x8
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_SHIFT 3
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG3_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_MASK 0x4
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_SHIFT 2
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG2_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_MASK 0x2
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_SHIFT 1
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG1_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_MASK 0x1
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_SHIFT 0
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_MASK) >> APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL_ACC_ENG0_RST_SHIFT))

//====================================================================
//Register: Engine Control 2 (ADEC_CTRL2)
//====================================================================

#define  APB_ADEC_ADEC_CTRL2_RESERVED1_MASK 0xffe00000
#define  APB_ADEC_ADEC_CTRL2_RESERVED1_SHIFT 21
#define  APB_ADEC_ADEC_CTRL2_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_RESERVED1_MASK) >> APB_ADEC_ADEC_CTRL2_RESERVED1_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_RESERVED1_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_RESERVED1_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_MASK 0x100000
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_SHIFT 20
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG20_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_MASK 0x80000
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_SHIFT 19
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG19_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_MASK 0x40000
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_SHIFT 18
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG18_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_MASK 0x20000
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_SHIFT 17
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG17_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_MASK 0x10000
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_SHIFT 16
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG16_CLK_EN_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_RESERVED2_MASK 0xffe0
#define  APB_ADEC_ADEC_CTRL2_RESERVED2_SHIFT 5
#define  APB_ADEC_ADEC_CTRL2_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_RESERVED2_MASK) >> APB_ADEC_ADEC_CTRL2_RESERVED2_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_RESERVED2_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_RESERVED2_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_MASK 0x10
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_SHIFT 4
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG20_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_MASK 0x8
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_SHIFT 3
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG19_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_MASK 0x4
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_SHIFT 2
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG18_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_MASK 0x2
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_SHIFT 1
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG17_RST_SHIFT))

#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_MASK 0x1
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_SHIFT 0
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_MASK) >> APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_SHIFT)
#define  APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_CTRL2_ACC_ENG16_RST_SHIFT))

//====================================================================
//Register: AXI Slave Control Register (AXI_SL_CTRL)
//====================================================================

#define  APB_ADEC_AXI_SL_CTRL_RESERVED1_MASK 0xffff0000
#define  APB_ADEC_AXI_SL_CTRL_RESERVED1_SHIFT 16
#define  APB_ADEC_AXI_SL_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_RESERVED1_MASK) >> APB_ADEC_AXI_SL_CTRL_RESERVED1_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_RESERVED1_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_RESERVED1_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_MASK 0x8000
#define  APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_SHIFT 15
#define  APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_MASK) >> APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AHB_WR_SEQ_ALLOW_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_MASK 0x7000
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_SHIFT 12
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_MASK) >> APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_PROT_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_RESERVED2_MASK 0x800
#define  APB_ADEC_AXI_SL_CTRL_RESERVED2_SHIFT 11
#define  APB_ADEC_AXI_SL_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_RESERVED2_MASK) >> APB_ADEC_AXI_SL_CTRL_RESERVED2_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_RESERVED2_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_RESERVED2_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_MASK 0x700
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_SHIFT 8
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_MASK) >> APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AXI_SL_WR_PROT_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_RESERVED3_MASK 0x80
#define  APB_ADEC_AXI_SL_CTRL_RESERVED3_SHIFT 7
#define  APB_ADEC_AXI_SL_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_RESERVED3_MASK) >> APB_ADEC_AXI_SL_CTRL_RESERVED3_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_RESERVED3_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_RESERVED3_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_MASK 0x40
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_SHIFT 6
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_MASK) >> APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AXI_SL_BYPASS_FIFO_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_MASK 0x20
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_SHIFT 5
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_MASK) >> APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AXI_SL_RD_QENA_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_MASK 0x10
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_SHIFT 4
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_MASK) >> APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_AXI_SL_BUS_SZ_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_MASK 0x8
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_SHIFT 3
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_MASK) >> APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_WORD_SWP_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_MASK 0x4
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_SHIFT 2
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_MASK) >> APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_OUT_AXI_SL_BYTE_SWP_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_MASK 0x2
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_SHIFT 1
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_MASK) >> APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_WORD_SWP_SHIFT))

#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_MASK 0x1
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_SHIFT 0
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_MASK_SHIFT(reg) (((reg) & APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_MASK) >> APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_SHIFT)
#define  APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_MASK) | (((uint32_t)val) << APB_ADEC_AXI_SL_CTRL_IN_AXI_SL_BYTE_SWP_SHIFT))

//====================================================================
//Register: Address Decoder Interrupt Register (ADEC_INT)
//====================================================================

#define  APB_ADEC_ADEC_INT_RESERVED1_MASK 0xf0000000
#define  APB_ADEC_ADEC_INT_RESERVED1_SHIFT 28
#define  APB_ADEC_ADEC_INT_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_RESERVED1_MASK) >> APB_ADEC_ADEC_INT_RESERVED1_SHIFT)
#define  APB_ADEC_ADEC_INT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_RESERVED1_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_RESERVED1_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG20_INT_MASK 0x8000000
#define  APB_ADEC_ADEC_INT_ACC_ENG20_INT_SHIFT 27
#define  APB_ADEC_ADEC_INT_ACC_ENG20_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG20_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG20_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG20_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG20_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG20_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG19_INT_MASK 0x4000000
#define  APB_ADEC_ADEC_INT_ACC_ENG19_INT_SHIFT 26
#define  APB_ADEC_ADEC_INT_ACC_ENG19_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG19_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG19_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG19_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG19_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG19_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG18_INT_MASK 0x2000000
#define  APB_ADEC_ADEC_INT_ACC_ENG18_INT_SHIFT 25
#define  APB_ADEC_ADEC_INT_ACC_ENG18_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG18_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG18_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG18_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG18_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG18_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG17_INT_MASK 0x1000000
#define  APB_ADEC_ADEC_INT_ACC_ENG17_INT_SHIFT 24
#define  APB_ADEC_ADEC_INT_ACC_ENG17_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG17_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG17_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG17_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG17_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG17_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG16_INT_MASK 0x800000
#define  APB_ADEC_ADEC_INT_ACC_ENG16_INT_SHIFT 23
#define  APB_ADEC_ADEC_INT_ACC_ENG16_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG16_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG16_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG16_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG16_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG16_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG15_INT_MASK 0x400000
#define  APB_ADEC_ADEC_INT_ACC_ENG15_INT_SHIFT 22
#define  APB_ADEC_ADEC_INT_ACC_ENG15_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG15_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG15_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG15_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG15_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG15_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG14_INT_MASK 0x200000
#define  APB_ADEC_ADEC_INT_ACC_ENG14_INT_SHIFT 21
#define  APB_ADEC_ADEC_INT_ACC_ENG14_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG14_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG14_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG14_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG14_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG14_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG13_INT_MASK 0x100000
#define  APB_ADEC_ADEC_INT_ACC_ENG13_INT_SHIFT 20
#define  APB_ADEC_ADEC_INT_ACC_ENG13_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG13_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG13_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG13_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG13_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG13_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG12_INT_MASK 0x80000
#define  APB_ADEC_ADEC_INT_ACC_ENG12_INT_SHIFT 19
#define  APB_ADEC_ADEC_INT_ACC_ENG12_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG12_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG12_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG12_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG12_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG12_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG11_INT_MASK 0x40000
#define  APB_ADEC_ADEC_INT_ACC_ENG11_INT_SHIFT 18
#define  APB_ADEC_ADEC_INT_ACC_ENG11_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG11_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG11_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG11_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG11_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG11_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_USER_INT3_MASK 0x20000
#define  APB_ADEC_ADEC_INT_USER_INT3_SHIFT 17
#define  APB_ADEC_ADEC_INT_USER_INT3_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_USER_INT3_MASK) >> APB_ADEC_ADEC_INT_USER_INT3_SHIFT)
#define  APB_ADEC_ADEC_INT_USER_INT3_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_USER_INT3_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_USER_INT3_SHIFT))

#define  APB_ADEC_ADEC_INT_USER_INT2_MASK 0x10000
#define  APB_ADEC_ADEC_INT_USER_INT2_SHIFT 16
#define  APB_ADEC_ADEC_INT_USER_INT2_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_USER_INT2_MASK) >> APB_ADEC_ADEC_INT_USER_INT2_SHIFT)
#define  APB_ADEC_ADEC_INT_USER_INT2_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_USER_INT2_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_USER_INT2_SHIFT))

#define  APB_ADEC_ADEC_INT_USER_INT1_MASK 0x8000
#define  APB_ADEC_ADEC_INT_USER_INT1_SHIFT 15
#define  APB_ADEC_ADEC_INT_USER_INT1_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_USER_INT1_MASK) >> APB_ADEC_ADEC_INT_USER_INT1_SHIFT)
#define  APB_ADEC_ADEC_INT_USER_INT1_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_USER_INT1_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_USER_INT1_SHIFT))

#define  APB_ADEC_ADEC_INT_USER_INT0_MASK 0x4000
#define  APB_ADEC_ADEC_INT_USER_INT0_SHIFT 14
#define  APB_ADEC_ADEC_INT_USER_INT0_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_USER_INT0_MASK) >> APB_ADEC_ADEC_INT_USER_INT0_SHIFT)
#define  APB_ADEC_ADEC_INT_USER_INT0_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_USER_INT0_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_USER_INT0_SHIFT))

#define  APB_ADEC_ADEC_INT_APB_ACC_ERR_MASK 0x2000
#define  APB_ADEC_ADEC_INT_APB_ACC_ERR_SHIFT 13
#define  APB_ADEC_ADEC_INT_APB_ACC_ERR_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_APB_ACC_ERR_MASK) >> APB_ADEC_ADEC_INT_APB_ACC_ERR_SHIFT)
#define  APB_ADEC_ADEC_INT_APB_ACC_ERR_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_APB_ACC_ERR_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_APB_ACC_ERR_SHIFT))

#define  APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_MASK 0x1000
#define  APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_SHIFT 12
#define  APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_MASK) >> APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_SHIFT)
#define  APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_AXI_SL_BUS_ERR_SHIFT))

#define  APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_MASK 0x800
#define  APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_SHIFT 11
#define  APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_MASK) >> APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_SHIFT)
#define  APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_AXI_SL_APB_ERR_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG10_INT_MASK 0x400
#define  APB_ADEC_ADEC_INT_ACC_ENG10_INT_SHIFT 10
#define  APB_ADEC_ADEC_INT_ACC_ENG10_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG10_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG10_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG10_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG10_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG10_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG9_INT_MASK 0x200
#define  APB_ADEC_ADEC_INT_ACC_ENG9_INT_SHIFT 9
#define  APB_ADEC_ADEC_INT_ACC_ENG9_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG9_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG9_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG9_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG9_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG9_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG8_INT_MASK 0x100
#define  APB_ADEC_ADEC_INT_ACC_ENG8_INT_SHIFT 8
#define  APB_ADEC_ADEC_INT_ACC_ENG8_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG8_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG8_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG8_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG8_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG8_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG7_INT_MASK 0x80
#define  APB_ADEC_ADEC_INT_ACC_ENG7_INT_SHIFT 7
#define  APB_ADEC_ADEC_INT_ACC_ENG7_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG7_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG7_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG7_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG7_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG7_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG6_INT_MASK 0x40
#define  APB_ADEC_ADEC_INT_ACC_ENG6_INT_SHIFT 6
#define  APB_ADEC_ADEC_INT_ACC_ENG6_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG6_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG6_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG6_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG6_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG6_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG5_INT_MASK 0x20
#define  APB_ADEC_ADEC_INT_ACC_ENG5_INT_SHIFT 5
#define  APB_ADEC_ADEC_INT_ACC_ENG5_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG5_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG5_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG5_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG5_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG5_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG4_INT_MASK 0x10
#define  APB_ADEC_ADEC_INT_ACC_ENG4_INT_SHIFT 4
#define  APB_ADEC_ADEC_INT_ACC_ENG4_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG4_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG4_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG4_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG4_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG4_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG3_INT_MASK 0x8
#define  APB_ADEC_ADEC_INT_ACC_ENG3_INT_SHIFT 3
#define  APB_ADEC_ADEC_INT_ACC_ENG3_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG3_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG3_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG3_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG3_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG3_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG2_INT_MASK 0x4
#define  APB_ADEC_ADEC_INT_ACC_ENG2_INT_SHIFT 2
#define  APB_ADEC_ADEC_INT_ACC_ENG2_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG2_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG2_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG2_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG2_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG2_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG1_INT_MASK 0x2
#define  APB_ADEC_ADEC_INT_ACC_ENG1_INT_SHIFT 1
#define  APB_ADEC_ADEC_INT_ACC_ENG1_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG1_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG1_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG1_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG1_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG1_INT_SHIFT))

#define  APB_ADEC_ADEC_INT_ACC_ENG0_INT_MASK 0x1
#define  APB_ADEC_ADEC_INT_ACC_ENG0_INT_SHIFT 0
#define  APB_ADEC_ADEC_INT_ACC_ENG0_INT_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_ACC_ENG0_INT_MASK) >> APB_ADEC_ADEC_INT_ACC_ENG0_INT_SHIFT)
#define  APB_ADEC_ADEC_INT_ACC_ENG0_INT_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_ACC_ENG0_INT_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_ACC_ENG0_INT_SHIFT))

//====================================================================
//Register: Address Decoder Interrupt Mask (ADEC_INT_MSK)
/** \brief Masks for the associated interrupts in register ADEC_INT.*/
//====================================================================

#define  APB_ADEC_ADEC_INT_MSK_RESERVED1_MASK 0xf0000000
#define  APB_ADEC_ADEC_INT_MSK_RESERVED1_SHIFT 28
#define  APB_ADEC_ADEC_INT_MSK_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_RESERVED1_MASK) >> APB_ADEC_ADEC_INT_MSK_RESERVED1_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_RESERVED1_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_RESERVED1_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_MASK 0x8000000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_SHIFT 27
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG20_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_MASK 0x4000000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_SHIFT 26
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG19_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_MASK 0x2000000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_SHIFT 25
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG18_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_MASK 0x1000000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_SHIFT 24
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG17_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_MASK 0x800000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_SHIFT 23
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG16_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_MASK 0x400000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_SHIFT 22
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG15_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_MASK 0x200000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_SHIFT 21
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG14_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_MASK 0x100000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_SHIFT 20
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG13_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_MASK 0x80000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_SHIFT 19
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG12_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_MASK 0x40000
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_SHIFT 18
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG11_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_MASK 0x20000
#define  APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_SHIFT 17
#define  APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_USER_INT3_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_MASK 0x10000
#define  APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_SHIFT 16
#define  APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_USER_INT2_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_MASK 0x8000
#define  APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_SHIFT 15
#define  APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_USER_INT1_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_MASK 0x4000
#define  APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_SHIFT 14
#define  APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_USER_INT0_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_MASK 0x2000
#define  APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_SHIFT 13
#define  APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_APB_ACC_ERR_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_MASK 0x1000
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_SHIFT 12
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_AXI_SL_BUS_ERR_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_MASK 0x800
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_SHIFT 11
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_AXI_SL_APB_ERR_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_MASK 0x400
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_SHIFT 10
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG10_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_MASK 0x200
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_SHIFT 9
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG9_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_MASK 0x100
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_SHIFT 8
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG8_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_MASK 0x80
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_SHIFT 7
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG7_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_MASK 0x40
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_SHIFT 6
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG6_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_MASK 0x20
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_SHIFT 5
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG5_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_MASK 0x10
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_SHIFT 4
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG4_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_MASK 0x8
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_SHIFT 3
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG3_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_MASK 0x4
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_SHIFT 2
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG2_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_MASK 0x2
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_SHIFT 1
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG1_INT_MSK_SHIFT))

#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_MASK 0x1
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_SHIFT 0
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_MASK_SHIFT(reg) (((reg) & APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_MASK) >> APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_SHIFT)
#define  APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_MASK) | (((uint32_t)val) << APB_ADEC_ADEC_INT_MSK_ACC_ENG0_INT_MSK_SHIFT))

//====================================================================
//Register: APB Access Error Address Register (ACC_ERR_ADR)
/** \brief This address register is used for debug purposes. It stores the 19 bit base
address in term of word of the APB bus when the first bus exception occurs.*/
//====================================================================

#define  APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_MASK 0xffffffff
#define  APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_SHIFT 0
#define  APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_MASK_SHIFT(reg) (((reg) & APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_MASK) >> APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_SHIFT)
#define  APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_MASK) | (((uint32_t)val) << APB_ADEC_ACC_ERR_ADR_ACC_ERR_ADR_SHIFT))

//====================================================================
//Register: MP FIFO Error Read Pointer (MP_FIFO_ERR_ADR)
/** \brief This address register is used for debug purposes. It stores the 4 bit FIFO read
pointer when the FIFO Read Data parity occurs.*/
//====================================================================

#define  APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_MASK 0xffffffff
#define  APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_SHIFT 0
#define  APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_MASK_SHIFT(reg) (((reg) & APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_MASK) >> APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_SHIFT)
#define  APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_REPLACE_VAL(reg,val) (((reg) & ~APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_MASK) | (((uint32_t)val) << APB_ADEC_MP_FIFO_ERR_ADR_MP_FIFO_ERR_ADR_SHIFT))

//====================================================================
//
//Register File: AXI Master Control Registers (DMA)
//
//====================================================================

//====================================================================
//Register: Input DMA Control Register (IN_DMA_CTRL)
//====================================================================

#define  DMA_IN_DMA_CTRL_RESERVED1_MASK 0x80000000
#define  DMA_IN_DMA_CTRL_RESERVED1_SHIFT 31
#define  DMA_IN_DMA_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_RESERVED1_MASK) >> DMA_IN_DMA_CTRL_RESERVED1_SHIFT)
#define  DMA_IN_DMA_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_RESERVED1_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_MASK 0x40000000
#define  DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_SHIFT 30
#define  DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_MASK) >> DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_DIS_REC_ERR_CODE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_MASK 0x20000000
#define  DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_SHIFT 29
#define  DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_MASK) >> DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_DIS_LL_ERR_CODE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_MASK 0x10000000
#define  DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_SHIFT 28
#define  DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_MASK) >> DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_DIS_ERR_CODE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_CACHE_MODE_MASK 0xf000000
#define  DMA_IN_DMA_CTRL_IN_CACHE_MODE_SHIFT 24
#define  DMA_IN_DMA_CTRL_IN_CACHE_MODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_CACHE_MODE_MASK) >> DMA_IN_DMA_CTRL_IN_CACHE_MODE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_CACHE_MODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_CACHE_MODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_CACHE_MODE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_RID_EXT_MASK 0xf00000
#define  DMA_IN_DMA_CTRL_IN_RID_EXT_SHIFT 20
#define  DMA_IN_DMA_CTRL_IN_RID_EXT_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_RID_EXT_MASK) >> DMA_IN_DMA_CTRL_IN_RID_EXT_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_RID_EXT_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_RID_EXT_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_RID_EXT_SHIFT))

#define  DMA_IN_DMA_CTRL_RESERVED2_MASK 0x80000
#define  DMA_IN_DMA_CTRL_RESERVED2_SHIFT 19
#define  DMA_IN_DMA_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_RESERVED2_MASK) >> DMA_IN_DMA_CTRL_RESERVED2_SHIFT)
#define  DMA_IN_DMA_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_RESERVED2_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_ORDER_DIS_MASK 0x40000
#define  DMA_IN_DMA_CTRL_IN_ORDER_DIS_SHIFT 18
#define  DMA_IN_DMA_CTRL_IN_ORDER_DIS_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_ORDER_DIS_MASK) >> DMA_IN_DMA_CTRL_IN_ORDER_DIS_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_ORDER_DIS_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_ORDER_DIS_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_ORDER_DIS_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_REQ_ALGN64_MASK 0x20000
#define  DMA_IN_DMA_CTRL_IN_REQ_ALGN64_SHIFT 17
#define  DMA_IN_DMA_CTRL_IN_REQ_ALGN64_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_REQ_ALGN64_MASK) >> DMA_IN_DMA_CTRL_IN_REQ_ALGN64_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_REQ_ALGN64_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_REQ_ALGN64_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_REQ_ALGN64_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_REQ_PAUSE_MASK 0x10000
#define  DMA_IN_DMA_CTRL_IN_REQ_PAUSE_SHIFT 16
#define  DMA_IN_DMA_CTRL_IN_REQ_PAUSE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_REQ_PAUSE_MASK) >> DMA_IN_DMA_CTRL_IN_REQ_PAUSE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_REQ_PAUSE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_REQ_PAUSE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_REQ_PAUSE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_BUS_SZ_MASK 0x8000
#define  DMA_IN_DMA_CTRL_IN_BUS_SZ_SHIFT 15
#define  DMA_IN_DMA_CTRL_IN_BUS_SZ_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_BUS_SZ_MASK) >> DMA_IN_DMA_CTRL_IN_BUS_SZ_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_BUS_SZ_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_BUS_SZ_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_BUS_SZ_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_BURST_TYPE_MASK 0x6000
#define  DMA_IN_DMA_CTRL_IN_BURST_TYPE_SHIFT 13
#define  DMA_IN_DMA_CTRL_IN_BURST_TYPE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_BURST_TYPE_MASK) >> DMA_IN_DMA_CTRL_IN_BURST_TYPE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_BURST_TYPE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_BURST_TYPE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_BURST_TYPE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_BURST_LEN_MASK 0x1f00
#define  DMA_IN_DMA_CTRL_IN_BURST_LEN_SHIFT 8
#define  DMA_IN_DMA_CTRL_IN_BURST_LEN_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_BURST_LEN_MASK) >> DMA_IN_DMA_CTRL_IN_BURST_LEN_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_BURST_LEN_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_BURST_LEN_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_RID_MASK 0xf0
#define  DMA_IN_DMA_CTRL_IN_RID_SHIFT 4
#define  DMA_IN_DMA_CTRL_IN_RID_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_RID_MASK) >> DMA_IN_DMA_CTRL_IN_RID_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_RID_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_RID_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_RID_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_PROT_MODE_MASK 0xe
#define  DMA_IN_DMA_CTRL_IN_PROT_MODE_SHIFT 1
#define  DMA_IN_DMA_CTRL_IN_PROT_MODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_PROT_MODE_MASK) >> DMA_IN_DMA_CTRL_IN_PROT_MODE_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_PROT_MODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_PROT_MODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_PROT_MODE_SHIFT))

#define  DMA_IN_DMA_CTRL_IN_DMA_ENA_MASK 0x1
#define  DMA_IN_DMA_CTRL_IN_DMA_ENA_SHIFT 0
#define  DMA_IN_DMA_CTRL_IN_DMA_ENA_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_CTRL_IN_DMA_ENA_MASK) >> DMA_IN_DMA_CTRL_IN_DMA_ENA_SHIFT)
#define  DMA_IN_DMA_CTRL_IN_DMA_ENA_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_CTRL_IN_DMA_ENA_MASK) | (((uint32_t)val) << DMA_IN_DMA_CTRL_IN_DMA_ENA_SHIFT))

//====================================================================
//Register: Input DMA Status Register (IN_DMA_STATUS)
//====================================================================

#define  DMA_IN_DMA_STATUS_RESERVED1_MASK 0xffffff80
#define  DMA_IN_DMA_STATUS_RESERVED1_SHIFT 7
#define  DMA_IN_DMA_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_RESERVED1_MASK) >> DMA_IN_DMA_STATUS_RESERVED1_SHIFT)
#define  DMA_IN_DMA_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_RESERVED1_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_RESERVED1_SHIFT))

#define  DMA_IN_DMA_STATUS_READ_PENDING_MASK 0x40
#define  DMA_IN_DMA_STATUS_READ_PENDING_SHIFT 6
#define  DMA_IN_DMA_STATUS_READ_PENDING_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_READ_PENDING_MASK) >> DMA_IN_DMA_STATUS_READ_PENDING_SHIFT)
#define  DMA_IN_DMA_STATUS_READ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_READ_PENDING_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_READ_PENDING_SHIFT))

#define  DMA_IN_DMA_STATUS_PAUSE_CMPL_MASK 0x20
#define  DMA_IN_DMA_STATUS_PAUSE_CMPL_SHIFT 5
#define  DMA_IN_DMA_STATUS_PAUSE_CMPL_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_PAUSE_CMPL_MASK) >> DMA_IN_DMA_STATUS_PAUSE_CMPL_SHIFT)
#define  DMA_IN_DMA_STATUS_PAUSE_CMPL_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_PAUSE_CMPL_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_PAUSE_CMPL_SHIFT))

#define  DMA_IN_DMA_STATUS_LL_ERR_CODE_MASK 0x18
#define  DMA_IN_DMA_STATUS_LL_ERR_CODE_SHIFT 3
#define  DMA_IN_DMA_STATUS_LL_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_LL_ERR_CODE_MASK) >> DMA_IN_DMA_STATUS_LL_ERR_CODE_SHIFT)
#define  DMA_IN_DMA_STATUS_LL_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_LL_ERR_CODE_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_LL_ERR_CODE_SHIFT))

#define  DMA_IN_DMA_STATUS_PAR_ERR_MASK 0x4
#define  DMA_IN_DMA_STATUS_PAR_ERR_SHIFT 2
#define  DMA_IN_DMA_STATUS_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_PAR_ERR_MASK) >> DMA_IN_DMA_STATUS_PAR_ERR_SHIFT)
#define  DMA_IN_DMA_STATUS_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_PAR_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_PAR_ERR_SHIFT))

#define  DMA_IN_DMA_STATUS_RD_CYCLE_ERR_MASK 0x3
#define  DMA_IN_DMA_STATUS_RD_CYCLE_ERR_SHIFT 0
#define  DMA_IN_DMA_STATUS_RD_CYCLE_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_STATUS_RD_CYCLE_ERR_MASK) >> DMA_IN_DMA_STATUS_RD_CYCLE_ERR_SHIFT)
#define  DMA_IN_DMA_STATUS_RD_CYCLE_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_STATUS_RD_CYCLE_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_STATUS_RD_CYCLE_ERR_SHIFT))

//====================================================================
//Register: DMA Source Address (IN_SRC_ADR)
/** \brief This Source Address register contains the 32 bit address of the source data.
Each time a 32 bit word is accessed from the memory, the address is incremented
by four.*/
//====================================================================

#define  DMA_IN_SRC_ADR_IN_SRC_ADR_MASK 0xffffffff
#define  DMA_IN_SRC_ADR_IN_SRC_ADR_SHIFT 0
#define  DMA_IN_SRC_ADR_IN_SRC_ADR_MASK_SHIFT(reg) (((reg) & DMA_IN_SRC_ADR_IN_SRC_ADR_MASK) >> DMA_IN_SRC_ADR_IN_SRC_ADR_SHIFT)
#define  DMA_IN_SRC_ADR_IN_SRC_ADR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_SRC_ADR_IN_SRC_ADR_MASK) | (((uint32_t)val) << DMA_IN_SRC_ADR_IN_SRC_ADR_SHIFT))

//====================================================================
//Register: DMA Input Transfer Counter (IN_XFER_CNTR)
/** \brief >
This counter keeps track of the total input transfer count in term of 32 bit
word.*/
//====================================================================

#define  DMA_IN_XFER_CNTR_RESERVED1_MASK 0xf0000000
#define  DMA_IN_XFER_CNTR_RESERVED1_SHIFT 28
#define  DMA_IN_XFER_CNTR_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_IN_XFER_CNTR_RESERVED1_MASK) >> DMA_IN_XFER_CNTR_RESERVED1_SHIFT)
#define  DMA_IN_XFER_CNTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_XFER_CNTR_RESERVED1_MASK) | (((uint32_t)val) << DMA_IN_XFER_CNTR_RESERVED1_SHIFT))

#define  DMA_IN_XFER_CNTR_XFER_CNTR_MASK 0xfffffff
#define  DMA_IN_XFER_CNTR_XFER_CNTR_SHIFT 0
#define  DMA_IN_XFER_CNTR_XFER_CNTR_MASK_SHIFT(reg) (((reg) & DMA_IN_XFER_CNTR_XFER_CNTR_MASK) >> DMA_IN_XFER_CNTR_XFER_CNTR_SHIFT)
#define  DMA_IN_XFER_CNTR_XFER_CNTR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_XFER_CNTR_XFER_CNTR_MASK) | (((uint32_t)val) << DMA_IN_XFER_CNTR_XFER_CNTR_SHIFT))

//====================================================================
//Register: Input DMA Next Link List Address (IN_NX_LL_ADR)
/** \brief This Address register contains the 32 bit address of the Next Link List address.
This address must be always at even address of the four word boundary. For
example: 0h , 10h, 20h or 30h .....
>
The following is the format of Link List stored in the system memory:
>
Base+0 : Source Address of Read Data
Base+4: Read Transfer Count in term of Word and the count should be 2 or more
for 64 bit AXI?? Data Bus.
Base+8: Next Link List Address (Which point to the base address of the next link
list).
>*/
//====================================================================

#define  DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_MASK 0xffffffff
#define  DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_SHIFT 0
#define  DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_MASK_SHIFT(reg) (((reg) & DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_MASK) >> DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_SHIFT)
#define  DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_MASK) | (((uint32_t)val) << DMA_IN_NX_LL_ADR_IN_NX_LL_ADR_SHIFT))

//====================================================================
//Register: Input DMA Interrupt 1 (IN_DMA_INT1)
//====================================================================

#define  DMA_IN_DMA_INT1_RESERVED1_MASK 0xffffffc0
#define  DMA_IN_DMA_INT1_RESERVED1_SHIFT 6
#define  DMA_IN_DMA_INT1_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_RESERVED1_MASK) >> DMA_IN_DMA_INT1_RESERVED1_SHIFT)
#define  DMA_IN_DMA_INT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_RESERVED1_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_RESERVED1_SHIFT))

#define  DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_MASK 0x20
#define  DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT 5
#define  DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_MASK) >> DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT)
#define  DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT))

#define  DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_MASK 0x10
#define  DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_SHIFT 4
#define  DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_MASK) >> DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_SHIFT)
#define  DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_IN_DMA_PAUSE_CMPL_SHIFT))

#define  DMA_IN_DMA_INT1_IN_PAR_ERR_MASK 0x8
#define  DMA_IN_DMA_INT1_IN_PAR_ERR_SHIFT 3
#define  DMA_IN_DMA_INT1_IN_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_IN_PAR_ERR_MASK) >> DMA_IN_DMA_INT1_IN_PAR_ERR_SHIFT)
#define  DMA_IN_DMA_INT1_IN_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_IN_PAR_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_IN_PAR_ERR_SHIFT))

#define  DMA_IN_DMA_INT1_IN_LL_ERR_MASK 0x4
#define  DMA_IN_DMA_INT1_IN_LL_ERR_SHIFT 2
#define  DMA_IN_DMA_INT1_IN_LL_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_IN_LL_ERR_MASK) >> DMA_IN_DMA_INT1_IN_LL_ERR_SHIFT)
#define  DMA_IN_DMA_INT1_IN_LL_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_IN_LL_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_IN_LL_ERR_SHIFT))

#define  DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_MASK 0x2
#define  DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_SHIFT 1
#define  DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_MASK) >> DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_SHIFT)
#define  DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_IN_DMA_BUS_ERR_SHIFT))

#define  DMA_IN_DMA_INT1_IN_DMA_DONE_MASK 0x1
#define  DMA_IN_DMA_INT1_IN_DMA_DONE_SHIFT 0
#define  DMA_IN_DMA_INT1_IN_DMA_DONE_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_IN_DMA_DONE_MASK) >> DMA_IN_DMA_INT1_IN_DMA_DONE_SHIFT)
#define  DMA_IN_DMA_INT1_IN_DMA_DONE_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_IN_DMA_DONE_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_IN_DMA_DONE_SHIFT))

//====================================================================
//Register: Input DMA Interrupt 1 Mask (IN_DMA_INT1_MSK)
/** \brief This register contains the individual interrupt mask bits.*/
//====================================================================

#define  DMA_IN_DMA_INT1_MSK_RESERVED1_MASK 0xffffffc0
#define  DMA_IN_DMA_INT1_MSK_RESERVED1_SHIFT 6
#define  DMA_IN_DMA_INT1_MSK_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_RESERVED1_MASK) >> DMA_IN_DMA_INT1_MSK_RESERVED1_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_RESERVED1_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_RESERVED1_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_MASK 0x20
#define  DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_SHIFT 5
#define  DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_AXI_DATA_PAR_ERR_MSK_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_MASK 0x10
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_SHIFT 4
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_IN_DMA_PAUSE_CMPL_MSK_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_MASK 0x8
#define  DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_SHIFT 3
#define  DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_IN_PAR_ERR_MSK_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_MASK 0x4
#define  DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_SHIFT 2
#define  DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_IN_LL_ERR_MSK_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_MASK 0x2
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_SHIFT 1
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_IN_DMA_BUS_ERR_MSK_SHIFT))

#define  DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_MASK 0x1
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_SHIFT 0
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_MASK_SHIFT(reg) (((reg) & DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_MASK) >> DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_SHIFT)
#define  DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_MASK) | (((uint32_t)val) << DMA_IN_DMA_INT1_MSK_IN_DMA_DONE_MSK_SHIFT))

//====================================================================
//Register: Output DMA Control Register (OUT_DMA_CTRL)
//====================================================================

#define  DMA_OUT_DMA_CTRL_RESERVED1_MASK 0x80000000
#define  DMA_OUT_DMA_CTRL_RESERVED1_SHIFT 31
#define  DMA_OUT_DMA_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_RESERVED1_MASK) >> DMA_OUT_DMA_CTRL_RESERVED1_SHIFT)
#define  DMA_OUT_DMA_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_RESERVED1_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_MASK 0x40000000
#define  DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_SHIFT 30
#define  DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_MASK) >> DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_DIS_XMIT_ERR_CODE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_MASK 0x20000000
#define  DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_SHIFT 29
#define  DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_MASK) >> DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_DIS_LL_ERR_CODE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_MASK 0x10000000
#define  DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_SHIFT 28
#define  DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_MASK) >> DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_DIS_ERR_CODE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_MASK 0xf000000
#define  DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_SHIFT 24
#define  DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_MASK) >> DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_CACHE_MODE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_WID_EXT_MASK 0xf00000
#define  DMA_OUT_DMA_CTRL_OUT_WID_EXT_SHIFT 20
#define  DMA_OUT_DMA_CTRL_OUT_WID_EXT_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_WID_EXT_MASK) >> DMA_OUT_DMA_CTRL_OUT_WID_EXT_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_WID_EXT_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_WID_EXT_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_WID_EXT_SHIFT))

#define  DMA_OUT_DMA_CTRL_RESERVED2_MASK 0xc0000
#define  DMA_OUT_DMA_CTRL_RESERVED2_SHIFT 18
#define  DMA_OUT_DMA_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_RESERVED2_MASK) >> DMA_OUT_DMA_CTRL_RESERVED2_SHIFT)
#define  DMA_OUT_DMA_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_RESERVED2_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_MASK 0x20000
#define  DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_SHIFT 17
#define  DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_MASK) >> DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_REQ_ALGN64_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_MASK 0x10000
#define  DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_SHIFT 16
#define  DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_MASK) >> DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_REQ_PAUSE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_BUS_SZ_MASK 0x8000
#define  DMA_OUT_DMA_CTRL_OUT_BUS_SZ_SHIFT 15
#define  DMA_OUT_DMA_CTRL_OUT_BUS_SZ_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_BUS_SZ_MASK) >> DMA_OUT_DMA_CTRL_OUT_BUS_SZ_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_BUS_SZ_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_BUS_SZ_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_BUS_SZ_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_MASK 0x6000
#define  DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_SHIFT 13
#define  DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_MASK) >> DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_BURST_TYPE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_BURST_LEN_MASK 0x1f00
#define  DMA_OUT_DMA_CTRL_OUT_BURST_LEN_SHIFT 8
#define  DMA_OUT_DMA_CTRL_OUT_BURST_LEN_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_BURST_LEN_MASK) >> DMA_OUT_DMA_CTRL_OUT_BURST_LEN_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_BURST_LEN_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_BURST_LEN_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_WID_MASK 0xf0
#define  DMA_OUT_DMA_CTRL_OUT_WID_SHIFT 4
#define  DMA_OUT_DMA_CTRL_OUT_WID_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_WID_MASK) >> DMA_OUT_DMA_CTRL_OUT_WID_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_WID_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_WID_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_WID_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_PROT_MODE_MASK 0xe
#define  DMA_OUT_DMA_CTRL_OUT_PROT_MODE_SHIFT 1
#define  DMA_OUT_DMA_CTRL_OUT_PROT_MODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_PROT_MODE_MASK) >> DMA_OUT_DMA_CTRL_OUT_PROT_MODE_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_PROT_MODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_PROT_MODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_PROT_MODE_SHIFT))

#define  DMA_OUT_DMA_CTRL_OUT_DMA_ENA_MASK 0x1
#define  DMA_OUT_DMA_CTRL_OUT_DMA_ENA_SHIFT 0
#define  DMA_OUT_DMA_CTRL_OUT_DMA_ENA_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_CTRL_OUT_DMA_ENA_MASK) >> DMA_OUT_DMA_CTRL_OUT_DMA_ENA_SHIFT)
#define  DMA_OUT_DMA_CTRL_OUT_DMA_ENA_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_CTRL_OUT_DMA_ENA_MASK) | (((uint32_t)val) << DMA_OUT_DMA_CTRL_OUT_DMA_ENA_SHIFT))

//====================================================================
//Register: Output DMA Status Register (OUT_DMA_STATUS)
//====================================================================

#define  DMA_OUT_DMA_STATUS_RESERVED1_MASK 0xffffffc0
#define  DMA_OUT_DMA_STATUS_RESERVED1_SHIFT 6
#define  DMA_OUT_DMA_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_STATUS_RESERVED1_MASK) >> DMA_OUT_DMA_STATUS_RESERVED1_SHIFT)
#define  DMA_OUT_DMA_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_STATUS_RESERVED1_MASK) | (((uint32_t)val) << DMA_OUT_DMA_STATUS_RESERVED1_SHIFT))

#define  DMA_OUT_DMA_STATUS_PAUSE_CMPL_MASK 0x20
#define  DMA_OUT_DMA_STATUS_PAUSE_CMPL_SHIFT 5
#define  DMA_OUT_DMA_STATUS_PAUSE_CMPL_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_STATUS_PAUSE_CMPL_MASK) >> DMA_OUT_DMA_STATUS_PAUSE_CMPL_SHIFT)
#define  DMA_OUT_DMA_STATUS_PAUSE_CMPL_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_STATUS_PAUSE_CMPL_MASK) | (((uint32_t)val) << DMA_OUT_DMA_STATUS_PAUSE_CMPL_SHIFT))

#define  DMA_OUT_DMA_STATUS_LL_ERR_CODE_MASK 0x18
#define  DMA_OUT_DMA_STATUS_LL_ERR_CODE_SHIFT 3
#define  DMA_OUT_DMA_STATUS_LL_ERR_CODE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_STATUS_LL_ERR_CODE_MASK) >> DMA_OUT_DMA_STATUS_LL_ERR_CODE_SHIFT)
#define  DMA_OUT_DMA_STATUS_LL_ERR_CODE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_STATUS_LL_ERR_CODE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_STATUS_LL_ERR_CODE_SHIFT))

#define  DMA_OUT_DMA_STATUS_PAR_ERR_MASK 0x4
#define  DMA_OUT_DMA_STATUS_PAR_ERR_SHIFT 2
#define  DMA_OUT_DMA_STATUS_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_STATUS_PAR_ERR_MASK) >> DMA_OUT_DMA_STATUS_PAR_ERR_SHIFT)
#define  DMA_OUT_DMA_STATUS_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_STATUS_PAR_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_STATUS_PAR_ERR_SHIFT))

#define  DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_MASK 0x3
#define  DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_SHIFT 0
#define  DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_MASK) >> DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_SHIFT)
#define  DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_STATUS_WR_CYCLE_ERR_SHIFT))

//====================================================================
//Register: DMA Output FIFO Destination Address (OUT_DEST_ADR)
/** \brief This Destination Address register contains the 32 bit memory address for the
output data. Each time a 32 bit word is written to the memory, the address is
incremented by four.*/
//====================================================================

#define  DMA_OUT_DEST_ADR_OUT_DEST_ADR_MASK 0xffffffff
#define  DMA_OUT_DEST_ADR_OUT_DEST_ADR_SHIFT 0
#define  DMA_OUT_DEST_ADR_OUT_DEST_ADR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DEST_ADR_OUT_DEST_ADR_MASK) >> DMA_OUT_DEST_ADR_OUT_DEST_ADR_SHIFT)
#define  DMA_OUT_DEST_ADR_OUT_DEST_ADR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DEST_ADR_OUT_DEST_ADR_MASK) | (((uint32_t)val) << DMA_OUT_DEST_ADR_OUT_DEST_ADR_SHIFT))

//====================================================================
//Register: Output DMA Transfer Counter (OUT_XFER_CNTR)
/** \brief This counter keeps track of the total output transfer count in term of 32 bit
data word.*/
//====================================================================

#define  DMA_OUT_XFER_CNTR_RESERVED1_MASK 0xf0000000
#define  DMA_OUT_XFER_CNTR_RESERVED1_SHIFT 28
#define  DMA_OUT_XFER_CNTR_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_OUT_XFER_CNTR_RESERVED1_MASK) >> DMA_OUT_XFER_CNTR_RESERVED1_SHIFT)
#define  DMA_OUT_XFER_CNTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_XFER_CNTR_RESERVED1_MASK) | (((uint32_t)val) << DMA_OUT_XFER_CNTR_RESERVED1_SHIFT))

#define  DMA_OUT_XFER_CNTR_XFER_CNTR_MASK 0xfffffff
#define  DMA_OUT_XFER_CNTR_XFER_CNTR_SHIFT 0
#define  DMA_OUT_XFER_CNTR_XFER_CNTR_MASK_SHIFT(reg) (((reg) & DMA_OUT_XFER_CNTR_XFER_CNTR_MASK) >> DMA_OUT_XFER_CNTR_XFER_CNTR_SHIFT)
#define  DMA_OUT_XFER_CNTR_XFER_CNTR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_XFER_CNTR_XFER_CNTR_MASK) | (((uint32_t)val) << DMA_OUT_XFER_CNTR_XFER_CNTR_SHIFT))

//====================================================================
//Register: Output DMA Next Link List Address (OUT_NX_LL_ADR)
/** \brief This Address register contains the 32 bit address of the Next Link List address.
This address must be always at even address of the four word boundary. For
example: 0h , 10h, 20h or 30h .....
>
>
The following is the format of Link List stored in the system memory:
>
Base+0 : Destination Address of Write Data
Base+4: Write Transfer Count in term of Word and the count should be 2 or more
for 64 bit AXI?? Data Bus.
Base+8: Next Link List Address (Which point to the base address of the next link
list).
>
>*/
//====================================================================

#define  DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_MASK 0xffffffff
#define  DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_SHIFT 0
#define  DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_MASK_SHIFT(reg) (((reg) & DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_MASK) >> DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_SHIFT)
#define  DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_MASK) | (((uint32_t)val) << DMA_OUT_NX_LL_ADR_OUT_NX_LL_ADR_SHIFT))

//====================================================================
//Register: Output DMA Interrupt 1 (OUT_DMA_INT1)
//====================================================================

#define  DMA_OUT_DMA_INT1_RESERVED1_MASK 0xffffffc0
#define  DMA_OUT_DMA_INT1_RESERVED1_SHIFT 6
#define  DMA_OUT_DMA_INT1_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_RESERVED1_MASK) >> DMA_OUT_DMA_INT1_RESERVED1_SHIFT)
#define  DMA_OUT_DMA_INT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_RESERVED1_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_RESERVED1_SHIFT))

#define  DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_MASK 0x20
#define  DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT 5
#define  DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_MASK) >> DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT)
#define  DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_AXI_DATA_PAR_ERR_SHIFT))

#define  DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_MASK 0x10
#define  DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_SHIFT 4
#define  DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_MASK) >> DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_SHIFT)
#define  DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_OUT_DMA_PAUSE_CMPL_SHIFT))

#define  DMA_OUT_DMA_INT1_OUT_PAR_ERR_MASK 0x8
#define  DMA_OUT_DMA_INT1_OUT_PAR_ERR_SHIFT 3
#define  DMA_OUT_DMA_INT1_OUT_PAR_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_OUT_PAR_ERR_MASK) >> DMA_OUT_DMA_INT1_OUT_PAR_ERR_SHIFT)
#define  DMA_OUT_DMA_INT1_OUT_PAR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_OUT_PAR_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_OUT_PAR_ERR_SHIFT))

#define  DMA_OUT_DMA_INT1_OUT_LL_ERR_MASK 0x4
#define  DMA_OUT_DMA_INT1_OUT_LL_ERR_SHIFT 2
#define  DMA_OUT_DMA_INT1_OUT_LL_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_OUT_LL_ERR_MASK) >> DMA_OUT_DMA_INT1_OUT_LL_ERR_SHIFT)
#define  DMA_OUT_DMA_INT1_OUT_LL_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_OUT_LL_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_OUT_LL_ERR_SHIFT))

#define  DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_MASK 0x2
#define  DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_SHIFT 1
#define  DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_MASK) >> DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_SHIFT)
#define  DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_OUT_DMA_BUS_ERR_SHIFT))

#define  DMA_OUT_DMA_INT1_OUT_DMA_DONE_MASK 0x1
#define  DMA_OUT_DMA_INT1_OUT_DMA_DONE_SHIFT 0
#define  DMA_OUT_DMA_INT1_OUT_DMA_DONE_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_OUT_DMA_DONE_MASK) >> DMA_OUT_DMA_INT1_OUT_DMA_DONE_SHIFT)
#define  DMA_OUT_DMA_INT1_OUT_DMA_DONE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_OUT_DMA_DONE_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_OUT_DMA_DONE_SHIFT))

//====================================================================
//Register: Output DMA Interrupt 1 Mask (OUT_DMA_INT1_MSK)
/** \brief This register contains the individual interrupt mask bits.*/
//====================================================================

#define  DMA_OUT_DMA_INT1_MSK_RESERVED1_MASK 0xffffffc0
#define  DMA_OUT_DMA_INT1_MSK_RESERVED1_SHIFT 6
#define  DMA_OUT_DMA_INT1_MSK_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_RESERVED1_MASK) >> DMA_OUT_DMA_INT1_MSK_RESERVED1_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_RESERVED1_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_RESERVED1_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_MASK 0x20
#define  DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_SHIFT 5
#define  DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_DATA_PAR_ERR_MSK_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_MASK 0x10
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_SHIFT 4
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_OUT_DMA_PAUSE_CMPL_MSK_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_MASK 0x8
#define  DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_SHIFT 3
#define  DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_OUT_PAR_ERR_MSK_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_MASK 0x4
#define  DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_SHIFT 2
#define  DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_OUT_LL_ERR_MSK_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_MASK 0x2
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_SHIFT 1
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_OUT_DMA_BUS_ERR_MSK_SHIFT))

#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_MASK 0x1
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_SHIFT 0
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_MASK_SHIFT(reg) (((reg) & DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_MASK) >> DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_SHIFT)
#define  DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_REPLACE_VAL(reg,val) (((reg) & ~DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_MASK) | (((uint32_t)val) << DMA_OUT_DMA_INT1_MSK_OUT_DMA_DONE_MSK_SHIFT))

//====================================================================
//Register: AXI Control Register (AXI_CTRL)
//====================================================================

#define  DMA_AXI_CTRL_RESERVED1_MASK 0xfff80000
#define  DMA_AXI_CTRL_RESERVED1_SHIFT 19
#define  DMA_AXI_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_RESERVED1_MASK) >> DMA_AXI_CTRL_RESERVED1_SHIFT)
#define  DMA_AXI_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_RESERVED1_SHIFT))

#define  DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_MASK 0x70000
#define  DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_SHIFT 16
#define  DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_MASK) >> DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_SHIFT)
#define  DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_AXI_XMIT_RESP_MAX_SHIFT))

#define  DMA_AXI_CTRL_RESERVED2_MASK 0xfe00
#define  DMA_AXI_CTRL_RESERVED2_SHIFT 9
#define  DMA_AXI_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_RESERVED2_MASK) >> DMA_AXI_CTRL_RESERVED2_SHIFT)
#define  DMA_AXI_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_RESERVED2_SHIFT))

#define  DMA_AXI_CTRL_AXI_DATA_PAR_ENA_MASK 0x100
#define  DMA_AXI_CTRL_AXI_DATA_PAR_ENA_SHIFT 8
#define  DMA_AXI_CTRL_AXI_DATA_PAR_ENA_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_AXI_DATA_PAR_ENA_MASK) >> DMA_AXI_CTRL_AXI_DATA_PAR_ENA_SHIFT)
#define  DMA_AXI_CTRL_AXI_DATA_PAR_ENA_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_AXI_DATA_PAR_ENA_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_AXI_DATA_PAR_ENA_SHIFT))

#define  DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_MASK 0x80
#define  DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_SHIFT 7
#define  DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_MASK) >> DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_SHIFT)
#define  DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_AXI_WDATA_PAR_EVEN_SHIFT))

#define  DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_MASK 0x40
#define  DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_SHIFT 6
#define  DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_MASK) >> DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_SHIFT)
#define  DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_AXI_RDATA_PAR_EVEN_SHIFT))

#define  DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_MASK 0x20
#define  DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_SHIFT 5
#define  DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_MASK) >> DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_SHIFT)
#define  DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_LINK_LIST_SWAP_DIS_SHIFT))

#define  DMA_AXI_CTRL_DMA_LOOP_BACK_EN_MASK 0x10
#define  DMA_AXI_CTRL_DMA_LOOP_BACK_EN_SHIFT 4
#define  DMA_AXI_CTRL_DMA_LOOP_BACK_EN_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_DMA_LOOP_BACK_EN_MASK) >> DMA_AXI_CTRL_DMA_LOOP_BACK_EN_SHIFT)
#define  DMA_AXI_CTRL_DMA_LOOP_BACK_EN_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_DMA_LOOP_BACK_EN_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_DMA_LOOP_BACK_EN_SHIFT))

#define  DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_MASK 0x8
#define  DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_SHIFT 3
#define  DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_MASK) >> DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_SHIFT)
#define  DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_OUT_AXI_MS_WRD_SWP_SHIFT))

#define  DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_MASK 0x4
#define  DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_SHIFT 2
#define  DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_MASK) >> DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_SHIFT)
#define  DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_OUT_AXI_MS_BYTE_SWP_SHIFT))

#define  DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_MASK 0x2
#define  DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_SHIFT 1
#define  DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_MASK) >> DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_SHIFT)
#define  DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_IN_AXI_MS_WRD_SWP_SHIFT))

#define  DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_MASK 0x1
#define  DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_SHIFT 0
#define  DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_MASK_SHIFT(reg) (((reg) & DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_MASK) >> DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_SHIFT)
#define  DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_REPLACE_VAL(reg,val) (((reg) & ~DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_MASK) | (((uint32_t)val) << DMA_AXI_CTRL_IN_AXI_MS_BYTE_SWP_SHIFT))

//====================================================================
//Register: DMA input FIFO Remain Count (IF_RCOUNT)
/** \brief This register indicates how much data is remain in the DMA?? Input FIFO. This
register and the Input DMA Counter the can be used to calculate how much data
has been sent to the encrytion engine.*/
//====================================================================

#define  DMA_IF_RCOUNT_IF_RCOUNT_MASK 0xffffffff
#define  DMA_IF_RCOUNT_IF_RCOUNT_SHIFT 0
#define  DMA_IF_RCOUNT_IF_RCOUNT_MASK_SHIFT(reg) (((reg) & DMA_IF_RCOUNT_IF_RCOUNT_MASK) >> DMA_IF_RCOUNT_IF_RCOUNT_SHIFT)
#define  DMA_IF_RCOUNT_IF_RCOUNT_REPLACE_VAL(reg,val) (((reg) & ~DMA_IF_RCOUNT_IF_RCOUNT_MASK) | (((uint32_t)val) << DMA_IF_RCOUNT_IF_RCOUNT_SHIFT))

//====================================================================
//Register: DMA input FIFO Error Read Pointer (IF_RD_PTR_ERR)
/** \brief This register indicates the FIFO??read Pointer of the DMA?? Input FIFO where the
parity error occurs.*/
//====================================================================

#define  DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_MASK 0xffffffff
#define  DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_SHIFT 0
#define  DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_MASK_SHIFT(reg) (((reg) & DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_MASK) >> DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_SHIFT)
#define  DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_MASK) | (((uint32_t)val) << DMA_IF_RD_PTR_ERR_IF_RD_PTR_ERR_SHIFT))

//====================================================================
//Register: DMA Output FIFO Remain Space (OF_SPACE)
/** \brief This register indicates how much space is remain in the DMA?? Output FIFO. This
register and the Output DMA Counter the can be used to calculate how much data
has been sent out from the encrytion engine. This can be used for diagnostic
purpose.*/
//====================================================================

#define  DMA_OF_SPACE_OF_SPACE_MASK 0xffffffff
#define  DMA_OF_SPACE_OF_SPACE_SHIFT 0
#define  DMA_OF_SPACE_OF_SPACE_MASK_SHIFT(reg) (((reg) & DMA_OF_SPACE_OF_SPACE_MASK) >> DMA_OF_SPACE_OF_SPACE_SHIFT)
#define  DMA_OF_SPACE_OF_SPACE_REPLACE_VAL(reg,val) (((reg) & ~DMA_OF_SPACE_OF_SPACE_MASK) | (((uint32_t)val) << DMA_OF_SPACE_OF_SPACE_SHIFT))

//====================================================================
//Register: DMA output FIFO Error Read Pointer (OF_RD_PTR_ERR)
/** \brief This register indicates the FIFO??read Pointer of the DMA?? Input FIFO where the
parity error occurs.*/
//====================================================================

#define  DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_MASK 0xffffffff
#define  DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_SHIFT 0
#define  DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_MASK_SHIFT(reg) (((reg) & DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_MASK) >> DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_SHIFT)
#define  DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_REPLACE_VAL(reg,val) (((reg) & ~DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_MASK) | (((uint32_t)val) << DMA_OF_RD_PTR_ERR_OF_RD_PTR_ERR_SHIFT))

//====================================================================
//Register: DMA input FIFO Access Port (IF_RAM)
/** \brief This 32 bit wide access port allows the external CPU?? to access the DMA?? Input
FIFO.*/
//====================================================================

#define  DMA_IF_RAM_IF_RAM_MASK 0xffffffff
#define  DMA_IF_RAM_IF_RAM_SHIFT 0
#define  DMA_IF_RAM_IF_RAM_MASK_SHIFT(reg) (((reg) & DMA_IF_RAM_IF_RAM_MASK) >> DMA_IF_RAM_IF_RAM_SHIFT)
#define  DMA_IF_RAM_IF_RAM_REPLACE_VAL(reg,val) (((reg) & ~DMA_IF_RAM_IF_RAM_MASK) | (((uint32_t)val) << DMA_IF_RAM_IF_RAM_SHIFT))

//====================================================================
//Register: DMA Output FIFO Access Port (OF_RAM)
/** \brief This 32 bit access port allows the external CPU?? to access the DMA?? output
FIFO.*/
//====================================================================

#define  DMA_OF_RAM_OF_RAM_MASK 0xffffffff
#define  DMA_OF_RAM_OF_RAM_SHIFT 0
#define  DMA_OF_RAM_OF_RAM_MASK_SHIFT(reg) (((reg) & DMA_OF_RAM_OF_RAM_MASK) >> DMA_OF_RAM_OF_RAM_SHIFT)
#define  DMA_OF_RAM_OF_RAM_REPLACE_VAL(reg,val) (((reg) & ~DMA_OF_RAM_OF_RAM_MASK) | (((uint32_t)val) << DMA_OF_RAM_OF_RAM_SHIFT))

//====================================================================
//
//Register File: AXI Master Control Registers (WTM_ACCEL_BUS_REG)
/** \brief Accelrator Internal Bus Control Registers
Control Data Flow Between DMA&nbsp; (Input & Output Buffers), Scratch Pad
(Temporary Buffer) and Group A &&nbsp; Group B Accelrators*/
//
//====================================================================

//====================================================================
//Register: Trusted Module Internal Bus Control (accel_bus_ctrl)
//====================================================================

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_MASK 0xfffff800
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_SHIFT 11
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED1_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_MASK 0x700
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_SHIFT 8
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPB_SELECT_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_MASK 0x80
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_SHIFT 7
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED2_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_MASK 0x70
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_SHIFT 4
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_GROUPA_SELECT_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_MASK 0x8
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_SHIFT 3
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED3_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_MASK 0x4
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_SHIFT 2
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_WR_CB_CTRL_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_MASK 0x2
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_SHIFT 1
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RESERVED4_SHIFT))

#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_MASK 0x1
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_SHIFT 0
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_MASK_SHIFT(reg) (((reg) & WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_MASK) >> WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_SHIFT)
#define  WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_REPLACE_VAL(reg,val) (((reg) & ~WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_MASK) | (((uint32_t)val) << WTM_ACCEL_BUS_REG_ACCEL_BUS_CTRL_RD_CB_CTRL_SHIFT))

//====================================================================
//
//Register File: CRYPTO Engine Control Registers (CRYPT)
//
//====================================================================

//====================================================================
//Register: AES_CFG_REG (AES_CFG_REG)
//====================================================================

#define  CRYPT_AES_CFG_REG_RESERVED1_MASK 0xfffe0000
#define  CRYPT_AES_CFG_REG_RESERVED1_SHIFT 17
#define  CRYPT_AES_CFG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_RESERVED1_MASK) >> CRYPT_AES_CFG_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_CFG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_CFG_REG_CTS_MODE_MASK 0x10000
#define  CRYPT_AES_CFG_REG_CTS_MODE_SHIFT 16
#define  CRYPT_AES_CFG_REG_CTS_MODE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_CTS_MODE_MASK) >> CRYPT_AES_CFG_REG_CTS_MODE_SHIFT)
#define  CRYPT_AES_CFG_REG_CTS_MODE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_CTS_MODE_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_CTS_MODE_SHIFT))

#define  CRYPT_AES_CFG_REG_RESERVED2_MASK 0x8000
#define  CRYPT_AES_CFG_REG_RESERVED2_SHIFT 15
#define  CRYPT_AES_CFG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_RESERVED2_MASK) >> CRYPT_AES_CFG_REG_RESERVED2_SHIFT)
#define  CRYPT_AES_CFG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_RESERVED2_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_RESERVED2_SHIFT))

#define  CRYPT_AES_CFG_REG_MODULAR_MASK 0x7f00
#define  CRYPT_AES_CFG_REG_MODULAR_SHIFT 8
#define  CRYPT_AES_CFG_REG_MODULAR_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_MODULAR_MASK) >> CRYPT_AES_CFG_REG_MODULAR_SHIFT)
#define  CRYPT_AES_CFG_REG_MODULAR_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_MODULAR_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_MODULAR_SHIFT))

#define  CRYPT_AES_CFG_REG_RESERVED3_MASK 0x80
#define  CRYPT_AES_CFG_REG_RESERVED3_SHIFT 7
#define  CRYPT_AES_CFG_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_RESERVED3_MASK) >> CRYPT_AES_CFG_REG_RESERVED3_SHIFT)
#define  CRYPT_AES_CFG_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_RESERVED3_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_RESERVED3_SHIFT))

#define  CRYPT_AES_CFG_REG_RKEY_MASK 0x40
#define  CRYPT_AES_CFG_REG_RKEY_SHIFT 6
#define  CRYPT_AES_CFG_REG_RKEY_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_RKEY_MASK) >> CRYPT_AES_CFG_REG_RKEY_SHIFT)
#define  CRYPT_AES_CFG_REG_RKEY_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_RKEY_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_RKEY_SHIFT))

#define  CRYPT_AES_CFG_REG_MODE_MASK 0x38
#define  CRYPT_AES_CFG_REG_MODE_SHIFT 3
#define  CRYPT_AES_CFG_REG_MODE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_MODE_MASK) >> CRYPT_AES_CFG_REG_MODE_SHIFT)
#define  CRYPT_AES_CFG_REG_MODE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_MODE_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_MODE_SHIFT))

#define  CRYPT_AES_CFG_REG_KEYLEN_MASK 0x6
#define  CRYPT_AES_CFG_REG_KEYLEN_SHIFT 1
#define  CRYPT_AES_CFG_REG_KEYLEN_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_KEYLEN_MASK) >> CRYPT_AES_CFG_REG_KEYLEN_SHIFT)
#define  CRYPT_AES_CFG_REG_KEYLEN_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_KEYLEN_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_KEYLEN_SHIFT))

#define  CRYPT_AES_CFG_REG_DECRYPT_MASK 0x1
#define  CRYPT_AES_CFG_REG_DECRYPT_SHIFT 0
#define  CRYPT_AES_CFG_REG_DECRYPT_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CFG_REG_DECRYPT_MASK) >> CRYPT_AES_CFG_REG_DECRYPT_SHIFT)
#define  CRYPT_AES_CFG_REG_DECRYPT_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CFG_REG_DECRYPT_MASK) | (((uint32_t)val) << CRYPT_AES_CFG_REG_DECRYPT_SHIFT))

//====================================================================
//Register: AES_CTRL_REG (AES_CTRL_REG)
//====================================================================

#define  CRYPT_AES_CTRL_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_AES_CTRL_REG_RESERVED1_SHIFT 3
#define  CRYPT_AES_CTRL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CTRL_REG_RESERVED1_MASK) >> CRYPT_AES_CTRL_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_CTRL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CTRL_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_CTRL_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_CTRL_REG_OUTPUTBLOCK_MASK 0x4
#define  CRYPT_AES_CTRL_REG_OUTPUTBLOCK_SHIFT 2
#define  CRYPT_AES_CTRL_REG_OUTPUTBLOCK_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CTRL_REG_OUTPUTBLOCK_MASK) >> CRYPT_AES_CTRL_REG_OUTPUTBLOCK_SHIFT)
#define  CRYPT_AES_CTRL_REG_OUTPUTBLOCK_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CTRL_REG_OUTPUTBLOCK_MASK) | (((uint32_t)val) << CRYPT_AES_CTRL_REG_OUTPUTBLOCK_SHIFT))

#define  CRYPT_AES_CTRL_REG_RESUME_MASK 0x2
#define  CRYPT_AES_CTRL_REG_RESUME_SHIFT 1
#define  CRYPT_AES_CTRL_REG_RESUME_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CTRL_REG_RESUME_MASK) >> CRYPT_AES_CTRL_REG_RESUME_SHIFT)
#define  CRYPT_AES_CTRL_REG_RESUME_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CTRL_REG_RESUME_MASK) | (((uint32_t)val) << CRYPT_AES_CTRL_REG_RESUME_SHIFT))

#define  CRYPT_AES_CTRL_REG_RESET_MASK 0x1
#define  CRYPT_AES_CTRL_REG_RESET_SHIFT 0
#define  CRYPT_AES_CTRL_REG_RESET_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CTRL_REG_RESET_MASK) >> CRYPT_AES_CTRL_REG_RESET_SHIFT)
#define  CRYPT_AES_CTRL_REG_RESET_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CTRL_REG_RESET_MASK) | (((uint32_t)val) << CRYPT_AES_CTRL_REG_RESET_SHIFT))

//====================================================================
//Register: AES_CMD_REG (AES_CMD_REG)
//====================================================================

#define  CRYPT_AES_CMD_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_AES_CMD_REG_RESERVED1_SHIFT 1
#define  CRYPT_AES_CMD_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CMD_REG_RESERVED1_MASK) >> CRYPT_AES_CMD_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_CMD_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CMD_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_CMD_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_CMD_REG_START_MASK 0x1
#define  CRYPT_AES_CMD_REG_START_SHIFT 0
#define  CRYPT_AES_CMD_REG_START_MASK_SHIFT(reg) (((reg) & CRYPT_AES_CMD_REG_START_MASK) >> CRYPT_AES_CMD_REG_START_SHIFT)
#define  CRYPT_AES_CMD_REG_START_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_CMD_REG_START_MASK) | (((uint32_t)val) << CRYPT_AES_CMD_REG_START_SHIFT))

//====================================================================
//Register: AES_STATUS_REG (AES_STATUS_REG)
//====================================================================

#define  CRYPT_AES_STATUS_REG_RESERVED1_MASK 0xffffffe0
#define  CRYPT_AES_STATUS_REG_RESERVED1_SHIFT 5
#define  CRYPT_AES_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_STATUS_REG_RESERVED1_MASK) >> CRYPT_AES_STATUS_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_STATUS_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_STATUS_REG_STATE_MASK 0x1e
#define  CRYPT_AES_STATUS_REG_STATE_SHIFT 1
#define  CRYPT_AES_STATUS_REG_STATE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_STATUS_REG_STATE_MASK) >> CRYPT_AES_STATUS_REG_STATE_SHIFT)
#define  CRYPT_AES_STATUS_REG_STATE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_STATUS_REG_STATE_MASK) | (((uint32_t)val) << CRYPT_AES_STATUS_REG_STATE_SHIFT))

#define  CRYPT_AES_STATUS_REG_BUSY_MASK 0x1
#define  CRYPT_AES_STATUS_REG_BUSY_SHIFT 0
#define  CRYPT_AES_STATUS_REG_BUSY_MASK_SHIFT(reg) (((reg) & CRYPT_AES_STATUS_REG_BUSY_MASK) >> CRYPT_AES_STATUS_REG_BUSY_SHIFT)
#define  CRYPT_AES_STATUS_REG_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_STATUS_REG_BUSY_MASK) | (((uint32_t)val) << CRYPT_AES_STATUS_REG_BUSY_SHIFT))

//====================================================================
//Register: AES_INTRPT_REG (AES_INTRPT_REG)
/** \brief Interrupt signals can only be cleared by CPU.*/
//====================================================================

#define  CRYPT_AES_INTRPT_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_AES_INTRPT_REG_RESERVED1_SHIFT 3
#define  CRYPT_AES_INTRPT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_REG_RESERVED1_MASK) >> CRYPT_AES_INTRPT_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_INTRPT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_INTRPT_REG_ERROR2_MASK 0x4
#define  CRYPT_AES_INTRPT_REG_ERROR2_SHIFT 2
#define  CRYPT_AES_INTRPT_REG_ERROR2_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_REG_ERROR2_MASK) >> CRYPT_AES_INTRPT_REG_ERROR2_SHIFT)
#define  CRYPT_AES_INTRPT_REG_ERROR2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_REG_ERROR2_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_REG_ERROR2_SHIFT))

#define  CRYPT_AES_INTRPT_REG_ERROR1_MASK 0x2
#define  CRYPT_AES_INTRPT_REG_ERROR1_SHIFT 1
#define  CRYPT_AES_INTRPT_REG_ERROR1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_REG_ERROR1_MASK) >> CRYPT_AES_INTRPT_REG_ERROR1_SHIFT)
#define  CRYPT_AES_INTRPT_REG_ERROR1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_REG_ERROR1_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_REG_ERROR1_SHIFT))

#define  CRYPT_AES_INTRPT_REG_DONE_MASK 0x1
#define  CRYPT_AES_INTRPT_REG_DONE_SHIFT 0
#define  CRYPT_AES_INTRPT_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_REG_DONE_MASK) >> CRYPT_AES_INTRPT_REG_DONE_SHIFT)
#define  CRYPT_AES_INTRPT_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_REG_DONE_SHIFT))

//====================================================================
//Register: AES_INTRPT_SRC_EN_REG (AES_INTRPT_SRC_EN_REG)
//====================================================================

#define  CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT 3
#define  CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_MASK) >> CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT)
#define  CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT))

#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_MASK 0x4
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_SHIFT 2
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_MASK) >> CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_SHIFT)
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_SRC_EN_REG_ERROR2_SHIFT))

#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_MASK 0x2
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_SHIFT 1
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_MASK) >> CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_SHIFT)
#define  CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_SRC_EN_REG_ERROR1_SHIFT))

#define  CRYPT_AES_INTRPT_SRC_EN_REG_DONE_MASK 0x1
#define  CRYPT_AES_INTRPT_SRC_EN_REG_DONE_SHIFT 0
#define  CRYPT_AES_INTRPT_SRC_EN_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_INTRPT_SRC_EN_REG_DONE_MASK) >> CRYPT_AES_INTRPT_SRC_EN_REG_DONE_SHIFT)
#define  CRYPT_AES_INTRPT_SRC_EN_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_INTRPT_SRC_EN_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_AES_INTRPT_SRC_EN_REG_DONE_SHIFT))

//====================================================================
//Register: AES_STREAM_SIZE (AES_STREAM_SIZE)
/** \brief Incoming stream (segment) size (in Byte).
-Key Wrap Mode
- The input data stream must be multiple of 8 bytes, no less than 16 bytes, and
no more than Scratch Pad can handle .
- The input data stream must be 64-bit reversed order during unwrapping. After
unwrapped, the output data stream has to be reversed (64-bit) again to restore
the data format. EX: "ABCD" is the plaintext to AES for Key Wrapping and the
ciphertext is "WXYZ". Each character represents 32 bits (1 word). When the
ciphertext is fed back to AES for unwrapping, the order must be "YZWX". The
output of the unwrapping process is "CDAB". User then needs to restore the order
back to "ABCD".
-Other Modes
- The input data stream must be no less than 16 bytes.
- If the stream is divided to multiple segments (Resume Operation), all segments
must be multiple of 16 bytes. If the mode is not ECB, the last segment allowes
partial codeword.*/
//====================================================================

#define  CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_MASK 0xffffffff
#define  CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_SHIFT 0
#define  CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_MASK_SHIFT(reg) (((reg) & CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_MASK) >> CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_SHIFT)
#define  CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_MASK) | (((uint32_t)val) << CRYPT_AES_STREAM_SIZE_AES_STREAM_SIZE_SHIFT))

//====================================================================
//Register: DES_CFG_REG (DES_CFG_REG)
//====================================================================

#define  CRYPT_DES_CFG_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_DES_CFG_REG_RESERVED1_SHIFT 3
#define  CRYPT_DES_CFG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CFG_REG_RESERVED1_MASK) >> CRYPT_DES_CFG_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_CFG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CFG_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_CFG_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_CFG_REG_OP_MODE_MASK 0x4
#define  CRYPT_DES_CFG_REG_OP_MODE_SHIFT 2
#define  CRYPT_DES_CFG_REG_OP_MODE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CFG_REG_OP_MODE_MASK) >> CRYPT_DES_CFG_REG_OP_MODE_SHIFT)
#define  CRYPT_DES_CFG_REG_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CFG_REG_OP_MODE_MASK) | (((uint32_t)val) << CRYPT_DES_CFG_REG_OP_MODE_SHIFT))

#define  CRYPT_DES_CFG_REG_ENG_MODE_MASK 0x2
#define  CRYPT_DES_CFG_REG_ENG_MODE_SHIFT 1
#define  CRYPT_DES_CFG_REG_ENG_MODE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CFG_REG_ENG_MODE_MASK) >> CRYPT_DES_CFG_REG_ENG_MODE_SHIFT)
#define  CRYPT_DES_CFG_REG_ENG_MODE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CFG_REG_ENG_MODE_MASK) | (((uint32_t)val) << CRYPT_DES_CFG_REG_ENG_MODE_SHIFT))

#define  CRYPT_DES_CFG_REG_DECRYPT_MASK 0x1
#define  CRYPT_DES_CFG_REG_DECRYPT_SHIFT 0
#define  CRYPT_DES_CFG_REG_DECRYPT_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CFG_REG_DECRYPT_MASK) >> CRYPT_DES_CFG_REG_DECRYPT_SHIFT)
#define  CRYPT_DES_CFG_REG_DECRYPT_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CFG_REG_DECRYPT_MASK) | (((uint32_t)val) << CRYPT_DES_CFG_REG_DECRYPT_SHIFT))

//====================================================================
//Register: DES_CTRL_REG (DES_CTRL_REG)
//====================================================================

#define  CRYPT_DES_CTRL_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_DES_CTRL_REG_RESERVED1_SHIFT 1
#define  CRYPT_DES_CTRL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CTRL_REG_RESERVED1_MASK) >> CRYPT_DES_CTRL_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_CTRL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CTRL_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_CTRL_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_CTRL_REG_RESET_MASK 0x1
#define  CRYPT_DES_CTRL_REG_RESET_SHIFT 0
#define  CRYPT_DES_CTRL_REG_RESET_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CTRL_REG_RESET_MASK) >> CRYPT_DES_CTRL_REG_RESET_SHIFT)
#define  CRYPT_DES_CTRL_REG_RESET_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CTRL_REG_RESET_MASK) | (((uint32_t)val) << CRYPT_DES_CTRL_REG_RESET_SHIFT))

//====================================================================
//Register: DES_CMD_REG (DES_CMD_REG)
//====================================================================

#define  CRYPT_DES_CMD_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_DES_CMD_REG_RESERVED1_SHIFT 1
#define  CRYPT_DES_CMD_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CMD_REG_RESERVED1_MASK) >> CRYPT_DES_CMD_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_CMD_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CMD_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_CMD_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_CMD_REG_START_MASK 0x1
#define  CRYPT_DES_CMD_REG_START_SHIFT 0
#define  CRYPT_DES_CMD_REG_START_MASK_SHIFT(reg) (((reg) & CRYPT_DES_CMD_REG_START_MASK) >> CRYPT_DES_CMD_REG_START_SHIFT)
#define  CRYPT_DES_CMD_REG_START_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_CMD_REG_START_MASK) | (((uint32_t)val) << CRYPT_DES_CMD_REG_START_SHIFT))

//====================================================================
//Register: DES_STATUS_REG (DES_STATUS_REG)
//====================================================================

#define  CRYPT_DES_STATUS_REG_RESERVED1_MASK 0xffffffe0
#define  CRYPT_DES_STATUS_REG_RESERVED1_SHIFT 5
#define  CRYPT_DES_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_STATUS_REG_RESERVED1_MASK) >> CRYPT_DES_STATUS_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_STATUS_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_STATUS_REG_STATE_MASK 0x1e
#define  CRYPT_DES_STATUS_REG_STATE_SHIFT 1
#define  CRYPT_DES_STATUS_REG_STATE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_STATUS_REG_STATE_MASK) >> CRYPT_DES_STATUS_REG_STATE_SHIFT)
#define  CRYPT_DES_STATUS_REG_STATE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_STATUS_REG_STATE_MASK) | (((uint32_t)val) << CRYPT_DES_STATUS_REG_STATE_SHIFT))

#define  CRYPT_DES_STATUS_REG_BUSY_MASK 0x1
#define  CRYPT_DES_STATUS_REG_BUSY_SHIFT 0
#define  CRYPT_DES_STATUS_REG_BUSY_MASK_SHIFT(reg) (((reg) & CRYPT_DES_STATUS_REG_BUSY_MASK) >> CRYPT_DES_STATUS_REG_BUSY_SHIFT)
#define  CRYPT_DES_STATUS_REG_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_STATUS_REG_BUSY_MASK) | (((uint32_t)val) << CRYPT_DES_STATUS_REG_BUSY_SHIFT))

//====================================================================
//Register: DES_INTRPT_REG (DES_INTRPT_REG)
/** \brief Interrupt signals can only be cleared by CPU.*/
//====================================================================

#define  CRYPT_DES_INTRPT_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_DES_INTRPT_REG_RESERVED1_SHIFT 3
#define  CRYPT_DES_INTRPT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_REG_RESERVED1_MASK) >> CRYPT_DES_INTRPT_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_INTRPT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_INTRPT_REG_ERROR2_MASK 0x4
#define  CRYPT_DES_INTRPT_REG_ERROR2_SHIFT 2
#define  CRYPT_DES_INTRPT_REG_ERROR2_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_REG_ERROR2_MASK) >> CRYPT_DES_INTRPT_REG_ERROR2_SHIFT)
#define  CRYPT_DES_INTRPT_REG_ERROR2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_REG_ERROR2_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_REG_ERROR2_SHIFT))

#define  CRYPT_DES_INTRPT_REG_ERROR1_MASK 0x2
#define  CRYPT_DES_INTRPT_REG_ERROR1_SHIFT 1
#define  CRYPT_DES_INTRPT_REG_ERROR1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_REG_ERROR1_MASK) >> CRYPT_DES_INTRPT_REG_ERROR1_SHIFT)
#define  CRYPT_DES_INTRPT_REG_ERROR1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_REG_ERROR1_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_REG_ERROR1_SHIFT))

#define  CRYPT_DES_INTRPT_REG_DONE_MASK 0x1
#define  CRYPT_DES_INTRPT_REG_DONE_SHIFT 0
#define  CRYPT_DES_INTRPT_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_REG_DONE_MASK) >> CRYPT_DES_INTRPT_REG_DONE_SHIFT)
#define  CRYPT_DES_INTRPT_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_REG_DONE_SHIFT))

//====================================================================
//Register: DES_INTRPT_SRC_EN_REG (DES_INTRPT_SRC_EN_REG)
//====================================================================

#define  CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_MASK 0xfffffff8
#define  CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT 3
#define  CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_MASK) >> CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT)
#define  CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_SRC_EN_REG_RESERVED1_SHIFT))

#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_MASK 0x4
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_SHIFT 2
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_MASK) >> CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_SHIFT)
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_SRC_EN_REG_ERROR2_SHIFT))

#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_MASK 0x2
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_SHIFT 1
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_MASK) >> CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_SHIFT)
#define  CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_SRC_EN_REG_ERROR1_SHIFT))

#define  CRYPT_DES_INTRPT_SRC_EN_REG_DONE_MASK 0x1
#define  CRYPT_DES_INTRPT_SRC_EN_REG_DONE_SHIFT 0
#define  CRYPT_DES_INTRPT_SRC_EN_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_INTRPT_SRC_EN_REG_DONE_MASK) >> CRYPT_DES_INTRPT_SRC_EN_REG_DONE_SHIFT)
#define  CRYPT_DES_INTRPT_SRC_EN_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_INTRPT_SRC_EN_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_DES_INTRPT_SRC_EN_REG_DONE_SHIFT))

//====================================================================
//Register: DES_STREAM_SIZE (DES_STREAM_SIZE)
/** \brief Incoming stream (segment) size (in Byte).
- The input data stream must be no less than 8 bytes.
- If the stream is divided to multiple segments (Resume Operation), all segments
must be multiple of 8 bytes. If the mode is not ECB, the last segment allowes
partial codeword.*/
//====================================================================

#define  CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_MASK 0xffffffff
#define  CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_SHIFT 0
#define  CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_MASK_SHIFT(reg) (((reg) & CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_MASK) >> CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_SHIFT)
#define  CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_MASK) | (((uint32_t)val) << CRYPT_DES_STREAM_SIZE_DES_STREAM_SIZE_SHIFT))

//====================================================================
//Register: RC4_CFG_REG (RC4_CFG_REG)
//====================================================================

#define  CRYPT_RC4_CFG_REG_RESERVED1_MASK 0xffffffe0
#define  CRYPT_RC4_CFG_REG_RESERVED1_SHIFT 5
#define  CRYPT_RC4_CFG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CFG_REG_RESERVED1_MASK) >> CRYPT_RC4_CFG_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_CFG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CFG_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_CFG_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_CFG_REG_KEYLEN_MASK 0x1f
#define  CRYPT_RC4_CFG_REG_KEYLEN_SHIFT 0
#define  CRYPT_RC4_CFG_REG_KEYLEN_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CFG_REG_KEYLEN_MASK) >> CRYPT_RC4_CFG_REG_KEYLEN_SHIFT)
#define  CRYPT_RC4_CFG_REG_KEYLEN_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CFG_REG_KEYLEN_MASK) | (((uint32_t)val) << CRYPT_RC4_CFG_REG_KEYLEN_SHIFT))

//====================================================================
//Register: RC4_CTRL_REG (RC4_CTRL_REG)
//====================================================================

#define  CRYPT_RC4_CTRL_REG_RESERVED1_MASK 0xfffffffc
#define  CRYPT_RC4_CTRL_REG_RESERVED1_SHIFT 2
#define  CRYPT_RC4_CTRL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CTRL_REG_RESERVED1_MASK) >> CRYPT_RC4_CTRL_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_CTRL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CTRL_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_CTRL_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_CTRL_REG_RESUME_MASK 0x2
#define  CRYPT_RC4_CTRL_REG_RESUME_SHIFT 1
#define  CRYPT_RC4_CTRL_REG_RESUME_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CTRL_REG_RESUME_MASK) >> CRYPT_RC4_CTRL_REG_RESUME_SHIFT)
#define  CRYPT_RC4_CTRL_REG_RESUME_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CTRL_REG_RESUME_MASK) | (((uint32_t)val) << CRYPT_RC4_CTRL_REG_RESUME_SHIFT))

#define  CRYPT_RC4_CTRL_REG_RESET_MASK 0x1
#define  CRYPT_RC4_CTRL_REG_RESET_SHIFT 0
#define  CRYPT_RC4_CTRL_REG_RESET_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CTRL_REG_RESET_MASK) >> CRYPT_RC4_CTRL_REG_RESET_SHIFT)
#define  CRYPT_RC4_CTRL_REG_RESET_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CTRL_REG_RESET_MASK) | (((uint32_t)val) << CRYPT_RC4_CTRL_REG_RESET_SHIFT))

//====================================================================
//Register: RC4_CMD_REG (RC4_CMD_REG)
//====================================================================

#define  CRYPT_RC4_CMD_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_RC4_CMD_REG_RESERVED1_SHIFT 1
#define  CRYPT_RC4_CMD_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CMD_REG_RESERVED1_MASK) >> CRYPT_RC4_CMD_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_CMD_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CMD_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_CMD_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_CMD_REG_START_MASK 0x1
#define  CRYPT_RC4_CMD_REG_START_SHIFT 0
#define  CRYPT_RC4_CMD_REG_START_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_CMD_REG_START_MASK) >> CRYPT_RC4_CMD_REG_START_SHIFT)
#define  CRYPT_RC4_CMD_REG_START_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_CMD_REG_START_MASK) | (((uint32_t)val) << CRYPT_RC4_CMD_REG_START_SHIFT))

//====================================================================
//Register: RC4_STATUS_REG (RC4_STATUS_REG)
//====================================================================

#define  CRYPT_RC4_STATUS_REG_RESERVED1_MASK 0xffffffe0
#define  CRYPT_RC4_STATUS_REG_RESERVED1_SHIFT 5
#define  CRYPT_RC4_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_STATUS_REG_RESERVED1_MASK) >> CRYPT_RC4_STATUS_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_STATUS_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_STATUS_REG_STATE_MASK 0x1e
#define  CRYPT_RC4_STATUS_REG_STATE_SHIFT 1
#define  CRYPT_RC4_STATUS_REG_STATE_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_STATUS_REG_STATE_MASK) >> CRYPT_RC4_STATUS_REG_STATE_SHIFT)
#define  CRYPT_RC4_STATUS_REG_STATE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_STATUS_REG_STATE_MASK) | (((uint32_t)val) << CRYPT_RC4_STATUS_REG_STATE_SHIFT))

#define  CRYPT_RC4_STATUS_REG_BUSY_MASK 0x1
#define  CRYPT_RC4_STATUS_REG_BUSY_SHIFT 0
#define  CRYPT_RC4_STATUS_REG_BUSY_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_STATUS_REG_BUSY_MASK) >> CRYPT_RC4_STATUS_REG_BUSY_SHIFT)
#define  CRYPT_RC4_STATUS_REG_BUSY_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_STATUS_REG_BUSY_MASK) | (((uint32_t)val) << CRYPT_RC4_STATUS_REG_BUSY_SHIFT))

//====================================================================
//Register: RC4_INTRPT_REG (RC4_INTRPT_REG)
/** \brief Interrupt signal can only be cleared by CPU.*/
//====================================================================

#define  CRYPT_RC4_INTRPT_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_RC4_INTRPT_REG_RESERVED1_SHIFT 1
#define  CRYPT_RC4_INTRPT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INTRPT_REG_RESERVED1_MASK) >> CRYPT_RC4_INTRPT_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_INTRPT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INTRPT_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_INTRPT_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_INTRPT_REG_DONE_MASK 0x1
#define  CRYPT_RC4_INTRPT_REG_DONE_SHIFT 0
#define  CRYPT_RC4_INTRPT_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INTRPT_REG_DONE_MASK) >> CRYPT_RC4_INTRPT_REG_DONE_SHIFT)
#define  CRYPT_RC4_INTRPT_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INTRPT_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_RC4_INTRPT_REG_DONE_SHIFT))

//====================================================================
//Register: RC4_INTRPT_SRC_EN_REG (RC4_INTRPT_SRC_EN_REG)
//====================================================================

#define  CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_MASK 0xfffffffe
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_SHIFT 1
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_MASK) >> CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_SHIFT)
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_INTRPT_SRC_EN_REG_RESERVED1_SHIFT))

#define  CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_MASK 0x1
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_SHIFT 0
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_MASK) >> CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_SHIFT)
#define  CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_MASK) | (((uint32_t)val) << CRYPT_RC4_INTRPT_SRC_EN_REG_DONE_SHIFT))

//====================================================================
//Register: RC4_STREAM_SIZE (RC4_STREAM_SIZE)
/** \brief Incoming stream (segment) size (in Byte).
- The input data stream must be no less than 1 bytes.
- If the stream is divided to multiple segments (Resume Operation), all segments
must be multiple of 4 bytes except the last segment which can be multiple of 1
byte*/
//====================================================================

#define  CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_MASK 0xffffffff
#define  CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_SHIFT 0
#define  CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_MASK) >> CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_SHIFT)
#define  CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_MASK) | (((uint32_t)val) << CRYPT_RC4_STREAM_SIZE_RC4_STREAM_SIZE_SHIFT))

//====================================================================
//Register: RC4_INDEX (RC4_INDEX)
//====================================================================

#define  CRYPT_RC4_INDEX_RESERVED1_MASK 0xffff0000
#define  CRYPT_RC4_INDEX_RESERVED1_SHIFT 16
#define  CRYPT_RC4_INDEX_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INDEX_RESERVED1_MASK) >> CRYPT_RC4_INDEX_RESERVED1_SHIFT)
#define  CRYPT_RC4_INDEX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INDEX_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_RC4_INDEX_RESERVED1_SHIFT))

#define  CRYPT_RC4_INDEX_INDEX_I_MASK 0xff00
#define  CRYPT_RC4_INDEX_INDEX_I_SHIFT 8
#define  CRYPT_RC4_INDEX_INDEX_I_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INDEX_INDEX_I_MASK) >> CRYPT_RC4_INDEX_INDEX_I_SHIFT)
#define  CRYPT_RC4_INDEX_INDEX_I_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INDEX_INDEX_I_MASK) | (((uint32_t)val) << CRYPT_RC4_INDEX_INDEX_I_SHIFT))

#define  CRYPT_RC4_INDEX_INDEX_J_MASK 0xff
#define  CRYPT_RC4_INDEX_INDEX_J_SHIFT 0
#define  CRYPT_RC4_INDEX_INDEX_J_MASK_SHIFT(reg) (((reg) & CRYPT_RC4_INDEX_INDEX_J_MASK) >> CRYPT_RC4_INDEX_INDEX_J_SHIFT)
#define  CRYPT_RC4_INDEX_INDEX_J_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_RC4_INDEX_INDEX_J_MASK) | (((uint32_t)val) << CRYPT_RC4_INDEX_INDEX_J_SHIFT))

//====================================================================
//Register: KEY2_WORD0 (KEY2_W0)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode)
- 128 Key Case
- AES Key2 [127:96]
- 192 Key Case
- AES Key2 [191:160]
- 256 Key Case
- AES Key2 [255:224]
*DES Engine*
- DES Key [63:32]
- TDES Key1 [63:32]
*RC4 Engine*
- RC4 Key (MSW)*/
//====================================================================

#define  CRYPT_KEY2_W0_KEY2_W0_MASK 0xffffffff
#define  CRYPT_KEY2_W0_KEY2_W0_SHIFT 0
#define  CRYPT_KEY2_W0_KEY2_W0_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W0_KEY2_W0_MASK) >> CRYPT_KEY2_W0_KEY2_W0_SHIFT)
#define  CRYPT_KEY2_W0_KEY2_W0_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W0_KEY2_W0_MASK) | (((uint32_t)val) << CRYPT_KEY2_W0_KEY2_W0_SHIFT))

//====================================================================
//Register: KEY2_WORD1 (KEY2_W1)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode):
- 128 Key Case
- AES Key2 [95:64]
- 192 Key Case
- AES Key2 [159:128]
- 256 Key Case
- AES Key2 [223:192]
<<b>>DES Engine <</b>>
- DES Key [31:00]
- TDES Key1 [31:00]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W1_KEY2_W1_MASK 0xffffffff
#define  CRYPT_KEY2_W1_KEY2_W1_SHIFT 0
#define  CRYPT_KEY2_W1_KEY2_W1_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W1_KEY2_W1_MASK) >> CRYPT_KEY2_W1_KEY2_W1_SHIFT)
#define  CRYPT_KEY2_W1_KEY2_W1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W1_KEY2_W1_MASK) | (((uint32_t)val) << CRYPT_KEY2_W1_KEY2_W1_SHIFT))

//====================================================================
//Register: KEY2_WORD2 (KEY2_W2)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode):
- 128 Key Case
- AES Key2 [63:32]
- 192 Key Case
- AES Key2 [127:96]
- 256 Key Case
- AES Key2 [191:160]
<<b>>DES Engine <</b>>
- TDES Key2 [63:32]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W2_KEY2_W2_MASK 0xffffffff
#define  CRYPT_KEY2_W2_KEY2_W2_SHIFT 0
#define  CRYPT_KEY2_W2_KEY2_W2_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W2_KEY2_W2_MASK) >> CRYPT_KEY2_W2_KEY2_W2_SHIFT)
#define  CRYPT_KEY2_W2_KEY2_W2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W2_KEY2_W2_MASK) | (((uint32_t)val) << CRYPT_KEY2_W2_KEY2_W2_SHIFT))

//====================================================================
//Register: KEY2_WORD3 (KEY2_W3)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode):
- 128 Key Case
- AES Key2 [31:00]
- 192 Key Case
- AES Key2 [95:64]
- 256 Key Case
- AES Key2 [159:128]
<<b>>DES Engine <</b>>
- TDES Key2 [31:00]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W3_KEY2_W3_MASK 0xffffffff
#define  CRYPT_KEY2_W3_KEY2_W3_SHIFT 0
#define  CRYPT_KEY2_W3_KEY2_W3_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W3_KEY2_W3_MASK) >> CRYPT_KEY2_W3_KEY2_W3_SHIFT)
#define  CRYPT_KEY2_W3_KEY2_W3_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W3_KEY2_W3_MASK) | (((uint32_t)val) << CRYPT_KEY2_W3_KEY2_W3_SHIFT))

//====================================================================
//Register: KEY2_WORD4 (KEY2_W4)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode):
- 192 Key Case
- AES Key2 [63:32]
- 256 Key Case
- AES Key2 [127:96]
<<b>>DES Engine <</b>>
- TDES Key3 [63:32]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W4_KEY2_W4_MASK 0xffffffff
#define  CRYPT_KEY2_W4_KEY2_W4_SHIFT 0
#define  CRYPT_KEY2_W4_KEY2_W4_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W4_KEY2_W4_MASK) >> CRYPT_KEY2_W4_KEY2_W4_SHIFT)
#define  CRYPT_KEY2_W4_KEY2_W4_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W4_KEY2_W4_MASK) | (((uint32_t)val) << CRYPT_KEY2_W4_KEY2_W4_SHIFT))

//====================================================================
//Register: KEY2_WORD5 (KEY2_W5)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>(XTS Mode):
- 192 Key Case
- AES Key2 [31:00]
- 256 Key Case
- AES Key2 [95:64]
<<b>>DES Engine <</b>>
- TDES Key3 [31:00]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W5_KEY2_W5_MASK 0xffffffff
#define  CRYPT_KEY2_W5_KEY2_W5_SHIFT 0
#define  CRYPT_KEY2_W5_KEY2_W5_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W5_KEY2_W5_MASK) >> CRYPT_KEY2_W5_KEY2_W5_SHIFT)
#define  CRYPT_KEY2_W5_KEY2_W5_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W5_KEY2_W5_MASK) | (((uint32_t)val) << CRYPT_KEY2_W5_KEY2_W5_SHIFT))

//====================================================================
//Register: KEY2_WORD6 (KEY2_W6)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>( XTS Mode 256 Key Case):
- AES Key2 [63:32]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W6_KEY2_W6_MASK 0xffffffff
#define  CRYPT_KEY2_W6_KEY2_W6_SHIFT 0
#define  CRYPT_KEY2_W6_KEY2_W6_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W6_KEY2_W6_MASK) >> CRYPT_KEY2_W6_KEY2_W6_SHIFT)
#define  CRYPT_KEY2_W6_KEY2_W6_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W6_KEY2_W6_MASK) | (((uint32_t)val) << CRYPT_KEY2_W6_KEY2_W6_SHIFT))

//====================================================================
//Register: KEY2_WORD7 (KEY2_W7)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine <</b>>( XTS Mode 256 Key Case):
- AES Key2 [31:00]
<<b>>RC4 Engine <</b>>
- RC4 Key*/
//====================================================================

#define  CRYPT_KEY2_W7_KEY2_W7_MASK 0xffffffff
#define  CRYPT_KEY2_W7_KEY2_W7_SHIFT 0
#define  CRYPT_KEY2_W7_KEY2_W7_MASK_SHIFT(reg) (((reg) & CRYPT_KEY2_W7_KEY2_W7_MASK) >> CRYPT_KEY2_W7_KEY2_W7_SHIFT)
#define  CRYPT_KEY2_W7_KEY2_W7_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY2_W7_KEY2_W7_MASK) | (((uint32_t)val) << CRYPT_KEY2_W7_KEY2_W7_SHIFT))

//====================================================================
//Register: KEY1_WORD0 (KEY1_W0)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 128 Key Case
- AES Key1 [127:96] (Normal operation)
- AES Last Round Key [127:96] (Resume Decrypt operation)
- 192 Key Case:
- AES Key1 [191:160] (Normal operation)
- AES Last Round Key [191:160] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [255:224] (Normal operation)
- AES Last Round Key [255:224] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W0_KEY1_W0_MASK 0xffffffff
#define  CRYPT_KEY1_W0_KEY1_W0_SHIFT 0
#define  CRYPT_KEY1_W0_KEY1_W0_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W0_KEY1_W0_MASK) >> CRYPT_KEY1_W0_KEY1_W0_SHIFT)
#define  CRYPT_KEY1_W0_KEY1_W0_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W0_KEY1_W0_MASK) | (((uint32_t)val) << CRYPT_KEY1_W0_KEY1_W0_SHIFT))

//====================================================================
//Register: KEY1_WORD1 (KEY1_W1)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 128 Key Case
- AES Key1 [95:64] (Normal operation)
- AES Last Round Key [95:64] (Resume Decrypt operation)
- 192 Key Case:
- AES Key1 [159:128] (Normal operation)
- AES Last Round Key [159:128] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [223:192] (Normal operation)
- AES Last Round Key [223:192] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W1_KEY1_W1_MASK 0xffffffff
#define  CRYPT_KEY1_W1_KEY1_W1_SHIFT 0
#define  CRYPT_KEY1_W1_KEY1_W1_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W1_KEY1_W1_MASK) >> CRYPT_KEY1_W1_KEY1_W1_SHIFT)
#define  CRYPT_KEY1_W1_KEY1_W1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W1_KEY1_W1_MASK) | (((uint32_t)val) << CRYPT_KEY1_W1_KEY1_W1_SHIFT))

//====================================================================
//Register: KEY1_WORD2 (KEY1_W2)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 128 Key Case
- AES Key1 [63:32] (Normal operation)
- AES Last Round Key [63:32] (Resume Decrypt operation)
- 192 Key Case:
- AES Key1 [127:96] (Normal operation)
- AES Last Round Key [127:96] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [191:160] (Normal operation)
- AES Last Round Key [191:160] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W2_KEY1_W2_MASK 0xffffffff
#define  CRYPT_KEY1_W2_KEY1_W2_SHIFT 0
#define  CRYPT_KEY1_W2_KEY1_W2_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W2_KEY1_W2_MASK) >> CRYPT_KEY1_W2_KEY1_W2_SHIFT)
#define  CRYPT_KEY1_W2_KEY1_W2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W2_KEY1_W2_MASK) | (((uint32_t)val) << CRYPT_KEY1_W2_KEY1_W2_SHIFT))

//====================================================================
//Register: KEY1_WORD3 (KEY1_W3)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 128 Key Case
- AES Key1 [31:00] (Normal operation)
- AES Last Round Key [31:00] (Resume Decrypt operation)
- 192 Key Case:
- AES Key1 [95:64] (Normal operation)
- AES Last Round Key [95:64] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [159:128] (Normal operation)
- AES Last Round Key [159:128] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W3_KEY1_W3_MASK 0xffffffff
#define  CRYPT_KEY1_W3_KEY1_W3_SHIFT 0
#define  CRYPT_KEY1_W3_KEY1_W3_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W3_KEY1_W3_MASK) >> CRYPT_KEY1_W3_KEY1_W3_SHIFT)
#define  CRYPT_KEY1_W3_KEY1_W3_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W3_KEY1_W3_MASK) | (((uint32_t)val) << CRYPT_KEY1_W3_KEY1_W3_SHIFT))

//====================================================================
//Register: KEY1_WORD4 (KEY1_W4)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 192 Key Case:
- AES Key1 [63:32] (Normal operation)
- AES Last Round Key [63:32] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [127:96] (Normal operation)
- AES Last Round Key [127:96] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W4_KEY1_W4_MASK 0xffffffff
#define  CRYPT_KEY1_W4_KEY1_W4_SHIFT 0
#define  CRYPT_KEY1_W4_KEY1_W4_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W4_KEY1_W4_MASK) >> CRYPT_KEY1_W4_KEY1_W4_SHIFT)
#define  CRYPT_KEY1_W4_KEY1_W4_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W4_KEY1_W4_MASK) | (((uint32_t)val) << CRYPT_KEY1_W4_KEY1_W4_SHIFT))

//====================================================================
//Register: KEY1_WORD5 (KEY1_W5)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>
- 192 Key Case:
- AES Key1 [31:00] (Normal operation)
- AES Last Round Key [31:00] (Resume Decrypt operation)
- 256 Key Case:
- AES Key1 [95:64] (Normal operation)
- AES Last Round Key [95:64] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W5_KEY1_W5_MASK 0xffffffff
#define  CRYPT_KEY1_W5_KEY1_W5_SHIFT 0
#define  CRYPT_KEY1_W5_KEY1_W5_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W5_KEY1_W5_MASK) >> CRYPT_KEY1_W5_KEY1_W5_SHIFT)
#define  CRYPT_KEY1_W5_KEY1_W5_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W5_KEY1_W5_MASK) | (((uint32_t)val) << CRYPT_KEY1_W5_KEY1_W5_SHIFT))

//====================================================================
//Register: KEY1_WORD6 (KEY1_W6)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>(256 Key Case):
- AES Key1 [63:32] (Normal operation)
- AES Last Round Key [63:32] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W6_KEY1_W6_MASK 0xffffffff
#define  CRYPT_KEY1_W6_KEY1_W6_SHIFT 0
#define  CRYPT_KEY1_W6_KEY1_W6_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W6_KEY1_W6_MASK) >> CRYPT_KEY1_W6_KEY1_W6_SHIFT)
#define  CRYPT_KEY1_W6_KEY1_W6_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W6_KEY1_W6_MASK) | (((uint32_t)val) << CRYPT_KEY1_W6_KEY1_W6_SHIFT))

//====================================================================
//Register: KEY1_WORD7 (KEY1_W7)
/** \brief Data is in Byte-Little Endian format
<<b>>AES Engine Only <</b>>(256 Key Case):
- AES Key1 [31:00] (Normal operation)
- AES Last Round Key [31:00] (Resume Decrypt operation)*/
//====================================================================

#define  CRYPT_KEY1_W7_KEY1_W7_MASK 0xffffffff
#define  CRYPT_KEY1_W7_KEY1_W7_SHIFT 0
#define  CRYPT_KEY1_W7_KEY1_W7_MASK_SHIFT(reg) (((reg) & CRYPT_KEY1_W7_KEY1_W7_MASK) >> CRYPT_KEY1_W7_KEY1_W7_SHIFT)
#define  CRYPT_KEY1_W7_KEY1_W7_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_KEY1_W7_KEY1_W7_MASK) | (((uint32_t)val) << CRYPT_KEY1_W7_KEY1_W7_SHIFT))

//====================================================================
//Register: IV_WORD0 (IV_W0)
/** \brief Data is in Byte-Little Endian format
*AES Engine*
- Key Wrap Mode
- Wrapping: Given IV [63:32] from user.
- Unwrapping: Saved IV[63:32] from Wrapping.
- Other Modes
- IV[127:96]
*DES Engine*
- IV[63:00]*/
//====================================================================

#define  CRYPT_IV_W0_IV_W0_MASK 0xffffffff
#define  CRYPT_IV_W0_IV_W0_SHIFT 0
#define  CRYPT_IV_W0_IV_W0_MASK_SHIFT(reg) (((reg) & CRYPT_IV_W0_IV_W0_MASK) >> CRYPT_IV_W0_IV_W0_SHIFT)
#define  CRYPT_IV_W0_IV_W0_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_IV_W0_IV_W0_MASK) | (((uint32_t)val) << CRYPT_IV_W0_IV_W0_SHIFT))

//====================================================================
//Register: IV_WORD1 (IV_W1)
/** \brief Data is in Byte-Little Endian format
*AES Engine*
- Key Wrap Mode
- Wrapping: Given IV [31:00] from user.
- Unwrapping: Saved IV[31:00] from Wrapping.
- Other Modes
- IV[95:64]
*DES Engine*
- IV[31:00]*/
//====================================================================

#define  CRYPT_IV_W1_IV_W1_MASK 0xffffffff
#define  CRYPT_IV_W1_IV_W1_SHIFT 0
#define  CRYPT_IV_W1_IV_W1_MASK_SHIFT(reg) (((reg) & CRYPT_IV_W1_IV_W1_MASK) >> CRYPT_IV_W1_IV_W1_SHIFT)
#define  CRYPT_IV_W1_IV_W1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_IV_W1_IV_W1_MASK) | (((uint32_t)val) << CRYPT_IV_W1_IV_W1_SHIFT))

//====================================================================
//Register: IV_WORD2 (IV_W2)
/** \brief Data is in Byte-Little Endian format
*AES Engine Only*
- Key Wrap Mode
- Counter value [63:32]. It will be set up automatically once AES starts the
task.
- Other Modes
- IV[63:32]*/
//====================================================================

#define  CRYPT_IV_W2_IV_W2_MASK 0xffffffff
#define  CRYPT_IV_W2_IV_W2_SHIFT 0
#define  CRYPT_IV_W2_IV_W2_MASK_SHIFT(reg) (((reg) & CRYPT_IV_W2_IV_W2_MASK) >> CRYPT_IV_W2_IV_W2_SHIFT)
#define  CRYPT_IV_W2_IV_W2_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_IV_W2_IV_W2_MASK) | (((uint32_t)val) << CRYPT_IV_W2_IV_W2_SHIFT))

//====================================================================
//Register: IV_WORD3 (IV_W3)
/** \brief Data is in Byte-Little Endian format
*AES Engine Only*
- Key Wrap Mode
- Counter value [31:00]. It will be set up automatically once AES starts the
task.
- Other Modes
- IV[31:00]*/
//====================================================================

#define  CRYPT_IV_W3_IV_W3_MASK 0xffffffff
#define  CRYPT_IV_W3_IV_W3_SHIFT 0
#define  CRYPT_IV_W3_IV_W3_MASK_SHIFT(reg) (((reg) & CRYPT_IV_W3_IV_W3_MASK) >> CRYPT_IV_W3_IV_W3_SHIFT)
#define  CRYPT_IV_W3_IV_W3_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_IV_W3_IV_W3_MASK) | (((uint32_t)val) << CRYPT_IV_W3_IV_W3_SHIFT))

//====================================================================
//Register: ENGINE_SELECT_REG (ENGINE_SELECT_REG)
//====================================================================

#define  CRYPT_ENGINE_SELECT_REG_RESERVED1_MASK 0xfffffffc
#define  CRYPT_ENGINE_SELECT_REG_RESERVED1_SHIFT 2
#define  CRYPT_ENGINE_SELECT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & CRYPT_ENGINE_SELECT_REG_RESERVED1_MASK) >> CRYPT_ENGINE_SELECT_REG_RESERVED1_SHIFT)
#define  CRYPT_ENGINE_SELECT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_ENGINE_SELECT_REG_RESERVED1_MASK) | (((uint32_t)val) << CRYPT_ENGINE_SELECT_REG_RESERVED1_SHIFT))

#define  CRYPT_ENGINE_SELECT_REG_SELECT_MASK 0x3
#define  CRYPT_ENGINE_SELECT_REG_SELECT_SHIFT 0
#define  CRYPT_ENGINE_SELECT_REG_SELECT_MASK_SHIFT(reg) (((reg) & CRYPT_ENGINE_SELECT_REG_SELECT_MASK) >> CRYPT_ENGINE_SELECT_REG_SELECT_SHIFT)
#define  CRYPT_ENGINE_SELECT_REG_SELECT_REPLACE_VAL(reg,val) (((reg) & ~CRYPT_ENGINE_SELECT_REG_SELECT_MASK) | (((uint32_t)val) << CRYPT_ENGINE_SELECT_REG_SELECT_SHIFT))

//====================================================================
//
//Register File: HASH-MAC Engine Control Registers (HASH)
//
//====================================================================

//====================================================================
//Register: Hash Configuration (Hash_Configure)
/** \brief This register is used to configure Hash engine.*/
//====================================================================

#define  HASH_HASH_CONFIGURE_RESERVED1_MASK 0xffffffe0
#define  HASH_HASH_CONFIGURE_RESERVED1_SHIFT 5
#define  HASH_HASH_CONFIGURE_RESERVED1_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONFIGURE_RESERVED1_MASK) >> HASH_HASH_CONFIGURE_RESERVED1_SHIFT)
#define  HASH_HASH_CONFIGURE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONFIGURE_RESERVED1_MASK) | (((uint32_t)val) << HASH_HASH_CONFIGURE_RESERVED1_SHIFT))

#define  HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_MASK 0x10
#define  HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_SHIFT 4
#define  HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_MASK) >> HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_SHIFT)
#define  HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_MASK) | (((uint32_t)val) << HASH_HASH_CONFIGURE_OUTPUT_DATA_MODE_SHIFT))

#define  HASH_HASH_CONFIGURE_HASH_MODE_MASK 0x8
#define  HASH_HASH_CONFIGURE_HASH_MODE_SHIFT 3
#define  HASH_HASH_CONFIGURE_HASH_MODE_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONFIGURE_HASH_MODE_MASK) >> HASH_HASH_CONFIGURE_HASH_MODE_SHIFT)
#define  HASH_HASH_CONFIGURE_HASH_MODE_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONFIGURE_HASH_MODE_MASK) | (((uint32_t)val) << HASH_HASH_CONFIGURE_HASH_MODE_SHIFT))

#define  HASH_HASH_CONFIGURE_ALG_SELECT_MASK 0x7
#define  HASH_HASH_CONFIGURE_ALG_SELECT_SHIFT 0
#define  HASH_HASH_CONFIGURE_ALG_SELECT_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONFIGURE_ALG_SELECT_MASK) >> HASH_HASH_CONFIGURE_ALG_SELECT_SHIFT)
#define  HASH_HASH_CONFIGURE_ALG_SELECT_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONFIGURE_ALG_SELECT_MASK) | (((uint32_t)val) << HASH_HASH_CONFIGURE_ALG_SELECT_SHIFT))

//====================================================================
//Register: Hash Control (Hash_control)
/** \brief Set control for each Hash operation.*/
//====================================================================

#define  HASH_HASH_CONTROL_RESERVED1_MASK 0xfffffff0
#define  HASH_HASH_CONTROL_RESERVED1_SHIFT 4
#define  HASH_HASH_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONTROL_RESERVED1_MASK) >> HASH_HASH_CONTROL_RESERVED1_SHIFT)
#define  HASH_HASH_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << HASH_HASH_CONTROL_RESERVED1_SHIFT))

#define  HASH_HASH_CONTROL_RESET_MASK 0x8
#define  HASH_HASH_CONTROL_RESET_SHIFT 3
#define  HASH_HASH_CONTROL_RESET_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONTROL_RESET_MASK) >> HASH_HASH_CONTROL_RESET_SHIFT)
#define  HASH_HASH_CONTROL_RESET_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONTROL_RESET_MASK) | (((uint32_t)val) << HASH_HASH_CONTROL_RESET_SHIFT))

#define  HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_MASK 0x4
#define  HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_SHIFT 2
#define  HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_MASK) >> HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_SHIFT)
#define  HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_MASK) | (((uint32_t)val) << HASH_HASH_CONTROL_HARDWARE_PADDED_REQUIRED_SHIFT))

#define  HASH_HASH_CONTROL_HASH_OP_MODE_MASK 0x3
#define  HASH_HASH_CONTROL_HASH_OP_MODE_SHIFT 0
#define  HASH_HASH_CONTROL_HASH_OP_MODE_MASK_SHIFT(reg) (((reg) & HASH_HASH_CONTROL_HASH_OP_MODE_MASK) >> HASH_HASH_CONTROL_HASH_OP_MODE_SHIFT)
#define  HASH_HASH_CONTROL_HASH_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_CONTROL_HASH_OP_MODE_MASK) | (((uint32_t)val) << HASH_HASH_CONTROL_HASH_OP_MODE_SHIFT))

//====================================================================
//Register: Hash Command (Hash_Command)
/** \brief Set command to Hash Engine.*/
//====================================================================

#define  HASH_HASH_COMMAND_RESERVED1_MASK 0xfffffffe
#define  HASH_HASH_COMMAND_RESERVED1_SHIFT 1
#define  HASH_HASH_COMMAND_RESERVED1_MASK_SHIFT(reg) (((reg) & HASH_HASH_COMMAND_RESERVED1_MASK) >> HASH_HASH_COMMAND_RESERVED1_SHIFT)
#define  HASH_HASH_COMMAND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_COMMAND_RESERVED1_MASK) | (((uint32_t)val) << HASH_HASH_COMMAND_RESERVED1_SHIFT))

#define  HASH_HASH_COMMAND_COM_START_MASK 0x1
#define  HASH_HASH_COMMAND_COM_START_SHIFT 0
#define  HASH_HASH_COMMAND_COM_START_MASK_SHIFT(reg) (((reg) & HASH_HASH_COMMAND_COM_START_MASK) >> HASH_HASH_COMMAND_COM_START_SHIFT)
#define  HASH_HASH_COMMAND_COM_START_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_COMMAND_COM_START_MASK) | (((uint32_t)val) << HASH_HASH_COMMAND_COM_START_SHIFT))

//====================================================================
//Register: Hash Status (Hash_Status)
/** \brief This register holds status from last hash operation.*/
//====================================================================

#define  HASH_HASH_STATUS_RESERVED1_MASK 0xfffffff0
#define  HASH_HASH_STATUS_RESERVED1_SHIFT 4
#define  HASH_HASH_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & HASH_HASH_STATUS_RESERVED1_MASK) >> HASH_HASH_STATUS_RESERVED1_SHIFT)
#define  HASH_HASH_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_STATUS_RESERVED1_MASK) | (((uint32_t)val) << HASH_HASH_STATUS_RESERVED1_SHIFT))

#define  HASH_HASH_STATUS_HMAC_SM_BUSY_MASK 0x8
#define  HASH_HASH_STATUS_HMAC_SM_BUSY_SHIFT 3
#define  HASH_HASH_STATUS_HMAC_SM_BUSY_MASK_SHIFT(reg) (((reg) & HASH_HASH_STATUS_HMAC_SM_BUSY_MASK) >> HASH_HASH_STATUS_HMAC_SM_BUSY_SHIFT)
#define  HASH_HASH_STATUS_HMAC_SM_BUSY_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_STATUS_HMAC_SM_BUSY_MASK) | (((uint32_t)val) << HASH_HASH_STATUS_HMAC_SM_BUSY_SHIFT))

#define  HASH_HASH_STATUS_XFER_SM_BUSY_MASK 0x4
#define  HASH_HASH_STATUS_XFER_SM_BUSY_SHIFT 2
#define  HASH_HASH_STATUS_XFER_SM_BUSY_MASK_SHIFT(reg) (((reg) & HASH_HASH_STATUS_XFER_SM_BUSY_MASK) >> HASH_HASH_STATUS_XFER_SM_BUSY_SHIFT)
#define  HASH_HASH_STATUS_XFER_SM_BUSY_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_STATUS_XFER_SM_BUSY_MASK) | (((uint32_t)val) << HASH_HASH_STATUS_XFER_SM_BUSY_SHIFT))

#define  HASH_HASH_STATUS_HASH_BUSY_MASK 0x2
#define  HASH_HASH_STATUS_HASH_BUSY_SHIFT 1
#define  HASH_HASH_STATUS_HASH_BUSY_MASK_SHIFT(reg) (((reg) & HASH_HASH_STATUS_HASH_BUSY_MASK) >> HASH_HASH_STATUS_HASH_BUSY_SHIFT)
#define  HASH_HASH_STATUS_HASH_BUSY_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_STATUS_HASH_BUSY_MASK) | (((uint32_t)val) << HASH_HASH_STATUS_HASH_BUSY_SHIFT))

#define  HASH_HASH_STATUS_HASH_DONE_MASK 0x1
#define  HASH_HASH_STATUS_HASH_DONE_SHIFT 0
#define  HASH_HASH_STATUS_HASH_DONE_MASK_SHIFT(reg) (((reg) & HASH_HASH_STATUS_HASH_DONE_MASK) >> HASH_HASH_STATUS_HASH_DONE_SHIFT)
#define  HASH_HASH_STATUS_HASH_DONE_REPLACE_VAL(reg,val) (((reg) & ~HASH_HASH_STATUS_HASH_DONE_MASK) | (((uint32_t)val) << HASH_HASH_STATUS_HASH_DONE_SHIFT))

//====================================================================
//Register: Incoming Message Segment Size Word (incoming_segment_size)
/** \brief This register is incoming message segment size for the next hash operation.
Size unit is byte. This is data transfer size for next hash operation.*/
//====================================================================

#define  HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_MASK 0xffffffff
#define  HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_SHIFT 0
#define  HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_MASK_SHIFT(reg) (((reg) & HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_MASK) >> HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_SHIFT)
#define  HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_REPLACE_VAL(reg,val) (((reg) & ~HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_MASK) | (((uint32_t)val) << HASH_INCOMING_SEGMENT_SIZE_INCOMING_SEGMENT_SIZE_SHIFT))

//====================================================================
//Register: Total Message Size Low Word (total_message_size_low)
/** \brief This register holds the total length of message (lower 32bit). Size unit is
byte. Need set this register when hardware padding required.*/
//====================================================================

#define  HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_MASK 0xffffffff
#define  HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_SHIFT 0
#define  HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_MASK_SHIFT(reg) (((reg) & HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_MASK) >> HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_SHIFT)
#define  HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_REPLACE_VAL(reg,val) (((reg) & ~HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_MASK) | (((uint32_t)val) << HASH_TOTAL_MESSAGE_SIZE_LOW_TOTAL_MESSAGE_SIZE_LOW_SHIFT))

//====================================================================
//Register: Total Message Size High Word (total_message_size_high)
/** \brief This register holds the total length of message (Upper 32bit). Size unit is
byte. Need set this register when hardware padding required.*/
//====================================================================

#define  HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_MASK 0xffffffff
#define  HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_SHIFT 0
#define  HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_MASK_SHIFT(reg) (((reg) & HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_MASK) >> HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_SHIFT)
#define  HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_MASK) | (((uint32_t)val) << HASH_TOTAL_MESSAGE_SIZE_HIGH_TOTAL_MESSAGE_SIZE_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context A (digest_context_A)
/** \brief Hash digest or context A value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_SHIFT 0
#define  HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_MASK) >> HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_SHIFT)
#define  HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_A_DIGEST_CONTEXT_A_SHIFT))

//====================================================================
//Register: Hash Digest and context B (digest_context_B)
/** \brief Hash digest or context B value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_SHIFT 0
#define  HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_MASK) >> HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_SHIFT)
#define  HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_B_DIGEST_CONTEXT_B_SHIFT))

//====================================================================
//Register: Hash Digest and context C (digest_context_C)
/** \brief Hash digest or context C value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_SHIFT 0
#define  HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_MASK) >> HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_SHIFT)
#define  HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_C_DIGEST_CONTEXT_C_SHIFT))

//====================================================================
//Register: Hash Digest and context D (digest_context_D)
/** \brief Hash digest or context D value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_SHIFT 0
#define  HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_MASK) >> HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_SHIFT)
#define  HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_D_DIGEST_CONTEXT_D_SHIFT))

//====================================================================
//Register: Hash Digest and context E (digest_context_E)
/** \brief Hash digest or context E value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_SHIFT 0
#define  HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_MASK) >> HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_SHIFT)
#define  HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_E_DIGEST_CONTEXT_E_SHIFT))

//====================================================================
//Register: Hash Digest and context F (digest_context_F)
/** \brief Hash digest or context F value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_SHIFT 0
#define  HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_MASK) >> HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_SHIFT)
#define  HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_F_DIGEST_CONTEXT_F_SHIFT))

//====================================================================
//Register: Hash Digest and context G (digest_context_G)
/** \brief Hash digest or context G value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_SHIFT 0
#define  HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_MASK) >> HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_SHIFT)
#define  HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_G_DIGEST_CONTEXT_G_SHIFT))

//====================================================================
//Register: Hash Digest and context H (digest_context_H)
/** \brief Hash digest or context H value based on the operation. If the operation is
last part of message, this register holds the digest of the message. If the
operation is middle message segment, this register is context of the
message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_SHIFT 0
#define  HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_MASK) >> HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_SHIFT)
#define  HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_H_DIGEST_CONTEXT_H_SHIFT))

//====================================================================
//Register: Hash Digest and context A High Word (digest_context_A_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context A value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_MASK) >> HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_A_HIGH_DIGEST_CONTEXT_A_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context B High Word (digest_context_B_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context B value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_MASK) >> HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_B_HIGH_DIGEST_CONTEXT_B_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context C High Word (digest_context_C_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context C value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_MASK) >> HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_C_HIGH_DIGEST_CONTEXT_C_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context D High Word (digest_context_D_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context D value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_MASK) >> HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_D_HIGH_DIGEST_CONTEXT_D_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context E High Word (digest_context_E_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context E value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_MASK) >> HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_E_HIGH_DIGEST_CONTEXT_E_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context F High Word (digest_context_F_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context F value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_MASK) >> HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_F_HIGH_DIGEST_CONTEXT_F_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context G High Word (digest_context_G_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context G value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_MASK) >> HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_G_HIGH_DIGEST_CONTEXT_G_HIGH_SHIFT))

//====================================================================
//Register: Hash Digest and context H High Word (digest_context_H_HIGH)
/** \brief The high word of the SHA512 and SHA384 digest or context H value. If the
operation is last part of message, this register holds the digest of the
message. If the operation is middle message segment, this register is
context of the message.*/
//====================================================================

#define  HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_MASK 0xffffffff
#define  HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_SHIFT 0
#define  HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_MASK_SHIFT(reg) (((reg) & HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_MASK) >> HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_SHIFT)
#define  HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_MASK) | (((uint32_t)val) << HASH_DIGEST_CONTEXT_H_HIGH_DIGEST_CONTEXT_H_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto A (contexto_A)
/** \brief HMAC operation contexto A value.*/
//====================================================================

#define  HASH_CONTEXTO_A_CONTEXTO_A_MASK 0xffffffff
#define  HASH_CONTEXTO_A_CONTEXTO_A_SHIFT 0
#define  HASH_CONTEXTO_A_CONTEXTO_A_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_A_CONTEXTO_A_MASK) >> HASH_CONTEXTO_A_CONTEXTO_A_SHIFT)
#define  HASH_CONTEXTO_A_CONTEXTO_A_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_A_CONTEXTO_A_MASK) | (((uint32_t)val) << HASH_CONTEXTO_A_CONTEXTO_A_SHIFT))

//====================================================================
//Register: HMAC Contexto B (contexto_B)
/** \brief HMAC operation contexto B value.*/
//====================================================================

#define  HASH_CONTEXTO_B_CONTEXTO_B_MASK 0xffffffff
#define  HASH_CONTEXTO_B_CONTEXTO_B_SHIFT 0
#define  HASH_CONTEXTO_B_CONTEXTO_B_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_B_CONTEXTO_B_MASK) >> HASH_CONTEXTO_B_CONTEXTO_B_SHIFT)
#define  HASH_CONTEXTO_B_CONTEXTO_B_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_B_CONTEXTO_B_MASK) | (((uint32_t)val) << HASH_CONTEXTO_B_CONTEXTO_B_SHIFT))

//====================================================================
//Register: HMAC Contexto C (contexto_C)
/** \brief HMAC operation contexto C value.*/
//====================================================================

#define  HASH_CONTEXTO_C_CONTEXTO_C_MASK 0xffffffff
#define  HASH_CONTEXTO_C_CONTEXTO_C_SHIFT 0
#define  HASH_CONTEXTO_C_CONTEXTO_C_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_C_CONTEXTO_C_MASK) >> HASH_CONTEXTO_C_CONTEXTO_C_SHIFT)
#define  HASH_CONTEXTO_C_CONTEXTO_C_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_C_CONTEXTO_C_MASK) | (((uint32_t)val) << HASH_CONTEXTO_C_CONTEXTO_C_SHIFT))

//====================================================================
//Register: HMAC Contexto D (contexto_D)
/** \brief HMAC operation contexto D value.*/
//====================================================================

#define  HASH_CONTEXTO_D_CONTEXTO_D_MASK 0xffffffff
#define  HASH_CONTEXTO_D_CONTEXTO_D_SHIFT 0
#define  HASH_CONTEXTO_D_CONTEXTO_D_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_D_CONTEXTO_D_MASK) >> HASH_CONTEXTO_D_CONTEXTO_D_SHIFT)
#define  HASH_CONTEXTO_D_CONTEXTO_D_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_D_CONTEXTO_D_MASK) | (((uint32_t)val) << HASH_CONTEXTO_D_CONTEXTO_D_SHIFT))

//====================================================================
//Register: HMAC Contexto E (contexto_E)
/** \brief HMAC operation contexto E value.*/
//====================================================================

#define  HASH_CONTEXTO_E_CONTEXTO_E_MASK 0xffffffff
#define  HASH_CONTEXTO_E_CONTEXTO_E_SHIFT 0
#define  HASH_CONTEXTO_E_CONTEXTO_E_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_E_CONTEXTO_E_MASK) >> HASH_CONTEXTO_E_CONTEXTO_E_SHIFT)
#define  HASH_CONTEXTO_E_CONTEXTO_E_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_E_CONTEXTO_E_MASK) | (((uint32_t)val) << HASH_CONTEXTO_E_CONTEXTO_E_SHIFT))

//====================================================================
//Register: HMAC Contexto F (contexto_F)
/** \brief HMAC operation contexto F value.*/
//====================================================================

#define  HASH_CONTEXTO_F_CONTEXTO_F_MASK 0xffffffff
#define  HASH_CONTEXTO_F_CONTEXTO_F_SHIFT 0
#define  HASH_CONTEXTO_F_CONTEXTO_F_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_F_CONTEXTO_F_MASK) >> HASH_CONTEXTO_F_CONTEXTO_F_SHIFT)
#define  HASH_CONTEXTO_F_CONTEXTO_F_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_F_CONTEXTO_F_MASK) | (((uint32_t)val) << HASH_CONTEXTO_F_CONTEXTO_F_SHIFT))

//====================================================================
//Register: HMAC Contexto G (contexto_G)
/** \brief HMAC operation contexto G value.*/
//====================================================================

#define  HASH_CONTEXTO_G_CONTEXTO_G_MASK 0xffffffff
#define  HASH_CONTEXTO_G_CONTEXTO_G_SHIFT 0
#define  HASH_CONTEXTO_G_CONTEXTO_G_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_G_CONTEXTO_G_MASK) >> HASH_CONTEXTO_G_CONTEXTO_G_SHIFT)
#define  HASH_CONTEXTO_G_CONTEXTO_G_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_G_CONTEXTO_G_MASK) | (((uint32_t)val) << HASH_CONTEXTO_G_CONTEXTO_G_SHIFT))

//====================================================================
//Register: HMAC Contexto H (contexto_H)
/** \brief HMAC operation contexto H value.*/
//====================================================================

#define  HASH_CONTEXTO_H_CONTEXTO_H_MASK 0xffffffff
#define  HASH_CONTEXTO_H_CONTEXTO_H_SHIFT 0
#define  HASH_CONTEXTO_H_CONTEXTO_H_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_H_CONTEXTO_H_MASK) >> HASH_CONTEXTO_H_CONTEXTO_H_SHIFT)
#define  HASH_CONTEXTO_H_CONTEXTO_H_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_H_CONTEXTO_H_MASK) | (((uint32_t)val) << HASH_CONTEXTO_H_CONTEXTO_H_SHIFT))

//====================================================================
//Register: HMAC Contexto A High Word (contexto_A_HIGH)
/** \brief The high word of the HMAC operation's contexto A, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_SHIFT 0
#define  HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_MASK) >> HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_SHIFT)
#define  HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_A_HIGH_CONTEXTO_A_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto B High Word (contexto_B_HIGH)
/** \brief The high word of the HMAC operation's contexto B, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_SHIFT 0
#define  HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_MASK) >> HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_SHIFT)
#define  HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_B_HIGH_CONTEXTO_B_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto C High Word (contexto_C_HIGH)
/** \brief The high word of the HMAC operation's contexto C, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_SHIFT 0
#define  HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_MASK) >> HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_SHIFT)
#define  HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_C_HIGH_CONTEXTO_C_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto D High Word (contexto_D_HIGH)
/** \brief The high word of the HMAC operation's contexto D, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_SHIFT 0
#define  HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_MASK) >> HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_SHIFT)
#define  HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_D_HIGH_CONTEXTO_D_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto E High Word (contexto_E_HIGH)
/** \brief The high word of the HMAC operation's contexto E, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_SHIFT 0
#define  HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_MASK) >> HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_SHIFT)
#define  HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_E_HIGH_CONTEXTO_E_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto F High Word (contexto_F_HIGH)
/** \brief The high word of the HMAC operation's contexto F, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_SHIFT 0
#define  HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_MASK) >> HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_SHIFT)
#define  HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_F_HIGH_CONTEXTO_F_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto G High Word (contexto_G_HIGH)
/** \brief The high word of the HMAC operation's contexto G, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_SHIFT 0
#define  HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_MASK) >> HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_SHIFT)
#define  HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_G_HIGH_CONTEXTO_G_HIGH_SHIFT))

//====================================================================
//Register: HMAC Contexto H High Word (contexto_H_HIGH)
/** \brief The high word of the HMAC operation's contexto H, applicable for SHA-512
and SHA-384.*/
//====================================================================

#define  HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_MASK 0xffffffff
#define  HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_SHIFT 0
#define  HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_MASK_SHIFT(reg) (((reg) & HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_MASK) >> HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_SHIFT)
#define  HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_REPLACE_VAL(reg,val) (((reg) & ~HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_MASK) | (((uint32_t)val) << HASH_CONTEXTO_H_HIGH_CONTEXTO_H_HIGH_SHIFT))

//====================================================================
//Register: HMAC Key Length (key_len)
/** \brief This register hold HMAC key length, size unit is byte. For
SHA1/256/224/MD5, Our hash engine limits HMAC key length to not larger
than 64bytes.
For SHA512/384, Our hash engine limits HMAC key length to not larger
than 128bytes.*/
//====================================================================

#define  HASH_KEY_LEN_RESERVED1_MASK 0xffffff00
#define  HASH_KEY_LEN_RESERVED1_SHIFT 8
#define  HASH_KEY_LEN_RESERVED1_MASK_SHIFT(reg) (((reg) & HASH_KEY_LEN_RESERVED1_MASK) >> HASH_KEY_LEN_RESERVED1_SHIFT)
#define  HASH_KEY_LEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_LEN_RESERVED1_MASK) | (((uint32_t)val) << HASH_KEY_LEN_RESERVED1_SHIFT))

#define  HASH_KEY_LEN_LEN_MASK 0xff
#define  HASH_KEY_LEN_LEN_SHIFT 0
#define  HASH_KEY_LEN_LEN_MASK_SHIFT(reg) (((reg) & HASH_KEY_LEN_LEN_MASK) >> HASH_KEY_LEN_LEN_SHIFT)
#define  HASH_KEY_LEN_LEN_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_LEN_LEN_MASK) | (((uint32_t)val) << HASH_KEY_LEN_LEN_SHIFT))

//====================================================================
//Register: HMAC Key 0 (key_0)
/** \brief HMAC operation Key word 0.*/
//====================================================================

#define  HASH_KEY_0_KEY_0_MASK 0xffffffff
#define  HASH_KEY_0_KEY_0_SHIFT 0
#define  HASH_KEY_0_KEY_0_MASK_SHIFT(reg) (((reg) & HASH_KEY_0_KEY_0_MASK) >> HASH_KEY_0_KEY_0_SHIFT)
#define  HASH_KEY_0_KEY_0_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_0_KEY_0_MASK) | (((uint32_t)val) << HASH_KEY_0_KEY_0_SHIFT))

//====================================================================
//Register: HMAC Key 1 (key_1)
/** \brief HMAC operation Key word 1.*/
//====================================================================

#define  HASH_KEY_1_KEY_1_MASK 0xffffffff
#define  HASH_KEY_1_KEY_1_SHIFT 0
#define  HASH_KEY_1_KEY_1_MASK_SHIFT(reg) (((reg) & HASH_KEY_1_KEY_1_MASK) >> HASH_KEY_1_KEY_1_SHIFT)
#define  HASH_KEY_1_KEY_1_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_1_KEY_1_MASK) | (((uint32_t)val) << HASH_KEY_1_KEY_1_SHIFT))

//====================================================================
//Register: HMAC Key 2 (key_2)
/** \brief HMAC operation Key word 2.*/
//====================================================================

#define  HASH_KEY_2_KEY_2_MASK 0xffffffff
#define  HASH_KEY_2_KEY_2_SHIFT 0
#define  HASH_KEY_2_KEY_2_MASK_SHIFT(reg) (((reg) & HASH_KEY_2_KEY_2_MASK) >> HASH_KEY_2_KEY_2_SHIFT)
#define  HASH_KEY_2_KEY_2_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_2_KEY_2_MASK) | (((uint32_t)val) << HASH_KEY_2_KEY_2_SHIFT))

//====================================================================
//Register: HMAC Key 3 (key_3)
/** \brief HMAC operation Key word 3.*/
//====================================================================

#define  HASH_KEY_3_KEY_3_MASK 0xffffffff
#define  HASH_KEY_3_KEY_3_SHIFT 0
#define  HASH_KEY_3_KEY_3_MASK_SHIFT(reg) (((reg) & HASH_KEY_3_KEY_3_MASK) >> HASH_KEY_3_KEY_3_SHIFT)
#define  HASH_KEY_3_KEY_3_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_3_KEY_3_MASK) | (((uint32_t)val) << HASH_KEY_3_KEY_3_SHIFT))

//====================================================================
//Register: HMAC Key 4 (key_4)
/** \brief HMAC operation Key word 4.*/
//====================================================================

#define  HASH_KEY_4_KEY_4_MASK 0xffffffff
#define  HASH_KEY_4_KEY_4_SHIFT 0
#define  HASH_KEY_4_KEY_4_MASK_SHIFT(reg) (((reg) & HASH_KEY_4_KEY_4_MASK) >> HASH_KEY_4_KEY_4_SHIFT)
#define  HASH_KEY_4_KEY_4_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_4_KEY_4_MASK) | (((uint32_t)val) << HASH_KEY_4_KEY_4_SHIFT))

//====================================================================
//Register: HMAC Key 5 (key_5)
/** \brief HMAC operation Key word 5.*/
//====================================================================

#define  HASH_KEY_5_KEY_5_MASK 0xffffffff
#define  HASH_KEY_5_KEY_5_SHIFT 0
#define  HASH_KEY_5_KEY_5_MASK_SHIFT(reg) (((reg) & HASH_KEY_5_KEY_5_MASK) >> HASH_KEY_5_KEY_5_SHIFT)
#define  HASH_KEY_5_KEY_5_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_5_KEY_5_MASK) | (((uint32_t)val) << HASH_KEY_5_KEY_5_SHIFT))

//====================================================================
//Register: HMAC Key 6 (key_6)
/** \brief HMAC operation Key word 6.*/
//====================================================================

#define  HASH_KEY_6_KEY_6_MASK 0xffffffff
#define  HASH_KEY_6_KEY_6_SHIFT 0
#define  HASH_KEY_6_KEY_6_MASK_SHIFT(reg) (((reg) & HASH_KEY_6_KEY_6_MASK) >> HASH_KEY_6_KEY_6_SHIFT)
#define  HASH_KEY_6_KEY_6_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_6_KEY_6_MASK) | (((uint32_t)val) << HASH_KEY_6_KEY_6_SHIFT))

//====================================================================
//Register: HMAC Key 7 (key_7)
/** \brief HMAC operation Key word 7.*/
//====================================================================

#define  HASH_KEY_7_KEY_7_MASK 0xffffffff
#define  HASH_KEY_7_KEY_7_SHIFT 0
#define  HASH_KEY_7_KEY_7_MASK_SHIFT(reg) (((reg) & HASH_KEY_7_KEY_7_MASK) >> HASH_KEY_7_KEY_7_SHIFT)
#define  HASH_KEY_7_KEY_7_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_7_KEY_7_MASK) | (((uint32_t)val) << HASH_KEY_7_KEY_7_SHIFT))

//====================================================================
//Register: HMAC Key 8 (key_8)
/** \brief HMAC operation Key word 8.*/
//====================================================================

#define  HASH_KEY_8_KEY_8_MASK 0xffffffff
#define  HASH_KEY_8_KEY_8_SHIFT 0
#define  HASH_KEY_8_KEY_8_MASK_SHIFT(reg) (((reg) & HASH_KEY_8_KEY_8_MASK) >> HASH_KEY_8_KEY_8_SHIFT)
#define  HASH_KEY_8_KEY_8_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_8_KEY_8_MASK) | (((uint32_t)val) << HASH_KEY_8_KEY_8_SHIFT))

//====================================================================
//Register: HMAC Key 9 (key_9)
/** \brief HMAC operation Key word 9.*/
//====================================================================

#define  HASH_KEY_9_KEY_9_MASK 0xffffffff
#define  HASH_KEY_9_KEY_9_SHIFT 0
#define  HASH_KEY_9_KEY_9_MASK_SHIFT(reg) (((reg) & HASH_KEY_9_KEY_9_MASK) >> HASH_KEY_9_KEY_9_SHIFT)
#define  HASH_KEY_9_KEY_9_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_9_KEY_9_MASK) | (((uint32_t)val) << HASH_KEY_9_KEY_9_SHIFT))

//====================================================================
//Register: HMAC Key 10 (key_10)
/** \brief HMAC operation Key word 10.*/
//====================================================================

#define  HASH_KEY_10_KEY_10_MASK 0xffffffff
#define  HASH_KEY_10_KEY_10_SHIFT 0
#define  HASH_KEY_10_KEY_10_MASK_SHIFT(reg) (((reg) & HASH_KEY_10_KEY_10_MASK) >> HASH_KEY_10_KEY_10_SHIFT)
#define  HASH_KEY_10_KEY_10_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_10_KEY_10_MASK) | (((uint32_t)val) << HASH_KEY_10_KEY_10_SHIFT))

//====================================================================
//Register: HMAC Key 11 (key_11)
/** \brief HMAC operation Key word 11.*/
//====================================================================

#define  HASH_KEY_11_KEY_11_MASK 0xffffffff
#define  HASH_KEY_11_KEY_11_SHIFT 0
#define  HASH_KEY_11_KEY_11_MASK_SHIFT(reg) (((reg) & HASH_KEY_11_KEY_11_MASK) >> HASH_KEY_11_KEY_11_SHIFT)
#define  HASH_KEY_11_KEY_11_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_11_KEY_11_MASK) | (((uint32_t)val) << HASH_KEY_11_KEY_11_SHIFT))

//====================================================================
//Register: HMAC Key 12 (key_12)
/** \brief HMAC operation Key word 12.*/
//====================================================================

#define  HASH_KEY_12_KEY_12_MASK 0xffffffff
#define  HASH_KEY_12_KEY_12_SHIFT 0
#define  HASH_KEY_12_KEY_12_MASK_SHIFT(reg) (((reg) & HASH_KEY_12_KEY_12_MASK) >> HASH_KEY_12_KEY_12_SHIFT)
#define  HASH_KEY_12_KEY_12_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_12_KEY_12_MASK) | (((uint32_t)val) << HASH_KEY_12_KEY_12_SHIFT))

//====================================================================
//Register: HMAC Key 13 (key_13)
/** \brief HMAC operation Key word 13.*/
//====================================================================

#define  HASH_KEY_13_KEY_13_MASK 0xffffffff
#define  HASH_KEY_13_KEY_13_SHIFT 0
#define  HASH_KEY_13_KEY_13_MASK_SHIFT(reg) (((reg) & HASH_KEY_13_KEY_13_MASK) >> HASH_KEY_13_KEY_13_SHIFT)
#define  HASH_KEY_13_KEY_13_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_13_KEY_13_MASK) | (((uint32_t)val) << HASH_KEY_13_KEY_13_SHIFT))

//====================================================================
//Register: HMAC Key 14 (key_14)
/** \brief HMAC operation Key word 14.*/
//====================================================================

#define  HASH_KEY_14_KEY_14_MASK 0xffffffff
#define  HASH_KEY_14_KEY_14_SHIFT 0
#define  HASH_KEY_14_KEY_14_MASK_SHIFT(reg) (((reg) & HASH_KEY_14_KEY_14_MASK) >> HASH_KEY_14_KEY_14_SHIFT)
#define  HASH_KEY_14_KEY_14_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_14_KEY_14_MASK) | (((uint32_t)val) << HASH_KEY_14_KEY_14_SHIFT))

//====================================================================
//Register: HMAC Key 15 (key_15)
/** \brief HMAC operation Key word 15.*/
//====================================================================

#define  HASH_KEY_15_KEY_15_MASK 0xffffffff
#define  HASH_KEY_15_KEY_15_SHIFT 0
#define  HASH_KEY_15_KEY_15_MASK_SHIFT(reg) (((reg) & HASH_KEY_15_KEY_15_MASK) >> HASH_KEY_15_KEY_15_SHIFT)
#define  HASH_KEY_15_KEY_15_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_15_KEY_15_MASK) | (((uint32_t)val) << HASH_KEY_15_KEY_15_SHIFT))

//====================================================================
//Register: HMAC Key 16 (key_16)
/** \brief HMAC operation Key word 16.*/
//====================================================================

#define  HASH_KEY_16_KEY_16_MASK 0xffffffff
#define  HASH_KEY_16_KEY_16_SHIFT 0
#define  HASH_KEY_16_KEY_16_MASK_SHIFT(reg) (((reg) & HASH_KEY_16_KEY_16_MASK) >> HASH_KEY_16_KEY_16_SHIFT)
#define  HASH_KEY_16_KEY_16_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_16_KEY_16_MASK) | (((uint32_t)val) << HASH_KEY_16_KEY_16_SHIFT))

//====================================================================
//Register: HMAC Key 17 (key_17)
/** \brief HMAC operation Key word 17.*/
//====================================================================

#define  HASH_KEY_17_KEY_17_MASK 0xffffffff
#define  HASH_KEY_17_KEY_17_SHIFT 0
#define  HASH_KEY_17_KEY_17_MASK_SHIFT(reg) (((reg) & HASH_KEY_17_KEY_17_MASK) >> HASH_KEY_17_KEY_17_SHIFT)
#define  HASH_KEY_17_KEY_17_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_17_KEY_17_MASK) | (((uint32_t)val) << HASH_KEY_17_KEY_17_SHIFT))

//====================================================================
//Register: HMAC Key 18 (key_18)
/** \brief HMAC operation Key word 18.*/
//====================================================================

#define  HASH_KEY_18_KEY_18_MASK 0xffffffff
#define  HASH_KEY_18_KEY_18_SHIFT 0
#define  HASH_KEY_18_KEY_18_MASK_SHIFT(reg) (((reg) & HASH_KEY_18_KEY_18_MASK) >> HASH_KEY_18_KEY_18_SHIFT)
#define  HASH_KEY_18_KEY_18_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_18_KEY_18_MASK) | (((uint32_t)val) << HASH_KEY_18_KEY_18_SHIFT))

//====================================================================
//Register: HMAC Key 19 (key_19)
/** \brief HMAC operation Key word 19.*/
//====================================================================

#define  HASH_KEY_19_KEY_19_MASK 0xffffffff
#define  HASH_KEY_19_KEY_19_SHIFT 0
#define  HASH_KEY_19_KEY_19_MASK_SHIFT(reg) (((reg) & HASH_KEY_19_KEY_19_MASK) >> HASH_KEY_19_KEY_19_SHIFT)
#define  HASH_KEY_19_KEY_19_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_19_KEY_19_MASK) | (((uint32_t)val) << HASH_KEY_19_KEY_19_SHIFT))

//====================================================================
//Register: HMAC Key 20 (key_20)
/** \brief HMAC operation Key word 20.*/
//====================================================================

#define  HASH_KEY_20_KEY_20_MASK 0xffffffff
#define  HASH_KEY_20_KEY_20_SHIFT 0
#define  HASH_KEY_20_KEY_20_MASK_SHIFT(reg) (((reg) & HASH_KEY_20_KEY_20_MASK) >> HASH_KEY_20_KEY_20_SHIFT)
#define  HASH_KEY_20_KEY_20_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_20_KEY_20_MASK) | (((uint32_t)val) << HASH_KEY_20_KEY_20_SHIFT))

//====================================================================
//Register: HMAC Key 21 (key_21)
/** \brief HMAC operation Key word 21.*/
//====================================================================

#define  HASH_KEY_21_KEY_21_MASK 0xffffffff
#define  HASH_KEY_21_KEY_21_SHIFT 0
#define  HASH_KEY_21_KEY_21_MASK_SHIFT(reg) (((reg) & HASH_KEY_21_KEY_21_MASK) >> HASH_KEY_21_KEY_21_SHIFT)
#define  HASH_KEY_21_KEY_21_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_21_KEY_21_MASK) | (((uint32_t)val) << HASH_KEY_21_KEY_21_SHIFT))

//====================================================================
//Register: HMAC Key 22 (key_22)
/** \brief HMAC operation Key word 22.*/
//====================================================================

#define  HASH_KEY_22_KEY_22_MASK 0xffffffff
#define  HASH_KEY_22_KEY_22_SHIFT 0
#define  HASH_KEY_22_KEY_22_MASK_SHIFT(reg) (((reg) & HASH_KEY_22_KEY_22_MASK) >> HASH_KEY_22_KEY_22_SHIFT)
#define  HASH_KEY_22_KEY_22_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_22_KEY_22_MASK) | (((uint32_t)val) << HASH_KEY_22_KEY_22_SHIFT))

//====================================================================
//Register: HMAC Key 23 (key_23)
/** \brief HMAC operation Key word 23.*/
//====================================================================

#define  HASH_KEY_23_KEY_23_MASK 0xffffffff
#define  HASH_KEY_23_KEY_23_SHIFT 0
#define  HASH_KEY_23_KEY_23_MASK_SHIFT(reg) (((reg) & HASH_KEY_23_KEY_23_MASK) >> HASH_KEY_23_KEY_23_SHIFT)
#define  HASH_KEY_23_KEY_23_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_23_KEY_23_MASK) | (((uint32_t)val) << HASH_KEY_23_KEY_23_SHIFT))

//====================================================================
//Register: HMAC Key 24 (key_24)
/** \brief HMAC operation Key word 24.*/
//====================================================================

#define  HASH_KEY_24_KEY_24_MASK 0xffffffff
#define  HASH_KEY_24_KEY_24_SHIFT 0
#define  HASH_KEY_24_KEY_24_MASK_SHIFT(reg) (((reg) & HASH_KEY_24_KEY_24_MASK) >> HASH_KEY_24_KEY_24_SHIFT)
#define  HASH_KEY_24_KEY_24_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_24_KEY_24_MASK) | (((uint32_t)val) << HASH_KEY_24_KEY_24_SHIFT))

//====================================================================
//Register: HMAC Key 25 (key_25)
/** \brief HMAC operation Key word 25.*/
//====================================================================

#define  HASH_KEY_25_KEY_25_MASK 0xffffffff
#define  HASH_KEY_25_KEY_25_SHIFT 0
#define  HASH_KEY_25_KEY_25_MASK_SHIFT(reg) (((reg) & HASH_KEY_25_KEY_25_MASK) >> HASH_KEY_25_KEY_25_SHIFT)
#define  HASH_KEY_25_KEY_25_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_25_KEY_25_MASK) | (((uint32_t)val) << HASH_KEY_25_KEY_25_SHIFT))

//====================================================================
//Register: HMAC Key 26 (key_26)
/** \brief HMAC operation Key word 26.*/
//====================================================================

#define  HASH_KEY_26_KEY_26_MASK 0xffffffff
#define  HASH_KEY_26_KEY_26_SHIFT 0
#define  HASH_KEY_26_KEY_26_MASK_SHIFT(reg) (((reg) & HASH_KEY_26_KEY_26_MASK) >> HASH_KEY_26_KEY_26_SHIFT)
#define  HASH_KEY_26_KEY_26_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_26_KEY_26_MASK) | (((uint32_t)val) << HASH_KEY_26_KEY_26_SHIFT))

//====================================================================
//Register: HMAC Key 27 (key_27)
/** \brief HMAC operation Key word 27.*/
//====================================================================

#define  HASH_KEY_27_KEY_27_MASK 0xffffffff
#define  HASH_KEY_27_KEY_27_SHIFT 0
#define  HASH_KEY_27_KEY_27_MASK_SHIFT(reg) (((reg) & HASH_KEY_27_KEY_27_MASK) >> HASH_KEY_27_KEY_27_SHIFT)
#define  HASH_KEY_27_KEY_27_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_27_KEY_27_MASK) | (((uint32_t)val) << HASH_KEY_27_KEY_27_SHIFT))

//====================================================================
//Register: HMAC Key 28 (key_28)
/** \brief HMAC operation Key word 28.*/
//====================================================================

#define  HASH_KEY_28_KEY_28_MASK 0xffffffff
#define  HASH_KEY_28_KEY_28_SHIFT 0
#define  HASH_KEY_28_KEY_28_MASK_SHIFT(reg) (((reg) & HASH_KEY_28_KEY_28_MASK) >> HASH_KEY_28_KEY_28_SHIFT)
#define  HASH_KEY_28_KEY_28_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_28_KEY_28_MASK) | (((uint32_t)val) << HASH_KEY_28_KEY_28_SHIFT))

//====================================================================
//Register: HMAC Key 29 (key_29)
/** \brief HMAC operation Key word 29.*/
//====================================================================

#define  HASH_KEY_29_KEY_29_MASK 0xffffffff
#define  HASH_KEY_29_KEY_29_SHIFT 0
#define  HASH_KEY_29_KEY_29_MASK_SHIFT(reg) (((reg) & HASH_KEY_29_KEY_29_MASK) >> HASH_KEY_29_KEY_29_SHIFT)
#define  HASH_KEY_29_KEY_29_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_29_KEY_29_MASK) | (((uint32_t)val) << HASH_KEY_29_KEY_29_SHIFT))

//====================================================================
//Register: HMAC Key 30 (key_30)
/** \brief HMAC operation Key word 30.*/
//====================================================================

#define  HASH_KEY_30_KEY_30_MASK 0xffffffff
#define  HASH_KEY_30_KEY_30_SHIFT 0
#define  HASH_KEY_30_KEY_30_MASK_SHIFT(reg) (((reg) & HASH_KEY_30_KEY_30_MASK) >> HASH_KEY_30_KEY_30_SHIFT)
#define  HASH_KEY_30_KEY_30_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_30_KEY_30_MASK) | (((uint32_t)val) << HASH_KEY_30_KEY_30_SHIFT))

//====================================================================
//Register: HMAC Key 31 (key_31)
/** \brief HMAC operation Key word 31.*/
//====================================================================

#define  HASH_KEY_31_KEY_31_MASK 0xffffffff
#define  HASH_KEY_31_KEY_31_SHIFT 0
#define  HASH_KEY_31_KEY_31_MASK_SHIFT(reg) (((reg) & HASH_KEY_31_KEY_31_MASK) >> HASH_KEY_31_KEY_31_SHIFT)
#define  HASH_KEY_31_KEY_31_REPLACE_VAL(reg,val) (((reg) & ~HASH_KEY_31_KEY_31_MASK) | (((uint32_t)val) << HASH_KEY_31_KEY_31_SHIFT))

//====================================================================
//
//Register File: WTM Scratch Pad Control Registers (WTM_SCRATCH_PAD)
/** \brief Scratch Pad for Accelerators
Data RAM
Provides CPU, Random Access & Sequential Access to Data RAM*/
//
//====================================================================

//====================================================================
//Register: Access Control for Scratch Pad (SP_CTRL)
//====================================================================

#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_MASK 0xffffff00
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_SHIFT 8
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_RESERVED1_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_MASK 0x80
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_SHIFT 7
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_SP_REV_MODE_SELECT_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_MASK 0x40
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_SHIFT 6
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_RESERVED2_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_MASK 0x30
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_SHIFT 4
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_SP_ACCESS_SELECT_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_MASK 0x8
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_SHIFT 3
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_RESERVED3_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_MASK 0x4
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_SHIFT 2
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_CPU_INT_EN_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_MASK 0x2
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_SHIFT 1
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_SP_ACC_ERR_ENG_INT_EN_SHIFT))

#define  WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_MASK 0x1
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_MASK) >> WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CTRL_SP_RESET_SHIFT))

//====================================================================
//Register: Access Status for Scratch Pad (SP_STATUS)
//====================================================================

#define  WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_MASK 0xfffffffc
#define  WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_SHIFT 2
#define  WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_MASK) >> WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_SHIFT)
#define  WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_STATUS_RESERVED1_SHIFT))

#define  WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_MASK 0x2
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_SHIFT 1
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_MASK) >> WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_SHIFT)
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_STATUS_SP_EMPTY_SHIFT))

#define  WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_MASK 0x1
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_MASK) >> WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_SHIFT)
#define  WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_STATUS_SP_ACCESS_ERROR_SHIFT))

//====================================================================
//Register: Write Address for Scratch Pad Data Access (SP_CPU_WR_ADDR)
/** \brief Scratch Pad CPU Write Access Address.
Steps for writing:
1. Program CPU Write Access Address (<<b>>SP_CPU_WR_ADDR<</b>>).
2. Program CPU Write Access Data (<<b>>SP_CPU_WR_DATA<</b>>), Posted Write
will be performed.
Valid only when CPU Access Mode is enabled*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_MASK) >> WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CPU_WR_ADDR_SP_CPU_WR_ADDR_SHIFT))

//====================================================================
//Register: Write Data for Scratch Pad for Data Access (SP_CPU_WR_DATA)
/** \brief Scratch Pad CPU Write Access Data.
Steps for writing:
1. Program CPU Write Access Address (<<b>>SP_CPU_WR_ADDR<</b>>).
2. Program CPU Write Access Data (<<b>>SP_CPU_WR_DATA<</b>>), Posted Write
will be performed.
Valid only when CPU Access Mode is enabled*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_MASK) >> WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CPU_WR_DATA_SP_CPU_WR_DATA_SHIFT))

//====================================================================
//Register: Read Address for Scratch Pad Data Access (SP_CPU_RD_ADDR)
/** \brief Scratch Pad CPU Read Access Address.
Steps for reading:
1. Program CPU Read Access Address (<<b>>SP_CPU_RD_ADDR<</b>>). Triggers
RAM Read within 2 clocks
2. Program CPU Read Access Data (<<b>>SP_CPU_RD_DATA<</b>>), RAM Read Data
should be loaded
Valid only when CPU Access Mode is enabled*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_MASK) >> WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CPU_RD_ADDR_SP_CPU_RD_ADDR_SHIFT))

//====================================================================
//Register: Read Data for Scratch Pad for Data Access (SP_CPU_RD_DATA)
/** \brief Scratch Pad CPU Read Access Data
Steps for reading:
1. Program CPU Read Access Address (<<b>>SP_CPU_RD_ADDR<</b>>). Triggers
RAM Read within 2 clocks
2. Program CPU Read Access Data (<<b>>SP_CPU_RD_DATA<</b>>), RAM Read Data
should be loaded
Valid only when CPU Access Mode is enabled
Notes: Reset Read value is unknown*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_MASK) >> WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_SHIFT)
#define  WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_CPU_RD_DATA_SP_CPU_RD_DATA_SHIFT))

//====================================================================
//Register: Scratch Pad Set Write Address (SP_SET_WR_ADDR)
/** \brief Scratch Pad Sets Write Address (Pointer) for Sequential and Reverse Access
- This field is composed of an indication bit and address bits. Ex, for
a 256x32 Scratch Pad design, only the LSB 9 bits are valid.
- The difference between Read and Write Addresses (Pointers) should not
exceed Scratch Pad's size.
- Write Address should always point to the next avaliable address space.
Ex, if last pushed data is stored at address zero, Write Address then
points to address one.
- When CPU programs pointers, it is required to program both Read/Write
Addresses and the program sequence must be Write Address followed by Read
Address
- CPU needs to make sure there is no ongoing data transfer (in or out)
before it reads pointers.*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_MASK) >> WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_SHIFT)
#define  WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_SET_WR_ADDR_SP_SET_WR_ADDR_SHIFT))

//====================================================================
//Register: Scratch Pad Set Read Address (SP_SET_RD_ADDR)
/** \brief Scratch Pad Sets Read Address (Pointer) for Sequential and Reverse Access
- This field is composed of an indication bit and address bits. Ex, for
a 256x32 Scratch Pad design, only the LSB 9 bits are valid.
- The difference between Read and Write Addresses (Pointers) should not
exceed Scratch Pad's size.
- Read Address should always point to the address which contains the valid
data for the next pop. Ex, The only valid data is in the address zero and
one, then Read Address would be zero.
- When CPU programs pointers, it is required to program both Read/Write
Addresses and the program sequence must be Write Address followed by Read
Address.
- CPU needs to make sure there is no ongoing data transfer (in or out)
before it reads pointers.*/
//====================================================================

#define  WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_MASK 0xffffffff
#define  WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_SHIFT 0
#define  WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_MASK_SHIFT(reg) (((reg) & WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_MASK) >> WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_SHIFT)
#define  WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_REPLACE_VAL(reg,val) (((reg) & ~WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_MASK) | (((uint32_t)val) << WTM_SCRATCH_PAD_SP_SET_RD_ADDR_SP_SET_RD_ADDR_SHIFT))

//====================================================================
//
//Register File: ZMODP Engine Control Registers (ZMODP)
/** \brief The ZMODP module can be used to perform four kinds of operations: Montgomery
multiplication, ordinary modular multiplication, modular exponentiation and
multiplicative inversion with prime moduli (which can be performed via little
Fermat theorem). The operand size varies from 32 to 2048. Five size
modes, 128, 256, 512, 1024 and 2048-bit are provided. For example, to
perform 101-bit modular exponentiation, one needs to set the size mode
as 128-bit. Two code modes for exponentiation, non-secure mode and secure mode,
are provided. For encryption, non-secure mode should be chosen to obtain faster
operation speed, and for decryption, secure mode should be chosen to counter
against simple powering analysis (SPA).*/
//
//====================================================================

//====================================================================
//Register: ZMODP configuration register (ZMODP_CFG_REG)
/** \brief Configuration registers by which size_mode, operation_mode, and code_mode can be
defined*/
//====================================================================

#define  ZMODP_ZMODP_CFG_REG_RESERVED1_MASK 0xffff0000
#define  ZMODP_ZMODP_CFG_REG_RESERVED1_SHIFT 16
#define  ZMODP_ZMODP_CFG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_RESERVED1_MASK) >> ZMODP_ZMODP_CFG_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_MASK 0x8000
#define  ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_SHIFT 15
#define  ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_MASK) >> ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_USE_OTP_EC521_DK_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_RESERVED2_MASK 0x4000
#define  ZMODP_ZMODP_CFG_REG_RESERVED2_SHIFT 14
#define  ZMODP_ZMODP_CFG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_RESERVED2_MASK) >> ZMODP_ZMODP_CFG_REG_RESERVED2_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_RESERVED2_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_RESERVED2_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_CODE_MODE_MASK 0x2000
#define  ZMODP_ZMODP_CFG_REG_CODE_MODE_SHIFT 13
#define  ZMODP_ZMODP_CFG_REG_CODE_MODE_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_CODE_MODE_MASK) >> ZMODP_ZMODP_CFG_REG_CODE_MODE_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_CODE_MODE_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_CODE_MODE_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_CODE_MODE_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_NUM_COEFS_MASK 0x1fc0
#define  ZMODP_ZMODP_CFG_REG_NUM_COEFS_SHIFT 6
#define  ZMODP_ZMODP_CFG_REG_NUM_COEFS_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_NUM_COEFS_MASK) >> ZMODP_ZMODP_CFG_REG_NUM_COEFS_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_NUM_COEFS_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_NUM_COEFS_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_NUM_COEFS_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_MOD_SIZE_MASK 0x38
#define  ZMODP_ZMODP_CFG_REG_MOD_SIZE_SHIFT 3
#define  ZMODP_ZMODP_CFG_REG_MOD_SIZE_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_MOD_SIZE_MASK) >> ZMODP_ZMODP_CFG_REG_MOD_SIZE_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_MOD_SIZE_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_MOD_SIZE_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_MOD_SIZE_SHIFT))

#define  ZMODP_ZMODP_CFG_REG_OP_MODE_MASK 0x7
#define  ZMODP_ZMODP_CFG_REG_OP_MODE_SHIFT 0
#define  ZMODP_ZMODP_CFG_REG_OP_MODE_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CFG_REG_OP_MODE_MASK) >> ZMODP_ZMODP_CFG_REG_OP_MODE_SHIFT)
#define  ZMODP_ZMODP_CFG_REG_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CFG_REG_OP_MODE_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CFG_REG_OP_MODE_SHIFT))

//====================================================================
//Register: ZMODP control register (ZMODP_CTRL_REG)
/** \brief Control registers*/
//====================================================================

#define  ZMODP_ZMODP_CTRL_REG_RESERVED1_MASK 0xfffffffe
#define  ZMODP_ZMODP_CTRL_REG_RESERVED1_SHIFT 1
#define  ZMODP_ZMODP_CTRL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CTRL_REG_RESERVED1_MASK) >> ZMODP_ZMODP_CTRL_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_CTRL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CTRL_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CTRL_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_CTRL_REG_RESET_MASK 0x1
#define  ZMODP_ZMODP_CTRL_REG_RESET_SHIFT 0
#define  ZMODP_ZMODP_CTRL_REG_RESET_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CTRL_REG_RESET_MASK) >> ZMODP_ZMODP_CTRL_REG_RESET_SHIFT)
#define  ZMODP_ZMODP_CTRL_REG_RESET_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CTRL_REG_RESET_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CTRL_REG_RESET_SHIFT))

//====================================================================
//Register: ZMODP command register (ZMODP_CMD_REG)
/** \brief Command registers*/
//====================================================================

#define  ZMODP_ZMODP_CMD_REG_RESERVED1_MASK 0xfffffffc
#define  ZMODP_ZMODP_CMD_REG_RESERVED1_SHIFT 2
#define  ZMODP_ZMODP_CMD_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CMD_REG_RESERVED1_MASK) >> ZMODP_ZMODP_CMD_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_CMD_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CMD_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CMD_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_CMD_REG_CMD_START_MASK 0x2
#define  ZMODP_ZMODP_CMD_REG_CMD_START_SHIFT 1
#define  ZMODP_ZMODP_CMD_REG_CMD_START_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CMD_REG_CMD_START_MASK) >> ZMODP_ZMODP_CMD_REG_CMD_START_SHIFT)
#define  ZMODP_ZMODP_CMD_REG_CMD_START_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CMD_REG_CMD_START_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CMD_REG_CMD_START_SHIFT))

#define  ZMODP_ZMODP_CMD_REG_ZERORIZE_START_MASK 0x1
#define  ZMODP_ZMODP_CMD_REG_ZERORIZE_START_SHIFT 0
#define  ZMODP_ZMODP_CMD_REG_ZERORIZE_START_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_CMD_REG_ZERORIZE_START_MASK) >> ZMODP_ZMODP_CMD_REG_ZERORIZE_START_SHIFT)
#define  ZMODP_ZMODP_CMD_REG_ZERORIZE_START_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_CMD_REG_ZERORIZE_START_MASK) | (((uint32_t)val) << ZMODP_ZMODP_CMD_REG_ZERORIZE_START_SHIFT))

//====================================================================
//Register: ZMODP status register (ZMODP_STATUS_REG)
/** \brief Status registers*/
//====================================================================

#define  ZMODP_ZMODP_STATUS_REG_RESERVED1_MASK 0xffffffc0
#define  ZMODP_ZMODP_STATUS_REG_RESERVED1_SHIFT 6
#define  ZMODP_ZMODP_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_STATUS_REG_RESERVED1_MASK) >> ZMODP_ZMODP_STATUS_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_STATUS_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_STATUS_REG_MFSM_MASK 0x3e
#define  ZMODP_ZMODP_STATUS_REG_MFSM_SHIFT 1
#define  ZMODP_ZMODP_STATUS_REG_MFSM_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_STATUS_REG_MFSM_MASK) >> ZMODP_ZMODP_STATUS_REG_MFSM_SHIFT)
#define  ZMODP_ZMODP_STATUS_REG_MFSM_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_STATUS_REG_MFSM_MASK) | (((uint32_t)val) << ZMODP_ZMODP_STATUS_REG_MFSM_SHIFT))

#define  ZMODP_ZMODP_STATUS_REG_BUSY_MASK 0x1
#define  ZMODP_ZMODP_STATUS_REG_BUSY_SHIFT 0
#define  ZMODP_ZMODP_STATUS_REG_BUSY_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_STATUS_REG_BUSY_MASK) >> ZMODP_ZMODP_STATUS_REG_BUSY_SHIFT)
#define  ZMODP_ZMODP_STATUS_REG_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_STATUS_REG_BUSY_MASK) | (((uint32_t)val) << ZMODP_ZMODP_STATUS_REG_BUSY_SHIFT))

//====================================================================
//Register: ZMODP interrupt sources register (ZMODP_INTRPT_SRC_REG)
/** \brief Interrupt source registers*/
//====================================================================

#define  ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_MASK 0xfffffffe
#define  ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_SHIFT 1
#define  ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_MASK) >> ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_INTRPT_SRC_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_MASK 0x1
#define  ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_SHIFT 0
#define  ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_MASK) >> ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_SHIFT)
#define  ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_MASK) | (((uint32_t)val) << ZMODP_ZMODP_INTRPT_SRC_REG_CMD_DONE_INT_SHIFT))

//====================================================================
//Register: ZMODP interrupt sources enable register (ZMODP_INTRPT_SRC_EN_REG)
/** \brief Set each bit to enable the corresponding ZMODP_INTRPT_REG bit as an
interrupt source.*/
//====================================================================

#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_MASK 0xfffffffe
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_SHIFT 1
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_MASK) >> ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_SHIFT)
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << ZMODP_ZMODP_INTRPT_SRC_EN_REG_RESERVED1_SHIFT))

#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_MASK 0x1
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_SHIFT 0
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_MASK) >> ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_SHIFT)
#define  ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_MASK) | (((uint32_t)val) << ZMODP_ZMODP_INTRPT_SRC_EN_REG_CMD_DONE_EN_SHIFT))

//====================================================================
//Register: ZMODP Register Array (ZMODP_MEM)
/** \brief Memory for moduli, operands, and results
Word Address Description
- <<b>>X <</b>>(Addr: <<b>>06h ~ 45h <</b>>Mapped to Scratch Pad)-
Multiplicand, Base of exponentiation.
- <<b>>X1 <</b>>(Addr: <<b>>46h ~ 85h <</b>>Mapped to Scratch Pad)-
Multiplicand and Pre-Computation parameter (2^2n Mod M) of Montgomery
domain
- <<b>>EXP <</b>>(Addr: <<b>>86h ~ C5h <</b>>Mapped to Scratch Pad)-
Exponent
- *M* (Addr: <<b>>C6h <</b>>Mapped to Shift Register for moduli)- It is
required to read/write the whole operands\* from/to shift registers
successively according to CODE_MODE
- <<b>>Y <</b>>(Addr: <<b>>C7h <</b>>Mapped to Shift Register for
multiplicand)- It is required to read/write the whole operands\* from/to
shift registers successively according to CODE_MODE
- <<b>>Z <</b>>(Addr: <<b>>C8h <</b>>Mapped to Shift Register for
Computation Result)- It is required to read/write the whole operands\*
from/to shift registers successively according to CODE_MODE*/
//====================================================================

#define  ZMODP_ZMODP_MEM_ZMODP_MEM_MASK 0xffffffff
#define  ZMODP_ZMODP_MEM_ZMODP_MEM_SHIFT 0
#define  ZMODP_ZMODP_MEM_ZMODP_MEM_MASK_SHIFT(reg) (((reg) & ZMODP_ZMODP_MEM_ZMODP_MEM_MASK) >> ZMODP_ZMODP_MEM_ZMODP_MEM_SHIFT)
#define  ZMODP_ZMODP_MEM_ZMODP_MEM_REPLACE_VAL(reg,val) (((reg) & ~ZMODP_ZMODP_MEM_ZMODP_MEM_MASK) | (((uint32_t)val) << ZMODP_ZMODP_MEM_ZMODP_MEM_SHIFT))

//====================================================================
//
//Register File: Security Control Registers (BCMREG)
//
//====================================================================

//====================================================================
//Register: OTP Controller Control Register (OTP_CONTROLLER_CONTROL)
//====================================================================

#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_MASK 0x80000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_SHIFT 31
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_RESERVED1_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_MASK 0x40000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_SHIFT 30
#define  BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_STICKY_CONTROL_BIT_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_MASK 0x20000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_SHIFT 29
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_RESERVED2_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_MASK 0x10000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_SHIFT 28
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_POWER_BYPASS_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_MASK 0xe000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_SHIFT 25
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DIVIDER_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_MASK 0x1000000
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_SHIFT 24
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_RESERVED3_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_MASK 0x800000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_SHIFT 23
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_CLOCK_DISABLE_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_MASK 0x400000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_SHIFT 22
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_SOFTWARE_RESET_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_MASK 0x3c0000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_SHIFT 18
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_BLOCK_NUMBER_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_MASK 0x20000
#define  BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_SHIFT 17
#define  BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_HIGH_VOLT_ENABLE_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_MASK 0x10000
#define  BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_SHIFT 16
#define  BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_BURN_FUSE_ENABLE_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_MASK 0x8000
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_SHIFT 15
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_FUSE_LOCK_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_MASK 0x4000
#define  BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_SHIFT 14
#define  BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_ENABLE_SOFT_FUSE_PROG_SHIFT))

#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_MASK 0x3fff
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_SHIFT 0
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_MASK) >> BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_SHIFT)
#define  BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_MASK) | (((uint32_t)val) << BCMREG_OTP_CONTROLLER_CONTROL_RESERVED4_SHIFT))

//====================================================================
//Register: Invalid Access Interrupt Mask Register (INV_ACC_INT_MAS)
//====================================================================

#define  BCMREG_INV_ACC_INT_MAS_RESERVED1_MASK 0xfffc0000
#define  BCMREG_INV_ACC_INT_MAS_RESERVED1_SHIFT 18
#define  BCMREG_INV_ACC_INT_MAS_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_RESERVED1_MASK) >> BCMREG_INV_ACC_INT_MAS_RESERVED1_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_RESERVED1_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_LAN_MASK 0x20000
#define  BCMREG_INV_ACC_INT_MAS_LAN_SHIFT 17
#define  BCMREG_INV_ACC_INT_MAS_LAN_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_LAN_MASK) >> BCMREG_INV_ACC_INT_MAS_LAN_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_LAN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_LAN_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_LAN_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_GC_MASK 0x10000
#define  BCMREG_INV_ACC_INT_MAS_GC_SHIFT 16
#define  BCMREG_INV_ACC_INT_MAS_GC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_GC_MASK) >> BCMREG_INV_ACC_INT_MAS_GC_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_GC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_GC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_GC_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_AP_SCCP_MASK 0x8000
#define  BCMREG_INV_ACC_INT_MAS_AP_SCCP_SHIFT 15
#define  BCMREG_INV_ACC_INT_MAS_AP_SCCP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_AP_SCCP_MASK) >> BCMREG_INV_ACC_INT_MAS_AP_SCCP_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_AP_SCCP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_AP_SCCP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_AP_SCCP_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_DAP_MASK 0x4000
#define  BCMREG_INV_ACC_INT_MAS_DAP_SHIFT 14
#define  BCMREG_INV_ACC_INT_MAS_DAP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_DAP_MASK) >> BCMREG_INV_ACC_INT_MAS_DAP_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_DAP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_DAP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_DAP_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_PDMA2_MASK 0x2000
#define  BCMREG_INV_ACC_INT_MAS_PDMA2_SHIFT 13
#define  BCMREG_INV_ACC_INT_MAS_PDMA2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_PDMA2_MASK) >> BCMREG_INV_ACC_INT_MAS_PDMA2_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_PDMA2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_PDMA2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_PDMA2_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_PDMA1_MASK 0x1000
#define  BCMREG_INV_ACC_INT_MAS_PDMA1_SHIFT 12
#define  BCMREG_INV_ACC_INT_MAS_PDMA1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_PDMA1_MASK) >> BCMREG_INV_ACC_INT_MAS_PDMA1_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_PDMA1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_PDMA1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_PDMA1_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_AP2MC_MASK 0x800
#define  BCMREG_INV_ACC_INT_MAS_AP2MC_SHIFT 11
#define  BCMREG_INV_ACC_INT_MAS_AP2MC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_AP2MC_MASK) >> BCMREG_INV_ACC_INT_MAS_AP2MC_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_AP2MC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_AP2MC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_AP2MC_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_AP2BUS_MASK 0x400
#define  BCMREG_INV_ACC_INT_MAS_AP2BUS_SHIFT 10
#define  BCMREG_INV_ACC_INT_MAS_AP2BUS_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_AP2BUS_MASK) >> BCMREG_INV_ACC_INT_MAS_AP2BUS_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_AP2BUS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_AP2BUS_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_AP2BUS_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_USB3H_MASK 0x200
#define  BCMREG_INV_ACC_INT_MAS_USB3H_SHIFT 9
#define  BCMREG_INV_ACC_INT_MAS_USB3H_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_USB3H_MASK) >> BCMREG_INV_ACC_INT_MAS_USB3H_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_USB3H_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_USB3H_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_USB3H_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_USB3D_MASK 0x100
#define  BCMREG_INV_ACC_INT_MAS_USB3D_SHIFT 8
#define  BCMREG_INV_ACC_INT_MAS_USB3D_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_USB3D_MASK) >> BCMREG_INV_ACC_INT_MAS_USB3D_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_USB3D_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_USB3D_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_USB3D_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_USB2_MASK 0x80
#define  BCMREG_INV_ACC_INT_MAS_USB2_SHIFT 7
#define  BCMREG_INV_ACC_INT_MAS_USB2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_USB2_MASK) >> BCMREG_INV_ACC_INT_MAS_USB2_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_USB2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_USB2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_USB2_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_LCD_MASK 0x40
#define  BCMREG_INV_ACC_INT_MAS_LCD_SHIFT 6
#define  BCMREG_INV_ACC_INT_MAS_LCD_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_LCD_MASK) >> BCMREG_INV_ACC_INT_MAS_LCD_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_LCD_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_LCD_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_LCD_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_PCIE0_MASK 0x20
#define  BCMREG_INV_ACC_INT_MAS_PCIE0_SHIFT 5
#define  BCMREG_INV_ACC_INT_MAS_PCIE0_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_PCIE0_MASK) >> BCMREG_INV_ACC_INT_MAS_PCIE0_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_PCIE0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_PCIE0_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_PCIE0_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_PCIE1_MASK 0x10
#define  BCMREG_INV_ACC_INT_MAS_PCIE1_SHIFT 4
#define  BCMREG_INV_ACC_INT_MAS_PCIE1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_PCIE1_MASK) >> BCMREG_INV_ACC_INT_MAS_PCIE1_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_PCIE1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_PCIE1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_PCIE1_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_SATA_MASK 0x8
#define  BCMREG_INV_ACC_INT_MAS_SATA_SHIFT 3
#define  BCMREG_INV_ACC_INT_MAS_SATA_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_SATA_MASK) >> BCMREG_INV_ACC_INT_MAS_SATA_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_SATA_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_SATA_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_SATA_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_SDMMC1_MASK 0x4
#define  BCMREG_INV_ACC_INT_MAS_SDMMC1_SHIFT 2
#define  BCMREG_INV_ACC_INT_MAS_SDMMC1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_SDMMC1_MASK) >> BCMREG_INV_ACC_INT_MAS_SDMMC1_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_SDMMC1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_SDMMC1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_SDMMC1_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_SDMMC2_MASK 0x2
#define  BCMREG_INV_ACC_INT_MAS_SDMMC2_SHIFT 1
#define  BCMREG_INV_ACC_INT_MAS_SDMMC2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_SDMMC2_MASK) >> BCMREG_INV_ACC_INT_MAS_SDMMC2_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_SDMMC2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_SDMMC2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_SDMMC2_SHIFT))

#define  BCMREG_INV_ACC_INT_MAS_SDMMC3_MASK 0x1
#define  BCMREG_INV_ACC_INT_MAS_SDMMC3_SHIFT 0
#define  BCMREG_INV_ACC_INT_MAS_SDMMC3_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_MAS_SDMMC3_MASK) >> BCMREG_INV_ACC_INT_MAS_SDMMC3_SHIFT)
#define  BCMREG_INV_ACC_INT_MAS_SDMMC3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_MAS_SDMMC3_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_MAS_SDMMC3_SHIFT))

//====================================================================
//Register: Invalid Access Interrupt Clear Register (INV_ACC_INT_CLR)
//====================================================================

#define  BCMREG_INV_ACC_INT_CLR_RESERVED1_MASK 0xfffc0000
#define  BCMREG_INV_ACC_INT_CLR_RESERVED1_SHIFT 18
#define  BCMREG_INV_ACC_INT_CLR_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_RESERVED1_MASK) >> BCMREG_INV_ACC_INT_CLR_RESERVED1_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_RESERVED1_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_LAN_MASK 0x20000
#define  BCMREG_INV_ACC_INT_CLR_LAN_SHIFT 17
#define  BCMREG_INV_ACC_INT_CLR_LAN_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_LAN_MASK) >> BCMREG_INV_ACC_INT_CLR_LAN_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_LAN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_LAN_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_LAN_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_GC_MASK 0x10000
#define  BCMREG_INV_ACC_INT_CLR_GC_SHIFT 16
#define  BCMREG_INV_ACC_INT_CLR_GC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_GC_MASK) >> BCMREG_INV_ACC_INT_CLR_GC_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_GC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_GC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_GC_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_AP_SCCP_MASK 0x8000
#define  BCMREG_INV_ACC_INT_CLR_AP_SCCP_SHIFT 15
#define  BCMREG_INV_ACC_INT_CLR_AP_SCCP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_AP_SCCP_MASK) >> BCMREG_INV_ACC_INT_CLR_AP_SCCP_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_AP_SCCP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_AP_SCCP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_AP_SCCP_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_DAP_MASK 0x4000
#define  BCMREG_INV_ACC_INT_CLR_DAP_SHIFT 14
#define  BCMREG_INV_ACC_INT_CLR_DAP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_DAP_MASK) >> BCMREG_INV_ACC_INT_CLR_DAP_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_DAP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_DAP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_DAP_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_PDMA2_MASK 0x2000
#define  BCMREG_INV_ACC_INT_CLR_PDMA2_SHIFT 13
#define  BCMREG_INV_ACC_INT_CLR_PDMA2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_PDMA2_MASK) >> BCMREG_INV_ACC_INT_CLR_PDMA2_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_PDMA2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_PDMA2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_PDMA2_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_PDMA1_MASK 0x1000
#define  BCMREG_INV_ACC_INT_CLR_PDMA1_SHIFT 12
#define  BCMREG_INV_ACC_INT_CLR_PDMA1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_PDMA1_MASK) >> BCMREG_INV_ACC_INT_CLR_PDMA1_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_PDMA1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_PDMA1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_PDMA1_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_AP2MC_MASK 0x800
#define  BCMREG_INV_ACC_INT_CLR_AP2MC_SHIFT 11
#define  BCMREG_INV_ACC_INT_CLR_AP2MC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_AP2MC_MASK) >> BCMREG_INV_ACC_INT_CLR_AP2MC_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_AP2MC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_AP2MC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_AP2MC_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_AP2BUS_MASK 0x400
#define  BCMREG_INV_ACC_INT_CLR_AP2BUS_SHIFT 10
#define  BCMREG_INV_ACC_INT_CLR_AP2BUS_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_AP2BUS_MASK) >> BCMREG_INV_ACC_INT_CLR_AP2BUS_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_AP2BUS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_AP2BUS_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_AP2BUS_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_USB3H_MASK 0x200
#define  BCMREG_INV_ACC_INT_CLR_USB3H_SHIFT 9
#define  BCMREG_INV_ACC_INT_CLR_USB3H_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_USB3H_MASK) >> BCMREG_INV_ACC_INT_CLR_USB3H_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_USB3H_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_USB3H_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_USB3H_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_USB3D_MASK 0x100
#define  BCMREG_INV_ACC_INT_CLR_USB3D_SHIFT 8
#define  BCMREG_INV_ACC_INT_CLR_USB3D_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_USB3D_MASK) >> BCMREG_INV_ACC_INT_CLR_USB3D_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_USB3D_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_USB3D_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_USB3D_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_USB2_MASK 0x80
#define  BCMREG_INV_ACC_INT_CLR_USB2_SHIFT 7
#define  BCMREG_INV_ACC_INT_CLR_USB2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_USB2_MASK) >> BCMREG_INV_ACC_INT_CLR_USB2_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_USB2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_USB2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_USB2_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_LCD_MASK 0x40
#define  BCMREG_INV_ACC_INT_CLR_LCD_SHIFT 6
#define  BCMREG_INV_ACC_INT_CLR_LCD_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_LCD_MASK) >> BCMREG_INV_ACC_INT_CLR_LCD_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_LCD_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_LCD_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_LCD_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_PCIE0_MASK 0x20
#define  BCMREG_INV_ACC_INT_CLR_PCIE0_SHIFT 5
#define  BCMREG_INV_ACC_INT_CLR_PCIE0_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_PCIE0_MASK) >> BCMREG_INV_ACC_INT_CLR_PCIE0_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_PCIE0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_PCIE0_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_PCIE0_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_PCIE1_MASK 0x10
#define  BCMREG_INV_ACC_INT_CLR_PCIE1_SHIFT 4
#define  BCMREG_INV_ACC_INT_CLR_PCIE1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_PCIE1_MASK) >> BCMREG_INV_ACC_INT_CLR_PCIE1_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_PCIE1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_PCIE1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_PCIE1_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_SATA_MASK 0x8
#define  BCMREG_INV_ACC_INT_CLR_SATA_SHIFT 3
#define  BCMREG_INV_ACC_INT_CLR_SATA_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_SATA_MASK) >> BCMREG_INV_ACC_INT_CLR_SATA_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_SATA_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_SATA_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_SATA_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_SDMMC1_MASK 0x4
#define  BCMREG_INV_ACC_INT_CLR_SDMMC1_SHIFT 2
#define  BCMREG_INV_ACC_INT_CLR_SDMMC1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_SDMMC1_MASK) >> BCMREG_INV_ACC_INT_CLR_SDMMC1_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_SDMMC1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_SDMMC1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_SDMMC1_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_SDMMC2_MASK 0x2
#define  BCMREG_INV_ACC_INT_CLR_SDMMC2_SHIFT 1
#define  BCMREG_INV_ACC_INT_CLR_SDMMC2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_SDMMC2_MASK) >> BCMREG_INV_ACC_INT_CLR_SDMMC2_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_SDMMC2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_SDMMC2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_SDMMC2_SHIFT))

#define  BCMREG_INV_ACC_INT_CLR_SDMMC3_MASK 0x1
#define  BCMREG_INV_ACC_INT_CLR_SDMMC3_SHIFT 0
#define  BCMREG_INV_ACC_INT_CLR_SDMMC3_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_INT_CLR_SDMMC3_MASK) >> BCMREG_INV_ACC_INT_CLR_SDMMC3_SHIFT)
#define  BCMREG_INV_ACC_INT_CLR_SDMMC3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_INT_CLR_SDMMC3_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_INT_CLR_SDMMC3_SHIFT))

//====================================================================
//Register: Invalid Access Interrupt Status Register (INV_ACC_STA)
//====================================================================

#define  BCMREG_INV_ACC_STA_RESERVED1_MASK 0xfffc0000
#define  BCMREG_INV_ACC_STA_RESERVED1_SHIFT 18
#define  BCMREG_INV_ACC_STA_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_RESERVED1_MASK) >> BCMREG_INV_ACC_STA_RESERVED1_SHIFT)
#define  BCMREG_INV_ACC_STA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_RESERVED1_SHIFT))

#define  BCMREG_INV_ACC_STA_LAN_MASK 0x20000
#define  BCMREG_INV_ACC_STA_LAN_SHIFT 17
#define  BCMREG_INV_ACC_STA_LAN_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_LAN_MASK) >> BCMREG_INV_ACC_STA_LAN_SHIFT)
#define  BCMREG_INV_ACC_STA_LAN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_LAN_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_LAN_SHIFT))

#define  BCMREG_INV_ACC_STA_GC_MASK 0x10000
#define  BCMREG_INV_ACC_STA_GC_SHIFT 16
#define  BCMREG_INV_ACC_STA_GC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_GC_MASK) >> BCMREG_INV_ACC_STA_GC_SHIFT)
#define  BCMREG_INV_ACC_STA_GC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_GC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_GC_SHIFT))

#define  BCMREG_INV_ACC_STA_AP_SCCP_MASK 0x8000
#define  BCMREG_INV_ACC_STA_AP_SCCP_SHIFT 15
#define  BCMREG_INV_ACC_STA_AP_SCCP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_AP_SCCP_MASK) >> BCMREG_INV_ACC_STA_AP_SCCP_SHIFT)
#define  BCMREG_INV_ACC_STA_AP_SCCP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_AP_SCCP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_AP_SCCP_SHIFT))

#define  BCMREG_INV_ACC_STA_DAP_MASK 0x4000
#define  BCMREG_INV_ACC_STA_DAP_SHIFT 14
#define  BCMREG_INV_ACC_STA_DAP_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_DAP_MASK) >> BCMREG_INV_ACC_STA_DAP_SHIFT)
#define  BCMREG_INV_ACC_STA_DAP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_DAP_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_DAP_SHIFT))

#define  BCMREG_INV_ACC_STA_PDMA2_MASK 0x2000
#define  BCMREG_INV_ACC_STA_PDMA2_SHIFT 13
#define  BCMREG_INV_ACC_STA_PDMA2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_PDMA2_MASK) >> BCMREG_INV_ACC_STA_PDMA2_SHIFT)
#define  BCMREG_INV_ACC_STA_PDMA2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_PDMA2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_PDMA2_SHIFT))

#define  BCMREG_INV_ACC_STA_PDMA1_MASK 0x1000
#define  BCMREG_INV_ACC_STA_PDMA1_SHIFT 12
#define  BCMREG_INV_ACC_STA_PDMA1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_PDMA1_MASK) >> BCMREG_INV_ACC_STA_PDMA1_SHIFT)
#define  BCMREG_INV_ACC_STA_PDMA1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_PDMA1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_PDMA1_SHIFT))

#define  BCMREG_INV_ACC_STA_AP2MC_MASK 0x800
#define  BCMREG_INV_ACC_STA_AP2MC_SHIFT 11
#define  BCMREG_INV_ACC_STA_AP2MC_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_AP2MC_MASK) >> BCMREG_INV_ACC_STA_AP2MC_SHIFT)
#define  BCMREG_INV_ACC_STA_AP2MC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_AP2MC_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_AP2MC_SHIFT))

#define  BCMREG_INV_ACC_STA_AP2BUS_MASK 0x400
#define  BCMREG_INV_ACC_STA_AP2BUS_SHIFT 10
#define  BCMREG_INV_ACC_STA_AP2BUS_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_AP2BUS_MASK) >> BCMREG_INV_ACC_STA_AP2BUS_SHIFT)
#define  BCMREG_INV_ACC_STA_AP2BUS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_AP2BUS_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_AP2BUS_SHIFT))

#define  BCMREG_INV_ACC_STA_USB3H_MASK 0x200
#define  BCMREG_INV_ACC_STA_USB3H_SHIFT 9
#define  BCMREG_INV_ACC_STA_USB3H_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_USB3H_MASK) >> BCMREG_INV_ACC_STA_USB3H_SHIFT)
#define  BCMREG_INV_ACC_STA_USB3H_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_USB3H_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_USB3H_SHIFT))

#define  BCMREG_INV_ACC_STA_USB3D_MASK 0x100
#define  BCMREG_INV_ACC_STA_USB3D_SHIFT 8
#define  BCMREG_INV_ACC_STA_USB3D_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_USB3D_MASK) >> BCMREG_INV_ACC_STA_USB3D_SHIFT)
#define  BCMREG_INV_ACC_STA_USB3D_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_USB3D_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_USB3D_SHIFT))

#define  BCMREG_INV_ACC_STA_USB2_MASK 0x80
#define  BCMREG_INV_ACC_STA_USB2_SHIFT 7
#define  BCMREG_INV_ACC_STA_USB2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_USB2_MASK) >> BCMREG_INV_ACC_STA_USB2_SHIFT)
#define  BCMREG_INV_ACC_STA_USB2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_USB2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_USB2_SHIFT))

#define  BCMREG_INV_ACC_STA_LCD_MASK 0x40
#define  BCMREG_INV_ACC_STA_LCD_SHIFT 6
#define  BCMREG_INV_ACC_STA_LCD_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_LCD_MASK) >> BCMREG_INV_ACC_STA_LCD_SHIFT)
#define  BCMREG_INV_ACC_STA_LCD_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_LCD_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_LCD_SHIFT))

#define  BCMREG_INV_ACC_STA_PCIE0_MASK 0x20
#define  BCMREG_INV_ACC_STA_PCIE0_SHIFT 5
#define  BCMREG_INV_ACC_STA_PCIE0_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_PCIE0_MASK) >> BCMREG_INV_ACC_STA_PCIE0_SHIFT)
#define  BCMREG_INV_ACC_STA_PCIE0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_PCIE0_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_PCIE0_SHIFT))

#define  BCMREG_INV_ACC_STA_PCIE1_MASK 0x10
#define  BCMREG_INV_ACC_STA_PCIE1_SHIFT 4
#define  BCMREG_INV_ACC_STA_PCIE1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_PCIE1_MASK) >> BCMREG_INV_ACC_STA_PCIE1_SHIFT)
#define  BCMREG_INV_ACC_STA_PCIE1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_PCIE1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_PCIE1_SHIFT))

#define  BCMREG_INV_ACC_STA_SATA_MASK 0x8
#define  BCMREG_INV_ACC_STA_SATA_SHIFT 3
#define  BCMREG_INV_ACC_STA_SATA_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_SATA_MASK) >> BCMREG_INV_ACC_STA_SATA_SHIFT)
#define  BCMREG_INV_ACC_STA_SATA_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_SATA_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_SATA_SHIFT))

#define  BCMREG_INV_ACC_STA_SDMMC1_MASK 0x4
#define  BCMREG_INV_ACC_STA_SDMMC1_SHIFT 2
#define  BCMREG_INV_ACC_STA_SDMMC1_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_SDMMC1_MASK) >> BCMREG_INV_ACC_STA_SDMMC1_SHIFT)
#define  BCMREG_INV_ACC_STA_SDMMC1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_SDMMC1_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_SDMMC1_SHIFT))

#define  BCMREG_INV_ACC_STA_SDMMC2_MASK 0x2
#define  BCMREG_INV_ACC_STA_SDMMC2_SHIFT 1
#define  BCMREG_INV_ACC_STA_SDMMC2_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_SDMMC2_MASK) >> BCMREG_INV_ACC_STA_SDMMC2_SHIFT)
#define  BCMREG_INV_ACC_STA_SDMMC2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_SDMMC2_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_SDMMC2_SHIFT))

#define  BCMREG_INV_ACC_STA_SDMMC3_MASK 0x1
#define  BCMREG_INV_ACC_STA_SDMMC3_SHIFT 0
#define  BCMREG_INV_ACC_STA_SDMMC3_MASK_SHIFT(reg) (((reg) & BCMREG_INV_ACC_STA_SDMMC3_MASK) >> BCMREG_INV_ACC_STA_SDMMC3_SHIFT)
#define  BCMREG_INV_ACC_STA_SDMMC3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_INV_ACC_STA_SDMMC3_MASK) | (((uint32_t)val) << BCMREG_INV_ACC_STA_SDMMC3_SHIFT))

//====================================================================
//Register: Regulator Counters Control Register (REGULATOR_CNT_REG)
//====================================================================

#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_MASK 0xff000000
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_SHIFT 24
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_MASK) >> BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_REGULATOR_SWITCH_CNT_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_RESERVED1_MASK 0xf00000
#define  BCMREG_REGULATOR_CNT_REG_RESERVED1_SHIFT 20
#define  BCMREG_REGULATOR_CNT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_RESERVED1_MASK) >> BCMREG_REGULATOR_CNT_REG_RESERVED1_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_RESERVED1_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_RESERVED2_MASK 0xe0000
#define  BCMREG_REGULATOR_CNT_REG_RESERVED2_SHIFT 17
#define  BCMREG_REGULATOR_CNT_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_RESERVED2_MASK) >> BCMREG_REGULATOR_CNT_REG_RESERVED2_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_RESERVED2_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_RESERVED2_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_MASK 0x1fff0
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_SHIFT 4
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_MASK) >> BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_REGULATOR_READY_CNT_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_RESERVED3_MASK 0xc
#define  BCMREG_REGULATOR_CNT_REG_RESERVED3_SHIFT 2
#define  BCMREG_REGULATOR_CNT_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_RESERVED3_MASK) >> BCMREG_REGULATOR_CNT_REG_RESERVED3_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_RESERVED3_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_RESERVED3_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_MASK 0x2
#define  BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_SHIFT 1
#define  BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_MASK) >> BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_EN_SLCT_RSB_DN_SHIFT))

#define  BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_MASK 0x1
#define  BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_SHIFT 0
#define  BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_MASK_SHIFT(reg) (((reg) & BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_MASK) >> BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_SHIFT)
#define  BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_MASK) | (((uint32_t)val) << BCMREG_REGULATOR_CNT_REG_EN_REGULATORY_CNT_SHIFT))

//====================================================================
//Register: iKey Register (iKey4)
//====================================================================

#define  BCMREG_IKEY4_KEY_MASK 0xffffffff
#define  BCMREG_IKEY4_KEY_SHIFT 0
#define  BCMREG_IKEY4_KEY_MASK_SHIFT(reg) (((reg) & BCMREG_IKEY4_KEY_MASK) >> BCMREG_IKEY4_KEY_SHIFT)
#define  BCMREG_IKEY4_KEY_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IKEY4_KEY_MASK) | (((uint32_t)val) << BCMREG_IKEY4_KEY_SHIFT))

//====================================================================
//Register: iKey Register (iKey5)
//====================================================================

#define  BCMREG_IKEY5_KEY_MASK 0xffffffff
#define  BCMREG_IKEY5_KEY_SHIFT 0
#define  BCMREG_IKEY5_KEY_MASK_SHIFT(reg) (((reg) & BCMREG_IKEY5_KEY_MASK) >> BCMREG_IKEY5_KEY_SHIFT)
#define  BCMREG_IKEY5_KEY_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IKEY5_KEY_MASK) | (((uint32_t)val) << BCMREG_IKEY5_KEY_SHIFT))

//====================================================================
//Register: iKey Register (iKey6)
//====================================================================

#define  BCMREG_IKEY6_KEY_MASK 0xffffffff
#define  BCMREG_IKEY6_KEY_SHIFT 0
#define  BCMREG_IKEY6_KEY_MASK_SHIFT(reg) (((reg) & BCMREG_IKEY6_KEY_MASK) >> BCMREG_IKEY6_KEY_SHIFT)
#define  BCMREG_IKEY6_KEY_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IKEY6_KEY_MASK) | (((uint32_t)val) << BCMREG_IKEY6_KEY_SHIFT))

//====================================================================
//Register: iKey Register (iKey7)
//====================================================================

#define  BCMREG_IKEY7_KEY_MASK 0xffffffff
#define  BCMREG_IKEY7_KEY_SHIFT 0
#define  BCMREG_IKEY7_KEY_MASK_SHIFT(reg) (((reg) & BCMREG_IKEY7_KEY_MASK) >> BCMREG_IKEY7_KEY_SHIFT)
#define  BCMREG_IKEY7_KEY_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IKEY7_KEY_MASK) | (((uint32_t)val) << BCMREG_IKEY7_KEY_SHIFT))

//====================================================================
//Register: Secure Enable Control Register (SEC_CTRL0)
//====================================================================

#define  BCMREG_SEC_CTRL0_SQU_EN_MASK 0x80000000
#define  BCMREG_SEC_CTRL0_SQU_EN_SHIFT 31
#define  BCMREG_SEC_CTRL0_SQU_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_SQU_EN_MASK) >> BCMREG_SEC_CTRL0_SQU_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_SQU_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_SQU_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_SQU_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_USB3H_EN_MASK 0x40000000
#define  BCMREG_SEC_CTRL0_USB3H_EN_SHIFT 30
#define  BCMREG_SEC_CTRL0_USB3H_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_USB3H_EN_MASK) >> BCMREG_SEC_CTRL0_USB3H_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_USB3H_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_USB3H_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_USB3H_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_USB3D_EN_MASK 0x20000000
#define  BCMREG_SEC_CTRL0_USB3D_EN_SHIFT 29
#define  BCMREG_SEC_CTRL0_USB3D_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_USB3D_EN_MASK) >> BCMREG_SEC_CTRL0_USB3D_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_USB3D_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_USB3D_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_USB3D_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_USB2_EN_MASK 0x10000000
#define  BCMREG_SEC_CTRL0_USB2_EN_SHIFT 28
#define  BCMREG_SEC_CTRL0_USB2_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_USB2_EN_MASK) >> BCMREG_SEC_CTRL0_USB2_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_USB2_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_USB2_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_USB2_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_CDMA0_EN_MASK 0x8000000
#define  BCMREG_SEC_CTRL0_CDMA0_EN_SHIFT 27
#define  BCMREG_SEC_CTRL0_CDMA0_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_CDMA0_EN_MASK) >> BCMREG_SEC_CTRL0_CDMA0_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_CDMA0_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_CDMA0_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_CDMA0_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_CDMA1_EN_MASK 0x4000000
#define  BCMREG_SEC_CTRL0_CDMA1_EN_SHIFT 26
#define  BCMREG_SEC_CTRL0_CDMA1_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_CDMA1_EN_MASK) >> BCMREG_SEC_CTRL0_CDMA1_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_CDMA1_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_CDMA1_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_CDMA1_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_CIU_EN_MASK 0x2000000
#define  BCMREG_SEC_CTRL0_CIU_EN_SHIFT 25
#define  BCMREG_SEC_CTRL0_CIU_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_CIU_EN_MASK) >> BCMREG_SEC_CTRL0_CIU_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_CIU_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_CIU_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_CIU_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_UART_EN_MASK 0x1000000
#define  BCMREG_SEC_CTRL0_UART_EN_SHIFT 24
#define  BCMREG_SEC_CTRL0_UART_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_UART_EN_MASK) >> BCMREG_SEC_CTRL0_UART_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_UART_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_UART_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_UART_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_RESERVED1_MASK 0xc00000
#define  BCMREG_SEC_CTRL0_RESERVED1_SHIFT 22
#define  BCMREG_SEC_CTRL0_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_RESERVED1_MASK) >> BCMREG_SEC_CTRL0_RESERVED1_SHIFT)
#define  BCMREG_SEC_CTRL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_RESERVED1_SHIFT))

#define  BCMREG_SEC_CTRL0_CSS_EN_MASK 0x200000
#define  BCMREG_SEC_CTRL0_CSS_EN_SHIFT 21
#define  BCMREG_SEC_CTRL0_CSS_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_CSS_EN_MASK) >> BCMREG_SEC_CTRL0_CSS_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_CSS_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_CSS_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_CSS_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_LCD_EN_MASK 0x100000
#define  BCMREG_SEC_CTRL0_LCD_EN_SHIFT 20
#define  BCMREG_SEC_CTRL0_LCD_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_LCD_EN_MASK) >> BCMREG_SEC_CTRL0_LCD_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_LCD_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_LCD_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_LCD_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_BUS_EN_MASK 0x80000
#define  BCMREG_SEC_CTRL0_BUS_EN_SHIFT 19
#define  BCMREG_SEC_CTRL0_BUS_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_BUS_EN_MASK) >> BCMREG_SEC_CTRL0_BUS_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_BUS_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_BUS_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_BUS_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_MC_EN_MASK 0x40000
#define  BCMREG_SEC_CTRL0_MC_EN_SHIFT 18
#define  BCMREG_SEC_CTRL0_MC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_MC_EN_MASK) >> BCMREG_SEC_CTRL0_MC_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_MC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_MC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_MC_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_I2C_EN_MASK 0x20000
#define  BCMREG_SEC_CTRL0_I2C_EN_SHIFT 17
#define  BCMREG_SEC_CTRL0_I2C_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_I2C_EN_MASK) >> BCMREG_SEC_CTRL0_I2C_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_I2C_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_I2C_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_I2C_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_ICU_EN_MASK 0x10000
#define  BCMREG_SEC_CTRL0_ICU_EN_SHIFT 16
#define  BCMREG_SEC_CTRL0_ICU_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_ICU_EN_MASK) >> BCMREG_SEC_CTRL0_ICU_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_ICU_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_ICU_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_ICU_EN_SHIFT))

#define  BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_MASK 0xffff
#define  BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_SHIFT 0
#define  BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_MASK) >> BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_SHIFT)
#define  BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL0_PDMA0_15_0_SEC_EN_SHIFT))

//====================================================================
//Register: Secure Enable Control Register (SEC_CTRL1)
//====================================================================

#define  BCMREG_SEC_CTRL1_RESERVED1_MASK 0xfc000000
#define  BCMREG_SEC_CTRL1_RESERVED1_SHIFT 26
#define  BCMREG_SEC_CTRL1_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_RESERVED1_MASK) >> BCMREG_SEC_CTRL1_RESERVED1_SHIFT)
#define  BCMREG_SEC_CTRL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_RESERVED1_SHIFT))

#define  BCMREG_SEC_CTRL1_AP_GIC400_EN_MASK 0x2000000
#define  BCMREG_SEC_CTRL1_AP_GIC400_EN_SHIFT 25
#define  BCMREG_SEC_CTRL1_AP_GIC400_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_AP_GIC400_EN_MASK) >> BCMREG_SEC_CTRL1_AP_GIC400_EN_SHIFT)
#define  BCMREG_SEC_CTRL1_AP_GIC400_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_AP_GIC400_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_AP_GIC400_EN_SHIFT))

#define  BCMREG_SEC_CTRL1_SP_GIC400_EN_MASK 0x1000000
#define  BCMREG_SEC_CTRL1_SP_GIC400_EN_SHIFT 24
#define  BCMREG_SEC_CTRL1_SP_GIC400_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_SP_GIC400_EN_MASK) >> BCMREG_SEC_CTRL1_SP_GIC400_EN_SHIFT)
#define  BCMREG_SEC_CTRL1_SP_GIC400_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_SP_GIC400_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_SP_GIC400_EN_SHIFT))

#define  BCMREG_SEC_CTRL1_WDT_EN_MASK 0x800000
#define  BCMREG_SEC_CTRL1_WDT_EN_SHIFT 23
#define  BCMREG_SEC_CTRL1_WDT_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_WDT_EN_MASK) >> BCMREG_SEC_CTRL1_WDT_EN_SHIFT)
#define  BCMREG_SEC_CTRL1_WDT_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_WDT_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_WDT_EN_SHIFT))

#define  BCMREG_SEC_CTRL1_RESERVED2_MASK 0x400000
#define  BCMREG_SEC_CTRL1_RESERVED2_SHIFT 22
#define  BCMREG_SEC_CTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_RESERVED2_MASK) >> BCMREG_SEC_CTRL1_RESERVED2_SHIFT)
#define  BCMREG_SEC_CTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_RESERVED2_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_RESERVED2_SHIFT))

#define  BCMREG_SEC_CTRL1_SSP1_EN_MASK 0x200000
#define  BCMREG_SEC_CTRL1_SSP1_EN_SHIFT 21
#define  BCMREG_SEC_CTRL1_SSP1_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_SSP1_EN_MASK) >> BCMREG_SEC_CTRL1_SSP1_EN_SHIFT)
#define  BCMREG_SEC_CTRL1_SSP1_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_SSP1_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_SSP1_EN_SHIFT))

#define  BCMREG_SEC_CTRL1_CORE2BUS_DIS_MASK 0x100000
#define  BCMREG_SEC_CTRL1_CORE2BUS_DIS_SHIFT 20
#define  BCMREG_SEC_CTRL1_CORE2BUS_DIS_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_CORE2BUS_DIS_MASK) >> BCMREG_SEC_CTRL1_CORE2BUS_DIS_SHIFT)
#define  BCMREG_SEC_CTRL1_CORE2BUS_DIS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_CORE2BUS_DIS_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_CORE2BUS_DIS_SHIFT))

#define  BCMREG_SEC_CTRL1_CORE2DDR_DIS_MASK 0x80000
#define  BCMREG_SEC_CTRL1_CORE2DDR_DIS_SHIFT 19
#define  BCMREG_SEC_CTRL1_CORE2DDR_DIS_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_CORE2DDR_DIS_MASK) >> BCMREG_SEC_CTRL1_CORE2DDR_DIS_SHIFT)
#define  BCMREG_SEC_CTRL1_CORE2DDR_DIS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_CORE2DDR_DIS_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_CORE2DDR_DIS_SHIFT))

#define  BCMREG_SEC_CTRL1_RESERVED3_MASK 0x70000
#define  BCMREG_SEC_CTRL1_RESERVED3_SHIFT 16
#define  BCMREG_SEC_CTRL1_RESERVED3_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_RESERVED3_MASK) >> BCMREG_SEC_CTRL1_RESERVED3_SHIFT)
#define  BCMREG_SEC_CTRL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_RESERVED3_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_RESERVED3_SHIFT))

#define  BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_MASK 0xffff
#define  BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_SHIFT 0
#define  BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_MASK) >> BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_SHIFT)
#define  BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_CTRL1_PDMA1_15_0_SEC_EN_SHIFT))

//====================================================================
//Register: Debug Valid Code Register (DEBUG_VALID_CODE)
/** \brief This register is written by the Dragonite in the debug enable/disable process.
This register is not affected by JTAG or PXA2128 SoC reset.*/
//====================================================================

#define  BCMREG_DEBUG_VALID_CODE_RESERVED1_MASK 0xffff0000
#define  BCMREG_DEBUG_VALID_CODE_RESERVED1_SHIFT 16
#define  BCMREG_DEBUG_VALID_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DEBUG_VALID_CODE_RESERVED1_MASK) >> BCMREG_DEBUG_VALID_CODE_RESERVED1_SHIFT)
#define  BCMREG_DEBUG_VALID_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DEBUG_VALID_CODE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DEBUG_VALID_CODE_RESERVED1_SHIFT))

#define  BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_MASK 0xffff
#define  BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT 0
#define  BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_MASK_SHIFT(reg) (((reg) & BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_MASK) >> BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT)
#define  BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_MASK) | (((uint32_t)val) << BCMREG_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT))

//====================================================================
//Register: Debug Disable Register (DEBUG_DISABLE)
/** \brief This register is written by the Dragonite in the debug enable/disable process.*/
//====================================================================

#define  BCMREG_DEBUG_DISABLE_RESERVED1_MASK 0xfffffffe
#define  BCMREG_DEBUG_DISABLE_RESERVED1_SHIFT 1
#define  BCMREG_DEBUG_DISABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DEBUG_DISABLE_RESERVED1_MASK) >> BCMREG_DEBUG_DISABLE_RESERVED1_SHIFT)
#define  BCMREG_DEBUG_DISABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DEBUG_DISABLE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DEBUG_DISABLE_RESERVED1_SHIFT))

#define  BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_MASK 0x1
#define  BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT 0
#define  BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_MASK_SHIFT(reg) (((reg) & BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_MASK) >> BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT)
#define  BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_MASK) | (((uint32_t)val) << BCMREG_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT))

//====================================================================
//Register: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 1 of 4) (WTM_FUSE_PROG_VAL10)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL10_FUSE_3_0_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 2 of 4) (WTM_FUSE_PROG_VAL11)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL11_FUSE_3_0_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 3 of 4) (WTM_FUSE_PROG_VAL12)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL12_FUSE_3_0_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[127:0] in Software Fuse Programming Mode Register (Instance 4 of 4) (WTM_FUSE_PROG_VAL13)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL13_FUSE_3_0_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 1 of 4) (WTM_FUSE_PROG_VAL20)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL20_FUSE_7_4_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 2 of 4) (WTM_FUSE_PROG_VAL21)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL21_FUSE_7_4_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 3 of 4) (WTM_FUSE_PROG_VAL22)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL22_FUSE_7_4_31_0_SHIFT))

//====================================================================
//Register: Fuse Programming Value[255:128] in Software Fuse Programming Mode Register (Instance 4 of 4) (WTM_FUSE_PROG_VAL23)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_MASK) >> BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_PROG_VAL23_FUSE_7_4_31_0_SHIFT))

//====================================================================
//Register: Debug Valid Code Register (DAP_DEBUG_VALID_CODE)
/** \brief This register is written by the Dragonite in the debug enable/disable process.
This register is not affected by JTAG or PXA2128 SoC reset.*/
//====================================================================

#define  BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_MASK 0xffff0000
#define  BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_SHIFT 16
#define  BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_MASK) >> BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_SHIFT)
#define  BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DAP_DEBUG_VALID_CODE_RESERVED1_SHIFT))

#define  BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_MASK 0xffff
#define  BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT 0
#define  BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_MASK_SHIFT(reg) (((reg) & BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_MASK) >> BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT)
#define  BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_MASK) | (((uint32_t)val) << BCMREG_DAP_DEBUG_VALID_CODE_DEBUGVCODE_SHIFT))

//====================================================================
//Register: Debug Disable Register (DAP_DEBUG_DISABLE)
/** \brief This register is written by the Dragonite in the debug enable/disable process.*/
//====================================================================

#define  BCMREG_DAP_DEBUG_DISABLE_RESERVED1_MASK 0xfffffffe
#define  BCMREG_DAP_DEBUG_DISABLE_RESERVED1_SHIFT 1
#define  BCMREG_DAP_DEBUG_DISABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DAP_DEBUG_DISABLE_RESERVED1_MASK) >> BCMREG_DAP_DEBUG_DISABLE_RESERVED1_SHIFT)
#define  BCMREG_DAP_DEBUG_DISABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DAP_DEBUG_DISABLE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DAP_DEBUG_DISABLE_RESERVED1_SHIFT))

#define  BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_MASK 0x1
#define  BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT 0
#define  BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_MASK_SHIFT(reg) (((reg) & BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_MASK) >> BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT)
#define  BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_MASK) | (((uint32_t)val) << BCMREG_DAP_DEBUG_DISABLE_DEBUG_DISABLE_SHIFT))

//====================================================================
//Register: iKey Register (CFG_CORRECTION)
//====================================================================

#define  BCMREG_CFG_CORRECTION_RESERVED1_MASK 0xffff0000
#define  BCMREG_CFG_CORRECTION_RESERVED1_SHIFT 16
#define  BCMREG_CFG_CORRECTION_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_CFG_CORRECTION_RESERVED1_MASK) >> BCMREG_CFG_CORRECTION_RESERVED1_SHIFT)
#define  BCMREG_CFG_CORRECTION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_CFG_CORRECTION_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_CFG_CORRECTION_RESERVED1_SHIFT))

#define  BCMREG_CFG_CORRECTION_CFG_MASK 0xffff
#define  BCMREG_CFG_CORRECTION_CFG_SHIFT 0
#define  BCMREG_CFG_CORRECTION_CFG_MASK_SHIFT(reg) (((reg) & BCMREG_CFG_CORRECTION_CFG_MASK) >> BCMREG_CFG_CORRECTION_CFG_SHIFT)
#define  BCMREG_CFG_CORRECTION_CFG_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_CFG_CORRECTION_CFG_MASK) | (((uint32_t)val) << BCMREG_CFG_CORRECTION_CFG_SHIFT))

//====================================================================
//Register: Reserved Register (DOUT_3)
//====================================================================

#define  BCMREG_DOUT_3_RESERVED1_MASK 0xffffffff
#define  BCMREG_DOUT_3_RESERVED1_SHIFT 0
#define  BCMREG_DOUT_3_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DOUT_3_RESERVED1_MASK) >> BCMREG_DOUT_3_RESERVED1_SHIFT)
#define  BCMREG_DOUT_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DOUT_3_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DOUT_3_RESERVED1_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 4) (RKEK0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_RKEK0_VAL_MASK 0xffffffff
#define  BCMREG_RKEK0_VAL_SHIFT 0
#define  BCMREG_RKEK0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_RKEK0_VAL_MASK) >> BCMREG_RKEK0_VAL_SHIFT)
#define  BCMREG_RKEK0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RKEK0_VAL_MASK) | (((uint32_t)val) << BCMREG_RKEK0_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 4) (RKEK1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_RKEK1_VAL_MASK 0xffffffff
#define  BCMREG_RKEK1_VAL_SHIFT 0
#define  BCMREG_RKEK1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_RKEK1_VAL_MASK) >> BCMREG_RKEK1_VAL_SHIFT)
#define  BCMREG_RKEK1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RKEK1_VAL_MASK) | (((uint32_t)val) << BCMREG_RKEK1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 4) (RKEK2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_RKEK2_VAL_MASK 0xffffffff
#define  BCMREG_RKEK2_VAL_SHIFT 0
#define  BCMREG_RKEK2_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_RKEK2_VAL_MASK) >> BCMREG_RKEK2_VAL_SHIFT)
#define  BCMREG_RKEK2_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RKEK2_VAL_MASK) | (((uint32_t)val) << BCMREG_RKEK2_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 4) (RKEK3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_RKEK3_VAL_MASK 0xffffffff
#define  BCMREG_RKEK3_VAL_SHIFT 0
#define  BCMREG_RKEK3_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_RKEK3_VAL_MASK) >> BCMREG_RKEK3_VAL_SHIFT)
#define  BCMREG_RKEK3_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RKEK3_VAL_MASK) | (((uint32_t)val) << BCMREG_RKEK3_VAL_SHIFT))

//====================================================================
//Register: JTAG Bypass Control Register for various cores (JTAG_DBG_BYPASS_CNTL0)
//====================================================================

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_MASK 0xf8000000
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_SHIFT 27
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_BREAK_MOLTRES_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_MASK 0x7f00000
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_SHIFT 20
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED1_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_MASK 0xf8000
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_SHIFT 15
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_DUMMY_IR_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_MASK 0x7c00
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_SHIFT 10
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED2_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_MASK 0x200
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_SHIFT 9
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_JTAG_P_DIS_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_MASK 0x100
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_SHIFT 8
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DD_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_MASK 0x80
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_SHIFT 7
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2DM_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_MASK 0x40
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_SHIFT 6
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_LCS2CM_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_MASK 0x30
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_SHIFT 4
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED3_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_MASK 0x8
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_SHIFT 3
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_AP_TAP_BYPASS_LP_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_MASK 0x4
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_SHIFT 2
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_RESERVED4_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_MASK 0x2
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_SHIFT 1
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_SP_DBG_EN_CNTRL_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_MASK 0x1
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_SHIFT 0
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL0_DAP_TAP_BYPASS_SHIFT))

//====================================================================
//Register: JTAG Bypass Control Register for various cores (JTAG_DBG_BYPASS_CNTL1)
//====================================================================

#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_MASK 0xfffffffc
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_SHIFT 2
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL1_RESERVED1_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_MASK 0x2
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_SHIFT 1
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL1_JTAG_FORCE_SHIFT))

#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_MASK 0x1
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_SHIFT 0
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_MASK) >> BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_SHIFT)
#define  BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_MASK) | (((uint32_t)val) << BCMREG_JTAG_DBG_BYPASS_CNTL1_BREAK_MOLTRES_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (DFX)
//====================================================================

#define  BCMREG_DFX_RESERVED1_MASK 0xfffffffe
#define  BCMREG_DFX_RESERVED1_SHIFT 1
#define  BCMREG_DFX_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_DFX_RESERVED1_MASK) >> BCMREG_DFX_RESERVED1_SHIFT)
#define  BCMREG_DFX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DFX_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_DFX_RESERVED1_SHIFT))

#define  BCMREG_DFX_CASCADE_MASK 0x1
#define  BCMREG_DFX_CASCADE_SHIFT 0
#define  BCMREG_DFX_CASCADE_MASK_SHIFT(reg) (((reg) & BCMREG_DFX_CASCADE_MASK) >> BCMREG_DFX_CASCADE_SHIFT)
#define  BCMREG_DFX_CASCADE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_DFX_CASCADE_MASK) | (((uint32_t)val) << BCMREG_DFX_CASCADE_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD2)
//====================================================================

#define  BCMREG_RSVD2_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD2_RESERVED1_SHIFT 0
#define  BCMREG_RSVD2_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD2_RESERVED1_MASK) >> BCMREG_RSVD2_RESERVED1_SHIFT)
#define  BCMREG_RSVD2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD2_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD2_RESERVED1_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank30)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK30_VAL_MASK 0xffffffff
#define  BCMREG_BANK30_VAL_SHIFT 0
#define  BCMREG_BANK30_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK30_VAL_MASK) >> BCMREG_BANK30_VAL_SHIFT)
#define  BCMREG_BANK30_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK30_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK30_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank31)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK31_VAL_MASK 0xffffffff
#define  BCMREG_BANK31_VAL_SHIFT 0
#define  BCMREG_BANK31_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK31_VAL_MASK) >> BCMREG_BANK31_VAL_SHIFT)
#define  BCMREG_BANK31_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK31_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK31_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank32)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK32_VAL_MASK 0xffffffff
#define  BCMREG_BANK32_VAL_SHIFT 0
#define  BCMREG_BANK32_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK32_VAL_MASK) >> BCMREG_BANK32_VAL_SHIFT)
#define  BCMREG_BANK32_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK32_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK32_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank33)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK33_VAL_MASK 0xffffffff
#define  BCMREG_BANK33_VAL_SHIFT 0
#define  BCMREG_BANK33_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK33_VAL_MASK) >> BCMREG_BANK33_VAL_SHIFT)
#define  BCMREG_BANK33_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK33_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK33_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank34)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK34_VAL_MASK 0xffffffff
#define  BCMREG_BANK34_VAL_SHIFT 0
#define  BCMREG_BANK34_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK34_VAL_MASK) >> BCMREG_BANK34_VAL_SHIFT)
#define  BCMREG_BANK34_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK34_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK34_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank35)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK35_VAL_MASK 0xffffffff
#define  BCMREG_BANK35_VAL_SHIFT 0
#define  BCMREG_BANK35_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK35_VAL_MASK) >> BCMREG_BANK35_VAL_SHIFT)
#define  BCMREG_BANK35_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK35_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK35_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank36)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK36_VAL_MASK 0xffffffff
#define  BCMREG_BANK36_VAL_SHIFT 0
#define  BCMREG_BANK36_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK36_VAL_MASK) >> BCMREG_BANK36_VAL_SHIFT)
#define  BCMREG_BANK36_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK36_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK36_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank37)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK37_VAL_MASK 0xffffffff
#define  BCMREG_BANK37_VAL_SHIFT 0
#define  BCMREG_BANK37_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK37_VAL_MASK) >> BCMREG_BANK37_VAL_SHIFT)
#define  BCMREG_BANK37_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK37_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK37_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank80)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK80_VAL_MASK 0xffffffff
#define  BCMREG_BANK80_VAL_SHIFT 0
#define  BCMREG_BANK80_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK80_VAL_MASK) >> BCMREG_BANK80_VAL_SHIFT)
#define  BCMREG_BANK80_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK80_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK80_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank81)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK81_VAL_MASK 0xffffffff
#define  BCMREG_BANK81_VAL_SHIFT 0
#define  BCMREG_BANK81_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK81_VAL_MASK) >> BCMREG_BANK81_VAL_SHIFT)
#define  BCMREG_BANK81_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK81_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK81_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank82)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK82_VAL_MASK 0xffffffff
#define  BCMREG_BANK82_VAL_SHIFT 0
#define  BCMREG_BANK82_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK82_VAL_MASK) >> BCMREG_BANK82_VAL_SHIFT)
#define  BCMREG_BANK82_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK82_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK82_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank83)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK83_VAL_MASK 0xffffffff
#define  BCMREG_BANK83_VAL_SHIFT 0
#define  BCMREG_BANK83_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK83_VAL_MASK) >> BCMREG_BANK83_VAL_SHIFT)
#define  BCMREG_BANK83_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK83_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK83_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank84)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK84_VAL_MASK 0xffffffff
#define  BCMREG_BANK84_VAL_SHIFT 0
#define  BCMREG_BANK84_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK84_VAL_MASK) >> BCMREG_BANK84_VAL_SHIFT)
#define  BCMREG_BANK84_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK84_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK84_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank85)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK85_VAL_MASK 0xffffffff
#define  BCMREG_BANK85_VAL_SHIFT 0
#define  BCMREG_BANK85_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK85_VAL_MASK) >> BCMREG_BANK85_VAL_SHIFT)
#define  BCMREG_BANK85_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK85_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK85_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank86)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK86_VAL_MASK 0xffffffff
#define  BCMREG_BANK86_VAL_SHIFT 0
#define  BCMREG_BANK86_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK86_VAL_MASK) >> BCMREG_BANK86_VAL_SHIFT)
#define  BCMREG_BANK86_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK86_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK86_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank87)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK87_VAL_MASK 0xffffffff
#define  BCMREG_BANK87_VAL_SHIFT 0
#define  BCMREG_BANK87_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK87_VAL_MASK) >> BCMREG_BANK87_VAL_SHIFT)
#define  BCMREG_BANK87_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK87_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK87_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 4) (Bank9_L0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_BANK9_L0_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_L0_VAL_SHIFT 0
#define  BCMREG_BANK9_L0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_L0_VAL_MASK) >> BCMREG_BANK9_L0_VAL_SHIFT)
#define  BCMREG_BANK9_L0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_L0_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_L0_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 4) (Bank9_L1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_BANK9_L1_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_L1_VAL_SHIFT 0
#define  BCMREG_BANK9_L1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_L1_VAL_MASK) >> BCMREG_BANK9_L1_VAL_SHIFT)
#define  BCMREG_BANK9_L1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_L1_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_L1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 4) (Bank9_L2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_BANK9_L2_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_L2_VAL_SHIFT 0
#define  BCMREG_BANK9_L2_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_L2_VAL_MASK) >> BCMREG_BANK9_L2_VAL_SHIFT)
#define  BCMREG_BANK9_L2_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_L2_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_L2_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 4) (Bank9_L3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_BANK9_L3_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_L3_VAL_SHIFT 0
#define  BCMREG_BANK9_L3_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_L3_VAL_MASK) >> BCMREG_BANK9_L3_VAL_SHIFT)
#define  BCMREG_BANK9_L3_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_L3_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_L3_VAL_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 1 of 8) (SP2JTAG_MBOX0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX0_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX0_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX0_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX0_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX0_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX0_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX0_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX0_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 2 of 8) (SP2JTAG_MBOX1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX1_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX1_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX1_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX1_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX1_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX1_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX1_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX1_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 3 of 8) (SP2JTAG_MBOX2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX2_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX2_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX2_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX2_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX2_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX2_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX2_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX2_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 4 of 8) (SP2JTAG_MBOX3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX3_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX3_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX3_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX3_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX3_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX3_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX3_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX3_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 5 of 8) (SP2JTAG_MBOX4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX4_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX4_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX4_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX4_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX4_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX4_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX4_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX4_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 6 of 8) (SP2JTAG_MBOX5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX5_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX5_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX5_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX5_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX5_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX5_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX5_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX5_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 7 of 8) (SP2JTAG_MBOX6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX6_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX6_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX6_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX6_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX6_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX6_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX6_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX6_MESSAGE_SHIFT))

//====================================================================
//Register: Mailbox to JTAG Register (Instance 8 of 8) (SP2JTAG_MBOX7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_SP2JTAG_MBOX7_MESSAGE_MASK 0xffffffff
#define  BCMREG_SP2JTAG_MBOX7_MESSAGE_SHIFT 0
#define  BCMREG_SP2JTAG_MBOX7_MESSAGE_MASK_SHIFT(reg) (((reg) & BCMREG_SP2JTAG_MBOX7_MESSAGE_MASK) >> BCMREG_SP2JTAG_MBOX7_MESSAGE_SHIFT)
#define  BCMREG_SP2JTAG_MBOX7_MESSAGE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SP2JTAG_MBOX7_MESSAGE_MASK) | (((uint32_t)val) << BCMREG_SP2JTAG_MBOX7_MESSAGE_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (FuseTest)
//====================================================================

#define  BCMREG_FUSETEST_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETEST_RESERVED1_SHIFT 8
#define  BCMREG_FUSETEST_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETEST_RESERVED1_MASK) >> BCMREG_FUSETEST_RESERVED1_SHIFT)
#define  BCMREG_FUSETEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETEST_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETEST_RESERVED1_SHIFT))

#define  BCMREG_FUSETEST_TESTBITS_MASK 0xff
#define  BCMREG_FUSETEST_TESTBITS_SHIFT 0
#define  BCMREG_FUSETEST_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETEST_TESTBITS_MASK) >> BCMREG_FUSETEST_TESTBITS_SHIFT)
#define  BCMREG_FUSETEST_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETEST_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETEST_TESTBITS_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank00)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK00_VAL_MASK 0xffffffff
#define  BCMREG_BANK00_VAL_SHIFT 0
#define  BCMREG_BANK00_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK00_VAL_MASK) >> BCMREG_BANK00_VAL_SHIFT)
#define  BCMREG_BANK00_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK00_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK00_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank01)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK01_VAL_MASK 0xffffffff
#define  BCMREG_BANK01_VAL_SHIFT 0
#define  BCMREG_BANK01_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK01_VAL_MASK) >> BCMREG_BANK01_VAL_SHIFT)
#define  BCMREG_BANK01_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK01_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK01_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank02)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK02_VAL_MASK 0xffffffff
#define  BCMREG_BANK02_VAL_SHIFT 0
#define  BCMREG_BANK02_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK02_VAL_MASK) >> BCMREG_BANK02_VAL_SHIFT)
#define  BCMREG_BANK02_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK02_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK02_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank03)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK03_VAL_MASK 0xffffffff
#define  BCMREG_BANK03_VAL_SHIFT 0
#define  BCMREG_BANK03_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK03_VAL_MASK) >> BCMREG_BANK03_VAL_SHIFT)
#define  BCMREG_BANK03_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK03_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK03_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank04)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK04_VAL_MASK 0xffffffff
#define  BCMREG_BANK04_VAL_SHIFT 0
#define  BCMREG_BANK04_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK04_VAL_MASK) >> BCMREG_BANK04_VAL_SHIFT)
#define  BCMREG_BANK04_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK04_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK04_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank05)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK05_VAL_MASK 0xffffffff
#define  BCMREG_BANK05_VAL_SHIFT 0
#define  BCMREG_BANK05_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK05_VAL_MASK) >> BCMREG_BANK05_VAL_SHIFT)
#define  BCMREG_BANK05_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK05_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK05_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank06)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK06_VAL_MASK 0xffffffff
#define  BCMREG_BANK06_VAL_SHIFT 0
#define  BCMREG_BANK06_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK06_VAL_MASK) >> BCMREG_BANK06_VAL_SHIFT)
#define  BCMREG_BANK06_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK06_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK06_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank07)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK07_VAL_MASK 0xffffffff
#define  BCMREG_BANK07_VAL_SHIFT 0
#define  BCMREG_BANK07_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK07_VAL_MASK) >> BCMREG_BANK07_VAL_SHIFT)
#define  BCMREG_BANK07_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK07_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK07_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank10)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK10_VAL_MASK 0xffffffff
#define  BCMREG_BANK10_VAL_SHIFT 0
#define  BCMREG_BANK10_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK10_VAL_MASK) >> BCMREG_BANK10_VAL_SHIFT)
#define  BCMREG_BANK10_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK10_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK10_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank11)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK11_VAL_MASK 0xffffffff
#define  BCMREG_BANK11_VAL_SHIFT 0
#define  BCMREG_BANK11_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK11_VAL_MASK) >> BCMREG_BANK11_VAL_SHIFT)
#define  BCMREG_BANK11_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK11_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK11_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank12)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK12_VAL_MASK 0xffffffff
#define  BCMREG_BANK12_VAL_SHIFT 0
#define  BCMREG_BANK12_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK12_VAL_MASK) >> BCMREG_BANK12_VAL_SHIFT)
#define  BCMREG_BANK12_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK12_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK12_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank13)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK13_VAL_MASK 0xffffffff
#define  BCMREG_BANK13_VAL_SHIFT 0
#define  BCMREG_BANK13_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK13_VAL_MASK) >> BCMREG_BANK13_VAL_SHIFT)
#define  BCMREG_BANK13_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK13_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK13_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank14)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK14_VAL_MASK 0xffffffff
#define  BCMREG_BANK14_VAL_SHIFT 0
#define  BCMREG_BANK14_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK14_VAL_MASK) >> BCMREG_BANK14_VAL_SHIFT)
#define  BCMREG_BANK14_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK14_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK14_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank15)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK15_VAL_MASK 0xffffffff
#define  BCMREG_BANK15_VAL_SHIFT 0
#define  BCMREG_BANK15_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK15_VAL_MASK) >> BCMREG_BANK15_VAL_SHIFT)
#define  BCMREG_BANK15_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK15_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK15_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank16)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK16_VAL_MASK 0xffffffff
#define  BCMREG_BANK16_VAL_SHIFT 0
#define  BCMREG_BANK16_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK16_VAL_MASK) >> BCMREG_BANK16_VAL_SHIFT)
#define  BCMREG_BANK16_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK16_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK16_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank17)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK17_VAL_MASK 0xffffffff
#define  BCMREG_BANK17_VAL_SHIFT 0
#define  BCMREG_BANK17_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK17_VAL_MASK) >> BCMREG_BANK17_VAL_SHIFT)
#define  BCMREG_BANK17_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK17_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK17_VAL_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 1 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH0_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 2 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH1_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 3 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH2_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 4 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH3_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 5 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH4_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 6 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH5_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 7 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH6_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM Key Hash Registers 1- 8 (Instance 8 of 8) (WTM_FUSE_VAL_OEM_KEY_HASH7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_KEY_HASH7_OTP_OEM_KEY_HASH_31_0_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 1 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH0_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 2 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH1_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 3 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH2_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 4 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH3_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 5 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH4_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 6 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH5_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 7 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH6_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash Registers 1- 8 (Instance 8 of 8) (WTM_FUSE_VAL_OEM_JTAG_HASH7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_HASH7_OEM_JTAG_KEY_HASH_SHIFT))

//====================================================================
//Register: Fuse Operation Status Register (WTM_FUSE_STATUS)
//====================================================================

#define  BCMREG_WTM_FUSE_STATUS_RESERVED1_MASK 0xf8000000
#define  BCMREG_WTM_FUSE_STATUS_RESERVED1_SHIFT 27
#define  BCMREG_WTM_FUSE_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_RESERVED1_MASK) >> BCMREG_WTM_FUSE_STATUS_RESERVED1_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_RESERVED1_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_MASK 0x7000000
#define  BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_SHIFT 24
#define  BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_MASK) >> BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LCS_JTAG_DISABLE_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LCS_FA_MASK 0xe00000
#define  BCMREG_WTM_FUSE_STATUS_LCS_FA_SHIFT 21
#define  BCMREG_WTM_FUSE_STATUS_LCS_FA_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LCS_FA_MASK) >> BCMREG_WTM_FUSE_STATUS_LCS_FA_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LCS_FA_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LCS_FA_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LCS_FA_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LCS_DD_MASK 0x1c0000
#define  BCMREG_WTM_FUSE_STATUS_LCS_DD_SHIFT 18
#define  BCMREG_WTM_FUSE_STATUS_LCS_DD_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LCS_DD_MASK) >> BCMREG_WTM_FUSE_STATUS_LCS_DD_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LCS_DD_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LCS_DD_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LCS_DD_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LCS_DM_MASK 0x38000
#define  BCMREG_WTM_FUSE_STATUS_LCS_DM_SHIFT 15
#define  BCMREG_WTM_FUSE_STATUS_LCS_DM_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LCS_DM_MASK) >> BCMREG_WTM_FUSE_STATUS_LCS_DM_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LCS_DM_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LCS_DM_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LCS_DM_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LCS_CM_MASK 0x7000
#define  BCMREG_WTM_FUSE_STATUS_LCS_CM_SHIFT 12
#define  BCMREG_WTM_FUSE_STATUS_LCS_CM_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LCS_CM_MASK) >> BCMREG_WTM_FUSE_STATUS_LCS_CM_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LCS_CM_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LCS_CM_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LCS_CM_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_BANK9LOCK_MASK 0x800
#define  BCMREG_WTM_FUSE_STATUS_BANK9LOCK_SHIFT 11
#define  BCMREG_WTM_FUSE_STATUS_BANK9LOCK_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_BANK9LOCK_MASK) >> BCMREG_WTM_FUSE_STATUS_BANK9LOCK_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_BANK9LOCK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_BANK9LOCK_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_BANK9LOCK_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_BANK8LOCK_MASK 0x400
#define  BCMREG_WTM_FUSE_STATUS_BANK8LOCK_SHIFT 10
#define  BCMREG_WTM_FUSE_STATUS_BANK8LOCK_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_BANK8LOCK_MASK) >> BCMREG_WTM_FUSE_STATUS_BANK8LOCK_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_BANK8LOCK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_BANK8LOCK_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_BANK8LOCK_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_FUSE_READY_MASK 0x200
#define  BCMREG_WTM_FUSE_STATUS_FUSE_READY_SHIFT 9
#define  BCMREG_WTM_FUSE_STATUS_FUSE_READY_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_FUSE_READY_MASK) >> BCMREG_WTM_FUSE_STATUS_FUSE_READY_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_FUSE_READY_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_FUSE_READY_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_FUSE_READY_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_MASK 0x100
#define  BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_SHIFT 8
#define  BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_MASK) >> BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_FUSE_BURN_DONE_SHIFT))

#define  BCMREG_WTM_FUSE_STATUS_LOCK_BIT_MASK 0xff
#define  BCMREG_WTM_FUSE_STATUS_LOCK_BIT_SHIFT 0
#define  BCMREG_WTM_FUSE_STATUS_LOCK_BIT_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_STATUS_LOCK_BIT_MASK) >> BCMREG_WTM_FUSE_STATUS_LOCK_BIT_SHIFT)
#define  BCMREG_WTM_FUSE_STATUS_LOCK_BIT_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_STATUS_LOCK_BIT_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_STATUS_LOCK_BIT_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD3)
//====================================================================

#define  BCMREG_RSVD3_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD3_RESERVED1_SHIFT 0
#define  BCMREG_RSVD3_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD3_RESERVED1_MASK) >> BCMREG_RSVD3_RESERVED1_SHIFT)
#define  BCMREG_RSVD3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD3_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD3_RESERVED1_SHIFT))

//====================================================================
//Register: Fuse Value for OEM JTAG Key Hash ECC Correction Register (WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC)
//====================================================================

#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_MASK 0xffffffff
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_SHIFT 0
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_MASK) >> BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_SHIFT)
#define  BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_MASK) | (((uint32_t)val) << BCMREG_WTM_FUSE_VAL_OEM_JTAG_KEY_HASH_ECC_OEM_JTAG_KEY_HASH_ECC_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 0 (BLOCK7_RESERVED_0)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_MASK) >> BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_0_BLOCK7_RESERVED_95_64_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 1 (BLOCK7_RESERVED_1)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_MASK) >> BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_1_BLOCK7_RESERVED_127_96_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 2 (BLOCK7_RESERVED_2)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_MASK) >> BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_2_BLOCK7_RESERVED_159_128_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 3 (BLOCK7_RESERVED_3)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_MASK) >> BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_3_BLOCK7_RESERVED_191_160_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 4 (BLOCK7_RESERVED_4)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_MASK) >> BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_4_BLOCK7_RESERVED_223_192_SHIFT))

//====================================================================
//Register: Block 7 Reserved Fuse Bit Register 5 (BLOCK7_RESERVED_5)
//====================================================================

#define  BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_MASK 0xffffffff
#define  BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_SHIFT 0
#define  BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_MASK_SHIFT(reg) (((reg) & BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_MASK) >> BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_SHIFT)
#define  BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_MASK) | (((uint32_t)val) << BCMREG_BLOCK7_RESERVED_5_BLOCK7_RESERVED_255_224_SHIFT))

//====================================================================
//Register: OEM Key Hash ECC Correction Register (OEM_KEY_HASH_ECC)
//====================================================================

#define  BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_MASK 0xffffffff
#define  BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_SHIFT 0
#define  BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_MASK_SHIFT(reg) (((reg) & BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_MASK) >> BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_SHIFT)
#define  BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_MASK) | (((uint32_t)val) << BCMREG_OEM_KEY_HASH_ECC_OKH_ECC_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD4)
//====================================================================

#define  BCMREG_RSVD4_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD4_RESERVED1_SHIFT 0
#define  BCMREG_RSVD4_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD4_RESERVED1_MASK) >> BCMREG_RSVD4_RESERVED1_SHIFT)
#define  BCMREG_RSVD4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD4_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD4_RESERVED1_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD5)
//====================================================================

#define  BCMREG_RSVD5_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD5_RESERVED1_SHIFT 0
#define  BCMREG_RSVD5_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD5_RESERVED1_MASK) >> BCMREG_RSVD5_RESERVED1_SHIFT)
#define  BCMREG_RSVD5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD5_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD5_RESERVED1_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD6)
//====================================================================

#define  BCMREG_RSVD6_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD6_RESERVED1_SHIFT 0
#define  BCMREG_RSVD6_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD6_RESERVED1_MASK) >> BCMREG_RSVD6_RESERVED1_SHIFT)
#define  BCMREG_RSVD6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD6_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD6_RESERVED1_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD7)
//====================================================================

#define  BCMREG_RSVD7_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD7_RESERVED1_SHIFT 0
#define  BCMREG_RSVD7_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD7_RESERVED1_MASK) >> BCMREG_RSVD7_RESERVED1_SHIFT)
#define  BCMREG_RSVD7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD7_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD7_RESERVED1_SHIFT))

//====================================================================
//Register: Reserved Register (RSVD8)
//====================================================================

#define  BCMREG_RSVD8_RESERVED1_MASK 0xffffffff
#define  BCMREG_RSVD8_RESERVED1_SHIFT 0
#define  BCMREG_RSVD8_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_RSVD8_RESERVED1_MASK) >> BCMREG_RSVD8_RESERVED1_SHIFT)
#define  BCMREG_RSVD8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_RSVD8_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_RSVD8_RESERVED1_SHIFT))

//====================================================================
//Register: ECC Calculator Register (WTM_ECC_CAL)
//====================================================================

#define  BCMREG_WTM_ECC_CAL_ECC_CAL_MASK 0xffffffff
#define  BCMREG_WTM_ECC_CAL_ECC_CAL_SHIFT 0
#define  BCMREG_WTM_ECC_CAL_ECC_CAL_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_CAL_ECC_CAL_MASK) >> BCMREG_WTM_ECC_CAL_ECC_CAL_SHIFT)
#define  BCMREG_WTM_ECC_CAL_ECC_CAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_CAL_ECC_CAL_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_CAL_ECC_CAL_SHIFT))

//====================================================================
//Register: ECC Status Register (WTM_ECC_STATUS)
//====================================================================

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_MASK 0xc0000000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_SHIFT 30
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_9_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_MASK 0x30000000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_SHIFT 28
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_8_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_MASK 0xc000000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_SHIFT 26
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_7_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_MASK 0x3000000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_SHIFT 24
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_6_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_MASK 0xc00000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_SHIFT 22
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_USB_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_MASK 0x300000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_SHIFT 20
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_5_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_MASK 0xc0000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_SHIFT 18
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_UID_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_MASK 0x30000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_SHIFT 16
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_4_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_MASK 0x8000
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_SHIFT 15
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_MASK) >> BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_SOFT_ERR_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_3_MASK 0x4000
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_3_SHIFT 14
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ECC_ERR_3_MASK) >> BCMREG_WTM_ECC_STATUS_ECC_ERR_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ECC_ERR_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ECC_ERR_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_MASK 0x3000
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_SHIFT 12
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_MASK 0x800
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_SHIFT 11
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_MASK) >> BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_SOFT_ERR_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_2_MASK 0x400
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_2_SHIFT 10
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ECC_ERR_2_MASK) >> BCMREG_WTM_ECC_STATUS_ECC_ERR_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ECC_ERR_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ECC_ERR_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_MASK 0x300
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_SHIFT 8
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_MASK 0x80
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_SHIFT 7
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_MASK) >> BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_SOFT_ERR_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_1_MASK 0x40
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_1_SHIFT 6
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ECC_ERR_1_MASK) >> BCMREG_WTM_ECC_STATUS_ECC_ERR_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ECC_ERR_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ECC_ERR_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_MASK 0x30
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_SHIFT 4
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_MASK 0x8
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_SHIFT 3
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_MASK) >> BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_SOFT_ERR_0_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_0_MASK 0x4
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_0_SHIFT 2
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ECC_ERR_0_MASK) >> BCMREG_WTM_ECC_STATUS_ECC_ERR_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ECC_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ECC_ERR_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ECC_ERR_0_SHIFT))

#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_MASK 0x3
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_SHIFT 0
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_MASK) >> BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS_ERR_TYPE_0_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 1 of 8) (JTAG2SP_MBOX0)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX0_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX0_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX0_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX0_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX0_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX0_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX0_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX0_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 2 of 8) (JTAG2SP_MBOX1)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX1_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX1_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX1_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX1_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX1_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX1_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX1_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX1_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 3 of 8) (JTAG2SP_MBOX2)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX2_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX2_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX2_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX2_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX2_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX2_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX2_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX2_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 4 of 8) (JTAG2SP_MBOX3)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX3_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX3_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX3_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX3_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX3_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX3_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX3_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX3_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 5 of 8) (JTAG2SP_MBOX4)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX4_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX4_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX4_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX4_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX4_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX4_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX4_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX4_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 6 of 8) (JTAG2SP_MBOX5)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX5_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX5_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX5_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX5_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX5_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX5_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX5_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX5_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 7 of 8) (JTAG2SP_MBOX6)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX6_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX6_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX6_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX6_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX6_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX6_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX6_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX6_DKEY1_SHIFT))

//====================================================================
//Register: JTAG to SP Mailbox (Instance 8 of 8) (JTAG2SP_MBOX7)
/** \brief This read only register is read by the Secure Processor. This register is written by
the non-secure JTAG interface. Writing this register by the JTAG also generates
an interrupt to the Dragonite. (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_JTAG2SP_MBOX7_DKEY1_MASK 0xffffffff
#define  BCMREG_JTAG2SP_MBOX7_DKEY1_SHIFT 0
#define  BCMREG_JTAG2SP_MBOX7_DKEY1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAG2SP_MBOX7_DKEY1_MASK) >> BCMREG_JTAG2SP_MBOX7_DKEY1_SHIFT)
#define  BCMREG_JTAG2SP_MBOX7_DKEY1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAG2SP_MBOX7_DKEY1_MASK) | (((uint32_t)val) << BCMREG_JTAG2SP_MBOX7_DKEY1_SHIFT))

//====================================================================
//Register: UID  Register (Instance 1 of 2) (UID0)
/** \brief SoC UID After ECC Correction. (Instance 1 of 2)*/
//====================================================================

#define  BCMREG_UID0_VAL_MASK 0xffffffff
#define  BCMREG_UID0_VAL_SHIFT 0
#define  BCMREG_UID0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_UID0_VAL_MASK) >> BCMREG_UID0_VAL_SHIFT)
#define  BCMREG_UID0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_UID0_VAL_MASK) | (((uint32_t)val) << BCMREG_UID0_VAL_SHIFT))

//====================================================================
//Register: UID  Register (Instance 2 of 2) (UID1)
/** \brief SoC UID After ECC Correction. (Instance 2 of 2)*/
//====================================================================

#define  BCMREG_UID1_VAL_MASK 0xffffffff
#define  BCMREG_UID1_VAL_SHIFT 0
#define  BCMREG_UID1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_UID1_VAL_MASK) >> BCMREG_UID1_VAL_SHIFT)
#define  BCMREG_UID1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_UID1_VAL_MASK) | (((uint32_t)val) << BCMREG_UID1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 4) (Bank9_U0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_BANK9_U0_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_U0_VAL_SHIFT 0
#define  BCMREG_BANK9_U0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_U0_VAL_MASK) >> BCMREG_BANK9_U0_VAL_SHIFT)
#define  BCMREG_BANK9_U0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_U0_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_U0_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 4) (Bank9_U1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_BANK9_U1_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_U1_VAL_SHIFT 0
#define  BCMREG_BANK9_U1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_U1_VAL_MASK) >> BCMREG_BANK9_U1_VAL_SHIFT)
#define  BCMREG_BANK9_U1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_U1_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_U1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 4) (Bank9_U2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_BANK9_U2_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_U2_VAL_SHIFT 0
#define  BCMREG_BANK9_U2_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_U2_VAL_MASK) >> BCMREG_BANK9_U2_VAL_SHIFT)
#define  BCMREG_BANK9_U2_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_U2_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_U2_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 4) (Bank9_U3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_BANK9_U3_VAL_MASK 0xffffffff
#define  BCMREG_BANK9_U3_VAL_SHIFT 0
#define  BCMREG_BANK9_U3_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK9_U3_VAL_MASK) >> BCMREG_BANK9_U3_VAL_SHIFT)
#define  BCMREG_BANK9_U3_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK9_U3_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK9_U3_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank100)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK100_VAL_MASK 0xffffffff
#define  BCMREG_BANK100_VAL_SHIFT 0
#define  BCMREG_BANK100_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK100_VAL_MASK) >> BCMREG_BANK100_VAL_SHIFT)
#define  BCMREG_BANK100_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK100_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK100_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank101)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK101_VAL_MASK 0xffffffff
#define  BCMREG_BANK101_VAL_SHIFT 0
#define  BCMREG_BANK101_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK101_VAL_MASK) >> BCMREG_BANK101_VAL_SHIFT)
#define  BCMREG_BANK101_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK101_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK101_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank102)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK102_VAL_MASK 0xffffffff
#define  BCMREG_BANK102_VAL_SHIFT 0
#define  BCMREG_BANK102_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK102_VAL_MASK) >> BCMREG_BANK102_VAL_SHIFT)
#define  BCMREG_BANK102_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK102_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK102_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank103)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK103_VAL_MASK 0xffffffff
#define  BCMREG_BANK103_VAL_SHIFT 0
#define  BCMREG_BANK103_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK103_VAL_MASK) >> BCMREG_BANK103_VAL_SHIFT)
#define  BCMREG_BANK103_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK103_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK103_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank104)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK104_VAL_MASK 0xffffffff
#define  BCMREG_BANK104_VAL_SHIFT 0
#define  BCMREG_BANK104_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK104_VAL_MASK) >> BCMREG_BANK104_VAL_SHIFT)
#define  BCMREG_BANK104_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK104_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK104_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank105)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK105_VAL_MASK 0xffffffff
#define  BCMREG_BANK105_VAL_SHIFT 0
#define  BCMREG_BANK105_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK105_VAL_MASK) >> BCMREG_BANK105_VAL_SHIFT)
#define  BCMREG_BANK105_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK105_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK105_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank106)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK106_VAL_MASK 0xffffffff
#define  BCMREG_BANK106_VAL_SHIFT 0
#define  BCMREG_BANK106_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK106_VAL_MASK) >> BCMREG_BANK106_VAL_SHIFT)
#define  BCMREG_BANK106_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK106_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK106_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank107)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK107_VAL_MASK 0xffffffff
#define  BCMREG_BANK107_VAL_SHIFT 0
#define  BCMREG_BANK107_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK107_VAL_MASK) >> BCMREG_BANK107_VAL_SHIFT)
#define  BCMREG_BANK107_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK107_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK107_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank110)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK110_VAL_MASK 0xffffffff
#define  BCMREG_BANK110_VAL_SHIFT 0
#define  BCMREG_BANK110_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK110_VAL_MASK) >> BCMREG_BANK110_VAL_SHIFT)
#define  BCMREG_BANK110_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK110_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK110_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank111)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK111_VAL_MASK 0xffffffff
#define  BCMREG_BANK111_VAL_SHIFT 0
#define  BCMREG_BANK111_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK111_VAL_MASK) >> BCMREG_BANK111_VAL_SHIFT)
#define  BCMREG_BANK111_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK111_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK111_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank112)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK112_VAL_MASK 0xffffffff
#define  BCMREG_BANK112_VAL_SHIFT 0
#define  BCMREG_BANK112_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK112_VAL_MASK) >> BCMREG_BANK112_VAL_SHIFT)
#define  BCMREG_BANK112_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK112_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK112_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank113)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK113_VAL_MASK 0xffffffff
#define  BCMREG_BANK113_VAL_SHIFT 0
#define  BCMREG_BANK113_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK113_VAL_MASK) >> BCMREG_BANK113_VAL_SHIFT)
#define  BCMREG_BANK113_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK113_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK113_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank114)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK114_VAL_MASK 0xffffffff
#define  BCMREG_BANK114_VAL_SHIFT 0
#define  BCMREG_BANK114_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK114_VAL_MASK) >> BCMREG_BANK114_VAL_SHIFT)
#define  BCMREG_BANK114_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK114_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK114_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank115)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK115_VAL_MASK 0xffffffff
#define  BCMREG_BANK115_VAL_SHIFT 0
#define  BCMREG_BANK115_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK115_VAL_MASK) >> BCMREG_BANK115_VAL_SHIFT)
#define  BCMREG_BANK115_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK115_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK115_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank116)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK116_VAL_MASK 0xffffffff
#define  BCMREG_BANK116_VAL_SHIFT 0
#define  BCMREG_BANK116_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK116_VAL_MASK) >> BCMREG_BANK116_VAL_SHIFT)
#define  BCMREG_BANK116_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK116_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK116_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank117)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK117_VAL_MASK 0xffffffff
#define  BCMREG_BANK117_VAL_SHIFT 0
#define  BCMREG_BANK117_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK117_VAL_MASK) >> BCMREG_BANK117_VAL_SHIFT)
#define  BCMREG_BANK117_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK117_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK117_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank120)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK120_VAL_MASK 0xffffffff
#define  BCMREG_BANK120_VAL_SHIFT 0
#define  BCMREG_BANK120_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK120_VAL_MASK) >> BCMREG_BANK120_VAL_SHIFT)
#define  BCMREG_BANK120_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK120_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK120_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank121)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK121_VAL_MASK 0xffffffff
#define  BCMREG_BANK121_VAL_SHIFT 0
#define  BCMREG_BANK121_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK121_VAL_MASK) >> BCMREG_BANK121_VAL_SHIFT)
#define  BCMREG_BANK121_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK121_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK121_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank122)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK122_VAL_MASK 0xffffffff
#define  BCMREG_BANK122_VAL_SHIFT 0
#define  BCMREG_BANK122_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK122_VAL_MASK) >> BCMREG_BANK122_VAL_SHIFT)
#define  BCMREG_BANK122_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK122_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK122_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank123)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK123_VAL_MASK 0xffffffff
#define  BCMREG_BANK123_VAL_SHIFT 0
#define  BCMREG_BANK123_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK123_VAL_MASK) >> BCMREG_BANK123_VAL_SHIFT)
#define  BCMREG_BANK123_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK123_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK123_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank124)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK124_VAL_MASK 0xffffffff
#define  BCMREG_BANK124_VAL_SHIFT 0
#define  BCMREG_BANK124_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK124_VAL_MASK) >> BCMREG_BANK124_VAL_SHIFT)
#define  BCMREG_BANK124_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK124_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK124_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank125)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK125_VAL_MASK 0xffffffff
#define  BCMREG_BANK125_VAL_SHIFT 0
#define  BCMREG_BANK125_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK125_VAL_MASK) >> BCMREG_BANK125_VAL_SHIFT)
#define  BCMREG_BANK125_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK125_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK125_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank126)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK126_VAL_MASK 0xffffffff
#define  BCMREG_BANK126_VAL_SHIFT 0
#define  BCMREG_BANK126_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK126_VAL_MASK) >> BCMREG_BANK126_VAL_SHIFT)
#define  BCMREG_BANK126_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK126_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK126_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank127)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK127_VAL_MASK 0xffffffff
#define  BCMREG_BANK127_VAL_SHIFT 0
#define  BCMREG_BANK127_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK127_VAL_MASK) >> BCMREG_BANK127_VAL_SHIFT)
#define  BCMREG_BANK127_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK127_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK127_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank130)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK130_VAL_MASK 0xffffffff
#define  BCMREG_BANK130_VAL_SHIFT 0
#define  BCMREG_BANK130_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK130_VAL_MASK) >> BCMREG_BANK130_VAL_SHIFT)
#define  BCMREG_BANK130_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK130_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK130_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank131)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK131_VAL_MASK 0xffffffff
#define  BCMREG_BANK131_VAL_SHIFT 0
#define  BCMREG_BANK131_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK131_VAL_MASK) >> BCMREG_BANK131_VAL_SHIFT)
#define  BCMREG_BANK131_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK131_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK131_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank132)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK132_VAL_MASK 0xffffffff
#define  BCMREG_BANK132_VAL_SHIFT 0
#define  BCMREG_BANK132_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK132_VAL_MASK) >> BCMREG_BANK132_VAL_SHIFT)
#define  BCMREG_BANK132_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK132_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK132_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank133)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK133_VAL_MASK 0xffffffff
#define  BCMREG_BANK133_VAL_SHIFT 0
#define  BCMREG_BANK133_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK133_VAL_MASK) >> BCMREG_BANK133_VAL_SHIFT)
#define  BCMREG_BANK133_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK133_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK133_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank134)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK134_VAL_MASK 0xffffffff
#define  BCMREG_BANK134_VAL_SHIFT 0
#define  BCMREG_BANK134_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK134_VAL_MASK) >> BCMREG_BANK134_VAL_SHIFT)
#define  BCMREG_BANK134_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK134_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK134_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank135)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK135_VAL_MASK 0xffffffff
#define  BCMREG_BANK135_VAL_SHIFT 0
#define  BCMREG_BANK135_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK135_VAL_MASK) >> BCMREG_BANK135_VAL_SHIFT)
#define  BCMREG_BANK135_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK135_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK135_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank136)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK136_VAL_MASK 0xffffffff
#define  BCMREG_BANK136_VAL_SHIFT 0
#define  BCMREG_BANK136_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK136_VAL_MASK) >> BCMREG_BANK136_VAL_SHIFT)
#define  BCMREG_BANK136_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK136_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK136_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank137)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK137_VAL_MASK 0xffffffff
#define  BCMREG_BANK137_VAL_SHIFT 0
#define  BCMREG_BANK137_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK137_VAL_MASK) >> BCMREG_BANK137_VAL_SHIFT)
#define  BCMREG_BANK137_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK137_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK137_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank140)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK140_VAL_MASK 0xffffffff
#define  BCMREG_BANK140_VAL_SHIFT 0
#define  BCMREG_BANK140_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK140_VAL_MASK) >> BCMREG_BANK140_VAL_SHIFT)
#define  BCMREG_BANK140_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK140_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK140_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank141)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK141_VAL_MASK 0xffffffff
#define  BCMREG_BANK141_VAL_SHIFT 0
#define  BCMREG_BANK141_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK141_VAL_MASK) >> BCMREG_BANK141_VAL_SHIFT)
#define  BCMREG_BANK141_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK141_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK141_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank142)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK142_VAL_MASK 0xffffffff
#define  BCMREG_BANK142_VAL_SHIFT 0
#define  BCMREG_BANK142_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK142_VAL_MASK) >> BCMREG_BANK142_VAL_SHIFT)
#define  BCMREG_BANK142_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK142_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK142_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank143)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK143_VAL_MASK 0xffffffff
#define  BCMREG_BANK143_VAL_SHIFT 0
#define  BCMREG_BANK143_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK143_VAL_MASK) >> BCMREG_BANK143_VAL_SHIFT)
#define  BCMREG_BANK143_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK143_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK143_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank144)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK144_VAL_MASK 0xffffffff
#define  BCMREG_BANK144_VAL_SHIFT 0
#define  BCMREG_BANK144_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK144_VAL_MASK) >> BCMREG_BANK144_VAL_SHIFT)
#define  BCMREG_BANK144_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK144_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK144_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank145)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK145_VAL_MASK 0xffffffff
#define  BCMREG_BANK145_VAL_SHIFT 0
#define  BCMREG_BANK145_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK145_VAL_MASK) >> BCMREG_BANK145_VAL_SHIFT)
#define  BCMREG_BANK145_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK145_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK145_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank146)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK146_VAL_MASK 0xffffffff
#define  BCMREG_BANK146_VAL_SHIFT 0
#define  BCMREG_BANK146_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK146_VAL_MASK) >> BCMREG_BANK146_VAL_SHIFT)
#define  BCMREG_BANK146_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK146_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK146_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank147)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK147_VAL_MASK 0xffffffff
#define  BCMREG_BANK147_VAL_SHIFT 0
#define  BCMREG_BANK147_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK147_VAL_MASK) >> BCMREG_BANK147_VAL_SHIFT)
#define  BCMREG_BANK147_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK147_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK147_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank150)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK150_VAL_MASK 0xffffffff
#define  BCMREG_BANK150_VAL_SHIFT 0
#define  BCMREG_BANK150_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK150_VAL_MASK) >> BCMREG_BANK150_VAL_SHIFT)
#define  BCMREG_BANK150_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK150_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK150_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank151)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK151_VAL_MASK 0xffffffff
#define  BCMREG_BANK151_VAL_SHIFT 0
#define  BCMREG_BANK151_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK151_VAL_MASK) >> BCMREG_BANK151_VAL_SHIFT)
#define  BCMREG_BANK151_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK151_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK151_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank152)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK152_VAL_MASK 0xffffffff
#define  BCMREG_BANK152_VAL_SHIFT 0
#define  BCMREG_BANK152_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK152_VAL_MASK) >> BCMREG_BANK152_VAL_SHIFT)
#define  BCMREG_BANK152_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK152_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK152_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank153)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK153_VAL_MASK 0xffffffff
#define  BCMREG_BANK153_VAL_SHIFT 0
#define  BCMREG_BANK153_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK153_VAL_MASK) >> BCMREG_BANK153_VAL_SHIFT)
#define  BCMREG_BANK153_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK153_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK153_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank154)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK154_VAL_MASK 0xffffffff
#define  BCMREG_BANK154_VAL_SHIFT 0
#define  BCMREG_BANK154_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK154_VAL_MASK) >> BCMREG_BANK154_VAL_SHIFT)
#define  BCMREG_BANK154_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK154_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK154_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank155)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK155_VAL_MASK 0xffffffff
#define  BCMREG_BANK155_VAL_SHIFT 0
#define  BCMREG_BANK155_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK155_VAL_MASK) >> BCMREG_BANK155_VAL_SHIFT)
#define  BCMREG_BANK155_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK155_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK155_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank156)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK156_VAL_MASK 0xffffffff
#define  BCMREG_BANK156_VAL_SHIFT 0
#define  BCMREG_BANK156_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK156_VAL_MASK) >> BCMREG_BANK156_VAL_SHIFT)
#define  BCMREG_BANK156_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK156_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK156_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank157)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK157_VAL_MASK 0xffffffff
#define  BCMREG_BANK157_VAL_SHIFT 0
#define  BCMREG_BANK157_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK157_VAL_MASK) >> BCMREG_BANK157_VAL_SHIFT)
#define  BCMREG_BANK157_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK157_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK157_VAL_SHIFT))

//====================================================================
//Register: ECC Status Register (WTM_ECC_STATUS1)
//====================================================================

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_MASK 0xc0000000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_SHIFT 30
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_9_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_MASK 0x30000000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_SHIFT 28
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_8_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_MASK 0xc000000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_SHIFT 26
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_7_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_MASK 0x3000000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_SHIFT 24
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_6_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_MASK 0xc00000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_SHIFT 22
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_USB_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_MASK 0x300000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_SHIFT 20
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_5_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_MASK 0xc0000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_SHIFT 18
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_UID_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_MASK 0x30000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_SHIFT 16
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_4_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_MASK 0x8000
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_SHIFT 15
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_MASK) >> BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_SOFT_ERR_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_MASK 0x4000
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_SHIFT 14
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_MASK) >> BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ECC_ERR_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_MASK 0x3000
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_SHIFT 12
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_3_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_MASK 0x800
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_SHIFT 11
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_MASK) >> BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_SOFT_ERR_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_MASK 0x400
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_SHIFT 10
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_MASK) >> BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ECC_ERR_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_MASK 0x300
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_SHIFT 8
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_2_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_MASK 0x80
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_SHIFT 7
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_MASK) >> BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_SOFT_ERR_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_MASK 0x40
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_SHIFT 6
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_MASK) >> BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ECC_ERR_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_MASK 0x30
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_SHIFT 4
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_1_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_MASK 0x8
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_SHIFT 3
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_MASK) >> BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_SOFT_ERR_0_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_MASK 0x4
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_SHIFT 2
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_MASK) >> BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ECC_ERR_0_SHIFT))

#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_MASK 0x3
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_SHIFT 0
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_MASK_SHIFT(reg) (((reg) & BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_MASK) >> BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_SHIFT)
#define  BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_MASK) | (((uint32_t)val) << BCMREG_WTM_ECC_STATUS1_ERR_TYPE_0_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 1 of 16) (FuseTestStatus0)
/** \brief  (Instance 1 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS0_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS0_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS0_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS0_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS0_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS0_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS0_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS0_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS0_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS0_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS0_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS0_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS0_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS0_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS0_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 2 of 16) (FuseTestStatus1)
/** \brief  (Instance 2 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS1_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS1_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS1_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS1_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS1_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS1_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS1_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS1_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS1_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS1_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS1_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS1_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS1_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS1_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS1_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 3 of 16) (FuseTestStatus2)
/** \brief  (Instance 3 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS2_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS2_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS2_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS2_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS2_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS2_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS2_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS2_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS2_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS2_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS2_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS2_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS2_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS2_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS2_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 4 of 16) (FuseTestStatus3)
/** \brief  (Instance 4 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS3_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS3_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS3_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS3_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS3_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS3_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS3_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS3_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS3_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS3_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS3_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS3_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS3_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS3_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS3_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 5 of 16) (FuseTestStatus4)
/** \brief  (Instance 5 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS4_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS4_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS4_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS4_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS4_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS4_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS4_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS4_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS4_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS4_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS4_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS4_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS4_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS4_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS4_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 6 of 16) (FuseTestStatus5)
/** \brief  (Instance 6 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS5_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS5_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS5_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS5_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS5_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS5_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS5_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS5_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS5_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS5_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS5_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS5_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS5_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS5_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS5_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 7 of 16) (FuseTestStatus6)
/** \brief  (Instance 7 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS6_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS6_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS6_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS6_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS6_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS6_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS6_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS6_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS6_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS6_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS6_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS6_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS6_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS6_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS6_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 8 of 16) (FuseTestStatus7)
/** \brief  (Instance 8 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS7_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS7_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS7_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS7_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS7_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS7_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS7_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS7_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS7_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS7_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS7_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS7_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS7_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS7_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS7_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 9 of 16) (FuseTestStatus8)
/** \brief  (Instance 9 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS8_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS8_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS8_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS8_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS8_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS8_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS8_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS8_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS8_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS8_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS8_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS8_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS8_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS8_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS8_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 10 of 16) (FuseTestStatus9)
/** \brief  (Instance 10 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS9_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS9_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS9_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS9_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS9_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS9_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS9_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS9_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS9_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS9_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS9_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS9_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS9_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS9_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS9_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 11 of 16) (FuseTestStatus10)
/** \brief  (Instance 11 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS10_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS10_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS10_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS10_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS10_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS10_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS10_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS10_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS10_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS10_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS10_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS10_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS10_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS10_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS10_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 12 of 16) (FuseTestStatus11)
/** \brief  (Instance 12 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS11_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS11_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS11_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS11_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS11_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS11_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS11_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS11_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS11_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS11_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS11_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS11_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS11_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS11_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS11_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 13 of 16) (FuseTestStatus12)
/** \brief  (Instance 13 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS12_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS12_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS12_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS12_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS12_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS12_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS12_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS12_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS12_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS12_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS12_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS12_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS12_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS12_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS12_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 14 of 16) (FuseTestStatus13)
/** \brief  (Instance 14 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS13_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS13_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS13_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS13_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS13_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS13_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS13_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS13_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS13_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS13_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS13_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS13_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS13_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS13_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS13_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 15 of 16) (FuseTestStatus14)
/** \brief  (Instance 15 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS14_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS14_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS14_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS14_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS14_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS14_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS14_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS14_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS14_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS14_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS14_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS14_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS14_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS14_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS14_TESTBITS_SHIFT))

//====================================================================
//Register: Miscallaneous Security Register (Instance 16 of 16) (FuseTestStatus15)
/** \brief  (Instance 16 of 16)*/
//====================================================================

#define  BCMREG_FUSETESTSTATUS15_RESERVED1_MASK 0xffffff00
#define  BCMREG_FUSETESTSTATUS15_RESERVED1_SHIFT 8
#define  BCMREG_FUSETESTSTATUS15_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS15_RESERVED1_MASK) >> BCMREG_FUSETESTSTATUS15_RESERVED1_SHIFT)
#define  BCMREG_FUSETESTSTATUS15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS15_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS15_RESERVED1_SHIFT))

#define  BCMREG_FUSETESTSTATUS15_TESTBITS_MASK 0xff
#define  BCMREG_FUSETESTSTATUS15_TESTBITS_SHIFT 0
#define  BCMREG_FUSETESTSTATUS15_TESTBITS_MASK_SHIFT(reg) (((reg) & BCMREG_FUSETESTSTATUS15_TESTBITS_MASK) >> BCMREG_FUSETESTSTATUS15_TESTBITS_SHIFT)
#define  BCMREG_FUSETESTSTATUS15_TESTBITS_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_FUSETESTSTATUS15_TESTBITS_MASK) | (((uint32_t)val) << BCMREG_FUSETESTSTATUS15_TESTBITS_SHIFT))

//====================================================================
//Register:  (SEC_ENA_CTRL_2)
//====================================================================

#define  BCMREG_SEC_ENA_CTRL_2_RESERVED1_MASK 0xfff80000
#define  BCMREG_SEC_ENA_CTRL_2_RESERVED1_SHIFT 19
#define  BCMREG_SEC_ENA_CTRL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_RESERVED1_MASK) >> BCMREG_SEC_ENA_CTRL_2_RESERVED1_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_RESERVED1_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_MASK 0x7c000
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SHIFT 14
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_MPMU_ID_MASK) >> BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_MPMU_ID_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_MASK 0x2000
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_SHIFT 13
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_MPMU_ID_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_MASK 0x1000
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_SHIFT 12
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_MPMU_AVS_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_MASK 0x800
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_SHIFT 11
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_MPMU_RTC_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_MASK 0x400
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_SHIFT 10
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_MPMU_WDT_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_MASK 0x3e0
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SHIFT 5
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_ID_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_ID_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_MASK 0x10
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_SHIFT 4
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_ID_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_MASK 0x8
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_SHIFT 3
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_TIMER_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_MASK 0x4
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_SHIFT 2
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_SRAM_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_MASK 0x2
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_SHIFT 1
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_CLKGEN_CFG_SEC_EN_SHIFT))

#define  BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_MASK 0x1
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_SHIFT 0
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_MASK_SHIFT(reg) (((reg) & BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_MASK) >> BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_SHIFT)
#define  BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_MASK) | (((uint32_t)val) << BCMREG_SEC_ENA_CTRL_2_APPMU_BCM_CFG_SEC_EN_SHIFT))

//====================================================================
//Register: JTAG Interrupt Acknowledge (JTAGAckPulse)
//====================================================================

#define  BCMREG_JTAGACKPULSE_RESERVED1_MASK 0xfffffffe
#define  BCMREG_JTAGACKPULSE_RESERVED1_SHIFT 1
#define  BCMREG_JTAGACKPULSE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_JTAGACKPULSE_RESERVED1_MASK) >> BCMREG_JTAGACKPULSE_RESERVED1_SHIFT)
#define  BCMREG_JTAGACKPULSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAGACKPULSE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_JTAGACKPULSE_RESERVED1_SHIFT))

#define  BCMREG_JTAGACKPULSE_ACK_MASK 0x1
#define  BCMREG_JTAGACKPULSE_ACK_SHIFT 0
#define  BCMREG_JTAGACKPULSE_ACK_MASK_SHIFT(reg) (((reg) & BCMREG_JTAGACKPULSE_ACK_MASK) >> BCMREG_JTAGACKPULSE_ACK_SHIFT)
#define  BCMREG_JTAGACKPULSE_ACK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_JTAGACKPULSE_ACK_MASK) | (((uint32_t)val) << BCMREG_JTAGACKPULSE_ACK_SHIFT))

//====================================================================
//Register: IPS master Secure (IPS_secure)
//====================================================================

#define  BCMREG_IPS_SECURE_RESERVED1_MASK 0xffff8000
#define  BCMREG_IPS_SECURE_RESERVED1_SHIFT 15
#define  BCMREG_IPS_SECURE_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_SECURE_RESERVED1_MASK) >> BCMREG_IPS_SECURE_RESERVED1_SHIFT)
#define  BCMREG_IPS_SECURE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_SECURE_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_IPS_SECURE_RESERVED1_SHIFT))

#define  BCMREG_IPS_SECURE_MST_MASK 0x7fff
#define  BCMREG_IPS_SECURE_MST_SHIFT 0
#define  BCMREG_IPS_SECURE_MST_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_SECURE_MST_MASK) >> BCMREG_IPS_SECURE_MST_SHIFT)
#define  BCMREG_IPS_SECURE_MST_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_SECURE_MST_MASK) | (((uint32_t)val) << BCMREG_IPS_SECURE_MST_SHIFT))

//====================================================================
//Register: IPS Master Violation Clear (IPS_vio_clr)
//====================================================================

#define  BCMREG_IPS_VIO_CLR_RESERVED1_MASK 0xffffc000
#define  BCMREG_IPS_VIO_CLR_RESERVED1_SHIFT 14
#define  BCMREG_IPS_VIO_CLR_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_CLR_RESERVED1_MASK) >> BCMREG_IPS_VIO_CLR_RESERVED1_SHIFT)
#define  BCMREG_IPS_VIO_CLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_CLR_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_CLR_RESERVED1_SHIFT))

#define  BCMREG_IPS_VIO_CLR_CLR_MASK 0x3fff
#define  BCMREG_IPS_VIO_CLR_CLR_SHIFT 0
#define  BCMREG_IPS_VIO_CLR_CLR_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_CLR_CLR_MASK) >> BCMREG_IPS_VIO_CLR_CLR_SHIFT)
#define  BCMREG_IPS_VIO_CLR_CLR_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_CLR_CLR_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_CLR_CLR_SHIFT))

//====================================================================
//Register: IPS Master Violation Interrupt Mask (IPS_vio_mask)
//====================================================================

#define  BCMREG_IPS_VIO_MASK_RESERVED1_MASK 0xffffc000
#define  BCMREG_IPS_VIO_MASK_RESERVED1_SHIFT 14
#define  BCMREG_IPS_VIO_MASK_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_MASK_RESERVED1_MASK) >> BCMREG_IPS_VIO_MASK_RESERVED1_SHIFT)
#define  BCMREG_IPS_VIO_MASK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_MASK_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_MASK_RESERVED1_SHIFT))

#define  BCMREG_IPS_VIO_MASK_MASK_MASK 0x3fff
#define  BCMREG_IPS_VIO_MASK_MASK_SHIFT 0
#define  BCMREG_IPS_VIO_MASK_MASK_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_MASK_MASK_MASK) >> BCMREG_IPS_VIO_MASK_MASK_SHIFT)
#define  BCMREG_IPS_VIO_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_MASK_MASK_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_MASK_MASK_SHIFT))

//====================================================================
//Register: IPS Master Violation Source (IPS_vio_src)
//====================================================================

#define  BCMREG_IPS_VIO_SRC_RESERVED1_MASK 0xffffc000
#define  BCMREG_IPS_VIO_SRC_RESERVED1_SHIFT 14
#define  BCMREG_IPS_VIO_SRC_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_SRC_RESERVED1_MASK) >> BCMREG_IPS_VIO_SRC_RESERVED1_SHIFT)
#define  BCMREG_IPS_VIO_SRC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_SRC_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_SRC_RESERVED1_SHIFT))

#define  BCMREG_IPS_VIO_SRC_MASK_MASK 0x3fff
#define  BCMREG_IPS_VIO_SRC_MASK_SHIFT 0
#define  BCMREG_IPS_VIO_SRC_MASK_MASK_SHIFT(reg) (((reg) & BCMREG_IPS_VIO_SRC_MASK_MASK) >> BCMREG_IPS_VIO_SRC_MASK_SHIFT)
#define  BCMREG_IPS_VIO_SRC_MASK_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_IPS_VIO_SRC_MASK_MASK) | (((uint32_t)val) << BCMREG_IPS_VIO_SRC_MASK_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 4) (Bank5_L0)
/** \brief  (Instance 1 of 4)*/
//====================================================================

#define  BCMREG_BANK5_L0_VAL_MASK 0xffffffff
#define  BCMREG_BANK5_L0_VAL_SHIFT 0
#define  BCMREG_BANK5_L0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_L0_VAL_MASK) >> BCMREG_BANK5_L0_VAL_SHIFT)
#define  BCMREG_BANK5_L0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_L0_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_L0_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 4) (Bank5_L1)
/** \brief  (Instance 2 of 4)*/
//====================================================================

#define  BCMREG_BANK5_L1_VAL_MASK 0xffffffff
#define  BCMREG_BANK5_L1_VAL_SHIFT 0
#define  BCMREG_BANK5_L1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_L1_VAL_MASK) >> BCMREG_BANK5_L1_VAL_SHIFT)
#define  BCMREG_BANK5_L1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_L1_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_L1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 4) (Bank5_L2)
/** \brief  (Instance 3 of 4)*/
//====================================================================

#define  BCMREG_BANK5_L2_VAL_MASK 0xffffffff
#define  BCMREG_BANK5_L2_VAL_SHIFT 0
#define  BCMREG_BANK5_L2_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_L2_VAL_MASK) >> BCMREG_BANK5_L2_VAL_SHIFT)
#define  BCMREG_BANK5_L2_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_L2_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_L2_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 4) (Bank5_L3)
/** \brief  (Instance 4 of 4)*/
//====================================================================

#define  BCMREG_BANK5_L3_VAL_MASK 0xffffffff
#define  BCMREG_BANK5_L3_VAL_SHIFT 0
#define  BCMREG_BANK5_L3_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_L3_VAL_MASK) >> BCMREG_BANK5_L3_VAL_SHIFT)
#define  BCMREG_BANK5_L3_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_L3_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_L3_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Bank5_U0)
//====================================================================

#define  BCMREG_BANK5_U0_VAL_MASK 0xffffffff
#define  BCMREG_BANK5_U0_VAL_SHIFT 0
#define  BCMREG_BANK5_U0_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_U0_VAL_MASK) >> BCMREG_BANK5_U0_VAL_SHIFT)
#define  BCMREG_BANK5_U0_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_U0_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_U0_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Bank5_U1)
//====================================================================

#define  BCMREG_BANK5_U1_RESERVED1_MASK 0xffff0000
#define  BCMREG_BANK5_U1_RESERVED1_SHIFT 16
#define  BCMREG_BANK5_U1_RESERVED1_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_U1_RESERVED1_MASK) >> BCMREG_BANK5_U1_RESERVED1_SHIFT)
#define  BCMREG_BANK5_U1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_U1_RESERVED1_MASK) | (((uint32_t)val) << BCMREG_BANK5_U1_RESERVED1_SHIFT))

#define  BCMREG_BANK5_U1_VAL_MASK 0xffff
#define  BCMREG_BANK5_U1_VAL_SHIFT 0
#define  BCMREG_BANK5_U1_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK5_U1_VAL_MASK) >> BCMREG_BANK5_U1_VAL_SHIFT)
#define  BCMREG_BANK5_U1_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK5_U1_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK5_U1_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 1 of 8) (Bank40)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  BCMREG_BANK40_VAL_MASK 0xffffffff
#define  BCMREG_BANK40_VAL_SHIFT 0
#define  BCMREG_BANK40_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK40_VAL_MASK) >> BCMREG_BANK40_VAL_SHIFT)
#define  BCMREG_BANK40_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK40_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK40_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 2 of 8) (Bank41)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  BCMREG_BANK41_VAL_MASK 0xffffffff
#define  BCMREG_BANK41_VAL_SHIFT 0
#define  BCMREG_BANK41_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK41_VAL_MASK) >> BCMREG_BANK41_VAL_SHIFT)
#define  BCMREG_BANK41_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK41_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK41_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 3 of 8) (Bank42)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  BCMREG_BANK42_VAL_MASK 0xffffffff
#define  BCMREG_BANK42_VAL_SHIFT 0
#define  BCMREG_BANK42_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK42_VAL_MASK) >> BCMREG_BANK42_VAL_SHIFT)
#define  BCMREG_BANK42_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK42_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK42_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 4 of 8) (Bank43)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  BCMREG_BANK43_VAL_MASK 0xffffffff
#define  BCMREG_BANK43_VAL_SHIFT 0
#define  BCMREG_BANK43_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK43_VAL_MASK) >> BCMREG_BANK43_VAL_SHIFT)
#define  BCMREG_BANK43_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK43_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK43_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 5 of 8) (Bank44)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  BCMREG_BANK44_VAL_MASK 0xffffffff
#define  BCMREG_BANK44_VAL_SHIFT 0
#define  BCMREG_BANK44_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK44_VAL_MASK) >> BCMREG_BANK44_VAL_SHIFT)
#define  BCMREG_BANK44_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK44_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK44_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 6 of 8) (Bank45)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  BCMREG_BANK45_VAL_MASK 0xffffffff
#define  BCMREG_BANK45_VAL_SHIFT 0
#define  BCMREG_BANK45_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK45_VAL_MASK) >> BCMREG_BANK45_VAL_SHIFT)
#define  BCMREG_BANK45_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK45_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK45_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 7 of 8) (Bank46)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  BCMREG_BANK46_VAL_MASK 0xffffffff
#define  BCMREG_BANK46_VAL_SHIFT 0
#define  BCMREG_BANK46_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK46_VAL_MASK) >> BCMREG_BANK46_VAL_SHIFT)
#define  BCMREG_BANK46_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK46_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK46_VAL_SHIFT))

//====================================================================
//Register: Soc Fuse Bank Num Read Register (Instance 8 of 8) (Bank47)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  BCMREG_BANK47_VAL_MASK 0xffffffff
#define  BCMREG_BANK47_VAL_SHIFT 0
#define  BCMREG_BANK47_VAL_MASK_SHIFT(reg) (((reg) & BCMREG_BANK47_VAL_MASK) >> BCMREG_BANK47_VAL_SHIFT)
#define  BCMREG_BANK47_VAL_REPLACE_VAL(reg,val) (((reg) & ~BCMREG_BANK47_VAL_MASK) | (((uint32_t)val) << BCMREG_BANK47_VAL_SHIFT))

//====================================================================
//
//Register File: EGB Engine Control Registers (EBG)
//
//====================================================================

//====================================================================
//Register: EBG Control Register (EBG_CTRL_REG)
//====================================================================

#define  EBG_EBG_CTRL_REG_DS_RATIO_MASK 0xff000000
#define  EBG_EBG_CTRL_REG_DS_RATIO_SHIFT 24
#define  EBG_EBG_CTRL_REG_DS_RATIO_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_DS_RATIO_MASK) >> EBG_EBG_CTRL_REG_DS_RATIO_SHIFT)
#define  EBG_EBG_CTRL_REG_DS_RATIO_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_DS_RATIO_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_DS_RATIO_SHIFT))

#define  EBG_EBG_CTRL_REG_RESERVED1_MASK 0xff0000
#define  EBG_EBG_CTRL_REG_RESERVED1_SHIFT 16
#define  EBG_EBG_CTRL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RESERVED1_MASK) >> EBG_EBG_CTRL_REG_RESERVED1_SHIFT)
#define  EBG_EBG_CTRL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RESERVED1_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RESERVED1_SHIFT))

#define  EBG_EBG_CTRL_REG_ENTROPY_MODE_MASK 0x8000
#define  EBG_EBG_CTRL_REG_ENTROPY_MODE_SHIFT 15
#define  EBG_EBG_CTRL_REG_ENTROPY_MODE_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_ENTROPY_MODE_MASK) >> EBG_EBG_CTRL_REG_ENTROPY_MODE_SHIFT)
#define  EBG_EBG_CTRL_REG_ENTROPY_MODE_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_ENTROPY_MODE_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_ENTROPY_MODE_SHIFT))

#define  EBG_EBG_CTRL_REG_ENTROPY_SEL_MASK 0x6000
#define  EBG_EBG_CTRL_REG_ENTROPY_SEL_SHIFT 13
#define  EBG_EBG_CTRL_REG_ENTROPY_SEL_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_ENTROPY_SEL_MASK) >> EBG_EBG_CTRL_REG_ENTROPY_SEL_SHIFT)
#define  EBG_EBG_CTRL_REG_ENTROPY_SEL_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_ENTROPY_SEL_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_ENTROPY_SEL_SHIFT))

#define  EBG_EBG_CTRL_REG_ENTROPY_REQ_MASK 0x1000
#define  EBG_EBG_CTRL_REG_ENTROPY_REQ_SHIFT 12
#define  EBG_EBG_CTRL_REG_ENTROPY_REQ_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_ENTROPY_REQ_MASK) >> EBG_EBG_CTRL_REG_ENTROPY_REQ_SHIFT)
#define  EBG_EBG_CTRL_REG_ENTROPY_REQ_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_ENTROPY_REQ_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_ENTROPY_REQ_SHIFT))

#define  EBG_EBG_CTRL_REG_RNG_CLK_SEL_MASK 0x800
#define  EBG_EBG_CTRL_REG_RNG_CLK_SEL_SHIFT 11
#define  EBG_EBG_CTRL_REG_RNG_CLK_SEL_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RNG_CLK_SEL_MASK) >> EBG_EBG_CTRL_REG_RNG_CLK_SEL_SHIFT)
#define  EBG_EBG_CTRL_REG_RNG_CLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RNG_CLK_SEL_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RNG_CLK_SEL_SHIFT))

#define  EBG_EBG_CTRL_REG_RNG_RSTN_MASK 0x400
#define  EBG_EBG_CTRL_REG_RNG_RSTN_SHIFT 10
#define  EBG_EBG_CTRL_REG_RNG_RSTN_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RNG_RSTN_MASK) >> EBG_EBG_CTRL_REG_RNG_RSTN_SHIFT)
#define  EBG_EBG_CTRL_REG_RNG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RNG_RSTN_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RNG_RSTN_SHIFT))

#define  EBG_EBG_CTRL_REG_RNG_PU_BIAS_MASK 0x200
#define  EBG_EBG_CTRL_REG_RNG_PU_BIAS_SHIFT 9
#define  EBG_EBG_CTRL_REG_RNG_PU_BIAS_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RNG_PU_BIAS_MASK) >> EBG_EBG_CTRL_REG_RNG_PU_BIAS_SHIFT)
#define  EBG_EBG_CTRL_REG_RNG_PU_BIAS_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RNG_PU_BIAS_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RNG_PU_BIAS_SHIFT))

#define  EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_MASK 0x100
#define  EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_SHIFT 8
#define  EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_MASK) >> EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_SHIFT)
#define  EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RNG_FAST_OSC_ENA_SHIFT))

#define  EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_MASK 0x80
#define  EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_SHIFT 7
#define  EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_MASK) >> EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_SHIFT)
#define  EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RNG_SLOW_OSC_ENA_SHIFT))

#define  EBG_EBG_CTRL_REG_PP_ENA_MASK 0x40
#define  EBG_EBG_CTRL_REG_PP_ENA_SHIFT 6
#define  EBG_EBG_CTRL_REG_PP_ENA_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_PP_ENA_MASK) >> EBG_EBG_CTRL_REG_PP_ENA_SHIFT)
#define  EBG_EBG_CTRL_REG_PP_ENA_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_PP_ENA_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_PP_ENA_SHIFT))

#define  EBG_EBG_CTRL_REG_PP_BYPASS_MASK 0x20
#define  EBG_EBG_CTRL_REG_PP_BYPASS_SHIFT 5
#define  EBG_EBG_CTRL_REG_PP_BYPASS_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_PP_BYPASS_MASK) >> EBG_EBG_CTRL_REG_PP_BYPASS_SHIFT)
#define  EBG_EBG_CTRL_REG_PP_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_PP_BYPASS_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_PP_BYPASS_SHIFT))

#define  EBG_EBG_CTRL_REG_RESERVED2_MASK 0x1f
#define  EBG_EBG_CTRL_REG_RESERVED2_SHIFT 0
#define  EBG_EBG_CTRL_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & EBG_EBG_CTRL_REG_RESERVED2_MASK) >> EBG_EBG_CTRL_REG_RESERVED2_SHIFT)
#define  EBG_EBG_CTRL_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_CTRL_REG_RESERVED2_MASK) | (((uint32_t)val) << EBG_EBG_CTRL_REG_RESERVED2_SHIFT))

//====================================================================
//Register: EBG Entropy Value Register (EBG_ENTROPY_VALUE_REG)
/** \brief Entropy Value*/
//====================================================================

#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_MASK 0x80000000
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_SHIFT 31
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_MASK_SHIFT(reg) (((reg) & EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_MASK) >> EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_SHIFT)
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_MASK) | (((uint32_t)val) << EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_RDY_SHIFT))

#define  EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_MASK 0x7fff0000
#define  EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_SHIFT 16
#define  EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_MASK) >> EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_SHIFT)
#define  EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_MASK) | (((uint32_t)val) << EBG_EBG_ENTROPY_VALUE_REG_RESERVED1_SHIFT))

#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_MASK 0xffff
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_SHIFT 0
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_MASK_SHIFT(reg) (((reg) & EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_MASK) >> EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_SHIFT)
#define  EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_REPLACE_VAL(reg,val) (((reg) & ~EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_MASK) | (((uint32_t)val) << EBG_EBG_ENTROPY_VALUE_REG_ENTROPY_VALUE_SHIFT))

//====================================================================
//
//Register File: RCT Control Registers (RCTRL)
/** \brief This module contains registers that control the memory timing controls and the
debug monitor.*/
//
//====================================================================

//====================================================================
//Register: Core Memory Timing Control (MEM_CTRL_CORE)
//====================================================================

#define  RCTRL_MEM_CTRL_CORE_RESERVED1_MASK 0xc0000000
#define  RCTRL_MEM_CTRL_CORE_RESERVED1_SHIFT 30
#define  RCTRL_MEM_CTRL_CORE_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RESERVED1_MASK) >> RCTRL_MEM_CTRL_CORE_RESERVED1_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RESERVED1_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_5_MASK 0x20000000
#define  RCTRL_MEM_CTRL_CORE_PDWN_5_SHIFT 29
#define  RCTRL_MEM_CTRL_CORE_PDWN_5_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_5_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_5_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_5_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_5_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_5_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_5_MASK 0x18000000
#define  RCTRL_MEM_CTRL_CORE_WTC_5_SHIFT 27
#define  RCTRL_MEM_CTRL_CORE_WTC_5_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_5_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_5_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_5_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_5_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_5_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_5_MASK 0x6000000
#define  RCTRL_MEM_CTRL_CORE_RTC_5_SHIFT 25
#define  RCTRL_MEM_CTRL_CORE_RTC_5_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_5_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_5_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_5_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_5_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_5_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_4_MASK 0x1000000
#define  RCTRL_MEM_CTRL_CORE_PDWN_4_SHIFT 24
#define  RCTRL_MEM_CTRL_CORE_PDWN_4_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_4_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_4_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_4_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_4_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_4_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_4_MASK 0xc00000
#define  RCTRL_MEM_CTRL_CORE_WTC_4_SHIFT 22
#define  RCTRL_MEM_CTRL_CORE_WTC_4_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_4_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_4_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_4_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_4_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_4_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_4_MASK 0x300000
#define  RCTRL_MEM_CTRL_CORE_RTC_4_SHIFT 20
#define  RCTRL_MEM_CTRL_CORE_RTC_4_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_4_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_4_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_4_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_4_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_4_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_3_MASK 0x80000
#define  RCTRL_MEM_CTRL_CORE_PDWN_3_SHIFT 19
#define  RCTRL_MEM_CTRL_CORE_PDWN_3_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_3_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_3_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_3_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_3_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_3_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_3_MASK 0x60000
#define  RCTRL_MEM_CTRL_CORE_WTC_3_SHIFT 17
#define  RCTRL_MEM_CTRL_CORE_WTC_3_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_3_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_3_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_3_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_3_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_3_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_3_MASK 0x18000
#define  RCTRL_MEM_CTRL_CORE_RTC_3_SHIFT 15
#define  RCTRL_MEM_CTRL_CORE_RTC_3_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_3_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_3_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_3_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_3_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_3_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_2_MASK 0x4000
#define  RCTRL_MEM_CTRL_CORE_PDWN_2_SHIFT 14
#define  RCTRL_MEM_CTRL_CORE_PDWN_2_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_2_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_2_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_2_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_2_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_2_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_2_MASK 0x3000
#define  RCTRL_MEM_CTRL_CORE_WTC_2_SHIFT 12
#define  RCTRL_MEM_CTRL_CORE_WTC_2_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_2_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_2_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_2_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_2_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_2_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_2_MASK 0xc00
#define  RCTRL_MEM_CTRL_CORE_RTC_2_SHIFT 10
#define  RCTRL_MEM_CTRL_CORE_RTC_2_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_2_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_2_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_2_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_2_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_2_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_1_MASK 0x200
#define  RCTRL_MEM_CTRL_CORE_PDWN_1_SHIFT 9
#define  RCTRL_MEM_CTRL_CORE_PDWN_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_1_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_1_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_1_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_1_MASK 0x180
#define  RCTRL_MEM_CTRL_CORE_WTC_1_SHIFT 7
#define  RCTRL_MEM_CTRL_CORE_WTC_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_1_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_1_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_1_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_1_MASK 0x60
#define  RCTRL_MEM_CTRL_CORE_RTC_1_SHIFT 5
#define  RCTRL_MEM_CTRL_CORE_RTC_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_1_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_1_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_1_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_PDWN_0_MASK 0x10
#define  RCTRL_MEM_CTRL_CORE_PDWN_0_SHIFT 4
#define  RCTRL_MEM_CTRL_CORE_PDWN_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_PDWN_0_MASK) >> RCTRL_MEM_CTRL_CORE_PDWN_0_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_PDWN_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_PDWN_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_PDWN_0_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_WTC_0_MASK 0xc
#define  RCTRL_MEM_CTRL_CORE_WTC_0_SHIFT 2
#define  RCTRL_MEM_CTRL_CORE_WTC_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_WTC_0_MASK) >> RCTRL_MEM_CTRL_CORE_WTC_0_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_WTC_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_WTC_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_WTC_0_SHIFT))

#define  RCTRL_MEM_CTRL_CORE_RTC_0_MASK 0x3
#define  RCTRL_MEM_CTRL_CORE_RTC_0_SHIFT 0
#define  RCTRL_MEM_CTRL_CORE_RTC_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_CORE_RTC_0_MASK) >> RCTRL_MEM_CTRL_CORE_RTC_0_SHIFT)
#define  RCTRL_MEM_CTRL_CORE_RTC_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_CORE_RTC_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_CORE_RTC_0_SHIFT))

//====================================================================
//Register: WTM Monitor Module Select (WTM_MON_MOD_SEL)
/** \brief This will determine which of the modules will have its output sent to
wtm_monitor[15:0].
- 4'h0: DMA
- 4'h1: AES
- 4'h2: DES
- 4'h3: RC4
- 4'h4: ECP
- 4'h5: MCT
- 4'h6: ZMD
- 4'h7: HSH
- 4'h8: EBG*/
//====================================================================

#define  RCTRL_WTM_MON_MOD_SEL_RESERVED1_MASK 0xffffff00
#define  RCTRL_WTM_MON_MOD_SEL_RESERVED1_SHIFT 8
#define  RCTRL_WTM_MON_MOD_SEL_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MON_MOD_SEL_RESERVED1_MASK) >> RCTRL_WTM_MON_MOD_SEL_RESERVED1_SHIFT)
#define  RCTRL_WTM_MON_MOD_SEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MON_MOD_SEL_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_WTM_MON_MOD_SEL_RESERVED1_SHIFT))

#define  RCTRL_WTM_MON_MOD_SEL_MOD_SEL_MASK 0xff
#define  RCTRL_WTM_MON_MOD_SEL_MOD_SEL_SHIFT 0
#define  RCTRL_WTM_MON_MOD_SEL_MOD_SEL_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MON_MOD_SEL_MOD_SEL_MASK) >> RCTRL_WTM_MON_MOD_SEL_MOD_SEL_SHIFT)
#define  RCTRL_WTM_MON_MOD_SEL_MOD_SEL_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MON_MOD_SEL_MOD_SEL_MASK) | (((uint32_t)val) << RCTRL_WTM_MON_MOD_SEL_MOD_SEL_SHIFT))

//====================================================================
//Register: WtM Monitor Signal Select (WTM_MON_SIG_SEL)
/** \brief This will determine which signals within a module are selected for output
to the wtm_monitor. Note that this only selects each modules signals,
WTM_MON_MOD_SEL dictates which module.
>
These values are currently TBD.*/
//====================================================================

#define  RCTRL_WTM_MON_SIG_SEL_RESERVED1_MASK 0xfffffe00
#define  RCTRL_WTM_MON_SIG_SEL_RESERVED1_SHIFT 9
#define  RCTRL_WTM_MON_SIG_SEL_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MON_SIG_SEL_RESERVED1_MASK) >> RCTRL_WTM_MON_SIG_SEL_RESERVED1_SHIFT)
#define  RCTRL_WTM_MON_SIG_SEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MON_SIG_SEL_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_WTM_MON_SIG_SEL_RESERVED1_SHIFT))

#define  RCTRL_WTM_MON_SIG_SEL_MON_DIS_MASK 0x100
#define  RCTRL_WTM_MON_SIG_SEL_MON_DIS_SHIFT 8
#define  RCTRL_WTM_MON_SIG_SEL_MON_DIS_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MON_SIG_SEL_MON_DIS_MASK) >> RCTRL_WTM_MON_SIG_SEL_MON_DIS_SHIFT)
#define  RCTRL_WTM_MON_SIG_SEL_MON_DIS_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MON_SIG_SEL_MON_DIS_MASK) | (((uint32_t)val) << RCTRL_WTM_MON_SIG_SEL_MON_DIS_SHIFT))

#define  RCTRL_WTM_MON_SIG_SEL_SIG_SEL_MASK 0xff
#define  RCTRL_WTM_MON_SIG_SEL_SIG_SEL_SHIFT 0
#define  RCTRL_WTM_MON_SIG_SEL_SIG_SEL_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MON_SIG_SEL_SIG_SEL_MASK) >> RCTRL_WTM_MON_SIG_SEL_SIG_SEL_SHIFT)
#define  RCTRL_WTM_MON_SIG_SEL_SIG_SEL_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MON_SIG_SEL_SIG_SEL_MASK) | (((uint32_t)val) << RCTRL_WTM_MON_SIG_SEL_SIG_SEL_SHIFT))

//====================================================================
//Register: WTM Monitor (WTM_MONITOR)
//====================================================================

#define  RCTRL_WTM_MONITOR_RESERVED1_MASK 0xffff0000
#define  RCTRL_WTM_MONITOR_RESERVED1_SHIFT 16
#define  RCTRL_WTM_MONITOR_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MONITOR_RESERVED1_MASK) >> RCTRL_WTM_MONITOR_RESERVED1_SHIFT)
#define  RCTRL_WTM_MONITOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MONITOR_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_WTM_MONITOR_RESERVED1_SHIFT))

#define  RCTRL_WTM_MONITOR_WTM_MONITOR_MASK 0xffff
#define  RCTRL_WTM_MONITOR_WTM_MONITOR_SHIFT 0
#define  RCTRL_WTM_MONITOR_WTM_MONITOR_MASK_SHIFT(reg) (((reg) & RCTRL_WTM_MONITOR_WTM_MONITOR_MASK) >> RCTRL_WTM_MONITOR_WTM_MONITOR_SHIFT)
#define  RCTRL_WTM_MONITOR_WTM_MONITOR_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_WTM_MONITOR_WTM_MONITOR_MASK) | (((uint32_t)val) << RCTRL_WTM_MONITOR_WTM_MONITOR_SHIFT))

//====================================================================
//Register: Processor Memory Timing Control (MEM_CTRL_PROC)
//====================================================================

#define  RCTRL_MEM_CTRL_PROC_RESERVED1_MASK 0xfff00000
#define  RCTRL_MEM_CTRL_PROC_RESERVED1_SHIFT 20
#define  RCTRL_MEM_CTRL_PROC_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RESERVED1_MASK) >> RCTRL_MEM_CTRL_PROC_RESERVED1_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RESERVED1_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_MASK 0xc0000
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_SHIFT 18
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_REF_55_ROM_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_MASK 0x38000
#define  RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_SHIFT 15
#define  RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_40_ROM_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_MASK 0x4000
#define  RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_SHIFT 14
#define  RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_MASK) >> RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_PDWN_ROM_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_MASK 0x3000
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_SHIFT 12
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_REF_ROM_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_ROM_0_MASK 0xc00
#define  RCTRL_MEM_CTRL_PROC_RTC_ROM_0_SHIFT 10
#define  RCTRL_MEM_CTRL_PROC_RTC_ROM_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_ROM_0_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_ROM_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_ROM_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_ROM_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_ROM_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_PDWN_1_MASK 0x200
#define  RCTRL_MEM_CTRL_PROC_PDWN_1_SHIFT 9
#define  RCTRL_MEM_CTRL_PROC_PDWN_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_PDWN_1_MASK) >> RCTRL_MEM_CTRL_PROC_PDWN_1_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_PDWN_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_PDWN_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_PDWN_1_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_WTC_1_MASK 0x180
#define  RCTRL_MEM_CTRL_PROC_WTC_1_SHIFT 7
#define  RCTRL_MEM_CTRL_PROC_WTC_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_WTC_1_MASK) >> RCTRL_MEM_CTRL_PROC_WTC_1_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_WTC_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_WTC_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_WTC_1_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_1_MASK 0x60
#define  RCTRL_MEM_CTRL_PROC_RTC_1_SHIFT 5
#define  RCTRL_MEM_CTRL_PROC_RTC_1_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_1_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_1_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_1_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_1_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_PDWN_0_MASK 0x10
#define  RCTRL_MEM_CTRL_PROC_PDWN_0_SHIFT 4
#define  RCTRL_MEM_CTRL_PROC_PDWN_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_PDWN_0_MASK) >> RCTRL_MEM_CTRL_PROC_PDWN_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_PDWN_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_PDWN_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_PDWN_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_WTC_0_MASK 0xc
#define  RCTRL_MEM_CTRL_PROC_WTC_0_SHIFT 2
#define  RCTRL_MEM_CTRL_PROC_WTC_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_WTC_0_MASK) >> RCTRL_MEM_CTRL_PROC_WTC_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_WTC_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_WTC_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_WTC_0_SHIFT))

#define  RCTRL_MEM_CTRL_PROC_RTC_0_MASK 0x3
#define  RCTRL_MEM_CTRL_PROC_RTC_0_SHIFT 0
#define  RCTRL_MEM_CTRL_PROC_RTC_0_MASK_SHIFT(reg) (((reg) & RCTRL_MEM_CTRL_PROC_RTC_0_MASK) >> RCTRL_MEM_CTRL_PROC_RTC_0_SHIFT)
#define  RCTRL_MEM_CTRL_PROC_RTC_0_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_MEM_CTRL_PROC_RTC_0_MASK) | (((uint32_t)val) << RCTRL_MEM_CTRL_PROC_RTC_0_SHIFT))

//====================================================================
//Register: Power Control (PWR_CTRL)
//====================================================================

#define  RCTRL_PWR_CTRL_RESERVED1_MASK 0xfffffffe
#define  RCTRL_PWR_CTRL_RESERVED1_SHIFT 1
#define  RCTRL_PWR_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & RCTRL_PWR_CTRL_RESERVED1_MASK) >> RCTRL_PWR_CTRL_RESERVED1_SHIFT)
#define  RCTRL_PWR_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_PWR_CTRL_RESERVED1_MASK) | (((uint32_t)val) << RCTRL_PWR_CTRL_RESERVED1_SHIFT))

#define  RCTRL_PWR_CTRL_PWR_EVENT_MASK 0x1
#define  RCTRL_PWR_CTRL_PWR_EVENT_SHIFT 0
#define  RCTRL_PWR_CTRL_PWR_EVENT_MASK_SHIFT(reg) (((reg) & RCTRL_PWR_CTRL_PWR_EVENT_MASK) >> RCTRL_PWR_CTRL_PWR_EVENT_SHIFT)
#define  RCTRL_PWR_CTRL_PWR_EVENT_REPLACE_VAL(reg,val) (((reg) & ~RCTRL_PWR_CTRL_PWR_EVENT_MASK) | (((uint32_t)val) << RCTRL_PWR_CTRL_PWR_EVENT_SHIFT))

//====================================================================
//
//Register File: APB Control Registers (APB)
/** \brief This module facilitates access to up to 4 separate APB buses. The particular APB
bus is selected via the APB_INTF register. Access to the selected bus is via the
APB_ACCESS register space, which direct accesses 128 32-bit words.*/
//
//====================================================================

//====================================================================
//Register: APB Access (APB_ACCESS)
/** \brief This address space is used to access the external APB buses. 128 32-bit words
can be direct addressed. Note that the APB_BASE register can be used to increase
the addressable space.*/
//====================================================================

#define  APB_APB_ACCESS_APB_ACCESS_MASK 0xffffffff
#define  APB_APB_ACCESS_APB_ACCESS_SHIFT 0
#define  APB_APB_ACCESS_APB_ACCESS_MASK_SHIFT(reg) (((reg) & APB_APB_ACCESS_APB_ACCESS_MASK) >> APB_APB_ACCESS_APB_ACCESS_SHIFT)
#define  APB_APB_ACCESS_APB_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_ACCESS_APB_ACCESS_MASK) | (((uint32_t)val) << APB_APB_ACCESS_APB_ACCESS_SHIFT))

//====================================================================
//Register: APB Base Address (APB_BASE)
//====================================================================

#define  APB_APB_BASE_RESERVED1_MASK 0xc0000000
#define  APB_APB_BASE_RESERVED1_SHIFT 30
#define  APB_APB_BASE_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_APB_BASE_RESERVED1_MASK) >> APB_APB_BASE_RESERVED1_SHIFT)
#define  APB_APB_BASE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_BASE_RESERVED1_MASK) | (((uint32_t)val) << APB_APB_BASE_RESERVED1_SHIFT))

#define  APB_APB_BASE_APB_BASE_MASK 0x3fffffff
#define  APB_APB_BASE_APB_BASE_SHIFT 0
#define  APB_APB_BASE_APB_BASE_MASK_SHIFT(reg) (((reg) & APB_APB_BASE_APB_BASE_MASK) >> APB_APB_BASE_APB_BASE_SHIFT)
#define  APB_APB_BASE_APB_BASE_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_BASE_APB_BASE_MASK) | (((uint32_t)val) << APB_APB_BASE_APB_BASE_SHIFT))

//====================================================================
//Register: APB Interface Select (APB_INTF)
//====================================================================

#define  APB_APB_INTF_RESERVED1_MASK 0xfffffffc
#define  APB_APB_INTF_RESERVED1_SHIFT 2
#define  APB_APB_INTF_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_APB_INTF_RESERVED1_MASK) >> APB_APB_INTF_RESERVED1_SHIFT)
#define  APB_APB_INTF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INTF_RESERVED1_MASK) | (((uint32_t)val) << APB_APB_INTF_RESERVED1_SHIFT))

#define  APB_APB_INTF_APB_INTF_MASK 0x3
#define  APB_APB_INTF_APB_INTF_SHIFT 0
#define  APB_APB_INTF_APB_INTF_MASK_SHIFT(reg) (((reg) & APB_APB_INTF_APB_INTF_MASK) >> APB_APB_INTF_APB_INTF_SHIFT)
#define  APB_APB_INTF_APB_INTF_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INTF_APB_INTF_MASK) | (((uint32_t)val) << APB_APB_INTF_APB_INTF_SHIFT))

//====================================================================
//Register: APB Interrupt Status (APB_INT_STATUS)
//====================================================================

#define  APB_APB_INT_STATUS_RESERVED1_MASK 0xffffff00
#define  APB_APB_INT_STATUS_RESERVED1_SHIFT 8
#define  APB_APB_INT_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_APB_INT_STATUS_RESERVED1_MASK) >> APB_APB_INT_STATUS_RESERVED1_SHIFT)
#define  APB_APB_INT_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INT_STATUS_RESERVED1_MASK) | (((uint32_t)val) << APB_APB_INT_STATUS_RESERVED1_SHIFT))

#define  APB_APB_INT_STATUS_APB_INT_STATUS_MASK 0xff
#define  APB_APB_INT_STATUS_APB_INT_STATUS_SHIFT 0
#define  APB_APB_INT_STATUS_APB_INT_STATUS_MASK_SHIFT(reg) (((reg) & APB_APB_INT_STATUS_APB_INT_STATUS_MASK) >> APB_APB_INT_STATUS_APB_INT_STATUS_SHIFT)
#define  APB_APB_INT_STATUS_APB_INT_STATUS_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INT_STATUS_APB_INT_STATUS_MASK) | (((uint32_t)val) << APB_APB_INT_STATUS_APB_INT_STATUS_SHIFT))

//====================================================================
//Register: APB Interrupt Mask (APB_INT_MASK)
/** \brief These bits apply a mask to the associated interrupt bits in register
APB_INT_STATUS.*/
//====================================================================

#define  APB_APB_INT_MASK_RESERVED1_MASK 0xffffff00
#define  APB_APB_INT_MASK_RESERVED1_SHIFT 8
#define  APB_APB_INT_MASK_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_APB_INT_MASK_RESERVED1_MASK) >> APB_APB_INT_MASK_RESERVED1_SHIFT)
#define  APB_APB_INT_MASK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INT_MASK_RESERVED1_MASK) | (((uint32_t)val) << APB_APB_INT_MASK_RESERVED1_SHIFT))

#define  APB_APB_INT_MASK_APB_INT_MASK_MASK 0xff
#define  APB_APB_INT_MASK_APB_INT_MASK_SHIFT 0
#define  APB_APB_INT_MASK_APB_INT_MASK_MASK_SHIFT(reg) (((reg) & APB_APB_INT_MASK_APB_INT_MASK_MASK) >> APB_APB_INT_MASK_APB_INT_MASK_SHIFT)
#define  APB_APB_INT_MASK_APB_INT_MASK_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_INT_MASK_APB_INT_MASK_MASK) | (((uint32_t)val) << APB_APB_INT_MASK_APB_INT_MASK_SHIFT))

//====================================================================
//Register: APB Reset (APB_RST)
/** \brief These bits when active will apply a reset over the associated APB bus. A high
value indicates reset is applied. Bit 0 applies the reset to APB bus0, bit 1
applies the reset to APB bus 1, etc.*/
//====================================================================

#define  APB_APB_RST_RESERVED1_MASK 0xfffffff0
#define  APB_APB_RST_RESERVED1_SHIFT 4
#define  APB_APB_RST_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_APB_RST_RESERVED1_MASK) >> APB_APB_RST_RESERVED1_SHIFT)
#define  APB_APB_RST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_RST_RESERVED1_MASK) | (((uint32_t)val) << APB_APB_RST_RESERVED1_SHIFT))

#define  APB_APB_RST_APB_RST_MASK 0xf
#define  APB_APB_RST_APB_RST_SHIFT 0
#define  APB_APB_RST_APB_RST_MASK_SHIFT(reg) (((reg) & APB_APB_RST_APB_RST_MASK) >> APB_APB_RST_APB_RST_SHIFT)
#define  APB_APB_RST_APB_RST_REPLACE_VAL(reg,val) (((reg) & ~APB_APB_RST_APB_RST_MASK) | (((uint32_t)val) << APB_APB_RST_APB_RST_SHIFT))

#endif // BCM
