 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file APMU_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _APMU_TOP_REGSTRUCTS_H_
#define _APMU_TOP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Registers for AP PMU (APMU_top)
/** \brief The APMU provides various registers to control Power Management functions related to the
    Application Processing Subsystem of the SoC.*/
//
//====================================================================

//====================================================================
//
//Register File: APMU SRAM, Power Island control and miscellaneous registers (APMU_misc_reg)
/** \brief These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the AP section of the chip.*/
//
//====================================================================

typedef struct APMU_MISC_REG_REGS_s
{
  volatile uint32_t A53Core0PwrIsland_PICR;  ///< 0x0 [R/W]: Power Island Configuration Register
  volatile uint32_t A53Core0PwrIsland_PISR;  ///< 0x4 [R]: Power Island Status Register
  volatile uint32_t A53Core1PwrIsland_PICR;  ///< 0x8 [R/W]: Power Island Configuration Register
  volatile uint32_t A53Core1PwrIsland_PISR;  ///< 0xc [R]: Power Island Status Register
  volatile uint32_t A53Core2PwrIsland_PICR;  ///< 0x10 [R/W]: Power Island Configuration Register
  volatile uint32_t A53Core2PwrIsland_PISR;  ///< 0x14 [R]: Power Island Status Register
  volatile uint32_t A53Core3PwrIsland_PICR;  ///< 0x18 [R/W]: Power Island Configuration Register
  volatile uint32_t A53Core3PwrIsland_PISR;  ///< 0x1c [R]: Power Island Status Register
  volatile uint32_t A53_L2PwrIsland_PICR;  ///< 0x20 [R/W]: Power Island Configuration Register
  volatile uint32_t A53_L2PwrIsland_PISR;  ///< 0x24 [R]: Power Island Status Register
  volatile uint32_t A53OtherPwrIsland_PICR;  ///< 0x28 [R/W]: Power Island Configuration Register
  volatile uint32_t A53OtherPwrIsland_PISR;  ///< 0x2c [R]: Power Island Status Register
  volatile uint32_t GPUPwrIsland_PICR;  ///< 0x30 [R/W]: Power Island Configuration Register
  volatile uint32_t GPUPwrIsland_PISR;  ///< 0x34 [R]: Power Island Status Register
  volatile uint32_t A53L2_SRAMPdwn;  ///< 0x38 [R/W]: A53 L2 Powerdown Control Register
  volatile uint32_t GC400LT_SRAMPdwn_SPCTL;  ///< 0x3c [R/W]: SRAM Powerdown Control Register
  volatile uint32_t GC400LT_SRAMSpeedCtl_SRAMCTL;  ///< 0x40 [R/W]: SRAM Speed Control Register
  volatile uint32_t GC400LT_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x44 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t NAND_SRAMPdwn_SPCTL;  ///< 0x48 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t NAND_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x4c [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t SCCP_SRAMPdwn_SPCTL;  ///< 0x50 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t SCCP_SRAMSpeedCtl_SRAMCTL;  ///< 0x54 [R/W]: SRAM Speed Control Register
  volatile uint32_t LANRX_SRAMPdwn_SPCTL;  ///< 0x58 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t LANTX_SRAMPdwn_SPCTL;  ///< 0x5c [R/W]: SRAM Powerdown Control Register
  volatile uint32_t LAN_SRAMSpeedCtl_SRAMCTL;  ///< 0x60 [R/W]: SRAM Speed Control Register
  volatile uint32_t LAN_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x64 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t SATA_SRAMPdwn_SPCTL;  ///< 0x68 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t SATA_SRAMSpeedCtl_SRAMCTL;  ///< 0x6c [R/W]: SRAM Speed Control Register
  volatile uint32_t SATA_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x70 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t PCIe_dm2_SRAMPdwn_SPCTL;  ///< 0x74 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t PCIe_dm2_SRAMSpeedCtl_SRAMCTL;  ///< 0x78 [R/W]: SRAM Speed Control Register
  volatile uint32_t PCIe_dm2_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x7c [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t PCIe_dm4_SRAMPdwn_SPCTL;  ///< 0x80 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t PCIe_dm4_SRAMSpeedCtl_SRAMCTL;  ///< 0x84 [R/W]: SRAM Speed Control Register
  volatile uint32_t PCIe_dm4_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x88 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t M2M0_SRAMPdwn_SPCTL;  ///< 0x8c [R/W]: SRAM Powerdown Control Register
  volatile uint32_t M2M0_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x90 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t M2M1_SRAMPdwn_SPCTL;  ///< 0x94 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t M2M1_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x98 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t SDMMC_SRAMPdwn_SPCTL;  ///< 0x9c [R/W]: SRAM Powerdown Control Register
  volatile uint32_t SDMMC_SRAMSpeedCtl_SRAMCTL;  ///< 0xa0 [R/W]: SRAM Speed Control Register
  volatile uint32_t usb3d_SRAMPdwn_SPCTL;  ///< 0xa4 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t usb3d_SRAMSpeedCtl_SRAMCTL;  ///< 0xa8 [R/W]: SRAM Speed Control Register
  volatile uint32_t usb3h_SRAMPdwn_SPCTL;  ///< 0xac [R/W]: SRAM Powerdown Control Register
  volatile uint32_t usb3h_SRAMSpeedCtl_SRAMCTL;  ///< 0xb0 [R/W]: SRAM Speed Control Register
  volatile uint32_t usb3h_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0xb4 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t usb3h_SRAMSpeedCtl_RF2PSRAMCTL1;  ///< 0xb8 [R/W]: RF2P SRAMSpeed Control Register 1
  volatile uint32_t usb3h_SRAMSpeedCtl_RF2PSRAMCTL2;  ///< 0xbc [R/W]: RF2P SRAMSpeed Control Register 2
  volatile uint32_t usbdm_SRAMPdwn_SPCTL;  ///< 0xc0 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t usbdm_SRAMSpeedCtl_SRAMCTL;  ///< 0xc4 [R/W]: SRAM Speed Control Register
  volatile uint32_t usbh_SRAMPdwn_SPCTL;  ///< 0xc8 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t usbh_SRAMSpeedCtl_SRAMCTL;  ///< 0xcc [R/W]: SRAM Speed Control Register
  volatile uint32_t lcd_SRAMPdwn_SPCTL;  ///< 0xd0 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t lcd_SRAMSpeedCtl_SRAMCTL;  ///< 0xd4 [R/W]: SRAM Speed Control Register
  volatile uint32_t lcd_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0xd8 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t PDMA0_SRAMPdwn_SPCTL;  ///< 0xdc [R/W]: SRAM Powerdown Control Register
  volatile uint32_t PDMA0_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0xe0 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t PDMA1_SRAMPdwn_SPCTL;  ///< 0xe4 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t PDMA1_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0xe8 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t Coresight_SRAMPdwn_SPCTL;  ///< 0xec [R/W]: SRAM Powerdown Control Register
  volatile uint32_t Coresight_SRAMSpeedCtl_SRAMCTL;  ///< 0xf0 [R/W]: SRAM Speed Control Register
  volatile uint32_t SMMU_SRAMPdwn_SPCTL;  ///< 0xf4 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t SMMU_SRAMSpeedCtl_SRAMCTL;  ///< 0xf8 [R/W]: SRAM Speed Control Register
  volatile uint32_t SQU_SRAMPdwn_SPCTL;  ///< 0xfc [R/W]: SRAM Powerdown Control Register
  volatile uint32_t SQU_SRAMSpeedCtl_SRAMCTL;  ///< 0x100 [R/W]: SRAM Speed Control Register
  volatile uint32_t MC5_SRAMPdwn_SPCTL;  ///< 0x104 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t MC5_SRAMSpeedCtl_SRAMCTL;  ///< 0x108 [R/W]: SRAM Speed Control Register
  volatile uint32_t RedunRepairCtl;  ///< 0x10c [R/W]: Redundancy Repair Control Register
  volatile uint32_t RepairDone;  ///< 0x110 [R]: Redundancy Repair Done Status Register
  volatile uint32_t ClkDomIntEnReg1;  ///< 0x114 [R/W]: Clock Domain Interrupt Enable Register 1
  volatile uint32_t ClkDomIntPendReg1;  ///< 0x118 [R]: Clock Domain Interrupt Pending Register 1
  volatile uint32_t ClkDomIntAckReg1;  ///< 0x11c [W]: Clock Domain Interrupt Acknowledge Register 1
  volatile uint32_t ClkDomIntForceReg1;  ///< 0x120 [W]: Clock Domain Interrupt Force Register 1
  volatile uint32_t ClkDomIntEnReg2;  ///< 0x124 [R/W]: Clock Domain Interrupt Enable Register 2
  volatile uint32_t ClkDomIntPendReg2;  ///< 0x128 [R]: Clock Domain Interrupt Pending Register 2
  volatile uint32_t ClkDomIntAckReg2;  ///< 0x12c [W]: Clock Domain Interrupt Acknowledge Register 2
  volatile uint32_t ClkDomIntForceReg2;  ///< 0x130 [W]: Clock Domain Interrupt Force Register 2
  volatile uint32_t MiscIntEnReg;  ///< 0x134 [R/W]: Miscellaneous Interrupt Enable Register
  volatile uint32_t MiscIntPendReg;  ///< 0x138 [R]: Miscellaneous Interrupt Pending Register
  volatile uint32_t MiscIntAckReg;  ///< 0x13c [W]: Miscellaneous Interrupt Acknowledge Register
  volatile uint32_t MiscIntForceReg;  ///< 0x140 [W]: Miscellaneous Interrupt Force Register
  volatile uint32_t R4_AXI_ID;  ///< 0x144 [R/W]: R4 AXI ID register
  volatile uint32_t R4_AXI_MASK;  ///< 0x148 [R/W]: R4 AXI ID mask register
  volatile uint32_t ERR_AXI_ID;  ///< 0x14c [R]: Error AXI ID
  volatile uint32_t GENERIC_CTRL;  ///< 0x150 [R/W]: General Control Register
  volatile uint32_t WAKE_CLR;  ///< 0x154 [W]: Wakeup Clear Register
  volatile uint32_t REV0;  ///< 0x158 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x15c [R]: IP Tagging Revision 1
  volatile uint32_t reserved0[8];
  volatile uint32_t BCM_SRAMPdwn_SPCTL;  ///< 0x180 [R/W]: SRAM Powerdown Control Register
  volatile uint32_t BCM_SRAMSpeedCtl_RF2PSRAMCTL;  ///< 0x184 [R/W]: RF2P SRAMSpeed Control Register
  volatile uint32_t R4_SRAMSpeedCtl_SRAMCTL;  ///< 0x188 [R/W]: SRAM Speed Control Register
  volatile uint32_t BCM_ROMCtl_RCTL;  ///< 0x18c [R/W]: SRAM Powerdown Control Register
} APMU_MISC_REG_REGS_t;

//====================================================================
//
//Register File: APMU Clock and Reset Control Registers (APMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Application Processing section of the chip.*/
//
//====================================================================

typedef struct APMU_CLKRSTGEN_REGS_s
{
  volatile uint32_t CPUDbgClkConfig;  ///< 0x0 [R/W]: CPU Debug Clock Configuration Register
  volatile uint32_t CPUDbgClkStatus;  ///< 0x4 [R]: CPU Debug Clock Status Register
  volatile uint32_t TPIUClkConfig_ClkGenConfig;  ///< 0x8 [R/W]: TPIUClk ClkGen Configuration Register
  volatile uint32_t TPIUClkConfig_ClkGenStatus;  ///< 0xc [R]: TPIUClk ClkGen Status Register
  volatile uint32_t MCBusGuardConfig_ClkGenConfig;  ///< 0x10 [R/W]: MCBusGuard ClkGen Configuration Register
  volatile uint32_t MCBusGuardConfig_ClkGenStatus;  ///< 0x14 [R]: MCBusGuard ClkGen Status Register
  volatile uint32_t DDRClk2xConfig_ClkGenConfig;  ///< 0x18 [R/W]: DDRClk2x ClkGen Configuration Register
  volatile uint32_t DDRClk2xConfig_ClkGenStatus;  ///< 0x1c [R]: DDRClk2x ClkGen Status Register
  volatile uint32_t DDRClkConfig;  ///< 0x20 [R/W]: DDR Clock Configuration Register
  volatile uint32_t DDRClkStatus;  ///< 0x24 [R]: DDR Clock Status Register
  volatile uint32_t I2CClkConfig_ClkGenConfig;  ///< 0x28 [R/W]: I2CClk ClkGen Configuration Register
  volatile uint32_t I2CClkConfig_ClkGenStatus;  ///< 0x2c [R]: I2CClk ClkGen Status Register
  volatile uint32_t SSPClkConfig_ClkGenConfig;  ///< 0x30 [R/W]: SSPClk ClkGen Configuration Register
  volatile uint32_t SSPClkConfig_ClkGenStatus;  ///< 0x34 [R]: SSPClk ClkGen Status Register
  volatile uint32_t APBusClkConfig_ClkGenConfig;  ///< 0x38 [R/W]: APBusClk ClkGen Configuration Register
  volatile uint32_t APBusClkConfig_ClkGenStatus;  ///< 0x3c [R]: APBusClk ClkGen Status Register
  volatile uint32_t APBusClkDiv2Config_ClkGenConfig;  ///< 0x40 [R/W]: APBusClkDiv2 ClkGen Configuration Register
  volatile uint32_t APBusClkDiv2Config_ClkGenStatus;  ///< 0x44 [R]: APBusClkDiv2 ClkGen Status Register
  volatile uint32_t APBusClk_APBConfig_ClkGenConfig;  ///< 0x48 [R/W]: APBusClk_APB ClkGen Configuration Register
  volatile uint32_t APBusClk_APBConfig_ClkGenStatus;  ///< 0x4c [R]: APBusClk_APB ClkGen Status Register
  volatile uint32_t APBusClk_LCDConfig_ClkGenConfig;  ///< 0x50 [R/W]: APBusClk_LCD ClkGen Configuration Register
  volatile uint32_t APBusClk_LCDConfig_ClkGenStatus;  ///< 0x54 [R]: APBusClk_LCD ClkGen Status Register
  volatile uint32_t APBusClk_CDMAConfig_ClkGenConfig;  ///< 0x58 [R/W]: APBusClk_CDMA ClkGen Configuration Register
  volatile uint32_t APBusClk_CDMAConfig_ClkGenStatus;  ///< 0x5c [R]: APBusClk_CDMA ClkGen Status Register
  volatile uint32_t APBusClk_SQUConfig_ClkGenConfig;  ///< 0x60 [R/W]: APBusClk_SQU ClkGen Configuration Register
  volatile uint32_t APBusClk_SQUConfig_ClkGenStatus;  ///< 0x64 [R]: APBusClk_SQU ClkGen Status Register
  volatile uint32_t APBusClk_IOWrapConfig_ClkGenConfig;  ///< 0x68 [R/W]: APBusClk_IOWrap ClkGen Configuration Register
  volatile uint32_t APBusClk_IOWrapConfig_ClkGenStatus;  ///< 0x6c [R]: APBusClk_IOWrap ClkGen Status Register
  volatile uint32_t APBusClk_LANConfig_ClkGenConfig;  ///< 0x70 [R/W]: APBusClk_LAN ClkGen Configuration Register
  volatile uint32_t APBusClk_LANConfig_ClkGenStatus;  ///< 0x74 [R]: APBusClk_LAN ClkGen Status Register
  volatile uint32_t APBusClk_USB2AConfig_ClkGenConfig;  ///< 0x78 [R/W]: APBusClk_USB2A ClkGen Configuration Register
  volatile uint32_t APBusClk_USB2AConfig_ClkGenStatus;  ///< 0x7c [R]: APBusClk_USB2A ClkGen Status Register
  volatile uint32_t APBusClk_USB2PHYConfig_ClkGenConfig;  ///< 0x80 [R/W]: APBusClk_USB2PHY ClkGen Configuration Register
  volatile uint32_t APBusClk_USB2PHYConfig_ClkGenStatus;  ///< 0x84 [R]: APBusClk_USB2PHY ClkGen Status Register
  volatile uint32_t APBusClk_USB3DConfig_ClkGenConfig;  ///< 0x88 [R/W]: APBusClk_USB3D ClkGen Configuration Register
  volatile uint32_t APBusClk_USB3DConfig_ClkGenStatus;  ///< 0x8c [R]: APBusClk_USB3D ClkGen Status Register
  volatile uint32_t APBusClk_USB3HConfig_ClkGenConfig;  ///< 0x90 [R/W]: APBusClk_USB3H ClkGen Configuration Register
  volatile uint32_t APBusClk_USB3HConfig_ClkGenStatus;  ///< 0x94 [R]: APBusClk_USB3H ClkGen Status Register
  volatile uint32_t APBusClk_USB3PHYConfig_ClkGenConfig;  ///< 0x98 [R/W]: APBusClk_USB3PHY ClkGen Configuration Register
  volatile uint32_t APBusClk_USB3PHYConfig_ClkGenStatus;  ///< 0x9c [R]: APBusClk_USB3PHY ClkGen Status Register
  volatile uint32_t APBusClk_PCIe_DM2Config_ClkGenConfig;  ///< 0xa0 [R/W]: APBusClk_PCIe_DM2 ClkGen Configuration Register
  volatile uint32_t APBusClk_PCIe_DM2Config_ClkGenStatus;  ///< 0xa4 [R]: APBusClk_PCIe_DM2 ClkGen Status Register
  volatile uint32_t APBusClk_PCIe_DM4Config_ClkGenConfig;  ///< 0xa8 [R/W]: APBusClk_PCIe_DM4 ClkGen Configuration Register
  volatile uint32_t APBusClk_PCIe_DM4Config_ClkGenStatus;  ///< 0xac [R]: APBusClk_PCIe_DM4 ClkGen Status Register
  volatile uint32_t APBusClk_SATAConfig_ClkGenConfig;  ///< 0xb0 [R/W]: APBusClk_SATA ClkGen Configuration Register
  volatile uint32_t APBusClk_SATAConfig_ClkGenStatus;  ///< 0xb4 [R]: APBusClk_SATA ClkGen Status Register
  volatile uint32_t APBusClk_GPUConfig_ClkGenConfig;  ///< 0xb8 [R/W]: APBusClk_GPU ClkGen Configuration Register
  volatile uint32_t APBusClk_GPUConfig_ClkGenStatus;  ///< 0xbc [R]: APBusClk_GPU ClkGen Status Register
  volatile uint32_t SMMUClkConfig_ClkGenConfig;  ///< 0xc0 [R/W]: SMMUClk ClkGen Configuration Register
  volatile uint32_t SMMUClkConfig_ClkGenStatus;  ///< 0xc4 [R]: SMMUClk ClkGen Status Register
  volatile uint32_t GPUBusClkConfig_ClkGenConfig;  ///< 0xc8 [R/W]: GPUBusClk ClkGen Configuration Register
  volatile uint32_t GPUBusClkConfig_ClkGenStatus;  ///< 0xcc [R]: GPUBusClk ClkGen Status Register
  volatile uint32_t GPUClkConfig_ClkGenConfig;  ///< 0xd0 [R/W]: GPUClk ClkGen Configuration Register
  volatile uint32_t GPUClkConfig_ClkGenStatus;  ///< 0xd4 [R]: GPUClk ClkGen Status Register
  volatile uint32_t SDMMCClkConfig_ClkGenConfig;  ///< 0xd8 [R/W]: SDMMCClk ClkGen Configuration Register
  volatile uint32_t SDMMCClkConfig_ClkGenStatus;  ///< 0xdc [R]: SDMMCClk ClkGen Status Register
  volatile uint32_t QSPIClkConfig_ClkGenConfig;  ///< 0xe0 [R/W]: QSPIClk ClkGen Configuration Register
  volatile uint32_t QSPIClkConfig_ClkGenStatus;  ///< 0xe4 [R]: QSPIClk ClkGen Status Register
  volatile uint32_t LCDXClkConfig_ClkGenConfig;  ///< 0xe8 [R/W]: LCDXClk ClkGen Configuration Register
  volatile uint32_t LCDXClkConfig_ClkGenStatus;  ///< 0xec [R]: LCDXClk ClkGen Status Register
  volatile uint32_t LCDClkConfig;  ///< 0xf0 [R/W]: LCD Clock Configuration Register
  volatile uint32_t LCDClkStatus;  ///< 0xf4 [R]: LCD Clock Status Register
  volatile uint32_t UART0ClkConfig_ClkGenConfig;  ///< 0xf8 [R/W]: UART0Clk ClkGen Configuration Register
  volatile uint32_t UART0ClkConfig_ClkGenStatus;  ///< 0xfc [R]: UART0Clk ClkGen Status Register
  volatile uint32_t UART0ClkFracDivCfg;  ///< 0x100 [R/W]: UART0 Clock Fractional Divider Configuration Register
  volatile uint32_t UART1ClkConfig_ClkGenConfig;  ///< 0x104 [R/W]: UART1Clk ClkGen Configuration Register
  volatile uint32_t UART1ClkConfig_ClkGenStatus;  ///< 0x108 [R]: UART1Clk ClkGen Status Register
  volatile uint32_t UART1ClkFracDivCfg;  ///< 0x10c [R/W]: UART1 Clock Fractional Divider Configuration Register
  volatile uint32_t UART2ClkConfig_ClkGenConfig;  ///< 0x110 [R/W]: UART2Clk ClkGen Configuration Register
  volatile uint32_t UART2ClkConfig_ClkGenStatus;  ///< 0x114 [R]: UART2Clk ClkGen Status Register
  volatile uint32_t UART2ClkFracDivCfg;  ///< 0x118 [R/W]: UART2 Clock Fractional Divider Configuration Register
  volatile uint32_t UART3ClkConfig_ClkGenConfig;  ///< 0x11c [R/W]: UART3Clk ClkGen Configuration Register
  volatile uint32_t UART3ClkConfig_ClkGenStatus;  ///< 0x120 [R]: UART3Clk ClkGen Status Register
  volatile uint32_t UART3ClkFracDivCfg;  ///< 0x124 [R/W]: UART3 Clock Fractional Divider Configuration Register
  volatile uint32_t LANMacClk2xConfig;  ///< 0x128 [R/W]: LAN Mac 2x Clock Configuration Register
  volatile uint32_t LANMacClk2xStatus;  ///< 0x12c [R]: LAN Mac 2x Clock Status Register
  volatile uint32_t LANRxClkGenConfig;  ///< 0x130 [R/W]: ClkGen Configuration Register
  volatile uint32_t LANRxClkGenStatus;  ///< 0x134 [R]: ClkGen Status Register
  volatile uint32_t APCPUMiscControl;  ///< 0x138 [R/W]: AP CPU Miscellaneous Control Register
  volatile uint32_t APCPUClkControl;  ///< 0x13c [R/W]: AP CPU Clock Control Register
  volatile uint32_t APCPUClkStatus;  ///< 0x140 [R]: AP CPU Clocks Status Register
  volatile uint32_t R4ClkStatus;  ///< 0x144 [R]: R4 CPU Clocks Status Register
  volatile uint32_t PCIeRstCtl;  ///< 0x148 [R/W]: PCIe Reset Control
  volatile uint32_t reserved0[13];
  volatile uint32_t BCMClkConfig_ClkGenConfig;  ///< 0x180 [R/W]: BCMClk ClkGen Configuration Register
  volatile uint32_t BCMClkConfig_ClkGenStatus;  ///< 0x184 [R]: BCMClk ClkGen Status Register
  volatile uint32_t BCMCPUClkConfig_ClkGenConfig;  ///< 0x188 [R/W]: BCMCPUClk ClkGen Configuration Register
  volatile uint32_t BCMCPUClkConfig_ClkGenStatus;  ///< 0x18c [R]: BCMCPUClk ClkGen Status Register
} APMU_CLKRSTGEN_REGS_t;

//====================================================================
//
//Register File: APMU Timer Control Registers (APMU_timers)
/** \brief The APB TIMERS block provides programmable interval timers and watchdog. <BR>
The interval timers can be used to generate a repetitive period timer (for the RTO/S periodic tick interrupt), to time intervals (for switch presses, LED flashing, or fan speed), or for a watchdog reset. <BR>
Four identical programmable timers (Timer0, Timer1, Timer2, Timer3) are provided in the APB subsystem. Each timer generates a level interrupt when it reaches the final event, which can be programmed to be either a terminal count or an input pulse (on an external signal). When the final event is reached, the counter can restart at zero (continuous mode) or halt, depending on how it is configured. <BR>
Timer0 provides the watchdog function, and when enabled, the system will be reset if the watchdog timer reaches the final event. <BR>
The timer count is incremented on a selected input timebase. There are 8 choices of input timebases to select from: 1us, 10us, 100us, 1ms, 10ms and 100ms, the bus clock, and external input signal pulses. <BR>
To facilitate interval timing, the counter may be disabled to lock the count value that can then be read via the Timer Status Register. The counter is reset to zero and begins to increment when the Timer is re-enabled. <BR>
To assist system level functions, each timer can generate a signal that toggles when the final count is reached. The toggling signal is a periodic waveform that can be used within the SoC or be connected to the pins for further use by the system. <BR>*/
//
//====================================================================

typedef struct APMU_TIMERS_REGS_s
{
  volatile uint32_t TWR0;  ///< 0x0 [R/W]: Timer0 Watchdog Register
  volatile uint32_t TTCR0;  ///< 0x4 [R/W]: Timer0 Terminal Count Register
  volatile uint32_t TCR0;  ///< 0x8 [R/W]: Timer0 Control Register
  volatile uint32_t TSR0;  ///< 0xc [R]: Timer0 Status Register
  volatile uint32_t TISR;  ///< 0x10 [R]: Timers Interrupt Status Register
  volatile uint32_t TTCR1;  ///< 0x14 [R/W]: Timer1 Terminal Count Register
  volatile uint32_t TCR1;  ///< 0x18 [R/W]: Timer1 Control Register
  volatile uint32_t TSR1;  ///< 0x1c [R]: Timer1 Status Register
  volatile uint32_t TIAR;  ///< 0x20 [W]: Timers Interrupt Acknowledge Register
  volatile uint32_t TTCR2;  ///< 0x24 [R/W]: Timer2 Terminal Count Register
  volatile uint32_t TCR2;  ///< 0x28 [R/W]: Timer2 Control Register
  volatile uint32_t TSR2;  ///< 0x2c [R]: Timer2 Status Register
  volatile uint32_t reserved0;
  volatile uint32_t TTCR3;  ///< 0x34 [R/W]: Timer3 Terminal Count Register
  volatile uint32_t TCR3;  ///< 0x38 [R/W]: Timer3 Control Register
  volatile uint32_t TSR3;  ///< 0x3c [R]: Timer3 Status Register
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
} APMU_TIMERS_REGS_t;

#endif // APMU_TOP
