 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file APMU_regmasks_fpga.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _APMU_TOP_REGMASKS_H_
#define _APMU_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Registers for AP PMU (APMU_top)
/** \brief The APMU provides various registers to control Power Management functions related to the
    Application Processing Subsystem of the SoC.*/
//
//====================================================================

//====================================================================
//
//Register File: APMU Clock and Reset Control Registers (APMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Application Processing section of the chip.*/
//
//====================================================================

//====================================================================
//Register: AP CPU Miscellaneous Control Register (APCPUMiscControl)
/** \brief The bits in this register are used to control the resets going to the AP CPU subsystem.*/
//====================================================================

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK 0xf0000000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT 28
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK 0xf000000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT 24
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK 0xf00000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT 20
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK 0x80000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT 19
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK 0x40000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT 18
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK 0x20000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT 17
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK 0x10000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT 16
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK 0xff00
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT 8
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK 0xf0
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT 4
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK 0xf
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT 0
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT))

//====================================================================
//Register: PCIe Reset Control (PCIeRstCtl)
//====================================================================

#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT 2
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK 0x2
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT 1
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT))

#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT))

#endif // APMU_TOP
