 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file APMU_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _APMU_TOP_REGMASKS_H_
#define _APMU_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Registers for AP PMU (APMU_top)
/** \brief The APMU provides various registers to control Power Management functions related to the
    Application Processing Subsystem of the SoC.*/
//
//====================================================================

//====================================================================
//
//Register File: APMU SRAM, Power Island control and miscellaneous registers (APMU_misc_reg)
/** \brief These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the AP section of the chip.*/
//
//====================================================================

//====================================================================
//Register: Power Island Configuration Register (A53Core0PwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_MASK 0x200
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_SHIFT 9
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DBGPWRDUP_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_MASK 0x100
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_SHIFT 8
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_DISTPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53Core0PwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_MASK 0x100
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_SHIFT 8
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_DISTSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE0PWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (A53Core1PwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_MASK 0x200
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_SHIFT 9
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DBGPWRDUP_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_MASK 0x100
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_SHIFT 8
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_DISTPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53Core1PwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_MASK 0x100
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_SHIFT 8
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_DISTSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE1PWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (A53Core2PwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_MASK 0x200
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_SHIFT 9
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DBGPWRDUP_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_MASK 0x100
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_SHIFT 8
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_DISTPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53Core2PwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_MASK 0x100
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_SHIFT 8
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_DISTSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE2PWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (A53Core3PwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_MASK 0x200
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_SHIFT 9
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DBGPWRDUP_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_MASK 0x100
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_SHIFT 8
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_DISTPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53Core3PwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_MASK 0x100
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_SHIFT 8
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_DISTSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53CORE3PWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (A53_L2PwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_MASK 0x200
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_SHIFT 9
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_MASK 0x100
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_SHIFT 8
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_MASK 0xc0
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_SHIFT 6
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED4_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_MASK 0xe
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_SHIFT 1
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED5_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_MASK 0x1
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_SHIFT 0
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PICR_RESERVED6_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53_L2PwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_MASK 0x100
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_SHIFT 8
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_MASK 0xc0
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_SHIFT 6
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_MASK 0xe
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_SHIFT 1
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED4_SHIFT))

#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_MASK 0x1
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_SHIFT 0
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_MASK) >> APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_SHIFT)
#define  APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53_L2PWRISLAND_PISR_RESERVED5_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (A53OtherPwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_MASK 0x200
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_SHIFT 9
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_MASK 0x100
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_SHIFT 8
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_DISTPWRUP_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_MASK 0xc0
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_SHIFT 6
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_MASK 0xe
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_SHIFT 1
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_RESERVED4_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (A53OtherPwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_MASK 0x100
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_SHIFT 8
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_DISTSTATUS_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_MASK 0xc0
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_SHIFT 6
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_MASK 0xe
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_SHIFT 1
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53OTHERPWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Configuration Register (GPUPwrIsland_PICR)
/** \brief <p>The Power Island Configuration Register (PICR) and the Power Island Status Register (PISR) control internal power switches for on-chip power islands. When power to a island is switched off the blocks in it are unactive and consume zero power. When the power is switched back on, the blocks get a complete hardware reset to return them to their default power-on state. This register is "locked" when PI_LOCK is not 0x0 or PI_UNLOCK is not 0x3. Then values written still stored but they have no effect and are not reflected in the PISR. Locking the register when not doing power switching operations provides some protection against spurious register writes.</p>
        To switch off an island:<br/>
        <ul>
        <li>Disable the clock to the island in the PWCR.</li>
        <li>Set the ISOLATE bit</li>
        <li>Set the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum).</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=1</li>
        <li>Set the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=1</li>
        <br />
        To switch an island back on:
        <ul>
        <li>Assert resets for all clock domains in the island via the ClkGenConfig
        register(s)</li>
        <li>Clear the SLEEP1 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP1_RETURN=0</li>
        <li>Clear the SLEEP2 bit</li>
        <li>Wait at least 200 us (no maximum)</li>
        <li>Read the PISR and verify that SLEEP2_RETURN=0</li>
        <li>Enable the clock(s) to the island in the ClkGenConfig register(s) for
        all clock domains on the island.</li>
        <li>Disable the clock(s) to the island in the ClkGenConfig register(s).</li>
        <li>Deassert the resets for all clock domains in the ClkGenConfig register(s)
        </li>
        <li>Clear ISOLATE bit</li>
        <li>Enable the clock(s) for the island in the ClkGenConfig register(s).
        </li></ul>
        Only switch one island at a time to avoid high surge currents which could cause a malfunction.*/
//====================================================================

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_MASK 0xfffffc00
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_SHIFT 10
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_MASK 0x200
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_SHIFT 9
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_MASK 0x100
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_SHIFT 8
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_MASK 0xc0
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_SHIFT 6
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED4_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_MASK 0x30
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_SHIFT 4
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_BULKPWRUP_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_MASK 0xe
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_SHIFT 1
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_RESERVED5_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_MASK 0x1
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_SHIFT 0
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PICR_ISOB_SHIFT))

//====================================================================
//Register: Power Island Status Register (GPUPwrIsland_PISR)
/** \brief The Power Island Status Register contains the current state of the power switch controls.
      It is identical to the contents of the PICR except when the state is changing.*/
//====================================================================

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_MASK 0xfffffe00
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_SHIFT 9
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_MASK 0x100
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_SHIFT 8
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED2_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_MASK 0xc0
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_SHIFT 6
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED3_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_MASK 0x30
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_SHIFT 4
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_BULKSTATUS_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_MASK 0xe
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_SHIFT 1
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_RESERVED4_SHIFT))

#define  APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_MASK 0x1
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_SHIFT 0
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_MASK) >> APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_SHIFT)
#define  APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_MASK) | (((uint32_t)val) << APMU_MISC_REG_GPUPWRISLAND_PISR_ISOB_SHIFT))

//====================================================================
//Register: A53 L2 Powerdown Control Register (A53L2_SRAMPdwn)
/** \brief The fields of this register drive the low leakage power control signals of the A53 L2 SRAMs*/
//====================================================================

#define  APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_MASK 0xfffffffe
#define  APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_SHIFT 1
#define  APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_MASK) >> APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_SHIFT)
#define  APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53L2_SRAMPDWN_RESERVED1_SHIFT))

#define  APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_MASK 0x1
#define  APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_SHIFT 0
#define  APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_MASK) >> APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_SHIFT)
#define  APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_A53L2_SRAMPDWN_PDWN_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (GC400LT_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (GC400LT_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (GC400LT_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_GC400LT_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (NAND_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (NAND_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_NAND_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (SCCP_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (SCCP_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SCCP_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (LANRX_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANRX_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (LANTX_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_LANTX_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (LAN_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        RX SRAM*/
//====================================================================

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (LAN_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        TX SRAM*/
//====================================================================

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LAN_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (SATA_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (SATA_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        128x24, 128x64, 32x32, 32x64*/
//====================================================================

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffff0000
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 16
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (SATA_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        64x32, 512x66*/
//====================================================================

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xffffff00
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 8
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SATA_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (PCIe_dm2_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (PCIe_dm2_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        Retry Buffer*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (PCIe_dm2_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        Receive queue heder, Receive queue data, RADMX Composition, GM Composition*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xffff0000
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 16
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM2_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (PCIe_dm4_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (PCIe_dm4_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        Retry Buffer*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (PCIe_dm4_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        Receive queue heder, Receive queue data, RADMX Composition, GM Composition*/
//====================================================================

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xffff0000
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 16
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PCIE_DM4_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (M2M0_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (M2M0_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (M2M1_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (M2M1_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_M2M1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (SDMMC_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (SDMMC_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SDMMC_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (usb3d_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (usb3d_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        RX, TX, Descriptor*/
//====================================================================

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffff000
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 12
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3D_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (usb3h_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (usb3h_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        slot_ep_cntxt, deqptr_dcs, trans_trb, ep_status_hs, ss_data_in, ep_status_ss, tx_data_buf_ram*/
//====================================================================

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xf0000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 28
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_MASK 0xc000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT 26
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_MASK 0x3000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT 24
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_MASK 0xc00000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT 22
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_MASK 0x300000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT 20
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (usb3h_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        ahb_addr_len, cmd_slot_state, cmd_input_cntxt, event_mem, er_seg_table, spipe, trans_que, ahb_out_fifo*/
//====================================================================

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_MASK 0xc0000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_SHIFT 30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC7_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_MASK 0x30000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_SHIFT 28
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC7_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_MASK 0xc000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_SHIFT 26
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_MASK 0x3000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_SHIFT 24
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK 0xc00000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT 22
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK 0x300000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT 20
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK 0xc0000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT 18
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK 0x30000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT 16
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register 1 (usb3h_SRAMSpeedCtl_RF2PSRAMCTL1)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        ahb_in_fifo, seqnum_hs, hs_resp_queue, hs_data_in, hs_ctrl_fifo, hs_data_out, ss_resp_queue, ss_ctrl_in*/
//====================================================================

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_MASK 0xc0000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_SHIFT 30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC7_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_MASK 0x30000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_SHIFT 28
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC7_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_MASK 0xc000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_SHIFT 26
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_MASK 0x3000000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_SHIFT 24
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC6_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_MASK 0xc00000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_SHIFT 22
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_MASK 0x300000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_SHIFT 20
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC5_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_MASK 0xc0000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_SHIFT 18
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_MASK 0x30000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_SHIFT 16
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_MASK 0xc000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_SHIFT 14
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_MASK 0x3000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_SHIFT 12
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_SHIFT 10
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_MASK 0x300
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_SHIFT 8
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_SHIFT 6
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_MASK 0x30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_SHIFT 4
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_MASK 0xc
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_SHIFT 2
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_RTC0_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_MASK 0x3
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_SHIFT 0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL1_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register 2 (usb3h_SRAMSpeedCtl_RF2PSRAMCTL2)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        ss_ctrl_out, ss_data_out, seqnum_ss, que_ram, tx_sync_fifo_ds*/
//====================================================================

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_MASK 0xfff00000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_SHIFT 20
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_MASK 0xc0000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_SHIFT 18
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_MASK 0x30000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_SHIFT 16
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC4_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_MASK 0xc000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_SHIFT 14
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_MASK 0x3000
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_SHIFT 12
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC3_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_SHIFT 10
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_MASK 0x300
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_SHIFT 8
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC2_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_SHIFT 6
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_MASK 0x30
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_SHIFT 4
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC1_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_MASK 0xc
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_SHIFT 2
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_RTC0_SHIFT))

#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_MASK 0x3
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_SHIFT 0
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_MASK) >> APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_SHIFT)
#define  APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USB3H_SRAMSPEEDCTL_RF2PSRAMCTL2_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (usbdm_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (usbdm_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        tx0, rx0, tx1, rx1*/
//====================================================================

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffff0000
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 16
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBDM_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (usbh_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (usbh_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        tx, rx*/
//====================================================================

#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffffff00
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 8
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_USBH_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (lcd_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (lcd_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        palette, gamma*/
//====================================================================

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffffff00
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 8
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (lcd_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        aff4gra, aff4yuv_y, aff4yuv_uv*/
//====================================================================

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffff000
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 12
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_LCD_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (PDMA0_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (PDMA0_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA0_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (PDMA1_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (PDMA1_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_PDMA1_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (Coresight_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (Coresight_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_CORESIGHT_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (SMMU_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (SMMU_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SMMU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (SQU_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (SQU_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_SQU_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (MC5_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (MC5_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xffffff00
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 8
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_MC5_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: Redundancy Repair Control Register (RedunRepairCtl)
/** \brief The bits in this register allow the LPP to sequence through the redundancy repair process.*/
//====================================================================

#define  APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_MASK 0xfffffff8
#define  APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_SHIFT 3
#define  APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_MASK) >> APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_REDUNREPAIRCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_MASK 0x4
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_SHIFT 2
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_MASK) >> APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_SHIFT)
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_MASK) | (((uint32_t)val) << APMU_MISC_REG_REDUNREPAIRCTL_NRST_CA53_AXIM_SHIFT))

#define  APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_MASK 0x2
#define  APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_SHIFT 1
#define  APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_MASK) >> APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_SHIFT)
#define  APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_MASK) | (((uint32_t)val) << APMU_MISC_REG_REDUNREPAIRCTL_L2_REDUN_START_SHIFT))

#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_MASK 0x1
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_SHIFT 0
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_MASK) >> APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_SHIFT)
#define  APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_MASK) | (((uint32_t)val) << APMU_MISC_REG_REDUNREPAIRCTL_NRST_L2_REDUN_SHIFT))

//====================================================================
//Register: Redundancy Repair Done Status Register (RepairDone)
/** \brief After reset, SRAMs with redundancy must go through a repair process. This register contains
      status bits for each SRAM with redundancy in the IPS. Firmware should ensure that the
      corresponding RepairDone status bit is set before doing anything that would access those
      SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_REPAIRDONE_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_REPAIRDONE_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REPAIRDONE_RESERVED1_MASK) >> APMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT)
#define  APMU_MISC_REG_REPAIRDONE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REPAIRDONE_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_REPAIRDONE_RESERVED1_SHIFT))

#define  APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_MASK 0x2
#define  APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_SHIFT 1
#define  APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_MASK) >> APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_SHIFT)
#define  APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_MASK) | (((uint32_t)val) << APMU_MISC_REG_REPAIRDONE_APL2_SRBIST_REPAIRDONE_SHIFT))

#define  APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_MASK 0x1
#define  APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_SHIFT 0
#define  APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_MASK) >> APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_SHIFT)
#define  APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_MASK) | (((uint32_t)val) << APMU_MISC_REG_REPAIRDONE_AP_SRBIST_REPAIRDONE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Enable Register 1 (ClkDomIntEnReg1)
/** \brief Bit order (high to low): lanmacclk2x, lanrxclk, uartclk_IRQ[4], lcdclk, lcdxclk,
      qspiclk, sdmmcclk, gpuclk, gpubusclk, smmuclk, bcmclk, apbusclkdiv2, apbusclk_gpu,
      apbusclk_sata, apbusclk_pcie_dm4, apbusclk_pcie_dm2, apbusclk_usb3phy, apbusclk_usb3h,
      apbusclk_usb3d, apbusclk_usb2phy, apbusclk_usb2a, apbusclk_lan, apbusclk_iowrap,
      apbusclk_squ, apbusclk_cdma, apbusclk_lcd, apbusclk_apb, sspclk, i2cclk.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_MASK 0xffffffff
#define  APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_MASK) >> APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTENREG1_INTENABLE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Pending Register 1 (ClkDomIntPendReg1)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_MASK 0xffffffff
#define  APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_MASK) >> APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTPENDREG1_INTPEND_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Acknowledge Register 1 (ClkDomIntAckReg1)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_MASK 0xffffffff
#define  APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_MASK) >> APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTACKREG1_INTACK_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Force Register 1 (ClkDomIntForceReg1)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_MASK 0xffffffff
#define  APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_MASK) >> APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTFORCEREG1_INTFORCE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Enable Register 2 (ClkDomIntEnReg2)
/** \brief Bit order (high to low): ddrclk, ddrclk2x, tpiuclk, cpudbgclk.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_MASK) >> APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTENREG2_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_MASK 0xf
#define  APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_MASK) >> APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTENREG2_INTENABLE_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Pending Register 2 (ClkDomIntPendReg2)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_MASK) >> APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTPENDREG2_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_MASK 0xf
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_MASK) >> APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTPENDREG2_INTPEND_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Acknowledge Register 2 (ClkDomIntAckReg2)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_MASK) >> APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTACKREG2_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_MASK 0xf
#define  APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_MASK) >> APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTACKREG2_INTACK_SHIFT))

//====================================================================
//Register: Clock Domain Interrupt Force Register 2 (ClkDomIntForceReg2)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_MASK) >> APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTFORCEREG2_RESERVED1_SHIFT))

#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_MASK 0xf
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_SHIFT 0
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_MASK) >> APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_SHIFT)
#define  APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_MASK) | (((uint32_t)val) << APMU_MISC_REG_CLKDOMINTFORCEREG2_INTFORCE_SHIFT))

//====================================================================
//Register: Miscellaneous Interrupt Enable Register (MiscIntEnReg)
/** \brief Bit order (high to low): MC_Access, Timer3, Timer2, Timer1, Timer0.*/
//====================================================================

#define  APMU_MISC_REG_MISCINTENREG_RESERVED1_MASK 0xffffffe0
#define  APMU_MISC_REG_MISCINTENREG_RESERVED1_SHIFT 5
#define  APMU_MISC_REG_MISCINTENREG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTENREG_RESERVED1_MASK) >> APMU_MISC_REG_MISCINTENREG_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MISCINTENREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTENREG_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTENREG_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MISCINTENREG_INTENABLE_MASK 0x1f
#define  APMU_MISC_REG_MISCINTENREG_INTENABLE_SHIFT 0
#define  APMU_MISC_REG_MISCINTENREG_INTENABLE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTENREG_INTENABLE_MASK) >> APMU_MISC_REG_MISCINTENREG_INTENABLE_SHIFT)
#define  APMU_MISC_REG_MISCINTENREG_INTENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTENREG_INTENABLE_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTENREG_INTENABLE_SHIFT))

//====================================================================
//Register: Miscellaneous Interrupt Pending Register (MiscIntPendReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_MISCINTPENDREG_RESERVED1_MASK 0xffffffe0
#define  APMU_MISC_REG_MISCINTPENDREG_RESERVED1_SHIFT 5
#define  APMU_MISC_REG_MISCINTPENDREG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTPENDREG_RESERVED1_MASK) >> APMU_MISC_REG_MISCINTPENDREG_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MISCINTPENDREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTPENDREG_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTPENDREG_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MISCINTPENDREG_INTPEND_MASK 0x1f
#define  APMU_MISC_REG_MISCINTPENDREG_INTPEND_SHIFT 0
#define  APMU_MISC_REG_MISCINTPENDREG_INTPEND_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTPENDREG_INTPEND_MASK) >> APMU_MISC_REG_MISCINTPENDREG_INTPEND_SHIFT)
#define  APMU_MISC_REG_MISCINTPENDREG_INTPEND_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTPENDREG_INTPEND_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTPENDREG_INTPEND_SHIFT))

//====================================================================
//Register: Miscellaneous Interrupt Acknowledge Register (MiscIntAckReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_MISCINTACKREG_RESERVED1_MASK 0xffffffe0
#define  APMU_MISC_REG_MISCINTACKREG_RESERVED1_SHIFT 5
#define  APMU_MISC_REG_MISCINTACKREG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTACKREG_RESERVED1_MASK) >> APMU_MISC_REG_MISCINTACKREG_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MISCINTACKREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTACKREG_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTACKREG_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MISCINTACKREG_INTACK_MASK 0x1f
#define  APMU_MISC_REG_MISCINTACKREG_INTACK_SHIFT 0
#define  APMU_MISC_REG_MISCINTACKREG_INTACK_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTACKREG_INTACK_MASK) >> APMU_MISC_REG_MISCINTACKREG_INTACK_SHIFT)
#define  APMU_MISC_REG_MISCINTACKREG_INTACK_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTACKREG_INTACK_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTACKREG_INTACK_SHIFT))

//====================================================================
//Register: Miscellaneous Interrupt Force Register (MiscIntForceReg)
/** \brief See IntEnReg description for bit mapping.*/
//====================================================================

#define  APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_MASK 0xffffffe0
#define  APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_SHIFT 5
#define  APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_MASK) >> APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_SHIFT)
#define  APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTFORCEREG_RESERVED1_SHIFT))

#define  APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_MASK 0x1f
#define  APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_SHIFT 0
#define  APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_MASK) >> APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_SHIFT)
#define  APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_MASK) | (((uint32_t)val) << APMU_MISC_REG_MISCINTFORCEREG_INTFORCE_SHIFT))

//====================================================================
//Register: R4 AXI ID register (R4_AXI_ID)
/** \brief The AXI ID for the R4 security/low power processor should be written into this register.
      This value is provided to special AXI shims that are placed in front of the memory
      controller AXI slave ports when the memory controller has its clock gated. Any accesses
      from an AXI ID other than the R4 will generate an error interrupt. Accesses from the
      R4 are not considered to be an error, as they will be used instead to generate a fault
      that will trigger the R4 to wake the memory controller back up. The compare for the
      ID value in this register will be masked with the value in the R4AXIMASK register.*/
//====================================================================

#define  APMU_MISC_REG_R4_AXI_ID_RESERVED1_MASK 0xff000000
#define  APMU_MISC_REG_R4_AXI_ID_RESERVED1_SHIFT 24
#define  APMU_MISC_REG_R4_AXI_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_AXI_ID_RESERVED1_MASK) >> APMU_MISC_REG_R4_AXI_ID_RESERVED1_SHIFT)
#define  APMU_MISC_REG_R4_AXI_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_AXI_ID_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_AXI_ID_RESERVED1_SHIFT))

#define  APMU_MISC_REG_R4_AXI_ID_AXI_ID_MASK 0xffffff
#define  APMU_MISC_REG_R4_AXI_ID_AXI_ID_SHIFT 0
#define  APMU_MISC_REG_R4_AXI_ID_AXI_ID_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_AXI_ID_AXI_ID_MASK) >> APMU_MISC_REG_R4_AXI_ID_AXI_ID_SHIFT)
#define  APMU_MISC_REG_R4_AXI_ID_AXI_ID_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_AXI_ID_AXI_ID_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_AXI_ID_AXI_ID_SHIFT))

//====================================================================
//Register: R4 AXI ID mask register (R4_AXI_MASK)
/** \brief When comparing the value in the R4AXIID register with an incoming AXI transaction, the
      memory controller AXI shim will ignore the values of any bits that are set to 0 in
      this mask register.*/
//====================================================================

#define  APMU_MISC_REG_R4_AXI_MASK_RESERVED1_MASK 0xff000000
#define  APMU_MISC_REG_R4_AXI_MASK_RESERVED1_SHIFT 24
#define  APMU_MISC_REG_R4_AXI_MASK_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_AXI_MASK_RESERVED1_MASK) >> APMU_MISC_REG_R4_AXI_MASK_RESERVED1_SHIFT)
#define  APMU_MISC_REG_R4_AXI_MASK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_AXI_MASK_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_AXI_MASK_RESERVED1_SHIFT))

#define  APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_MASK 0xffffff
#define  APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_SHIFT 0
#define  APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_MASK) >> APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_SHIFT)
#define  APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_AXI_MASK_AXI_ID_MASK_SHIFT))

//====================================================================
//Register: Error AXI ID (ERR_AXI_ID)
/** \brief If an AXI master other than the R4 low power processor (as indicated by the R4_AXI_ID and
      R4_AXI_MASK register values) tries to access the memory controller while its clock is gated
      off, an interrupt will be generated, and the AXI ID of the master that attempted the
      access will be available in this register.*/
//====================================================================

#define  APMU_MISC_REG_ERR_AXI_ID_RESERVED1_MASK 0xff000000
#define  APMU_MISC_REG_ERR_AXI_ID_RESERVED1_SHIFT 24
#define  APMU_MISC_REG_ERR_AXI_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_ERR_AXI_ID_RESERVED1_MASK) >> APMU_MISC_REG_ERR_AXI_ID_RESERVED1_SHIFT)
#define  APMU_MISC_REG_ERR_AXI_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_ERR_AXI_ID_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_ERR_AXI_ID_RESERVED1_SHIFT))

#define  APMU_MISC_REG_ERR_AXI_ID_AXI_ID_MASK 0xffffff
#define  APMU_MISC_REG_ERR_AXI_ID_AXI_ID_SHIFT 0
#define  APMU_MISC_REG_ERR_AXI_ID_AXI_ID_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_ERR_AXI_ID_AXI_ID_MASK) >> APMU_MISC_REG_ERR_AXI_ID_AXI_ID_SHIFT)
#define  APMU_MISC_REG_ERR_AXI_ID_AXI_ID_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_ERR_AXI_ID_AXI_ID_MASK) | (((uint32_t)val) << APMU_MISC_REG_ERR_AXI_ID_AXI_ID_SHIFT))

//====================================================================
//Register: General Control Register (GENERIC_CTRL)
/** \brief Miscellaneous power related control signals.*/
//====================================================================

#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED1_MASK 0xffe00000
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED1_SHIFT 21
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_RESERVED1_MASK) >> APMU_MISC_REG_GENERIC_CTRL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_MASK 0x1e0000
#define  APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_SHIFT 17
#define  APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_MASK) >> APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_MC_CS_OVERRIDE_SHIFT))

#define  APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_MASK 0x10000
#define  APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_SHIFT 16
#define  APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_MASK) >> APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_MC_PHY_PWRDWN_SHIFT))

#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED2_MASK 0x8000
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED2_SHIFT 15
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_RESERVED2_MASK) >> APMU_MISC_REG_GENERIC_CTRL_RESERVED2_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_RESERVED2_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_RESERVED2_SHIFT))

#define  APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_MASK 0x4000
#define  APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_SHIFT 14
#define  APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_MASK) >> APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_FUSE_CLK_DIV_COUNT_DISABLE_SHIFT))

#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED3_MASK 0x3fff
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED3_SHIFT 0
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_GENERIC_CTRL_RESERVED3_MASK) >> APMU_MISC_REG_GENERIC_CTRL_RESERVED3_SHIFT)
#define  APMU_MISC_REG_GENERIC_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_GENERIC_CTRL_RESERVED3_MASK) | (((uint32_t)val) << APMU_MISC_REG_GENERIC_CTRL_RESERVED3_SHIFT))

//====================================================================
//Register: Wakeup Clear Register (WAKE_CLR)
/** \brief Provides signals to clear various wakeup sources.*/
//====================================================================

#define  APMU_MISC_REG_WAKE_CLR_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_WAKE_CLR_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_WAKE_CLR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_WAKE_CLR_RESERVED1_MASK) >> APMU_MISC_REG_WAKE_CLR_RESERVED1_SHIFT)
#define  APMU_MISC_REG_WAKE_CLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_WAKE_CLR_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_WAKE_CLR_RESERVED1_SHIFT))

#define  APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_MASK 0xf
#define  APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_SHIFT 0
#define  APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_MASK) >> APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_SHIFT)
#define  APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_MASK) | (((uint32_t)val) << APMU_MISC_REG_WAKE_CLR_SDH_WK_CLR_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  APMU_MISC_REG_REV0_MAJ_MASK 0xffff0000
#define  APMU_MISC_REG_REV0_MAJ_SHIFT 16
#define  APMU_MISC_REG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REV0_MAJ_MASK) >> APMU_MISC_REG_REV0_MAJ_SHIFT)
#define  APMU_MISC_REG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REV0_MAJ_MASK) | (((uint32_t)val) << APMU_MISC_REG_REV0_MAJ_SHIFT))

#define  APMU_MISC_REG_REV0_MID_MASK 0xffff
#define  APMU_MISC_REG_REV0_MID_SHIFT 0
#define  APMU_MISC_REG_REV0_MID_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REV0_MID_MASK) >> APMU_MISC_REG_REV0_MID_SHIFT)
#define  APMU_MISC_REG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REV0_MID_MASK) | (((uint32_t)val) << APMU_MISC_REG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APMU_MISC_REG_REV1_RESERVED1_MASK 0xffff0000
#define  APMU_MISC_REG_REV1_RESERVED1_SHIFT 16
#define  APMU_MISC_REG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REV1_RESERVED1_MASK) >> APMU_MISC_REG_REV1_RESERVED1_SHIFT)
#define  APMU_MISC_REG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REV1_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_REV1_RESERVED1_SHIFT))

#define  APMU_MISC_REG_REV1_CFG_MASK 0xffff
#define  APMU_MISC_REG_REV1_CFG_SHIFT 0
#define  APMU_MISC_REG_REV1_CFG_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_REV1_CFG_MASK) >> APMU_MISC_REG_REV1_CFG_SHIFT)
#define  APMU_MISC_REG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_REV1_CFG_MASK) | (((uint32_t)val) << APMU_MISC_REG_REV1_CFG_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (BCM_SRAMPdwn_SPCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_SHIFT 2
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_MASK) >> APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_MASK 0x2
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_SHIFT 1
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_MASK) >> APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDLVMC_SHIFT))

#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_MASK) >> APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMPDWN_SPCTL_PDWN_SHIFT))

//====================================================================
//Register: RF2P SRAMSpeed Control Register (BCM_SRAMSpeedCtl_RF2PSRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK 0xfffffff0
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT 4
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) >> APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) >> APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_SRAMSPEEDCTL_RF2PSRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Speed Control Register (R4_SRAMSpeedCtl_SRAMCTL)
/** \brief The fields of this register drive the RTC/WTC signals of the following SRAMS:
        (least significant fields to most significant fields)
        ICache Data, ICache Tag, DCache Data, DCache Tag, DCacheDirty*/
//====================================================================

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK 0xfff00000
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT 20
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK 0xc0000
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT 18
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC4_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK 0x30000
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT 16
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC4_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK 0xc000
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT 14
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC3_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK 0x3000
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT 12
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC3_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK 0xc00
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT 10
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC2_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK 0x300
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT 8
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC2_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK 0xc0
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT 6
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC1_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK 0x30
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT 4
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC1_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK 0xc
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT 2
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_RTC0_SHIFT))

#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK 0x3
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT 0
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) >> APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT)
#define  APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_MASK) | (((uint32_t)val) << APMU_MISC_REG_R4_SRAMSPEEDCTL_SRAMCTL_WTC0_SHIFT))

//====================================================================
//Register: SRAM Powerdown Control Register (BCM_ROMCtl_RCTL)
/** \brief The fields of this register drive the low leakage power control signals of a set of SRAMs.*/
//====================================================================

#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_MASK 0xffffffc0
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_SHIFT 6
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_MASK) >> APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_SHIFT)
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_ROMCTL_RCTL_RESERVED1_SHIFT))

#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_MASK 0x30
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_SHIFT 4
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_MASK) >> APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_SHIFT)
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REF_SHIFT))

#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_MASK 0xe
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_SHIFT 1
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_MASK) >> APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_SHIFT)
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_ROMCTL_RCTL_RTC_SHIFT))

#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_MASK 0x1
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_SHIFT 0
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_MASK_SHIFT(reg) (((reg) & APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_MASK) >> APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_SHIFT)
#define  APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_MASK) | (((uint32_t)val) << APMU_MISC_REG_BCM_ROMCTL_RCTL_PDWN_SHIFT))

//====================================================================
//
//Register File: APMU Clock and Reset Control Registers (APMU_ClkRstGen)
/** \brief These registers provide control/status for the clocks/resets for all of the clock domains
    in the Application Processing section of the chip.*/
//
//====================================================================

//====================================================================
//Register: CPU Debug Clock Configuration Register (CPUDbgClkConfig)
/** \brief CPU Debug Clock domain Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_MASK 0x4
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_SHIFT 2
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_AT_RSTN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKCONFIG_CPU_RSTN_SHIFT))

//====================================================================
//Register: CPU Debug Clock Status Register (CPUDbgClkStatus)
/** \brief CPU Debug Clock Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_MASK 0x4
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_SHIFT 2
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_AT_RSTN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_MASK) >> APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_CPUDBGCLKSTATUS_CPU_RSTN_SHIFT))

//====================================================================
//Register: TPIUClk ClkGen Configuration Register (TPIUClkConfig_ClkGenConfig)
/** \brief TPIUClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: TPIUClk ClkGen Status Register (TPIUClkConfig_ClkGenStatus)
/** \brief TPIUClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_TPIUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: MCBusGuard ClkGen Configuration Register (MCBusGuardConfig_ClkGenConfig)
/** \brief MCBusGuard ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: MCBusGuard ClkGen Status Register (MCBusGuardConfig_ClkGenStatus)
/** \brief MCBusGuard ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf80000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 19
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_MASK 0x70000
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf800
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 11
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_MASK 0x700
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_MCBUSGUARDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: DDRClk2x ClkGen Configuration Register (DDRClk2xConfig_ClkGenConfig)
/** \brief DDRClk2x ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf80000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 19
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_MASK 0x70000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf800
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 11
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_MASK 0x700
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: DDRClk2x ClkGen Status Register (DDRClk2xConfig_ClkGenStatus)
/** \brief DDRClk2x ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf80000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 19
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_MASK 0x70000
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf800
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 11
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_MASK 0x700
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLK2XCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: DDR Clock Configuration Register (DDRClkConfig)
/** \brief DDR Clock Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_MASK 0x3fe00000
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_SHIFT 21
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_MASK 0x100000
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_SHIFT 20
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_DIVSEL_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_MASK 0xfff80
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_SHIFT 7
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_MASK 0x4
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_SHIFT 2
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKCONFIG_RSTN_SHIFT))

//====================================================================
//Register: DDR Clock Status Register (DDRClkStatus)
/** \brief DDR Clock Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_MASK 0xfe000000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_MASK 0xe00000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_SHIFT 21
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_MASK 0x100000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_SHIFT 20
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_DIVSEL_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_MASK 0x80000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_SHIFT 19
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_MASK 0x70000
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_MASK 0xf800
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_SHIFT 11
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_MASK 0x700
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_DDRCLKSTATUS_RSTN_SHIFT))

//====================================================================
//Register: I2CClk ClkGen Configuration Register (I2CClkConfig_ClkGenConfig)
/** \brief I2CClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: I2CClk ClkGen Status Register (I2CClkConfig_ClkGenStatus)
/** \brief I2CClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_I2CCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: SSPClk ClkGen Configuration Register (SSPClkConfig_ClkGenConfig)
/** \brief SSPClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 24
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: SSPClk ClkGen Status Register (SSPClkConfig_ClkGenStatus)
/** \brief SSPClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x7000000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 24
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SSPCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk ClkGen Configuration Register (APBusClkConfig_ClkGenConfig)
/** \brief APBusClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENCONFIG_RESERVED8_SHIFT))

//====================================================================
//Register: APBusClk ClkGen Status Register (APBusClkConfig_ClkGenStatus)
/** \brief APBusClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0xf8
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED7_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) >> APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKCONFIG_CLKGENSTATUS_RESERVED8_SHIFT))

//====================================================================
//Register: APBusClkDiv2 ClkGen Configuration Register (APBusClkDiv2Config_ClkGenConfig)
/** \brief APBusClkDiv2 ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClkDiv2 ClkGen Status Register (APBusClkDiv2Config_ClkGenStatus)
/** \brief APBusClkDiv2 ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLKDIV2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: APBusClk_APB ClkGen Configuration Register (APBusClk_APBConfig_ClkGenConfig)
/** \brief APBusClk_APB ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_APB ClkGen Status Register (APBusClk_APBConfig_ClkGenStatus)
/** \brief APBusClk_APB ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_APBCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_LCD ClkGen Configuration Register (APBusClk_LCDConfig_ClkGenConfig)
/** \brief APBusClk_LCD ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_LCD ClkGen Status Register (APBusClk_LCDConfig_ClkGenStatus)
/** \brief APBusClk_LCD ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LCDCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_CDMA ClkGen Configuration Register (APBusClk_CDMAConfig_ClkGenConfig)
/** \brief APBusClk_CDMA ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_CDMA ClkGen Status Register (APBusClk_CDMAConfig_ClkGenStatus)
/** \brief APBusClk_CDMA ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_CDMACONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_SQU ClkGen Configuration Register (APBusClk_SQUConfig_ClkGenConfig)
/** \brief APBusClk_SQU ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_SQU ClkGen Status Register (APBusClk_SQUConfig_ClkGenStatus)
/** \brief APBusClk_SQU ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SQUCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_IOWrap ClkGen Configuration Register (APBusClk_IOWrapConfig_ClkGenConfig)
/** \brief APBusClk_IOWrap ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_IOWrap ClkGen Status Register (APBusClk_IOWrapConfig_ClkGenStatus)
/** \brief APBusClk_IOWrap ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_IOWRAPCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_LAN ClkGen Configuration Register (APBusClk_LANConfig_ClkGenConfig)
/** \brief APBusClk_LAN ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_LAN ClkGen Status Register (APBusClk_LANConfig_ClkGenStatus)
/** \brief APBusClk_LAN ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_LANCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_USB2A ClkGen Configuration Register (APBusClk_USB2AConfig_ClkGenConfig)
/** \brief APBusClk_USB2A ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_USB2A ClkGen Status Register (APBusClk_USB2AConfig_ClkGenStatus)
/** \brief APBusClk_USB2A ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2ACONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_USB2PHY ClkGen Configuration Register (APBusClk_USB2PHYConfig_ClkGenConfig)
/** \brief APBusClk_USB2PHY ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_USB2PHY ClkGen Status Register (APBusClk_USB2PHYConfig_ClkGenStatus)
/** \brief APBusClk_USB2PHY ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB2PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_USB3D ClkGen Configuration Register (APBusClk_USB3DConfig_ClkGenConfig)
/** \brief APBusClk_USB3D ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_USB3D ClkGen Status Register (APBusClk_USB3DConfig_ClkGenStatus)
/** \brief APBusClk_USB3D ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3DCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_USB3H ClkGen Configuration Register (APBusClk_USB3HConfig_ClkGenConfig)
/** \brief APBusClk_USB3H ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_USB3H ClkGen Status Register (APBusClk_USB3HConfig_ClkGenStatus)
/** \brief APBusClk_USB3H ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3HCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_USB3PHY ClkGen Configuration Register (APBusClk_USB3PHYConfig_ClkGenConfig)
/** \brief APBusClk_USB3PHY ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_USB3PHY ClkGen Status Register (APBusClk_USB3PHYConfig_ClkGenStatus)
/** \brief APBusClk_USB3PHY ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_USB3PHYCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_PCIe_DM2 ClkGen Configuration Register (APBusClk_PCIe_DM2Config_ClkGenConfig)
/** \brief APBusClk_PCIe_DM2 ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_PCIe_DM2 ClkGen Status Register (APBusClk_PCIe_DM2Config_ClkGenStatus)
/** \brief APBusClk_PCIe_DM2 ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM2CONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_PCIe_DM4 ClkGen Configuration Register (APBusClk_PCIe_DM4Config_ClkGenConfig)
/** \brief APBusClk_PCIe_DM4 ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: APBusClk_PCIe_DM4 ClkGen Status Register (APBusClk_PCIe_DM4Config_ClkGenStatus)
/** \brief APBusClk_PCIe_DM4 ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_PCIE_DM4CONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: APBusClk_SATA ClkGen Configuration Register (APBusClk_SATAConfig_ClkGenConfig)
/** \brief APBusClk_SATA ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: APBusClk_SATA ClkGen Status Register (APBusClk_SATAConfig_ClkGenStatus)
/** \brief APBusClk_SATA ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_SATACONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: APBusClk_GPU ClkGen Configuration Register (APBusClk_GPUConfig_ClkGenConfig)
/** \brief APBusClk_GPU ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: APBusClk_GPU ClkGen Status Register (APBusClk_GPUConfig_ClkGenStatus)
/** \brief APBusClk_GPU ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APBUSCLK_GPUCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: SMMUClk ClkGen Configuration Register (SMMUClkConfig_ClkGenConfig)
/** \brief SMMUClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: SMMUClk ClkGen Status Register (SMMUClkConfig_ClkGenStatus)
/** \brief SMMUClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xe00000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 21
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe000
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 13
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SMMUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: GPUBusClk ClkGen Configuration Register (GPUBusClkConfig_ClkGenConfig)
/** \brief GPUBusClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: GPUBusClk ClkGen Status Register (GPUBusClkConfig_ClkGenStatus)
/** \brief GPUBusClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUBUSCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: GPUClk ClkGen Configuration Register (GPUClkConfig_ClkGenConfig)
/** \brief GPUClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENCONFIG_RSTN_SHIFT))

//====================================================================
//Register: GPUClk ClkGen Status Register (GPUClkConfig_ClkGenStatus)
/** \brief GPUClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) >> APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_GPUCLKCONFIG_CLKGENSTATUS_RSTN_SHIFT))

//====================================================================
//Register: SDMMCClk ClkGen Configuration Register (SDMMCClkConfig_ClkGenConfig)
/** \brief SDMMCClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xf00000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 20
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xf000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 12
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: SDMMCClk ClkGen Status Register (SDMMCClkConfig_ClkGenStatus)
/** \brief SDMMCClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xf00000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 20
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0xf0000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xf000
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 12
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0xf00
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_SDMMCCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: QSPIClk ClkGen Configuration Register (QSPIClkConfig_ClkGenConfig)
/** \brief QSPIClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: QSPIClk ClkGen Status Register (QSPIClkConfig_ClkGenStatus)
/** \brief QSPIClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_QSPICLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: LCDXClk ClkGen Configuration Register (LCDXClkConfig_ClkGenConfig)
/** \brief LCDXClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: LCDXClk ClkGen Status Register (LCDXClkConfig_ClkGenStatus)
/** \brief LCDXClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xe00000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 21
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe000
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 13
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDXCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: LCD Clock Configuration Register (LCDClkConfig)
/** \brief LCD Clock Controls.*/
//====================================================================

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: LCD Clock Status Register (LCDClkStatus)
/** \brief LCD Clock Status Register. Note that this clock is derived from the LCDXCLK. The
      read-only fields for PreDiv, Divider count values, and such come from the LCDXCLK
      control register. The ratio select field comes from a control register in the
      LCD block itself.*/
//====================================================================

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_MASK 0x6000000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_SHIFT 25
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_RATIOSEL_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_MASK 0xe00000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_SHIFT 21
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_MASK 0xe000
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_SHIFT 13
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_MASK 0x1
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_SHIFT 0
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LCDCLKSTATUS_RESERVED3_SHIFT))

//====================================================================
//Register: UART0Clk ClkGen Configuration Register (UART0ClkConfig_ClkGenConfig)
/** \brief UART0Clk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 26
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 18
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 10
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: UART0Clk ClkGen Status Register (UART0ClkConfig_ClkGenStatus)
/** \brief UART0Clk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 26
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 18
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 10
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: UART0 Clock Fractional Divider Configuration Register (UART0ClkFracDivCfg)
/** \brief This register is used to configure the UART0 clock generator's fractional divider.*/
//====================================================================

#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_MASK 0xffff0000
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_SHIFT 16
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_MASK) >> APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_NUMERATOR_SHIFT))

#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_MASK 0xffff
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_SHIFT 0
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_MASK) >> APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART0CLKFRACDIVCFG_DENOMINATOR_SHIFT))

//====================================================================
//Register: UART1Clk ClkGen Configuration Register (UART1ClkConfig_ClkGenConfig)
/** \brief UART1Clk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 26
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 18
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 10
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: UART1Clk ClkGen Status Register (UART1ClkConfig_ClkGenStatus)
/** \brief UART1Clk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 26
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 18
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 10
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: UART1 Clock Fractional Divider Configuration Register (UART1ClkFracDivCfg)
/** \brief This register is used to configure the UART1 clock generator's fractional divider.*/
//====================================================================

#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_MASK 0xffff0000
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_SHIFT 16
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_MASK) >> APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_NUMERATOR_SHIFT))

#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_MASK 0xffff
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_SHIFT 0
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_MASK) >> APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART1CLKFRACDIVCFG_DENOMINATOR_SHIFT))

//====================================================================
//Register: UART2Clk ClkGen Configuration Register (UART2ClkConfig_ClkGenConfig)
/** \brief UART2Clk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 26
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 18
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 10
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: UART2Clk ClkGen Status Register (UART2ClkConfig_ClkGenStatus)
/** \brief UART2Clk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 26
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 18
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 10
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: UART2 Clock Fractional Divider Configuration Register (UART2ClkFracDivCfg)
/** \brief This register is used to configure the UART2 clock generator's fractional divider.*/
//====================================================================

#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_MASK 0xffff0000
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_SHIFT 16
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_MASK) >> APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_NUMERATOR_SHIFT))

#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_MASK 0xffff
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_SHIFT 0
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_MASK) >> APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART2CLKFRACDIVCFG_DENOMINATOR_SHIFT))

//====================================================================
//Register: UART3Clk ClkGen Configuration Register (UART3ClkConfig_ClkGenConfig)
/** \brief UART3Clk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 26
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 18
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 10
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

//====================================================================
//Register: UART3Clk ClkGen Status Register (UART3ClkConfig_ClkGenStatus)
/** \brief UART3Clk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x4000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 26
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x3000000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xfc0000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 18
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x30000
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xfc00
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 10
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x300
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: UART3 Clock Fractional Divider Configuration Register (UART3ClkFracDivCfg)
/** \brief This register is used to configure the UART3 clock generator's fractional divider.*/
//====================================================================

#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_MASK 0xffff0000
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_SHIFT 16
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_MASK) >> APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_NUMERATOR_SHIFT))

#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_MASK 0xffff
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_SHIFT 0
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_MASK) >> APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_SHIFT)
#define  APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_UART3CLKFRACDIVCFG_DENOMINATOR_SHIFT))

//====================================================================
//Register: LAN Mac 2x Clock Configuration Register (LANMacClk2xConfig)
/** \brief LAN MAC 2x Clock Configuration Register. Note that the LAN MAC clock will always
      run at half the frequency that is programmed for this clock.*/
//====================================================================

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_MASK 0x3e000000
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_MASK 0x1000000
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_SHIFT 24
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_SRCFREQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_MASK 0xffff80
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_SHIFT 7
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_MASK 0x4
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_SHIFT 2
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XCONFIG_RESERVED4_SHIFT))

//====================================================================
//Register: LAN Mac 2x Clock Status Register (LANMacClk2xStatus)
/** \brief LAN MAC 2x Clock Status Register. Note that the LAN MAC clock will always
      run at half the frequency that is programmed for this clock.*/
//====================================================================

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_MASK 0x1000000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_SHIFT 24
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_SRCFREQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_MASK 0xc00000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_SHIFT 22
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_MASK 0x3f0000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_MASK 0xc000
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_SHIFT 14
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_MASK 0x3f00
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_MASK 0x1
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_SHIFT 0
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANMACCLK2XSTATUS_RESERVED4_SHIFT))

//====================================================================
//Register: ClkGen Configuration Register (LANRxClkGenConfig)
/** \brief PMU ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_MASK 0xff0000
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_SHIFT 16
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_MASK 0xff00
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_SHIFT 8
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_MASK 0x4
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_SHIFT 2
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: ClkGen Status Register (LANRxClkGenStatus)
/** \brief PMU ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_MASK 0xff0000
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_SHIFT 16
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_MASK 0xff00
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_SHIFT 8
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_LANRXCLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: AP CPU Miscellaneous Control Register (APCPUMiscControl)
/** \brief The bits in this register are used to control the resets going to the AP CPU subsystem.*/
//====================================================================

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK 0xf0000000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT 28
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK 0xf000000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT 24
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUFIQ_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK 0xf00000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT 20
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NMASKCPUIRQ_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK 0x80000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT 19
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK 0x40000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT 18
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUAT_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK 0x20000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT 17
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_CPUL2RSTDISABLE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK 0x10000
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT 16
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUL2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK 0xff00
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT 8
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK 0xf0
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT 4
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPU_SHIFT))

#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK 0xf
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT 0
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK) >> APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT)
#define  APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUMISCCONTROL_NRSTCPUPOR_SHIFT))

//====================================================================
//Register: AP CPU Clock Control Register (APCPUClkControl)
/** \brief The bits in this register are fed to the CPU sub-systems clock gen block.*/
//====================================================================

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_MASK 0xe0000000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_SHIFT 29
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_MASK 0x10000000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_SHIFT 28
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_ACPINACTIVE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_MASK 0x8000000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_SHIFT 27
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLK_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_MASK 0x4000000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_SHIFT 26
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_L2RAMDUMMYCLKSEL_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_MASK 0x2000000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_SHIFT 25
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_L2FLUSHREQ_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_MASK 0x1f00000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_SHIFT 20
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_PCLKENDBG_DIV_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_MASK 0x80000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_SHIFT 19
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_MASK 0x70000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_SHIFT 16
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_ATCLKEN_DIV_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_MASK 0x8000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_SHIFT 15
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_MASK 0x7000
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_SHIFT 12
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_PERIPHCLK_DIV_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_MASK 0x800
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_SHIFT 11
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_MASK 0x700
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_SHIFT 8
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_ACLKENM_DIV_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_MASK 0x80
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_SHIFT 7
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_MASK 0x70
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_SHIFT 4
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_COREAPCKL_DIV_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_MASK 0xc
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_SHIFT 2
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_CORECLK_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_MASK 0x2
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_SHIFT 1
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_MASK 0x1
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_SHIFT 0
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_MASK) >> APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKCONTROL_CPUCLKGEN_STOP_SHIFT))

//====================================================================
//Register: AP CPU Clocks Status Register (APCPUClkStatus)
/** \brief Various CPU clock status fields.*/
//====================================================================

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_MASK 0xfc000000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_SHIFT 26
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_MASK 0x2000000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_SHIFT 25
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_L2FLUSHDONE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_MASK 0x1000000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_SHIFT 24
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_L2QACTIVE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_MASK 0xf00000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_SHIFT 20
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_DBGNOPWRDOWN_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_MASK 0xf0000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_SHIFT 16
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUSMPEN_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_MASK 0xf000
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_SHIFT 12
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_CPUQACTIVE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_MASK 0xf00
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_SHIFT 8
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_MASK 0xf0
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_SHIFT 4
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_STANDBYWFI_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_MASK 0x8
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_SHIFT 3
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_L2STANDBYWFI_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_MASK 0x4
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_SHIFT 2
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_MASK 0x2
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_SHIFT 1
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKGENIDLE_SHIFT))

#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_MASK 0x1
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_SHIFT 0
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_MASK) >> APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_SHIFT)
#define  APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_APCPUCLKSTATUS_CLKCHANGE_SHIFT))

//====================================================================
//Register: R4 CPU Clocks Status Register (R4ClkStatus)
/** \brief R4 clock status.*/
//====================================================================

#define  APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_MASK 0xfffffffe
#define  APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_SHIFT 1
#define  APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_R4CLKSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_MASK 0x1
#define  APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_SHIFT 0
#define  APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_MASK) >> APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_SHIFT)
#define  APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_R4CLKSTATUS_STANDBYWFI_SHIFT))

//====================================================================
//Register: PCIe Reset Control (PCIeRstCtl)
//====================================================================

#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK 0xfffffffc
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT 2
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK 0x2
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT 1
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM2_RSTN_SHIFT))

#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK 0x1
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT 0
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK) >> APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT)
#define  APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_PCIERSTCTL_PCIE_DM4_RSTN_SHIFT))

//====================================================================
//Register: BCMClk ClkGen Configuration Register (BCMClkConfig_ClkGenConfig)
/** \brief BCMClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK 0x80000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT 31
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACKOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK 0x40000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT 30
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_ACTIVEOVERRIDE_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0x38000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x7ffff00
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 8
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0x80
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 7
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK 0x40
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT 6
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKONREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK 0x20
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT 5
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKOFFREQIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK 0x10
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT 4
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQDENIEDIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK 0x8
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT 3
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_LPREQSUCCESSIRQEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0x4
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 2
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0x1
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 0
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

//====================================================================
//Register: BCMClk ClkGen Status Register (BCMClkConfig_ClkGenStatus)
/** \brief BCMClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK 0x80
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT 7
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKGATED_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK 0x40
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT 6
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKONREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK 0x20
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT 5
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKOFFREQIRQ_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK 0x10
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT 4
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQDENIEDIRQ_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK 0x8
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT 3
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_LPREQSUCCESSIRQ_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x4
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 2
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_MASK 0x2
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT 1
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_CLKEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//Register: BCMCPUClk ClkGen Configuration Register (BCMCPUClkConfig_ClkGenConfig)
/** \brief BCMCPUClk ClkGen Configuration Register*/
//====================================================================

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK 0xf8000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT 27
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK 0x6000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT 25
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK 0xe00000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT 21
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK 0xe000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT 13
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK 0xf8
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT 3
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK 0x2
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT 1
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED6_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK 0x1
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT 0
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENCONFIG_RESERVED7_SHIFT))

//====================================================================
//Register: BCMCPUClk ClkGen Status Register (BCMCPUClkConfig_ClkGenStatus)
/** \brief BCMCPUClk ClkGen Status Register*/
//====================================================================

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK 0xf8000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT 27
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK 0x6000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT 25
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED1_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK 0x1000000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT 24
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_SRCSEL_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK 0xe00000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT 21
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED2_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK 0x1f0000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT 16
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_HIDIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK 0xe000
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT 13
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED3_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK 0x1f00
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT 8
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_LODIV_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK 0xf8
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT 3
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED4_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK 0x4
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT 2
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_PREDIVEN_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK 0x2
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT 1
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED5_SHIFT))

#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK 0x1
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT 0
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK_SHIFT(reg) (((reg) & APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) >> APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT)
#define  APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_MASK) | (((uint32_t)val) << APMU_CLKRSTGEN_BCMCPUCLKCONFIG_CLKGENSTATUS_RESERVED6_SHIFT))

//====================================================================
//
//Register File: APMU Timer Control Registers (APMU_timers)
/** \brief The APB TIMERS block provides programmable interval timers and watchdog. <BR>
The interval timers can be used to generate a repetitive period timer (for the RTO/S periodic tick interrupt), to time intervals (for switch presses, LED flashing, or fan speed), or for a watchdog reset. <BR>
Four identical programmable timers (Timer0, Timer1, Timer2, Timer3) are provided in the APB subsystem. Each timer generates a level interrupt when it reaches the final event, which can be programmed to be either a terminal count or an input pulse (on an external signal). When the final event is reached, the counter can restart at zero (continuous mode) or halt, depending on how it is configured. <BR>
Timer0 provides the watchdog function, and when enabled, the system will be reset if the watchdog timer reaches the final event. <BR>
The timer count is incremented on a selected input timebase. There are 8 choices of input timebases to select from: 1us, 10us, 100us, 1ms, 10ms and 100ms, the bus clock, and external input signal pulses. <BR>
To facilitate interval timing, the counter may be disabled to lock the count value that can then be read via the Timer Status Register. The counter is reset to zero and begins to increment when the Timer is re-enabled. <BR>
To assist system level functions, each timer can generate a signal that toggles when the final count is reached. The toggling signal is a periodic waveform that can be used within the SoC or be connected to the pins for further use by the system. <BR>*/
//
//====================================================================

//====================================================================
//Register: Timer0 Watchdog Register (TWR0)
/** \brief When Watchdog Mode is enabled, this register must be serviced properly or the system will reset. This is useful to automatically reboot a malfunctioning system. This register must be correctly serviced before timer0 reaches the terminal event (see Control register bit[2]), which can be a terminal count (see Terminal Count register) or pulse. Also, if improperly serviced, the system will also immediately reset (if Watchdog Mode is enabled). In addition, when you write this register to disable the watchdog (Enable bit zero), it must be correctly serviced or a system reset will be generated (this is to prevent a malfunctioning system from accidentally disabling the watchdog).<BR>
            The correct method of servicing the watchdog is to read the register value, then write back the value with the lower four bits inverted (XOR with 0x0000000f). The register read value cycles in a pseudo-random pattern.<BR>
            Attention: the Timer0 Control Register must be placed in Continuous mode (TCR0.Mode=1) for the watchdog timeout and reset to properly function. When Timer0 is placed in non-continuous mode, the watchdog reset function is de-activated even if the watchdog mode is enabled (TWR0.Enable=1).*/
//====================================================================

#define  APMU_TIMERS_TWR0_ENABLE_MASK 0x80000000
#define  APMU_TIMERS_TWR0_ENABLE_SHIFT 31
#define  APMU_TIMERS_TWR0_ENABLE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TWR0_ENABLE_MASK) >> APMU_TIMERS_TWR0_ENABLE_SHIFT)
#define  APMU_TIMERS_TWR0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TWR0_ENABLE_MASK) | (((uint32_t)val) << APMU_TIMERS_TWR0_ENABLE_SHIFT))

#define  APMU_TIMERS_TWR0_RESERVED1_MASK 0x7ffffff0
#define  APMU_TIMERS_TWR0_RESERVED1_SHIFT 4
#define  APMU_TIMERS_TWR0_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TWR0_RESERVED1_MASK) >> APMU_TIMERS_TWR0_RESERVED1_SHIFT)
#define  APMU_TIMERS_TWR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TWR0_RESERVED1_MASK) | (((uint32_t)val) << APMU_TIMERS_TWR0_RESERVED1_SHIFT))

#define  APMU_TIMERS_TWR0_SERVICE_MASK 0xf
#define  APMU_TIMERS_TWR0_SERVICE_SHIFT 0
#define  APMU_TIMERS_TWR0_SERVICE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TWR0_SERVICE_MASK) >> APMU_TIMERS_TWR0_SERVICE_SHIFT)
#define  APMU_TIMERS_TWR0_SERVICE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TWR0_SERVICE_MASK) | (((uint32_t)val) << APMU_TIMERS_TWR0_SERVICE_SHIFT))

//====================================================================
//Register: Timers Interrupt Status Register (TISR)
/** \brief This register provides the raw interrupt status. The TimerIRQ[3:0] interrupt request lines are passed to an Interrupt Controller. The TimerIRQ lines are individually maskable using the Interrupt Controller's Interrupt Enable Register.*/
//====================================================================

#define  APMU_TIMERS_TISR_RESERVED1_MASK 0xfffffff0
#define  APMU_TIMERS_TISR_RESERVED1_SHIFT 4
#define  APMU_TIMERS_TISR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TISR_RESERVED1_MASK) >> APMU_TIMERS_TISR_RESERVED1_SHIFT)
#define  APMU_TIMERS_TISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TISR_RESERVED1_MASK) | (((uint32_t)val) << APMU_TIMERS_TISR_RESERVED1_SHIFT))

#define  APMU_TIMERS_TISR_STATUS3_MASK 0x8
#define  APMU_TIMERS_TISR_STATUS3_SHIFT 3
#define  APMU_TIMERS_TISR_STATUS3_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TISR_STATUS3_MASK) >> APMU_TIMERS_TISR_STATUS3_SHIFT)
#define  APMU_TIMERS_TISR_STATUS3_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TISR_STATUS3_MASK) | (((uint32_t)val) << APMU_TIMERS_TISR_STATUS3_SHIFT))

#define  APMU_TIMERS_TISR_STATUS2_MASK 0x4
#define  APMU_TIMERS_TISR_STATUS2_SHIFT 2
#define  APMU_TIMERS_TISR_STATUS2_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TISR_STATUS2_MASK) >> APMU_TIMERS_TISR_STATUS2_SHIFT)
#define  APMU_TIMERS_TISR_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TISR_STATUS2_MASK) | (((uint32_t)val) << APMU_TIMERS_TISR_STATUS2_SHIFT))

#define  APMU_TIMERS_TISR_STATUS1_MASK 0x2
#define  APMU_TIMERS_TISR_STATUS1_SHIFT 1
#define  APMU_TIMERS_TISR_STATUS1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TISR_STATUS1_MASK) >> APMU_TIMERS_TISR_STATUS1_SHIFT)
#define  APMU_TIMERS_TISR_STATUS1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TISR_STATUS1_MASK) | (((uint32_t)val) << APMU_TIMERS_TISR_STATUS1_SHIFT))

#define  APMU_TIMERS_TISR_STATUS0_MASK 0x1
#define  APMU_TIMERS_TISR_STATUS0_SHIFT 0
#define  APMU_TIMERS_TISR_STATUS0_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TISR_STATUS0_MASK) >> APMU_TIMERS_TISR_STATUS0_SHIFT)
#define  APMU_TIMERS_TISR_STATUS0_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TISR_STATUS0_MASK) | (((uint32_t)val) << APMU_TIMERS_TISR_STATUS0_SHIFT))

//====================================================================
//Register: Timers Interrupt Acknowledge Register (TIAR)
/** \brief This register is written to acknowledge and clear the TimerIRQs.*/
//====================================================================

#define  APMU_TIMERS_TIAR_RESERVED1_MASK 0xfffffff0
#define  APMU_TIMERS_TIAR_RESERVED1_SHIFT 4
#define  APMU_TIMERS_TIAR_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TIAR_RESERVED1_MASK) >> APMU_TIMERS_TIAR_RESERVED1_SHIFT)
#define  APMU_TIMERS_TIAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TIAR_RESERVED1_MASK) | (((uint32_t)val) << APMU_TIMERS_TIAR_RESERVED1_SHIFT))

#define  APMU_TIMERS_TIAR_ACK3_MASK 0x8
#define  APMU_TIMERS_TIAR_ACK3_SHIFT 3
#define  APMU_TIMERS_TIAR_ACK3_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TIAR_ACK3_MASK) >> APMU_TIMERS_TIAR_ACK3_SHIFT)
#define  APMU_TIMERS_TIAR_ACK3_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TIAR_ACK3_MASK) | (((uint32_t)val) << APMU_TIMERS_TIAR_ACK3_SHIFT))

#define  APMU_TIMERS_TIAR_ACK2_MASK 0x4
#define  APMU_TIMERS_TIAR_ACK2_SHIFT 2
#define  APMU_TIMERS_TIAR_ACK2_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TIAR_ACK2_MASK) >> APMU_TIMERS_TIAR_ACK2_SHIFT)
#define  APMU_TIMERS_TIAR_ACK2_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TIAR_ACK2_MASK) | (((uint32_t)val) << APMU_TIMERS_TIAR_ACK2_SHIFT))

#define  APMU_TIMERS_TIAR_ACK1_MASK 0x2
#define  APMU_TIMERS_TIAR_ACK1_SHIFT 1
#define  APMU_TIMERS_TIAR_ACK1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TIAR_ACK1_MASK) >> APMU_TIMERS_TIAR_ACK1_SHIFT)
#define  APMU_TIMERS_TIAR_ACK1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TIAR_ACK1_MASK) | (((uint32_t)val) << APMU_TIMERS_TIAR_ACK1_SHIFT))

#define  APMU_TIMERS_TIAR_ACK0_MASK 0x1
#define  APMU_TIMERS_TIAR_ACK0_SHIFT 0
#define  APMU_TIMERS_TIAR_ACK0_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TIAR_ACK0_MASK) >> APMU_TIMERS_TIAR_ACK0_SHIFT)
#define  APMU_TIMERS_TIAR_ACK0_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TIAR_ACK0_MASK) | (((uint32_t)val) << APMU_TIMERS_TIAR_ACK0_SHIFT))

//====================================================================
//Register: Timer0 Terminal Count Register (TTCR0)
/** \brief This register sets the final count where the interrupt is generated. For Continuous mode the counter will reset to zero on the next timebase period; otherwise, the counter will stop at the terminal count (programmed in this register) in terminal count mode (Control register bit[2]=0) or at the current count in terminal pulse mode (Control bit[2]=1).*/
//====================================================================

#define  APMU_TIMERS_TTCR0_TERMINALCOUNT_MASK 0xffffffff
#define  APMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT 0
#define  APMU_TIMERS_TTCR0_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TTCR0_TERMINALCOUNT_MASK) >> APMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT)
#define  APMU_TIMERS_TTCR0_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TTCR0_TERMINALCOUNT_MASK) | (((uint32_t)val) << APMU_TIMERS_TTCR0_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer0 Control Register (TCR0)
/** \brief The control register is used to configure the operation of the timer. The timer count is reset when the counter is enabled (Enable bit changes from 0 to 1). When in continuous mode (see bit[1]), the counter will reset and continue after reaching the terminal event, otherwise the timer stops when reaching the terminal event. The Terminal event (see bit[2]) can be a pulse on the external input signal or a pre-programmed count. <BR>
            The timer counter may be disabled (write Enable bit to 0 after it was originally enabled) to lock the count value. The resulting count value can be read from the Timer Status Register.*/
//====================================================================

#define  APMU_TIMERS_TCR0_RESERVED1_MASK 0xffffff80
#define  APMU_TIMERS_TCR0_RESERVED1_SHIFT 7
#define  APMU_TIMERS_TCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_RESERVED1_MASK) >> APMU_TIMERS_TCR0_RESERVED1_SHIFT)
#define  APMU_TIMERS_TCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_RESERVED1_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_RESERVED1_SHIFT))

#define  APMU_TIMERS_TCR0_TIMEBASESEL_MASK 0x70
#define  APMU_TIMERS_TCR0_TIMEBASESEL_SHIFT 4
#define  APMU_TIMERS_TCR0_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_TIMEBASESEL_MASK) >> APMU_TIMERS_TCR0_TIMEBASESEL_SHIFT)
#define  APMU_TIMERS_TCR0_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_TIMEBASESEL_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_TIMEBASESEL_SHIFT))

#define  APMU_TIMERS_TCR0_POLARITY_MASK 0x8
#define  APMU_TIMERS_TCR0_POLARITY_SHIFT 3
#define  APMU_TIMERS_TCR0_POLARITY_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_POLARITY_MASK) >> APMU_TIMERS_TCR0_POLARITY_SHIFT)
#define  APMU_TIMERS_TCR0_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_POLARITY_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_POLARITY_SHIFT))

#define  APMU_TIMERS_TCR0_TERMINALMODE_MASK 0x4
#define  APMU_TIMERS_TCR0_TERMINALMODE_SHIFT 2
#define  APMU_TIMERS_TCR0_TERMINALMODE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_TERMINALMODE_MASK) >> APMU_TIMERS_TCR0_TERMINALMODE_SHIFT)
#define  APMU_TIMERS_TCR0_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_TERMINALMODE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_TERMINALMODE_SHIFT))

#define  APMU_TIMERS_TCR0_CONTMODE_MASK 0x2
#define  APMU_TIMERS_TCR0_CONTMODE_SHIFT 1
#define  APMU_TIMERS_TCR0_CONTMODE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_CONTMODE_MASK) >> APMU_TIMERS_TCR0_CONTMODE_SHIFT)
#define  APMU_TIMERS_TCR0_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_CONTMODE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_CONTMODE_SHIFT))

#define  APMU_TIMERS_TCR0_ENABLE_MASK 0x1
#define  APMU_TIMERS_TCR0_ENABLE_SHIFT 0
#define  APMU_TIMERS_TCR0_ENABLE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR0_ENABLE_MASK) >> APMU_TIMERS_TCR0_ENABLE_SHIFT)
#define  APMU_TIMERS_TCR0_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR0_ENABLE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR0_ENABLE_SHIFT))

//====================================================================
//Register: Timer0 Status Register (TSR0)
/** \brief The Status register returns the current timer count value, which updates on each timebase tick (selected by Control Timebase Input Select bits), as long the timer is enabled (Control.Enable=1).<BR>
            When the timer has been enabled and is counting, the timer counter may be disabled (write Control.Enable bit to 0) and the counter locks the current value, so that firmware can read the current count. NOTE - when the timer is re-enabled (write Enable bit to 1), the count value is reset to zero.<BR>
            If firmware wishes to obtain a reliable count value without having to disable the timer, firmware can rely on the TimerIRQ to indicate that the final count is reached. Alternatively, firmware can do two consecutive reads of the Status register, and two identical consecutive readings means that the count value is valid because it has not updated since the last timebase tick. For these two methods to work, be sure to set the Control.Enable bit to 1, and the Control.ContinuousMode bit to 0 (stop when reach terminal event).<BR>
            When the timer is configured to stop counting when reaching a terminal pulse event (Control.ContMode bit is 0, and Control.TerminalMode bit is 1), this registers returns the elapsed time between two consecutive pulses. The TimerIRQ interrupt indicates when the final count is ready to read from this register. This functional mode is useful, for example, for measuring the external fan speed. The count is directly related to the fan rpm's.*/
//====================================================================

#define  APMU_TIMERS_TSR0_COUNT_MASK 0xffffffff
#define  APMU_TIMERS_TSR0_COUNT_SHIFT 0
#define  APMU_TIMERS_TSR0_COUNT_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TSR0_COUNT_MASK) >> APMU_TIMERS_TSR0_COUNT_SHIFT)
#define  APMU_TIMERS_TSR0_COUNT_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TSR0_COUNT_MASK) | (((uint32_t)val) << APMU_TIMERS_TSR0_COUNT_SHIFT))

//====================================================================
//Register: Timer1 Terminal Count Register (TTCR1)
/** \brief See description for Timer0 Terminal Count Register.*/
//====================================================================

#define  APMU_TIMERS_TTCR1_TERMINALCOUNT_MASK 0xffffffff
#define  APMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT 0
#define  APMU_TIMERS_TTCR1_TERMINALCOUNT_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TTCR1_TERMINALCOUNT_MASK) >> APMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT)
#define  APMU_TIMERS_TTCR1_TERMINALCOUNT_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TTCR1_TERMINALCOUNT_MASK) | (((uint32_t)val) << APMU_TIMERS_TTCR1_TERMINALCOUNT_SHIFT))

//====================================================================
//Register: Timer1 Control Register (TCR1)
/** \brief See description for Timer0 Control Register.*/
//====================================================================

#define  APMU_TIMERS_TCR1_RESERVED1_MASK 0xffffff80
#define  APMU_TIMERS_TCR1_RESERVED1_SHIFT 7
#define  APMU_TIMERS_TCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_RESERVED1_MASK) >> APMU_TIMERS_TCR1_RESERVED1_SHIFT)
#define  APMU_TIMERS_TCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_RESERVED1_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_RESERVED1_SHIFT))

#define  APMU_TIMERS_TCR1_TIMEBASESEL_MASK 0x70
#define  APMU_TIMERS_TCR1_TIMEBASESEL_SHIFT 4
#define  APMU_TIMERS_TCR1_TIMEBASESEL_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_TIMEBASESEL_MASK) >> APMU_TIMERS_TCR1_TIMEBASESEL_SHIFT)
#define  APMU_TIMERS_TCR1_TIMEBASESEL_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_TIMEBASESEL_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_TIMEBASESEL_SHIFT))

#define  APMU_TIMERS_TCR1_POLARITY_MASK 0x8
#define  APMU_TIMERS_TCR1_POLARITY_SHIFT 3
#define  APMU_TIMERS_TCR1_POLARITY_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_POLARITY_MASK) >> APMU_TIMERS_TCR1_POLARITY_SHIFT)
#define  APMU_TIMERS_TCR1_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_POLARITY_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_POLARITY_SHIFT))

#define  APMU_TIMERS_TCR1_TERMINALMODE_MASK 0x4
#define  APMU_TIMERS_TCR1_TERMINALMODE_SHIFT 2
#define  APMU_TIMERS_TCR1_TERMINALMODE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_TERMINALMODE_MASK) >> APMU_TIMERS_TCR1_TERMINALMODE_SHIFT)
#define  APMU_TIMERS_TCR1_TERMINALMODE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_TERMINALMODE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_TERMINALMODE_SHIFT))

#define  APMU_TIMERS_TCR1_CONTMODE_MASK 0x2
#define  APMU_TIMERS_TCR1_CONTMODE_SHIFT 1
#define  APMU_TIMERS_TCR1_CONTMODE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_CONTMODE_MASK) >> APMU_TIMERS_TCR1_CONTMODE_SHIFT)
#define  APMU_TIMERS_TCR1_CONTMODE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_CONTMODE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_CONTMODE_SHIFT))

#define  APMU_TIMERS_TCR1_ENABLE_MASK 0x1
#define  APMU_TIMERS_TCR1_ENABLE_SHIFT 0
#define  APMU_TIMERS_TCR1_ENABLE_MASK_SHIFT(reg) (((reg) & APMU_TIMERS_TCR1_ENABLE_MASK) >> APMU_TIMERS_TCR1_ENABLE_SHIFT)
#define  APMU_TIMERS_TCR1_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~APMU_TIMERS_TCR1_ENABLE_MASK) | (((uint32_t)val) << APMU_TIMERS_TCR1_ENABLE_SHIFT))

//====================================================================
//Register: Timer1 Status Register (TSR1)
/** \brief See descripti