 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ANTIFLIN_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ANTIFLIN_REGSTRUCTS_H_
#define _ANTIFLIN_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: ANTIFLIN (ANTIFLIN)
/** \brief Register descriptions for the ANTIFLIN block.
    (rev 0 . 0 . 5 . 0)*/
//
//====================================================================

typedef struct ANTIFLIN_REGS_s
{
  volatile uint32_t Control;  ///< 0x0 [R/W]: Control
  volatile uint32_t C1;  ///< 0x4 [R/W]: Channel 1
  volatile uint32_t C2;  ///< 0x8 [R/W]: Channel 2
  volatile uint32_t C3;  ///< 0xc [R/W]: Channel 3
  volatile uint32_t RAR;  ///< 0x10 [R/W]: RAM Access Control Register
  volatile uint32_t RAWR;  ///< 0x14 [W]: RAM Address Write Register
  volatile uint32_t RASR;  ///< 0x18 [R]: RAM Address Status Register
  volatile uint32_t RDWR;  ///< 0x1c [W]: RAM Data Write Register
  volatile uint32_t RDRR;  ///< 0x20 [R]: RAM Data Read Register
  volatile uint32_t debug_ch0;  ///< 0x24 [R]: ANTIFLIN channel 0 Debug Register
  volatile uint32_t debug_ch1;  ///< 0x28 [R]: ANTIFLIN channel 1 Debug Register
  volatile uint32_t debug_ch2;  ///< 0x2c [R]: ANTIFLIN channel 2 Debug Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} ANTIFLIN_REGS_t;

#endif // ANTIFLIN
