 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ANTIFLIN_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ANTIFLIN_REGMASKS_H_
#define _ANTIFLIN_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: ANTIFLIN (ANTIFLIN)
/** \brief Register descriptions for the ANTIFLIN block.
    (rev 0 . 0 . 5 . 0)*/
//
//====================================================================

//====================================================================
//Register: Control (Control)
//====================================================================

#define  ANTIFLIN_CONTROL_RESERVED1_MASK 0xfffffff8
#define  ANTIFLIN_CONTROL_RESERVED1_SHIFT 3
#define  ANTIFLIN_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_RESERVED1_MASK) >> ANTIFLIN_CONTROL_RESERVED1_SHIFT)
#define  ANTIFLIN_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_RESERVED1_SHIFT))

#define  ANTIFLIN_CONTROL_RAMACCESS_MASK 0x4
#define  ANTIFLIN_CONTROL_RAMACCESS_SHIFT 2
#define  ANTIFLIN_CONTROL_RAMACCESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_RAMACCESS_MASK) >> ANTIFLIN_CONTROL_RAMACCESS_SHIFT)
#define  ANTIFLIN_CONTROL_RAMACCESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_RAMACCESS_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_RAMACCESS_SHIFT))

#define  ANTIFLIN_CONTROL_PSENABLE_MASK 0x2
#define  ANTIFLIN_CONTROL_PSENABLE_SHIFT 1
#define  ANTIFLIN_CONTROL_PSENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_PSENABLE_MASK) >> ANTIFLIN_CONTROL_PSENABLE_SHIFT)
#define  ANTIFLIN_CONTROL_PSENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_PSENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_PSENABLE_SHIFT))

#define  ANTIFLIN_CONTROL_BYPASS_MASK 0x1
#define  ANTIFLIN_CONTROL_BYPASS_SHIFT 0
#define  ANTIFLIN_CONTROL_BYPASS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_BYPASS_MASK) >> ANTIFLIN_CONTROL_BYPASS_SHIFT)
#define  ANTIFLIN_CONTROL_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_BYPASS_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_BYPASS_SHIFT))

//====================================================================
//Register: Channel 1 (C1)
//====================================================================

#define  ANTIFLIN_C1_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C1_RESERVED1_SHIFT 31
#define  ANTIFLIN_C1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED1_MASK) >> ANTIFLIN_C1_RESERVED1_SHIFT)
#define  ANTIFLIN_C1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED1_SHIFT))

#define  ANTIFLIN_C1_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C1_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C1_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_PASSTHRU_MASK) >> ANTIFLIN_C1_PASSTHRU_SHIFT)
#define  ANTIFLIN_C1_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C1_PASSTHRU_SHIFT))

#define  ANTIFLIN_C1_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C1_RESERVED2_SHIFT 20
#define  ANTIFLIN_C1_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED2_MASK) >> ANTIFLIN_C1_RESERVED2_SHIFT)
#define  ANTIFLIN_C1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED2_SHIFT))

#define  ANTIFLIN_C1_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C1_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C1_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_FRACTIONSHIFT_MASK) >> ANTIFLIN_C1_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C1_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C1_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C1_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C1_RESERVED3_SHIFT 15
#define  ANTIFLIN_C1_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED3_MASK) >> ANTIFLIN_C1_RESERVED3_SHIFT)
#define  ANTIFLIN_C1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED3_SHIFT))

#define  ANTIFLIN_C1_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C1_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C1_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_SUBSAMPLEY_MASK) >> ANTIFLIN_C1_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C1_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C1_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C1_RESERVED4_MASK 0x800
#define  ANTIFLIN_C1_RESERVED4_SHIFT 11
#define  ANTIFLIN_C1_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED4_MASK) >> ANTIFLIN_C1_RESERVED4_SHIFT)
#define  ANTIFLIN_C1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED4_SHIFT))

#define  ANTIFLIN_C1_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C1_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C1_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_SUBSAMPLEX_MASK) >> ANTIFLIN_C1_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C1_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C1_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C1_IGNOREY_MASK 0xff
#define  ANTIFLIN_C1_IGNOREY_SHIFT 0
#define  ANTIFLIN_C1_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_IGNOREY_MASK) >> ANTIFLIN_C1_IGNOREY_SHIFT)
#define  ANTIFLIN_C1_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C1_IGNOREY_SHIFT))

//====================================================================
//Register: Channel 2 (C2)
//====================================================================

#define  ANTIFLIN_C2_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C2_RESERVED1_SHIFT 31
#define  ANTIFLIN_C2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED1_MASK) >> ANTIFLIN_C2_RESERVED1_SHIFT)
#define  ANTIFLIN_C2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED1_SHIFT))

#define  ANTIFLIN_C2_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C2_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C2_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_PASSTHRU_MASK) >> ANTIFLIN_C2_PASSTHRU_SHIFT)
#define  ANTIFLIN_C2_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C2_PASSTHRU_SHIFT))

#define  ANTIFLIN_C2_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C2_RESERVED2_SHIFT 20
#define  ANTIFLIN_C2_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED2_MASK) >> ANTIFLIN_C2_RESERVED2_SHIFT)
#define  ANTIFLIN_C2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED2_SHIFT))

#define  ANTIFLIN_C2_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C2_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C2_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_FRACTIONSHIFT_MASK) >> ANTIFLIN_C2_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C2_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C2_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C2_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C2_RESERVED3_SHIFT 15
#define  ANTIFLIN_C2_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED3_MASK) >> ANTIFLIN_C2_RESERVED3_SHIFT)
#define  ANTIFLIN_C2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED3_SHIFT))

#define  ANTIFLIN_C2_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C2_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C2_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_SUBSAMPLEY_MASK) >> ANTIFLIN_C2_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C2_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C2_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C2_RESERVED4_MASK 0x800
#define  ANTIFLIN_C2_RESERVED4_SHIFT 11
#define  ANTIFLIN_C2_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED4_MASK) >> ANTIFLIN_C2_RESERVED4_SHIFT)
#define  ANTIFLIN_C2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED4_SHIFT))

#define  ANTIFLIN_C2_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C2_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C2_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_SUBSAMPLEX_MASK) >> ANTIFLIN_C2_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C2_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C2_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C2_IGNOREY_MASK 0xff
#define  ANTIFLIN_C2_IGNOREY_SHIFT 0
#define  ANTIFLIN_C2_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_IGNOREY_MASK) >> ANTIFLIN_C2_IGNOREY_SHIFT)
#define  ANTIFLIN_C2_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C2_IGNOREY_SHIFT))

//====================================================================
//Register: Channel 3 (C3)
//====================================================================

#define  ANTIFLIN_C3_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C3_RESERVED1_SHIFT 31
#define  ANTIFLIN_C3_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED1_MASK) >> ANTIFLIN_C3_RESERVED1_SHIFT)
#define  ANTIFLIN_C3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED1_SHIFT))

#define  ANTIFLIN_C3_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C3_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C3_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_PASSTHRU_MASK) >> ANTIFLIN_C3_PASSTHRU_SHIFT)
#define  ANTIFLIN_C3_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C3_PASSTHRU_SHIFT))

#define  ANTIFLIN_C3_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C3_RESERVED2_SHIFT 20
#define  ANTIFLIN_C3_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED2_MASK) >> ANTIFLIN_C3_RESERVED2_SHIFT)
#define  ANTIFLIN_C3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED2_SHIFT))

#define  ANTIFLIN_C3_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C3_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C3_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_FRACTIONSHIFT_MASK) >> ANTIFLIN_C3_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C3_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C3_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C3_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C3_RESERVED3_SHIFT 15
#define  ANTIFLIN_C3_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED3_MASK) >> ANTIFLIN_C3_RESERVED3_SHIFT)
#define  ANTIFLIN_C3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED3_SHIFT))

#define  ANTIFLIN_C3_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C3_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C3_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_SUBSAMPLEY_MASK) >> ANTIFLIN_C3_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C3_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C3_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C3_RESERVED4_MASK 0x800
#define  ANTIFLIN_C3_RESERVED4_SHIFT 11
#define  ANTIFLIN_C3_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED4_MASK) >> ANTIFLIN_C3_RESERVED4_SHIFT)
#define  ANTIFLIN_C3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED4_SHIFT))

#define  ANTIFLIN_C3_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C3_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C3_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_SUBSAMPLEX_MASK) >> ANTIFLIN_C3_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C3_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C3_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C3_IGNOREY_MASK 0xff
#define  ANTIFLIN_C3_IGNOREY_SHIFT 0
#define  ANTIFLIN_C3_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_IGNOREY_MASK) >> ANTIFLIN_C3_IGNOREY_SHIFT)
#define  ANTIFLIN_C3_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C3_IGNOREY_SHIFT))

//====================================================================
//Register: RAM Access Control Register (RAR)
//====================================================================

#define  ANTIFLIN_RAR_RESERVED1_MASK 0xfffffff0
#define  ANTIFLIN_RAR_RESERVED1_SHIFT 4
#define  ANTIFLIN_RAR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_RESERVED1_MASK) >> ANTIFLIN_RAR_RESERVED1_SHIFT)
#define  ANTIFLIN_RAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_RESERVED1_SHIFT))

#define  ANTIFLIN_RAR_RAM_SELECT_MASK 0xc
#define  ANTIFLIN_RAR_RAM_SELECT_SHIFT 2
#define  ANTIFLIN_RAR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_RAM_SELECT_MASK) >> ANTIFLIN_RAR_RAM_SELECT_SHIFT)
#define  ANTIFLIN_RAR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_RAM_SELECT_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_RAM_SELECT_SHIFT))

#define  ANTIFLIN_RAR_INC_ADDR_MODE_MASK 0x2
#define  ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT 1
#define  ANTIFLIN_RAR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_INC_ADDR_MODE_MASK) >> ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT)
#define  ANTIFLIN_RAR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT))

#define  ANTIFLIN_RAR_LB_RNW_MASK 0x1
#define  ANTIFLIN_RAR_LB_RNW_SHIFT 0
#define  ANTIFLIN_RAR_LB_RNW_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_LB_RNW_MASK) >> ANTIFLIN_RAR_LB_RNW_SHIFT)
#define  ANTIFLIN_RAR_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_LB_RNW_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_LB_RNW_SHIFT))

//====================================================================
//Register: RAM Address Write Register (RAWR)
//====================================================================

#define  ANTIFLIN_RAWR_RESERVED1_MASK 0xfffffc00
#define  ANTIFLIN_RAWR_RESERVED1_SHIFT 10
#define  ANTIFLIN_RAWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAWR_RESERVED1_MASK) >> ANTIFLIN_RAWR_RESERVED1_SHIFT)
#define  ANTIFLIN_RAWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RAWR_RESERVED1_SHIFT))

#define  ANTIFLIN_RAWR_ADDRESS_MASK 0x3ff
#define  ANTIFLIN_RAWR_ADDRESS_SHIFT 0
#define  ANTIFLIN_RAWR_ADDRESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAWR_ADDRESS_MASK) >> ANTIFLIN_RAWR_ADDRESS_SHIFT)
#define  ANTIFLIN_RAWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAWR_ADDRESS_MASK) | (((uint32_t)val) << ANTIFLIN_RAWR_ADDRESS_SHIFT))

//====================================================================
//Register: RAM Address Status Register (RASR)
//====================================================================

#define  ANTIFLIN_RASR_RESERVED1_MASK 0xfffffc00
#define  ANTIFLIN_RASR_RESERVED1_SHIFT 10
#define  ANTIFLIN_RASR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RASR_RESERVED1_MASK) >> ANTIFLIN_RASR_RESERVED1_SHIFT)
#define  ANTIFLIN_RASR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RASR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RASR_RESERVED1_SHIFT))

#define  ANTIFLIN_RASR_ADDRESS_MASK 0x3ff
#define  ANTIFLIN_RASR_ADDRESS_SHIFT 0
#define  ANTIFLIN_RASR_ADDRESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RASR_ADDRESS_MASK) >> ANTIFLIN_RASR_ADDRESS_SHIFT)
#define  ANTIFLIN_RASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RASR_ADDRESS_MASK) | (((uint32_t)val) << ANTIFLIN_RASR_ADDRESS_SHIFT))

//====================================================================
//Register: RAM Data Write Register (RDWR)
/** \brief This register writes the RAM.*/
//====================================================================

#define  ANTIFLIN_RDWR_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_RDWR_RESERVED1_SHIFT 24
#define  ANTIFLIN_RDWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDWR_RESERVED1_MASK) >> ANTIFLIN_RDWR_RESERVED1_SHIFT)
#define  ANTIFLIN_RDWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RDWR_RESERVED1_SHIFT))

#define  ANTIFLIN_RDWR_DATA_MASK 0xffffff
#define  ANTIFLIN_RDWR_DATA_SHIFT 0
#define  ANTIFLIN_RDWR_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDWR_DATA_MASK) >> ANTIFLIN_RDWR_DATA_SHIFT)
#define  ANTIFLIN_RDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDWR_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_RDWR_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read Register (RDRR)
/** \brief This register reads the SRAM.*/
//====================================================================

#define  ANTIFLIN_RDRR_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_RDRR_RESERVED1_SHIFT 24
#define  ANTIFLIN_RDRR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDRR_RESERVED1_MASK) >> ANTIFLIN_RDRR_RESERVED1_SHIFT)
#define  ANTIFLIN_RDRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDRR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RDRR_RESERVED1_SHIFT))

#define  ANTIFLIN_RDRR_DATA_MASK 0xffffff
#define  ANTIFLIN_RDRR_DATA_SHIFT 0
#define  ANTIFLIN_RDRR_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDRR_DATA_MASK) >> ANTIFLIN_RDRR_DATA_SHIFT)
#define  ANTIFLIN_RDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDRR_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_RDRR_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 0 Debug Register (debug_ch0)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH0_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH0_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH0_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH0_DATA_MASK) >> ANTIFLIN_DEBUG_CH0_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH0_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH0_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH0_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 1 Debug Register (debug_ch1)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH1_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH1_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH1_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH1_DATA_MASK) >> ANTIFLIN_DEBUG_CH1_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH1_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH1_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH1_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 2 Debug Register (debug_ch2)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH2_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH2_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH2_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH2_DATA_MASK) >> ANTIFLIN_DEBUG_CH2_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH2_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH2_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH2_DATA_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFLIN_REV0_MAJ_MASK 0xffff0000
#define  ANTIFLIN_REV0_MAJ_SHIFT 16
#define  ANTIFLIN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV0_MAJ_MASK) >> ANTIFLIN_REV0_MAJ_SHIFT)
#define  ANTIFLIN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFLIN_REV0_MAJ_SHIFT))

#define  ANTIFLIN_REV0_MID_MASK 0xffff
#define  ANTIFLIN_REV0_MID_SHIFT 0
#define  ANTIFLIN_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV0_MID_MASK) >> ANTIFLIN_REV0_MID_SHIFT)
#define  ANTIFLIN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV0_MID_MASK) | (((uint32_t)val) << ANTIFLIN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFLIN_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFLIN_REV1_RESERVED1_SHIFT 16
#define  ANTIFLIN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV1_RESERVED1_MASK) >> ANTIFLIN_REV1_RESERVED1_SHIFT)
#define  ANTIFLIN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_REV1_RESERVED1_SHIFT))

#define  ANTIFLIN_REV1_CFG_MASK 0xffff
#define  ANTIFLIN_REV1_CFG_SHIFT 0
#define  ANTIFLIN_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV1_CFG_MASK) >> ANTIFLIN_REV1_CFG_SHIFT)
#define  ANTIFLIN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFLIN_REV1_CFG_SHIFT))

#endif // ANTIFLIN
