 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ANTIFCOR_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ANTIFCOR_REGMASKS_H_
#define _ANTIFCOR_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: ANTIFCOR (ANTIFCOR)
/** \brief Register descriptions for the ANTIFCOR block.*/
//
//====================================================================

//====================================================================
//Register: ANTIFCOR Configuration Register (ANTIFCOR_CFG)
//====================================================================

#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK 0xf8000000
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT 27
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK) >> ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_RESERVED1_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK 0x7000000
#define  ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT 24
#define  ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK) >> ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_VSCALE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_VSCALE_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_VSCALE_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK 0xf80000
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT 19
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK) >> ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_RESERVED2_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_RESERVED2_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK 0x70000
#define  ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT 16
#define  ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK) >> ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_HSCALE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_HSCALE_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_HSCALE_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK 0xfffe
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT 1
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK) >> ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_RESERVED3_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_RESERVED3_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK 0x1
#define  ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT 0
#define  ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK) >> ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CFG_BYPASS_ALL_SHIFT))

//====================================================================
//Register: ANTIFCOR Gray and Black Clip Register (ANTIFCOR_CLIP)
//====================================================================

#define  ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK 0xffff0000
#define  ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT 16
#define  ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK) >> ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CLIP_GRAYCLIP_SHIFT))

#define  ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK 0xffff
#define  ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT 0
#define  ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK_SHIFT(reg) (((reg) & ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK) >> ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT)
#define  ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_MASK) | (((uint32_t)val) << ANTIFCOR_ANTIFCOR_CLIP_BLACKCLIP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFCOR_REV0_MAJ_MASK 0xffff0000
#define  ANTIFCOR_REV0_MAJ_SHIFT 16
#define  ANTIFCOR_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFCOR_REV0_MAJ_MASK) >> ANTIFCOR_REV0_MAJ_SHIFT)
#define  ANTIFCOR_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFCOR_REV0_MAJ_SHIFT))

#define  ANTIFCOR_REV0_MID_MASK 0xffff
#define  ANTIFCOR_REV0_MID_SHIFT 0
#define  ANTIFCOR_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFCOR_REV0_MID_MASK) >> ANTIFCOR_REV0_MID_SHIFT)
#define  ANTIFCOR_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_REV0_MID_MASK) | (((uint32_t)val) << ANTIFCOR_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFCOR_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFCOR_REV1_RESERVED1_SHIFT 16
#define  ANTIFCOR_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFCOR_REV1_RESERVED1_MASK) >> ANTIFCOR_REV1_RESERVED1_SHIFT)
#define  ANTIFCOR_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFCOR_REV1_RESERVED1_SHIFT))

#define  ANTIFCOR_REV1_CFG_MASK 0xffff
#define  ANTIFCOR_REV1_CFG_SHIFT 0
#define  ANTIFCOR_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFCOR_REV1_CFG_MASK) >> ANTIFCOR_REV1_CFG_SHIFT)
#define  ANTIFCOR_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFCOR_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFCOR_REV1_CFG_SHIFT))

#endif // ANTIFCOR
