 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ADCNorm_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ADCNORM_REGMASKS_H_
#define _ADCNORM_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: ADCNorm (ADCNorm)
/** \brief Register Descriptions for the PIC ADCNorm block (rev 0 . 2 . 2 . 4)*/
//
//====================================================================

//====================================================================
//Register: ADC Normalization Register (ANR)
/** \brief The ANR Register controls the normalization functions as defined below. Note that the normalization logic is bypassed in Bypass Mode and when the ExposureIn CBI signal is valid.*/
//====================================================================

#define  ADCNORM_ANR_RESERVED1_MASK 0xfffffe00
#define  ADCNORM_ANR_RESERVED1_SHIFT 9
#define  ADCNORM_ANR_RESERVED1_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_RESERVED1_MASK) >> ADCNORM_ANR_RESERVED1_SHIFT)
#define  ADCNORM_ANR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_RESERVED1_MASK) | (((uint32_t)val) << ADCNORM_ANR_RESERVED1_SHIFT))

#define  ADCNORM_ANR_BYPASS_MASK 0x100
#define  ADCNORM_ANR_BYPASS_SHIFT 8
#define  ADCNORM_ANR_BYPASS_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_BYPASS_MASK) >> ADCNORM_ANR_BYPASS_SHIFT)
#define  ADCNORM_ANR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_BYPASS_MASK) | (((uint32_t)val) << ADCNORM_ANR_BYPASS_SHIFT))

#define  ADCNORM_ANR_INVERT_MASK 0x80
#define  ADCNORM_ANR_INVERT_SHIFT 7
#define  ADCNORM_ANR_INVERT_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_INVERT_MASK) >> ADCNORM_ANR_INVERT_SHIFT)
#define  ADCNORM_ANR_INVERT_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_INVERT_MASK) | (((uint32_t)val) << ADCNORM_ANR_INVERT_SHIFT))

#define  ADCNORM_ANR_JUSTIFY_MASK 0x40
#define  ADCNORM_ANR_JUSTIFY_SHIFT 6
#define  ADCNORM_ANR_JUSTIFY_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_JUSTIFY_MASK) >> ADCNORM_ANR_JUSTIFY_SHIFT)
#define  ADCNORM_ANR_JUSTIFY_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_JUSTIFY_MASK) | (((uint32_t)val) << ADCNORM_ANR_JUSTIFY_SHIFT))

#define  ADCNORM_ANR_PADFILL_MASK 0x30
#define  ADCNORM_ANR_PADFILL_SHIFT 4
#define  ADCNORM_ANR_PADFILL_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_PADFILL_MASK) >> ADCNORM_ANR_PADFILL_SHIFT)
#define  ADCNORM_ANR_PADFILL_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_PADFILL_MASK) | (((uint32_t)val) << ADCNORM_ANR_PADFILL_SHIFT))

#define  ADCNORM_ANR_ADCBITS_MASK 0xf
#define  ADCNORM_ANR_ADCBITS_SHIFT 0
#define  ADCNORM_ANR_ADCBITS_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_ADCBITS_MASK) >> ADCNORM_ANR_ADCBITS_SHIFT)
#define  ADCNORM_ANR_ADCBITS_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_ADCBITS_MASK) | (((uint32_t)val) << ADCNORM_ANR_ADCBITS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
                    This register of particular interest to firmware.*/
//====================================================================

#define  ADCNORM_REV0_MAJ_MASK 0xffff0000
#define  ADCNORM_REV0_MAJ_SHIFT 16
#define  ADCNORM_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ADCNORM_REV0_MAJ_MASK) >> ADCNORM_REV0_MAJ_SHIFT)
#define  ADCNORM_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV0_MAJ_MASK) | (((uint32_t)val) << ADCNORM_REV0_MAJ_SHIFT))

#define  ADCNORM_REV0_MID_MASK 0xffff
#define  ADCNORM_REV0_MID_SHIFT 0
#define  ADCNORM_REV0_MID_MASK_SHIFT(reg) (((reg) & ADCNORM_REV0_MID_MASK) >> ADCNORM_REV0_MID_SHIFT)
#define  ADCNORM_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV0_MID_MASK) | (((uint32_t)val) << ADCNORM_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ADCNORM_REV1_RESERVED1_MASK 0xffff0000
#define  ADCNORM_REV1_RESERVED1_SHIFT 16
#define  ADCNORM_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADCNORM_REV1_RESERVED1_MASK) >> ADCNORM_REV1_RESERVED1_SHIFT)
#define  ADCNORM_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV1_RESERVED1_MASK) | (((uint32_t)val) << ADCNORM_REV1_RESERVED1_SHIFT))

#define  ADCNORM_REV1_CFG_MASK 0xffff
#define  ADCNORM_REV1_CFG_SHIFT 0
#define  ADCNORM_REV1_CFG_MASK_SHIFT(reg) (((reg) & ADCNORM_REV1_CFG_MASK) >> ADCNORM_REV1_CFG_SHIFT)
#define  ADCNORM_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV1_CFG_MASK) | (((uint32_t)val) << ADCNORM_REV1_CFG_SHIFT))

#endif // ADCNORM
