/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/* 
 * This file is a h/a/c/k to support building different executables with
 * different sensors.
 * 
 * dave 25-May-2011
 */

#ifndef SCANSEN_TARGET_H
#define SCANSEN_TARGET_H

#define SCAN_SENSOR_TYPE1     87
#define SCAN_SENSOR_TYPE2     88 


/** 
 * \brief LED gate timing 
 *
 */
typedef struct {
    scan_cmode_t   cmode;
    uint32_t         dpi;
    uint32_t         edgeR;
    uint32_t         edgeF;
} scan_led_timing_t;


/** 
 * \brief SCANX gate timing 
 *
 */
typedef struct {
    scan_cmode_t   cmode;
    uint32_t         dpi;
    uint32_t         scanx;
} scan_scanx_conf_t;


/**
 *  \brief CISX configuration
 *
 **/
struct scan_cisx_conf {
    uint32_t                     dpi;           
    struct cisx_sensor_conf    cisx_conf;
};

struct pt_cis {
    unsigned int cis_ctrl;
    unsigned int cis_led_en;
};

int scansen_get_sensor_id( void );

/**
 *  \brief Chipgap configuration table
 *
 **/
typedef struct {
    uint32_t         dpi;
    struct scan_sensor_chipgap gap_conf;
} scan_chipgap_table_t;

#endif

