/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/*
 * Some kernel functions can only be called from GPL'd modules. Split the
 * scantask into three modules:
 *      kscanman (GPL; kernel/userspace interface)
 *      kscantask (Proprietary; the bulk of the scan code)
 *      scansb (GPL; kernel functions that require GPL module)
 *
 */

#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <asm/gpio.h>
#include <linux/dma-mapping.h>
#include <linux/dmaengine.h>
#include <linux/interrupt.h>

#include "lassert.h"

#include "scantypes.h"
#include "scancore.h"
#include "scanplat.h"
#include "scansen.h"
#include "scanvars.h"
#include "scanmech.h"
#include "adfsensor_granum2.h"
#include "scanmech_granum2.h" 
//#include "afe_wm8213.h"
//#include "scansen-target.h"
#include "scanplat_sb.h"

/**
 * \brief  Linux GPL code
 *
 */

#define GPIO_B(n)   ( 32+n)
#define GPIO_C(n)   ( 64+n)
#define GPIO_D(n)   ( 96+n)
#define GPIO_E(n)   (128+n)
#define GPIO_F(n)   (160+n)
#define GPIO_G(n)   (192+n)
#define GPIO_H(n)   (224+n)


static bool (*home_isr)(void) = NULL;
static irqreturn_t home_irq_handler(int irq, void *dev_id)
{
    // Warning: debug output in isr context!  Don't leave this enabled.
    //printk("%s: irq=%d\n", __FUNCTION__, irq);

    if (home_isr != NULL)
    {
        if (home_isr())
        {
            return IRQ_HANDLED;
        }
    }
    return IRQ_NONE;
}

static bool (*pip_isr)(void) = NULL;
static irqreturn_t pip_irq_handler(int irq, void *dev_id)
{
    // Warning: debug output in isr context!  Don't leave this enabled.
    //printk("%s: irq=%d\n", __FUNCTION__, irq);

    if (pip_isr != NULL)
    {
        if (pip_isr())
        {
            return IRQ_HANDLED;
        }
    }
    return IRQ_NONE;
}

static bool (*cio_isr)(void) = NULL;
static irqreturn_t cio_irq_handler(int irq, void *dev_id)
{
    // Warning: debug output in isr context!  Don't leave this enabled.
    //printk("%s: irq=%d\n", __FUNCTION__, irq);

    if (cio_isr != NULL)
    {
        if (cio_isr())
        {
            return IRQ_HANDLED;
        }
    }
    return IRQ_NONE;
}


int adfsensor_kernel_onetime_init( struct pt_adf *adf, 
                                   bool (*pip_handler)(void),
                                   bool (*cio_handler)(void) )
{
	#if 0 
    int err;
    int pip_irq = 0;
    int cio_irq = 0;

    adf->adf_pip_sensor_gpio = GPIO_F(7);
    err = gpio_request(adf->adf_pip_sensor_gpio, "ADF Paper In Path Sensor");
    XASSERT(err==0, err);
    err = gpio_direction_input(adf->adf_pip_sensor_gpio);
    XASSERT(err==0, err);

    pip_isr = pip_handler;
    pip_irq = gpio_to_irq(adf->adf_pip_sensor_gpio);
    XASSERT(pip_irq >= 0, pip_irq);
    err = request_irq(pip_irq, pip_irq_handler, IRQF_TRIGGER_FALLING | IRQF_TRIGGER_RISING, "PIP intr", "PIP intr");
    XASSERT(err==0, err);
    
    adf->adf_pp_sensor_gpio = GPIO_F(5);
    err = gpio_request(adf->adf_pp_sensor_gpio, "ADF Paper Present Sensor");
    XASSERT(err==0, err);
    err = gpio_direction_input(adf->adf_pp_sensor_gpio);
    XASSERT(err==0, err);
    
    adf->adf_cio_sensor_gpio = GPIO_F(6);
    err = gpio_request(adf->adf_cio_sensor_gpio, "ADF Cover Is Open Sensor");
    XASSERT(err==0, err);
    err = gpio_direction_input(adf->adf_cio_sensor_gpio);
    XASSERT(err==0, err);

    cio_isr = cio_handler;
    cio_irq = gpio_to_irq(adf->adf_cio_sensor_gpio);
    XASSERT(cio_irq >= 0, cio_irq);
    err = request_irq(cio_irq, cio_irq_handler, IRQF_TRIGGER_FALLING | IRQF_TRIGGER_RISING, "CIO intr", "CIO intr");
    XASSERT(err==0, err);
	#endif
    return 0;
}


#if 0 
int cis_kernel_onetime_init(struct pt_cis *cis)
{
    int err;

    cis->cis_ctrl = GPIO_G(29);
    err = gpio_request(cis->cis_ctrl, "CIS Ctrl Signal");
    XASSERT(err==0, err);
    err = gpio_direction_output(cis->cis_ctrl, 1);
    XASSERT(err==0, err);
    gpio_set_value(cis->cis_ctrl, 0);

    cis->cis_led_en = GPIO_F(3);
    err = gpio_request(cis->cis_led_en, "CIS LED_EN Signal");
    XASSERT(err==0, err);
    err = gpio_direction_output(cis->cis_led_en, 1);
    XASSERT(err==0, err);
    gpio_set_value(cis->cis_led_en, 0);

    return 0;
}

int afe_kernel_onetime_init(struct pt_afe *afe)
{
    int err;

    //AFE WM8213 OEB = GPIOG28 (output)
    afe->afe_wm8213_gpio_scif_oeb = GPIO_G(28);
    err = gpio_request(afe->afe_wm8213_gpio_scif_oeb, "AFE WM8213 GPIO SCIF OEB");
    XASSERT(err==0, err);
    err = gpio_direction_output(afe->afe_wm8213_gpio_scif_oeb, 1);
    XASSERT(err==0, err);
    gpio_set_value(afe->afe_wm8213_gpio_scif_oeb, 0);

    //AFE WM8213 SCL = GPIOG30 (output)
    afe->afe_wm8213_gpio_scif_scl = GPIO_G(30);
    err = gpio_request(afe->afe_wm8213_gpio_scif_scl, "AFE WM8213 GPIO SCIF CLK");
    XASSERT(err==0, err);
    err = gpio_direction_output(afe->afe_wm8213_gpio_scif_scl, 1);
    XASSERT(err==0, err);
    gpio_set_value(afe->afe_wm8213_gpio_scif_scl, 0);
    
    //AFE WM8213 SEN = GPIOG31 (output)
    afe->afe_wm8213_gpio_scif_sen = GPIO_G(22);
    err = gpio_request(afe->afe_wm8213_gpio_scif_sen, "AFE WM8213 GPIO SCIF SEN");
    XASSERT(err==0, err);
    err = gpio_direction_output(afe->afe_wm8213_gpio_scif_sen, 1);
    XASSERT(err==0, err);
    gpio_set_value(afe->afe_wm8213_gpio_scif_sen, 0);

    //AFE WM8213 SDO = GPIOH00 (input)
    afe->afe_wm8213_gpio_scif_sdo = GPIO_H(0);
    err = gpio_request(afe->afe_wm8213_gpio_scif_sdo, "AFE WM8213 GPIO SCIF SDO");
    XASSERT(err==0, err);
    err = gpio_direction_input(afe->afe_wm8213_gpio_scif_sdo);
    XASSERT(err==0, err);

    //AFE WM8213 SDI = GPIOH01 (output)
    afe->afe_wm8213_gpio_scif_sdi = GPIO_H(1);
    err = gpio_request(afe->afe_wm8213_gpio_scif_sdi, "AFE WM8213 GPIO SCIF SDI");
    XASSERT(err==0, err);
    err = gpio_direction_output(afe->afe_wm8213_gpio_scif_sdi, 1);
    XASSERT(err==0, err);
    gpio_set_value(afe->afe_wm8213_gpio_scif_sdi, 0);
    
    return 0;
}
#endif


int smech_kernel_init(struct pt_mech *pt, bool (*home_sensor_isr)(void))
{
    int err;
    int home_irq = 0;
    #if 0
    pt->scan_home_sensor_gpio = GPIO_F(31);
    err = gpio_request(pt->scan_home_sensor_gpio, "Scanner Home Sensor");
    XASSERT(err==0, err);
    err = gpio_direction_input(pt->scan_home_sensor_gpio);
    XASSERT(err==0, err);

    home_isr = home_sensor_isr;
    home_irq = gpio_to_irq(pt->scan_home_sensor_gpio);
    XASSERT(home_irq >= 0, home_irq);
    err = request_irq(home_irq, home_irq_handler, IRQF_TRIGGER_FALLING | IRQF_TRIGGER_RISING, "HOME intr", "HOME intr");
    XASSERT(err==0, err);

    pt->scan_fb_motor_driver_nslp = GPIO_B(28);
    err = gpio_request(pt->scan_fb_motor_driver_nslp, "FB Motor Driver NSLP");
    XASSERT(err==0, err);
    err = gpio_direction_output(pt->scan_fb_motor_driver_nslp, 1);
    XASSERT(err==0, err);
    gpio_set_value(pt->scan_fb_motor_driver_nslp, 1);

    pt->scan_adf_motor_driver_nslp = GPIO_B(29);
    err = gpio_request(pt->scan_adf_motor_driver_nslp, "ADF Motor Driver NSLP");
    XASSERT(err==0, err);
    err = gpio_direction_output(pt->scan_adf_motor_driver_nslp, 1);
    XASSERT(err==0, err);
    gpio_set_value(pt->scan_adf_motor_driver_nslp, 1);

    pt->scan_sensor_pwr_en_n = GPIO_C(19);
    err = gpio_request(pt->scan_sensor_pwr_en_n, "Scan Sensor Power Enable");
    XASSERT(err==0, err);
    err = gpio_direction_output(pt->scan_sensor_pwr_en_n, 1);
    XASSERT(err==0, err);
    // Start with the power off (1=off, 0=on)
    gpio_set_value(pt->scan_sensor_pwr_en_n, 1);
	#endif
    return 0;
}


void scanplat_kernel_gpio_set_value( unsigned int gpio, int value )
{
    gpio_set_value(gpio,value);
}

int scanplat_kernel_gpio_get_value( unsigned int gpio )
{
    return gpio_get_value(gpio);
}

static int __init scanplat_sb_init_module(void)
{
    /*
     * A non 0 return means init_module failed; module can't be loaded.
     */
    return 0;
}

static void __exit scanplat_sb_cleanup_module(void)
{
}

void scanplat_sb_init_scan_gpio( void )
{
    uint32_t pad, err;
#if 0
    printk("%s: reached\n", __func__);
    /* Two sensor GPIOs must be set for the Granum 2 board:
         1) gpioC18/pad82 -- OUTPUT -- LO
            (enables 3.3V source)
         2) gpioF3/pad163 -- OUTPUT -- HI
            (enables 8V source -- labelled as 6.6V?) */
    pad = 82;
    err = gpio_request(pad, "nSCAN_PWR_EN");
    XASSERT(err==0, err);
    err = gpio_direction_output(pad, 0);
    XASSERT(err==0, err);
    gpio_set_value(pad, 0);

    pad = 163;
    err = gpio_request(pad, "CIS_LED_EN");
    XASSERT(err==0, err);
    err = gpio_direction_output(pad, 1);
    XASSERT(err==0, err);
    gpio_set_value(pad, 1);
 #endif
}

module_init( scanplat_sb_init_module );
module_exit( scanplat_sb_cleanup_module );

EXPORT_SYMBOL(adfsensor_kernel_onetime_init);
//EXPORT_SYMBOL(cis_kernel_onetime_init);
//EXPORT_SYMBOL(afe_kernel_onetime_init);
EXPORT_SYMBOL(smech_kernel_init);

EXPORT_SYMBOL(scanplat_kernel_gpio_set_value);
EXPORT_SYMBOL(scanplat_kernel_gpio_get_value);
EXPORT_SYMBOL(scanplat_sb_init_scan_gpio);

MODULE_AUTHOR("Copyright (c) 2013-2016, Marvell International Ltd.");
MODULE_DESCRIPTION("scanplat_sb");

MODULE_LICENSE("Dual MPL/GPL");
MODULE_VERSION("2014_JUL_31");

