/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/*
 * Some kernel functions can only be called from GPL'd modules. Split the
 * scantask into three modules: 
 *      kscanman (GPL; kernel/userspace interface)
 *      kscantask (Proprietary; the bulk of the scan code)
 *      scansb (GPL; kernel functions that require GPL module)
 *
 */

#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <asm/gpio.h>
#include <linux/dma-mapping.h>
#include <linux/dmaengine.h>
#include <linux/interrupt.h>

#include "lassert.h"

#include "scantypes.h"
#include "scancore.h"
#include "scanplat.h"
#include "scansen.h"
#include "scanvars.h"
#include "scanmech.h"
#include "scanplat_sb.h"

/**
 * \brief  Linux GPL code 
 *
 */

#define GPIO_C(n)   (64+n)
#define GPIO_D(n)   (96+n)
#define GPIO_F(n)   (160+n)

int adf_sensor_kernel_onetime_init( struct pt_adf *adf,
                                    bool (*pip_handler)(void), 
                                    bool (*cio_handler)(void) )
{
    return 0;
}


void scanplat_kernel_gpio_set_value( unsigned int gpio, int value )
{
    gpio_set_value(gpio,value);
}

int scanplat_kernel_gpio_get_value( unsigned int gpio )
{
    return gpio_get_value(gpio);
}

static int __init scanplat_sb_init_module(void)
{
    /* 
     * A non 0 return means init_module failed; module can't be loaded. 
     */
    return 0;
}

static void __exit scanplat_sb_cleanup_module(void)
{
}

void scanplat_sb_init_scan_gpio( void )
{
}

module_init( scanplat_sb_init_module );
module_exit( scanplat_sb_cleanup_module );

EXPORT_SYMBOL(adf_sensor_kernel_onetime_init);

EXPORT_SYMBOL(scanplat_kernel_gpio_set_value);
EXPORT_SYMBOL(scanplat_kernel_gpio_get_value);
EXPORT_SYMBOL(scanplat_sb_init_scan_gpio);

MODULE_AUTHOR("Copyright (c) 2013-2016, Marvell International Ltd.");
MODULE_DESCRIPTION("scanplat_sb");

MODULE_LICENSE("Dual MPL/GPL");
MODULE_VERSION("2013_SEP_24");

