/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/** 
 * \file adfsensor_granum2.h
 *
 * \brief Internal Marvell Granum2 ADF sensor function definitions
 *
 **/

#ifndef ADFSENSOR_GRANUM2_H
#define ADFSENSOR_GRANUM2_H

#define SMECH_ADF_ERROR_CIO     0xE0
#define SMECH_ADF_ERROR_JAM     0xE1

bool adf_sensor_cover_is_open(void);
void adf_sensor_cio_callback_enable(void);
void adf_sensor_cio_callback_disable(void);

/* Granum2 ADF GPIO data structure for GPIO initialization
 * (requires calls to GPL functions so in scansb module).
 */
struct pt_adf {
    unsigned int adf_pip_sensor_gpio;   // Paper in path
    unsigned int adf_pp_sensor_gpio;    // Paper present
    unsigned int adf_cio_sensor_gpio;   // Cover is open
};


#endif // ADFSENSOR_GRANUM2_H

