;; ===========================================================================
;;    Copyright (c) 2014  RICOH Crp. All right reserved.
;; ===========================================================================
;;
;; Filename:    sccplite_afersci.s
;;
;; ̃AZu\[X́ASCCPLiteAFE_SCIʐM̃}CNR[hB
;; SCCPLite̊epin̊t͈ȉ̂ƂB
;;  GPIO pin 1 - AFE_SCK
;;  GPIO pin 2 - AFE_SDI
;;  GPIO pin 3 - AFE_SEN
;;  GPIO pin 4 - AFE_SDO
;;
;; ̃R[hAFEƂ̒ʐMAFE_SCI@\̂݃T|[gB
;; AhXTCY4bitAMf[^TCY1byteŒAʐMNbN4MHzB
;;
;; SRAMzu
;;   0x000:0x01F - CFWƂ̃f[^obt@
;;   0x020:0x023 - R}hMailbox
;;   0x024:0x37F - microcode
;;   0x380:      - X^bN
;;
;; SCCP}CNR[h́AɃR}hmailboxĎĂāA0x200ȊO
;; lݒ肳ƁAR}hsB0x20ɒlݒ肷Oɑ̃AhX
;; Ƀp[^ݒ肷KvB
;; R}hƁAR}hmailbox0NABāA݂
;; ACFW݃NÂ҂B
;; ُƂẮApeBG[̂݌mB
;;
;; R}hmailbox
;;   Command A bits 15:3  = <unused>
;;   Command A bit   2:1  = R/W (0x3 = DF_write, 0x2 = DF_Read, 0x1 = FB_write, 0x0 = FB_read)
;;   Command A bit     0  = ʐMNGXg(1:Request, 0:None)
;;   Command B bits 15:0  = <unused>
;;   Arg     A bits 15:4  = <unused>
;;   Arg     A bits  3:0  = Address
;;   Arg     B bits 15:0  = <unused>
;;
;; 
;;   Interrupt bit    Meaning
;;   -------------    -------------------------------------
;;      0             ʐM
;;
;; NbN
;; ^[QbgNbN4MHzŎ0.25usBABPoXNbN͖5.05nsB
;; 4MHz49APBoXNbNB
;;
;; CLK freq.     CLK period     CLK high time     CLK low time  
;; ----------    -----------    --------------    --------------
;;    4 MHz      0.25 us        0.125 us          0.125 us      
;;    4 MHz      49 APB clk     24 APB clk        24 APB clk    
;;
;; ėpWX^̎gp@
;;  ȉ̓KChCłāAWX^邽߁A
;;  KvɉăX^bNɐςނƂŕʂ̗prŎgpB
;;  g0 - {I0(萔)ƂĎgp
;;  g1 - R/W bit, 1=Write, 0=Read
;;  g2 - Address
;;  g3 - pŗlX
;;  g4 - pŗlX
;;  g5 - pŗlX
;;
;; The stack pointer is initialized to _stack near the top of SCCP SRAM.
;;
;;
;; define some useful equates
;;

;; Want stack at byte address 0x700 which is word address 0x380
_stack             equ 0x38  ;; initial value for the stack pointer really want 0x380
                             ;; so load 0x38 then shift left by 4
_addr_writedata    equ    0  ;; Write Data Address(word address)
_addr_readdata     equ    2  ;; Read Data Address(word address)
    
;; error/return bit fields - these indicate the bits that will be set in the int register
;; to indicate success/fail after a command
success           equ 0x0            ;; success

;; commands
cmd_df_write      equ 0x3            ;; df_write cmd
cmd_df_read       equ 0x2            ;; df_read cmd
cmd_fb_write      equ 0x1            ;; write cmd
cmd_fb_read       equ 0x0            ;; read cmd

;; GPIO[1] = AFE_SCK
;; GPIO[2] = AFE_SDO
;; GPIO[3] = AFE_SEN
;; GPIO[4] = AFE_SDI
gpio_clk            equ 1
gpio_data_in	    equ 2
gpio_sdenb          equ 3
gpio_data_out       equ 4

out      equ 1
in       equ 0

pin1     equ 1
pin0     equ 0


;; ABP_BUS:200MHz Ȃ̂Ŏ5[ns]
uSec_0_625            equ  125    ;; 0.625 uSec delay
uSec_0_5              equ  100    ;; 0.5 uSec delay
uSec_0_25             equ  50     ;; 0.25 uSec delay
uSec_0_2              equ  40     ;; 0.2 uSec delay
uSec_0_125            equ  25     ;; 0.125 uSec delay
uSec_0_125_minus3clk  equ  22     ;; 0.125 uSec delay
uSec_0                equ  0      ;; 0 uSec delay
    
;;  The number of bytes in the list below needs to match MAX_DATA_SIZE_BYTES or there can be overflow -- REVISIT
;; define the data byte buffer storage locations at offset 0x0
;;
B_1_0          data    0x0000    ;; data byte queue entry at address 0x00
B_3_2          data    0x0000    ;; data byte queue entry at address 0x01
B_5_4          data    0x0000    ;; data byte queue entry at address 0x02
B_7_6          data    0x0000    ;; data byte queue entry at address 0x03
B_9_8          data    0x0000    ;; data byte queue entry at address 0x04
B_11_10        data    0x0000    ;; data byte queue entry at address 0x05
B_13_12        data    0x0000    ;; data byte queue entry at address 0x06
B_15_14        data    0x0000    ;; data byte queue entry at address 0x07
B_17_16        data    0x0000    ;; data byte queue entry at address 0x08
B_19_18        data    0x0000    ;; data byte queue entry at address 0x09
B_21_20        data    0x0000    ;; data byte queue entry at address 0x0A
B_23_22        data    0x0000    ;; data byte queue entry at address 0x0B
B_25_24        data    0x0000    ;; data byte queue entry at address 0x0C
B_27_26        data    0x0000    ;; data byte queue entry at address 0x0D
B_29_28        data    0x0000    ;; data byte queue entry at address 0x0E
B_31_30        data    0x0000    ;; data byte queue entry at address 0x0F
B_33_32        data    0x0000    ;; data byte queue entry at address 0x10
B_35_34        data    0x0000    ;; data byte queue entry at address 0x11
B_37_36        data    0x0000    ;; data byte queue entry at address 0x12
B_39_38        data    0x0000    ;; data byte queue entry at address 0x13
B_41_40        data    0x0000    ;; data byte queue entry at address 0x14
B_43_42        data    0x0000    ;; data byte queue entry at address 0x15
B_45_44        data    0x0000    ;; data byte queue entry at address 0x16
B_47_46        data    0x0000    ;; data byte queue entry at address 0x17
B_49_48        data    0x0000    ;; data byte queue entry at address 0x18
B_51_50        data    0x0000    ;; data byte queue entry at address 0x19
B_53_52        data    0x0000    ;; data byte queue entry at address 0x1A
B_55_54        data    0x0000    ;; data byte queue entry at address 0x1B
B_57_56        data    0x0000    ;; data byte queue entry at address 0x1C
B_59_58        data    0x0000    ;; data byte queue entry at address 0x1D
B_61_60        data    0x0000    ;; data byte queue entry at address 0x1E
B_63_62        data    0x0000    ;; data byte queue entry at address 0x1F
;;
;; define the command mailbox location at offset 0x20
;;

;; cmd_A: 
;;   bits 3-15  = unused
;;   bit  1-2   = R/W
;;   bit  0     = Request
;; cmd_B:
;;   bits 0-15  = unused
;; arg_A:
;;   bits 4-15  = unused
;;   bits 0-3   = Address
;; arg_B:
;;   bits 0-15  = unused
cmd_A  data    0x0000    ;; command entry at address 0x20
cmd_B  data    0x0000
arg_A  data    0x0000    ;; cmd arguments entry at address 0x22
arg_B  data    0x0000    ;; 
;;
;; Executable code starts at offset 0x24 so the IP must be initialized to 0x24
;; before starting SCCP code execution
;;
init:
    ldi        g1, _stack                       ;; initialize the stack pointer
    shli       g1, 4                            ;; Convert stack value from 0x38 to 0x380 which maps to SRAM address 0x700
    mov        sp, g1                           ;; set stack pointer
    ldi        g1, 0xc                          ;; MSB first for Data1/0 regs
    mov        mode, g1             
    ldi        g0, 0                            ;; load g0 with 0 and use it like a constant

    sck        out, 0, gpio_clk, uSec_0         ;; set clk to open-drain (O-D) 1 with 0 uSec delay(sck=sgpio)
    sgpio      out, 0, gpio_sdenb, uSec_0       ;; set cs to open-drain (O-D) 1 with 0 uSec delay(sgpio=sck)
    sgpio      out, 0, gpio_data_out, uSec_0    ;; set cs to open-drain (O-D) 1 with 0 uSec delay(sgpio=sck)
    sgpio      in, 1, gpio_data_in, uSec_0      ;; set data out to Hi-Z(1) with 0 uSec delay

;;
;; Enter the idle loop looking for valid AFE_SCI commands to execute
;;
idle:
    nopi       16                   ;; wait 16 clocks to allow the CPU access
    ldr        g5, cmd_A            ;; load the top 16 bits of command into reg g5
    cmpi       g5, 0                ;; compare commmand to 0 to look for null cmd
    je         idle                 ;; jump to idle if no command request

;;
;; A command has been found in the cmd mailbox
;; Now extract the command characteristics
;;
;; get R/W
    ldr        g5, cmd_A             ;; load the command into reg g5
    ldr        g4, BIT_RW            ;; load g4 with the AND bit mask for R/W
    and        g5, g4                ;; AND the mask with the command in g5
    shri       g5, 1                 ;; shift g5 right by 1 bit
    mov        g1, g5                ;; g1 represents 0x3=df_Write, 0x2=df_Read, 0x1=fb_Write, 0x0=fb_Read

;; get Address
    ldr        g5, arg_A             ;; load the argument into reg g5
    ldr        g4, BIT_ADDRESS       ;; load g4 with the AND bit mask for Address
    and        g5, g4                ;; AND the mask with the argument in g5
    mov        g2, g5                ;; g2 represents Address
    
;; call the do_cmd subroutine
;;
    jsr        do_cmd                ;; process the I2C command

;; the do_cmd subroutine set the proper interrupt bit so now wait to be cleared
    wint       0, 16                ;; wait for interrupt to be cleared

;; return to the idle loop
    jmp        idle                ;; jump to the idle loop

;;
;; Code for the do_cmd subroutine follows
;; g1 represents 1=Write, 0=Read
do_cmd:
    ;;Check the subcommand bits

;; write - jump to write start
    cmpi       g1, cmd_fb_write
    je         WrStrt
    cmpi       g1, cmd_df_write
    je         WrStrt
;; read - jump to read start
    cmpi       g1, cmd_fb_read
    je         RdStrt
    jsr        RdStrt
    rts

;;---------------------------------------------------------------------------
;; Write(FB/DF)
;; R/W, Address, WriteData
;;
;; input reg:
;;   g1 = R/W
;;   g2 = address
;; output reg:
;;   Ȃ
;; reg write:
;;   g0 = bits per byte counter
;;   g3 = R/WaddressInterval킹Mf[^̌,Parity
;;   g4 = Write Data
;;   g5 = Misc
WrStrt:
    ldi        g3, 0               ;; 0g3ɃRs[
    or         g3, g2              ;; g3g2(address)ORƂ
    ldi        g5, _addr_writedata ;; WriteData Addr
    ldri       g4, g5              ;; load g4 from WriteData Addr
    ldi        bptr0, 7            ;; bptr0WX^7ݒ
    ldi        g0, 8               ;; MbitJE^(JEg_E)
    
    ;; R/W, Address
loopWrRwAddrInterval:
    sdat       out, pin0, g3, gpio_data_out, uSec_0_125  ;; g3bptr0Ŏw肳Ăbit OESData to g3(bptr0) with OE, 0.125 uSec delay
    tck        out, gpio_clk, uSec_0_125                 ;; CLKlow delay 0.125us
    tck        out, gpio_clk, uSec_0                     ;; toggle CLK high with delay 0us
    subi       g0, 1                                     ;; g01fNg
    cmpi       g0, 0                                     ;; If
    jne        loopWrRwAddrInterval                      ;; 0ȊOȂloopRwjump

    ;; WriteDatȃM
    ldi        bptr0, 7           ;; bptr0WX^7ݒ
    ldi        g0, 8              ;; MbitJE^(JEg_E)

loopWrData:
    sdat       out, pin0, g4, gpio_data_out, uSec_0_125  ;; SData to g4(bptr0) with OE, 0.125 uSec delay
    tck        out, gpio_clk, uSec_0_125                 ;; toggle CLK low with delay 0.125
    tck        out, gpio_clk, uSec_0		         ;; toggle CLK high with delay 0us
    subi       g0, 1                                     ;; g01fNg
    cmpi       g0, 0                                     ;; If
    jne        loopWrData                                ;; 0ȊOȂloopWrDatajump
    
    ;; SDENB=H->L
    sgpio      out, 1, gpio_sdenb, uSec_0_25    ;; SDENB=H
    sgpio      out, 0, gpio_sdenb, uSec_0       ;; SDENB=L

    ;; success
    jsr        done                  ;; jump to done to terminate command
    sint       success, 0            ;; set int 0 - success
    rts                              ;; return from subroutine
;; ****** DONE WRITE ****

;;---------------------------------------------------------------------------
;; READ(FB/DF)
;; R/W, Address, ReadData
;; Parity`FbN
;; input reg: g1 - R/W, g2 - address
;; reg write:
;;   g0 = bits per byte counter
;;   g3 = R/WaddressInterval킹Mf[^̌,Parity
;;   g4 = Read Data
;;   g5 = Misc
RdStrt:
    ldi        g3, 0               ;; 0g3ɃRs[
    or         g3, g2              ;; g3g2(address)ORƂ
    ldi        g4, 0               ;; Read Data init
    ldi        bptr0, 7            ;; bptr0WX^7ݒ
    ldi        g0, 8               ;; MbitJE^(JEg_E)

    sgpio      out, 0, gpio_sdenb, uSec_0_5    ;; SDENB=L
    
    ;; R/W, Address, C^[ȏM
loopRdRwAddrInterval:
    sdat       out, pin0, g3, gpio_data_out, uSec_0_125  ;; g3bptr0Ŏw肳Ăbit OESData to g3(bptr0) with OE, 0.125 uSec delay
    tck        out, gpio_clk, uSec_0_125                 ;; CLKlow delay 0.125
    tck        out, gpio_clk, uSec_0                     ;; toggle CLK high with delay 0us
    subi       g0, 1                                     ;; g01fNg
    cmpi       g0, 0                                     ;; If
    jne        loopRdRwAddrInterval                      ;; 0ȊOȂloopRwjump

    ;; DummyDatȃM
    ldi        g5, 0               ;; Dummy Data init
    ldi        bptr0, 7           ;; bptr0WX^7ݒ
    ldi        g0, 8              ;; MbitJE^(JEg_E)

loopWrDummy:
    sdat       out, pin0, g5, gpio_data_out, uSec_0_125  ;; SData to g4(bptr0) with OE, 0.125 uSec delay
    tck        out, gpio_clk, uSec_0_125                 ;; toggle CLK low with delay 0
    tck        out, gpio_clk, uSec_0		         ;; toggle CLK high with delay 0.125us
    subi       g0, 1                                     ;; g01fNg
    cmpi       g0, 0                                     ;; If
    jne        loopWrDummy                                ;; 0ȊOȂloopWrDatajump
    
    ;; SDENB=L->H->L
    sgpio      out, 1, gpio_sdenb, uSec_0_25   ;; SDENB=H
    sgpio      out, 0, gpio_sdenb, uSec_0_125  ;; SDENB=L Clock̔

    ;; ReadData̎M
    ldi        bptr0, 7           ;; bptr0WX^15ݒ
    ldi        g0, 8              ;; MbitJE^(JEg_E)

loopRdData:
    tck        out, gpio_clk, uSec_0              ;; toggle CLK High with delay 0.125us
    rdat       pin0, g4, gpio_data_in, uSec_0_125 ;; ReadData to g4(bptr0) with 0.125 uSec delay
    tck        out, gpio_clk, uSec_0_125          ;; toggle CLK Low with delay 0us
    subi       g0, 1                              ;; g01fNg
    cmpi       g0, 0                              ;; If
    jne        loopRdData                         ;; 0ȊOȂloopWrDatajump
    
    ;; ReadDataSRAMi[
    str        g4, _addr_readdata  ;; [hf[^SRAMɊi[
    ;; success
    jsr        done
    sint       success, 0
    rts
;; ****** DONE READ ****

;;
;; RSCI command has been completed
;;
done:
    ldi        g5, 0                ;; load g5 with 0 for a null command
    str        g5, arg_A            ;; clear the args
    str        g5, arg_B
    str        g5, cmd_A            ;; clear the command mailbox
    str        g5, cmd_B

    rts                             ;; return from the do_cmd subroutine

;;---------------------------------------------------------------------------
;;
;; CONSTANTS DATA SECTION
;;
BIT_RW            data    0x0006    ;; used as a bit AND mask for Read/Write bit
BIT_ADDRESS       data    0x00ff    ;; used as a bit AND mask for address
