/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

/** 
* \file afe_wm8213.h
* 
* \brief AFE driver for wolfson micro 8213 AFE.
* 
* This driver uses a SCCP-lite interface to interact with the 
* AFE's registers.
* 
**/

#ifndef INC_AFE_WM8213_H
#define INC_AFE_WM8213_H

typedef struct
{
    uint8_t setup1;
    uint8_t setup2;
    uint8_t setup3;
    uint8_t setup4;
    uint8_t setup5;
    uint8_t setup6;

    uint8_t dac_red;
    uint8_t dac_green;
    uint8_t dac_blue;

    uint8_t pga_lsb_red;
    uint8_t pga_lsb_green;
    uint8_t pga_lsb_blue;
    uint8_t pga_msb_red;
    uint8_t pga_msb_green;
    uint8_t pga_msb_blue;

} afe_wm8213_config_t;

#endif // INC_AFE_WM8213_H

