/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


 
#ifndef _JPEG_MESSAGE_H
#define _JPEG_MESSAGE_H

#define MQ_NAME_0 "/scanapp_mq_0"
#define MQ_NAME_1 "/scanapp_mq_1"

struct scan_message_s
{
   char output_filename[256];
   char mq_name[256];
};

typedef enum
{
    SCAN_STRIP_DATA =   0,
    SCAN_PAGE_START =   1,
    SCAN_PAGE_END = 	2,
    SCAN_THRD_STOP = 	3,
    SCAN_DATA_TYPE_END_OF_ENUM

} jpeg_data_type_t;

struct meta_data_s 
{
   uint32_t pixel_width;
   uint32_t bits_per_pixel;
   uint32_t num_rows;
   bool last_buffer;
};

struct scan_data_s
{
   jpeg_data_type_t data_type;
   struct meta_data_s meta_data;
   struct dma_alloc_s dma_alloc;
};

#endif  // _JPEG_MESSAGE_H
