/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include "jpeg_page_adaptor.h"
#include "jpeg_strip_adaptor.h"
#include "dma_buffer.h"
#include <string.h>

void jpeg_recv_strip(struct jpeg_page_adaptor *page,
                     struct jpeg_strip_adaptor *strip, void *blob)
{
    if (strip && strip->recv_strip) 
    {
        strip->recv_strip(page, strip, blob);
    }
}

void jpeg_send_strip(struct jpeg_page_adaptor *page,
                     struct jpeg_strip_adaptor *strip, void *blob)
{
    if (strip && strip->send_strip) 
    {
        strip->send_strip(page, strip, blob);
    }
}

struct jpeg_strip_adaptor *construct_jpeg_strip_adaptor(struct jpeg_strip_adaptor *reuse_if_not_null)
{
    struct jpeg_strip_adaptor *jsa = 0;

    if (reuse_if_not_null)
        jsa = reuse_if_not_null;
    else
        jsa =
            (struct jpeg_strip_adaptor *)
            MEM_MALLOC(sizeof(struct jpeg_strip_adaptor));
    if (!jsa)
        return 0;
    memset(jsa, 0, sizeof(struct jpeg_strip_adaptor));

    return (struct jpeg_strip_adaptor *) jsa;
}

//eof jpeg_strip_adaptor.c
