#!/usr/bin/python
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2011-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

# 


# Scan block registers as lambdas.  Uses a cheap hack with globals() to get
# names/values into a hash.
# 
# davep 26-July-06
# $Id: scif.py 406 2008-05-13 13:40:07Z davep $

import sys

#
# from scanhw.h via m2l.py
#
# Anything starting with "SCIF_" will be parsed out of globals() and put into a
# hash
#
SCIF_BYTE_24 = lambda x :  (((x) & 0xFFL) << 24) # Byte at bit 24
SCIF_BYTE_16 = lambda x :  (((x) & 0xFFL) << 16) # Byte at bit 16
SCIF_BYTE_08 = lambda x :  (((x) & 0xFFL) <<  8) # Byte at bit 08
SCIF_BYTE_00 = lambda x :  (((x) & 0xFFL) <<  0) # Byte at bit 00
SCIF_SCFG1_P1CLKEN = lambda x :       (((x) & 0x1L) << 31) # Sensor P1CLK Enable
SCIF_SCFG1_P2CLKEN = lambda x :       (((x) & 0x1L) << 30) # Sensor P2CLK Enable
SCIF_SCFG1_RSCLKEN = lambda x :       (((x) & 0x1L) << 29) # Sensor RSClk Enable
SCIF_SCFG1_CPCLKEN = lambda x :       (((x) & 0x1L) << 28) # Sensor CPClk Enable
SCIF_SCFG1_MCLKEN = lambda x :        (((x) & 0x1L) << 27) # AFE Master Clock Enable
SCIF_SCFG1_VSCLKEN = lambda x :       (((x) & 0x1L) << 26) # AFE Sample Clock Enable
SCIF_SCFG1_CLCKEN = lambda x :        (((x) & 0x1L) << 25) # AFE Clamp Clock Enable
SCIF_SCFG1_LCLMPEN = lambda x :       (((x) & 0x1L) << 24) # AFE Line Clamp Clock Enable
SCIF_SCFG1_LEDEN_B = lambda x :       (((x) & 0x1L) << 23) # Enable LEDB
SCIF_SCFG1_LEDEN_G = lambda x :       (((x) & 0x1L) << 22) # Enable LEDG
SCIF_SCFG1_LEDEN_R = lambda x :       (((x) & 0x1L) << 21) # Enable LEDR
SCIF_SCFG1_LEDEN = lambda x :         (((x) & 0x7L) << 21) # Enable LEDR, LEDG, LEDB = LEDEN[0:2]
SCIF_SCFG1_BULBEN = lambda x :        (((x) & 0x1L) << 20) # Enable Bulb PWM generator on LEDB pin
SCIF_SCFG1_SSMEN_P1CLK = lambda x :   (((x) & 0x1L) << 19) # P1CLK Start Mask Enable
SCIF_SCFG1_SSMEN_P2CLK = lambda x :   (((x) & 0x1L) << 18) # P2CLK Start Mask Enable
SCIF_SCFG1_SSMEN_RSCLK = lambda x :   (((x) & 0x1L) << 17) # RSCLK Start Mask Enable
SCIF_SCFG1_SSMEN_CPCLK = lambda x :   (((x) & 0x1L) << 16) # CPCLK Start Mask Enable
SCIF_SCFG1_SSMEN = lambda x :         (((x) & 0xFL) << 16) # Sensor Clock Start Signal Mask Enables
SCIF_SCFG1_SMPOL_P1CLK = lambda x :   (((x) & 0x1L) << 15) # P1CLK Start Mask Polarity
SCIF_SCFG1_SMPOL_P2CLK = lambda x :   (((x) & 0x1L) << 14) # P2CLK Start Mask Polarity
SCIF_SCFG1_SMPOL_RSCLK = lambda x :   (((x) & 0x1L) << 13) # RSCLK Start Mask Polarity
SCIF_SCFG1_SMPOL_CPCLK = lambda x :   (((x) & 0x1L) << 12) # CPCLK Start Mask Polarity
SCIF_SCFG1_SMPOL = lambda x :         (((x) & 0xFL) << 12) # Sensor Clock Start Signal Mask Polarities
SCIF_SCFG1_P1APOL = lambda x :        (((x) & 0x1L) << 11) # Sensor P1 Clock Add Polarity
SCIF_SCFG1_SPPOL = lambda x :         (((x) & 0x1L) <<  8) # Start Pulse Polarity
SCIF_SCFG1_SCPOL_P1CLK = lambda x :   (((x) & 0x1L) <<  7) # P1CLK Clock Polarity
SCIF_SCFG1_SCPOL_P2CLK = lambda x :   (((x) & 0x1L) <<  6) # P2CLK Clock Polarity
SCIF_SCFG1_SCPOL_RSCLK = lambda x :   (((x) & 0x1L) <<  5) # RSCLK Clock Polarity
SCIF_SCFG1_SCPOL_CPCLK = lambda x :   (((x) & 0x1L) <<  4) # CPCLK Clock Polarity
SCIF_SCFG1_SCPOL = lambda x :         (((x) & 0xFL) <<  4) # Sensor Clock Polarities
SCIF_SCFG1_ACPOL_MCLK = lambda x :    (((x) & 0x1L) <<  3) # MCLK Clock Polarity
SCIF_SCFG1_ACPOL_VSCLK = lambda x :   (((x) & 0x1L) <<  2) # VSCLK Clock Polarity
SCIF_SCFG1_ACPOL_CD1CLK = lambda x :  (((x) & 0x1L) <<  1) # CD1CLK Clock Polarity
SCIF_SCFG1_ACPOL_LCCLK = lambda x :   (((x) & 0x1L) <<  0) # LCCLK Clock Polarity
SCIF_SCFG1_ACPOL = lambda x :         (((x) & 0xFL) <<  0) # AFE Clock Polarities
SCIF_SCFG2_CMODE = lambda x :     (((x) & 0x01L) << 31) # Color Mode (Mono or Color)
SCIF_SCFG2_STYPE = lambda x :     (((x) & 0x01L) << 30) # Sensor Type (CCD or CIS)
SCIF_SCFG2_SSEL = lambda x :      (((x) & 0x03L) << 28) # Sensor Select, SENSOR_SEL1 & 2 pins
SCIF_SCFG2_AFEWIDTH = lambda x :  (((x) & 0x01L) << 27) # AFE Data Width (4-bit or 8-bit)
SCIF_SCFG2_PIXPER = lambda x :    (((x) & 0xFFL) <<  0) # Pixel Period
SCIF_SCFG3_P1RISE = lambda x :   (((x) & 0x3L) << 30) # P1 Rising Edge Delay
SCIF_SCFG3_P1FALL = lambda x :   (((x) & 0x3L) << 28) # P1 Falling Edge Delay
SCIF_SCFG3_P2RISE = lambda x :   (((x) & 0x3L) << 26) # P2 Rising Edge Delay
SCIF_SCFG3_P2FALL = lambda x :   (((x) & 0x3L) << 24) # P2 Falling Edge Delay
SCIF_SCFG3_RSRISE = lambda x :   (((x) & 0x3L) << 22) # RS Rising Edge Delay
SCIF_SCFG3_RSFALL = lambda x :   (((x) & 0x3L) << 20) # RS Falling Edge Delay
SCIF_SCFG3_CPRISE = lambda x :   (((x) & 0x3L) << 18) # CP Rising Edge Delay
SCIF_SCFG3_CPFALL = lambda x :   (((x) & 0x3L) << 16) # CP Falling Edge Delay
SCIF_SCFG3_MCRISE = lambda x :   (((x) & 0x3L) << 14) # MC Rising Edge Delay
SCIF_SCFG3_MCFALL = lambda x :   (((x) & 0x3L) << 12) # MC Falling Edge Delay
SCIF_SCFG3_VSRISE = lambda x :   (((x) & 0x3L) << 10) # VS Rising Edge Delay
SCIF_SCFG3_VSFALL = lambda x :   (((x) & 0x3L) <<  8) # VS Falling Edge Delay
SCIF_SCFG3_CD1RISE = lambda x :  (((x) & 0x3L) <<  6) # CD1 Rising Edge Delay
SCIF_SCFG3_CD1FALL = lambda x :  (((x) & 0x3L) <<  4) # CD1 Falling Edge Delay
SCIF_SCFG3_SPRISE = lambda x :   (((x) & 0x3L) <<  2) # SP Rising Edge Delay
SCIF_SCFG3_SPFALL = lambda x :   (((x) & 0x3L) <<  0) # SP Falling Edge Delay
SCIF_SCTRL_CMDQEN = lambda x :   (((x) & 0x1L) << 6) # Command Queue Enable
SCIF_SCTRL_TERMCMD = lambda x :  (((x) & 0x1L) << 5) # Terminate Command
SCIF_SCTRL_SRESET = lambda x :   (((x) & 0x1L) << 4) # Soft Reset
SCIF_SCTRL_AFEPIE = lambda x :   (((x) & 0x1L) << 3) # AFE Program Complete Interrupt Enable
SCIF_SCTRL_SCMDIE = lambda x :   (((x) & 0x1L) << 2) # Scan Command Interrupt Enable
SCIF_SCTRL_RUN = lambda x :      (((x) & 0x1L) << 1) # Run - Starts execution of the commands
SCIF_SCTRL_SCANEN = lambda x :   (((x) & 0x1L) << 0) # Scan Enable
SCIF_SCMD_RAMP = lambda x :     (((x) & 0x0001L) << 31) # Ramp, Scaling of the PWM outputs
SCIF_SCMD_SDATA = lambda x :    (((x) & 0x0001L) << 30) # Transfer Scan Data
SCIF_SCMD_SMRUN = lambda x :    (((x) & 0x0001L) << 29) # Enable selected stepper motor
SCIF_SCMD_SCLKPER = lambda x :  (((x) & 0x1FFFL) << 16) # Scan Clock Period
SCIF_SCMD_SCANY = lambda x :    (((x) & 0xFFFFL) <<  0) # Scan Lines per Command
SCIF_SSTAT_SCANYR = lambda x :   (((x) & 0xFFFFL) << 16) # Line Count Remaning
SCIF_SSTAT_CMDSTAT = lambda x :  (((x) & 0x0001L) <<  6) # Command Status
SCIF_SSTAT_QEMPTY = lambda x :   (((x) & 0x0001L) <<  5) # Command Queue Empty
SCIF_SSTAT_QFULL = lambda x :    (((x) & 0x0001L) <<  4) # Command Queue Full
SCIF_SSTAT_QOVR = lambda x :    (((x) & 0x0001L) <<  3) # Command Queue Overrun
SCIF_SSTAT_CIOVR = lambda x :    (((x) & 0x0001L) <<  2) # Command Interrupt Overrun
SCIF_SSTAT_AFEPCOMP = lambda x : (((x) & 0x0001L) <<  1) # AFE Program Complete
SCIF_SSTAT_SCMDCOMP = lambda x : (((x) & 0x0001L) <<  0) # Scan Command Complete
SCIF_SIACK_QOVRACK = lambda x :   (((x) & 0x1L) << 3) # Queue Overrun Interrupt Acknowledge
SCIF_SIACK_CIOVRACK = lambda x :  (((x) & 0x1L) << 2) # Command Overrun Interrupt Acknowledge
SCIF_SIACK_AFEPACK = lambda x :   (((x) & 0x1L) << 1) # AFE Program Interrupt Acknowledge
SCIF_SIACK_SCMDACK = lambda x :   (((x) & 0x1L) << 0) # Scan Command Complete Interrupt Acknowledge
SCIF_SCANX_SCANX = lambda x :  (((x) & 0xFFFFL) << 0) # Data Pixels per Scan Line
SCIF_SCYCLE_EXPPER = lambda x :(((x) & 0xFFFFL) <<16) # Exposure Period Data (added mv6120 ASIC)
SCIF_SCYCLE_MSTEPP = lambda x :  (((x) & 0x3FL) << 8) # Scan Clocks per Microstep
SCIF_SCYCLE_SCYCLE = lambda x :  (((x) & 0x3FL) << 0) # Scan Clocks per Scan Cycle
SCIF_STCFG1_SPGEN = lambda x :          (((x) & 0x01L) << 31) # Start Pulse Generation (Pixel or System)
SCIF_STCFG1_MSKEXTD_P1CLK = lambda x :  (((x) & 0x01L) << 27) # P1CLK Clock Mask Extension
SCIF_STCFG1_MSKEXTD_P2CLK = lambda x :  (((x) & 0x01L) << 26) # P2CLK Clock Mask Extension
SCIF_STCFG1_MSKEXTD_RSCLK = lambda x :  (((x) & 0x01L) << 25) # RSCLK Clock Mask Extension
SCIF_STCFG1_MSKEXTD_CPCLK = lambda x :  (((x) & 0x01L) << 24) # CPCLK Clock Mask Extension
SCIF_STCFG1_MSKEXTD = lambda x :        (((x) & 0x0FL) << 24) # Start Signal Mask Extension
SCIF_STCFG1_SSME1 = lambda x :          (((x) & 0xFFL) << 16) # Start Pulse Signal Mask Edge 1
SCIF_STCFG1_SSME2 = lambda x :          (((x) & 0xFFL) <<  0) # Start Pulse Signal Mask Edge 2
SCIF_STCFG2_SPE1 = lambda x :  (((x) & 0xFFL) << 16) # Start Pulse Edge 1
SCIF_STCFG2_SPE2 = lambda x :  (((x) & 0xFFL) <<  0) # Start Pulse Edge 2
SCIF_STCFG3_APH1E1 = lambda x :  (((x) & 0xFFL) << 24) # Additional Phase1 Clock Edge 1
SCIF_STCFG3_APH1E2 = lambda x :  (((x) & 0xFFL) << 16) # Additional Phase1 Clock Edge 2
SCIF_STCFG3_APH1E3 = lambda x :  (((x) & 0xFFL) <<  8) # Additional Phase1 Clock Edge 3
SCIF_STCFG3_APH1E4 = lambda x :  (((x) & 0xFFL) <<  0) # Additional Phase1 Clock Edge 4
SCIF_STCFG4_APH1E5 = lambda x :  (((x) & 0xFFL) << 24) # Additional Phase1 Clock Edge 5
SCIF_STCFG4_APH1E6 = lambda x :  (((x) & 0xFFL) << 16) # Additional Phase1 Clock Edge 6
SCIF_STCFG4_APH1E7 = lambda x :  (((x) & 0xFFL) <<  8) # Additional Phase1 Clock Edge 7
SCIF_STCFG4_APH1E8 = lambda x :  (((x) & 0xFFL) <<  0) # Additional Phase1 Clock Edge 8
SCIF_CCFG_CPMODE = lambda x :  (((x) & 0x01L) << 31) # CCD Clamp Mode (Pixel or Line)
SCIF_CCFG_CLMODE = lambda x :  (((x) & 0x01L) << 30) # AFE Clamp Mode (Pixel or Line)
SCIF_CCFG_CLE1 = lambda x :    (((x) & 0xFFL) << 16) # CCD & AFE Clamp Edge 1
SCIF_CCFG_CCLE2 = lambda x :   (((x) & 0xFFL) <<  8) # CCD Clamp Edge 2
SCIF_CCFG_ACLE2 = lambda x :   (((x) & 0xFFL) <<  0) # AFE Clamp Edge 2
SCIF_SCLK1_P1E1 = lambda x :  (((x) & 0xFFL) << 24) # Phase1 Clock Edge 1
SCIF_SCLK1_P1E2 = lambda x :  (((x) & 0xFFL) << 16) # Phase1 Clock Edge 2
SCIF_SCLK1_P1E3 = lambda x :  (((x) & 0xFFL) <<  8) # Phase1 Clock Edge 3
SCIF_SCLK1_P1E4 = lambda x :  (((x) & 0xFFL) <<  0) # Phase1 Clock Edge 4
SCIF_SCLK2_P1E5 = lambda x :  (((x) & 0xFFL) << 24) # Phase1 Clock Edge 5
SCIF_SCLK2_P1E6 = lambda x :  (((x) & 0xFFL) << 16) # Phase1 Clock Edge 6
SCIF_SCLK2_P1E7 = lambda x :  (((x) & 0xFFL) <<  8) # Phase1 Clock Edge 7
SCIF_SCLK2_P1E8 = lambda x :  (((x) & 0xFFL) <<  0) # Phase1 Clock Edge 8
SCIF_SCLK3_P2E1 = lambda x :  (((x) & 0xFFL) << 24) # Phase2 Clock Edge 1
SCIF_SCLK3_P2E2 = lambda x :  (((x) & 0xFFL) << 16) # Phase2 Clock Edge 2
SCIF_SCLK3_P2E3 = lambda x :  (((x) & 0xFFL) <<  8) # Phase2 Clock Edge 3
SCIF_SCLK3_P2E4 = lambda x :  (((x) & 0xFFL) <<  0) # Phase2 Clock Edge 4
SCIF_SCLK4_P2E5 = lambda x :  (((x) & 0xFFL) << 24) # Phase2 Clock Edge 5
SCIF_SCLK4_P2E6 = lambda x :  (((x) & 0xFFL) << 16) # Phase2 Clock Edge 6
SCIF_SCLK4_P2E7 = lambda x :  (((x) & 0xFFL) <<  8) # Phase2 Clock Edge 7
SCIF_SCLK4_P2E8 = lambda x :  (((x) & 0xFFL) <<  0) # Phase2 Clock Edge 8
SCIF_SCLK5_RSE1 = lambda x :  (((x) & 0xFFL) << 24) # RS Clock Edge 1
SCIF_SCLK5_RSE2 = lambda x :  (((x) & 0xFFL) << 16) # RS Clock Edge 2
SCIF_SCLK5_RSE3 = lambda x :  (((x) & 0xFFL) <<  8) # RS Clock Edge 3
SCIF_SCLK5_RSE4 = lambda x :  (((x) & 0xFFL) <<  0) # RS Clock Edge 4
SCIF_SCLK6_CPE1 = lambda x :  (((x) & 0xFFL) << 24) # CP Clock Edge 1
SCIF_SCLK6_CPE2 = lambda x :  (((x) & 0xFFL) << 16) # CP Clock Edge 2
SCIF_SCLK6_CPE3 = lambda x :  (((x) & 0xFFL) <<  8) # CP Clock Edge 3
SCIF_SCLK6_CPE4 = lambda x :  (((x) & 0xFFL) <<  0) # CP Clock Edge 4
SCIF_ACLK1_MCE1 = lambda x :  (((x) & 0xFFL) << 24) # M Clock Edge 1
SCIF_ACLK1_MCE2 = lambda x :  (((x) & 0xFFL) << 16) # M Clock Edge 2
SCIF_ACLK1_MCE3 = lambda x :  (((x) & 0xFFL) <<  8) # M Clock Edge 3
SCIF_ACLK1_MCE4 = lambda x :  (((x) & 0xFFL) <<  0) # M Clock Edge 4
SCIF_ACLK2_MCE5 = lambda x :  (((x) & 0xFFL) << 24) # M Clock Edge 5
SCIF_ACLK2_MCE6 = lambda x :  (((x) & 0xFFL) << 16) # M Clock Edge 6
SCIF_ACLK2_MCE7 = lambda x :  (((x) & 0xFFL) <<  8) # M Clock Edge 7
SCIF_ACLK2_MCE8 = lambda x :  (((x) & 0xFFL) <<  0) # M Clock Edge 8
SCIF_ACLK3_MCE9 = lambda x :   (((x) & 0xFFL) << 24) # M Clock Edge 9
SCIF_ACLK3_MCE10 = lambda x :  (((x) & 0xFFL) << 16) # M Clock Edge 10
SCIF_ACLK3_MCE11 = lambda x :  (((x) & 0xFFL) <<  8) # M Clock Edge 11
SCIF_ACLK3_MCE12 = lambda x :  (((x) & 0xFFL) <<  0) # M Clock Edge 12
SCIF_ACLK4_VSE1 = lambda x :  (((x) & 0xFFL) << 24) # VS Clock Edge 1
SCIF_ACLK4_VSE2 = lambda x :  (((x) & 0xFFL) << 16) # VS Clock Edge 2
SCIF_ACLK4_VSE3 = lambda x :  (((x) & 0xFFL) <<  8) # VS Clock Edge 3
SCIF_ACLK4_VSE4 = lambda x :  (((x) & 0xFFL) <<  0) # VS Clock Edge 4
SCIF_ACLK5_CD1E1 = lambda x :  (((x) & 0xFFL) << 24) # CD1 Clock Edge 1
SCIF_ACLK5_CD1E2 = lambda x :  (((x) & 0xFFL) << 16) # CD1 Clock Edge 2
SCIF_ACLK5_CD1E3 = lambda x :  (((x) & 0xFFL) <<  8) # CD1 Clock Edge 3
SCIF_ACLK5_CD1E4 = lambda x :  (((x) & 0xFFL) <<  0) # CD1 Clock Edge 4
SCIF_LDATA_DS_A = lambda x :  (((x) & 0xFFL) << 24) # Data Sample A
SCIF_LDATA_DC_A = lambda x :  (((x) & 0x1FL) << 16) # Data Code A
SCIF_LDATA_DS_B = lambda x :  (((x) & 0xFFL) <<  8) # Data Sample B
SCIF_LDATA_DC_B = lambda x :  (((x) & 0x1FL) <<  0) # Data Code B
SCIF_PSEQ1_PSEQ1 = lambda x :  (((x) & 0x3FL) << 24) # Pixel Sequence 1
SCIF_PSEQ1_PSEQ2 = lambda x :  (((x) & 0x3FL) << 16) # Pixel Sequence 2
SCIF_PSEQ1_PSEQ3 = lambda x :  (((x) & 0x3FL) <<  8) # Pixel Sequence 3
SCIF_PSEQ1_PSEQ4 = lambda x :  (((x) & 0x3FL) <<  0) # Pixel Sequence 4
SCIF_PSEQ2_PSEQ5 = lambda x :  (((x) & 0x3FL) <<  8) # Pixel Sequence 5
SCIF_PSEQ2_PSEQ6 = lambda x :  (((x) & 0x3FL) <<  0) # Pixel Sequence 6
SCIF_BPWM_BPWMPER = lambda x :  (((x) & 0xFFFL) << 16) # Bulb PWM Period
SCIF_BPWM_BPWMDTY = lambda x :  (((x) & 0xFFFL) <<  0) # Bulb PWM Duty Cycle
SCIF_LPWM_LPWMDIV = lambda x :  (((x) & 0x07L) << 24) # LED PWM Divisor
SCIF_LPWM_LED0DTY = lambda x :  (((x) & 0x7FL) << 16) # LED0 PWM Duty Cycle
SCIF_LPWM_LED1DTY = lambda x :  (((x) & 0x7FL) <<  8) # LED1 PWM Duty Cycle
SCIF_LPWM_LED2DTY = lambda x :  (((x) & 0x7FL) <<  0) # LED2 PWM Duty Cycle
SCIF_LED_POS = lambda x :  (((x) & 0xFFFFL) << 16) # LED Positive Edge Delay
SCIF_LED_NEG = lambda x :  (((x) & 0xFFFFL) <<  0) # LED Negative Edge Delay
SCIF_MCFG_DATAEN = lambda x :   (((x) & 0x1L) << 15) # Data Transfer Enable
SCIF_MCFG_LSMODE = lambda x :   (((x) & 0x3L) << 13) # DC Motor Line Sync Mode
SCIF_MCFG_M1TYPE = lambda x :   (((x) & 0x1L) << 11) # Motor 1 Type
SCIF_MCFG_SM1TYPE = lambda x :  (((x) & 0x7L) <<  8) # Stepper Motor 1 Driver Type
SCIF_MCFG_M2TYPE = lambda x :   (((x) & 0x1L) <<  3) # Motor 2 Type
SCIF_MCFG_SM2TYPE = lambda x :  (((x) & 0x7L) <<  0) # Stepper Motor 2 Driver Type
SCIF_6219MCTRL_M1STEPEN = lambda x :  (((x) & 0x1L) << 25) # Motor 1 Step Enable
SCIF_6219MCTRL_M1RST = lambda x :     (((x) & 0x1L) << 24) # Motor 1 Reset
SCIF_6219MCTRL_M1DIS = lambda x :     (((x) & 0x1L) << 23) # Motor 1 Disable
SCIF_6219MCTRL_M1HOLD = lambda x :    (((x) & 0x1L) << 22) # Motor 1 Hold
SCIF_6219MCTRL_M1MODE = lambda x :    (((x) & 0x1L) << 21) # Motor 1 Mode
SCIF_6219MCTRL_M1DIR = lambda x :     (((x) & 0x1L) << 20) # Motor 1 Direction
SCIF_6219MCTRL_M1SCALE = lambda x :   (((x) & 0xFL) << 16) # Motor 1 Scaling Factor
SCIF_6219MCTRL_M2STEPEN = lambda x :  (((x) & 0x1L) <<  9) # Motor 2 Step Enable
SCIF_6219MCTRL_M2RST = lambda x :     (((x) & 0x1L) <<  8) # Motor 2 Reset
SCIF_6219MCTRL_M2DIS = lambda x :     (((x) & 0x1L) <<  7) # Motor 2 Disable
SCIF_6219MCTRL_M2HOLD = lambda x :    (((x) & 0x1L) <<  6) # Motor 2 Hold
SCIF_6219MCTRL_M2MODE = lambda x :    (((x) & 0x1L) <<  5) # Motor 2 Mode
SCIF_6219MCTRL_M2DIR = lambda x :     (((x) & 0x1L) <<  4) # Motor 2 Direction
SCIF_6219MCTRL_M2SCALE = lambda x :   (((x) & 0xFL) <<  0) # Motor 2 Scaling Factor
SCIF_3967MCTRL_MSTEP = lambda x :     (((x) & 0x1FL) << 24) # Motor 1 & 2 Step Pulse Width
SCIF_3967MCTRL_M1STEPEN = lambda x :  (((x) & 0x01L) << 20) # Motor 1 Step Enable
SCIF_3967MCTRL_M1DIR = lambda x :     (((x) & 0x01L) << 19) # Motor 1 Direction
SCIF_3967MCTRL_M1S = lambda x :       (((x) & 0x03L) << 17) # Motor 1 Step Rate Select
SCIF_3967MCTRL_M1SLEEP = lambda x :   (((x) & 0x01L) << 16) # Motor 1 Not Sleep
SCIF_3967MCTRL_M2STEPEN = lambda x :  (((x) & 0x01L) <<  4) # Motor 2 Step Enable
SCIF_3967MCTRL_M2DIR = lambda x :     (((x) & 0x01L) <<  3) # Motor 2 Direction
SCIF_3967MCTRL_M2S = lambda x :       (((x) & 0x03L) <<  1) # Motor 2 Step Rate Select
SCIF_3967MCTRL_M2SLEEP = lambda x :   (((x) & 0x01L) <<  0) # Motor 2 Not Sleep
SCIF_62209MCTRL_MCLK = lambda x :      (((x) & 0x1FL) << 24) # Motor 1 & 2 Clock Pulse Width
SCIF_62209MCTRL_M1STEPEN = lambda x :  (((x) & 0x01L) << 21) # Motor 1 Step Enable
SCIF_62209MCTRL_M1CCW = lambda x :     (((x) & 0x01L) << 20) # Motor 1 Direction
SCIF_62209MCTRL_M1DM = lambda x :      (((x) & 0x07L) << 17) # Motor 1 Drive Mode Select
SCIF_62209MCTRL_M1EN = lambda x :      (((x) & 0x01L) << 16) # Motor 1 Enable (Active Low?)
SCIF_62209MCTRL_M2STEPEN = lambda x :  (((x) & 0x01L) <<  5) # Motor 2 Step Enable
SCIF_62209MCTRL_M2CCW = lambda x :     (((x) & 0x01L) <<  4) # Motor 2 Direction
SCIF_62209MCTRL_M2DM = lambda x :      (((x) & 0x07L) <<  1) # Motor 2 Drive Mode Select
SCIF_62209MCTRL_M2EN = lambda x :      (((x) & 0x01L) <<  0) # Motor 2 Enable (Active Low?)
SCIF_MPWMCFG_M1PDIV = lambda x :    (((x) & 0x001FL) << 24) # Motor1 PWM Divider
SCIF_MPWMCFG_M2PDIV = lambda x :    (((x) & 0x001FL) << 16) # Motor2 PWM Divider
SCIF_MPWMCFG_PWMZEROI = lambda x :  (((x) & 0xFFFFL) <<  0) # PWM Zero Current Select
SCIF_PCTRL_24 = lambda x :  (((x) & 0xFFL) << 24) # Byte at bit 24
SCIF_PCTRL_16 = lambda x :  (((x) & 0xFFL) << 16) # Byte at bit 16
SCIF_PCTRL_08 = lambda x :  (((x) & 0xFFL) <<  8) # Byte at bit 08
SCIF_PCTRL_00 = lambda x :  (((x) & 0xFFL) <<  0) # Byte at bit 00
SCIF_AFEPC_T = lambda x :        (((x) & 0x01L) << 31) # AFE Single Transfer
SCIF_AFEPC_AUTO = lambda x :     (((x) & 0x01L) << 30) # AFE Auto Transfer
SCIF_AFEPC_SENINIT = lambda x :  (((x) & 0x01L) << 28) # Serial Enable Initial Value
SCIF_AFEPC_SENCTRL = lambda x :  (((x) & 0x03L) << 26) # Serial Enable Control
SCIF_AFEPC_SERDCFG = lambda x :  (((x) & 0x03L) << 24) # Serial Data Configuration
SCIF_AFEPC_SCLKDIV = lambda x :  (((x) & 0xFFL) << 16) # System Clock Divisor
SCIF_AFEPC_NBITS = lambda x :    (((x) & 0x1FL) <<  8) # Total Transfer Bits
SCIF_AFEPC_NADDR = lambda x :    (((x) & 0x0FL) <<  4) # Number of Address Bits
SCIF_AFEPC_NDATA = lambda x :    (((x) & 0x0FL) <<  0) # Number of Data Bits
SCIF_AFEPD_RDWR = lambda x :     (((x) & 0x01L) << 31) # Read/Write Serial Data
SCIF_AFEPD_CCODE = lambda x :    (((x) & 0x03L) << 28) # Color Code in Auto Mode
SCIF_AFEPD_CLOC = lambda x :     (((x) & 0x0FL) << 24) # Location of Color Code (MSB)
SCIF_AFEPD_DATA = lambda x :     (((x) & 0xFFFFFFL) << 0) # Serial Data
FPGA_FHICR_ARUBA_MOT = lambda x :  (((x) & 0x1L) << 12) # Aruba motor pinout (0=norm, 1=option)
FPGA_FHICR_CCD_RS = lambda x :     (((x) & 0x1L) <<  8) # enable CCD_RS on LEDR signal
FPGA_FHICR_CCD_MODE = lambda x :   (((x) & 0x1L) <<  4) # CCD Mode Select (Aruba only)
FPGA_FHICR_SONGB = lambda x :      (((x) & 0x1L) <<  0) # 0 = Aruba, 1 = Sgbd

names = ( "scfg1", "scfg2", "scfg3", "sctrl", "scmd", "sstat", "siack",
    "scanx", "scycle", "stcfg1", "stcfg2", "stcfg3", "stcfg4", "ccfg", "sclk1",
    "sclk2", "sclk3", "sclk4", "sclk5", "sclk6", "aclk1", "aclk2", "aclk3",
    "aclk4", "aclk5", "ldata", "pseq1", "pseq2", "bwpm", "lpwm", "led",
    "mcfg", "6219mctrl", "3967mctrl", "62209mctrl", "mpwmcfg", "pctrl", "afepc", "afepd" )

# AFE Load Data codes; 3 bits each; 16-bit value "ABCD" 
# (note there is no leading "SCIF_" on the names!
LDATA_CODE_CLEAR =    0  # clear all bits */
LDATA_CODE_AB_BITS =  1  # "AB", 8 MS bits */
LDATA_CODE_CD_BITS =  2  # "CD", LS bits */
LDATA_CODE_ABCD_BITS =  3  # "ABCD" (not implemented) */
LDATA_CODE_A_BITS =   4  # "A", 4 MS bits */
LDATA_CODE_B_BITS =   5  # "B", next 4 bits */
LDATA_CODE_C_BITS =   6  # "C", next 4 bits */
LDATA_CODE_D_BITS =   7  # "D", 4 LS bits */
LDATA_CODE_LOAD_COMPL =   (1<<3) # load complete */
LDATA_CODE_SEQ_COMPL =    (1<<4) # sequence complete */

def make_register( name, symbols ) :

    # make an array of our register fields; array will be of tuples:
    #   [0] is the name
    #   [1] is the lambda
    register_fields = [ ( symbol, symbols[symbol] ) for symbol in \
            symbols.keys() if symbol.find( name )==0 ] 

    # sort by increasing bits position 
    register_fields.sort( lambda x,y : cmp( y[1](-1), x[1](-1) ) )

    return register_fields

def make_all_registers( ) :

    # globals returns a hash
    g = globals()

    scif = {}
    for n in names :
        scif[n] = make_register( "SCIF_" + n.upper(), g )

    return scif

def print_register( register ) :
    for field in register :
        print "%#010x %s" % (field[1](-1), field[0] )

def decode_register( register, value ) :
    for field in register :
        bits = field[1](-1)
        if bits & value : 
            print "%#010x %#010x %s" % (field[1](-1), bits&value, field[0] )

if __name__ == '__main__' :
    scif = make_all_registers()
#    print scif

    name = sys.argv[1]
    value = int( sys.argv[2], 16 )
    print name, value

    print_register( scif[name] )

    decode_register( scif[name], value )

