# Python script to parse 'scanalyer' log dumps.
#
# **********************************************************************************
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2010-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ************************************************************************************


import string
import sys
import re
import StringIO
import ctypes
import os
#from pylab import *

CONF_ID = 0
CONF_ENABLED = 2
CONF_DESCR = 3
CONF_FILTER = 4

LOG_VALUE = 0
LOG_ENABLED = 1
LOG_LIST = 2
LOG_DESCR = 3
LOG_FILTER = 4

DATA_ID = 0
DATA_TIME = 1
DATA_VALUE = 2

ROLLOVER_ID = 1
ROLLOVER_VALUE = 65536

def TimestampToSting (time):
  time = time * 1000

  us = time % 1000
  time = time / 1000
  ms = time % 1000
  time = time / 1000
  seconds = time % 60
  time = time / 60
  minutes = time % 60
  time = time / 60
  hours = time 

  return str(hours).rjust(3,"0") + ":" + str(minutes).rjust(2,"0") + ":" + str(seconds).rjust(2,"0") + ":" + str(ms).rjust(3,"0") + ":" + str(us).rjust(3,"0")

def no_filter (n):
    return [n, int(n)]

def hex_filter (n):
    x = int(n)
    uint32 = ctypes.c_uint32(x)
    x = uint32.value
    hstr = "%#x" % x
    return [ hstr, x]

def scan_command_filter (n):
    temp = int(n)
    rows = temp & 0x00ff
    return ["%x" % temp, rows] 

def mtr_state_filter (n):
    mtr_state_vals = [ 'MOT_STATE_STOP',      'MOT_STATE_ACCEL', 
                       'MOT_STATE_WAIT_RAMP', 'MOT_STATE_STEADY', 
                       'MOT_STATE_DECEL',     'MOT_STATE_COAST',
                       'MOT_STATE_DISABLED' ]
    return [mtr_state_vals[int(n)], int(n)]

def cmdq_state_filter (n):
    cmdq_state_vals = [ 'CMDQ_STATE_IDLE',     'CMDQ_STATE_READY_FOR_SCAN',
                        'CMDQ_STATE_SCANNING', 'CMDQ_STATE_START_PAUSE',
                        'CMDQ_STATE_PAUSED',   'CMDQ_STATE_SCAN_STOPPED' ]
    return [cmdq_state_vals[int(n)], int(n)]

def get_basename( filename ) :
    return os.path.splitext( os.path.split( filename )[1] )[0]

#Input file name, also used for output file name with .txt added
File = sys.argv[1]

print "opening file " + "scanalyzer.conf"
myconfigfile = open("scanalyzer.conf", 'r')

print "opening file " + File
myinputfile = open(File, 'rb')

outfilename = os.path.split( File )[1] + "_log.txt"

myoutfile = open( outfilename, 'w')
myoutfile.write("Signal Description".ljust(25) + " " 
                + "Time".ljust(20) + " "
                + "Delta".ljust(20) + " "
                + "Value" + "\n")


logdata = {}
timedata = []

 

#NewLine = myconfigfile.readline() # First line is header, throw away
while 1:
  NewLine = myconfigfile.readline()
  if NewLine[0:7] == "[BEGIN]":
    print "Found begin"
    break

while 1:  
  NewLine = myconfigfile.readline() # Read next line
  if NewLine[0:5] == "[END]":
    print "Found end"
    break

  NewLineSplit = NewLine.split(",")
  logdata[NewLineSplit[CONF_ID]] = [0,int(NewLineSplit[CONF_ENABLED]),[],NewLineSplit[CONF_DESCR],NewLineSplit[CONF_FILTER]]

#Initialize variables:
line_num = 0
LastTime = 0
StartTime = 0
BaseTime = 0

# davep 15-dec-2008 ; better file parsing
# Look for the last instance of "Scanalyzer Dump:" in the file and start
# parsing there
# davep 05-Apr-2013 ; search backwards from bottom of file for most recent
# scanalyzer dump (was searching top-down)
lines = myinputfile.readlines()
startpos = 0
scanalyzer_dump_str = ""
dump_re = re.compile("^\d+,\d+,-?\d+")

# find the last dump
i = len(lines)-1
while i >= 0 :
    if lines[i].startswith( "Scanalyzer Dump" ) :
        startpos = i
        print "found scanalyzer dump at %d" % i
        break
    i -= 1

print lines[startpos]

i = startpos+1
found_line_count = 0
scanalyzer_dump_str = ""
while i < len(lines): 
    if dump_re.match( lines[i] ):
        found_line_count += 1
        scanalyzer_dump_str += lines[i]
#    else :
#        print "ignore {0}".format(lines[i].strip())
    i += 1

print "found lines={0}".format(found_line_count)

#print startpos
#print len(scanalyzer_dump_str)
#print scanalyzer_dump_str[0:100]
myinputfile.close()
myinputfile = StringIO.StringIO( scanalyzer_dump_str )
#sys.exit(0)
# end davep 15-dec-2008

while 1: #Scan through input file one line at a time
  NewLine = myinputfile.readline() # Read next line
  if not NewLine: 
    break # Break at end of file

  line_num = line_num + 1 

#  print line_num

  NewLineSplit = NewLine.split(",")

  temp = NewLineSplit[DATA_TIME].strip()
  my_time = int(temp)
  my_id = NewLineSplit[DATA_ID].strip()
  my_value_string = NewLineSplit[DATA_VALUE].strip()
  my_filter = logdata[my_id][LOG_FILTER].strip('\n')


  [my_value_string, my_value] = eval(my_filter)(my_value_string)
  

  NewTime = my_time
  if my_id == "1":
    BaseTime = BaseTime + ROLLOVER_VALUE
    NewTime = BaseTime + NewTime
    LastTime = NewTime
    continue

  NewTime = BaseTime + NewTime

  if (line_num == 1):
      StartTime = NewTime

  myoutfile.write(logdata[my_id][LOG_DESCR].strip().ljust(25) + " " 
                  + TimestampToSting(NewTime).ljust(20) + " "
                  + str(NewTime - LastTime).ljust(20) + " "
#                  + TimestampToSting(NewTime - LastTime).ljust(20) + " "
                  + my_value_string + "\n")
                  

  #save old state
  timedata.append(NewTime)
  for k, v in logdata.iteritems():
    if logdata[k][LOG_ENABLED] == 1:
      logdata[k][LOG_LIST].append(logdata[k][LOG_VALUE])

  logdata[my_id][LOG_VALUE] = my_value

  if (LastTime == NewTime):
    if logdata[my_id][LOG_ENABLED] == 1:
      logdata[my_id][LOG_LIST][-1] = my_value
  else:

    timedata.append(NewTime)
    for k, v in logdata.iteritems():
      if logdata[k][LOG_ENABLED] == 1:
        logdata[k][LOG_LIST].append(logdata[k][LOG_VALUE])


  LastTime = NewTime




# Close files
myinputfile.close()
myconfigfile.close()
myoutfile.close()

print "wrote", outfilename

#need to calculate the number of plots (# of enabled signals)

exit(0)

#this generates the plot
i = 1
for k, v in logdata.iteritems():
  if logdata[k][LOG_ENABLED] == 1:
    print len(timedata)
    print len(logdata[k][LOG_LIST])
    #ax1 = subplot(len(logdata),1,i)
    ax1 = subplot(1,1,1)
    plot(timedata,logdata[k][LOG_LIST])
    setp( ax1.get_xticklabels(), visible=False)
    i = i+1

figure(1).subplots_adjust(hspace=.02)
show()

