#!/usr/bin/python
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2011-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

# 


# Register class.  Bits with associated names.
#
# Pulled from scan.py into own file.
#
# davep 08-Dec-2007

import bits

class register(object) : 

    def __init__( self, register_value ) :
        self.register_value = register_value

        self.field_values = dict( zip( self.field_names, [0]*len(self.field_names) ))

        self.decode( )

        # Take apart the class name to get the register's name.
        # Class name will look like: <class 'scan.register_scfg1'>
        try : 
            # davep 06-Apr-2011 ; allow child class to set a name (catching
            # AttributeError feels dirty somehow. There might be a better way?)
            f = self.name 
        except AttributeError : 
            self.name = "(unknown)"
        fields= str(self.__class__).split( "." )
        if len(fields) > 0 and fields[-1].startswith("register_") :
            # Convert register_xxx to XXX, e.g., register_sclk1 to SCLK1
            # The rstrip is to clean off the '> from the end.
            self.name = fields[-1].replace( "register_", "").upper().rstrip("'>")

    def __set__( self, obj, value ) : 
        print "__set__"
        assert 0
        
    def decode( self ) :
        # davep 28-Jul-2010 ; back in June I found a better way to do the
        # decode. Finally adding to the base class.
        assert len(self.field_names)==len(self.shift_masks),\
                    (len(self.field_names),len(self.shift_masks))

        # davep 22-Oct-2013 ; more pythonic iteration of fields
        for name,bits in zip(self.field_names,self.shift_masks) :
            bitshift,bitmask = bits
            self.field_values[name] = (self.register_value>>bitshift) & bitmask

            # davep 08-Mar-2011 ; add register fields as class members
            object.__setattr__( self, name, self.field_values[name] )

    def encode( self ): 
        # davep 02-Jun-2011 ; add a way to re-pack a register after modifying
        # the fields
        num32 = 0
        # davep 22-Oct-2013 ; more pythonic iteration of fields
        for name,bits in zip(self.field_names,self.shift_masks) :
            bitshift,bitmask = bits
            value = object.__getattribute__( self, name )
            num32 |= (value&bitmask) << bitshift

        self.register_value = num32
        self.decode()

    def __repr__( self ) :
        s = self.name + " "
        fmt = "{0}={1} "
#        if len(self.field_names)==1 :
#            fmt = "{0}={1:#010x} "
        for name in self.field_names :
            s += fmt.format(name,self.field_values[name])

        return s

    def verbose_print( self ) :
#        print "%s: %#010x" % (self.name, self.register_value )
#        print bits.tobin( self.register_value, 32 )
#        print self

        s = "%s: %#010x\n" % (self.name, self.register_value )
        s += str( bits.tobin( self.register_value, 32 ) )
        s += "\n"
        s += str( self )
#        s += "\n"
        return s

class AddressRegister( register ) : 
    # davep 20-Jun-2013 ; a register with a single field, a pointer.
    # Created to print the value in hex notation rather than default integer.
    def __repr__( self ) :
        s = self.name + " "
        fmt = "{0}={1:#010x} "
        for name in self.field_names :
            s += fmt.format(name,self.field_values[name])
        return s

class four_field_register( register ) : 
    """Several of the clocks are simply four 8-bit fields. Make a nice cheap
       parent class to decode those."""

    # davep 24-Oct-2013 ; add shift_masks so can use parent's decode method
    shift_masks = ( 
        ( 24, 0xff ),
        ( 16, 0xff ),
        (  8, 0xff ),
        (  0, 0xff ),
    )

def make_registers( reglist, class_list ) : 
    return_list = []
    for reg_name,reg_class in class_list :
        if reg_name in reglist :
            obj = reg_class( reglist[reg_name] )
            return_list.append( obj )
            obj = None

    return return_list

