#!/bin/sh
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2014-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

#

usage() {
    echo "dual_scan_demo.sh - script to demo dual scan.  Sends data through icetest."
    echo "usage: ./dual_scan_demo ipaddress_of_device source_image_front source_image_back"
}

if [ $# -ne 3 ] ; then
    usage
    exit 1
fi

IP=$1 
SRC_FILE1=$2
SRC_FILE2=$3
LOG=dual_scan_demo.log
WIDTH=0
HEIGHT=0
STRIP_SIZE=0

echo "Loading scan modules..."
ssh root@$IP "loadscan" > $LOG

echo "Preparing to scan data from an input file..."
#ssh root@$IP "scancmd scan config nocal nocisx nopieiq icefile" >> $LOG
ssh root@$IP "scancmd scan config nocal nocisx icefile" >> $LOG

echo "Starting scan request..."
ssh root@$IP "rm -rf dualpath_intermediate ; mkdir dualpath_intermediate" >> $LOG

ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual --docsrc adfduplex" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual -b 16 --docsrc adfduplex" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual --docsrc fbnsensor" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual -b 16 --docsrc fbnsensor" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual -a 0,0,850,20 --docsrc fbnsensor" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t mono -r 300 -o dual -a 0,0,850,20 -b 16 --docsrc fbnsensor" & >> $LOG
#ssh root@$IP "cd dualpath_intermediate ; runscan -t rgb -r 300 -o dual -a 0,0,850,20 -b 16 --docsrc fbnsensor" & >> $LOG
RUNSCAN_PID=$!

echo "Determine required dimensions..."
rm dev_icefile_dims.txt >> $LOG
sleep 1
ssh root@$IP "cat /dev/icefile > dualpath_intermediate/dev_icefile_dims.txt" >> $LOG
scp root@$IP:dualpath_intermediate/dev_icefile_dims.txt . >> $LOG
WIDTH=`cat dev_icefile_dims.txt | sed -n 's/pixels_per_row=\([0-9]*\)/\1/p'`
HEIGHT=`cat dev_icefile_dims.txt | sed -n 's/total_rows=\([0-9]*\)/\1/p'`
STRIP_SIZE=`cat dev_icefile_dims.txt | sed -n 's/rows_per_buffer=\([0-9]*\)/\1/p'`

echo "Prepare input image ($WIDTH x $HEIGHT: $STRIP_SIZE line strips)..."
rm $SRC_FILE.ice >> $LOG
python dual_icefile_prep.py $SRC_FILE1 $SRC_FILE2 $WIDTH $HEIGHT $STRIP_SIZE dual.ice >> $LOG
gzip dual.ice >> $LOG

echo "Sending input image to device..."
scp dual.ice.gz root@$IP:dualpath_intermediate/
rm dual.ice.gz >> $LOG
ssh root@$IP "sync ; echo 3 > /proc/sys/vm/drop_caches " >> $LOG

echo "Sending input data through scan pipe..."
ssh root@$IP "gunzip -c dualpath_intermediate/dual.ice.gz > /dev/icefile" >> $LOG

wait $RUNSCAN_PID

echo "Retrieving images..."
#scp root@$IP:dualpath_intermediate/*.pgm . >> $LOG
scp root@$IP:dualpath_intermediate/*.p*m . >> $LOG

echo "Cleaning up..."
ssh root@$IP "rm -rf dualpath_intermediate" >> $LOG

