#!/bin/sh
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2014-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

#

usage() {
    echo "copy_path_demo.sh - script to demo running an image through the copy (scan and print) path"
    echo "usage: ./copy_path_demo ipaddress_of_device bw_source_image dpi"
}

if [ $# -ne 3 ] ; then
    usage
    exit 1
fi

IP=$1 
SRC_FILE=$2
DPI=$3
LOG=copy_path_demo.log
WIDTH=0
HEIGHT=0

echo "Loading scan modules..."
ssh root@$IP "loadscan" > $LOG

echo "Preparing to scan data from an input file..."
ssh root@$IP "scancmd scan config nocal nocisx nopieiq icefile" >> $LOG

echo "Starting scan request..."
ssh root@$IP "rm -rf copypath_intermediate ; mkdir copypath_intermediate" >> $LOG
ssh root@$IP "cd copypath_intermediate ; runscan -t mono -r $DPI -m 64 -o page" & >> $LOG
RUNSCAN_PID=$!

echo "Determine required dimensions..."
rm dev_icefile_dims.txt >> $LOG
sleep 1
ssh root@$IP "cat /dev/icefile > copypath_intermediate/dev_icefile_dims.txt" >> $LOG
scp root@$IP:copypath_intermediate/dev_icefile_dims.txt . >> $LOG
WIDTH=`cat dev_icefile_dims.txt | sed -n 's/pixels_per_row=\([0-9]*\)/\1/p'`
HEIGHT=`cat dev_icefile_dims.txt | sed -n 's/total_rows=\([0-9]*\)/\1/p'`

echo "Prepare input image ($WIDTH x $HEIGHT)..."
rm $SRC_FILE.ice >> $LOG
python icefile_prep.py $SRC_FILE $WIDTH $HEIGHT $SRC_FILE.ice >> $LOG
gzip $SRC_FILE.ice >> $LOG

echo "Sending input image to device..."
scp $SRC_FILE.ice.gz root@$IP:copypath_intermediate/
rm $SRC_FILE.ice.gz >> $LOG
ssh root@$IP "sync ; echo 3 > /proc/sys/vm/drop_caches " >> $LOG

echo "Sending input data through scan pipe..."
ssh root@$IP "gunzip -c copypath_intermediate/$SRC_FILE.ice.gz > /dev/icefile" >> $LOG

wait $RUNSCAN_PID

echo "Get ready for PIP..."
ssh root@$IP "modprobe dmaalloc" >> $LOG
ssh root@$IP "mkdir -p /data/dump" >> $LOG
ssh root@$IP "rm /data/dump/page*" >> $LOG

echo "Send previously scanned data through PIP..."
ssh root@$IP "test_file_pip_adaptor_lib 110 copypath_intermediate/" >> $LOG

echo "Retrieving PIP output strips..."
mkdir pip_output_strips >> $LOG
scp root@$IP:/data/dump/page* pip_output_strips/ >> $LOG

echo "Recombine strips into single file..."
ruby catpbm.rb -2 -o $SRC_FILE.copied.pbm -i pip_output_strips/page_p_01\*.pbm >> $LOG

echo "Cleaning up..."
ssh root@$IP "rm /data/dump/page*" >> $LOG
ssh root@$IP "rm -rf copypath_intermediate" >> $LOG
rm -rf pip_output_strips >> $LOG
