#!/usr/bin/env ruby
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2014-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================
# need to read input width and compute height.
require 'optparse'

opts = OptionParser.new

verbose = false
outwidth = 4992
outheight = 6600
infileglob = "temp*.pbm"
outfilename = "out.pbm.out"
fmt = "P4 %d %d\n"
usage = false
graybits = false

# opts.on("-w", "--width VAL", Integer) {|val| outwidth = val}
# opts.on("-h", "--height VAL", Integer) {|val| outheight = val}
opts.on("-v", "--verbose") {|val| verbose = true }
opts.on("-i=ARG", "--infileglob=page_p_02\\*.pnm", String) {|val| infileglob = val}
opts.on("-c", "--ppm" ) {|val| fmt = "P6 %d %d 255\n"}
opts.on("-g", "--pgm" ) {|val| fmt = "P5 %d %d 255\n"}
opts.on("-2", "--pgm" ) {|val| graybits = true; fmt = "P5 %d %d 255\n"}
opts.on("-b", "--pbm" ) {|val| fmt = "P4 %d %d\n"}
opts.on("-o", "--outfilename=page.pnm", String) {|val| outfilename = val}
opts.on("-?", "--help") {|val| usage = true} 
rest = opts.parse(ARGV)
puts rest
puts "concatinate pnm files based on directory file spec \n" if usage
puts "-2 converts 2bit to 8bit gray; -g gray; -c color; -b 1 bit \n" if usage
puts opts.to_s if usage
exit if usage

# sum up the strips to get the height
outheight = 0
infiles = Dir.glob(infileglob).sort
infiles.each do |infilename|
  File.open(infilename) do |infile|
    a = infile.readline()
    s = a.split()
    outheight += s[2].to_i
    outwidth = s[1].to_i
    puts "#{infilename} #{a} h #{outheight} w #{outwidth}" if verbose
  end
end
outwidth = outwidth / 2 if graybits 
puts "h #{outheight} w #{outwidth} --> #{outfilename} \n" if verbose

outarray = [255, 170, 85, 0] # conversion table 2bit - 8bit and invert colorspace.

if ( graybits ) then 
  File.open(outfilename, "w") do |outfile| 
    outfile.printf(fmt, outwidth, outheight)
    printf(fmt, outwidth, outheight)
    # Dir.glob(infileglob) do |infilename|
    infiles.each do |infilename|
      File.open(infilename) do |infile|
        inbytes = 0 
        outbytes = 0
        a = infile.readline()
        #b = infile.read(1) # toss the newline
        infile.each_byte do |abyte|
          # 4 pixels 2bit per pixel converted to 8bit per pixel
          ary = [ outarray[(abyte>>6) & 0x03], outarray[(abyte>>4) & 0x03], outarray[(abyte>>2) & 0x03], outarray[(abyte>>0) & 0x03] ]
          outfile << ary.pack("C*" )  # binary output of 8bit integers.
        end
      end
    end
  end
else
  File.open(outfilename, "w") do |outfile| 
    outfile.printf(fmt, outwidth, outheight)
    Dir.glob(infileglob) do |infilename|
      File.open(infilename) do |infile|
        a = infile.readline()
        #b = infile.read(1) # toss the newline
        outfile.write(infile.read)
      end
    end
  end
end



