#!/usr/bin/python
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2011-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

# 


# Decode a chunk of bits into human readable string. Originally written for
# decoding the scan block registers.
#
# davep 26-July-06
# $Id: bits.py 406 2008-05-13 13:40:07Z davep $

import sys

def tobin( num, maxbits=32 ) :
    s = ""
    for i in range(maxbits) :
        if num & (1<<i) :
            s = "1" + s
        else :
            s = "0" + s
        if (i+1) % 4 == 0 :
            s = " " + s

    # [1:] cuts off the extra " " on the front of the string (lazy)
    return s[1:]

def tohex( num, maxquads ) :
    # works in 4-bit chunks
    
    s = ""
    for i in range(maxquads) :
        quad = (num & (0xf<<(i*4))) >> (i*4)

        s = ("%x" % quad) + s
    
    return "0x"+s

def verbose_print( num ) :
    print("3322 2222 2222 1111 1111 1100 0000 0000")
    print("1098 7654 3210 9876 5432 1098 7654 3210")
    print("---------------------------------------")
    #      0000 0000 0000 0000 1000 1000 0000 1011

    print(tobin( num ))

def main() :
    hexes = {}
    for i in range(16) :
        s = tobin( i, 4 )
        hexes[s] = "%x" % i
    print(hexes)

    try : 
        num = int( sys.argv[1] )
    except ValueError :
        num = int( sys.argv[1], 16 )

    binstr = tobin( num, 32 )
    print(binstr)
    hexstr = "0x"
    for field in binstr.split() :
        hexstr += hexes[field]
    print(hexstr)

    print(tohex( num, 8 ))
    print(tohex( num, 4 ))
    print(tohex( num, 3 ))

if __name__=='__main__' :
#    main()
    try : 
        num = int( sys.argv[1] )
    except ValueError :
        num = int( sys.argv[1], 16 )
    verbose_print( num )
#    print tobin( num )

